/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class SuicideOfStreamingTest
extends BaseJDBCTestCase {
    public SuicideOfStreamingTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table TEST_TABLE( TEST_COL blob( 65536 ))");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into TEST_TABLE (TEST_COL) values (?)");
        int n = 65536;
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n), n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        SuicideOfStreamingTest.setSystemProperty("derby.debug.suicideOfLayerBStreaming", "true");
    }

    @Override
    public void tearDown() throws Exception {
        SuicideOfStreamingTest.removeSystemProperty("derby.debug.suicideOfLayerBStreaming");
        super.tearDown();
    }

    public void testInterruptedReadOfLob() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select TEST_COL from TEST_TABLE");
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            int n;
            resultSet.next();
            InputStream inputStream = resultSet.getBinaryStream(1);
            while ((n = inputStream.read()) > -1) {
            }
            SuicideOfStreamingTest.fail((String)"Reading stream should have raised exception.");
        }
        catch (SQLException sQLException) {
            SuicideOfStreamingTest.assertSQLState("58009", sQLException);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public static Test suite() {
        return new BaseTestSuite("SuicideOfStreamingTest <DISABLED IN INSANE MODE>");
    }
}

