/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.quaternion;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.ToDoubleFunction;
import org.apache.commons.numbers.core.Precision;

public final class Quaternion
implements Serializable {
    public static final Quaternion ZERO = Quaternion.of(0.0, 0.0, 0.0, 0.0);
    public static final Quaternion ONE = new Quaternion(Type.POSITIVE_POLAR_FORM, 1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(Type.POSITIVE_POLAR_FORM, 0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(Type.POSITIVE_POLAR_FORM, 0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(Type.POSITIVE_POLAR_FORM, 0.0, 0.0, 0.0, 1.0);
    private static final long serialVersionUID = 20170118L;
    private static final String ILLEGAL_NORM_MSG = "Illegal norm: ";
    private static final String FORMAT_START = "[";
    private static final String FORMAT_END = "]";
    private static final String FORMAT_SEP = " ";
    private static final int VECTOR_DIMENSIONS = 3;
    private static final int NUMBER_OF_PARTS = 4;
    private final Type type;
    private final double w;
    private final double x;
    private final double y;
    private final double z;

    private Quaternion(Type type, double w, double x, double y, double z) {
        this.type = type;
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private Quaternion(Type type, Quaternion q) {
        this.type = type;
        this.w = q.w;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public static Quaternion of(double w, double x, double y, double z) {
        return new Quaternion(Type.DEFAULT, w, x, y, z);
    }

    public static Quaternion of(double scalar, double[] v) {
        if (v.length != 3) {
            throw new IllegalArgumentException("Size of array must be 3");
        }
        return Quaternion.of(scalar, v[0], v[1], v[2]);
    }

    public static Quaternion of(double[] v) {
        return Quaternion.of(0.0, v);
    }

    public Quaternion conjugate() {
        return Quaternion.of(this.w, -this.x, -this.y, -this.z);
    }

    public static Quaternion multiply(Quaternion q1, Quaternion q2) {
        double q1a = q1.w;
        double q1b = q1.x;
        double q1c = q1.y;
        double q1d = q1.z;
        double q2a = q2.w;
        double q2b = q2.x;
        double q2c = q2.y;
        double q2d = q2.z;
        double w = q1a * q2a - q1b * q2b - q1c * q2c - q1d * q2d;
        double x = q1a * q2b + q1b * q2a + q1c * q2d - q1d * q2c;
        double y = q1a * q2c - q1b * q2d + q1c * q2a + q1d * q2b;
        double z = q1a * q2d + q1b * q2c - q1c * q2b + q1d * q2a;
        return Quaternion.of(w, x, y, z);
    }

    public Quaternion multiply(Quaternion q) {
        return Quaternion.multiply(this, q);
    }

    public static Quaternion add(Quaternion q1, Quaternion q2) {
        return Quaternion.of(q1.w + q2.w, q1.x + q2.x, q1.y + q2.y, q1.z + q2.z);
    }

    public Quaternion add(Quaternion q) {
        return Quaternion.add(this, q);
    }

    public static Quaternion subtract(Quaternion q1, Quaternion q2) {
        return Quaternion.of(q1.w - q2.w, q1.x - q2.x, q1.y - q2.y, q1.z - q2.z);
    }

    public Quaternion subtract(Quaternion q) {
        return Quaternion.subtract(this, q);
    }

    public static double dot(Quaternion q1, Quaternion q2) {
        return q1.w * q2.w + q1.x * q2.x + q1.y * q2.y + q1.z * q2.z;
    }

    public double dot(Quaternion q) {
        return Quaternion.dot(this, q);
    }

    public double norm() {
        return this.type.norm(this);
    }

    public double normSq() {
        return this.type.normSq(this);
    }

    public Quaternion normalize() {
        switch (this.type) {
            case NORMALIZED: 
            case POSITIVE_POLAR_FORM: {
                return this;
            }
            case DEFAULT: {
                double norm = this.norm();
                if (norm < Double.MIN_NORMAL || !Double.isFinite(norm)) {
                    throw new IllegalStateException(ILLEGAL_NORM_MSG + norm);
                }
                Quaternion unit = this.divide(norm);
                return this.w >= 0.0 ? new Quaternion(Type.POSITIVE_POLAR_FORM, unit) : new Quaternion(Type.NORMALIZED, unit);
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Quaternion) {
            Quaternion q = (Quaternion)other;
            return Double.valueOf(this.w).equals(q.w) && Double.valueOf(this.x).equals(q.x) && Double.valueOf(this.y).equals(q.y) && Double.valueOf(this.z).equals(q.z);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new double[]{this.w, this.x, this.y, this.z});
    }

    public boolean equals(Quaternion q, double eps) {
        return Precision.equals((double)this.w, (double)q.w, (double)eps) && Precision.equals((double)this.x, (double)q.x, (double)eps) && Precision.equals((double)this.y, (double)q.y, (double)eps) && Precision.equals((double)this.z, (double)q.z, (double)eps);
    }

    public boolean isUnit(double eps) {
        return this.type.isUnit(this, eps);
    }

    public boolean isPure(double eps) {
        return Math.abs(this.w) <= eps;
    }

    public Quaternion positivePolarForm() {
        switch (this.type) {
            case POSITIVE_POLAR_FORM: {
                return this;
            }
            case NORMALIZED: {
                return this.w >= 0.0 ? new Quaternion(Type.POSITIVE_POLAR_FORM, this) : new Quaternion(Type.POSITIVE_POLAR_FORM, this.negate());
            }
            case DEFAULT: {
                return this.w >= 0.0 ? this.normalize() : this.negate().normalize();
            }
        }
        throw new IllegalStateException();
    }

    public Quaternion negate() {
        switch (this.type) {
            case NORMALIZED: 
            case POSITIVE_POLAR_FORM: {
                return new Quaternion(Type.NORMALIZED, -this.w, -this.x, -this.y, -this.z);
            }
            case DEFAULT: {
                return new Quaternion(Type.DEFAULT, -this.w, -this.x, -this.y, -this.z);
            }
        }
        throw new IllegalStateException();
    }

    public Quaternion inverse() {
        switch (this.type) {
            case NORMALIZED: 
            case POSITIVE_POLAR_FORM: {
                return new Quaternion(this.type, this.w, -this.x, -this.y, -this.z);
            }
            case DEFAULT: {
                double squareNorm = this.normSq();
                if (squareNorm < Double.MIN_NORMAL || !Double.isFinite(squareNorm)) {
                    throw new IllegalStateException(ILLEGAL_NORM_MSG + Math.sqrt(squareNorm));
                }
                return Quaternion.of(this.w / squareNorm, -this.x / squareNorm, -this.y / squareNorm, -this.z / squareNorm);
            }
        }
        throw new IllegalStateException();
    }

    public double getW() {
        return this.w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getScalarPart() {
        return this.getW();
    }

    public double[] getVectorPart() {
        return new double[]{this.x, this.y, this.z};
    }

    public Quaternion multiply(double alpha) {
        return Quaternion.of(alpha * this.w, alpha * this.x, alpha * this.y, alpha * this.z);
    }

    public Quaternion divide(double alpha) {
        return Quaternion.of(this.w / alpha, this.x / alpha, this.y / alpha, this.z / alpha);
    }

    public static Quaternion parse(String s) {
        double d;
        double c;
        double b;
        double a;
        int startBracket = s.indexOf(FORMAT_START);
        if (startBracket != 0) {
            throw new QuaternionParsingException("Expected start string: [");
        }
        int len = s.length();
        int endBracket = s.indexOf(FORMAT_END);
        if (endBracket != len - 1) {
            throw new QuaternionParsingException("Expected end string: ]");
        }
        String[] elements = s.substring(1, s.length() - 1).split(FORMAT_SEP);
        if (elements.length != 4) {
            throw new QuaternionParsingException("Incorrect number of parts: Expected 4 but was " + elements.length + " (separator is '" + FORMAT_SEP + "')");
        }
        try {
            a = Double.parseDouble(elements[0]);
        }
        catch (NumberFormatException ex) {
            throw new QuaternionParsingException("Could not parse scalar part" + elements[0], ex);
        }
        try {
            b = Double.parseDouble(elements[1]);
        }
        catch (NumberFormatException ex) {
            throw new QuaternionParsingException("Could not parse i part" + elements[1], ex);
        }
        try {
            c = Double.parseDouble(elements[2]);
        }
        catch (NumberFormatException ex) {
            throw new QuaternionParsingException("Could not parse j part" + elements[2], ex);
        }
        try {
            d = Double.parseDouble(elements[3]);
        }
        catch (NumberFormatException ex) {
            throw new QuaternionParsingException("Could not parse k part" + elements[3], ex);
        }
        return Quaternion.of(a, b, c, d);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(FORMAT_START).append(this.w).append(FORMAT_SEP).append(this.x).append(FORMAT_SEP).append(this.y).append(FORMAT_SEP).append(this.z).append(FORMAT_END);
        return s.toString();
    }

    private static class QuaternionParsingException
    extends NumberFormatException {
        private static final long serialVersionUID = 20181128L;

        QuaternionParsingException(String msg) {
            super(msg);
        }

        QuaternionParsingException(String msg, Throwable cause) {
            super(msg);
            this.initCause(cause);
        }
    }

    private static enum Type {
        DEFAULT(Default.NORMSQ, Default.access$000(), Default.access$100()),
        NORMALIZED(Normalized.NORM, Normalized.NORM, Normalized.IS_UNIT),
        POSITIVE_POLAR_FORM(Normalized.NORM, Normalized.NORM, Normalized.IS_UNIT);

        private final ToDoubleFunction<Quaternion> normSq;
        private final ToDoubleFunction<Quaternion> norm;
        private final BiPredicate<Quaternion, Double> testIsUnit;

        private Type(ToDoubleFunction<Quaternion> normSq, ToDoubleFunction<Quaternion> norm, BiPredicate<Quaternion, Double> isUnit) {
            this.normSq = normSq;
            this.norm = norm;
            this.testIsUnit = isUnit;
        }

        double normSq(Quaternion q) {
            return this.normSq.applyAsDouble(q);
        }

        double norm(Quaternion q) {
            return this.norm.applyAsDouble(q);
        }

        boolean isUnit(Quaternion q, double eps) {
            return this.testIsUnit.test(q, eps);
        }

        private static final class Normalized {
            static final ToDoubleFunction<Quaternion> NORM = q -> 1.0;
            static final BiPredicate<Quaternion, Double> IS_UNIT = (q, eps) -> true;

            private Normalized() {
            }
        }

        private static final class Default {
            static final ToDoubleFunction<Quaternion> NORMSQ = q -> ((Quaternion)q).w * ((Quaternion)q).w + ((Quaternion)q).x * ((Quaternion)q).x + ((Quaternion)q).y * ((Quaternion)q).y + ((Quaternion)q).z * ((Quaternion)q).z;
            private static final ToDoubleFunction<Quaternion> NORM = q -> Math.sqrt(NORMSQ.applyAsDouble((Quaternion)q));
            private static final BiPredicate<Quaternion, Double> IS_UNIT = (q, eps) -> Precision.equals((double)NORM.applyAsDouble((Quaternion)q), (double)1.0, (double)eps);

            private Default() {
            }

            static /* synthetic */ ToDoubleFunction access$000() {
                return NORM;
            }

            static /* synthetic */ BiPredicate access$100() {
                return IS_UNIT;
            }
        }
    }
}

