/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import java.util.Arrays;

public final class MultidimensionalCounter {
    private final int dimension;
    private final int[] uniCounterOffset;
    private final int[] size;
    private final int totalSize;
    private final int last;

    private MultidimensionalCounter(int ... size) {
        this.dimension = size.length;
        this.size = Arrays.copyOf(size, size.length);
        this.uniCounterOffset = new int[this.dimension];
        this.last = this.dimension - 1;
        this.uniCounterOffset[this.last] = 1;
        int tS = 1;
        for (int i = this.last - 1; i >= 0; --i) {
            int index = i + 1;
            MultidimensionalCounter.checkStrictlyPositive("index size", size[index]);
            MultidimensionalCounter.checkStrictlyPositive("cumulative size", tS *= size[index]);
            this.uniCounterOffset[i] = tS;
        }
        this.totalSize = tS * size[0];
        MultidimensionalCounter.checkStrictlyPositive("total size", this.totalSize);
    }

    public static MultidimensionalCounter of(int ... size) {
        return new MultidimensionalCounter(size);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] toMulti(int index) {
        if (index < 0 || index >= this.totalSize) {
            throw new IndexOutOfBoundsException(MultidimensionalCounter.createIndexOutOfBoundsMessage(this.totalSize, index));
        }
        int[] indices = new int[this.dimension];
        for (int i = 0; i < this.last; ++i) {
            indices[i] = index / this.uniCounterOffset[i];
            index -= indices[i] * this.uniCounterOffset[i];
        }
        indices[this.last] = index;
        return indices;
    }

    public int toUni(int ... c) {
        if (c.length != this.dimension) {
            throw new IllegalArgumentException("Wrong number of arguments: " + c.length + "(expected: " + this.dimension + ")");
        }
        int count = 0;
        for (int i = 0; i < this.dimension; ++i) {
            int index = c[i];
            if (index < 0 || index >= this.size[i]) {
                throw new IndexOutOfBoundsException(MultidimensionalCounter.createIndexOutOfBoundsMessage(this.size[i], index));
            }
            count += this.uniCounterOffset[i] * index;
        }
        return count;
    }

    public int getSize() {
        return this.totalSize;
    }

    public int[] getSizes() {
        return Arrays.copyOf(this.size, this.size.length);
    }

    public String toString() {
        return Arrays.toString(this.size);
    }

    private static void checkStrictlyPositive(String name, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Not positive " + name + ": " + size);
        }
    }

    private static String createIndexOutOfBoundsMessage(int size, int index) {
        return "Index out of bounds [0, " + (size - 1) + "]: " + index;
    }
}

