/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopWatchTest
extends AbstractLangTest {
    private static final Duration MILLIS_200 = Duration.ofMillis(200L);
    private static final Duration MILLIS_550 = Duration.ofMillis(550L);
    private static final String MESSAGE = "Baking cookies";
    private static final Duration MIN_SLEEP = Duration.ofMillis(20L);
    private static final String ZERO_HOURS_PREFIX = "00:";
    private static final String ZERO_TIME_ELAPSED = "00:00:00.000";

    private StopWatch createMockStopWatch(long nanos) {
        StopWatch watch = StopWatch.createStarted();
        watch.suspend();
        try {
            long currentNanos = System.nanoTime();
            FieldUtils.writeField((Object)watch, (String)"startTimeNanos", (Object)(currentNanos - nanos), (boolean)true);
            FieldUtils.writeField((Object)watch, (String)"stopTimeNanos", (Object)currentNanos, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return watch;
    }

    private void sleepQuietly(Duration duration) throws InterruptedException {
        ThreadUtils.sleep((Duration)duration);
    }

    @Test
    public void testBadStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).stop(), (String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).suspend(), (String)"Calling suspend on an unstarted StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).split(), (String)"Calling split on a non-running StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        watch.start();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a started StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getSplitTime(), (String)"Calling getSplitTime on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        watch.stop();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a stopped StopWatch should throw an exception as it needs to be reset. ");
    }

    @Test
    public void testBooleanStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
        watch.start();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.suspend();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.stop();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
    }

    @Test
    public void testFormatSplitTime() {
        StopWatch watch = StopWatch.createStarted();
        ThreadUtils.sleepQuietly((Duration)MIN_SLEEP);
        watch.split();
        String formatSplitTime = watch.formatSplitTime();
        Assertions.assertNotEquals((Object)ZERO_TIME_ELAPSED, (Object)formatSplitTime);
        Assertions.assertTrue((boolean)formatSplitTime.startsWith(ZERO_HOURS_PREFIX));
    }

    @Test
    public void testFormatSplitTimeWithMessage() {
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        ThreadUtils.sleepQuietly((Duration)MIN_SLEEP);
        watch.split();
        String formatSplitTime = watch.formatSplitTime();
        Assertions.assertFalse((boolean)formatSplitTime.startsWith(MESSAGE), (String)formatSplitTime);
        Assertions.assertTrue((boolean)formatSplitTime.startsWith(ZERO_HOURS_PREFIX));
    }

    @Test
    public void testFormatTime() {
        StopWatch watch = StopWatch.create();
        String formatTime = watch.formatTime();
        Assertions.assertEquals((Object)ZERO_TIME_ELAPSED, (Object)formatTime);
        Assertions.assertTrue((boolean)formatTime.startsWith(ZERO_HOURS_PREFIX));
    }

    @Test
    public void testFormatTimeWithMessage() {
        StopWatch watch = new StopWatch(MESSAGE);
        String formatTime = watch.formatTime();
        Assertions.assertFalse((boolean)formatTime.startsWith(MESSAGE), (String)formatTime);
    }

    @Test
    public void testGetStartTime() {
        long beforeStopWatchMillis = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on an unstarted StopWatch should throw an exception");
        watch.start();
        watch.getStartTime();
        Assertions.assertTrue((watch.getStartTime() >= beforeStopWatchMillis ? 1 : 0) != 0);
        watch.reset();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on a reset, but unstarted StopWatch should throw an exception");
    }

    @Test
    public void testLang315() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepQuietly(MILLIS_200);
        watch.suspend();
        long suspendTime = watch.getTime();
        this.sleepQuietly(MILLIS_200);
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertEquals((long)suspendTime, (long)totalTime);
    }

    @Test
    public void testMessage() {
        Assertions.assertNull((Object)StopWatch.create().getMessage());
        StopWatch stopWatch = new StopWatch(MESSAGE);
        Assertions.assertEquals((Object)MESSAGE, (Object)stopWatch.getMessage());
        Assertions.assertTrue((boolean)stopWatch.toString().startsWith(MESSAGE));
        stopWatch.start();
        stopWatch.split();
        Assertions.assertTrue((boolean)stopWatch.toSplitString().startsWith(MESSAGE));
    }

    @Test
    public void testStopTimeSimple() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        long testStartMillis = System.currentTimeMillis();
        this.sleepQuietly(MILLIS_550);
        watch.stop();
        long testEndMillis = System.currentTimeMillis();
        long stopTime = watch.getStopTime();
        Assertions.assertEquals((long)stopTime, (long)watch.getStopTime());
        Assertions.assertTrue((stopTime >= testStartMillis ? 1 : 0) != 0);
        Assertions.assertTrue((stopTime <= testEndMillis ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchGetWithTimeUnit() {
        StopWatch watch = this.createMockStopWatch(TimeUnit.HOURS.toNanos(2L) + TimeUnit.MINUTES.toNanos(59L) + TimeUnit.SECONDS.toNanos(1L) + TimeUnit.MILLISECONDS.toNanos(999L));
        Assertions.assertEquals((long)2L, (long)watch.getTime(TimeUnit.HOURS));
        Assertions.assertEquals((long)179L, (long)watch.getTime(TimeUnit.MINUTES));
        Assertions.assertEquals((long)10741L, (long)watch.getTime(TimeUnit.SECONDS));
        Assertions.assertEquals((long)10741999L, (long)watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Test
    public void testStopWatchSimple() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepQuietly(MILLIS_550);
        watch.stop();
        long time = watch.getTime();
        Assertions.assertEquals((long)time, (long)watch.getTime());
        Assertions.assertTrue((time >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((time < 700L ? 1 : 0) != 0);
        watch.reset();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
    }

    @Test
    public void testStopWatchSimpleGet() throws InterruptedException {
        StopWatch watch = new StopWatch();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
        Assertions.assertEquals((Object)ZERO_TIME_ELAPSED, (Object)watch.toString());
        watch.start();
        this.sleepQuietly(MILLIS_550);
        Assertions.assertTrue((watch.getTime() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchSplit() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepQuietly(MILLIS_550);
        watch.split();
        long splitTime = watch.getSplitTime();
        String splitStr = watch.toSplitString();
        this.sleepQuietly(MILLIS_550);
        watch.unsplit();
        this.sleepQuietly(MILLIS_550);
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertEquals((int)splitStr.length(), (int)12, (String)"Formatted split string not the correct length");
        Assertions.assertTrue((splitTime >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((splitTime < 700L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime < 1900L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchStatic() {
        StopWatch watch = StopWatch.createStarted();
        Assertions.assertTrue((boolean)watch.isStarted());
    }

    @Test
    public void testStopWatchSuspend() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        long testStartMillis = System.currentTimeMillis();
        this.sleepQuietly(MILLIS_550);
        watch.suspend();
        long testSuspendMillis = System.currentTimeMillis();
        long suspendTime = watch.getTime();
        long stopTime = watch.getStopTime();
        Assertions.assertTrue((testStartMillis <= stopTime ? 1 : 0) != 0);
        Assertions.assertTrue((testSuspendMillis <= stopTime ? 1 : 0) != 0);
        this.sleepQuietly(MILLIS_550);
        watch.resume();
        this.sleepQuietly(MILLIS_550);
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertTrue((suspendTime >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((suspendTime < 700L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime >= 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime < 1300L ? 1 : 0) != 0);
    }

    @Test
    public void testToSplitString() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepQuietly(MILLIS_550);
        watch.split();
        String splitStr = watch.toSplitString();
        Assertions.assertEquals((int)splitStr.length(), (int)12, (String)"Formatted split string not the correct length");
    }

    @Test
    public void testToSplitStringWithMessage() throws InterruptedException {
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        this.sleepQuietly(MILLIS_550);
        watch.split();
        String splitStr = watch.toSplitString();
        Assertions.assertEquals((int)splitStr.length(), (int)(12 + MESSAGE.length() + 1), (String)"Formatted split string not the correct length");
    }

    @Test
    public void testToString() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepQuietly(MILLIS_550);
        watch.split();
        String splitStr = watch.toString();
        Assertions.assertEquals((int)splitStr.length(), (int)12, (String)"Formatted split string not the correct length");
    }

    @Test
    public void testToStringWithMessage() throws InterruptedException {
        Assertions.assertTrue((boolean)new StopWatch(MESSAGE).toString().startsWith(MESSAGE));
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        this.sleepQuietly(MILLIS_550);
        watch.split();
        String splitStr = watch.toString();
        Assertions.assertEquals((int)splitStr.length(), (int)(12 + MESSAGE.length() + 1), (String)"Formatted split string not the correct length");
    }
}

