/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.GmtTimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GmtTimeZoneTest
extends AbstractLangTest {
    @Test
    public void getID() {
        Assertions.assertEquals((Object)"GMT+00:00", (Object)new GmtTimeZone(false, 0, 0).getID());
        Assertions.assertEquals((Object)"GMT+01:02", (Object)new GmtTimeZone(false, 1, 2).getID());
        Assertions.assertEquals((Object)"GMT+11:22", (Object)new GmtTimeZone(false, 11, 22).getID());
        Assertions.assertEquals((Object)"GMT-01:02", (Object)new GmtTimeZone(true, 1, 2).getID());
        Assertions.assertEquals((Object)"GMT-11:22", (Object)new GmtTimeZone(true, 11, 22).getID());
    }

    @Test
    public void getOffset() {
        Assertions.assertEquals((int)0, (int)new GmtTimeZone(false, 0, 0).getOffset(234304L));
    }

    @Test
    public void getRawOffset() {
        Assertions.assertEquals((int)0, (int)new GmtTimeZone(false, 0, 0).getRawOffset());
    }

    @Test
    public void hoursInRange() {
        Assertions.assertEquals((int)82800000, (int)new GmtTimeZone(false, 23, 0).getRawOffset());
    }

    @Test
    public void hoursOutOfRange() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GmtTimeZone(false, 24, 0));
    }

    @Test
    public void inDaylightTime() {
        Assertions.assertFalse((boolean)new GmtTimeZone(false, 0, 0).useDaylightTime());
    }

    @Test
    public void minutesInRange() {
        Assertions.assertEquals((int)3540000, (int)new GmtTimeZone(false, 0, 59).getRawOffset());
    }

    @Test
    public void minutesOutOfRange() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GmtTimeZone(false, 0, 60));
    }

    @Test
    public void setRawOffset() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new GmtTimeZone(false, 0, 0).setRawOffset(0));
    }

    @Test
    public void testGetOffset() {
        Assertions.assertEquals((int)-23400000, (int)new GmtTimeZone(true, 6, 30).getOffset(1, 1, 1, 1, 1, 1));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"[GmtTimeZone id=\"GMT-12:00\",offset=-43200000]", (Object)new GmtTimeZone(true, 12, 0).toString());
    }

    @Test
    public void useDaylightTime() {
        Assertions.assertFalse((boolean)new GmtTimeZone(false, 0, 0).useDaylightTime());
    }
}

