/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang3.stream.LangCollectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LangCollectorsTest {
    private static final Long _1L = 1L;
    private static final Long _2L = 2L;
    private static final Long _3L = 3L;
    private static final Function<Object, String> TO_STRING = Objects::toString;
    private static final Collector<Object, ?, String> JOINING_0 = LangCollectors.joining();
    private static final Collector<Object, ?, String> JOINING_1 = LangCollectors.joining((CharSequence)"-");
    private static final Collector<Object, ?, String> JOINING_3 = LangCollectors.joining((CharSequence)"-", (CharSequence)"<", (CharSequence)">");
    private static final Collector<Object, ?, String> JOINING_4 = LangCollectors.joining((CharSequence)"-", (CharSequence)"<", (CharSequence)">", TO_STRING);
    private static final Collector<Object, ?, String> JOINING_4_NUL = LangCollectors.joining((CharSequence)"-", (CharSequence)"<", (CharSequence)">", o -> Objects.toString(o, "NUL"));

    @Test
    public void testJoiningNonStrings0Arg() {
        Assertions.assertEquals((Object)"", (Object)Stream.of(new Object[0]).collect(JOINING_0));
        Assertions.assertEquals((Object)"1", (Object)Stream.of(_1L).collect(JOINING_0));
        Assertions.assertEquals((Object)"12", (Object)Stream.of(_1L, _2L).collect(JOINING_0));
        Assertions.assertEquals((Object)"123", (Object)Stream.of(_1L, _2L, _3L).collect(JOINING_0));
        Assertions.assertEquals((Object)"1null3", (Object)Stream.of(_1L, null, _3L).collect(JOINING_0));
        Assertions.assertEquals((Object)"12", (Object)Stream.of(new AtomicLong(1L), new AtomicLong(2L)).collect(JOINING_0));
        Assertions.assertEquals((Object)"12", (Object)Stream.of(new Fixture(1), new Fixture(2)).collect(JOINING_0));
    }

    @Test
    public void testJoiningNonStrings1Arg() {
        Assertions.assertEquals((Object)"", (Object)Stream.of(new Object[0]).collect(JOINING_1));
        Assertions.assertEquals((Object)"1", (Object)Stream.of(_1L).collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2", (Object)Stream.of(_1L, _2L).collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2-3", (Object)Stream.of(_1L, _2L, _3L).collect(JOINING_1));
        Assertions.assertEquals((Object)"1-null-3", (Object)Stream.of(_1L, null, _3L).collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2", (Object)Stream.of(new AtomicLong(1L), new AtomicLong(2L)).collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2", (Object)Stream.of(new Fixture(1), new Fixture(2)).collect(JOINING_1));
    }

    @Test
    public void testJoiningNonStrings3Args() {
        Assertions.assertEquals((Object)"<>", (Object)Stream.of(new Object[0]).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1>", (Object)Stream.of(_1L).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(_1L, _2L).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2-3>", (Object)Stream.of(_1L, _2L, _3L).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-null-3>", (Object)Stream.of(_1L, null, _3L).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(new AtomicLong(1L), new AtomicLong(2L)).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(new Fixture(1), new Fixture(2)).collect(JOINING_3));
    }

    @Test
    public void testJoiningNonStrings4Args() {
        Assertions.assertEquals((Object)"<>", (Object)Stream.of(new Object[0]).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1>", (Object)Stream.of(_1L).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(_1L, _2L).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-2-3>", (Object)Stream.of(_1L, _2L, _3L).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-null-3>", (Object)Stream.of(_1L, null, _3L).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-NUL-3>", (Object)Stream.of(_1L, null, _3L).collect(JOINING_4_NUL));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(new AtomicLong(1L), new AtomicLong(2L)).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of(new Fixture(1), new Fixture(2)).collect(JOINING_4));
    }

    @Test
    public void testJoiningStrings0Arg() {
        Assertions.assertEquals((Object)"", (Object)Stream.of(new Object[0]).collect(JOINING_0));
        Assertions.assertEquals((Object)"1", (Object)Stream.of("1").collect(JOINING_0));
        Assertions.assertEquals((Object)"12", (Object)Stream.of("1", "2").collect(JOINING_0));
        Assertions.assertEquals((Object)"123", (Object)Stream.of("1", "2", "3").collect(JOINING_0));
        Assertions.assertEquals((Object)"1null3", (Object)Stream.of("1", null, "3").collect(JOINING_0));
    }

    @Test
    public void testJoiningStrings1Arg() {
        Assertions.assertEquals((Object)"", (Object)Stream.of(new Object[0]).collect(JOINING_1));
        Assertions.assertEquals((Object)"1", (Object)Stream.of("1").collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2", (Object)Stream.of("1", "2").collect(JOINING_1));
        Assertions.assertEquals((Object)"1-2-3", (Object)Stream.of("1", "2", "3").collect(JOINING_1));
        Assertions.assertEquals((Object)"1-null-3", (Object)Stream.of("1", null, "3").collect(JOINING_1));
    }

    @Test
    public void testJoiningStrings3Args() {
        Assertions.assertEquals((Object)"<>", (Object)Stream.of(new Object[0]).collect(JOINING_3));
        Assertions.assertEquals((Object)"<1>", (Object)Stream.of("1").collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of("1", "2").collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-2-3>", (Object)Stream.of("1", "2", "3").collect(JOINING_3));
        Assertions.assertEquals((Object)"<1-null-3>", (Object)Stream.of("1", null, "3").collect(JOINING_3));
    }

    @Test
    public void testJoiningStrings4Args() {
        Assertions.assertEquals((Object)"<>", (Object)Stream.of(new Object[0]).collect(JOINING_4));
        Assertions.assertEquals((Object)"<1>", (Object)Stream.of("1").collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-2>", (Object)Stream.of("1", "2").collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-2-3>", (Object)Stream.of("1", "2", "3").collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-null-3>", (Object)Stream.of("1", null, "3").collect(JOINING_4));
        Assertions.assertEquals((Object)"<1-NUL-3>", (Object)Stream.of("1", null, "3").collect(JOINING_4_NUL));
    }

    private static class Fixture {
        int value;

        private Fixture(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

