/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.test.NotVisibleExceptionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ExceptionUtilsTest
extends AbstractLangTest {
    private ExceptionWithCause cyclicCause;
    private Throwable jdkNoCause;
    private NestableException nested;
    private Throwable notVisibleException;
    private Throwable withCause;
    private Throwable withoutCause;

    private static int redeclareCheckedException() {
        return ExceptionUtilsTest.throwsCheckedException();
    }

    private static int throwsCheckedException() {
        try {
            throw new IOException();
        }
        catch (Exception e) {
            return (Integer)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private Throwable createExceptionWithCause() {
        try {
            try {
                throw new ExceptionWithCause(this.createExceptionWithoutCause());
            }
            catch (Throwable t) {
                throw new ExceptionWithCause(t);
            }
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Throwable createExceptionWithoutCause() {
        try {
            throw new ExceptionWithoutCause();
        }
        catch (Throwable t) {
            return t;
        }
    }

    @BeforeEach
    public void setUp() {
        this.withoutCause = this.createExceptionWithoutCause();
        this.nested = new NestableException(this.withoutCause);
        this.withCause = new ExceptionWithCause(this.nested);
        this.jdkNoCause = new NullPointerException();
        ExceptionWithCause a = new ExceptionWithCause(null);
        ExceptionWithCause b = new ExceptionWithCause(a);
        a.setCause(b);
        this.cyclicCause = new ExceptionWithCause(a);
        this.notVisibleException = NotVisibleExceptionFactory.createException(this.withoutCause);
    }

    @AfterEach
    public void tearDown() {
        this.withoutCause = null;
        this.nested = null;
        this.withCause = null;
        this.jdkNoCause = null;
        this.cyclicCause = null;
        this.notVisibleException = null;
    }

    @Test
    public void test_getMessage_Throwable() {
        Exception th = null;
        Assertions.assertEquals((Object)"", (Object)ExceptionUtils.getMessage(th));
        th = new IllegalArgumentException("Base");
        Assertions.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        Assertions.assertEquals((Object)"ExceptionUtilsTest.ExceptionWithCause: Wrapper", (Object)ExceptionUtils.getMessage((Throwable)th));
    }

    @Test
    public void test_getRootCauseMessage_Throwable() {
        Exception th = null;
        Assertions.assertEquals((Object)"", (Object)ExceptionUtils.getRootCauseMessage(th));
        th = new IllegalArgumentException("Base");
        Assertions.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        Assertions.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
    }

    @Test
    public void testCatchTechniques() {
        IOException ioe = (IOException)Assertions.assertThrows(IOException.class, ExceptionUtilsTest::throwsCheckedException);
        Assertions.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)ioe));
        ioe = (IOException)Assertions.assertThrows(IOException.class, ExceptionUtilsTest::redeclareCheckedException);
        Assertions.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)ioe));
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new ExceptionUtils());
        Constructor<?>[] cons = ExceptionUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ExceptionUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ExceptionUtils.class.getModifiers()));
    }

    @Test
    public void testForEach_jdkNoCause() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach((Throwable)this.jdkNoCause, throwables::add);
        Assertions.assertEquals((int)1, (int)throwables.size());
        Assertions.assertSame((Object)this.jdkNoCause, throwables.get(0));
    }

    @Test
    public void testForEach_nested() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach((Throwable)this.nested, throwables::add);
        Assertions.assertEquals((int)2, (int)throwables.size());
        Assertions.assertSame((Object)this.nested, throwables.get(0));
        Assertions.assertSame((Object)this.withoutCause, throwables.get(1));
    }

    @Test
    public void testForEach_null() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach(null, throwables::add);
        Assertions.assertEquals((int)0, (int)throwables.size());
    }

    @Test
    public void testForEach_recursiveCause() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach((Throwable)this.cyclicCause, throwables::add);
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.cyclicCause, throwables.get(0));
        Assertions.assertSame((Object)this.cyclicCause.getCause(), throwables.get(1));
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), throwables.get(2));
    }

    @Test
    public void testForEach_withCause() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach((Throwable)this.withCause, throwables::add);
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.withCause, throwables.get(0));
        Assertions.assertSame((Object)this.nested, throwables.get(1));
        Assertions.assertSame((Object)this.withoutCause, throwables.get(2));
    }

    @Test
    public void testForEach_withoutCause() {
        ArrayList throwables = new ArrayList();
        ExceptionUtils.forEach((Throwable)this.withoutCause, throwables::add);
        Assertions.assertEquals((int)1, (int)throwables.size());
        Assertions.assertSame((Object)this.withoutCause, throwables.get(0));
    }

    @Test
    public void testGetCause_Throwable() {
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause(null));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause));
        Assertions.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getCause((Throwable)this.nested));
        Assertions.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.jdkNoCause));
        Assertions.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause));
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause.getCause()));
        Assertions.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause.getCause().getCause()));
        Assertions.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getCause((Throwable)this.notVisibleException));
    }

    @Test
    public void testGetCause_ThrowableArray() {
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause(null, null));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause(null, (String[])new String[0]));
        Assertions.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, null));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[0]));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{null}));
        Assertions.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{"getCause"}));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, null));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[0]));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{null}));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getCause"}));
        Assertions.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getTargetException"}));
    }

    @Test
    public void testGetRootCause_Throwable() {
        Assertions.assertSame(null, (Object)ExceptionUtils.getRootCause(null));
        Assertions.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.withoutCause));
        Assertions.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.nested));
        Assertions.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.withCause));
        Assertions.assertSame((Object)this.jdkNoCause, (Object)ExceptionUtils.getRootCause((Throwable)this.jdkNoCause));
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), (Object)ExceptionUtils.getRootCause((Throwable)this.cyclicCause));
    }

    @Test
    public void testGetRootCauseStackTrace_Throwable() {
        Assertions.assertEquals((int)0, (int)ExceptionUtils.getRootCauseStackTrace(null).length);
        Throwable cause = this.createExceptionWithCause();
        String[] stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)cause);
        boolean match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assertions.assertTrue((boolean)match);
        stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)this.withoutCause);
        match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assertions.assertFalse((boolean)match);
    }

    @Test
    public void testGetRootCauseStackTraceList_Throwable() {
        Assertions.assertEquals((int)0, (int)ExceptionUtils.getRootCauseStackTraceList(null).size());
        Throwable cause = this.createExceptionWithCause();
        List stackTrace = ExceptionUtils.getRootCauseStackTraceList((Throwable)cause);
        boolean match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assertions.assertTrue((boolean)match);
        stackTrace = ExceptionUtils.getRootCauseStackTraceList((Throwable)this.withoutCause);
        match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assertions.assertFalse((boolean)match);
    }

    @Test
    @DisplayName(value="getStackFrames returns empty string array when the argument is null")
    public void testgetStackFramesHappyPath() {
        Object[] actual = ExceptionUtils.getStackFrames((Throwable)new Throwable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void printStackTrace(PrintWriter s) {
                s.write("org.apache.commons.lang3.exception.ExceptionUtilsTest$1\n\tat org.apache.commons.lang3.exception.ExceptionUtilsTest.testgetStackFramesGappyPath(ExceptionUtilsTest.java:706)\n\tat java.base/jdk.internal.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\n\tat com.intellij.rt.junit.JUnitStarter.prepareStreamsAndStart(JUnitStarter.java:230)\n\tat com.intellij.rt.junit.JUnitStarter.main(JUnitStarter.java:58)\n");
            }
        });
        Assertions.assertArrayEquals((Object[])new String[]{"org.apache.commons.lang3.exception.ExceptionUtilsTest$1", "\tat org.apache.commons.lang3.exception.ExceptionUtilsTest.testgetStackFramesGappyPath(ExceptionUtilsTest.java:706)", "\tat java.base/jdk.internal.reflect.NativeMethodAccessorImpl.invoke0(Native Method)", "\tat com.intellij.rt.junit.JUnitStarter.prepareStreamsAndStart(JUnitStarter.java:230)", "\tat com.intellij.rt.junit.JUnitStarter.main(JUnitStarter.java:58)"}, (Object[])actual);
    }

    @Test
    @DisplayName(value="getStackFrames returns the string array of the stack frames when there is a real exception")
    public void testgetStackFramesNullArg() {
        String[] actual = ExceptionUtils.getStackFrames((Throwable)null);
        Assertions.assertEquals((int)0, (int)actual.length);
    }

    @Test
    public void testGetThrowableCount_Throwable() {
        Assertions.assertEquals((int)0, (int)ExceptionUtils.getThrowableCount(null));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)this.withoutCause));
        Assertions.assertEquals((int)2, (int)ExceptionUtils.getThrowableCount((Throwable)this.nested));
        Assertions.assertEquals((int)3, (int)ExceptionUtils.getThrowableCount((Throwable)this.withCause));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)this.jdkNoCause));
        Assertions.assertEquals((int)3, (int)ExceptionUtils.getThrowableCount((Throwable)this.cyclicCause));
    }

    @Test
    public void testGetThrowableList_Throwable_jdkNoCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.jdkNoCause);
        Assertions.assertEquals((int)1, (int)throwables.size());
        Assertions.assertSame((Object)this.jdkNoCause, throwables.get(0));
    }

    @Test
    public void testGetThrowableList_Throwable_nested() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.nested);
        Assertions.assertEquals((int)2, (int)throwables.size());
        Assertions.assertSame((Object)this.nested, throwables.get(0));
        Assertions.assertSame((Object)this.withoutCause, throwables.get(1));
    }

    @Test
    public void testGetThrowableList_Throwable_null() {
        List throwables = ExceptionUtils.getThrowableList(null);
        Assertions.assertEquals((int)0, (int)throwables.size());
    }

    @Test
    public void testGetThrowableList_Throwable_recursiveCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.cyclicCause);
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.cyclicCause, throwables.get(0));
        Assertions.assertSame((Object)this.cyclicCause.getCause(), throwables.get(1));
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), throwables.get(2));
    }

    @Test
    public void testGetThrowableList_Throwable_withCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withCause);
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.withCause, throwables.get(0));
        Assertions.assertSame((Object)this.nested, throwables.get(1));
        Assertions.assertSame((Object)this.withoutCause, throwables.get(2));
    }

    @Test
    public void testGetThrowableList_Throwable_withoutCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withoutCause);
        Assertions.assertEquals((int)1, (int)throwables.size());
        Assertions.assertSame((Object)this.withoutCause, throwables.get(0));
    }

    @Test
    public void testGetThrowables_Throwable_jdkNoCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.jdkNoCause);
        Assertions.assertEquals((int)1, (int)throwables.length);
        Assertions.assertSame((Object)this.jdkNoCause, (Object)throwables[0]);
    }

    @Test
    public void testGetThrowables_Throwable_nested() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.nested);
        Assertions.assertEquals((int)2, (int)throwables.length);
        Assertions.assertSame((Object)this.nested, (Object)throwables[0]);
        Assertions.assertSame((Object)this.withoutCause, (Object)throwables[1]);
    }

    @Test
    public void testGetThrowables_Throwable_null() {
        Assertions.assertEquals((int)0, (int)ExceptionUtils.getThrowables(null).length);
    }

    @Test
    public void testGetThrowables_Throwable_recursiveCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.cyclicCause);
        Assertions.assertEquals((int)3, (int)throwables.length);
        Assertions.assertSame((Object)this.cyclicCause, (Object)throwables[0]);
        Assertions.assertSame((Object)this.cyclicCause.getCause(), (Object)throwables[1]);
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), (Object)throwables[2]);
    }

    @Test
    public void testGetThrowables_Throwable_withCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withCause);
        Assertions.assertEquals((int)3, (int)throwables.length);
        Assertions.assertSame((Object)this.withCause, (Object)throwables[0]);
        Assertions.assertSame((Object)this.nested, (Object)throwables[1]);
        Assertions.assertSame((Object)this.withoutCause, (Object)throwables[2]);
    }

    @Test
    public void testGetThrowables_Throwable_withoutCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withoutCause);
        Assertions.assertEquals((int)1, (int)throwables.length);
        Assertions.assertSame((Object)this.withoutCause, (Object)throwables[0]);
    }

    @Test
    public void testIndexOf_ThrowableClass() {
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, NestableException.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class));
        Assertions.assertEquals((int)2, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Throwable.class));
    }

    @Test
    public void testIndexOf_ThrowableClassInt() {
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, NestableException.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class, (int)0));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class, (int)0));
        Assertions.assertEquals((int)2, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Throwable.class, (int)0));
    }

    @Test
    public void testIndexOfType_ThrowableClass() {
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, NestableException.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class));
        Assertions.assertEquals((int)2, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Throwable.class));
    }

    @Test
    public void testIndexOfType_ThrowableClassInt() {
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, NestableException.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, null, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class, (int)0));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class, (int)0));
        Assertions.assertEquals((int)2, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class, (int)0));
        Assertions.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Throwable.class, (int)0));
    }

    @Test
    public void testIsChecked_checked() {
        Assertions.assertTrue((boolean)ExceptionUtils.isChecked((Throwable)new IOException()));
    }

    @Test
    public void testIsChecked_error() {
        Assertions.assertFalse((boolean)ExceptionUtils.isChecked((Throwable)new StackOverflowError()));
    }

    @Test
    public void testIsChecked_null() {
        Assertions.assertFalse((boolean)ExceptionUtils.isChecked(null));
    }

    @Test
    public void testIsChecked_unchecked() {
        Assertions.assertFalse((boolean)ExceptionUtils.isChecked((Throwable)new IllegalArgumentException()));
    }

    @Test
    public void testIsCheckedCustomThrowable() {
        Assertions.assertTrue((boolean)ExceptionUtils.isChecked((Throwable)new TestThrowable()));
    }

    @Test
    public void testIsUnchecked_null() {
        Assertions.assertFalse((boolean)ExceptionUtils.isUnchecked(null));
    }

    @Test
    public void testIsUnchecked_checked() {
        Assertions.assertFalse((boolean)ExceptionUtils.isUnchecked((Throwable)new IOException()));
    }

    @Test
    public void testIsUnchecked_error() {
        Assertions.assertTrue((boolean)ExceptionUtils.isUnchecked((Throwable)new StackOverflowError()));
    }

    @Test
    public void testIsUnchecked_unchecked() {
        Assertions.assertTrue((boolean)ExceptionUtils.isUnchecked((Throwable)new IllegalArgumentException()));
    }

    @Test
    public void testIsUnCheckedCustomThrowable() {
        Assertions.assertFalse((boolean)ExceptionUtils.isUnchecked((Throwable)new TestThrowable()));
    }

    @Test
    public void testPrintRootCauseStackTrace_Throwable() {
        ExceptionUtils.printRootCauseStackTrace(null);
    }

    @Test
    public void testPrintRootCauseStackTrace_ThrowableStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)new PrintStream(out));
        Assertions.assertEquals((int)0, (int)out.toString().length());
        out = new ByteArrayOutputStream(1024);
        Assertions.assertThrows(NullPointerException.class, () -> ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintStream)null));
        out = new ByteArrayOutputStream(1024);
        Throwable cause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)cause, (PrintStream)new PrintStream(out));
        String stackTrace = out.toString();
        Assertions.assertTrue((boolean)stackTrace.contains(" [wrapped] "));
        out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintStream)new PrintStream(out));
        stackTrace = out.toString();
        Assertions.assertFalse((boolean)stackTrace.contains(" [wrapped] "));
    }

    @Test
    public void testPrintRootCauseStackTrace_ThrowableWriter() {
        StringWriter writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)new PrintWriter(writer));
        Assertions.assertEquals((int)0, (int)writer.getBuffer().length());
        writer = new StringWriter(1024);
        Assertions.assertThrows(NullPointerException.class, () -> ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintWriter)null));
        writer = new StringWriter(1024);
        Throwable cause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)cause, (PrintWriter)new PrintWriter(writer));
        String stackTrace = writer.toString();
        Assertions.assertTrue((boolean)stackTrace.contains(" [wrapped] "));
        writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintWriter)new PrintWriter(writer));
        stackTrace = writer.toString();
        Assertions.assertFalse((boolean)stackTrace.contains(" [wrapped] "));
    }

    @Test
    public void testRemoveCommonFrames_ListList() {
        Assertions.assertThrows(NullPointerException.class, () -> ExceptionUtils.removeCommonFrames(null, null));
    }

    @Test
    public void testStream_jdkNoCause() {
        Assertions.assertEquals((long)1L, (long)ExceptionUtils.stream((Throwable)this.jdkNoCause).count());
        Assertions.assertSame((Object)this.jdkNoCause, (Object)ExceptionUtils.stream((Throwable)this.jdkNoCause).toArray()[0]);
    }

    @Test
    public void testStream_nested() {
        Assertions.assertEquals((long)2L, (long)ExceptionUtils.stream((Throwable)this.nested).count());
        Object[] array = ExceptionUtils.stream((Throwable)this.nested).toArray();
        Assertions.assertSame((Object)this.nested, (Object)array[0]);
        Assertions.assertSame((Object)this.withoutCause, (Object)array[1]);
    }

    @Test
    public void testStream_null() {
        Assertions.assertEquals((long)0L, (long)ExceptionUtils.stream(null).count());
    }

    @Test
    public void testStream_recursiveCause() {
        List throwables = ExceptionUtils.stream((Throwable)this.cyclicCause).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.cyclicCause, throwables.get(0));
        Assertions.assertSame((Object)this.cyclicCause.getCause(), throwables.get(1));
        Assertions.assertSame((Object)this.cyclicCause.getCause().getCause(), throwables.get(2));
    }

    @Test
    public void testStream_withCause() {
        List throwables = ExceptionUtils.stream((Throwable)this.withCause).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)throwables.size());
        Assertions.assertSame((Object)this.withCause, throwables.get(0));
        Assertions.assertSame((Object)this.nested, throwables.get(1));
        Assertions.assertSame((Object)this.withoutCause, throwables.get(2));
    }

    @Test
    public void testStream_withoutCause() {
        List throwables = ExceptionUtils.stream((Throwable)this.withoutCause).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)throwables.size());
        Assertions.assertSame((Object)this.withoutCause, throwables.get(0));
    }

    @Test
    public void testThrow() {
        InterruptedException expected = new InterruptedException();
        Exception actual = (Exception)Assertions.assertThrows(Exception.class, () -> ExceptionUtils.rethrow((Throwable)expected));
        Assertions.assertSame((Object)expected, (Object)actual);
    }

    @Test
    public void testThrowableOf_ThrowableClass() {
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable(null, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable(null, NestableException.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, NestableException.class));
        Assertions.assertEquals((Object)this.withoutCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, ExceptionWithCause.class));
        Assertions.assertEquals((Object)this.nested, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, NestableException.class));
        Assertions.assertEquals((Object)this.nested.getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, null));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class));
        Assertions.assertEquals((Object)this.withCause.getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, NestableException.class));
        Assertions.assertEquals((Object)this.withCause.getCause().getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, Exception.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, Throwable.class));
    }

    @Test
    public void testThrowableOf_ThrowableClassInt() {
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable(null, null, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable(null, NestableException.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.withoutCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, null, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((Object)this.nested, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.nested.getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, null));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((Object)this.withCause.getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.withCause.getCause().getCause(), (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, Exception.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfThrowable((Throwable)this.withCause, Throwable.class, (int)0));
    }

    @Test
    public void testThrowableOfType_ThrowableClass() {
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType(null, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType(null, NestableException.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, NestableException.class));
        Assertions.assertEquals((Object)this.withoutCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.nested, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.nested, ExceptionWithCause.class));
        Assertions.assertEquals((Object)this.nested, (Object)ExceptionUtils.throwableOfType((Throwable)this.nested, NestableException.class));
        Assertions.assertEquals((Object)this.nested.getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.nested, ExceptionWithoutCause.class));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, null));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class));
        Assertions.assertEquals((Object)this.withCause.getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, NestableException.class));
        Assertions.assertEquals((Object)this.withCause.getCause().getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, Exception.class));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, Throwable.class));
    }

    @Test
    public void testThrowableOfType_ThrowableClassInt() {
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType(null, null, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType(null, NestableException.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, null));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.withoutCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.nested, null, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((Object)this.nested, (Object)ExceptionUtils.throwableOfType((Throwable)this.nested, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.nested.getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, null));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertEquals((Object)this.withCause.getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, NestableException.class, (int)0));
        Assertions.assertEquals((Object)this.withCause.getCause().getCause(), (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assertions.assertNull((Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, Exception.class, (int)0));
        Assertions.assertEquals((Object)this.withCause, (Object)ExceptionUtils.throwableOfType((Throwable)this.withCause, Throwable.class, (int)0));
    }

    @Test
    public void testWrapAndUnwrapCheckedException() {
        Throwable t = Assertions.assertThrows(Throwable.class, () -> ExceptionUtils.wrapAndThrow((Throwable)new IOException()));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, IOException.class));
    }

    @Test
    public void testWrapAndUnwrapError() {
        Throwable t = Assertions.assertThrows(Throwable.class, () -> ExceptionUtils.wrapAndThrow((Throwable)new OutOfMemoryError()));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, Error.class));
    }

    @Test
    public void testWrapAndUnwrapRuntimeException() {
        Throwable t = Assertions.assertThrows(Throwable.class, () -> ExceptionUtils.wrapAndThrow((Throwable)new IllegalArgumentException()));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, RuntimeException.class));
    }

    @Test
    public void testWrapAndUnwrapThrowable() {
        Throwable t = Assertions.assertThrows(Throwable.class, () -> ExceptionUtils.wrapAndThrow((Throwable)new TestThrowable()));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, TestThrowable.class));
    }

    public static class TestThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;
    }

    private static class NestableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NestableException() {
        }

        NestableException(Throwable t) {
            super(t);
        }
    }

    private static class ExceptionWithoutCause
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ExceptionWithoutCause() {
        }

        public void getTargetException() {
        }
    }

    private static class ExceptionWithCause
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Throwable cause;

        ExceptionWithCause(String str, Throwable cause) {
            super(str);
            this.setCause(cause);
        }

        ExceptionWithCause(Throwable cause) {
            this.setCause(cause);
        }

        @Override
        public synchronized Throwable getCause() {
            return this.cause;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }
    }
}

