/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractExceptionContextTest<T extends ExceptionContext & Serializable>
extends AbstractLangTest {
    protected static final String TEST_MESSAGE_2 = "This is monotonous";
    protected static final String TEST_MESSAGE = "Test Message";
    protected T exceptionContext;

    @BeforeEach
    public void setUp() throws Exception {
        this.exceptionContext.addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new ObjectWithFaultyToString());
    }

    @Test
    public void testAddContextValue() {
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        Assertions.assertTrue((boolean)message.contains(TEST_MESSAGE));
        Assertions.assertTrue((boolean)message.contains("test1"));
        Assertions.assertTrue((boolean)message.contains("test2"));
        Assertions.assertTrue((boolean)message.contains("test Date"));
        Assertions.assertTrue((boolean)message.contains("test Nbr"));
        Assertions.assertTrue((boolean)message.contains("some value"));
        Assertions.assertTrue((boolean)message.contains("5"));
        Assertions.assertNull((Object)this.exceptionContext.getFirstContextValue("test1"));
        Assertions.assertEquals((Object)"some value", (Object)this.exceptionContext.getFirstContextValue("test2"));
        Assertions.assertEquals((int)5, (int)this.exceptionContext.getContextLabels().size());
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test1"));
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Date"));
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Nbr"));
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assertions.assertEquals((int)5, (int)this.exceptionContext.getContextLabels().size());
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        Assertions.assertFalse((boolean)contextMessage.contains(TEST_MESSAGE));
    }

    @Test
    public void testSetContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        this.exceptionContext.setContextValue("test3", (Object)"3");
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        Assertions.assertTrue((boolean)message.contains(TEST_MESSAGE));
        Assertions.assertTrue((boolean)message.contains("test Poorly written obj"));
        Assertions.assertTrue((boolean)message.contains("Crap"));
        Assertions.assertNull((Object)this.exceptionContext.getFirstContextValue("crap"));
        Assertions.assertTrue((boolean)(this.exceptionContext.getFirstContextValue("test Poorly written obj") instanceof ObjectWithFaultyToString));
        Assertions.assertEquals((int)7, (int)this.exceptionContext.getContextEntries().size());
        Assertions.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        Assertions.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Poorly written obj"));
        Assertions.assertFalse((boolean)this.exceptionContext.getContextLabels().contains("crap"));
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"replacement");
        Assertions.assertEquals((int)7, (int)this.exceptionContext.getContextEntries().size());
        Assertions.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assertions.assertEquals((int)6, (int)this.exceptionContext.getContextEntries().size());
        Assertions.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        Assertions.assertFalse((boolean)contextMessage.contains(TEST_MESSAGE));
    }

    @Test
    public void testGetFirstContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assertions.assertNull((Object)this.exceptionContext.getFirstContextValue("test1"));
        Assertions.assertEquals((Object)"some value", (Object)this.exceptionContext.getFirstContextValue("test2"));
        Assertions.assertNull((Object)this.exceptionContext.getFirstContextValue("crap"));
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assertions.assertEquals((Object)"another", (Object)this.exceptionContext.getFirstContextValue("test2"));
    }

    @Test
    public void testGetContextValues() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assertions.assertEquals(Collections.singletonList(null), (Object)this.exceptionContext.getContextValues("test1"));
        Assertions.assertEquals(Arrays.asList("some value", "different value"), (Object)this.exceptionContext.getContextValues("test2"));
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assertions.assertEquals((Object)"another", (Object)this.exceptionContext.getFirstContextValue("test2"));
    }

    @Test
    public void testGetContextLabels() {
        Assertions.assertEquals((int)5, (int)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Set labels = this.exceptionContext.getContextLabels();
        Assertions.assertEquals((int)6, (int)this.exceptionContext.getContextEntries().size());
        Assertions.assertEquals((int)5, (int)labels.size());
        Assertions.assertTrue((boolean)labels.contains("test1"));
        Assertions.assertTrue((boolean)labels.contains("test2"));
        Assertions.assertTrue((boolean)labels.contains("test Date"));
        Assertions.assertTrue((boolean)labels.contains("test Nbr"));
    }

    @Test
    public void testGetContextEntries() {
        Assertions.assertEquals((int)5, (int)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        List entries = this.exceptionContext.getContextEntries();
        Assertions.assertEquals((int)6, (int)entries.size());
        Assertions.assertEquals((Object)"test1", (Object)((Pair)entries.get(0)).getKey());
        Assertions.assertEquals((Object)"test2", (Object)((Pair)entries.get(1)).getKey());
        Assertions.assertEquals((Object)"test Date", (Object)((Pair)entries.get(2)).getKey());
        Assertions.assertEquals((Object)"test Nbr", (Object)((Pair)entries.get(3)).getKey());
        Assertions.assertEquals((Object)"test Poorly written obj", (Object)((Pair)entries.get(4)).getKey());
        Assertions.assertEquals((Object)"test2", (Object)((Pair)entries.get(5)).getKey());
    }

    @Test
    public void testJavaSerialization() {
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"serializable replacement");
        ExceptionContext clone = (ExceptionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)this.exceptionContext)));
        Assertions.assertEquals((Object)this.exceptionContext.getFormattedExceptionMessage(null), (Object)clone.getFormattedExceptionMessage(null));
    }

    protected static class ObjectWithFaultyToString {
        protected ObjectWithFaultyToString() {
        }

        public String toString() {
            throw new RuntimeException("Crap");
        }
    }
}

