/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.AbstractFutureProxy;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.lang3.concurrent.UncheckedExecutionException;
import org.apache.commons.lang3.concurrent.UncheckedFuture;
import org.apache.commons.lang3.concurrent.UncheckedTimeoutException;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UncheckedFutureTest
extends AbstractLangTest {
    @Test
    public void testGetExecutionException() {
        ExecutionException e = new ExecutionException(new Exception());
        Assertions.assertThrows(UncheckedExecutionException.class, () -> UncheckedFuture.on(new TestFuture(e)).get());
    }

    @Test
    public void testGetInterruptedException() {
        InterruptedException e = new InterruptedException();
        Assertions.assertThrows(UncheckedInterruptedException.class, () -> UncheckedFuture.on(new TestFuture(e)).get());
    }

    @Test
    public void testGetLongExecutionException() {
        ExecutionException e = new ExecutionException(new Exception());
        Assertions.assertThrows(UncheckedExecutionException.class, () -> UncheckedFuture.on(new TestFuture(e)).get(1L, TimeUnit.MICROSECONDS));
    }

    @Test
    public void testGetLongInterruptedException() {
        InterruptedException e = new InterruptedException();
        Assertions.assertThrows(UncheckedInterruptedException.class, () -> UncheckedFuture.on(new TestFuture(e)).get(1L, TimeUnit.MICROSECONDS));
    }

    @Test
    public void testGetLongTimeoutException() {
        TimeoutException e = new TimeoutException();
        Assertions.assertThrows(UncheckedTimeoutException.class, () -> UncheckedFuture.on(new TestFuture(e)).get(1L, TimeUnit.MICROSECONDS));
    }

    @Test
    public void testMap() {
        List<String> expected = Arrays.asList("Y", "Z");
        List<Future> input = Arrays.asList(new Future[]{new TestFuture<String>("Y"), new TestFuture<String>("Z")});
        Assertions.assertEquals(expected, UncheckedFuture.map(input).map(UncheckedFuture::get).collect(Collectors.toList()));
    }

    @Test
    public void testOnCollection() {
        List<String> expected = Arrays.asList("Y", "Z");
        List<Future> input = Arrays.asList(new Future[]{new TestFuture<String>("Y"), new TestFuture<String>("Z")});
        Assertions.assertEquals(expected, UncheckedFuture.on(input).stream().map(UncheckedFuture::get).collect(Collectors.toList()));
    }

    @Test
    public void testOnFuture() {
        Assertions.assertEquals((Object)"Z", (Object)UncheckedFuture.on(new TestFuture<String>("Z")).get());
    }

    private static class TestFuture<V>
    extends AbstractFutureProxy<V> {
        private final Exception exception;

        TestFuture(Exception throwable) {
            super(ConcurrentUtils.constantFuture(null));
            this.exception = throwable;
        }

        TestFuture(V value) {
            super(ConcurrentUtils.constantFuture(value));
            this.exception = null;
        }

        private <T extends Exception> void checkException() throws T {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public V get() throws InterruptedException, ExecutionException {
            this.checkException();
            return (V)super.get();
        }

        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.checkException();
            return (V)super.get(timeout, unit);
        }
    }
}

