/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractConcurrentInitializerTest
extends AbstractLangTest {
    @Test
    public void testGet() throws ConcurrentException {
        Assertions.assertNotNull((Object)this.createInitializer().get(), (String)"No managed object");
    }

    @Test
    public void testGetMultipleTimes() throws ConcurrentException {
        ConcurrentInitializer<Object> initializer = this.createInitializer();
        Object obj = initializer.get();
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)obj, (Object)initializer.get(), (String)("Got different object at " + i));
        }
    }

    @Test
    public void testGetConcurrent() throws ConcurrentException, InterruptedException {
        final ConcurrentInitializer<Object> initializer = this.createInitializer();
        int threadCount = 20;
        final CountDownLatch startLatch = new CountDownLatch(1);
        class GetThread
        extends Thread {
            Object object;

            GetThread() {
            }

            @Override
            public void run() {
                try {
                    startLatch.await();
                    this.object = initializer.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ConcurrentException cex) {
                    this.object = cex;
                }
            }
        }
        GetThread[] threads = new GetThread[20];
        for (int i = 0; i < 20; ++i) {
            threads[i] = new GetThread();
            threads[i].start();
        }
        startLatch.countDown();
        for (GetThread t : threads) {
            t.join();
        }
        Object managedObject = initializer.get();
        for (GetThread t : threads) {
            Assertions.assertEquals((Object)managedObject, (Object)t.object, (String)"Wrong object");
        }
    }

    protected abstract ConcurrentInitializer<Object> createInitializer();
}

