/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.math.BigDecimal;
import java.time.Instant;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.compare.ComparableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=DisplayNameGenerator.ReplaceUnderscores.class)
public class ComparableUtilsTest
extends AbstractLangTest {
    @Test
    public void testMax() {
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.max((Comparable)Instant.MAX, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MIN, (Object)ComparableUtils.max((Comparable)Instant.MIN, (Comparable)Instant.MIN));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.max((Comparable)Instant.MIN, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.max((Comparable)Instant.MAX, (Comparable)Instant.MIN));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (Integer)((Integer)ComparableUtils.max((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MIN_VALUE))));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)((Integer)ComparableUtils.max((Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE))));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)((Integer)ComparableUtils.max((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE))));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)((Integer)ComparableUtils.max((Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(Integer.MIN_VALUE))));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.max(null, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.max((Comparable)Instant.MAX, null));
    }

    @Test
    public void testMin() {
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.min((Comparable)Instant.MAX, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MIN, (Object)ComparableUtils.min((Comparable)Instant.MIN, (Comparable)Instant.MIN));
        Assertions.assertEquals((Object)Instant.MIN, (Object)ComparableUtils.min((Comparable)Instant.MIN, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MIN, (Object)ComparableUtils.min((Comparable)Instant.MAX, (Comparable)Instant.MIN));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (Integer)((Integer)ComparableUtils.min((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MIN_VALUE))));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)((Integer)ComparableUtils.min((Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE))));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (Integer)((Integer)ComparableUtils.min((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE))));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (Integer)((Integer)ComparableUtils.min((Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(Integer.MIN_VALUE))));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.min(null, (Comparable)Instant.MAX));
        Assertions.assertEquals((Object)Instant.MAX, (Object)ComparableUtils.min((Comparable)Instant.MAX, null));
    }

    @Nested
    class A_is_1 {
        BigDecimal a = BigDecimal.ONE;

        A_is_1() {
        }

        @DisplayName(value="B is 10 (B > A)")
        @Nested
        class B_is_10 {
            BigDecimal b = BigDecimal.TEN;

            B_is_10() {
            }

            @Test
            void equalTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void static_gt_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.gt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_ge_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.ge((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_lt_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.lt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_le_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.le((Comparable)this.b).test(A_is_1.this.a));
            }

            @DisplayName(value="C is 10 ([B,C] > A)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.between((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 1 (B > A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 0 (B > A > C)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }
        }

        @DisplayName(value="B is 1 (B = A)")
        @Nested
        class B_is_1 {
            BigDecimal b = BigDecimal.ONE;

            B_is_1() {
            }

            @Test
            void equalTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void static_gt_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.gt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_ge_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.ge((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_lt_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.lt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_le_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.le((Comparable)this.b).test(A_is_1.this.a));
            }

            @DisplayName(value="C is 10 (B = A < C)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 1 (B = A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 0 (B = A > C)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }
        }

        @DisplayName(value="B is 0 (B < A)")
        @Nested
        class B_is_0 {
            BigDecimal b = BigDecimal.ZERO;

            B_is_0() {
            }

            @Test
            void equalTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void static_gt_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.gt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_ge_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.ge((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_lt_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.lt((Comparable)this.b).test(A_is_1.this.a));
            }

            @Test
            void static_le_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.le((Comparable)this.b).test(A_is_1.this.a));
            }

            @DisplayName(value="C is 10 (B < A < C)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 1 (B < A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.between((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }

            @DisplayName(value="C is 0 ([B=C] < A)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void static_between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.between((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }

                @Test
                void static_betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c).test(A_is_1.this.a));
                }
            }
        }
    }
}

