/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.EqualsExclude;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EqualsBuilderTest
extends AbstractLangTest {
    @Test
    public void testReflectionEquals() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o1, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o2, (String[])new String[0]));
        o2.setA(4);
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o2, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)this, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)o1, null, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals(null, (Object)o2, (String[])new String[0]));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals(null, null, (String[])new String[0]));
    }

    @Test
    public void testReflectionHierarchyEquals() {
        this.testReflectionHierarchyEquals(false);
        this.testReflectionHierarchyEquals(true);
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)false));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 0, 0, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 0), (boolean)true));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(0, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true));
    }

    private void testReflectionHierarchyEquals(boolean testTransients) {
        TestObject to1 = new TestObject(4);
        TestObject to1Bis = new TestObject(4);
        TestObject to1Ter = new TestObject(4);
        TestObject to2 = new TestObject(5);
        TestEmptySubObject teso = new TestEmptySubObject(4);
        TestTSubObject ttso = new TestTSubObject(4, 1);
        TestTTSubObject tttso = new TestTTSubObject(4, 1, 2);
        TestTTLeafObject ttlo = new TestTTLeafObject(4, 1, 2, 3);
        TestSubObject tso1 = new TestSubObject(1, 4);
        TestSubObject tso1bis = new TestSubObject(1, 4);
        TestSubObject tso1ter = new TestSubObject(1, 4);
        TestSubObject tso2 = new TestSubObject(2, 5);
        this.testReflectionEqualsEquivalenceRelationship(to1, to1Bis, to1Ter, to2, new TestObject(), testTransients);
        this.testReflectionEqualsEquivalenceRelationship(tso1, tso1bis, tso1ter, tso2, new TestSubObject(), testTransients);
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttlo, (Object)ttlo, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(1, 10), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(1, 11), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 11), (Object)new TestSubObject(1, 10), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(0, 10), (Object)new TestSubObject(1, 10), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(0, 10), (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)teso, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)teso, (Object)to1, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)ttso, (boolean)false));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttso, (Object)to1, (boolean)false));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)tttso, (boolean)false));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)tttso, (Object)to1, (boolean)false));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttso, (Object)tttso, (boolean)false));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)tttso, (Object)ttso, (boolean)false));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestObject(0), (Object)new TestEmptySubObject(1), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestEmptySubObject(1), (Object)new TestObject(0), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestObject(0), (Object)new TestTSubObject(1, 1), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestTSubObject(1, 1), (Object)new TestObject(0), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestObject(1), (Object)new TestSubObject(0, 10), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(0, 10), (Object)new TestObject(1), (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)ttlo, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)tso1, (Object)this, (String[])new String[0]));
    }

    private void testReflectionEqualsEquivalenceRelationship(TestObject to, TestObject toBis, TestObject toTer, TestObject to2, TestObject oToChange, boolean testTransients) {
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to, (Object)to, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to2, (Object)to2, (boolean)testTransients));
        Assertions.assertTrue((EqualsBuilder.reflectionEquals((Object)to, (Object)toBis, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)toBis, (Object)to, (boolean)testTransients) ? 1 : 0) != 0);
        Assertions.assertTrue((EqualsBuilder.reflectionEquals((Object)to, (Object)toBis, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)toBis, (Object)toTer, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)to, (Object)toTer, (boolean)testTransients) ? 1 : 0) != 0);
        oToChange.setA(to.getA());
        if (oToChange instanceof TestSubObject) {
            ((TestSubObject)oToChange).setB(((TestSubObject)to).getB());
        }
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        oToChange.setA(to.getA() + 1);
        if (oToChange instanceof TestSubObject) {
            ((TestSubObject)oToChange).setB(((TestSubObject)to).getB() + 1);
        }
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)to, null, (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)to2, null, (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals(null, (Object)to, (boolean)testTransients));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals(null, (Object)to2, (boolean)testTransients));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals(null, null, (boolean)testTransients));
    }

    @Test
    public void testSuper() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertTrue((boolean)new EqualsBuilder().appendSuper(true).append((Object)o1, (Object)o1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().appendSuper(false).append((Object)o1, (Object)o1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().appendSuper(true).append((Object)o1, (Object)o2).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().appendSuper(false).append((Object)o1, (Object)o2).isEquals());
    }

    @Test
    public void testObject() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)o1, (Object)o2).isEquals());
        o2.setA(4);
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o2).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)o1, (Object)this).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)o1, null).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(null, (Object)o2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(null, null).isEquals());
    }

    @Test
    public void testObjectBuild() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)new EqualsBuilder().append((Object)o1, (Object)o1).build());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)new EqualsBuilder().append((Object)o1, (Object)o2).build());
        o2.setA(4);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)new EqualsBuilder().append((Object)o1, (Object)o2).build());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)new EqualsBuilder().append((Object)o1, (Object)this).build());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)new EqualsBuilder().append((Object)o1, null).build());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)new EqualsBuilder().append(null, (Object)o2).build());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)new EqualsBuilder().append(null, null).build());
    }

    @Test
    public void testObjectRecursiveGenericInteger() {
        TestRecursiveGenericObject<Integer> o1A = new TestRecursiveGenericObject<Integer>(1);
        TestRecursiveGenericObject<Integer> o1B = new TestRecursiveGenericObject<Integer>(1);
        TestRecursiveGenericObject<Integer> o2 = new TestRecursiveGenericObject<Integer>(2);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append(o1A, o1B).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append(o1B, o1A).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append(o1B, o2).isEquals());
    }

    @Test
    public void testObjectsBypassReflectionClasses() {
        ArrayList<Class> bypassReflectionClasses = new ArrayList<Class>();
        bypassReflectionClasses.add(List.class);
        bypassReflectionClasses.add(Boolean.class);
        Assertions.assertTrue((boolean)new EqualsBuilder().setBypassReflectionClasses(bypassReflectionClasses).isEquals());
    }

    @Test
    public void testObjectRecursiveGenericString() {
        String s1A = String.valueOf(1);
        TestRecursiveGenericObject<String> o1A = new TestRecursiveGenericObject<String>(s1A);
        TestRecursiveGenericObject<String> o1B = new TestRecursiveGenericObject<String>(String.valueOf(1));
        TestRecursiveGenericObject<String> o2 = new TestRecursiveGenericObject<String>(String.valueOf(2));
        s1A.hashCode();
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append(o1A, o1B).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append(o1B, o1A).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append(o1B, o2).isEquals());
    }

    @Test
    public void testObjectRecursive() {
        TestRecursiveInnerObject i1_1 = new TestRecursiveInnerObject(1);
        TestRecursiveInnerObject i1_2 = new TestRecursiveInnerObject(1);
        TestRecursiveInnerObject i2_1 = new TestRecursiveInnerObject(2);
        TestRecursiveInnerObject i2_2 = new TestRecursiveInnerObject(2);
        TestRecursiveInnerObject i3 = new TestRecursiveInnerObject(3);
        TestRecursiveInnerObject i4 = new TestRecursiveInnerObject(4);
        TestRecursiveObject o1A = new TestRecursiveObject(i1_1, i2_1, 1);
        TestRecursiveObject o1B = new TestRecursiveObject(i1_2, i2_2, 1);
        TestRecursiveObject o2 = new TestRecursiveObject(i3, i4, 2);
        TestRecursiveObject oNull = new TestRecursiveObject(null, null, 2);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1A).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1B).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)oNull, (Object)oNull).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)oNull).isEquals());
    }

    @Test
    public void testObjectRecursiveCycleSelfreference() {
        TestRecursiveCycleObject o1A = new TestRecursiveCycleObject(1);
        TestRecursiveCycleObject o1B = new TestRecursiveCycleObject(1);
        TestRecursiveCycleObject o2 = new TestRecursiveCycleObject(2);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1A).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1B).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o2).isEquals());
    }

    @Test
    public void testObjectRecursiveCycle() {
        TestRecursiveCycleObject o1A = new TestRecursiveCycleObject(1);
        TestRecursiveCycleObject i1A = new TestRecursiveCycleObject(o1A, 100);
        o1A.setCycle(i1A);
        TestRecursiveCycleObject o1B = new TestRecursiveCycleObject(1);
        TestRecursiveCycleObject i1B = new TestRecursiveCycleObject(o1B, 100);
        o1B.setCycle(i1B);
        TestRecursiveCycleObject o2 = new TestRecursiveCycleObject(2);
        TestRecursiveCycleObject i2 = new TestRecursiveCycleObject(o1B, 200);
        o2.setCycle(i2);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1A).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o1B).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1A, (Object)o2).isEquals());
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1A, (Object)o1B, (boolean)false, null, (boolean)true, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)o1A, (Object)o2, (boolean)false, null, (boolean)true, (String[])new String[0]));
    }

    @Test
    public void testLong() {
        long o1 = 1L;
        long o2 = 2L;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(1L, 1L).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1L, 2L).isEquals());
    }

    @Test
    public void testInt() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(1, 1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1, 2).isEquals());
    }

    @Test
    public void testShort() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((short)1, (short)1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((short)1, (short)2).isEquals());
    }

    @Test
    public void testChar() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append('\u0001', '\u0001').isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append('\u0001', '\u0002').isEquals());
    }

    @Test
    public void testByte() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((byte)1, (byte)1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((byte)1, (byte)2).isEquals());
    }

    @Test
    public void testDouble() {
        double o1 = 1.0;
        double o2 = 2.0;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(1.0, 1.0).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1.0, 2.0).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1.0, Double.NaN).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(Double.NaN, Double.NaN).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY).isEquals());
    }

    @Test
    public void testFloat() {
        float o1 = 1.0f;
        float o2 = 2.0f;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(1.0f, 1.0f).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1.0f, 2.0f).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(1.0f, Float.NaN).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(Float.NaN, Float.NaN).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY).isEquals());
    }

    @Test
    public void testAccessors() {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        Assertions.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(true);
        Assertions.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(false);
        Assertions.assertFalse((boolean)equalsBuilder.isEquals());
    }

    @Test
    public void testReset() {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        Assertions.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(false);
        Assertions.assertFalse((boolean)equalsBuilder.isEquals());
        equalsBuilder.reset();
        Assertions.assertTrue((boolean)equalsBuilder.isEquals());
    }

    @Test
    public void testBoolean() {
        boolean o1 = true;
        boolean o2 = false;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(true, true).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append(true, false).isEquals());
    }

    @Test
    public void testObjectArray() {
        Object[] obj1 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        Object[] obj2 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj2, obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        ((TestObject)obj1[1]).setA(6);
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        ((TestObject)obj1[1]).setA(5);
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[2] = obj1[1];
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[2] = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testLongArray() {
        long[] obj1 = new long[]{5L, 6L};
        long[] obj2 = new long[]{5L, 6L};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7L;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testIntArray() {
        int[] obj1 = new int[]{5, 6};
        int[] obj2 = new int[]{5, 6};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testShortArray() {
        short[] obj1 = new short[]{5, 6};
        short[] obj2 = new short[]{5, 6};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testCharArray() {
        char[] obj1 = new char[]{'\u0005', '\u0006'};
        char[] obj2 = new char[]{'\u0005', '\u0006'};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testByteArray() {
        byte[] obj1 = new byte[]{5, 6};
        byte[] obj2 = new byte[]{5, 6};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testDoubleArray() {
        double[] obj1 = new double[]{5.0, 6.0};
        double[] obj2 = new double[]{5.0, 6.0};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7.0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testFloatArray() {
        float[] obj1 = new float[]{5.0f, 6.0f};
        float[] obj2 = new float[]{5.0f, 6.0f};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7.0f;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testBooleanArray() {
        boolean[] obj1 = new boolean[]{true, false};
        boolean[] obj2 = new boolean[]{true, false};
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = true;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1 = null;
        Assertions.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    @Test
    public void testMultiLongArray() {
        long[][] array1 = new long[2][2];
        long[][] array2 = new long[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0L;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiIntArray() {
        int[][] array1 = new int[2][2];
        int[][] array2 = new int[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiShortArray() {
        short[][] array1 = new short[2][2];
        short[][] array2 = new short[2][2];
        for (int i = 0; i < array1.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((short)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiCharArray() {
        char[][] array1 = new char[2][2];
        char[][] array2 = new char[2][2];
        for (int i = 0; i < array1.length; i = (int)((char)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((char)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = '\u0000';
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiByteArray() {
        byte[][] array1 = new byte[2][2];
        byte[][] array2 = new byte[2][2];
        for (int i = 0; i < array1.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((byte)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiFloatArray() {
        float[][] array1 = new float[2][2];
        float[][] array2 = new float[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0.0f;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiDoubleArray() {
        double[][] array1 = new double[2][2];
        double[][] array2 = new double[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0.0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMultiBooleanArray() {
        boolean[][] array1 = new boolean[2][2];
        boolean[][] array2 = new boolean[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = i == 1 || j == 1;
                array2[i][j] = i == 1 || j == 1;
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = false;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        boolean[] array3 = new boolean[]{true, true};
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)array1, (Object)array3).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)array3, (Object)array1).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)array2, (Object)array3).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)array3, (Object)array2).isEquals());
    }

    @Test
    public void testRaggedArray() {
        long[][] array1 = new long[2][];
        long[][] array2 = new long[2][];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            for (int j = 0; j < array1[i].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0L;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
    }

    @Test
    public void testMixedArray() {
        Object[] array1 = new Object[2];
        Object[] array2 = new Object[2];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            for (int j = 0; j < 2; ++j) {
                ((long[])array1[i])[j] = (i + 1) * (j + 1);
                ((long[])array2[i])[j] = (i + 1) * (j + 1);
            }
        }
        Assertions.assertTrue((boolean)new EqualsBuilder().append(array1, array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(array1, array2).isEquals());
        ((long[])array1[1])[1] = 0L;
        Assertions.assertFalse((boolean)new EqualsBuilder().append(array1, array2).isEquals());
    }

    @Test
    public void testObjectArrayHiddenByObject() {
        TestObject[] array1 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array2 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] obj1 = array1;
        TestObject[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1].setA(6);
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testLongArrayHiddenByObject() {
        long[] array1 = new long[]{5L, 6L};
        long[] array2 = new long[]{5L, 6L};
        long[] obj1 = array1;
        long[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7L;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testIntArrayHiddenByObject() {
        int[] array1 = new int[]{5, 6};
        int[] array2 = new int[]{5, 6};
        int[] obj1 = array1;
        int[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testShortArrayHiddenByObject() {
        short[] array1 = new short[]{5, 6};
        short[] array2 = new short[]{5, 6};
        short[] obj1 = array1;
        short[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testCharArrayHiddenByObject() {
        char[] array1 = new char[]{'\u0005', '\u0006'};
        char[] array2 = new char[]{'\u0005', '\u0006'};
        char[] obj1 = array1;
        char[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testByteArrayHiddenByObject() {
        byte[] array1 = new byte[]{5, 6};
        byte[] array2 = new byte[]{5, 6};
        byte[] obj1 = array1;
        byte[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testDoubleArrayHiddenByObject() {
        double[] array1 = new double[]{5.0, 6.0};
        double[] array2 = new double[]{5.0, 6.0};
        double[] obj1 = array1;
        double[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7.0;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testFloatArrayHiddenByObject() {
        float[] array1 = new float[]{5.0f, 6.0f};
        float[] array2 = new float[]{5.0f, 6.0f};
        float[] obj1 = array1;
        float[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7.0f;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testBooleanArrayHiddenByObject() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = new boolean[]{true, false};
        boolean[] obj1 = array1;
        boolean[] obj2 = array2;
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = true;
        Assertions.assertFalse((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
    }

    @Test
    public void testUnrelatedClasses() {
        Object[] x = new Object[]{new TestACanEqualB(1)};
        Object[] y = new Object[]{new TestBCanEqualA(1)};
        Assertions.assertArrayEquals((Object[])x, (Object[])x);
        Assertions.assertArrayEquals((Object[])y, (Object[])y);
        Assertions.assertArrayEquals((Object[])x, (Object[])y);
        Assertions.assertArrayEquals((Object[])y, (Object[])x);
        Assertions.assertEquals((Object)x[0], (Object)x[0]);
        Assertions.assertEquals((Object)y[0], (Object)y[0]);
        Assertions.assertEquals((Object)x[0], (Object)y[0]);
        Assertions.assertEquals((Object)y[0], (Object)x[0]);
        Assertions.assertTrue((boolean)new EqualsBuilder().append(x, x).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(y, y).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(x, y).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().append(y, x).isEquals());
    }

    @Test
    public void testNpeForNullElement() {
        Object[] x1 = new Object[]{1, null, 3};
        Object[] x2 = new Object[]{1, 2, 3};
        new EqualsBuilder().append(x1, x2);
    }

    @Test
    public void testReflectionEqualsExcludeFields() {
        TestObjectWithMultipleFields x1 = new TestObjectWithMultipleFields(1, 2, 3);
        TestObjectWithMultipleFields x2 = new TestObjectWithMultipleFields(1, 3, 4);
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])null));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[0]));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"xxx"}));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"two"}));
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"three"}));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"two", "three"}));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"one", "two", "three"}));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"one", "two", "three", "xxx"}));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, Arrays.asList("one", "two", "three")));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, Arrays.asList("one", "two", "three", "xxx")));
    }

    @Test
    public void testCyclicalObjectReferences() {
        TestObjectReference refX1 = new TestObjectReference(1);
        TestObjectReference x1 = new TestObjectReference(1);
        x1.setObjectReference(refX1);
        refX1.setObjectReference(x1);
        TestObjectReference refX2 = new TestObjectReference(1);
        TestObjectReference x2 = new TestObjectReference(1);
        x2.setObjectReference(refX2);
        refX2.setObjectReference(x2);
        TestObjectReference refX3 = new TestObjectReference(2);
        TestObjectReference x3 = new TestObjectReference(2);
        x3.setObjectReference(refX3);
        refX3.setObjectReference(x3);
        Assertions.assertEquals((Object)x1, (Object)x2);
        Assertions.assertNull((Object)EqualsBuilder.getRegistry());
        Assertions.assertNotEquals((Object)x1, (Object)x3);
        Assertions.assertNull((Object)EqualsBuilder.getRegistry());
        Assertions.assertNotEquals((Object)x2, (Object)x3);
        Assertions.assertNull((Object)EqualsBuilder.getRegistry());
    }

    @Test
    public void testReflectionArrays() {
        TestObject one = new TestObject(1);
        TestObject two = new TestObject(2);
        Object[] o1 = new Object[]{one};
        Object[] o2 = new Object[]{two};
        Object[] o3 = new Object[]{one};
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o2, (String[])new String[0]));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o1, (String[])new String[0]));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o3, (String[])new String[0]));
        double[] d1 = new double[]{0.0, 1.0};
        double[] d2 = new double[]{2.0, 3.0};
        double[] d3 = new double[]{0.0, 1.0};
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)d1, (Object)d2, (String[])new String[0]));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)d1, (Object)d1, (String[])new String[0]));
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)d1, (Object)d3, (String[])new String[0]));
    }

    @Test
    public void testToEqualsExclude() {
        TestObjectEqualsExclude one = new TestObjectEqualsExclude(1, 2);
        TestObjectEqualsExclude two = new TestObjectEqualsExclude(1, 3);
        Assertions.assertFalse((boolean)EqualsBuilder.reflectionEquals((Object)one, (Object)two, (String[])new String[0]));
        one = new TestObjectEqualsExclude(1, 2);
        two = new TestObjectEqualsExclude(2, 2);
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)one, (Object)two, (String[])new String[0]));
    }

    @Test
    public void testReflectionAppend() {
        Assertions.assertTrue((boolean)EqualsBuilder.reflectionEquals(null, null, (String[])new String[0]));
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertTrue((boolean)new EqualsBuilder().reflectionAppend((Object)o1, (Object)o1).build());
        Assertions.assertFalse((boolean)new EqualsBuilder().reflectionAppend((Object)o1, (Object)o2).build());
        o2.setA(4);
        Assertions.assertTrue((boolean)new EqualsBuilder().reflectionAppend((Object)o1, (Object)o2).build());
        Assertions.assertFalse((boolean)new EqualsBuilder().reflectionAppend((Object)o1, (Object)this).build());
        Assertions.assertFalse((boolean)new EqualsBuilder().reflectionAppend((Object)o1, null).build());
        Assertions.assertFalse((boolean)new EqualsBuilder().reflectionAppend(null, (Object)o2).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsRegistered() throws Exception {
        Object firstObject = new Object();
        Object secondObject = new Object();
        try {
            Method registerMethod = MethodUtils.getMatchingMethod(EqualsBuilder.class, (String)"register", (Class[])new Class[]{Object.class, Object.class});
            registerMethod.setAccessible(true);
            registerMethod.invoke(null, firstObject, secondObject);
            Assertions.assertTrue((boolean)EqualsBuilder.isRegistered((Object)firstObject, (Object)secondObject));
            Assertions.assertTrue((boolean)EqualsBuilder.isRegistered((Object)secondObject, (Object)firstObject));
        }
        catch (Throwable throwable) {
            Method unregisterMethod = MethodUtils.getMatchingMethod(EqualsBuilder.class, (String)"unregister", (Class[])new Class[]{Object.class, Object.class});
            unregisterMethod.setAccessible(true);
            unregisterMethod.invoke(null, firstObject, secondObject);
            throw throwable;
        }
        Method unregisterMethod = MethodUtils.getMatchingMethod(EqualsBuilder.class, (String)"unregister", (Class[])new Class[]{Object.class, Object.class});
        unregisterMethod.setAccessible(true);
        unregisterMethod.invoke(null, firstObject, secondObject);
    }

    static class TestObjectEqualsExclude {
        @EqualsExclude
        private final int a;
        private final int b;

        TestObjectEqualsExclude(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObjectReference {
        private TestObjectReference reference;
        private final TestObject one;

        TestObjectReference(int one) {
            this.one = new TestObject(one);
        }

        public void setObjectReference(TestObjectReference reference) {
            this.reference = reference;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }

    static class TestObjectWithMultipleFields {
        private final TestObject one;
        private final TestObject two;
        private final TestObject three;

        TestObjectWithMultipleFields(int one, int two, int three) {
            this.one = new TestObject(one);
            this.two = new TestObject(two);
            this.three = new TestObject(three);
        }
    }

    public static class TestBCanEqualA {
        private final int b;

        public TestBCanEqualA(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.b == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.b == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int hashCode() {
            return this.b;
        }

        public int getB() {
            return this.b;
        }
    }

    public static class TestACanEqualB {
        private final int a;

        public TestACanEqualB(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.a == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.a == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int hashCode() {
            return this.a;
        }

        public int getA() {
            return this.a;
        }
    }

    static class TestRecursiveCycleObject {
        private TestRecursiveCycleObject cycle;
        private final int n;

        TestRecursiveCycleObject(int n) {
            this.n = n;
            this.cycle = this;
        }

        TestRecursiveCycleObject(TestRecursiveCycleObject cycle, int n) {
            this.n = n;
            this.cycle = cycle;
        }

        public int getN() {
            return this.n;
        }

        public TestRecursiveCycleObject getCycle() {
            return this.cycle;
        }

        public void setCycle(TestRecursiveCycleObject cycle) {
            this.cycle = cycle;
        }
    }

    static class TestRecursiveInnerObject {
        private final int n;

        TestRecursiveInnerObject(int n) {
            this.n = n;
        }

        public int getN() {
            return this.n;
        }
    }

    static class TestRecursiveObject {
        private final TestRecursiveInnerObject a;
        private final TestRecursiveInnerObject b;
        private int z;

        TestRecursiveObject(TestRecursiveInnerObject a, TestRecursiveInnerObject b, int z) {
            this.a = a;
            this.b = b;
        }

        public TestRecursiveInnerObject getA() {
            return this.a;
        }

        public TestRecursiveInnerObject getB() {
            return this.b;
        }

        public int getZ() {
            return this.z;
        }
    }

    static class TestRecursiveGenericObject<T> {
        private final T a;

        TestRecursiveGenericObject(T a) {
            this.a = a;
        }

        public T getA() {
            return this.a;
        }
    }

    static class TestTSubObject2
    extends TestObject {
        private transient int t;

        TestTSubObject2(int a, int t) {
            super(a);
        }

        public int getT() {
            return this.t;
        }

        public void setT(int t) {
            this.t = t;
        }
    }

    static class TestTTLeafObject
    extends TestTTSubObject {
        private final int leafValue;

        TestTTLeafObject(int a, int t, int tt, int leafValue) {
            super(a, t, tt);
            this.leafValue = leafValue;
        }
    }

    static class TestTTSubObject
    extends TestTSubObject {
        private final transient int tt;

        TestTTSubObject(int a, int t, int tt) {
            super(a, t);
            this.tt = tt;
        }
    }

    static class TestTSubObject
    extends TestObject {
        private final transient int t;

        TestTSubObject(int a, int t) {
            super(a);
            this.t = t;
        }
    }

    static class TestEmptySubObject
    extends TestObject {
        TestEmptySubObject(int a) {
            super(a);
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;

        TestSubObject() {
            super(0);
        }

        TestSubObject(int a, int b) {
            super(a);
            this.b = b;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }

        @Override
        public int hashCode() {
            return this.b * 17 + super.hashCode();
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObject {
        private int a;

        TestObject() {
        }

        TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public int hashCode() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }
    }
}

