/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.text.WordUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class StringUtilsTest
extends AbstractLangTest {
    static final String WHITESPACE;
    static final String NON_WHITESPACE;
    static final String HARD_SPACE;
    static final String TRIMMABLE;
    static final String NON_TRIMMABLE;
    private static final String[] ARRAY_LIST;
    private static final String[] EMPTY_ARRAY_LIST;
    private static final String[] NULL_ARRAY_LIST;
    private static final Object[] NULL_TO_STRING_LIST;
    private static final String[] MIXED_ARRAY_LIST;
    private static final Object[] MIXED_TYPE_LIST;
    private static final long[] LONG_PRIM_LIST;
    private static final int[] INT_PRIM_LIST;
    private static final byte[] BYTE_PRIM_LIST;
    private static final short[] SHORT_PRIM_LIST;
    private static final char[] CHAR_PRIM_LIST;
    private static final float[] FLOAT_PRIM_LIST;
    private static final double[] DOUBLE_PRIM_LIST;
    private static final List<String> MIXED_STRING_LIST;
    private static final List<Object> MIXED_TYPE_OBJECT_LIST;
    private static final List<String> STRING_LIST;
    private static final List<String> EMPTY_STRING_LIST;
    private static final List<String> NULL_STRING_LIST;
    private static final String SEPARATOR = ",";
    private static final char SEPARATOR_CHAR = ';';
    private static final char COMMA_SEPARATOR_CHAR = ',';
    private static final String TEXT_LIST = "foo,bar,baz";
    private static final String TEXT_LIST_CHAR = "foo;bar;baz";
    private static final String TEXT_LIST_NOSEP = "foobarbaz";
    private static final String FOO_UNCAP = "foo";
    private static final String FOO_CAP = "Foo";
    private static final String SENTENCE_UNCAP = "foo bar baz";
    private static final String SENTENCE_CAP = "Foo Bar Baz";
    private static final boolean[] EMPTY;
    private static final boolean[] ARRAY_FALSE_FALSE;
    private static final boolean[] ARRAY_FALSE_TRUE;
    private static final boolean[] ARRAY_FALSE_TRUE_FALSE;

    private void assertAbbreviateWithAbbrevMarkerAndOffset(String expected, String abbrevMarker, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,String,int,int) failed";
        String actual = StringUtils.abbreviate((String)"abcdefghijklmno", (String)abbrevMarker, (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < "abcdefghijklmno".length()) {
            Assertions.assertTrue((actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0, (String)"abbreviate(String,String,int,int) failed -- should contain offset character");
        }
        Assertions.assertTrue((actual.length() <= maxWidth ? 1 : 0) != 0, (String)"abbreviate(String,String,int,int) failed -- should not be greater than maxWidth");
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"abbreviate(String,String,int,int) failed");
    }

    private void assertAbbreviateWithOffset(String expected, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,int,int) failed";
        String actual = StringUtils.abbreviate((String)"abcdefghijklmno", (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < "abcdefghijklmno".length()) {
            Assertions.assertTrue((actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0, (String)"abbreviate(String,int,int) failed -- should contain offset character");
        }
        Assertions.assertTrue((actual.length() <= maxWidth ? 1 : 0) != 0, (String)"abbreviate(String,int,int) failed -- should not be greater than maxWidth");
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"abbreviate(String,int,int) failed");
    }

    private void innerTestSplit(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.split((String)str, (String)sepStr);
        Assertions.assertEquals((int)3, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[2]);
        String str2 = separator + "a" + separator;
        res = StringUtils.split((String)str2, (String)sepStr);
        Assertions.assertEquals((int)1, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        res = StringUtils.split((String)str, (String)sepStr, (int)-1);
        Assertions.assertEquals((int)3, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"b", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[2], (String)msg);
        res = StringUtils.split((String)str, (String)sepStr, (int)0);
        Assertions.assertEquals((int)3, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"b", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[2], (String)msg);
        res = StringUtils.split((String)str, (String)sepStr, (int)1);
        Assertions.assertEquals((int)1, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)str, (Object)res[0], (String)msg);
        res = StringUtils.split((String)str, (String)sepStr, (int)2);
        Assertions.assertEquals((int)2, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)str.substring(2), (Object)res[1], (String)msg);
    }

    private void innerTestSplitPreserveAllTokens(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr);
        Assertions.assertEquals((int)4, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"b", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)"", (Object)res[2], (String)msg);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[3], (String)msg);
        String str2 = separator + "a" + separator;
        res = StringUtils.splitPreserveAllTokens((String)str2, (String)sepStr);
        Assertions.assertEquals((int)3, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)"", (Object)res[2], (String)msg);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)-1);
        Assertions.assertEquals((int)4, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"b", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)"", (Object)res[2], (String)msg);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[3], (String)msg);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)0);
        Assertions.assertEquals((int)4, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)"b", (Object)res[1], (String)msg);
        Assertions.assertEquals((Object)"", (Object)res[2], (String)msg);
        Assertions.assertEquals((Object)(noMatch + "c"), (Object)res[3], (String)msg);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)1);
        Assertions.assertEquals((int)1, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)str, (Object)res[0], (String)msg);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)2);
        Assertions.assertEquals((int)2, (int)res.length, (String)msg);
        Assertions.assertEquals((Object)"a", (Object)res[0], (String)msg);
        Assertions.assertEquals((Object)str.substring(2), (Object)res[1], (String)msg);
    }

    @Test
    public void testAbbreviateMarkerWithEmptyString() {
        String greaterThanMaxTest = "much too long text";
        Assertions.assertEquals((Object)"much too long", (Object)StringUtils.abbreviate((String)"much too long text", (String)"", (int)13));
    }

    @Test
    public void testAbbreviate_StringInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)10));
        Assertions.assertEquals((Object)"short", (Object)StringUtils.abbreviate((String)"short", (int)10));
        Assertions.assertEquals((Object)"Now is ...", (Object)StringUtils.abbreviate((String)"Now is the time for all good men to come to the aid of their party.", (int)10));
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry p...", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)14));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)15));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)16));
        Assertions.assertEquals((Object)"abc...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)6));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)7));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)8));
        Assertions.assertEquals((Object)"a...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)4));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abc", (int)3), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
    }

    @Test
    public void testAbbreviate_StringIntInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)10, (int)12));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)0, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)2, (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abcdefghij", (int)0, (int)3), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abcdefghij", (int)5, (int)6), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)11, (int)15));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)7, (int)14));
        this.assertAbbreviateWithOffset("abcdefg...", -1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 0, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 2, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 3, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 4, 10);
        this.assertAbbreviateWithOffset("...fghi...", 5, 10);
        this.assertAbbreviateWithOffset("...ghij...", 6, 10);
        this.assertAbbreviateWithOffset("...hijk...", 7, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 8, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 9, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 11, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 12, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 13, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 14, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 15, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 16, 10);
        this.assertAbbreviateWithOffset("...ijklmno", Integer.MAX_VALUE, 10);
    }

    @Test
    public void testAbbreviate_StringStringInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, null, (int)10));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)"...", (int)10));
        Assertions.assertEquals((Object)"paranaguacu", (Object)StringUtils.abbreviate((String)"paranaguacu", null, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (String)"...", (int)2));
        Assertions.assertEquals((Object)"wai**", (Object)StringUtils.abbreviate((String)"waiheke", (String)"**", (int)5));
        Assertions.assertEquals((Object)"And af,,,,", (Object)StringUtils.abbreviate((String)"And after a long time, he finally met his son.", (String)",,,,", (int)10));
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry pe..", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"..", (int)14));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"---*---", (int)15));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)".", (int)16));
        Assertions.assertEquals((Object)"abc()(", (Object)StringUtils.abbreviate((String)"abcdefg", (String)"()(", (int)6));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (String)";", (int)7));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (String)"_-", (int)8));
        Assertions.assertEquals((Object)"abc.", (Object)StringUtils.abbreviate((String)"abcdefg", (String)".", (int)4));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abcdefghij", (String)"...", (int)3), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
    }

    @Test
    public void testAbbreviate_StringStringIntInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, null, (int)10, (int)12));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)"...", (int)10, (int)12));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", null, (int)0, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (String)"...", (int)2, (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abcdefghij", (String)"::", (int)0, (int)2), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.abbreviate((String)"abcdefghij", (String)"!!!", (int)5, (int)6), (String)"StringUtils.abbreviate expecting IllegalArgumentException");
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"--", (int)12, (int)15));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)";", (int)7, (int)14));
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefgh;;", ";;", -1, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefghi.", ".", 0, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefgh++", "++", 1, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefghi*", "*", 2, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdef{{{{", "{{{{", 4, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdef____", "____", 5, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("==fghijk==", "==", 5, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("___ghij___", "___", 6, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 7, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 8, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 9, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("///ijklmno", "///", 10, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("//hijklmno", "//", 10, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("//hijklmno", "//", 11, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("...ijklmno", "...", 12, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 13, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 14, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("999ijklmno", "999", 15, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("_ghijklmno", "_", 16, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("+ghijklmno", "+", Integer.MAX_VALUE, 10);
    }

    @Test
    public void testAbbreviateMiddle() {
        Assertions.assertNull((Object)StringUtils.abbreviateMiddle(null, null, (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", null, (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)3));
        Assertions.assertEquals((Object)"ab.f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)4));
        Assertions.assertEquals((Object)"A very long text with un...f the text is complete.", (Object)StringUtils.abbreviateMiddle((String)"A very long text with unimportant stuff in the middle but interesting start and end to see if the text is complete.", (String)"...", (int)50));
        String longText = "Start text" + StringUtils.repeat((String)"x", (int)10000) + "Close text";
        Assertions.assertEquals((Object)"Start text->Close text", (Object)StringUtils.abbreviateMiddle((String)longText, (String)"->", (int)22));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)-1));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)1));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)2));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.abbreviateMiddle((String)"a", (String)".", (int)1));
        Assertions.assertEquals((Object)"a.d", (Object)StringUtils.abbreviateMiddle((String)"abcd", (String)".", (int)3));
        Assertions.assertEquals((Object)"a..f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)"..", (int)4));
        Assertions.assertEquals((Object)"ab.ef", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)5));
    }

    @Test
    public void testAppendIfMissing() {
        Assertions.assertNull((Object)StringUtils.appendIfMissing(null, null, (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", null, (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(abc,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.appendIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(\"\",xyz)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(abc,xyz)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(abcxyz,xyz)");
        Assertions.assertEquals((Object)"aXYZxyz", (Object)StringUtils.appendIfMissing((String)"aXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissing(aXYZ,xyz)");
        Assertions.assertNull((Object)StringUtils.appendIfMissing(null, null, (CharSequence[])null), (String)"appendIfMissing(null,null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", null, (CharSequence[])null), (String)"appendIfMissing(abc,null,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.appendIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])null), (String)"appendIfMissing(\"\",xyz,null))");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", null), (String)"appendIfMissing(abc,xyz,{null})");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}), (String)"appendIfMissing(abc,xyz,\"\")");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissing(abc,xyz,mno)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissing(abcxyz,xyz,mno)");
        Assertions.assertEquals((Object)"abcmno", (Object)StringUtils.appendIfMissing((String)"abcmno", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissing(abcmno,xyz,mno)");
        Assertions.assertEquals((Object)"abcXYZxyz", (Object)StringUtils.appendIfMissing((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissing(abcXYZ,xyz,mno)");
        Assertions.assertEquals((Object)"abcMNOxyz", (Object)StringUtils.appendIfMissing((String)"abcMNO", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissing(abcMNO,xyz,mno)");
    }

    @Test
    public void testAppendIfMissingIgnoreCase() {
        Assertions.assertNull((Object)StringUtils.appendIfMissingIgnoreCase(null, null, (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", null, (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(abc,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(\"\",xyz)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(abc,xyz)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(abcxyz,xyz)");
        Assertions.assertEquals((Object)"abcXYZ", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"appendIfMissingIgnoreCase(abcXYZ,xyz)");
        Assertions.assertNull((Object)StringUtils.appendIfMissingIgnoreCase(null, null, (CharSequence[])null), (String)"appendIfMissingIgnoreCase(null,null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", null, (CharSequence[])null), (String)"appendIfMissingIgnoreCase(abc,null,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])null), (String)"appendIfMissingIgnoreCase(\"\",xyz,null)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", null), (String)"appendIfMissingIgnoreCase(abc,xyz,{null})");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}), (String)"appendIfMissingIgnoreCase(abc,xyz,\"\")");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissingIgnoreCase(abc,xyz,mno)");
        Assertions.assertEquals((Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissingIgnoreCase(abcxyz,xyz,mno)");
        Assertions.assertEquals((Object)"abcmno", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcmno", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissingIgnoreCase(abcmno,xyz,mno)");
        Assertions.assertEquals((Object)"abcXYZ", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissingIgnoreCase(abcXYZ,xyz,mno)");
        Assertions.assertEquals((Object)"abcMNO", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcMNO", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"appendIfMissingIgnoreCase(abcMNO,xyz,mno)");
    }

    @Test
    public void testCapitalize() {
        Assertions.assertNull((Object)StringUtils.capitalize(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.capitalize((String)""), (String)"capitalize(empty-string) failed");
        Assertions.assertEquals((Object)"X", (Object)StringUtils.capitalize((String)"x"), (String)"capitalize(single-char-string) failed");
        Assertions.assertEquals((Object)FOO_CAP, (Object)StringUtils.capitalize((String)FOO_CAP), (String)"capitalize(String) failed");
        Assertions.assertEquals((Object)FOO_CAP, (Object)StringUtils.capitalize((String)FOO_UNCAP), (String)"capitalize(string) failed");
        Assertions.assertEquals((Object)"\u01c8", (Object)StringUtils.capitalize((String)"\u01c9"), (String)"capitalize(String) is not using TitleCase");
        Assertions.assertNull((Object)StringUtils.capitalize(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.capitalize((String)""));
        Assertions.assertEquals((Object)"Cat", (Object)StringUtils.capitalize((String)"cat"));
        Assertions.assertEquals((Object)"CAt", (Object)StringUtils.capitalize((String)"cAt"));
        Assertions.assertEquals((Object)"'cat'", (Object)StringUtils.capitalize((String)"'cat'"));
    }

    @Test
    public void testCenter_StringInt() {
        Assertions.assertNull((Object)StringUtils.center(null, (int)-1));
        Assertions.assertNull((Object)StringUtils.center(null, (int)4));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4));
        Assertions.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4));
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2));
        Assertions.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4));
        Assertions.assertEquals((Object)"  a  ", (Object)StringUtils.center((String)"a", (int)5));
    }

    @Test
    public void testCenter_StringIntChar() {
        Assertions.assertNull((Object)StringUtils.center(null, (int)-1, (char)' '));
        Assertions.assertNull((Object)StringUtils.center(null, (int)4, (char)' '));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (char)' '));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0, (char)' '));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1, (char)' '));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1, (char)' '));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (char)' '));
        Assertions.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4, (char)' '));
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2, (char)' '));
        Assertions.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4, (char)' '));
        Assertions.assertEquals((Object)"  a  ", (Object)StringUtils.center((String)"a", (int)5, (char)' '));
        Assertions.assertEquals((Object)"xxaxx", (Object)StringUtils.center((String)"a", (int)5, (char)'x'));
    }

    @Test
    public void testCenter_StringIntString() {
        Assertions.assertNull((Object)StringUtils.center(null, (int)4, null));
        Assertions.assertNull((Object)StringUtils.center(null, (int)-1, (String)" "));
        Assertions.assertNull((Object)StringUtils.center(null, (int)4, (String)" "));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (String)" "));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0, (String)" "));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1, (String)" "));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1, (String)" "));
        Assertions.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (String)" "));
        Assertions.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4, (String)" "));
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2, (String)" "));
        Assertions.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4, (String)" "));
        Assertions.assertEquals((Object)"yayz", (Object)StringUtils.center((String)"a", (int)4, (String)"yz"));
        Assertions.assertEquals((Object)"yzyayzy", (Object)StringUtils.center((String)"a", (int)7, (String)"yz"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.center((String)"abc", (int)7, null));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.center((String)"abc", (int)7, (String)""));
    }

    @Test
    public void testChomp() {
        String[][] chompCases;
        for (String[] chompCase : chompCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, FOO_UNCAP}, {"foo\n\n", "foo\n"}, {"foo\r\n\r\n", "foo\r\n"}, {"foo\nfoo", "foo\nfoo"}, {"foo\n\rfoo", "foo\n\rfoo"}, {"\n", ""}, {"\r", ""}, {"a", "a"}, {"\r\n", ""}, {"", ""}, {null, null}, {"foo\n\r", "foo\n"}}) {
            String original = chompCase[0];
            String expectedResult = chompCase[1];
            Assertions.assertEquals((Object)expectedResult, (Object)StringUtils.chomp((String)original), (String)"chomp(String) failed");
        }
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.chomp((String)"foobar", (String)"bar"), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"foobar", (Object)StringUtils.chomp((String)"foobar", (String)"baz"), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.chomp((String)FOO_UNCAP, (String)"foooo"), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"foobar", (Object)StringUtils.chomp((String)"foobar", (String)""), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"foobar", (Object)StringUtils.chomp((String)"foobar", null), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.chomp((String)"", (String)FOO_UNCAP), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.chomp((String)"", null), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.chomp((String)"", (String)""), (String)"chomp(String, String) failed");
        Assertions.assertNull((Object)StringUtils.chomp(null, (String)FOO_UNCAP), (String)"chomp(String, String) failed");
        Assertions.assertNull((Object)StringUtils.chomp(null, null), (String)"chomp(String, String) failed");
        Assertions.assertNull((Object)StringUtils.chomp(null, (String)""), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.chomp((String)FOO_UNCAP, (String)FOO_UNCAP), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)" ", (Object)StringUtils.chomp((String)" foo", (String)FOO_UNCAP), (String)"chomp(String, String) failed");
        Assertions.assertEquals((Object)"foo ", (Object)StringUtils.chomp((String)"foo ", (String)FOO_UNCAP), (String)"chomp(String, String) failed");
    }

    @Test
    public void testChop() {
        String[][] chopCases;
        for (String[] chopCase : chopCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, "fo"}, {"foo\nfoo", "foo\nfo"}, {"\n", ""}, {"\r", ""}, {"\r\n", ""}, {null, null}, {"", ""}, {"a", ""}}) {
            String original = chopCase[0];
            String expectedResult = chopCase[1];
            Assertions.assertEquals((Object)expectedResult, (Object)StringUtils.chop((String)original), (String)"chop(String) failed");
        }
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new StringUtils());
        Constructor<?>[] cons = StringUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(StringUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(StringUtils.class.getModifiers()));
    }

    @Test
    public void testDefault_String() {
        Assertions.assertEquals((Object)"", (Object)StringUtils.defaultString(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.defaultString((String)""));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.defaultString((String)"abc"));
    }

    @Test
    public void testDefault_StringString() {
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultString(null, (String)"NULL"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.defaultString((String)"", (String)"NULL"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.defaultString((String)"abc", (String)"NULL"));
    }

    @Test
    public void testDefaultIfBlank_CharBuffers() {
        Assertions.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assertions.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(" "), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), (CharSequence)null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_StringBuffers() {
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(" "), (CharSequence)new StringBuffer("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), (CharSequence)null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_StringBuilders() {
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(" "), (CharSequence)new StringBuilder("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), (CharSequence)null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_StringString() {
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank(null, (CharSequence)"NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)"NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank((CharSequence)" ", (CharSequence)"NULL"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL"));
        Assertions.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)null));
        String s = (String)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL");
        Assertions.assertEquals((Object)"abc", (Object)s);
    }

    @Test
    public void testGetIfBlank_StringStringSupplier() {
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.getIfBlank(null, () -> "NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.getIfBlank((CharSequence)"", () -> "NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.getIfBlank((CharSequence)" ", () -> "NULL"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.getIfBlank((CharSequence)"abc", () -> "NULL"));
        Assertions.assertNull((Object)StringUtils.getIfBlank((CharSequence)"", () -> null));
        Assertions.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)null));
        String s = (String)StringUtils.getIfBlank((CharSequence)"abc", () -> "NULL");
        Assertions.assertEquals((Object)"abc", (Object)s);
        MutableInt numberOfCalls = new MutableInt(0);
        Supplier<String> countingDefaultSupplier = () -> {
            numberOfCalls.increment();
            return "NULL";
        };
        StringUtils.getIfBlank((CharSequence)"abc", countingDefaultSupplier);
        Assertions.assertEquals((int)0, (Integer)numberOfCalls.getValue());
        StringUtils.getIfBlank((CharSequence)"", countingDefaultSupplier);
        Assertions.assertEquals((int)1, (Integer)numberOfCalls.getValue());
        StringUtils.getIfBlank((CharSequence)" ", countingDefaultSupplier);
        Assertions.assertEquals((int)2, (Integer)numberOfCalls.getValue());
        StringUtils.getIfBlank(null, countingDefaultSupplier);
        Assertions.assertEquals((int)3, (Integer)numberOfCalls.getValue());
    }

    @Test
    public void testDefaultIfEmpty_CharBuffers() {
        Assertions.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), (CharSequence)null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfEmpty_StringBuffers() {
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), (CharSequence)null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfEmpty_StringBuilders() {
        Assertions.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        Assertions.assertEquals((Object)"abc", (Object)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        Assertions.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), (CharSequence)null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        Assertions.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfEmpty_StringString() {
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfEmpty(null, (CharSequence)"NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)"NULL"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL"));
        Assertions.assertNull((Object)StringUtils.getIfEmpty((CharSequence)"", null));
        String s = (String)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL");
        Assertions.assertEquals((Object)"abc", (Object)s);
    }

    @Test
    public void testGetIfEmpty_StringStringSupplier() {
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.getIfEmpty((CharSequence)null, () -> "NULL"));
        Assertions.assertEquals((Object)"NULL", (Object)StringUtils.getIfEmpty((CharSequence)"", () -> "NULL"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.getIfEmpty((CharSequence)"abc", () -> "NULL"));
        Assertions.assertNull((Object)StringUtils.getIfEmpty((CharSequence)"", () -> null));
        Assertions.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)null));
        String s = (String)StringUtils.getIfEmpty((CharSequence)"abc", () -> "NULL");
        Assertions.assertEquals((Object)"abc", (Object)s);
        MutableInt numberOfCalls = new MutableInt(0);
        Supplier<String> countingDefaultSupplier = () -> {
            numberOfCalls.increment();
            return "NULL";
        };
        StringUtils.getIfEmpty((CharSequence)"abc", countingDefaultSupplier);
        Assertions.assertEquals((int)0, (Integer)numberOfCalls.getValue());
        StringUtils.getIfEmpty((CharSequence)"", countingDefaultSupplier);
        Assertions.assertEquals((int)1, (Integer)numberOfCalls.getValue());
        StringUtils.getIfEmpty(null, countingDefaultSupplier);
        Assertions.assertEquals((int)2, (Integer)numberOfCalls.getValue());
    }

    @Test
    public void testDeleteWhitespace_String() {
        Assertions.assertNull((Object)StringUtils.deleteWhitespace(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)"  \f  \t\t\u001f\n\n \u000b  "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)WHITESPACE));
        Assertions.assertEquals((Object)NON_WHITESPACE, (Object)StringUtils.deleteWhitespace((String)NON_WHITESPACE));
        Assertions.assertEquals((Object)"\u00a0\u202f", (Object)StringUtils.deleteWhitespace((String)"  \u00a0  \t\t\n\n \u202f  "));
        Assertions.assertEquals((Object)"\u00a0\u202f", (Object)StringUtils.deleteWhitespace((String)"\u00a0\u202f"));
        Assertions.assertEquals((Object)"test", (Object)StringUtils.deleteWhitespace((String)"\u000bt  \t\n\te\rs\n\n   \tt"));
    }

    @Test
    public void testDifference_StringString() {
        Assertions.assertNull((Object)StringUtils.difference(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.difference((String)"", (String)""));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.difference((String)"", (String)"abc"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.difference((String)"abc", (String)""));
        Assertions.assertEquals((Object)"i am a robot", (Object)StringUtils.difference(null, (String)"i am a robot"));
        Assertions.assertEquals((Object)"i am a machine", (Object)StringUtils.difference((String)"i am a machine", null));
        Assertions.assertEquals((Object)"robot", (Object)StringUtils.difference((String)"i am a machine", (String)"i am a robot"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.difference((String)"abc", (String)"abc"));
        Assertions.assertEquals((Object)"you are a robot", (Object)StringUtils.difference((String)"i am a robot", (String)"you are a robot"));
    }

    @Test
    public void testDifferenceAt_StringArray() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new CharSequence[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new CharSequence[]{"abc"}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference(null, null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"", null));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new CharSequence[]{"abc", null, null}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new CharSequence[]{null, null, "abc"}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)"abc"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)"abc"));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)"a"));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfDifference((CharSequence)"ab", (CharSequence)"abxyz"));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfDifference((CharSequence)"abcde", (CharSequence)"abxyz"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"abcde", (CharSequence)"xyz"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"xyz", (CharSequence)"abcde"));
        Assertions.assertEquals((int)7, (int)StringUtils.indexOfDifference((CharSequence)"i am a machine", (CharSequence)"i am a robot"));
    }

    @Test
    public void testDifferenceAt_StringString() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference(null, null));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference(null, (CharSequence)"i am a robot"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)"abc"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"i am a machine", null));
        Assertions.assertEquals((int)7, (int)StringUtils.indexOfDifference((CharSequence)"i am a machine", (CharSequence)"i am a robot"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)FOO_UNCAP, (CharSequence)FOO_UNCAP));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"i am a robot", (CharSequence)"you are a robot"));
    }

    @Test
    public void testEMPTY() {
        Assertions.assertNotNull((Object)"");
        Assertions.assertEquals((Object)"", (Object)"");
        Assertions.assertEquals((int)0, (int)"".length());
    }

    @Test
    public void testEscapeSurrogatePairs() {
        Assertions.assertEquals((Object)"\ud83d\ude30", (Object)StringEscapeUtils.escapeCsv((String)"\ud83d\ude30"));
        Assertions.assertEquals((Object)"\ud800\udc00", (Object)StringEscapeUtils.escapeCsv((String)"\ud800\udc00"));
        Assertions.assertEquals((Object)"\ud834\udd1e", (Object)StringEscapeUtils.escapeCsv((String)"\ud834\udd1e"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeCsv((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeHtml3((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeHtml4((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeXml((String)"\udbff\udffd"));
    }

    @Test
    public void testEscapeSurrogatePairsLang858() {
        Assertions.assertEquals((Object)"\\uDBFF\\uDFFD", (Object)StringEscapeUtils.escapeJava((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\\uDBFF\\uDFFD", (Object)StringEscapeUtils.escapeEcmaScript((String)"\udbff\udffd"));
    }

    @Test
    public void testGetBytes_Charset() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)StringUtils.getBytes(null, (Charset)null));
        Assertions.assertArrayEquals((byte[])"".getBytes(), (byte[])StringUtils.getBytes((String)"", (Charset)null));
        Assertions.assertArrayEquals((byte[])"".getBytes(StandardCharsets.US_ASCII), (byte[])StringUtils.getBytes((String)"", (Charset)StandardCharsets.US_ASCII));
    }

    @Test
    public void testGetBytes_String() throws UnsupportedEncodingException {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)StringUtils.getBytes(null, (String)null));
        Assertions.assertArrayEquals((byte[])"".getBytes(), (byte[])StringUtils.getBytes((String)"", (String)null));
        Assertions.assertArrayEquals((byte[])"".getBytes(StandardCharsets.US_ASCII.name()), (byte[])StringUtils.getBytes((String)"", (String)StandardCharsets.US_ASCII.name()));
    }

    @Test
    public void testGetCommonPrefix_StringArray() {
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[0]));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{null, null}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", ""}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", null}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", null, null}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{null, null, "abc"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", "abc"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", ""}));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", "abc"}));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", "a"}));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.getCommonPrefix((String[])new String[]{"ab", "abxyz"}));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "abxyz"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "xyz"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"xyz", "abcde"}));
        Assertions.assertEquals((Object)"i am a ", (Object)StringUtils.getCommonPrefix((String[])new String[]{"i am a machine", "i am a robot"}));
    }

    @Test
    public void testGetDigits() {
        Assertions.assertNull((Object)StringUtils.getDigits(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getDigits((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.getDigits((String)"abc"));
        Assertions.assertEquals((Object)"1000", (Object)StringUtils.getDigits((String)"1000$"));
        Assertions.assertEquals((Object)"12345", (Object)StringUtils.getDigits((String)"123password45"));
        Assertions.assertEquals((Object)"5417543010", (Object)StringUtils.getDigits((String)"(541) 754-3010"));
        Assertions.assertEquals((Object)"\u0967\u0968\u0969", (Object)StringUtils.getDigits((String)"\u0967\u0968\u0969"));
    }

    @Test
    public void testGetFuzzyDistance() {
        Assertions.assertEquals((int)0, (int)StringUtils.getFuzzyDistance((CharSequence)"", (CharSequence)"", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)0, (int)StringUtils.getFuzzyDistance((CharSequence)"Workshop", (CharSequence)"b", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)1, (int)StringUtils.getFuzzyDistance((CharSequence)"Room", (CharSequence)"o", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)1, (int)StringUtils.getFuzzyDistance((CharSequence)"Workshop", (CharSequence)"w", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)2, (int)StringUtils.getFuzzyDistance((CharSequence)"Workshop", (CharSequence)"ws", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)4, (int)StringUtils.getFuzzyDistance((CharSequence)"Workshop", (CharSequence)"wo", (Locale)Locale.ENGLISH));
        Assertions.assertEquals((int)3, (int)StringUtils.getFuzzyDistance((CharSequence)"Apache Software Foundation", (CharSequence)"asf", (Locale)Locale.ENGLISH));
    }

    @Test
    public void testGetFuzzyDistance_NullNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getFuzzyDistance(null, null, null));
    }

    @Test
    public void testGetFuzzyDistance_NullStringLocale() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getFuzzyDistance(null, (CharSequence)"clear", (Locale)Locale.ENGLISH));
    }

    @Test
    public void testGetFuzzyDistance_StringNullLoclae() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getFuzzyDistance((CharSequence)" ", null, (Locale)Locale.ENGLISH));
    }

    @Test
    public void testGetFuzzyDistance_StringStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getFuzzyDistance((CharSequence)" ", (CharSequence)"clear", null));
    }

    @Test
    public void testGetJaroWinklerDistance_NullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getJaroWinklerDistance(null, null));
    }

    @Test
    public void testGetJaroWinklerDistance_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getJaroWinklerDistance(null, (CharSequence)"clear"));
    }

    @Test
    public void testGetJaroWinklerDistance_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getJaroWinklerDistance((CharSequence)" ", null));
    }

    @Test
    public void testGetJaroWinklerDistance_StringString() {
        Assertions.assertEquals((double)0.93, (double)StringUtils.getJaroWinklerDistance((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((double)0.0, (double)StringUtils.getJaroWinklerDistance((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((double)0.44, (double)StringUtils.getJaroWinklerDistance((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((double)0.84, (double)StringUtils.getJaroWinklerDistance((CharSequence)"dwayne", (CharSequence)"duane"));
        Assertions.assertEquals((double)0.93, (double)StringUtils.getJaroWinklerDistance((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((double)0.95, (double)StringUtils.getJaroWinklerDistance((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((double)0.92, (double)StringUtils.getJaroWinklerDistance((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((double)0.88, (double)StringUtils.getJaroWinklerDistance((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((double)0.63, (double)StringUtils.getJaroWinklerDistance((CharSequence)"Haus Ingeborg", (CharSequence)"Ingeborg Esser"));
    }

    @Test
    public void testGetLevenshteinDistance_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance((CharSequence)"a", null));
    }

    @Test
    public void testGetLevenshteinDistance_NullStringInt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance(null, (CharSequence)"a", (int)0));
    }

    @Test
    public void testGetLevenshteinDistance_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance(null, (CharSequence)"a"));
    }

    @Test
    public void testGetLevenshteinDistance_StringNullInt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance((CharSequence)"a", null, (int)0));
    }

    @Test
    public void testGetLevenshteinDistance_StringString() {
        Assertions.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"a"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)""));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant"));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz"));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo"));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo"));
    }

    @Test
    public void testGetLevenshteinDistance_StringStringInt() {
        Assertions.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)8));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"b", (CharSequence)"a", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"b", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)2));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)3));
        Assertions.assertEquals((int)6, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaaaaa", (CharSequence)"b", (int)10));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)8));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)4));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)7));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)3));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"12345", (CharSequence)"1234567", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"1234567", (CharSequence)"12345", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog", (int)1));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant", (int)3));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)6));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)6));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz", (int)8));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo", (int)8));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo", (int)Integer.MAX_VALUE));
    }

    @Test
    public void testGetLevenshteinDistance_StringStringNegativeInt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"a", (int)-1));
    }

    @Test
    public void testIsAllLowerCase() {
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase(null));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"  "));
        Assertions.assertTrue((boolean)StringUtils.isAllLowerCase((CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abc "));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abc\n"));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abC"));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"ab c"));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"ab1c"));
        Assertions.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"ab/c"));
    }

    @Test
    public void testIsAllUpperCase() {
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase(null));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"  "));
        Assertions.assertTrue((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC"));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC "));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC\n"));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"aBC"));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"A C"));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"A1C"));
        Assertions.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"A/C"));
    }

    @Test
    public void testIsMixedCase() {
        Assertions.assertFalse((boolean)StringUtils.isMixedCase(null));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"A"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"/"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"A/"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"/b"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.isMixedCase((CharSequence)"ABC"));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"aBc"));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"aBc "));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"A c"));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"aBc\n"));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"A1c"));
        Assertions.assertTrue((boolean)StringUtils.isMixedCase((CharSequence)"a/C"));
    }

    @Test
    public void testJoin_ArrayCharSeparator() {
        Assertions.assertNull((Object)StringUtils.join((Object[])null, (char)','));
        Assertions.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join((Object[])ARRAY_LIST, (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (char)';'));
        Assertions.assertEquals((Object)";;foo", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)';'));
        Assertions.assertEquals((Object)"foo;2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)';'));
        Assertions.assertNull((Object)StringUtils.join((Object[])null, (char)',', (int)0, (int)1));
        Assertions.assertEquals((Object)"/", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)'/', (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)1));
        Assertions.assertEquals((Object)"null", (Object)StringUtils.join((Object[])NULL_TO_STRING_LIST, (char)'/', (int)0, (int)1));
        Assertions.assertEquals((Object)"foo/2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)2));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)2, (int)1));
    }

    @Test
    public void testJoin_ArrayOfBytes() {
        Assertions.assertNull((Object)StringUtils.join((byte[])null, (char)','));
        Assertions.assertEquals((Object)"1;2", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((byte[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfBooleans() {
        Assertions.assertNull((Object)StringUtils.join((boolean[])null, (char)','));
        Assertions.assertEquals((Object)"false;false", (Object)StringUtils.join((boolean[])ARRAY_FALSE_FALSE, (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((boolean[])EMPTY, (char)';'));
        Assertions.assertEquals((Object)"false,true,false", (Object)StringUtils.join((boolean[])ARRAY_FALSE_TRUE_FALSE, (char)','));
        Assertions.assertEquals((Object)"true", (Object)StringUtils.join((boolean[])ARRAY_FALSE_TRUE, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((boolean[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((boolean[])ARRAY_FALSE_FALSE, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((boolean[])ARRAY_FALSE_TRUE_FALSE, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfChars() {
        Assertions.assertNull((Object)StringUtils.join((char[])null, (char)','));
        Assertions.assertEquals((Object)"1;2", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((char[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfDoubles() {
        Assertions.assertNull((Object)StringUtils.join((double[])null, (char)','));
        Assertions.assertEquals((Object)"1.0;2.0", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2.0", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((double[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfFloats() {
        Assertions.assertNull((Object)StringUtils.join((float[])null, (char)','));
        Assertions.assertEquals((Object)"1.0;2.0", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2.0", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((float[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfInts() {
        Assertions.assertNull((Object)StringUtils.join((int[])null, (char)','));
        Assertions.assertEquals((Object)"1;2", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((int[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfLongs() {
        Assertions.assertNull((Object)StringUtils.join((long[])null, (char)','));
        Assertions.assertEquals((Object)"1;2", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((long[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayOfShorts() {
        Assertions.assertNull((Object)StringUtils.join((short[])null, (char)','));
        Assertions.assertEquals((Object)"1;2", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';'));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';', (int)1, (int)2));
        Assertions.assertNull((Object)StringUtils.join((short[])null, (char)';', (int)0, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';', (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';', (int)1, (int)0));
    }

    @Test
    public void testJoin_ArrayString_EmptyDelimiter() {
        Assertions.assertNull((Object)StringUtils.join((Object[])null, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join((Object[])ARRAY_LIST, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join((Object[])ARRAY_LIST, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])NULL_ARRAY_LIST, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)"", (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
    }

    @ParameterizedTest
    @ValueSource(strings={",", ";", "\ud840\udc00", "\ud840\udc01"})
    public void testJoin_ArrayString_NonEmptyDelimiter(String delimiter) {
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)delimiter));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, ARRAY_LIST), (Object)StringUtils.join((Object[])ARRAY_LIST, (String)delimiter));
        Assertions.assertEquals((Object)(delimiter + delimiter + FOO_UNCAP), (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)delimiter));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, FOO_UNCAP, "2"), (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)delimiter));
        Assertions.assertEquals((Object)delimiter, (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)delimiter, (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)delimiter, (int)0, (int)1));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, FOO_UNCAP, "2"), (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)delimiter, (int)0, (int)2));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)delimiter, (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)delimiter, (int)2, (int)1));
    }

    @Test
    public void testJoin_IterableChar() {
        Assertions.assertNull((Object)StringUtils.join((Iterable)null, (char)','));
        Assertions.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (char)';'));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), (char)'x'));
    }

    @Test
    public void testJoin_IterableString() {
        Assertions.assertNull((Object)StringUtils.join((Iterable)null, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)""));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), (String)"x"));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)SEPARATOR));
        Assertions.assertEquals((Object)TEXT_LIST, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)SEPARATOR));
    }

    @Test
    public void testJoin_IteratorChar() {
        Assertions.assertNull((Object)StringUtils.join((Iterator)null, (char)','));
        Assertions.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), (char)';'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (char)';'));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (char)'x'));
        Assertions.assertEquals((Object)"null", (Object)StringUtils.join(Arrays.asList(NULL_TO_STRING_LIST).iterator(), (char)';'));
    }

    @Test
    public void testJoin_IteratorString() {
        Assertions.assertNull((Object)StringUtils.join((Iterator)null, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)""));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (String)"x"));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)SEPARATOR));
        Assertions.assertEquals((Object)TEXT_LIST, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)SEPARATOR));
        Assertions.assertEquals((Object)"null", (Object)StringUtils.join(Arrays.asList(NULL_TO_STRING_LIST).iterator(), (String)SEPARATOR));
    }

    @Test
    public void testJoin_List_EmptyDelimiter() {
        Assertions.assertNull((Object)StringUtils.join((Iterable)null, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(STRING_LIST, null));
        Assertions.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(STRING_LIST, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(NULL_STRING_LIST, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(EMPTY_STRING_LIST, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(EMPTY_STRING_LIST, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(MIXED_STRING_LIST, (String)"", (int)0, (int)(MIXED_STRING_LIST.size() - 1)));
    }

    @Test
    public void testJoin_List_CharDelimiter() {
        Assertions.assertEquals((Object)"/", (Object)StringUtils.join(MIXED_STRING_LIST, (char)'/', (int)0, (int)(MIXED_STRING_LIST.size() - 1)));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (char)'/', (int)0, (int)1));
        Assertions.assertEquals((Object)"foo/2", (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (char)'/', (int)0, (int)2));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (char)'/', (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (char)'/', (int)2, (int)1));
        Assertions.assertNull(null, (String)StringUtils.join((List)null, (char)'/', (int)0, (int)1));
    }

    @ParameterizedTest
    @ValueSource(strings={",", ";", "\ud840\udc00", "\ud840\udc01"})
    public void testJoin_List_NonEmptyDelimiter(String delimiter) {
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(EMPTY_STRING_LIST, (String)delimiter));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, STRING_LIST), (Object)StringUtils.join(STRING_LIST, (String)delimiter));
        Assertions.assertEquals((Object)(delimiter + delimiter + FOO_UNCAP), (Object)StringUtils.join(MIXED_STRING_LIST, (String)delimiter));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, FOO_UNCAP, "2"), (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (String)delimiter));
        Assertions.assertEquals((Object)delimiter, (Object)StringUtils.join(MIXED_STRING_LIST, (String)delimiter, (int)0, (int)(MIXED_STRING_LIST.size() - 1)));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (String)delimiter, (int)0, (int)1));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, FOO_UNCAP, "2"), (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (String)delimiter, (int)0, (int)2));
        Assertions.assertEquals((Object)"2", (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (String)delimiter, (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join(MIXED_TYPE_OBJECT_LIST, (String)delimiter, (int)2, (int)1));
        Assertions.assertNull(null, (String)StringUtils.join((List)null, (String)delimiter, (int)0, (int)1));
    }

    @Test
    public void testJoin_Objectarray() {
        Assertions.assertNull((Object)StringUtils.join((Object[])null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])new Object[0]));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])new Object[]{null}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST));
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])NULL_ARRAY_LIST));
        Assertions.assertEquals((Object)"null", (Object)StringUtils.join((Object[])NULL_TO_STRING_LIST));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.join((Object[])new String[]{null, "a", ""}));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST));
        Assertions.assertEquals((Object)"foo2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST));
    }

    @Disabled
    @Test
    public void testLang1593() {
        int[] arr = new int[]{1, 2, 3, 4, 5, 6, 7};
        String expected = StringUtils.join((int[])arr, (char)'-');
        String actual = StringUtils.join((Object[])new Serializable[]{arr, "-"});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testJoin_Objects() {
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.join((Object[])new String[]{null, "", "a"}));
        Assertions.assertNull((Object)StringUtils.join((Object[])null));
    }

    @ParameterizedTest
    @ValueSource(strings={",", ";", "\ud840\udc00", "\ud840\udc01"})
    public void testJoinWith(String delimiter) {
        Assertions.assertEquals((Object)"", (Object)StringUtils.joinWith((String)delimiter, (Object[])new Object[0]));
        Assertions.assertEquals((Object)"", (Object)StringUtils.joinWith((String)delimiter, (Object[])NULL_ARRAY_LIST));
        Assertions.assertEquals((Object)"null", (Object)StringUtils.joinWith((String)delimiter, (Object[])NULL_TO_STRING_LIST));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, "a", "b", "c"), (Object)StringUtils.joinWith((String)delimiter, (Object[])new Object[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, "", "a", ""), (Object)StringUtils.joinWith((String)delimiter, (Object[])new Object[]{null, "a", ""}));
        Assertions.assertEquals((Object)String.join((CharSequence)delimiter, "", "a", ""), (Object)StringUtils.joinWith((String)delimiter, (Object[])new Object[]{"", "a", ""}));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.joinWith(null, (Object[])new Object[]{"a", "b"}));
    }

    @Test
    public void testJoinWithThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.joinWith((String)SEPARATOR, (Object[])null));
    }

    @Test
    public void testLang623() {
        Assertions.assertEquals((Object)"t", (Object)StringUtils.replaceChars((String)"\u00de", (char)'\u00de', (char)'t'));
        Assertions.assertEquals((Object)"t", (Object)StringUtils.replaceChars((String)"\u00fe", (char)'\u00fe', (char)'t'));
    }

    @Test
    public void testLANG666() {
        Assertions.assertEquals((Object)"12", (Object)StringUtils.stripEnd((String)"120.00", (String)".0"));
        Assertions.assertEquals((Object)"121", (Object)StringUtils.stripEnd((String)"121.00", (String)".0"));
    }

    @Test
    public void testLeftPad_StringInt() {
        Assertions.assertNull((Object)StringUtils.leftPad(null, (int)5));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2));
    }

    @Test
    public void testLeftPad_StringIntChar() {
        Assertions.assertNull((Object)StringUtils.leftPad(null, (int)5, (char)' '));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5, (char)' '));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)' '));
        Assertions.assertEquals((Object)"xxabc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)'x'));
        Assertions.assertEquals((Object)"\uffff\uffffabc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)'\uffff'));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2, (char)' '));
        String str = StringUtils.leftPad((String)"aaa", (int)10000, (char)'a');
        Assertions.assertEquals((int)10000, (int)str.length());
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testLeftPad_StringIntString() {
        Assertions.assertNull((Object)StringUtils.leftPad(null, (int)5, (String)"-+"));
        Assertions.assertNull((Object)StringUtils.leftPad(null, (int)5, null));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5, (String)" "));
        Assertions.assertEquals((Object)"-+-+abc", (Object)StringUtils.leftPad((String)"abc", (int)7, (String)"-+"));
        Assertions.assertEquals((Object)"-+~abc", (Object)StringUtils.leftPad((String)"abc", (int)6, (String)"-+~"));
        Assertions.assertEquals((Object)"-+abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (String)"-+~"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2, (String)" "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)-1, (String)" "));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, null));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (String)""));
    }

    @Test
    public void testLength_CharBuffer() {
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)CharBuffer.wrap("")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)CharBuffer.wrap("A")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)CharBuffer.wrap(" ")));
        Assertions.assertEquals((int)8, (int)StringUtils.length((CharSequence)CharBuffer.wrap("ABCDEFGH")));
    }

    @Test
    public void testLengthString() {
        Assertions.assertEquals((int)0, (int)StringUtils.length(null));
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)""));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)"A"));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)" "));
        Assertions.assertEquals((int)8, (int)StringUtils.length((CharSequence)"ABCDEFGH"));
    }

    @Test
    public void testLengthStringBuffer() {
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuffer("")));
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuffer("")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuffer("A")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuffer(" ")));
        Assertions.assertEquals((int)8, (int)StringUtils.length((CharSequence)new StringBuffer("ABCDEFGH")));
    }

    @Test
    public void testLengthStringBuilder() {
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuilder("")));
        Assertions.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuilder("")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuilder("A")));
        Assertions.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuilder(" ")));
        Assertions.assertEquals((int)8, (int)StringUtils.length((CharSequence)new StringBuilder("ABCDEFGH")));
    }

    @Test
    public void testLowerCase() {
        Assertions.assertNull((Object)StringUtils.lowerCase(null));
        Assertions.assertNull((Object)StringUtils.lowerCase(null, (Locale)Locale.ENGLISH));
        Assertions.assertEquals((Object)"foo test thing", (Object)StringUtils.lowerCase((String)"fOo test THING"), (String)"lowerCase(String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.lowerCase((String)""), (String)"lowerCase(empty-string) failed");
        Assertions.assertEquals((Object)"foo test thing", (Object)StringUtils.lowerCase((String)"fOo test THING", (Locale)Locale.ENGLISH), (String)"lowerCase(String, Locale) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.lowerCase((String)"", (Locale)Locale.ENGLISH), (String)"lowerCase(empty-string, Locale) failed");
    }

    @Test
    public void testNormalizeSpace() {
        Assertions.assertFalse((boolean)Character.isWhitespace('\u00a0'));
        Assertions.assertNull((Object)StringUtils.normalizeSpace(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\t"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\n"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\t"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u000b"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\f"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001c"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001d"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001e"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001f"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\f"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\r"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.normalizeSpace((String)"  a  "));
        Assertions.assertEquals((Object)"a b c", (Object)StringUtils.normalizeSpace((String)"  a  b   c  "));
        Assertions.assertEquals((Object)"a b c", (Object)StringUtils.normalizeSpace((String)"a\t\f\r  b\u000b   c\n"));
        Assertions.assertEquals((Object)"a   b c", (Object)StringUtils.normalizeSpace((String)("a\t\f\r  " + HARD_SPACE + HARD_SPACE + "b\u000b   c\n")));
        Assertions.assertEquals((Object)"b", (Object)StringUtils.normalizeSpace((String)"\u0000b"));
        Assertions.assertEquals((Object)"b", (Object)StringUtils.normalizeSpace((String)"b\u0000"));
    }

    @Test
    public void testOverlay_StringStringIntInt() {
        Assertions.assertNull((Object)StringUtils.overlay(null, null, (int)2, (int)4));
        Assertions.assertNull((Object)StringUtils.overlay(null, null, (int)-2, (int)-4));
        Assertions.assertEquals((Object)"", (Object)StringUtils.overlay((String)"", null, (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.overlay((String)"", (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)0, (int)0));
        Assertions.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)2, (int)4));
        Assertions.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)-2, (int)-4));
        Assertions.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", null, (int)2, (int)4));
        Assertions.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", null, (int)4, (int)2));
        Assertions.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", (String)"", (int)2, (int)4));
        Assertions.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", (String)"", (int)4, (int)2));
        Assertions.assertEquals((Object)"abzzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)2, (int)4));
        Assertions.assertEquals((Object)"abzzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)2));
        Assertions.assertEquals((Object)"zzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)4));
        Assertions.assertEquals((Object)"zzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)-1));
        Assertions.assertEquals((Object)"zzzzabcdef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-2, (int)-1));
        Assertions.assertEquals((Object)"zzzzabcdef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)-2));
        Assertions.assertEquals((Object)"abcdzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)10));
        Assertions.assertEquals((Object)"abcdzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)4));
        Assertions.assertEquals((Object)"abcdefzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)8, (int)10));
        Assertions.assertEquals((Object)"abcdefzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)8));
    }

    @Test
    public void testPrependIfMissing() {
        Assertions.assertNull((Object)StringUtils.prependIfMissing(null, null, (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", null, (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(abc,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.prependIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(\"\",xyz)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(abc,xyz)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(xyzabc,xyz)");
        Assertions.assertEquals((Object)"xyzXYZabc", (Object)StringUtils.prependIfMissing((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissing(XYZabc,xyz)");
        Assertions.assertNull((Object)StringUtils.prependIfMissing(null, null, (CharSequence[])null), (String)"prependIfMissing(null,null null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", null, (CharSequence[])null), (String)"prependIfMissing(abc,null,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.prependIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])null), (String)"prependIfMissing(\"\",xyz,null)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", null), (String)"prependIfMissing(abc,xyz,{null})");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}), (String)"prependIfMissing(abc,xyz,\"\")");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissing(abc,xyz,mno)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissing(xyzabc,xyz,mno)");
        Assertions.assertEquals((Object)"mnoabc", (Object)StringUtils.prependIfMissing((String)"mnoabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissing(mnoabc,xyz,mno)");
        Assertions.assertEquals((Object)"xyzXYZabc", (Object)StringUtils.prependIfMissing((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissing(XYZabc,xyz,mno)");
        Assertions.assertEquals((Object)"xyzMNOabc", (Object)StringUtils.prependIfMissing((String)"MNOabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissing(MNOabc,xyz,mno)");
    }

    @Test
    public void testPrependIfMissingIgnoreCase() {
        Assertions.assertNull((Object)StringUtils.prependIfMissingIgnoreCase(null, null, (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(null,null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", null, (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(abc,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.prependIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(\"\",xyz)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(abc,xyz)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(xyzabc,xyz)");
        Assertions.assertEquals((Object)"XYZabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]), (String)"prependIfMissingIgnoreCase(XYZabc,xyz)");
        Assertions.assertNull((Object)StringUtils.prependIfMissingIgnoreCase(null, null, (CharSequence[])null), (String)"prependIfMissingIgnoreCase(null,null null)");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", null, (CharSequence[])null), (String)"prependIfMissingIgnoreCase(abc,null,null)");
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.prependIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])null), (String)"prependIfMissingIgnoreCase(\"\",xyz,null)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", null), (String)"prependIfMissingIgnoreCase(abc,xyz,{null})");
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}), (String)"prependIfMissingIgnoreCase(abc,xyz,\"\")");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissingIgnoreCase(abc,xyz,mno)");
        Assertions.assertEquals((Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissingIgnoreCase(xyzabc,xyz,mno)");
        Assertions.assertEquals((Object)"mnoabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"mnoabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissingIgnoreCase(mnoabc,xyz,mno)");
        Assertions.assertEquals((Object)"XYZabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissingIgnoreCase(XYZabc,xyz,mno)");
        Assertions.assertEquals((Object)"MNOabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"MNOabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}), (String)"prependIfMissingIgnoreCase(MNOabc,xyz,mno)");
    }

    @Test
    public void testReCapitalize() {
        Assertions.assertEquals((Object)SENTENCE_UNCAP, (Object)StringUtils.uncapitalize((String)StringUtils.capitalize((String)SENTENCE_UNCAP)), (String)"uncapitalize(capitalize(String)) failed");
        Assertions.assertEquals((Object)SENTENCE_CAP, (Object)StringUtils.capitalize((String)StringUtils.uncapitalize((String)SENTENCE_CAP)), (String)"capitalize(uncapitalize(String)) failed");
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)StringUtils.capitalize((String)FOO_UNCAP)), (String)"uncapitalize(capitalize(String)) failed");
        Assertions.assertEquals((Object)FOO_CAP, (Object)StringUtils.capitalize((String)StringUtils.uncapitalize((String)FOO_CAP)), (String)"capitalize(uncapitalize(String)) failed");
    }

    @Test
    public void testRemove_char() {
        Assertions.assertNull((Object)StringUtils.remove(null, null));
        Assertions.assertNull((Object)StringUtils.remove(null, (char)'a'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (char)'a'));
        Assertions.assertEquals((Object)"qeed", (Object)StringUtils.remove((String)"queued", (char)'u'));
        Assertions.assertEquals((Object)"queued", (Object)StringUtils.remove((String)"queued", (char)'z'));
    }

    @Test
    public void testRemove_String() {
        Assertions.assertNull((Object)StringUtils.remove(null, null));
        Assertions.assertNull((Object)StringUtils.remove(null, (String)""));
        Assertions.assertNull((Object)StringUtils.remove(null, (String)"a"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)"a"));
        Assertions.assertNull((Object)StringUtils.remove(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", null));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.remove((String)"a", null));
        Assertions.assertNull((Object)StringUtils.remove(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)""));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.remove((String)"a", (String)""));
        Assertions.assertEquals((Object)"qd", (Object)StringUtils.remove((String)"queued", (String)"ue"));
        Assertions.assertEquals((Object)"queued", (Object)StringUtils.remove((String)"queued", (String)"zz"));
    }

    @Test
    public void testRemoveAll_StringString() {
        Assertions.assertNull((Object)StringUtils.removeAll(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.removeAll((String)"any", null));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.removeAll((String)"any", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeAll((String)"any", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeAll((String)"any", (String)".+"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeAll((String)"any", (String)".?"));
        Assertions.assertEquals((Object)"A\nB", (Object)StringUtils.removeAll((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)StringUtils.removeAll((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assertions.assertEquals((Object)"ABC123", (Object)StringUtils.removeAll((String)"ABCabc123abc", (String)"[a-z]"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> StringUtils.removeAll((String)"any", (String)"{badRegexSyntax}"), (String)"StringUtils.removeAll expecting PatternSyntaxException");
    }

    @Test
    public void testRemoveEnd() {
        Assertions.assertNull((Object)StringUtils.removeEnd(null, null));
        Assertions.assertNull((Object)StringUtils.removeEnd(null, (String)""));
        Assertions.assertNull((Object)StringUtils.removeEnd(null, (String)"a"));
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"", null), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"", (String)""), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"", (String)"a"), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"www.domain.com.", (String)".com"), (Object)"www.domain.com.");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"www.domain.com", (String)".com"), (Object)"www.domain");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"www.domain", (String)".com"), (Object)"www.domain");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"domain.com", (String)""), (Object)"domain.com");
        Assertions.assertEquals((Object)StringUtils.removeEnd((String)"domain.com", null), (Object)"domain.com");
    }

    @Test
    public void testRemoveEndIgnoreCase() {
        Assertions.assertNull((Object)StringUtils.removeEndIgnoreCase(null, null), (String)"removeEndIgnoreCase(null, null)");
        Assertions.assertNull((Object)StringUtils.removeEndIgnoreCase(null, (String)""), (String)"removeEndIgnoreCase(null, \"\")");
        Assertions.assertNull((Object)StringUtils.removeEndIgnoreCase(null, (String)"a"), (String)"removeEndIgnoreCase(null, \"a\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"", null), (Object)"", (String)"removeEndIgnoreCase(\"\", null)");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"", (String)""), (Object)"", (String)"removeEndIgnoreCase(\"\", \"\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"", (String)"a"), (Object)"", (String)"removeEndIgnoreCase(\"\", \"a\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com.", (String)".com"), (Object)"www.domain.com.", (String)"removeEndIgnoreCase(\"www.domain.com.\", \".com\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".com"), (Object)"www.domain", (String)"removeEndIgnoreCase(\"www.domain.com\", \".com\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"www.domain", (String)".com"), (Object)"www.domain", (String)"removeEndIgnoreCase(\"www.domain\", \".com\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"domain.com", (String)""), (Object)"domain.com", (String)"removeEndIgnoreCase(\"domain.com\", \"\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"domain.com", null), (Object)"domain.com", (String)"removeEndIgnoreCase(\"domain.com\", null)");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".COM"), (Object)"www.domain", (String)"removeEndIgnoreCase(\"www.domain.com\", \".COM\")");
        Assertions.assertEquals((Object)StringUtils.removeEndIgnoreCase((String)"www.domain.COM", (String)".com"), (Object)"www.domain", (String)"removeEndIgnoreCase(\"www.domain.COM\", \".com\")");
    }

    @Test
    public void testRemoveFirst_StringString() {
        Assertions.assertNull((Object)StringUtils.removeFirst(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.removeFirst((String)"any", null));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.removeFirst((String)"any", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeFirst((String)"any", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeFirst((String)"any", (String)".+"));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.removeFirst((String)"abc", (String)".?"));
        Assertions.assertEquals((Object)"A\n<__>B", (Object)StringUtils.removeFirst((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)StringUtils.removeFirst((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assertions.assertEquals((Object)"ABCbc123", (Object)StringUtils.removeFirst((String)"ABCabc123", (String)"[a-z]"));
        Assertions.assertEquals((Object)"ABC123abc", (Object)StringUtils.removeFirst((String)"ABCabc123abc", (String)"[a-z]+"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> StringUtils.removeFirst((String)"any", (String)"{badRegexSyntax}"), (String)"StringUtils.removeFirst expecting PatternSyntaxException");
    }

    @Test
    public void testRemoveIgnoreCase_String() {
        Assertions.assertNull((Object)StringUtils.removeIgnoreCase(null, null));
        Assertions.assertNull((Object)StringUtils.removeIgnoreCase(null, (String)""));
        Assertions.assertNull((Object)StringUtils.removeIgnoreCase(null, (String)"a"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeIgnoreCase((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeIgnoreCase((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeIgnoreCase((String)"", (String)"a"));
        Assertions.assertNull((Object)StringUtils.removeIgnoreCase(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeIgnoreCase((String)"", null));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.removeIgnoreCase((String)"a", null));
        Assertions.assertNull((Object)StringUtils.removeIgnoreCase(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removeIgnoreCase((String)"", (String)""));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.removeIgnoreCase((String)"a", (String)""));
        Assertions.assertEquals((Object)"qd", (Object)StringUtils.removeIgnoreCase((String)"queued", (String)"ue"));
        Assertions.assertEquals((Object)"queued", (Object)StringUtils.removeIgnoreCase((String)"queued", (String)"zz"));
        Assertions.assertEquals((Object)"qd", (Object)StringUtils.removeIgnoreCase((String)"quEUed", (String)"UE"));
        Assertions.assertEquals((Object)"queued", (Object)StringUtils.removeIgnoreCase((String)"queued", (String)"zZ"));
        Assertions.assertEquals((Object)"\u0130", (Object)StringUtils.removeIgnoreCase((String)"\u0130x", (String)"x"));
        StringUtils.removeIgnoreCase((String)"\u0130a", (String)"a");
    }

    @Test
    public void testRemovePattern_StringString() {
        Assertions.assertNull((Object)StringUtils.removePattern(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.removePattern((String)"any", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"", (String)".+"));
        Assertions.assertEquals((Object)"AB", (Object)StringUtils.removePattern((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)StringUtils.removePattern((String)"A<__>\\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"<A>x\\ny</A>", (String)"<A>.*</A>"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>"));
        Assertions.assertEquals((Object)"ABC123", (Object)StringUtils.removePattern((String)"ABCabc123", (String)"[a-z]"));
    }

    @Test
    public void testRemoveStartChar() {
        Assertions.assertNull((Object)StringUtils.removeStart(null, (char)'\u0000'));
        Assertions.assertNull((Object)StringUtils.removeStart(null, (char)'a'));
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"", (char)'\u0000'), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"", (char)'a'), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"/path", (char)'/'), (Object)"path");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"path", (char)'/'), (Object)"path");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"path", (char)'\u0000'), (Object)"path");
    }

    @Test
    public void testRemoveStartString() {
        Assertions.assertNull((Object)StringUtils.removeStart(null, null));
        Assertions.assertNull((Object)StringUtils.removeStart(null, (String)""));
        Assertions.assertNull((Object)StringUtils.removeStart(null, (String)"a"));
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"", null), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"", (String)""), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"", (String)"a"), (Object)"");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"www.domain.com", (String)"www."), (Object)"domain.com");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"domain.com", (String)"www."), (Object)"domain.com");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"domain.com", (String)""), (Object)"domain.com");
        Assertions.assertEquals((Object)StringUtils.removeStart((String)"domain.com", null), (Object)"domain.com");
    }

    @Test
    public void testRemoveStartIgnoreCase() {
        Assertions.assertNull((Object)StringUtils.removeStartIgnoreCase(null, null), (String)"removeStartIgnoreCase(null, null)");
        Assertions.assertNull((Object)StringUtils.removeStartIgnoreCase(null, (String)""), (String)"removeStartIgnoreCase(null, \"\")");
        Assertions.assertNull((Object)StringUtils.removeStartIgnoreCase(null, (String)"a"), (String)"removeStartIgnoreCase(null, \"a\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"", null), (Object)"", (String)"removeStartIgnoreCase(\"\", null)");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"", (String)""), (Object)"", (String)"removeStartIgnoreCase(\"\", \"\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"", (String)"a"), (Object)"", (String)"removeStartIgnoreCase(\"\", \"a\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"www."), (Object)"domain.com", (String)"removeStartIgnoreCase(\"www.domain.com\", \"www.\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)"www."), (Object)"domain.com", (String)"removeStartIgnoreCase(\"domain.com\", \"www.\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)""), (Object)"domain.com", (String)"removeStartIgnoreCase(\"domain.com\", \"\")");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"domain.com", null), (Object)"domain.com", (String)"removeStartIgnoreCase(\"domain.com\", null)");
        Assertions.assertEquals((Object)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"WWW."), (Object)"domain.com", (String)"removeStartIgnoreCase(\"www.domain.com\", \"WWW.\")");
    }

    @Test
    public void testRepeat_CharInt() {
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.repeat((char)'z', (int)3));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((char)'z', (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((char)'z', (int)-2));
    }

    @Test
    public void testRepeat_StringInt() {
        Assertions.assertNull((Object)StringUtils.repeat(null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"ab", (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)3));
        Assertions.assertEquals((Object)"aaa", (Object)StringUtils.repeat((String)"a", (int)3));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"a", (int)-2));
        Assertions.assertEquals((Object)"ababab", (Object)StringUtils.repeat((String)"ab", (int)3));
        Assertions.assertEquals((Object)"abcabcabc", (Object)StringUtils.repeat((String)"abc", (int)3));
        String str = StringUtils.repeat((String)"a", (int)10000);
        Assertions.assertEquals((int)10000, (int)str.length());
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testRepeat_StringStringInt() {
        Assertions.assertNull((Object)StringUtils.repeat(null, null, (int)2));
        Assertions.assertNull((Object)StringUtils.repeat(null, (String)"x", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"ab", (String)"", (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (String)"", (int)2));
        Assertions.assertEquals((Object)"xx", (Object)StringUtils.repeat((String)"", (String)"x", (int)3));
        Assertions.assertEquals((Object)"?, ?, ?", (Object)StringUtils.repeat((String)"?", (String)", ", (int)3));
    }

    @Test
    public void testReplace_StringStringArrayStringArray() {
        Assertions.assertNull((Object)StringUtils.replaceEach(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}), (Object)"");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", null, null), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[0], null), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", null, (String[])new String[0]), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, null), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}), (Object)"b");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}), (Object)"wcte");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}), (Object)"dcte");
        Assertions.assertEquals((Object)"bcc", (Object)StringUtils.replaceEach((String)"abc", (String[])new String[]{"a", "b"}, (String[])new String[]{"b", "c"}));
        Assertions.assertEquals((Object)"q651.506bera", (Object)StringUtils.replaceEach((String)"d216.102oren", (String[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, (String[])new String[]{"n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "5", "6", "7", "8", "9", "1", "2", "3", "4"}));
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{null}), (Object)"aba");
        Assertions.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a", "b"}, (String[])new String[]{"c", null}), (Object)"cbc");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.replaceEach((String)"abba", (String[])new String[]{"a"}, (String[])new String[]{"b", "a"}), (String)"StringUtils.replaceEach(String, String[], String[]) expecting IllegalArgumentException");
    }

    @Test
    public void testReplace_StringStringArrayStringArrayBoolean() {
        Assertions.assertNull((Object)StringUtils.replaceEachRepeatedly(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceEachRepeatedly((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        Assertions.assertEquals((Object)"aba", (Object)StringUtils.replaceEachRepeatedly((String)"aba", null, null));
        Assertions.assertEquals((Object)"aba", (Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null));
        Assertions.assertEquals((Object)"aba", (Object)StringUtils.replaceEachRepeatedly((String)"aba", null, (String[])new String[0]));
        Assertions.assertEquals((Object)"aba", (Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null));
        Assertions.assertEquals((Object)"b", (Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}));
        Assertions.assertEquals((Object)"aba", (Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}));
        Assertions.assertEquals((Object)"wcte", (Object)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}));
        Assertions.assertEquals((Object)"tcte", (Object)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}));
        Assertions.assertEquals((Object)"blaan", (Object)StringUtils.replaceEachRepeatedly((String)"blllaan", (String[])new String[]{"llaan"}, (String[])new String[]{"laan"}));
        Assertions.assertThrows(IllegalStateException.class, () -> StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "ab"}), (String)"Should be a circular reference");
    }

    @Test
    public void testReplace_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replace(null, null, null));
        Assertions.assertNull((Object)StringUtils.replace(null, null, (String)"any"));
        Assertions.assertNull((Object)StringUtils.replace(null, (String)"any", null));
        Assertions.assertNull((Object)StringUtils.replace(null, (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", (String)"", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", null, (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", (String)"F", null));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
        Assertions.assertEquals((Object)"barbarbar", (Object)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)"bar"));
        Assertions.assertEquals((Object)"farfarfar", (Object)StringUtils.replace((String)"foofoofoo", (String)"oo", (String)"ar"));
    }

    @Test
    public void testReplace_StringStringStringInt() {
        Assertions.assertNull((Object)StringUtils.replace(null, null, null, (int)2));
        Assertions.assertNull((Object)StringUtils.replace(null, null, (String)"any", (int)2));
        Assertions.assertNull((Object)StringUtils.replace(null, (String)"any", null, (int)2));
        Assertions.assertNull((Object)StringUtils.replace(null, (String)"any", (String)"any", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, (String)"any", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", (String)"any", (int)2));
        String str = new String(new char[]{'o', 'o', 'f', 'o', 'o'});
        Assertions.assertSame((Object)str, (Object)StringUtils.replace((String)str, (String)"x", (String)"", (int)-1));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-1));
        Assertions.assertEquals((Object)"oofoo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)0));
        Assertions.assertEquals((Object)"ofoo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)2));
        Assertions.assertEquals((Object)"fo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)3));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)4));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-5));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1000));
    }

    @Test
    public void testReplaceAll_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceAll(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replaceAll((String)"any", null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replaceAll((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replaceAll((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replaceAll((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceAll((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"ZZaZZbZZcZZ", (Object)StringUtils.replaceAll((String)"abc", (String)"", (String)"ZZ"));
        Assertions.assertEquals((Object)"z\nz", (Object)StringUtils.replaceAll((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)StringUtils.replaceAll((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assertions.assertEquals((Object)"ABC___123", (Object)StringUtils.replaceAll((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123", (Object)StringUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123", (Object)StringUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)StringUtils.replaceAll((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> StringUtils.replaceAll((String)"any", (String)"{badRegexSyntax}", (String)""), (String)"StringUtils.replaceAll expecting PatternSyntaxException");
    }

    @Test
    public void testReplaceChars_StringCharChar() {
        Assertions.assertNull((Object)StringUtils.replaceChars(null, (char)'b', (char)'z'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (char)'b', (char)'z'));
        Assertions.assertEquals((Object)"azcza", (Object)StringUtils.replaceChars((String)"abcba", (char)'b', (char)'z'));
        Assertions.assertEquals((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (char)'x', (char)'z'));
    }

    @Test
    public void testReplaceChars_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceChars(null, null, null));
        Assertions.assertNull((Object)StringUtils.replaceChars(null, (String)"", null));
        Assertions.assertNull((Object)StringUtils.replaceChars(null, (String)"a", null));
        Assertions.assertNull((Object)StringUtils.replaceChars(null, null, (String)""));
        Assertions.assertNull((Object)StringUtils.replaceChars(null, null, (String)"x"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (String)"a", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, (String)"x"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, null));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, (String)""));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, (String)"x"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", null));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", (String)""));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", (String)"x"));
        Assertions.assertEquals((Object)"ac", (Object)StringUtils.replaceChars((String)"abc", (String)"b", null));
        Assertions.assertEquals((Object)"ac", (Object)StringUtils.replaceChars((String)"abc", (String)"b", (String)""));
        Assertions.assertEquals((Object)"axc", (Object)StringUtils.replaceChars((String)"abc", (String)"b", (String)"x"));
        Assertions.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        Assertions.assertEquals((Object)"ayya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        Assertions.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        Assertions.assertEquals((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        Assertions.assertSame((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        Assertions.assertEquals((Object)"jelly", (Object)StringUtils.replaceChars((String)"hello", (String)"ho", (String)"jy"));
        Assertions.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        Assertions.assertEquals((Object)"ayya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        Assertions.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        Assertions.assertEquals((Object)"bcc", (Object)StringUtils.replaceChars((String)"abc", (String)"ab", (String)"bc"));
        Assertions.assertEquals((Object)"q651.506bera", (Object)StringUtils.replaceChars((String)"d216.102oren", (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789", (String)"nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM567891234"));
    }

    @Test
    public void testReplaceFirst_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceFirst(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replaceFirst((String)"any", null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replaceFirst((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replaceFirst((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replaceFirst((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceFirst((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"ZZabc", (Object)StringUtils.replaceFirst((String)"abc", (String)"", (String)"ZZ"));
        Assertions.assertEquals((Object)"z\n<__>", (Object)StringUtils.replaceFirst((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)StringUtils.replaceFirst((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assertions.assertEquals((Object)"ABC_bc123", (Object)StringUtils.replaceFirst((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123abc", (Object)StringUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123abc", (Object)StringUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum  dolor   sit", (Object)StringUtils.replaceFirst((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> StringUtils.replaceFirst((String)"any", (String)"{badRegexSyntax}", (String)""), (String)"StringUtils.replaceFirst expecting PatternSyntaxException");
    }

    @Test
    public void testReplaceIgnoreCase_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, null, null));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, null, (String)"any"));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, (String)"any", null));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", null, (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", (String)"any", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceIgnoreCase((String)"FOO", (String)"", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceIgnoreCase((String)"FOO", null, (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceIgnoreCase((String)"FOO", (String)"F", null));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceIgnoreCase((String)"FOO", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
        Assertions.assertEquals((Object)"barbarbar", (Object)StringUtils.replaceIgnoreCase((String)"foofoofoo", (String)FOO_UNCAP, (String)"bar"));
        Assertions.assertEquals((Object)"farfarfar", (Object)StringUtils.replaceIgnoreCase((String)"foofoofoo", (String)"oo", (String)"ar"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"foofoofoo", (String)"FOO", (String)""));
        Assertions.assertEquals((Object)"barbarbar", (Object)StringUtils.replaceIgnoreCase((String)"fooFOOfoo", (String)FOO_UNCAP, (String)"bar"));
        Assertions.assertEquals((Object)"farfarfar", (Object)StringUtils.replaceIgnoreCase((String)"foofOOfoo", (String)"OO", (String)"ar"));
    }

    @Test
    public void testReplaceIgnoreCase_StringStringStringInt() {
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, null, null, (int)2));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, null, (String)"any", (int)2));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, (String)"any", null, (int)2));
        Assertions.assertNull((Object)StringUtils.replaceIgnoreCase(null, (String)"any", (String)"any", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", null, null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", null, (String)"any", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", (String)"any", null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceIgnoreCase((String)"", (String)"any", (String)"any", (int)2));
        String str = new String(new char[]{'o', 'o', 'f', 'o', 'o'});
        Assertions.assertSame((Object)str, (Object)StringUtils.replaceIgnoreCase((String)str, (String)"x", (String)"", (int)-1));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)-1));
        Assertions.assertEquals((Object)"oofoo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)0));
        Assertions.assertEquals((Object)"ofoo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)1));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)2));
        Assertions.assertEquals((Object)"fo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)3));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)4));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)-5));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"o", (String)"", (int)1000));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)-1));
        Assertions.assertEquals((Object)"oofoo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)0));
        Assertions.assertEquals((Object)"ofoo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)1));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)2));
        Assertions.assertEquals((Object)"fo", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)3));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)4));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)-5));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.replaceIgnoreCase((String)"oofoo", (String)"O", (String)"", (int)1000));
    }

    @Test
    public void testReplaceOnce_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceOnce(null, null, null));
        Assertions.assertNull((Object)StringUtils.replaceOnce(null, null, (String)"any"));
        Assertions.assertNull((Object)StringUtils.replaceOnce(null, (String)"any", null));
        Assertions.assertNull((Object)StringUtils.replaceOnce(null, (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", null, (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", (String)"any", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", (String)"", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", null, (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", (String)"F", null));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", null, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringUtils.replaceOnce((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
    }

    @Test
    public void testReplaceOnceIgnoreCase_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replaceOnceIgnoreCase(null, null, null));
        Assertions.assertNull((Object)StringUtils.replaceOnceIgnoreCase(null, null, (String)"any"));
        Assertions.assertNull((Object)StringUtils.replaceOnceIgnoreCase(null, (String)"any", null));
        Assertions.assertNull((Object)StringUtils.replaceOnceIgnoreCase(null, (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnceIgnoreCase((String)"", null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnceIgnoreCase((String)"", null, (String)"any"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnceIgnoreCase((String)"", (String)"any", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replaceOnceIgnoreCase((String)"", (String)"any", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnceIgnoreCase((String)"FOO", (String)"", (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnceIgnoreCase((String)"FOO", null, (String)"any"));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnceIgnoreCase((String)"FOO", (String)"F", null));
        Assertions.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnceIgnoreCase((String)"FOO", null, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringUtils.replaceOnceIgnoreCase((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
        Assertions.assertEquals((Object)"Foofoo", (Object)StringUtils.replaceOnceIgnoreCase((String)"FoOFoofoo", (String)FOO_UNCAP, (String)""));
    }

    @Test
    public void testReplacePattern_StringStringString() {
        Assertions.assertNull((Object)StringUtils.replacePattern(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replacePattern((String)"any", null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)StringUtils.replacePattern((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replacePattern((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)StringUtils.replacePattern((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.replacePattern((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"z", (Object)StringUtils.replacePattern((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)StringUtils.replacePattern((String)"<__>\\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"X", (Object)StringUtils.replacePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>", (String)"X"));
        Assertions.assertEquals((Object)"ABC___123", (Object)StringUtils.replacePattern((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123", (Object)StringUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123", (Object)StringUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)StringUtils.replacePattern((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
    }

    @Test
    public void testReverse_String() {
        Assertions.assertNull((Object)StringUtils.reverse(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.reverse((String)""));
        Assertions.assertEquals((Object)"sdrawkcab", (Object)StringUtils.reverse((String)"backwards"));
    }

    @Test
    public void testReverseDelimited_StringChar() {
        Assertions.assertNull((Object)StringUtils.reverseDelimited(null, (char)'.'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.reverseDelimited((String)"", (char)'.'));
        Assertions.assertEquals((Object)"c.b.a", (Object)StringUtils.reverseDelimited((String)"a.b.c", (char)'.'));
        Assertions.assertEquals((Object)"a b c", (Object)StringUtils.reverseDelimited((String)"a b c", (char)'.'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.reverseDelimited((String)"", (char)'.'));
    }

    @Test
    public void testRightPad_StringInt() {
        Assertions.assertNull((Object)StringUtils.rightPad(null, (int)5));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1));
    }

    @Test
    public void testRightPad_StringIntChar() {
        Assertions.assertNull((Object)StringUtils.rightPad(null, (int)5, (char)' '));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5, (char)' '));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, (char)' '));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2, (char)' '));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1, (char)' '));
        Assertions.assertEquals((Object)"abcxx", (Object)StringUtils.rightPad((String)"abc", (int)5, (char)'x'));
        String str = StringUtils.rightPad((String)"aaa", (int)10000, (char)'a');
        Assertions.assertEquals((int)10000, (int)str.length());
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testRightPad_StringIntString() {
        Assertions.assertNull((Object)StringUtils.rightPad(null, (int)5, (String)"-+"));
        Assertions.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5, (String)" "));
        Assertions.assertNull((Object)StringUtils.rightPad(null, (int)8, null));
        Assertions.assertEquals((Object)"abc-+-+", (Object)StringUtils.rightPad((String)"abc", (int)7, (String)"-+"));
        Assertions.assertEquals((Object)"abc-+~", (Object)StringUtils.rightPad((String)"abc", (int)6, (String)"-+~"));
        Assertions.assertEquals((Object)"abc-+", (Object)StringUtils.rightPad((String)"abc", (int)5, (String)"-+~"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2, (String)" "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1, (String)" "));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, null));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, (String)""));
    }

    @Test
    public void testRotate_StringInt() {
        Assertions.assertNull((Object)StringUtils.rotate(null, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.rotate((String)"", (int)1));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.rotate((String)"abcdefg", (int)0));
        Assertions.assertEquals((Object)"fgabcde", (Object)StringUtils.rotate((String)"abcdefg", (int)2));
        Assertions.assertEquals((Object)"cdefgab", (Object)StringUtils.rotate((String)"abcdefg", (int)-2));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.rotate((String)"abcdefg", (int)7));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.rotate((String)"abcdefg", (int)-7));
        Assertions.assertEquals((Object)"fgabcde", (Object)StringUtils.rotate((String)"abcdefg", (int)9));
        Assertions.assertEquals((Object)"cdefgab", (Object)StringUtils.rotate((String)"abcdefg", (int)-9));
        Assertions.assertEquals((Object)"efgabcd", (Object)StringUtils.rotate((String)"abcdefg", (int)17));
        Assertions.assertEquals((Object)"defgabc", (Object)StringUtils.rotate((String)"abcdefg", (int)-17));
    }

    @Test
    public void testSplit_String() {
        Assertions.assertNull((Object)StringUtils.split(null));
        Assertions.assertEquals((int)0, (int)StringUtils.split((String)"").length);
        String str = "a b  .c";
        String[] res = StringUtils.split((String)str);
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)".c", (Object)res[2]);
        str = " a ";
        res = StringUtils.split((String)str);
        Assertions.assertEquals((int)1, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.split((String)str);
        Assertions.assertEquals((int)2, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)("b" + NON_WHITESPACE + "c"), (Object)res[1]);
    }

    @Test
    public void testSplit_StringChar() {
        Assertions.assertNull((Object)StringUtils.split(null, (char)'.'));
        Assertions.assertEquals((int)0, (int)StringUtils.split((String)"", (char)'.').length);
        String str = "a.b.. c";
        String[] res = StringUtils.split((String)str, (char)'.');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)" c", (Object)res[2]);
        str = ".a.";
        res = StringUtils.split((String)str, (char)'.');
        Assertions.assertEquals((int)1, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        str = "a b c";
        res = StringUtils.split((String)str, (char)' ');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)"c", (Object)res[2]);
    }

    @Test
    public void testSplit_StringString_StringStringInt() {
        Assertions.assertNull((Object)StringUtils.split(null, (String)"."));
        Assertions.assertNull((Object)StringUtils.split(null, (String)".", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.split((String)"", (String)".").length);
        Assertions.assertEquals((int)0, (int)StringUtils.split((String)"", (String)".", (int)3).length);
        this.innerTestSplit('.', ".", ' ');
        this.innerTestSplit('.', ".", ',');
        this.innerTestSplit('.', ".,", 'x');
        for (int i = 0; i < WHITESPACE.length(); ++i) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplit(WHITESPACE.charAt(i), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplit(WHITESPACE.charAt(i), String.valueOf(WHITESPACE.charAt(i)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.split((String)"ab   de fg", null, (int)2);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        results = StringUtils.split((String)"ab:cd:ef", (String)":", (int)2);
        Assertions.assertEquals((int)expectedResults2.length, (int)results.length);
        for (int i = 0; i < expectedResults2.length; ++i) {
            Assertions.assertEquals((Object)expectedResults2[i], (Object)results[i]);
        }
    }

    @Test
    public void testSplitByCharacterType() {
        Assertions.assertNull((Object)StringUtils.splitByCharacterType(null));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByCharacterType((String)"").length);
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", " ", "de", " ", "fg"}, StringUtils.splitByCharacterType((String)"ab de fg")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", "   ", "de", " ", "fg"}, StringUtils.splitByCharacterType((String)"ab   de fg")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", ":", "cd", ":", "ef"}, StringUtils.splitByCharacterType((String)"ab:cd:ef")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"number", "5"}, StringUtils.splitByCharacterType((String)"number5")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{FOO_UNCAP, "B", "ar"}, StringUtils.splitByCharacterType((String)"fooBar")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{FOO_UNCAP, "200", "B", "ar"}, StringUtils.splitByCharacterType((String)"foo200Bar")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ASFR", "ules"}, StringUtils.splitByCharacterType((String)"ASFRules")));
    }

    @Test
    public void testSplitByCharacterTypeCamelCase() {
        Assertions.assertNull((Object)StringUtils.splitByCharacterTypeCamelCase(null));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByCharacterTypeCamelCase((String)"").length);
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", " ", "de", " ", "fg"}, StringUtils.splitByCharacterTypeCamelCase((String)"ab de fg")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", "   ", "de", " ", "fg"}, StringUtils.splitByCharacterTypeCamelCase((String)"ab   de fg")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ab", ":", "cd", ":", "ef"}, StringUtils.splitByCharacterTypeCamelCase((String)"ab:cd:ef")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"number", "5"}, StringUtils.splitByCharacterTypeCamelCase((String)"number5")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{FOO_UNCAP, "Bar"}, StringUtils.splitByCharacterTypeCamelCase((String)"fooBar")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{FOO_UNCAP, "200", "Bar"}, StringUtils.splitByCharacterTypeCamelCase((String)"foo200Bar")));
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"ASF", "Rules"}, StringUtils.splitByCharacterTypeCamelCase((String)"ASFRules")));
    }

    @Test
    public void testSplitByWholeSeparatorPreserveAllTokens_StringString() {
        int i;
        Assertions.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparatorPreserveAllTokens(null, (String)"."));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByWholeSeparatorPreserveAllTokens((String)"", (String)".").length);
        String input = "ab   de fg";
        String[] expected = new String[]{"ab", "", "", "de", "fg"};
        String[] actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, null);
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "", "2", "", "", "3", "", "", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":");
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "2", ":3", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)"::");
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testSplitByWholeSeparatorPreserveAllTokens_StringStringInt() {
        int i;
        Assertions.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparatorPreserveAllTokens(null, (String)".", (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByWholeSeparatorPreserveAllTokens((String)"", (String)".", (int)-1).length);
        String input = "ab   de fg";
        String[] expected = new String[]{"ab", "", "", "de", "fg"};
        String[] actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, null, (int)-1);
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "", "2", "", "", "3", "", "", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)-1);
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "2", ":3", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)"::", (int)-1);
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2::3:4";
        expected = new String[]{"1", "", "2", ":3:4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)4);
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testSplitByWholeString_StringStringBoolean() {
        Assertions.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparator(null, (String)"."));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByWholeSeparator((String)"", (String)".").length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de", "fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)"ab   de fg", null);
        Assertions.assertEquals((int)splitOnNullExpectedResults.length, (int)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            Assertions.assertEquals((Object)splitOnNullExpectedResults[i], (Object)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)"abstemiouslyaeiouyabstemiously", (String)"aeiouy");
        Assertions.assertEquals((int)splitOnStringExpectedResults.length, (int)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            Assertions.assertEquals((Object)splitOnStringExpectedResults[i], (Object)splitOnStringResults[i]);
        }
        String[] splitWithMultipleSeparatorExpectedResults = new String[]{"ab", "cd", "ef"};
        String[] splitWithMultipleSeparator = StringUtils.splitByWholeSeparator((String)"ab:cd::ef", (String)":");
        Assertions.assertEquals((int)splitWithMultipleSeparatorExpectedResults.length, (int)splitWithMultipleSeparator.length);
        for (int i = 0; i < splitWithMultipleSeparatorExpectedResults.length; ++i) {
            Assertions.assertEquals((Object)splitWithMultipleSeparatorExpectedResults[i], (Object)splitWithMultipleSeparator[i]);
        }
    }

    @Test
    public void testSplitByWholeString_StringStringBooleanInt() {
        Assertions.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparator(null, (String)".", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.splitByWholeSeparator((String)"", (String)".", (int)3).length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)"ab   de fg", null, (int)2);
        Assertions.assertEquals((int)splitOnNullExpectedResults.length, (int)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            Assertions.assertEquals((Object)splitOnNullExpectedResults[i], (Object)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiouslyaeiouyabstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)"abstemiouslyaeiouyabstemiouslyaeiouyabstemiously", (String)"aeiouy", (int)2);
        Assertions.assertEquals((int)splitOnStringExpectedResults.length, (int)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            Assertions.assertEquals((Object)splitOnStringExpectedResults[i], (Object)splitOnStringResults[i]);
        }
    }

    @Test
    public void testSplitPreserveAllTokens_String() {
        Assertions.assertNull((Object)StringUtils.splitPreserveAllTokens(null));
        Assertions.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"").length);
        String str = "abc def";
        String[] res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)2, (int)res.length);
        Assertions.assertEquals((Object)"abc", (Object)res[0]);
        Assertions.assertEquals((Object)"def", (Object)res[1]);
        str = "abc  def";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"abc", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"def", (Object)res[2]);
        str = " abc ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"abc", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        str = "a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)".c", (Object)res[2]);
        str = " a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"b", (Object)res[2]);
        Assertions.assertEquals((Object)".c", (Object)res[3]);
        str = "a  b  .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)5, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"b", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        Assertions.assertEquals((Object)".c", (Object)res[4]);
        str = " a  ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        str = " a  b";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        Assertions.assertEquals((Object)"b", (Object)res[3]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assertions.assertEquals((int)(WHITESPACE.length() + 1), (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        for (int i = 1; i < WHITESPACE.length() - 1; ++i) {
            Assertions.assertEquals((Object)"", (Object)res[i]);
        }
        Assertions.assertEquals((Object)("b" + NON_WHITESPACE + "c"), (Object)res[WHITESPACE.length()]);
    }

    @Test
    public void testSplitPreserveAllTokens_StringChar() {
        Assertions.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (char)'.'));
        Assertions.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (char)'.').length);
        String str = "a.b. c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)" c", (Object)res[2]);
        str = "a.b.. c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        Assertions.assertEquals((Object)" c", (Object)res[3]);
        str = ".a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        str = ".a..";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        str = "..a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"a", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        str = "..a";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"a", (Object)res[2]);
        str = "a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)3, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)"c", (Object)res[2]);
        str = "a  b  c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)5, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"b", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        Assertions.assertEquals((Object)"c", (Object)res[4]);
        str = " a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"a", (Object)res[1]);
        Assertions.assertEquals((Object)"b", (Object)res[2]);
        Assertions.assertEquals((Object)"c", (Object)res[3]);
        str = "  a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)5, (int)res.length);
        Assertions.assertEquals((Object)"", (Object)res[0]);
        Assertions.assertEquals((Object)"", (Object)res[1]);
        Assertions.assertEquals((Object)"a", (Object)res[2]);
        Assertions.assertEquals((Object)"b", (Object)res[3]);
        Assertions.assertEquals((Object)"c", (Object)res[4]);
        str = "a b c ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)4, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)"c", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        str = "a b c  ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assertions.assertEquals((int)5, (int)res.length);
        Assertions.assertEquals((Object)"a", (Object)res[0]);
        Assertions.assertEquals((Object)"b", (Object)res[1]);
        Assertions.assertEquals((Object)"c", (Object)res[2]);
        Assertions.assertEquals((Object)"", (Object)res[3]);
        Assertions.assertEquals((Object)"", (Object)res[4]);
        String[] expectedResults = new String[]{"a", "", "b", "c"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"a..b.c", (char)'.');
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
    }

    @Test
    public void testSplitPreserveAllTokens_StringString_StringStringInt() {
        int i;
        Assertions.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (String)"."));
        Assertions.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (String)".", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (String)".").length);
        Assertions.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (String)".", (int)3).length);
        this.innerTestSplitPreserveAllTokens('.', ".", ' ');
        this.innerTestSplitPreserveAllTokens('.', ".", ',');
        this.innerTestSplitPreserveAllTokens('.', ".,", 'x');
        for (int i2 = 0; i2 < WHITESPACE.length(); ++i2) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), String.valueOf(WHITESPACE.charAt(i2)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"ab de fg", null, (int)2);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "  de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)2);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "::de:fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::de:fg", (String)":", (int)2);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", " de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)3);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)4);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        String[] results2 = StringUtils.splitPreserveAllTokens((String)"ab:cd:ef", (String)":", (int)2);
        Assertions.assertEquals((int)expectedResults2.length, (int)results2.length);
        for (i = 0; i < expectedResults2.length; ++i) {
            Assertions.assertEquals((Object)expectedResults2[i], (Object)results2[i]);
        }
        expectedResults = new String[]{"ab", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab::cd:ef", (String)":", (int)2);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)3);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)4);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)":ab:::cd:ef", (String)":", (int)5);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"", "", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"::ab:::cd:ef", (String)":", (int)6);
        Assertions.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
    }

    @Test
    public void testStringUtilsCharSequenceContract() {
        Method[] methods;
        Class<StringUtils> c = StringUtils.class;
        Object[] excludeMethods = new String[]{"public static int org.apache.commons.lang3.StringUtils.compare(java.lang.String,java.lang.String)", "public static int org.apache.commons.lang3.StringUtils.compare(java.lang.String,java.lang.String,boolean)", "public static int org.apache.commons.lang3.StringUtils.compareIgnoreCase(java.lang.String,java.lang.String)", "public static int org.apache.commons.lang3.StringUtils.compareIgnoreCase(java.lang.String,java.lang.String,boolean)", "public static byte[] org.apache.commons.lang3.StringUtils.getBytes(java.lang.String,java.nio.charset.Charset)", "public static byte[] org.apache.commons.lang3.StringUtils.getBytes(java.lang.String,java.lang.String) throws java.io.UnsupportedEncodingException"};
        for (Method m : methods = c.getMethods()) {
            Class<?>[] params;
            String methodStr = m.toString();
            if (m.getReturnType() == String.class || m.getReturnType() == String[].class) {
                params = m.getParameterTypes();
                if (params.length <= 0 || params[0] != CharSequence.class && params[0] != CharSequence[].class) continue;
                Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])excludeMethods, (Object)methodStr), (String)("The method \"" + methodStr + "\" appears to be mutable in spirit and therefore must not accept a CharSequence"));
                continue;
            }
            params = m.getParameterTypes();
            if (params.length <= 0 || params[0] != String.class && params[0] != String[].class) continue;
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])excludeMethods, (Object)methodStr), (String)("The method \"" + methodStr + "\" appears to be immutable in spirit and therefore must not accept a String"));
        }
    }

    @Test
    public void testSwapCase_String() {
        Assertions.assertNull((Object)StringUtils.swapCase(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.swapCase((String)""));
        Assertions.assertEquals((Object)"  ", (Object)StringUtils.swapCase((String)"  "));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.swapCase((String)"I"));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.swapCase((String)"i"));
        Assertions.assertEquals((Object)"I AM HERE 123", (Object)StringUtils.swapCase((String)"i am here 123"));
        Assertions.assertEquals((Object)"i aM hERE 123", (Object)StringUtils.swapCase((String)"I Am Here 123"));
        Assertions.assertEquals((Object)"I AM here 123", (Object)StringUtils.swapCase((String)"i am HERE 123"));
        Assertions.assertEquals((Object)"i am here 123", (Object)StringUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assertions.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
        Assertions.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)StringUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
    }

    @Test
    public void testToCodePoints() {
        int orphanedHighSurrogate = 55297;
        int orphanedLowSurrogate = 56320;
        int supplementary = 132878;
        int[] codePoints = new int[]{97, 55297, 98, 99, 132878, 100, 56320, 101};
        String s = new String(codePoints, 0, codePoints.length);
        Assertions.assertArrayEquals((int[])codePoints, (int[])StringUtils.toCodePoints((CharSequence)s));
        Assertions.assertNull((Object)StringUtils.toCodePoints(null));
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])StringUtils.toCodePoints((CharSequence)""));
    }

    @Test
    public void testToEncodedString() {
        String expectedString = "The quick brown fox jumps over the lazy dog.";
        String encoding = SystemUtils.FILE_ENCODING;
        byte[] expectedBytes = "The quick brown fox jumps over the lazy dog.".getBytes(Charset.defaultCharset());
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])"The quick brown fox jumps over the lazy dog.".getBytes());
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.forName(encoding)));
        encoding = "UTF-16";
        expectedBytes = "The quick brown fox jumps over the lazy dog.".getBytes(Charset.forName(encoding));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.forName(encoding)));
    }

    @Test
    public void testToString() throws UnsupportedEncodingException {
        String expectedString = "The quick brown fox jumps over the lazy dog.";
        byte[] expectedBytes = "The quick brown fox jumps over the lazy dog.".getBytes(Charset.defaultCharset());
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])"The quick brown fox jumps over the lazy dog.".getBytes());
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, null));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, (String)SystemUtils.FILE_ENCODING));
        String encoding = "UTF-16";
        expectedBytes = "The quick brown fox jumps over the lazy dog.".getBytes(Charset.forName("UTF-16"));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, (String)"UTF-16"));
    }

    @Test
    public void testTruncate_StringInt() {
        Assertions.assertNull((Object)StringUtils.truncate(null, (int)12));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)-1), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)-10), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)Integer.MIN_VALUE), (String)"maxWith cannot be negative");
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"", (int)10));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.truncate((String)"abcdefghij", (int)3));
        Assertions.assertEquals((Object)"abcdef", (Object)StringUtils.truncate((String)"abcdefghij", (int)6));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"abcdefghij", (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-1), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-100), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)Integer.MIN_VALUE), (String)"maxWith cannot be negative");
        Assertions.assertEquals((Object)"abcdefghij", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)10));
        Assertions.assertEquals((Object)"abcdefghijklmno", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"abcde", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)5));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)3));
    }

    @Test
    public void testTruncate_StringIntInt() {
        Assertions.assertNull((Object)StringUtils.truncate(null, (int)0, (int)12));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)-1, (int)0), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)-10, (int)-4), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate(null, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), (String)"offset cannot be negative");
        Assertions.assertNull((Object)StringUtils.truncate(null, (int)10, (int)12));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"", (int)0, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"", (int)2, (int)10));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.truncate((String)"abcdefghij", (int)0, (int)3));
        Assertions.assertEquals((Object)"fghij", (Object)StringUtils.truncate((String)"abcdefghij", (int)5, (int)6));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"abcdefghij", (int)0, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)0, (int)-1), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)0, (int)-10), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)0, (int)-100), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)1, (int)-100), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)0, (int)Integer.MIN_VALUE), (String)"maxWith cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-1, (int)0), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-10, (int)0), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-100, (int)1), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)Integer.MIN_VALUE, (int)0), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-1, (int)-1), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-10, (int)-10), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)-100, (int)-100), (String)"offset cannot be negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.truncate((String)"abcdefghij", (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), (String)"offset cannot be negative");
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"peach", (Object)StringUtils.truncate((String)"raspberry peach", (int)10, (int)15));
        Assertions.assertEquals((Object)"abcdefghij", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)0, (int)10));
        Assertions.assertEquals((Object)"abcdefghijklmno", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)0, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"bcdefghijk", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)1, (int)10));
        Assertions.assertEquals((Object)"cdefghijkl", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)2, (int)10));
        Assertions.assertEquals((Object)"defghijklm", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)3, (int)10));
        Assertions.assertEquals((Object)"efghijklmn", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)4, (int)10));
        Assertions.assertEquals((Object)"fghijklmno", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)5, (int)10));
        Assertions.assertEquals((Object)"fghij", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)5, (int)5));
        Assertions.assertEquals((Object)"fgh", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)5, (int)3));
        Assertions.assertEquals((Object)"klm", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)10, (int)3));
        Assertions.assertEquals((Object)"klmno", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)10, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"n", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)13, (int)1));
        Assertions.assertEquals((Object)"no", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)13, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"o", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)14, (int)1));
        Assertions.assertEquals((Object)"o", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)14, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)15, (int)1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)15, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.truncate((String)"abcdefghijklmno", (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
    }

    @Test
    public void testUnCapitalize() {
        Assertions.assertNull((Object)StringUtils.uncapitalize(null));
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)FOO_CAP), (String)"uncapitalize(String) failed");
        Assertions.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)FOO_UNCAP), (String)"uncapitalize(string) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.uncapitalize((String)""), (String)"uncapitalize(empty-string) failed");
        Assertions.assertEquals((Object)"x", (Object)StringUtils.uncapitalize((String)"X"), (String)"uncapitalize(single-char-string) failed");
        Assertions.assertEquals((Object)"cat", (Object)StringUtils.uncapitalize((String)"cat"));
        Assertions.assertEquals((Object)"cat", (Object)StringUtils.uncapitalize((String)"Cat"));
        Assertions.assertEquals((Object)"cAT", (Object)StringUtils.uncapitalize((String)"CAT"));
    }

    @Test
    public void testUnescapeSurrogatePairs() {
        Assertions.assertEquals((Object)"\ud83d\ude30", (Object)StringEscapeUtils.unescapeCsv((String)"\ud83d\ude30"));
        Assertions.assertEquals((Object)"\ud800\udc00", (Object)StringEscapeUtils.unescapeCsv((String)"\ud800\udc00"));
        Assertions.assertEquals((Object)"\ud834\udd1e", (Object)StringEscapeUtils.unescapeCsv((String)"\ud834\udd1e"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeCsv((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeHtml3((String)"\udbff\udffd"));
        Assertions.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeHtml4((String)"\udbff\udffd"));
    }

    @Test
    public void testUnwrap_StringChar() {
        Assertions.assertNull((Object)StringUtils.unwrap(null, null));
        Assertions.assertNull((Object)StringUtils.unwrap(null, (char)'\u0000'));
        Assertions.assertNull((Object)StringUtils.unwrap(null, (char)'1'));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"abc", null));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.unwrap((String)"a", (String)"a"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.unwrap((String)"aa", (String)"a"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"'abc'", (char)'\''));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"AabcA", (char)'A'));
        Assertions.assertEquals((Object)"AabcA", (Object)StringUtils.unwrap((String)"AAabcAA", (char)'A'));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"abc", (char)'b'));
        Assertions.assertEquals((Object)"#A", (Object)StringUtils.unwrap((String)"#A", (char)'#'));
        Assertions.assertEquals((Object)"A#", (Object)StringUtils.unwrap((String)"A#", (char)'#'));
        Assertions.assertEquals((Object)"ABA", (Object)StringUtils.unwrap((String)"AABAA", (char)'A'));
    }

    @Test
    public void testUnwrap_StringString() {
        Assertions.assertNull((Object)StringUtils.unwrap(null, null));
        Assertions.assertNull((Object)StringUtils.unwrap(null, (String)""));
        Assertions.assertNull((Object)StringUtils.unwrap(null, (String)"1"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"abc", null));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"abc", (String)""));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.unwrap((String)"a", (String)"a"));
        Assertions.assertEquals((Object)"ababa", (Object)StringUtils.unwrap((String)"ababa", (String)"aba"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.unwrap((String)"aa", (String)"a"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"'abc'", (String)"'"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.unwrap((String)"\"abc\"", (String)"\""));
        Assertions.assertEquals((Object)"abc\"xyz", (Object)StringUtils.unwrap((String)"\"abc\"xyz\"", (String)"\""));
        Assertions.assertEquals((Object)"abc\"xyz\"", (Object)StringUtils.unwrap((String)"\"abc\"xyz\"\"", (String)"\""));
        Assertions.assertEquals((Object)"abc'xyz'", (Object)StringUtils.unwrap((String)"\"abc'xyz'\"", (String)"\""));
        Assertions.assertEquals((Object)"\"abc'xyz'\"", (Object)StringUtils.unwrap((String)"AA\"abc'xyz'\"AA", (String)"AA"));
        Assertions.assertEquals((Object)"\"abc'xyz'\"", (Object)StringUtils.unwrap((String)"123\"abc'xyz'\"123", (String)"123"));
        Assertions.assertEquals((Object)"AA\"abc'xyz'\"", (Object)StringUtils.unwrap((String)"AA\"abc'xyz'\"", (String)"AA"));
        Assertions.assertEquals((Object)"AA\"abc'xyz'\"AA", (Object)StringUtils.unwrap((String)"AAA\"abc'xyz'\"AAA", (String)"A"));
        Assertions.assertEquals((Object)"\"abc'xyz'\"AA", (Object)StringUtils.unwrap((String)"\"abc'xyz'\"AA", (String)"AA"));
    }

    @Test
    public void testUpperCase() {
        Assertions.assertNull((Object)StringUtils.upperCase(null));
        Assertions.assertNull((Object)StringUtils.upperCase(null, (Locale)Locale.ENGLISH));
        Assertions.assertEquals((Object)"FOO TEST THING", (Object)StringUtils.upperCase((String)"fOo test THING"), (String)"upperCase(String) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.upperCase((String)""), (String)"upperCase(empty-string) failed");
        Assertions.assertEquals((Object)"FOO TEST THING", (Object)StringUtils.upperCase((String)"fOo test THING", (Locale)Locale.ENGLISH), (String)"upperCase(String, Locale) failed");
        Assertions.assertEquals((Object)"", (Object)StringUtils.upperCase((String)"", (Locale)Locale.ENGLISH), (String)"upperCase(empty-string, Locale) failed");
    }

    @Test
    public void testWrap_StringChar() {
        Assertions.assertNull((Object)StringUtils.wrap(null, (char)'\u0000'));
        Assertions.assertNull((Object)StringUtils.wrap(null, (char)'1'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.wrap((String)"", (char)'\u0000'));
        Assertions.assertEquals((Object)"xabx", (Object)StringUtils.wrap((String)"ab", (char)'x'));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrap((String)"ab", (char)'\"'));
        Assertions.assertEquals((Object)"\"\"ab\"\"", (Object)StringUtils.wrap((String)"\"ab\"", (char)'\"'));
        Assertions.assertEquals((Object)"'ab'", (Object)StringUtils.wrap((String)"ab", (char)'\''));
        Assertions.assertEquals((Object)"''abcd''", (Object)StringUtils.wrap((String)"'abcd'", (char)'\''));
        Assertions.assertEquals((Object)"'\"abcd\"'", (Object)StringUtils.wrap((String)"\"abcd\"", (char)'\''));
        Assertions.assertEquals((Object)"\"'abcd'\"", (Object)StringUtils.wrap((String)"'abcd'", (char)'\"'));
    }

    @Test
    public void testWrap_StringString() {
        Assertions.assertNull((Object)StringUtils.wrap(null, null));
        Assertions.assertNull((Object)StringUtils.wrap(null, (String)""));
        Assertions.assertNull((Object)StringUtils.wrap(null, (String)"1"));
        Assertions.assertNull((Object)StringUtils.wrap(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.wrap((String)"", (String)""));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.wrap((String)"ab", null));
        Assertions.assertEquals((Object)"xabx", (Object)StringUtils.wrap((String)"ab", (String)"x"));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrap((String)"ab", (String)"\""));
        Assertions.assertEquals((Object)"\"\"ab\"\"", (Object)StringUtils.wrap((String)"\"ab\"", (String)"\""));
        Assertions.assertEquals((Object)"'ab'", (Object)StringUtils.wrap((String)"ab", (String)"'"));
        Assertions.assertEquals((Object)"''abcd''", (Object)StringUtils.wrap((String)"'abcd'", (String)"'"));
        Assertions.assertEquals((Object)"'\"abcd\"'", (Object)StringUtils.wrap((String)"\"abcd\"", (String)"'"));
        Assertions.assertEquals((Object)"\"'abcd'\"", (Object)StringUtils.wrap((String)"'abcd'", (String)"\""));
    }

    @Test
    public void testWrapIfMissing_StringChar() {
        Assertions.assertNull((Object)StringUtils.wrapIfMissing(null, (char)'\u0000'));
        Assertions.assertNull((Object)StringUtils.wrapIfMissing(null, (char)'1'));
        Assertions.assertEquals((Object)"", (Object)StringUtils.wrapIfMissing((String)"", (char)'\u0000'));
        Assertions.assertEquals((Object)"xabx", (Object)StringUtils.wrapIfMissing((String)"ab", (char)'x'));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrapIfMissing((String)"ab", (char)'\"'));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrapIfMissing((String)"\"ab\"", (char)'\"'));
        Assertions.assertEquals((Object)"'ab'", (Object)StringUtils.wrapIfMissing((String)"ab", (char)'\''));
        Assertions.assertEquals((Object)"'abcd'", (Object)StringUtils.wrapIfMissing((String)"'abcd'", (char)'\''));
        Assertions.assertEquals((Object)"'\"abcd\"'", (Object)StringUtils.wrapIfMissing((String)"\"abcd\"", (char)'\''));
        Assertions.assertEquals((Object)"\"'abcd'\"", (Object)StringUtils.wrapIfMissing((String)"'abcd'", (char)'\"'));
        Assertions.assertEquals((Object)"/x/", (Object)StringUtils.wrapIfMissing((String)"x", (char)'/'));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"x/y/z", (char)'/'));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"/x/y/z", (char)'/'));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"x/y/z/", (char)'/'));
        Assertions.assertSame((Object)"/", (Object)StringUtils.wrapIfMissing((String)"/", (char)'/'));
        Assertions.assertSame((Object)"/x/", (Object)StringUtils.wrapIfMissing((String)"/x/", (char)'/'));
    }

    @Test
    public void testWrapIfMissing_StringString() {
        Assertions.assertNull((Object)StringUtils.wrapIfMissing(null, (String)"\u0000"));
        Assertions.assertNull((Object)StringUtils.wrapIfMissing(null, (String)"1"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.wrapIfMissing((String)"", (String)"\u0000"));
        Assertions.assertEquals((Object)"xabx", (Object)StringUtils.wrapIfMissing((String)"ab", (String)"x"));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrapIfMissing((String)"ab", (String)"\""));
        Assertions.assertEquals((Object)"\"ab\"", (Object)StringUtils.wrapIfMissing((String)"\"ab\"", (String)"\""));
        Assertions.assertEquals((Object)"'ab'", (Object)StringUtils.wrapIfMissing((String)"ab", (String)"'"));
        Assertions.assertEquals((Object)"'abcd'", (Object)StringUtils.wrapIfMissing((String)"'abcd'", (String)"'"));
        Assertions.assertEquals((Object)"'\"abcd\"'", (Object)StringUtils.wrapIfMissing((String)"\"abcd\"", (String)"'"));
        Assertions.assertEquals((Object)"\"'abcd'\"", (Object)StringUtils.wrapIfMissing((String)"'abcd'", (String)"\""));
        Assertions.assertEquals((Object)"/x/", (Object)StringUtils.wrapIfMissing((String)"x", (String)"/"));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"x/y/z", (String)"/"));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"/x/y/z", (String)"/"));
        Assertions.assertEquals((Object)"/x/y/z/", (Object)StringUtils.wrapIfMissing((String)"x/y/z/", (String)"/"));
        Assertions.assertEquals((Object)"/", (Object)StringUtils.wrapIfMissing((String)"/", (String)"/"));
        Assertions.assertEquals((Object)"ab/ab", (Object)StringUtils.wrapIfMissing((String)"/", (String)"ab"));
        Assertions.assertSame((Object)"ab/ab", (Object)StringUtils.wrapIfMissing((String)"ab/ab", (String)"ab"));
        Assertions.assertSame((Object)"//x//", (Object)StringUtils.wrapIfMissing((String)"//x//", (String)"//"));
    }

    @Test
    public void testToRootLowerCase() {
        Assertions.assertNull((Object)StringUtils.toRootLowerCase(null));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.toRootLowerCase((String)"A"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.toRootLowerCase((String)"a"));
        Locale TURKISH = Locale.forLanguageTag("tr");
        Assertions.assertNotEquals((Object)"title", (Object)"TITLE".toLowerCase(TURKISH));
        Assertions.assertEquals((Object)"title", (Object)"TITLE".toLowerCase(Locale.ROOT));
        Assertions.assertEquals((Object)"title", (Object)StringUtils.toRootLowerCase((String)"TITLE"));
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(TURKISH);
            Assertions.assertEquals((Object)"title", (Object)StringUtils.toRootLowerCase((String)"TITLE"));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testToRootUpperCase() {
        Assertions.assertNull((Object)StringUtils.toRootUpperCase(null));
        Assertions.assertEquals((Object)"A", (Object)StringUtils.toRootUpperCase((String)"a"));
        Assertions.assertEquals((Object)"A", (Object)StringUtils.toRootUpperCase((String)"A"));
        Locale TURKISH = Locale.forLanguageTag("tr");
        Assertions.assertNotEquals((Object)"TITLE", (Object)"title".toUpperCase(TURKISH));
        Assertions.assertEquals((Object)"TITLE", (Object)"title".toUpperCase(Locale.ROOT));
        Assertions.assertEquals((Object)"TITLE", (Object)StringUtils.toRootUpperCase((String)"title"));
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(TURKISH);
            Assertions.assertEquals((Object)"TITLE", (Object)StringUtils.toRootUpperCase((String)"title"));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testGeorgianSample() {
        char[] arrayI = new char[]{'\u0131', '\u03f4'};
        char[] arrayJ = new char[]{'\u0130', '\u03d1'};
        for (char i : arrayI) {
            for (char j : arrayJ) {
                String si = String.valueOf(i);
                String sj = String.valueOf(j);
                boolean res1 = si.equalsIgnoreCase(sj);
                StringBuilder ci = new StringBuilder(si);
                StringBuilder cj = new StringBuilder(sj);
                boolean res2 = StringUtils.startsWithIgnoreCase((CharSequence)ci, (CharSequence)cj);
                Assertions.assertEquals((Object)res1, (Object)res2, (String)("si : " + si + " sj : " + sj));
                res2 = StringUtils.endsWithIgnoreCase((CharSequence)ci, (CharSequence)cj);
                Assertions.assertEquals((Object)res1, (Object)res2, (String)("si : " + si + " sj : " + sj));
                res2 = StringUtils.compareIgnoreCase((String)ci.toString(), (String)cj.toString()) == 0;
                Assertions.assertEquals((Object)res1, (Object)res2, (String)("si : " + si + " sj : " + sj));
                res2 = StringUtils.indexOfIgnoreCase((CharSequence)ci.toString(), (CharSequence)cj.toString()) == 0;
                Assertions.assertEquals((Object)res1, (Object)res2, (String)("si : " + si + " sj : " + sj));
                res2 = StringUtils.lastIndexOfIgnoreCase((CharSequence)ci.toString(), (CharSequence)cj.toString()) == 0;
                Assertions.assertEquals((Object)res1, (Object)res2, (String)("si : " + si + " sj : " + sj));
            }
        }
    }

    static {
        int i;
        StringBuilder ws = new StringBuilder();
        StringBuilder nws = new StringBuilder();
        String hs = String.valueOf('\u00a0');
        StringBuilder tr = new StringBuilder();
        StringBuilder ntr = new StringBuilder();
        for (i = 0; i < 65535; ++i) {
            if (Character.isWhitespace((char)i)) {
                ws.append(String.valueOf((char)i));
                if (i <= 32) continue;
                ntr.append(String.valueOf((char)i));
                continue;
            }
            if (i >= 40) continue;
            nws.append(String.valueOf((char)i));
        }
        for (i = 0; i <= 32; ++i) {
            tr.append(String.valueOf((char)i));
        }
        WHITESPACE = ws.toString();
        NON_WHITESPACE = nws.toString();
        HARD_SPACE = hs;
        TRIMMABLE = tr.toString();
        NON_TRIMMABLE = ntr.toString();
        ARRAY_LIST = new String[]{FOO_UNCAP, "bar", "baz"};
        EMPTY_ARRAY_LIST = new String[0];
        NULL_ARRAY_LIST = new String[]{null};
        NULL_TO_STRING_LIST = new Object[]{new Object(){

            public String toString() {
                return null;
            }
        }};
        MIXED_ARRAY_LIST = new String[]{null, "", FOO_UNCAP};
        MIXED_TYPE_LIST = new Object[]{FOO_UNCAP, 2L};
        LONG_PRIM_LIST = new long[]{1L, 2L};
        INT_PRIM_LIST = new int[]{1, 2};
        BYTE_PRIM_LIST = new byte[]{1, 2};
        SHORT_PRIM_LIST = new short[]{1, 2};
        CHAR_PRIM_LIST = new char[]{'1', '2'};
        FLOAT_PRIM_LIST = new float[]{1.0f, 2.0f};
        DOUBLE_PRIM_LIST = new double[]{1.0, 2.0};
        MIXED_STRING_LIST = Arrays.asList(null, "", FOO_UNCAP);
        MIXED_TYPE_OBJECT_LIST = Arrays.asList(FOO_UNCAP, 2L);
        STRING_LIST = Arrays.asList(FOO_UNCAP, "bar", "baz");
        EMPTY_STRING_LIST = Collections.emptyList();
        NULL_STRING_LIST = Collections.singletonList(null);
        EMPTY = new boolean[0];
        ARRAY_FALSE_FALSE = new boolean[]{false, false};
        ARRAY_FALSE_TRUE = new boolean[]{false, true};
        ARRAY_FALSE_TRUE_FALSE = new boolean[]{false, true, false};
    }
}

