/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core.disk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.SimplePathVisitor;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DiskFileItemSerializeTest {
    private static final Path REPOSITORY = PathUtils.getTempDirectory().resolve("DiskFileItemRepo");
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private static final int THRESHOLD = 16;

    private void compareBytes(String text, byte[] origBytes, byte[] newBytes) {
        Assertions.assertNotNull((Object)origBytes, (String)"origBytes must not be null");
        Assertions.assertNotNull((Object)newBytes, (String)"newBytes must not be null");
        Assertions.assertEquals((int)origBytes.length, (int)newBytes.length, (String)(text + " byte[] length"));
        for (int i = 0; i < origBytes.length; ++i) {
            Assertions.assertEquals((byte)origBytes[i], (byte)newBytes[i], (String)(text + " byte[" + i + "]"));
        }
    }

    private byte[] createContentBytes(int size) {
        StringBuilder buffer = new StringBuilder(size);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            buffer.append(count + "");
            count = (byte)(count + 1);
            if (count <= 9) continue;
            count = 0;
        }
        return buffer.toString().getBytes();
    }

    private DiskFileItem createFileItem(byte[] contentBytes) throws IOException {
        return this.createFileItem(contentBytes, REPOSITORY);
    }

    private DiskFileItem createFileItem(byte[] contentBytes, Path repository) throws IOException {
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(16)).setPath(repository)).get();
        DiskFileItem item = (DiskFileItem)factory.fileItemBuilder().setFieldName("textField").setContentType(TEXT_CONTENT_TYPE).setFormField(true).setFileName("My File Name").get();
        try (OutputStream os = item.getOutputStream();){
            os.write(contentBytes);
        }
        return item;
    }

    private Object deserialize(ByteArrayOutputStream baos) {
        return SerializationUtils.deserialize((byte[])baos.toByteArray());
    }

    private ByteArrayOutputStream serialize(Object target) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ByteArrayOutputStream byteArrayOutputStream;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(target);
                oos.flush();
                byteArrayOutputStream = baos;
            }
            return byteArrayOutputStream;
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        if (Files.exists(REPOSITORY, new LinkOption[0])) {
            PathUtils.deleteDirectory((Path)REPOSITORY);
        } else {
            Files.createDirectories(REPOSITORY, new FileAttribute[0]);
        }
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (Files.exists(REPOSITORY, new LinkOption[0])) {
            PathUtils.visitFileTree((FileVisitor)new SimplePathVisitor(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    System.out.println("Found leftover file " + file);
                    return FileVisitResult.CONTINUE;
                }
            }, (Path)REPOSITORY);
            PathUtils.deleteDirectory((Path)REPOSITORY);
        }
    }

    @Test
    public void testAboveThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(17);
        DiskFileItem item = this.createFileItem(testFieldValueBytes);
        Assertions.assertFalse((boolean)item.isInMemory(), (String)"Initial: in memory");
        Assertions.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length, (String)"Initial: size");
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        this.testWritingToFile(item, testFieldValueBytes);
        item.delete();
    }

    @Test
    public void testBelowThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(15);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testCheckFileName() {
        Assertions.assertThrows(InvalidPathException.class, () -> DiskFileItem.checkFileName((String)"\u0000"));
    }

    private void testInMemoryObject(byte[] testFieldValueBytes) throws IOException {
        this.testInMemoryObject(testFieldValueBytes, REPOSITORY);
    }

    private void testInMemoryObject(byte[] testFieldValueBytes, Path repository) throws IOException {
        DiskFileItem item = this.createFileItem(testFieldValueBytes, repository);
        Assertions.assertTrue((boolean)item.isInMemory(), (String)"Initial: in memory");
        Assertions.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length, (String)"Initial: size");
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        this.testWritingToFile(item, testFieldValueBytes);
        item.delete();
    }

    @Test
    public void testInvalidRepository() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        Path repository = PathUtils.getTempDirectory().resolve("file");
        DiskFileItem item = this.createFileItem(testFieldValueBytes, repository);
        Assertions.assertThrows(IOException.class, () -> this.deserialize(this.serialize(item)));
    }

    @Test
    public void testThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testValidRepository() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes, REPOSITORY);
    }

    private void testWritingToFile(DiskFileItem item, byte[] testFieldValueBytes) throws IOException {
        Path temp = Files.createTempFile("fileupload", null, new FileAttribute[0]);
        item.write(temp);
        this.compareBytes("Initial", Files.readAllBytes(temp), testFieldValueBytes);
    }
}

