/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.lang.annotation.ElementType;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertyConverter {
    private static final Class<ElementType> ENUM_CLASS = ElementType.class;

    @Test
    public void testSplit() {
        String s = "abc, xyz , 123";
        List list = PropertyConverter.split((String)s, (char)',');
        Assert.assertEquals((String)"size", (long)3L, (long)list.size());
        Assert.assertEquals((String)("1st token for '" + s + "'"), (Object)"abc", list.get(0));
        Assert.assertEquals((String)("2nd token for '" + s + "'"), (Object)"xyz", list.get(1));
        Assert.assertEquals((String)("3rd token for '" + s + "'"), (Object)"123", list.get(2));
    }

    @Test
    public void testSplitNoTrim() {
        String s = "abc, xyz , 123";
        List list = PropertyConverter.split((String)s, (char)',', (boolean)false);
        Assert.assertEquals((String)"size", (long)3L, (long)list.size());
        Assert.assertEquals((String)("1st token for '" + s + "'"), (Object)"abc", list.get(0));
        Assert.assertEquals((String)("2nd token for '" + s + "'"), (Object)" xyz ", list.get(1));
        Assert.assertEquals((String)("3rd token for '" + s + "'"), (Object)" 123", list.get(2));
    }

    @Test
    public void testSplitWithEscapedSeparator() {
        String s = "abc\\,xyz, 123";
        List list = PropertyConverter.split((String)s, (char)',');
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        Assert.assertEquals((String)("1st token for '" + s + "'"), (Object)"abc,xyz", list.get(0));
        Assert.assertEquals((String)("2nd token for '" + s + "'"), (Object)"123", list.get(1));
    }

    @Test
    public void testSplitEmptyValues() {
        String s = ",,";
        List list = PropertyConverter.split((String)s, (char)',');
        Assert.assertEquals((String)"size", (long)3L, (long)list.size());
        Assert.assertEquals((String)("1st token for '" + s + "'"), (Object)"", list.get(0));
        Assert.assertEquals((String)("2nd token for '" + s + "'"), (Object)"", list.get(1));
        Assert.assertEquals((String)("3rd token for '" + s + "'"), (Object)"", list.get(2));
    }

    @Test
    public void testSplitWithEndingSlash() {
        String s = "abc, xyz\\";
        List list = PropertyConverter.split((String)s, (char)',');
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        Assert.assertEquals((String)("1st token for '" + s + "'"), (Object)"abc", list.get(0));
        Assert.assertEquals((String)("2nd token for '" + s + "'"), (Object)"xyz\\", list.get(1));
    }

    @Test
    public void testSplitNull() {
        List list = PropertyConverter.split(null, (char)',');
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testSplitEscapeEscapeChar() {
        List list = PropertyConverter.split((String)"C:\\Temp\\\\,xyz", (char)',');
        Assert.assertEquals((String)"Wrong list size", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"C:\\Temp\\", list.get(0));
        Assert.assertEquals((String)"Wrong element 2", (Object)"xyz", list.get(1));
    }

    @Test
    public void testEscapeDelimiters() {
        Assert.assertEquals((String)"Wrong escaped delimiters", (Object)"C:\\\\Temp\\\\\\,D:\\\\Data\\\\", (Object)PropertyConverter.escapeDelimiters((String)"C:\\Temp\\,D:\\Data\\", (char)','));
    }

    @Test
    public void testEscapeListDelimiter() {
        Assert.assertEquals((String)"Wrong escaped list delimiter", (Object)"C:\\Temp\\\\,D:\\Data\\", (Object)PropertyConverter.escapeListDelimiter((String)"C:\\Temp\\,D:\\Data\\", (char)','));
    }

    @Test
    public void testToIterator() {
        int[] array = new int[]{1, 2, 3};
        Iterator it = PropertyConverter.toIterator((Object)array, (char)',');
        Assert.assertEquals((String)"1st element", (Object)new Integer(1), it.next());
        Assert.assertEquals((String)"2nd element", (Object)new Integer(2), it.next());
        Assert.assertEquals((String)"3rd element", (Object)new Integer(3), it.next());
    }

    @Test
    public void testInterpolateString() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty("target", (Object)"lazy dog");
        Assert.assertEquals((String)"Wrong interpolation", (Object)"The quick brown fox jumps over the lazy dog.", (Object)PropertyConverter.interpolate((Object)"The ${animal} jumps over the ${target}.", (AbstractConfiguration)config));
    }

    @Test
    public void testInterpolateObject() {
        Assert.assertEquals((String)"Object was not correctly interpolated", (Object)new Integer(42), (Object)PropertyConverter.interpolate((Object)new Integer(42), (AbstractConfiguration)new PropertiesConfiguration()));
    }

    @Test
    public void testInterpolateRecursive() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} fox");
        config.addProperty("target", (Object)"${target_attr} dog");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("target_attr", (Object)"lazy");
        Assert.assertEquals((String)"Wrong complex interpolation", (Object)"The quick brown fox jumps over the lazy dog.", (Object)PropertyConverter.interpolate((Object)"The ${animal} jumps over the ${target}.", (AbstractConfiguration)config));
    }

    @Test(expected=IllegalStateException.class)
    public void testCyclicInterpolation() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} ${species}");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("species", (Object)"${animal}");
        PropertyConverter.interpolate((Object)"This is a ${animal}", (AbstractConfiguration)config);
    }

    @Test
    public void testInterpolationUnknownVariable() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        Assert.assertEquals((String)"Wrong interpolation", (Object)"The quick brown fox jumps over ${target}.", (Object)PropertyConverter.interpolate((Object)"The ${animal} jumps over ${target}.", (AbstractConfiguration)config));
    }

    @Test
    public void testToNumberDirect() {
        Integer i = new Integer(42);
        Assert.assertSame((String)"Wrong integer", (Object)i, (Object)PropertyConverter.toNumber((Object)i, Integer.class));
        BigDecimal d = new BigDecimal("3.1415");
        Assert.assertSame((String)"Wrong BigDecimal", (Object)d, (Object)PropertyConverter.toNumber((Object)d, Integer.class));
    }

    @Test
    public void testToNumberFromString() {
        Assert.assertEquals((String)"Incorrect Integer value", (Object)new Integer(42), (Object)PropertyConverter.toNumber((Object)"42", Integer.class));
        Assert.assertEquals((String)"Incorrect Short value", (Object)new Short(10), (Object)PropertyConverter.toNumber((Object)new StringBuffer("10"), Short.class));
    }

    @Test
    public void testToNumberFromHexString() {
        Number n = PropertyConverter.toNumber((Object)"0x10", Integer.class);
        Assert.assertEquals((String)"Incorrect Integer value", (long)16L, (long)n.intValue());
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidHexString() {
        PropertyConverter.toNumber((Object)"0xNotAHexValue", Integer.class);
    }

    @Test
    public void testToNumberFromBinaryString() {
        Number n = PropertyConverter.toNumber((Object)"0b1111", Integer.class);
        Assert.assertEquals((String)"Incorrect Integer value", (long)15L, (long)n.intValue());
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidBinaryString() {
        PropertyConverter.toNumber((Object)"0bNotABinValue", Integer.class);
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidString() {
        PropertyConverter.toNumber((Object)"Not a number", Byte.class);
    }

    @Test(expected=ConversionException.class)
    public void testToNumberWithInvalidClass() {
        PropertyConverter.toNumber((Object)"42", Object.class);
    }

    @Test
    public void testToEnumFromEnum() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)((Object)ElementType.METHOD), ENUM_CLASS));
    }

    @Test
    public void testToEnumFromString() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)"METHOD", ENUM_CLASS));
    }

    @Test(expected=ConversionException.class)
    public void testToEnumFromInvalidString() {
        PropertyConverter.toEnum((Object)"FOO", ENUM_CLASS);
    }

    @Test
    public void testToEnumFromNumber() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)ElementType.METHOD.ordinal(), ENUM_CLASS));
    }

    @Test(expected=ConversionException.class)
    public void testToEnumFromInvalidNumber() {
        PropertyConverter.toEnum((Object)-1, ENUM_CLASS);
    }

    @Test
    public void testToNoConversionNeeded() {
        String value = "testValue";
        Assert.assertEquals((String)"Wrong conversion result", (Object)value, (Object)PropertyConverter.to(String.class, (Object)value, null));
    }

    @Test
    public void testToCharSuccess() {
        Assert.assertEquals((String)"Wrong conversion result", (Object)Character.valueOf('t'), (Object)PropertyConverter.to(Character.class, (Object)"t", null));
    }

    @Test
    public void testToCharViaToString() {
        Object value = new Object(){

            public String toString() {
                return "X";
            }
        };
        Assert.assertEquals((String)"Wrong conversion result", (Object)Character.valueOf('X'), (Object)PropertyConverter.to(Character.TYPE, (Object)value, null));
    }

    @Test(expected=ConversionException.class)
    public void testToCharFailed() {
        PropertyConverter.to(Character.TYPE, (Object)"FF", null);
    }
}

