/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestConfigurationFactory {
    private URL digesterRules = this.getClass().getResource("/digesterRules.xml");
    private File testDigesterFile = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
    private File testDigesterFileReverseOrder = ConfigurationAssert.getTestFile("testDigesterConfigurationReverseOrder.xml");
    private File testDigesterFileNamespaceAware = ConfigurationAssert.getTestFile("testDigesterConfigurationNamespaceAware.xml");
    private File testDigesterFileBasePath = ConfigurationAssert.getTestFile("testDigesterConfigurationBasePath.xml");
    private File testDigesterFileEnhanced = ConfigurationAssert.getTestFile("testDigesterConfiguration2.xml");
    private File testDigesterFileComplete = ConfigurationAssert.getTestFile("testDigesterConfiguration3.xml");
    private File testDigesterFileOptional = ConfigurationAssert.getTestFile("testDigesterOptionalConfiguration.xml");
    private File testDigesterFileOptionalEx = ConfigurationAssert.getTestFile("testDigesterOptionalConfigurationEx.xml");
    private File testDigesterFileSysProps = ConfigurationAssert.getTestFile("testDigesterConfigurationSysProps.xml");
    private File testDigesterFileInitProps = ConfigurationAssert.getTestFile("testDigesterConfigurationWithProps.xml");
    private File testDigesterBadXML = ConfigurationAssert.getTestFile("testDigesterBadXML.xml");
    private String testBasePath = new File("conf").getAbsolutePath();
    private File testProperties = ConfigurationAssert.getTestFile("test.properties");
    private File testAbsConfig = ConfigurationAssert.getOutFile("testAbsConfig.xml");
    private Configuration configuration;
    private CompositeConfiguration compositeConfiguration;
    private ConfigurationFactory factory;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.configuration.MockInitialContextFactory");
        this.factory = new ConfigurationFactory();
    }

    @Test
    public void testJNDI() throws Exception {
        JNDIConfiguration jndiConfiguration = new JNDIConfiguration();
        Object o = jndiConfiguration.getProperty("test.boolean");
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"true", (Object)o.toString());
    }

    @Test
    public void testLoadingConfiguration() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFile.toString());
        this.compositeConfiguration = (CompositeConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Number of configurations", (long)4L, (long)this.compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, this.compositeConfiguration.getConfiguration(0).getClass());
        Assert.assertEquals(XMLPropertiesConfiguration.class, this.compositeConfiguration.getConfiguration(1).getClass());
        Assert.assertEquals(XMLConfiguration.class, this.compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName: " + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)this.compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((String)"property in the XMLPropertiesConfiguration", (Object)"value1", (Object)this.compositeConfiguration.getProperty("key1"));
    }

    @Test
    public void testLoadingConfigurationWithRulesXML() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFile.toString());
        this.factory.setDigesterRules(this.digesterRules);
        this.compositeConfiguration = (CompositeConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Number of configurations", (long)4L, (long)this.compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, this.compositeConfiguration.getConfiguration(0).getClass());
        Assert.assertEquals(XMLConfiguration.class, this.compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName: " + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)pc.getBoolean("test.boolean"));
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)this.compositeConfiguration.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testLoadingConfigurationReverseOrder() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFileReverseOrder.toString());
        this.configuration = this.factory.getConfiguration();
        Assert.assertEquals((Object)"8", (Object)this.configuration.getProperty("test.short"));
        this.factory.setConfigurationFileName(this.testDigesterFile.toString());
        this.configuration = this.factory.getConfiguration();
        Assert.assertEquals((Object)"1", (Object)this.configuration.getProperty("test.short"));
    }

    @Test
    public void testLoadingConfigurationNamespaceAware() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFileNamespaceAware.toString());
        this.factory.setDigesterRuleNamespaceURI("namespace-one");
        this.checkCompositeConfiguration();
    }

    @Test
    public void testLoadingConfigurationBasePath() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFileBasePath.toString());
        this.factory.setBasePath(this.testBasePath);
        this.checkCompositeConfiguration();
    }

    @Test
    public void testLoadingAdditional() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterFileEnhanced.toString());
        this.factory.setBasePath(null);
        this.checkUnionConfig();
    }

    @Test
    public void testLoadingURL() throws Exception {
        this.factory.setConfigurationURL(this.testDigesterFileEnhanced.toURL());
        this.checkUnionConfig();
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadingURLNonExisting() throws Exception {
        this.factory = new ConfigurationFactory();
        File nonExistingFile = new File("conf/nonexisting.xml");
        this.factory.setConfigurationURL(nonExistingFile.toURL());
        this.factory.getConfiguration();
    }

    @Test
    public void testThrowingConfigurationInitializationException() throws Exception {
        this.factory.setConfigurationFileName(this.testDigesterBadXML.toString());
        try {
            this.factory.getConfiguration();
            Assert.fail((String)"Should have throw an Exception");
        }
        catch (ConfigurationException cle) {
            Assert.assertTrue((String)("Unexpected cause: " + cle.getCause()), (boolean)(cle.getCause() instanceof SAXException));
        }
    }

    @Test
    public void testAllConfiguration() throws Exception {
        this.factory.setConfigurationURL(this.testDigesterFileComplete.toURL());
        Configuration config = this.factory.getConfiguration();
        Assert.assertFalse((boolean)config.isEmpty());
        Assert.assertTrue((boolean)(config instanceof CompositeConfiguration));
        CompositeConfiguration cc = (CompositeConfiguration)config;
        Assert.assertTrue((cc.getNumberOfConfigurations() > 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)config.getProperty("tables.table(0).fields.field(2).name"));
        Assert.assertNotNull((Object)config.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element3"));
        Assert.assertEquals((Object)"foo", (Object)config.getProperty("element3[@name]"));
        Assert.assertNotNull((Object)config.getProperty("mail.account.user"));
        Assert.assertNotNull((Object)config.getProperty("test.onlyinjndi"));
        Assert.assertTrue((boolean)config.getBoolean("test.onlyinjndi"));
        Configuration subset = config.subset("test");
        Assert.assertNotNull((Object)subset.getProperty("onlyinjndi"));
        Assert.assertTrue((boolean)subset.getBoolean("onlyinjndi"));
        Assert.assertNotNull((Object)config.getProperty("java.version"));
        Assert.assertEquals((Object)System.getProperty("java.version"), (Object)config.getString("java.version"));
    }

    @Test
    public void testOptionalConfigurations() throws Exception {
        this.factory.setConfigurationURL(this.testDigesterFileOptional.toURL());
        Configuration config = this.factory.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element"));
        this.factory.setConfigurationURL(this.testDigesterFileOptionalEx.toURL());
        try {
            config = this.factory.getConfiguration();
            Assert.fail((String)"Unexisting properties loaded!");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadAbsolutePath() throws Exception {
        try {
            FileWriter out = null;
            try {
                out = new FileWriter(this.testAbsConfig);
                out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
                out.write("<configuration>");
                out.write("<properties fileName=\"");
                out.write(this.testProperties.getAbsolutePath());
                out.write("\"/>");
                out.write("</configuration>");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            this.factory.setConfigurationFileName(this.testAbsConfig.toString());
            Configuration config = this.factory.getConfiguration();
            Assert.assertTrue((boolean)config.getBoolean("configuration.loaded"));
        }
        finally {
            if (this.testAbsConfig.exists()) {
                this.testAbsConfig.delete();
            }
        }
    }

    @Test
    public void testBasePath() throws Exception {
        Assert.assertEquals((Object)".", (Object)this.factory.getBasePath());
        this.factory.setConfigurationFileName(this.testDigesterFile.getAbsolutePath());
        Assert.assertEquals((Object)this.testDigesterFile.getParentFile().getAbsolutePath(), (Object)this.factory.getBasePath());
        String homeDir = System.getProperty("user.home");
        this.factory = new ConfigurationFactory();
        this.factory.setBasePath(homeDir);
        this.factory.setConfigurationFileName(this.testDigesterFile.getAbsolutePath());
        Assert.assertEquals((Object)homeDir, (Object)this.factory.getBasePath());
        this.factory = new ConfigurationFactory(this.testDigesterFile.getAbsolutePath());
        Assert.assertEquals((Object)this.testDigesterFile.getParentFile().getAbsolutePath(), (Object)this.factory.getBasePath());
        this.factory.setBasePath(homeDir);
        Assert.assertEquals((Object)homeDir, (Object)this.factory.getBasePath());
        this.factory = new ConfigurationFactory();
        this.factory.setConfigurationURL(this.testDigesterFile.toURL());
        Assert.assertEquals((Object)this.testDigesterFile.toURL().toString(), (Object)this.factory.getBasePath());
    }

    @Test
    public void testLoadingWithSystemProperties() throws ConfigurationException {
        System.setProperty("config.file", "test.properties");
        this.factory.setConfigurationFileName(this.testDigesterFileSysProps.getAbsolutePath());
        Configuration config = this.factory.getConfiguration();
        Assert.assertTrue((String)"Configuration not loaded", (boolean)config.getBoolean("configuration.loaded"));
    }

    @Test
    public void testLoadInitProperties() throws ConfigurationException {
        this.factory.setConfigurationFileName(this.testDigesterFileInitProps.getAbsolutePath());
        Configuration config = this.factory.getConfiguration();
        PropertiesConfiguration c = (PropertiesConfiguration)((CompositeConfiguration)config).getConfiguration(0);
        Assert.assertEquals((String)"List delimiter was not set", (long)59L, (long)c.getListDelimiter());
        List l = c.getList("test.mixed.array");
        Assert.assertEquals((String)"Wrong number of list elements", (long)2L, (long)l.size());
        Assert.assertEquals((String)"List delimiter was not applied", (Object)"b, c, d", l.get(1));
    }

    private void checkUnionConfig() throws Exception {
        this.compositeConfiguration = (CompositeConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (long)3L, (long)this.compositeConfiguration.getNumberOfConfigurations());
        Object prop = this.compositeConfiguration.getProperty("tables.table.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"users", (Object)this.compositeConfiguration.getProperty("tables.table(0).name"));
        Assert.assertEquals((Object)"documents", (Object)this.compositeConfiguration.getProperty("tables.table(1).name"));
        Assert.assertEquals((Object)"tasks", (Object)this.compositeConfiguration.getProperty("tables.table(2).name"));
        prop = this.compositeConfiguration.getProperty("tables.table.fields.field.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)17L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"smtp.mydomain.org", (Object)this.compositeConfiguration.getString("mail.host.smtp"));
        Assert.assertEquals((Object)"pop3.mydomain.org", (Object)this.compositeConfiguration.getString("mail.host.pop"));
        Assert.assertEquals((Object)"masterOfPost", (Object)this.compositeConfiguration.getString("mail.account.user"));
        Assert.assertEquals((Object)"topsecret", (Object)this.compositeConfiguration.getString("mail.account.psswd"));
        Assert.assertEquals((Object)"enhanced factory", (Object)this.compositeConfiguration.getString("test.configuration"));
    }

    private void checkCompositeConfiguration() throws Exception {
        this.compositeConfiguration = (CompositeConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (long)2L, (long)this.compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, this.compositeConfiguration.getConfiguration(0).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)pc.getBoolean("test.boolean"));
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        Object property = this.compositeConfiguration.getProperty("element2.subelement.subsubelement");
        Assert.assertNull((String)"Should have returned a null", (Object)property);
    }
}

