/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.utils.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TimeUtilsTest {
    public static Stream<Arguments> dateToNtfsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.000Z", 0}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.000Z", 1}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.999Z", -1}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.001Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.001Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.000Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.999Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.999Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.998Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.000Z", 116444736000000000L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.000Z", 116444736000000001L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.001Z", 116444736000000000L + TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.999Z", 116444735999999999L}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.999Z", 116444736000000000L - TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}));
    }

    public static Stream<Arguments> fileTimeToNtfsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000000Z", 0}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000001Z", 1}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9999999Z", -1}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0010000Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0010001Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0009999Z", TimeUtils.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9990000Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9990001Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9989999Z", -TimeUtils.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0000000Z", 116444736000000000L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0000001Z", 116444736000000001L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0010000Z", 116444736000000000L + TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.9999999Z", 116444735999999999L}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.9990000Z", 116444736000000000L - TimeUtils.HUNDRED_NANOS_PER_MILLISECOND}));
    }

    public static Stream<Arguments> fileTimeToUnixTimeArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{0L, "1970-01-01T00:00:00Z"}), Arguments.of((Object[])new Object[]{1672141989L, "2022-12-27T11:53:09Z"}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "2038-01-19T03:14:07Z"}));
    }

    public static Stream<Arguments> truncateFileTimeProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"2022-05-10T18:25:33.123456789Z", "2022-05-10T18:25:33.1234567Z"}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.000000001Z", "1970-01-01T00:00:00.0000000Z"}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.000000010Z", "1970-01-01T00:00:00.0000000Z"}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.000000199Z", "1970-01-01T00:00:00.0000001Z"}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.999999999Z", "1969-12-31T23:59:59.9999999Z"}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.000000001Z", "1969-12-31T23:59:59.0000000Z"}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.000000010Z", "1969-12-31T23:59:59.0000000Z"}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.000000199Z", "1969-12-31T23:59:59.0000001Z"}));
    }

    @Test
    public void shouldCheckWhetherTimeCanBeRepresentedAsUnixTime() {
        Assertions.assertTrue((boolean)TimeUtils.isUnixTime(null));
        Assertions.assertTrue((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("2022-12-27T12:45:22Z"))));
        Assertions.assertTrue((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("2038-01-19T03:14:07Z"))));
        Assertions.assertTrue((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("1901-12-13T23:14:08Z"))));
        Assertions.assertFalse((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("1901-12-13T03:14:08Z"))));
        Assertions.assertFalse((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("2038-01-19T03:14:08Z"))));
        Assertions.assertFalse((boolean)TimeUtils.isUnixTime((FileTime)FileTime.from(Instant.parse("2099-06-30T12:31:42Z"))));
    }

    @ParameterizedTest
    @MethodSource(value={"dateToNtfsProvider"})
    public void shouldConvertDateToFileTime(String instant, long ignored) {
        Instant parsedInstant = Instant.parse(instant);
        FileTime parsedFileTime = FileTime.from(parsedInstant);
        Date parsedDate = Date.from(parsedInstant);
        Assertions.assertEquals((Object)parsedFileTime, (Object)TimeUtils.toFileTime((Date)parsedDate));
    }

    @ParameterizedTest
    @MethodSource(value={"dateToNtfsProvider"})
    public void shouldConvertDateToNtfsTime(String instant, long ntfsTime) {
        long ntfsMillis = Math.floorDiv(ntfsTime, TimeUtils.HUNDRED_NANOS_PER_MILLISECOND) * TimeUtils.HUNDRED_NANOS_PER_MILLISECOND;
        Date parsed = Date.from(Instant.parse(instant));
        long converted = TimeUtils.toNtfsTime((Date)parsed);
        Assertions.assertEquals((long)ntfsMillis, (long)converted);
        Assertions.assertEquals((long)converted, (long)SevenZArchiveEntry.javaTimeToNtfsTime((Date)parsed));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToNtfsProvider"})
    public void shouldConvertFileTimeToDate(String instant, long ignored) {
        Instant parsedInstant = Instant.parse(instant);
        FileTime parsedFileTime = FileTime.from(parsedInstant);
        Date parsedDate = Date.from(parsedInstant);
        Assertions.assertEquals((Object)parsedDate, (Object)TimeUtils.toDate((FileTime)parsedFileTime));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToNtfsProvider"})
    public void shouldConvertFileTimeToNtfsTime(String instant, long ntfsTime) {
        FileTime parsed = FileTime.from(Instant.parse(instant));
        Assertions.assertEquals((long)ntfsTime, (long)TimeUtils.toNtfsTime((FileTime)parsed));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToUnixTimeArguments"})
    public void shouldConvertFileTimeToUnixTime(long expectedUnixTime, String instant) {
        Assertions.assertEquals((long)expectedUnixTime, (long)TimeUtils.toUnixTime((FileTime)FileTime.from(Instant.parse(instant))));
    }

    @ParameterizedTest
    @MethodSource(value={"dateToNtfsProvider"})
    public void shouldConvertNtfsTimeToDate(String instant, long ntfsTime) {
        Date converted = TimeUtils.ntfsTimeToDate((long)ntfsTime);
        Assertions.assertEquals((Object)Instant.parse(instant), (Object)converted.toInstant());
        Assertions.assertEquals((Object)converted, (Object)SevenZArchiveEntry.ntfsTimeToJavaTime((long)ntfsTime));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToNtfsProvider"})
    public void shouldConvertNtfsTimeToFileTime(String instant, long ntfsTime) {
        FileTime parsed = FileTime.from(Instant.parse(instant));
        Assertions.assertEquals((Object)parsed, (Object)TimeUtils.ntfsTimeToFileTime((long)ntfsTime));
    }

    @Test
    public void shouldConvertNullDateToNullFileTime() {
        Assertions.assertNull((Object)TimeUtils.toFileTime(null));
    }

    @Test
    public void shouldConvertNullFileTimeToNullDate() {
        Assertions.assertNull((Object)TimeUtils.toDate(null));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToUnixTimeArguments"})
    public void shouldConvertUnixTimeToFileTime(long unixTime, String expectedInstant) {
        Assertions.assertEquals((Object)Instant.parse(expectedInstant), (Object)TimeUtils.unixTimeToFileTime((long)unixTime).toInstant());
    }

    @ParameterizedTest
    @MethodSource(value={"truncateFileTimeProvider"})
    public void shouldTruncateFileTimeToHundredNanos(String original, String truncated) {
        FileTime originalTime = FileTime.from(Instant.parse(original));
        FileTime truncatedTime = FileTime.from(Instant.parse(truncated));
        Assertions.assertEquals((Object)truncatedTime, (Object)TimeUtils.truncateToHundredNanos((FileTime)originalTime));
    }
}

