/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZstdCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);){
            Assertions.assertEquals((long)1L, (long)in.skip(1L));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File original = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        long originalFileLength = original.length();
        byte[] originalFileContent = new byte[(int)originalFileLength];
        try (InputStream ois = Files.newInputStream(original.toPath(), new OpenOption[0]);){
            ois.read(originalFileContent);
        }
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);){
            Assertions.assertEquals((int)originalFileContent[0], (int)in.read());
        }
    }

    @Test
    public void testCachingIsEnabledByDefaultAndZstdUtilsPresent() {
        Assertions.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        Assertions.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assertions.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            Assertions.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assertions.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
            Assertions.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void testZstandardUnarchive() throws Exception {
        File input = ZstdCompressorInputStreamTest.getFile("bla.tar.zst");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("zstd", is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testZstdDecode() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assertions.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testZstdDecodeWithNoPool() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream, NoPool.INSTANCE);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assertions.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testZstdDecodeWithRecyclingBufferPool() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream, RecyclingBufferPool.INSTANCE);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assertions.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }
}

