/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import org.apache.commons.compress.compressors.xz.XZUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XZUtilsTestCase {
    @Test
    public void testCachingIsEnabledByDefaultAndXZIsPresent() {
        Assertions.assertEquals((Object)XZUtils.CachedAvailability.CACHED_AVAILABLE, (Object)XZUtils.getCachedXZAvailability());
        Assertions.assertTrue((boolean)XZUtils.isXZCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            XZUtils.setCacheXZAvailablity((boolean)false);
            Assertions.assertEquals((Object)XZUtils.CachedAvailability.DONT_CACHE, (Object)XZUtils.getCachedXZAvailability());
            Assertions.assertTrue((boolean)XZUtils.isXZCompressionAvailable());
        }
        finally {
            XZUtils.setCacheXZAvailablity((boolean)true);
        }
    }

    @Test
    public void testGetCompressedFilename() {
        Assertions.assertEquals((Object)".xz", (Object)XZUtils.getCompressedFilename((String)""));
        Assertions.assertEquals((Object)"x.xz", (Object)XZUtils.getCompressedFilename((String)"x"));
        Assertions.assertEquals((Object)"x.txz", (Object)XZUtils.getCompressedFilename((String)"x.tar"));
        Assertions.assertEquals((Object)"x.wmf .xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf "));
        Assertions.assertEquals((Object)"x.wmf\n.xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf\n"));
        Assertions.assertEquals((Object)"x.wmf.y.xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assertions.assertEquals((Object)"", (Object)XZUtils.getUncompressedFilename((String)""));
        Assertions.assertEquals((Object)".xz", (Object)XZUtils.getUncompressedFilename((String)".xz"));
        Assertions.assertEquals((Object)"x.tar", (Object)XZUtils.getUncompressedFilename((String)"x.txz"));
        Assertions.assertEquals((Object)"x", (Object)XZUtils.getUncompressedFilename((String)"x.xz"));
        Assertions.assertEquals((Object)"x", (Object)XZUtils.getUncompressedFilename((String)"x-xz"));
        Assertions.assertEquals((Object)"x.txz ", (Object)XZUtils.getUncompressedFilename((String)"x.txz "));
        Assertions.assertEquals((Object)"x.txz\n", (Object)XZUtils.getUncompressedFilename((String)"x.txz\n"));
        Assertions.assertEquals((Object)"x.txz.y", (Object)XZUtils.getUncompressedFilename((String)"x.txz.y"));
    }

    @Test
    public void testIsCompressedFilename() {
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)""));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)".xz"));
        Assertions.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.txz"));
        Assertions.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.xz"));
        Assertions.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x-xz"));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xxgz"));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xzz"));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xaz"));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz "));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz\n"));
        Assertions.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz.y"));
    }

    @Test
    public void testMatches() {
        byte[] data = new byte[]{-3, 55, 122, 88, 90, 0};
        Assertions.assertFalse((boolean)XZUtils.matches((byte[])data, (int)5));
        Assertions.assertTrue((boolean)XZUtils.matches((byte[])data, (int)6));
        Assertions.assertTrue((boolean)XZUtils.matches((byte[])data, (int)7));
        data[5] = 48;
        Assertions.assertFalse((boolean)XZUtils.matches((byte[])data, (int)6));
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            XZUtils.setCacheXZAvailablity((boolean)false);
            Assertions.assertEquals((Object)XZUtils.CachedAvailability.DONT_CACHE, (Object)XZUtils.getCachedXZAvailability());
            XZUtils.setCacheXZAvailablity((boolean)true);
            Assertions.assertEquals((Object)XZUtils.CachedAvailability.CACHED_AVAILABLE, (Object)XZUtils.getCachedXZAvailability());
        }
        finally {
            XZUtils.setCacheXZAvailablity((boolean)true);
        }
    }
}

