/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XZCompressorInputStreamTest {
    private void multiByteReadConsistentlyReturnsMinusOneAtEof(boolean decompressConcatenated) throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.xz");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             XZCompressorInputStream in = new XZCompressorInputStream(is, decompressConcatenated);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofDecompressConcatenated() throws IOException {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(true);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofNoDecompressConcatenated() throws IOException {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(false);
    }

    @Test
    public void redundantTestOfAlmostDeprecatedMatchesMethod() {
        byte[] data = new byte[]{-3, 55, 122, 88, 90, 0};
        Assertions.assertFalse((boolean)XZCompressorInputStream.matches((byte[])data, (int)5));
        Assertions.assertTrue((boolean)XZCompressorInputStream.matches((byte[])data, (int)6));
        Assertions.assertTrue((boolean)XZCompressorInputStream.matches((byte[])data, (int)7));
        data[5] = 48;
        Assertions.assertFalse((boolean)XZCompressorInputStream.matches((byte[])data, (int)6));
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(boolean decompressConcatenated) throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.xz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             XZCompressorInputStream in = new XZCompressorInputStream(is, decompressConcatenated);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofDecompressConcatenated() throws IOException {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(true);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofNoDecompressConcatenated() throws IOException {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(false);
    }
}

