/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GzipCompressorOutputStreamTest {
    private void testFileName(String expected, String sourceFile) throws IOException {
        Path tempSourceFile = Files.createTempFile(sourceFile, sourceFile, new FileAttribute[0]);
        Files.write(tempSourceFile, "<text>Hello World!</text>".getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        Path targetFile = Files.createTempFile("test", ".gz", new FileAttribute[0]);
        GzipParameters parameters = new GzipParameters();
        parameters.setFilename(sourceFile);
        try (OutputStream fos = Files.newOutputStream(targetFile, new OpenOption[0]);
             GzipCompressorOutputStream gos = new GzipCompressorOutputStream(fos, parameters);){
            Files.copy(tempSourceFile, (OutputStream)gos);
        }
        try (GzipCompressorInputStream gis = new GzipCompressorInputStream(Files.newInputStream(targetFile, new OpenOption[0]));){
            Assertions.assertEquals((Object)expected, (Object)gis.getMetaData().getFilename());
        }
    }

    @Test
    public void testFileNameAscii() throws IOException {
        this.testFileName("ASCII.xml", "ASCII.xml");
    }

    @Test
    public void testFileNameChinesePercentEncoded() throws IOException {
        this.testFileName("%E6%B5%8B%E8%AF%95%E4%B8%AD%E6%96%87%E5%90%8D%E7%A7%B0.xml", "\u6d4b\u8bd5\u4e2d\u6587\u540d\u79f0.xml");
    }
}

