/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DataDescriptorTest {
    private File dir;

    @Test
    public void doesntWriteDataDescriptorForDeflatedEntryOnSeekableOutput() throws IOException {
        File f = new File(this.dir, "test.zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(f);){
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("test1.txt"));
            zos.write("foo".getBytes(StandardCharsets.UTF_8));
            zos.closeArchiveEntry();
        }
        byte[] data = Files.readAllBytes(f.toPath());
        byte[] versionInLFH = Arrays.copyOfRange(data, 4, 6);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInLFH);
        byte[] gpbInLFH = Arrays.copyOfRange(data, 6, 8);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 8}, (byte[])gpbInLFH);
        int cdhStart = this.findCentralDirectory(data);
        byte[] versionInCDH = Arrays.copyOfRange(data, cdhStart + 6, cdhStart + 8);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInCDH);
        byte[] gpbInCDH = Arrays.copyOfRange(data, cdhStart + 8, cdhStart + 10);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 8}, (byte[])gpbInCDH);
        int ddStart = cdhStart - 16;
        Assertions.assertNotEquals((Object)ZipLong.DD_SIG, (Object)new ZipLong(data, ddStart));
        long crcFromLFH = ZipLong.getValue((byte[])data, (int)14);
        long cSizeFromLFH = ZipLong.getValue((byte[])data, (int)18);
        long sizeFromLFH = ZipLong.getValue((byte[])data, (int)22);
        Assertions.assertEquals((long)3L, (long)sizeFromLFH);
        long crcFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 16));
        Assertions.assertEquals((long)crcFromLFH, (long)crcFromCDH);
        long cSizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 20));
        Assertions.assertEquals((long)cSizeFromLFH, (long)cSizeFromCDH);
        long sizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 24));
        Assertions.assertEquals((long)sizeFromLFH, (long)sizeFromCDH);
    }

    @Test
    public void doesntWriteDataDescriptorWhenAddingRawEntries() throws IOException {
        ByteArrayOutputStream init = new ByteArrayOutputStream();
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)init);){
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("test1.txt"));
            zos.write("foo".getBytes(StandardCharsets.UTF_8));
            zos.closeArchiveEntry();
        }
        File f = new File(this.dir, "test.zip");
        try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            fos.write(init.toByteArray());
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try (ZipFile zf = new ZipFile(f);
             ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)o);){
            ZipArchiveEntry zae = zf.getEntry("test1.txt");
            zos.addRawArchiveEntry(zae, zf.getRawInputStream(zae));
        }
        byte[] data = o.toByteArray();
        byte[] versionInLFH = Arrays.copyOfRange(data, 4, 6);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInLFH);
        byte[] gpbInLFH = Arrays.copyOfRange(data, 6, 8);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 8}, (byte[])gpbInLFH);
        int cdhStart = this.findCentralDirectory(data);
        byte[] versionInCDH = Arrays.copyOfRange(data, cdhStart + 6, cdhStart + 8);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInCDH);
        byte[] gpbInCDH = Arrays.copyOfRange(data, cdhStart + 8, cdhStart + 10);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 8}, (byte[])gpbInCDH);
        int ddStart = cdhStart - 16;
        Assertions.assertNotEquals((Object)ZipLong.DD_SIG, (Object)new ZipLong(data, ddStart));
        long crcFromLFH = ZipLong.getValue((byte[])data, (int)14);
        long cSizeFromLFH = ZipLong.getValue((byte[])data, (int)18);
        long sizeFromLFH = ZipLong.getValue((byte[])data, (int)22);
        Assertions.assertEquals((long)3L, (long)sizeFromLFH);
        long crcFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 16));
        Assertions.assertEquals((long)crcFromLFH, (long)crcFromCDH);
        long cSizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 20));
        Assertions.assertEquals((long)cSizeFromLFH, (long)cSizeFromCDH);
        long sizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 24));
        Assertions.assertEquals((long)sizeFromLFH, (long)sizeFromCDH);
    }

    private int findCentralDirectory(byte[] data) {
        return (int)ZipLong.getValue((byte[])data, (int)(data.length - 22 + 16));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.dir = AbstractTestCase.mkdir("ddtest");
    }

    @AfterEach
    public void tearDown() {
        AbstractTestCase.rmdir(this.dir);
    }

    @Test
    public void writesDataDescriptorForDeflatedEntryOnUnseekableOutput() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)o);){
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("test1.txt"));
            zos.write("foo".getBytes(StandardCharsets.UTF_8));
            zos.closeArchiveEntry();
        }
        byte[] data = o.toByteArray();
        byte[] versionInLFH = Arrays.copyOfRange(data, 4, 6);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInLFH);
        byte[] gpbInLFH = Arrays.copyOfRange(data, 6, 8);
        Assertions.assertArrayEquals((byte[])new byte[]{8, 8}, (byte[])gpbInLFH);
        byte[] crcAndSizedInLFH = Arrays.copyOfRange(data, 14, 26);
        Assertions.assertArrayEquals((byte[])new byte[12], (byte[])crcAndSizedInLFH);
        int cdhStart = this.findCentralDirectory(data);
        byte[] versionInCDH = Arrays.copyOfRange(data, cdhStart + 6, cdhStart + 8);
        Assertions.assertArrayEquals((byte[])new byte[]{20, 0}, (byte[])versionInCDH);
        byte[] gpbInCDH = Arrays.copyOfRange(data, cdhStart + 8, cdhStart + 10);
        Assertions.assertArrayEquals((byte[])new byte[]{8, 8}, (byte[])gpbInCDH);
        int ddStart = cdhStart - 16;
        Assertions.assertEquals((Object)ZipLong.DD_SIG, (Object)new ZipLong(data, ddStart));
        long crcFromDD = ZipLong.getValue((byte[])data, (int)(ddStart + 4));
        long cSizeFromDD = ZipLong.getValue((byte[])data, (int)(ddStart + 8));
        long sizeFromDD = ZipLong.getValue((byte[])data, (int)(ddStart + 12));
        Assertions.assertEquals((long)3L, (long)sizeFromDD);
        long crcFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 16));
        Assertions.assertEquals((long)crcFromDD, (long)crcFromCDH);
        long cSizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 20));
        Assertions.assertEquals((long)cSizeFromDD, (long)cSizeFromCDH);
        long sizeFromCDH = ZipLong.getValue((byte[])data, (int)(cdhStart + 24));
        Assertions.assertEquals((long)sizeFromDD, (long)sizeFromCDH);
    }
}

