/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArArchiveOutputStreamTest
extends AbstractTestCase {
    @Test
    public void testLongFileNamesCauseExceptionByDefault() throws IOException {
        try (ArArchiveOutputStream os = new ArArchiveOutputStream((OutputStream)new ByteArrayOutputStream());){
            ArArchiveEntry ae = new ArArchiveEntry("this_is_a_long_name.txt", 0L);
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> os.putArchiveEntry((ArchiveEntry)ae), (String)"Expected an exception");
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("File name too long"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongFileNamesWorkUsingBSDDialect() throws Exception {
        File[] df = this.createTempDirAndFile();
        try (OutputStream fos = Files.newOutputStream(df[1].toPath(), new OpenOption[0]);
             ArArchiveOutputStream os = new ArArchiveOutputStream(fos);){
            os.setLongFileMode(1);
            ArArchiveEntry ae = new ArArchiveEntry("this_is_a_long_name.txt", 14L);
            os.putArchiveEntry((ArchiveEntry)ae);
            os.write(new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10});
            os.closeArchiveEntry();
            ArrayList<String> expected = new ArrayList<String>();
            expected.add("this_is_a_long_name.txt");
            this.checkArchiveContent(df[1], expected);
        }
        finally {
            ArArchiveOutputStreamTest.rmdir(df[0]);
        }
    }
}

