/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Socket level networking using TCP or UDP with Netty 4.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NettyEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Netty component.
     */
    public interface NettyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedNettyEndpointConsumerBuilder advanced() {
            return (AdvancedNettyEndpointConsumerBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reuseAddress(boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reuseAddress(String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reuseChannel(boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reuseChannel(String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to choose Multicast over UDP.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param broadcast the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder broadcast(boolean broadcast) {
            doSetProperty("broadcast", broadcast);
            return this;
        }
        /**
         * Setting to choose Multicast over UDP.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param broadcast the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder broadcast(String broadcast) {
            doSetProperty("broadcast", broadcast);
            return this;
        }
        /**
         * If the clientMode is true, netty consumer will connect the address as
         * a TCP client.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clientMode the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder clientMode(boolean clientMode) {
            doSetProperty("clientMode", clientMode);
            return this;
        }
        /**
         * If the clientMode is true, netty consumer will connect the address as
         * a TCP client.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clientMode the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder clientMode(String clientMode) {
            doSetProperty("clientMode", clientMode);
            return this;
        }
        /**
         * Used only in clientMode in consumer, the consumer will attempt to
         * reconnect on disconnection if this is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Used only in clientMode in consumer, the consumer will attempt to
         * reconnect on disconnection if this is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Used if reconnect and clientMode is enabled. The interval in milli
         * seconds to attempt reconnection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param reconnectInterval the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reconnectInterval(
                int reconnectInterval) {
            doSetProperty("reconnectInterval", reconnectInterval);
            return this;
        }
        /**
         * Used if reconnect and clientMode is enabled. The interval in milli
         * seconds to attempt reconnection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param reconnectInterval the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder reconnectInterval(
                String reconnectInterval) {
            doSetProperty("reconnectInterval", reconnectInterval);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder autoAppendDelimiter(
                boolean autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder autoAppendDelimiter(
                String autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder delimiter(
                org.apache.camel.component.netty.TextLineDelimiter delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * The encoding (a charset name) to use for the textline codec. If not
         * provided, Camel will use the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder enabledProtocols(
                String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keyStoreFile(
                java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keyStoreFile(String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keyStoreFormat(
                String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder keyStoreResource(
                String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Configures whether the server needs client authentication when using
         * SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param needClientAuth the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder needClientAuth(
                boolean needClientAuth) {
            doSetProperty("needClientAuth", needClientAuth);
            return this;
        }
        /**
         * Configures whether the server needs client authentication when using
         * SSL.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param needClientAuth the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder needClientAuth(
                String needClientAuth) {
            doSetProperty("needClientAuth", needClientAuth);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder securityProvider(
                String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder trustStoreFile(
                java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder trustStoreFile(
                String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointConsumerBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Netty component.
     */
    public interface AdvancedNettyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default NettyEndpointConsumerBuilder basic() {
            return (NettyEndpointConsumerBuilder) this;
        }
        /**
         * Allows to configure a backlog for netty consumer (server). Note the
         * backlog is just a best effort depending on the OS. Setting this
         * option to a value such as 200, 500 or 1000, tells the TCP stack how
         * long the accept queue can be If this option is not configured, then
         * the backlog depends on OS setting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder backlog(int backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * Allows to configure a backlog for netty consumer (server). Note the
         * backlog is just a best effort depending on the OS. Setting this
         * option to a value such as 200, 500 or 1000, tells the TCP stack how
         * long the accept queue can be If this option is not configured, then
         * the backlog depends on OS setting.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder backlog(String backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default bossCount parameter
         * from Netty, which is 1. User can use this option to override the
         * default bossCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer (advanced)
         * 
         * @param bossCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bossCount(int bossCount) {
            doSetProperty("bossCount", bossCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default bossCount parameter
         * from Netty, which is 1. User can use this option to override the
         * default bossCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer (advanced)
         * 
         * @param bossCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bossCount(String bossCount) {
            doSetProperty("bossCount", bossCount);
            return this;
        }
        /**
         * Set the BossGroup which could be used for handling the new connection
         * of the server side across the NettyEndpoint.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param bossGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bossGroup(
                io.netty.channel.EventLoopGroup bossGroup) {
            doSetProperty("bossGroup", bossGroup);
            return this;
        }
        /**
         * Set the BossGroup which could be used for handling the new connection
         * of the server side across the NettyEndpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param bossGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bossGroup(String bossGroup) {
            doSetProperty("bossGroup", bossGroup);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If sync is enabled then this option dictates NettyConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates NettyConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use a custom NettyServerBootstrapFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyServerBootstrapFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettyServerBootstrapFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder nettyServerBootstrapFactory(
                org.apache.camel.component.netty.NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }
        /**
         * To use a custom NettyServerBootstrapFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.NettyServerBootstrapFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettyServerBootstrapFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder nettyServerBootstrapFactory(
                String nettyServerBootstrapFactory) {
            doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }
        /**
         * When using UDP then this option can be used to specify a network
         * interface by its name, such as eth0 to join a multicast group.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param networkInterface the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder networkInterface(
                String networkInterface) {
            doSetProperty("networkInterface", networkInterface);
            return this;
        }
        /**
         * If sync is enabled this option dictates NettyConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder noReplyLogLevel(
                org.apache.camel.LoggingLevel noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If sync is enabled this option dictates NettyConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder noReplyLogLevel(
                String noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an
         * java.nio.channels.ClosedChannelException then its logged using this
         * logging level. This is used to avoid logging the closed channel
         * exceptions, as clients can disconnect abruptly and then cause a flood
         * of closed exceptions in the Netty server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: DEBUG
         * Group: consumer (advanced)
         * 
         * @param serverClosedChannelExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(
                org.apache.camel.LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an
         * java.nio.channels.ClosedChannelException then its logged using this
         * logging level. This is used to avoid logging the closed channel
         * exceptions, as clients can disconnect abruptly and then cause a flood
         * of closed exceptions in the Netty server.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: DEBUG
         * Group: consumer (advanced)
         * 
         * @param serverClosedChannelExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(
                String serverClosedChannelExceptionCaughtLogLevel) {
            doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an exception then its logged
         * using this logging level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param serverExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverExceptionCaughtLogLevel(
                org.apache.camel.LoggingLevel serverExceptionCaughtLogLevel) {
            doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an exception then its logged
         * using this logging level.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param serverExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverExceptionCaughtLogLevel(
                String serverExceptionCaughtLogLevel) {
            doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }
        /**
         * To use a custom ServerInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ServerInitializerFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param serverInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverInitializerFactory(
                org.apache.camel.component.netty.ServerInitializerFactory serverInitializerFactory) {
            doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }
        /**
         * To use a custom ServerInitializerFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.ServerInitializerFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param serverInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder serverInitializerFactory(
                String serverInitializerFactory) {
            doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param usingExecutorService the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder usingExecutorService(
                boolean usingExecutorService) {
            doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param usingExecutorService the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder usingExecutorService(
                String usingExecutorService) {
            doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder channelGroup(
                String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder options(
                String key,
                Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder sendBufferSize(
                int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder udpByteArrayCodec(
                boolean udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder udpByteArrayCodec(
                String udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder workerCount(int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder workerCount(
                String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointConsumerBuilder workerGroup(
                String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Netty component.
     */
    public interface NettyEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNettyEndpointProducerBuilder advanced() {
            return (AdvancedNettyEndpointProducerBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder reuseAddress(boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder reuseAddress(String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder reuseChannel(boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder reuseChannel(String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Time to wait for a socket connection to be available. Value is in
         * milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Time to wait for a socket connection to be available. Value is in
         * milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Allows to use a timeout for the Netty producer when calling a remote
         * server. By default no timeout is in use. The value is in milli
         * seconds, so eg 30000 is 30 seconds. The requestTimeout is using
         * Netty's ReadTimeoutHandler to trigger the timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Allows to use a timeout for the Netty producer when calling a remote
         * server. By default no timeout is in use. The value is in milli
         * seconds, so eg 30000 is 30 seconds. The requestTimeout is using
         * Netty's ReadTimeoutHandler to trigger the timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder autoAppendDelimiter(
                boolean autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder autoAppendDelimiter(
                String autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder delimiter(
                org.apache.camel.component.netty.TextLineDelimiter delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * The encoding (a charset name) to use for the textline codec. If not
         * provided, Camel will use the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder enabledProtocols(
                String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keyStoreFile(
                java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keyStoreFile(String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keyStoreFormat(
                String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder keyStoreResource(
                String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder securityProvider(
                String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder trustStoreFile(
                java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder trustStoreFile(
                String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointProducerBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Netty component.
     */
    public interface AdvancedNettyEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default NettyEndpointProducerBuilder basic() {
            return (NettyEndpointProducerBuilder) this;
        }
        /**
         * To use a custom ClientInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ClientInitializerFactory&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param clientInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder clientInitializerFactory(
                org.apache.camel.component.netty.ClientInitializerFactory clientInitializerFactory) {
            doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }
        /**
         * To use a custom ClientInitializerFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.ClientInitializerFactory&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param clientInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder clientInitializerFactory(
                String clientInitializerFactory) {
            doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }
        /**
         * To use a custom correlation manager to manage how request and reply
         * messages are mapped when using request/reply with the netty producer.
         * This should only be used if you have a way to map requests together
         * with replies such as if there is correlation ids in both the request
         * and reply messages. This can be used if you want to multiplex
         * concurrent messages on the same channel (aka connection) in netty.
         * When doing this you must have a way to correlate the request and
         * reply messages so you can store the right reply on the inflight Camel
         * Exchange before its continued routed. We recommend extending the
         * TimeoutCorrelationManagerSupport when you build custom correlation
         * managers. This provides support for timeout and other complexities
         * you otherwise would need to implement as well. See also the
         * producerPoolEnabled option for more details.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyCamelStateCorrelationManager&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param correlationManager the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder correlationManager(
                org.apache.camel.component.netty.NettyCamelStateCorrelationManager correlationManager) {
            doSetProperty("correlationManager", correlationManager);
            return this;
        }
        /**
         * To use a custom correlation manager to manage how request and reply
         * messages are mapped when using request/reply with the netty producer.
         * This should only be used if you have a way to map requests together
         * with replies such as if there is correlation ids in both the request
         * and reply messages. This can be used if you want to multiplex
         * concurrent messages on the same channel (aka connection) in netty.
         * When doing this you must have a way to correlate the request and
         * reply messages so you can store the right reply on the inflight Camel
         * Exchange before its continued routed. We recommend extending the
         * TimeoutCorrelationManagerSupport when you build custom correlation
         * managers. This provides support for timeout and other complexities
         * you otherwise would need to implement as well. See also the
         * producerPoolEnabled option for more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.NettyCamelStateCorrelationManager&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param correlationManager the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder correlationManager(
                String correlationManager) {
            doSetProperty("correlationManager", correlationManager);
            return this;
        }
        /**
         * Channels can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazyChannelCreation the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder lazyChannelCreation(
                boolean lazyChannelCreation) {
            doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }
        /**
         * Channels can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazyChannelCreation the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder lazyChannelCreation(
                String lazyChannelCreation) {
            doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the value for the blockWhenExhausted configuration attribute. It
         * determines whether to block when the borrowObject() method is invoked
         * when the pool is exhausted (the maximum number of active objects has
         * been reached).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolBlockWhenExhausted the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolBlockWhenExhausted(
                boolean producerPoolBlockWhenExhausted) {
            doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }
        /**
         * Sets the value for the blockWhenExhausted configuration attribute. It
         * determines whether to block when the borrowObject() method is invoked
         * when the pool is exhausted (the maximum number of active objects has
         * been reached).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolBlockWhenExhausted the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolBlockWhenExhausted(
                String producerPoolBlockWhenExhausted) {
            doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }
        /**
         * Whether producer pool is enabled or not. Important: If you turn this
         * off then a single shared connection is used for the producer, also if
         * you are doing request/reply. That means there is a potential issue
         * with interleaved responses if replies comes back out-of-order.
         * Therefore you need to have a correlation id in both the request and
         * reply messages so you can properly correlate the replies to the Camel
         * callback that is responsible for continue processing the message in
         * Camel. To do this you need to implement
         * NettyCamelStateCorrelationManager as correlation manager and
         * configure it via the correlationManager option. See also the
         * correlationManager option for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolEnabled(
                boolean producerPoolEnabled) {
            doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }
        /**
         * Whether producer pool is enabled or not. Important: If you turn this
         * off then a single shared connection is used for the producer, also if
         * you are doing request/reply. That means there is a potential issue
         * with interleaved responses if replies comes back out-of-order.
         * Therefore you need to have a correlation id in both the request and
         * reply messages so you can properly correlate the replies to the Camel
         * callback that is responsible for continue processing the message in
         * Camel. To do this you need to implement
         * NettyCamelStateCorrelationManager as correlation manager and
         * configure it via the correlationManager option. See also the
         * correlationManager option for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolEnabled(
                String producerPoolEnabled) {
            doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }
        /**
         * Sets the cap on the number of idle instances in the pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxIdle(
                int producerPoolMaxIdle) {
            doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }
        /**
         * Sets the cap on the number of idle instances in the pool.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxIdle(
                String producerPoolMaxIdle) {
            doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }
        /**
         * Sets the cap on the number of objects that can be allocated by the
         * pool (checked out to clients, or idle awaiting checkout) at a given
         * time. Use a negative value for no limit.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxTotal the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxTotal(
                int producerPoolMaxTotal) {
            doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }
        /**
         * Sets the cap on the number of objects that can be allocated by the
         * pool (checked out to clients, or idle awaiting checkout) at a given
         * time. Use a negative value for no limit.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxTotal the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxTotal(
                String producerPoolMaxTotal) {
            doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }
        /**
         * Sets the maximum duration (value in millis) the borrowObject() method
         * should block before throwing an exception when the pool is exhausted
         * and producerPoolBlockWhenExhausted is true. When less than 0, the
         * borrowObject() method may block indefinitely.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxWait the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxWait(
                long producerPoolMaxWait) {
            doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }
        /**
         * Sets the maximum duration (value in millis) the borrowObject() method
         * should block before throwing an exception when the pool is exhausted
         * and producerPoolBlockWhenExhausted is true. When less than 0, the
         * borrowObject() method may block indefinitely.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxWait the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMaxWait(
                String producerPoolMaxWait) {
            doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }
        /**
         * Sets the minimum amount of time (value in millis) an object may sit
         * idle in the pool before it is eligible for eviction by the idle
         * object evictor.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer (advanced)
         * 
         * @param producerPoolMinEvictableIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMinEvictableIdle(
                long producerPoolMinEvictableIdle) {
            doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }
        /**
         * Sets the minimum amount of time (value in millis) an object may sit
         * idle in the pool before it is eligible for eviction by the idle
         * object evictor.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer (advanced)
         * 
         * @param producerPoolMinEvictableIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMinEvictableIdle(
                String producerPoolMinEvictableIdle) {
            doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }
        /**
         * Sets the minimum number of instances allowed in the producer pool
         * before the evictor thread (if active) spawns new objects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param producerPoolMinIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMinIdle(
                int producerPoolMinIdle) {
            doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }
        /**
         * Sets the minimum number of instances allowed in the producer pool
         * before the evictor thread (if active) spawns new objects.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param producerPoolMinIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder producerPoolMinIdle(
                String producerPoolMinIdle) {
            doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }
        /**
         * This option supports connection less udp sending which is a real fire
         * and forget. A connected udp send receive the PortUnreachableException
         * if no one is listen on the receiving port.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param udpConnectionlessSending the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder udpConnectionlessSending(
                boolean udpConnectionlessSending) {
            doSetProperty("udpConnectionlessSending", udpConnectionlessSending);
            return this;
        }
        /**
         * This option supports connection less udp sending which is a real fire
         * and forget. A connected udp send receive the PortUnreachableException
         * if no one is listen on the receiving port.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param udpConnectionlessSending the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder udpConnectionlessSending(
                String udpConnectionlessSending) {
            doSetProperty("udpConnectionlessSending", udpConnectionlessSending);
            return this;
        }
        /**
         * If the useByteBuf is true, netty producer will turn the message body
         * into ByteBuf before sending it out.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useByteBuf the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder useByteBuf(
                boolean useByteBuf) {
            doSetProperty("useByteBuf", useByteBuf);
            return this;
        }
        /**
         * If the useByteBuf is true, netty producer will turn the message body
         * into ByteBuf before sending it out.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useByteBuf the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder useByteBuf(
                String useByteBuf) {
            doSetProperty("useByteBuf", useByteBuf);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder channelGroup(
                String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder options(
                String key,
                Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder sendBufferSize(
                int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder udpByteArrayCodec(
                boolean udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder udpByteArrayCodec(
                String udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder workerCount(int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder workerCount(
                String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointProducerBuilder workerGroup(
                String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Netty component.
     */
    public interface NettyEndpointBuilder
            extends
                NettyEndpointConsumerBuilder,
                NettyEndpointProducerBuilder {
        default AdvancedNettyEndpointBuilder advanced() {
            return (AdvancedNettyEndpointBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder reuseAddress(boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder reuseAddress(String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder reuseChannel(boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder reuseChannel(String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder allowDefaultCodec(String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder autoAppendDelimiter(
                boolean autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder autoAppendDelimiter(
                String autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * The max line length to use for the textline codec.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder delimiter(
                org.apache.camel.component.netty.TextLineDelimiter delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * The encoding (a charset name) to use for the textline codec. If not
         * provided, Camel will use the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder enabledProtocols(String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keyStoreFile(java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keyStoreFile(String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keyStoreFormat(String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder keyStoreResource(String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder securityProvider(String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder trustStoreFile(java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder trustStoreFile(String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyEndpointBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Netty component.
     */
    public interface AdvancedNettyEndpointBuilder
            extends
                AdvancedNettyEndpointConsumerBuilder,
                AdvancedNettyEndpointProducerBuilder {
        default NettyEndpointBuilder basic() {
            return (NettyEndpointBuilder) this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder channelGroup(String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder options(String key, Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder sendBufferSize(int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder udpByteArrayCodec(
                boolean udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder udpByteArrayCodec(
                String udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder workerCount(int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder workerCount(String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyEndpointBuilder workerGroup(String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    public interface NettyBuilders {
        /**
         * Netty (camel-netty)
         * Socket level networking using TCP or UDP with Netty 4.x.
         * 
         * Category: networking
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty
         * 
         * @return the dsl builder for the headers' name.
         */
        default NettyHeaderNameBuilder netty() {
            return NettyHeaderNameBuilder.INSTANCE;
        }
        /**
         * Netty (camel-netty)
         * Socket level networking using TCP or UDP with Netty 4.x.
         * 
         * Category: networking
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty
         * 
         * Syntax: <code>netty:protocol://host:port</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use which can be tcp or udp.
         * There are 2 enums and the value can be one of: tcp, udp
         * 
         * Path parameter: host (required)
         * The hostname. For the consumer the hostname is localhost or 0.0.0.0.
         * For the producer the hostname is the remote host to connect to
         * 
         * Path parameter: port (required)
         * The host port number
         * 
         * @param path protocol://host:port
         * @return the dsl builder
         */
        default NettyEndpointBuilder netty(String path) {
            return NettyEndpointBuilderFactory.endpointBuilder("netty", path);
        }
        /**
         * Netty (camel-netty)
         * Socket level networking using TCP or UDP with Netty 4.x.
         * 
         * Category: networking
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty
         * 
         * Syntax: <code>netty:protocol://host:port</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use which can be tcp or udp.
         * There are 2 enums and the value can be one of: tcp, udp
         * 
         * Path parameter: host (required)
         * The hostname. For the consumer the hostname is localhost or 0.0.0.0.
         * For the producer the hostname is the remote host to connect to
         * 
         * Path parameter: port (required)
         * The host port number
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path protocol://host:port
         * @return the dsl builder
         */
        default NettyEndpointBuilder netty(String componentName, String path) {
            return NettyEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Netty component.
     */
    public static class NettyHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final NettyHeaderNameBuilder INSTANCE = new NettyHeaderNameBuilder();

        /**
         * Indicates whether the channel should be closed after complete.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyCloseChannelWhenComplete}.
         */
        public String nettyCloseChannelWhenComplete() {
            return "NettyCloseChannelWhenComplete";
        }

        /**
         * The channel handler context.
         * 
         * The option is a: {@code io.netty.channel.ChannelHandlerContext} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyChannelHandlerContext}.
         */
        public String nettyChannelHandlerContext() {
            return "NettyChannelHandlerContext";
        }

        /**
         * The remote address.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyRemoteAddress}.
         */
        public String nettyRemoteAddress() {
            return "NettyRemoteAddress";
        }

        /**
         * The local address.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyLocalAddress}.
         */
        public String nettyLocalAddress() {
            return "NettyLocalAddress";
        }

        /**
         * The SSL session.
         * 
         * The option is a: {@code javax.net.ssl.SSLSession} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLSession}.
         */
        public String nettySSLSession() {
            return "NettySSLSession";
        }

        /**
         * The SSL client certificate subject name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertSubjectName}.
         */
        public String nettySSLClientCertSubjectName() {
            return "NettySSLClientCertSubjectName";
        }

        /**
         * The SSL client certificate issuer name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertIssuerName}.
         */
        public String nettySSLClientCertIssuerName() {
            return "NettySSLClientCertIssuerName";
        }

        /**
         * The SSL client certificate serial number.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * NettySSLClientCertSerialNumber}.
         */
        public String nettySSLClientCertSerialNumber() {
            return "NettySSLClientCertSerialNumber";
        }

        /**
         * The SSL client certificate not before.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertNotBefore}.
         */
        public String nettySSLClientCertNotBefore() {
            return "NettySSLClientCertNotBefore";
        }

        /**
         * The SSL client certificate not after.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertNotAfter}.
         */
        public String nettySSLClientCertNotAfter() {
            return "NettySSLClientCertNotAfter";
        }

        /**
         * The read timeout.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyRequestTimeout}.
         */
        public String nettyRequestTimeout() {
            return "NettyRequestTimeout";
        }
    }
    static NettyEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class NettyEndpointBuilderImpl extends AbstractEndpointBuilder implements NettyEndpointBuilder, AdvancedNettyEndpointBuilder {
            public NettyEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new NettyEndpointBuilderImpl(path);
    }
}