/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class AccountInterface
 * \headerfile TelepathyQt/account.h <TelepathyQt/AccountManager>
 * \ingroup clientaccount
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Account".
 */
class TP_QT_EXPORT AccountInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Account", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Account");
    }

    /**
     * Creates a AccountInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AccountInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * A list of the extra interfaces provided by this account.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c DisplayName of type \c QString.
     *
     * 
     * The user-visible name of this account. This SHOULD be chosen by the 
     * user at account creation time. The account creation user interface is 
     * responsible for setting a reasonable default value in the user&apos;s 
     * locale; something like &quot;Jabber (bob@example.com)&quot; would be 
     * sensible.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDisplayName() const
    {
        return internalRequestProperty(QLatin1String("DisplayName"));
    }

    /**
     * Asynchronous setter for the remote object property \c DisplayName of type \c QString.
     *
     * 
     * The user-visible name of this account. This SHOULD be chosen by the 
     * user at account creation time. The account creation user interface is 
     * responsible for setting a reasonable default value in the user&apos;s 
     * locale; something like &quot;Jabber (bob@example.com)&quot; would be 
     * sensible.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyDisplayName(QString newValue)
    {
        return internalSetProperty(QLatin1String("DisplayName"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Icon of type \c QString.
     *
     * 
     * The name of an icon in the system&apos;s icon theme, such as 
     * &quot;im-msn&quot;, or the empty string to not specify an icon. If the 
     * icon is set to an empty string, the account manager or any client MAY 
     * derive a default icon, for instance from the protocol.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyIcon() const
    {
        return internalRequestProperty(QLatin1String("Icon"));
    }

    /**
     * Asynchronous setter for the remote object property \c Icon of type \c QString.
     *
     * 
     * The name of an icon in the system&apos;s icon theme, such as 
     * &quot;im-msn&quot;, or the empty string to not specify an icon. If the 
     * icon is set to an empty string, the account manager or any client MAY 
     * derive a default icon, for instance from the protocol.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyIcon(QString newValue)
    {
        return internalSetProperty(QLatin1String("Icon"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Valid of type \c bool.
     *
     * 
     * If true, this account is considered by the account manager to be 
     * complete and usable. If false, user action is required to make it 
     * usable, and it will never attempt to connect (for instance, this might 
     * be caused by the absence of a required parameter). For connection 
     * managers with a plugin architecture, like telepathy-haze, we have 
     * little or no control over the parameters offered; for platforms with 
     * package management, we have little or no control over the CMs offered. 
     * NMC 4.x would just pretend the account didn&apos;t exist in these 
     * circumstances, but silent data loss is bad, and UIs with CM-specific 
     * knowledge (or a user filling in newly-required parameters) might be 
     * able to rescue a broken account.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyValid() const
    {
        return internalRequestProperty(QLatin1String("Valid"));
    }

    /**
     * Asynchronous getter for the remote object property \c Enabled of type \c bool.
     *
     * 
     * \htmlonly
     * <p>This property gives the users the possibility to prevent an account
     *   from being used. This flag does not change the validity of the
     *   account.</p>
     * 
     * <p>A disabled account can never be put online.</p>
     * 
     * <div class="rationale">
     *   <p>Use cases:</p>
     * 
     *   <ul>
     *     <li>user has two or more accounts capable of calling contact X, but
     *       he doesn't want the UI to prompt him everytime about which one he
     *       wants to use for the call. He can then disable all the equivalent
     *       accounts but one.</li>
     * 
     *     <li>There is some temporary server error and the user doesn't want
     *       to be be bother by error messages, or change the account
     *       configuration: temporarily disabling the account is quicker.</li>
     *   </ul>
     * </div>
     * 
     * <p>The AccountManager SHOULD allow this property to be set on invalid
     *   accounts, but MUST NOT attempt to put invalid accounts online
     *   even if they become Enabled.</p>
     * 
     * <div class="rationale">
     *   <p>There doesn't seem to be any good reason not to allow this.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEnabled() const
    {
        return internalRequestProperty(QLatin1String("Enabled"));
    }

    /**
     * Asynchronous setter for the remote object property \c Enabled of type \c bool.
     *
     * 
     * \htmlonly
     * <p>This property gives the users the possibility to prevent an account
     *   from being used. This flag does not change the validity of the
     *   account.</p>
     * 
     * <p>A disabled account can never be put online.</p>
     * 
     * <div class="rationale">
     *   <p>Use cases:</p>
     * 
     *   <ul>
     *     <li>user has two or more accounts capable of calling contact X, but
     *       he doesn't want the UI to prompt him everytime about which one he
     *       wants to use for the call. He can then disable all the equivalent
     *       accounts but one.</li>
     * 
     *     <li>There is some temporary server error and the user doesn't want
     *       to be be bother by error messages, or change the account
     *       configuration: temporarily disabling the account is quicker.</li>
     *   </ul>
     * </div>
     * 
     * <p>The AccountManager SHOULD allow this property to be set on invalid
     *   accounts, but MUST NOT attempt to put invalid accounts online
     *   even if they become Enabled.</p>
     * 
     * <div class="rationale">
     *   <p>There doesn't seem to be any good reason not to allow this.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyEnabled(bool newValue)
    {
        return internalSetProperty(QLatin1String("Enabled"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Nickname of type \c QString.
     *
     * 
     * The nickname to set on this account for display to other contacts, as 
     * set by the user. When the account becomes connected, the account 
     * manager SHOULD set this as the user&apos;s alias using SetAliases if 
     * appropriate. In a later specification revision, we plan to separate the 
     * concepts of a contact&apos;s nickname as set by themselves, and the 
     * local name for them in our contact list (a &quot;handle&quot; or 
     * &quot;pet name&quot; as described in XEP-0165 and its references). The 
     * terminology change from alias to nickname here is a step in that 
     * direction.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyNickname() const
    {
        return internalRequestProperty(QLatin1String("Nickname"));
    }

    /**
     * Asynchronous setter for the remote object property \c Nickname of type \c QString.
     *
     * 
     * The nickname to set on this account for display to other contacts, as 
     * set by the user. When the account becomes connected, the account 
     * manager SHOULD set this as the user&apos;s alias using SetAliases if 
     * appropriate. In a later specification revision, we plan to separate the 
     * concepts of a contact&apos;s nickname as set by themselves, and the 
     * local name for them in our contact list (a &quot;handle&quot; or 
     * &quot;pet name&quot; as described in XEP-0165 and its references). The 
     * terminology change from alias to nickname here is a step in that 
     * direction.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyNickname(QString newValue)
    {
        return internalSetProperty(QLatin1String("Nickname"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Service of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Some protocols, like XMPP and SIP, are used by various different
     *   user-recognised brands, such as <i>Google Talk</i> and <i>Ovi by
     *   Nokia</i>. On accounts for such services, this property SHOULD be
     *   set to a string describing the service, which MUST consist only of
     *   ASCII letters, numbers and hyphen/minus signs, and start with a
     *   letter (matching the requirements for <tp:type>Protocol</tp:type>).
     *   For the <tt>jabber</tt> protocol, one of the following service names
     *   should be used if possible:</p>
     * 
     * <ul>
     *   <li><tt>google-talk</tt> (for <a href="http://www.google.com/talk/">Google's IM service</a>)</li>
     *   <li><tt>ovi-chat</tt> (for <a href="http://www.ovi.com/">Ovi</a>'s IM
     *     service)</li>
     *   <li><tt>facebook</tt> (for <a href="http://www.facebook.com/sitetour/chat.php">Facebook's IM
     *     service</a>)</li>
     *   <li><tt>lj-talk</tt> (for <a href="http://www.livejournal.com/chat/">LiveJournal's IM
     *     service</a>)</li>
     *   <li><tt>windows-live</tt> (for <a href="http://live.com">Windows Live Messenger IM service</a>)</li>
     * 
     * </ul>
     * 
     * <p>For the <tt>IRC</tt> protocol, the network name (<tt>freenode</tt>,
     *   <tt>gimpnet</tt>, etc.) can be used if relevant.</p>
     * 
     * <p>The  \endhtmlonly \link requestPropertyIcon() Icon \endlink \htmlonly  property SHOULD be set to a
     *   corresponding brand-specific icon name, if possible. In the future,
     *   this property may be used as an index into additional
     *   service-specific customizations. If this property is the empty string
     *   (or missing), the service is determined by the protocol name (either
     *   because this is a single-service protocol like <tt>msn</tt>, or
     *   because this is just a generic <tt>jabber</tt> or <tt>sip</tt>
     *   account without specific branding).</p>
     * 
     * <p>This property MAY be set, if appropriate, when calling
     *    \endhtmlonly AccountManagerInterface::CreateAccount() \htmlonly . Updating this property will fail on
     *   externally-stored accounts whose  \endhtmlonly \link AccountInterfaceStorageInterface::requestPropertyStorageRestrictions() AccountInterfaceStorageInterface::StorageRestrictions \endlink \htmlonly  include
     *   <code>Cannot_Set_Service</code>.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyService() const
    {
        return internalRequestProperty(QLatin1String("Service"));
    }

    /**
     * Asynchronous setter for the remote object property \c Service of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Some protocols, like XMPP and SIP, are used by various different
     *   user-recognised brands, such as <i>Google Talk</i> and <i>Ovi by
     *   Nokia</i>. On accounts for such services, this property SHOULD be
     *   set to a string describing the service, which MUST consist only of
     *   ASCII letters, numbers and hyphen/minus signs, and start with a
     *   letter (matching the requirements for <tp:type>Protocol</tp:type>).
     *   For the <tt>jabber</tt> protocol, one of the following service names
     *   should be used if possible:</p>
     * 
     * <ul>
     *   <li><tt>google-talk</tt> (for <a href="http://www.google.com/talk/">Google's IM service</a>)</li>
     *   <li><tt>ovi-chat</tt> (for <a href="http://www.ovi.com/">Ovi</a>'s IM
     *     service)</li>
     *   <li><tt>facebook</tt> (for <a href="http://www.facebook.com/sitetour/chat.php">Facebook's IM
     *     service</a>)</li>
     *   <li><tt>lj-talk</tt> (for <a href="http://www.livejournal.com/chat/">LiveJournal's IM
     *     service</a>)</li>
     *   <li><tt>windows-live</tt> (for <a href="http://live.com">Windows Live Messenger IM service</a>)</li>
     * 
     * </ul>
     * 
     * <p>For the <tt>IRC</tt> protocol, the network name (<tt>freenode</tt>,
     *   <tt>gimpnet</tt>, etc.) can be used if relevant.</p>
     * 
     * <p>The  \endhtmlonly \link requestPropertyIcon() Icon \endlink \htmlonly  property SHOULD be set to a
     *   corresponding brand-specific icon name, if possible. In the future,
     *   this property may be used as an index into additional
     *   service-specific customizations. If this property is the empty string
     *   (or missing), the service is determined by the protocol name (either
     *   because this is a single-service protocol like <tt>msn</tt>, or
     *   because this is just a generic <tt>jabber</tt> or <tt>sip</tt>
     *   account without specific branding).</p>
     * 
     * <p>This property MAY be set, if appropriate, when calling
     *    \endhtmlonly AccountManagerInterface::CreateAccount() \htmlonly . Updating this property will fail on
     *   externally-stored accounts whose  \endhtmlonly \link AccountInterfaceStorageInterface::requestPropertyStorageRestrictions() AccountInterfaceStorageInterface::StorageRestrictions \endlink \htmlonly  include
     *   <code>Cannot_Set_Service</code>.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyService(QString newValue)
    {
        return internalSetProperty(QLatin1String("Service"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Parameters of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>A map from connection manager parameter names (as in the
     *    \endhtmlonly ConnectionManagerInterface \htmlonly 
     *   interface) to their values. This property includes
     *   only those parameters that are stored for this account, and SHOULD
     *   only include those parameters that the user has explicitly set.
     * </p>
     * <p>This property cannot be altered using
     *   <code>org.freedesktop.DBus.Properties.Set()</code>; use
     *    \endhtmlonly UpdateParameters() \htmlonly  instead.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyParameters() const
    {
        return internalRequestProperty(QLatin1String("Parameters"));
    }

    /**
     * Asynchronous getter for the remote object property \c AutomaticPresence of type \c Tp::SimplePresence.
     *
     * 
     * \htmlonly
     * <p>The presence status that this account should have if it is brought
     *   online.</p>
     * 
     * <div class="rationale">
     *   In ITOS2007 and ITOS2008 this is a global preference, not visible
     *   on D-Bus (the &quot;default presence&quot;). &quot;Automatic presence&quot; better
     *   describes when it is used.
     * </div>
     * 
     * <p>Setting this property MUST NOT actually change the account's
     *   status until the next time it is (re)connected for some reason.</p>
     * 
     * <p>The value of this property MUST be one that would be acceptable
     *   for  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly ,
     *   with the additional restriction that the
     *   <tp:type>Connection_Presence_Type</tp:type> MUST NOT be Offline.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, it would not be possible to use this presence to bring
     *     the account online for a channel request.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAutomaticPresence() const
    {
        return internalRequestProperty(QLatin1String("AutomaticPresence"));
    }

    /**
     * Asynchronous setter for the remote object property \c AutomaticPresence of type \c Tp::SimplePresence.
     *
     * 
     * \htmlonly
     * <p>The presence status that this account should have if it is brought
     *   online.</p>
     * 
     * <div class="rationale">
     *   In ITOS2007 and ITOS2008 this is a global preference, not visible
     *   on D-Bus (the &quot;default presence&quot;). &quot;Automatic presence&quot; better
     *   describes when it is used.
     * </div>
     * 
     * <p>Setting this property MUST NOT actually change the account's
     *   status until the next time it is (re)connected for some reason.</p>
     * 
     * <p>The value of this property MUST be one that would be acceptable
     *   for  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly ,
     *   with the additional restriction that the
     *   <tp:type>Connection_Presence_Type</tp:type> MUST NOT be Offline.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, it would not be possible to use this presence to bring
     *     the account online for a channel request.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyAutomaticPresence(Tp::SimplePresence newValue)
    {
        return internalSetProperty(QLatin1String("AutomaticPresence"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c ConnectAutomatically of type \c bool.
     *
     * 
     * If true, the account manager SHOULD attempt to put this account online 
     * with the AutomaticPresence whenever possible (in the base Account 
     * interface this is deliberately left vague). If false, it MUST NOT put 
     * the account online automatically in response to, for instance, 
     * connectivity changes, but SHOULD still put the account online with the 
     * AutomaticPresence if requested by the user (for instance, if the user 
     * tries to start a conversation using this account).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnectAutomatically() const
    {
        return internalRequestProperty(QLatin1String("ConnectAutomatically"));
    }

    /**
     * Asynchronous setter for the remote object property \c ConnectAutomatically of type \c bool.
     *
     * 
     * If true, the account manager SHOULD attempt to put this account online 
     * with the AutomaticPresence whenever possible (in the base Account 
     * interface this is deliberately left vague). If false, it MUST NOT put 
     * the account online automatically in response to, for instance, 
     * connectivity changes, but SHOULD still put the account online with the 
     * AutomaticPresence if requested by the user (for instance, if the user 
     * tries to start a conversation using this account).
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyConnectAutomatically(bool newValue)
    {
        return internalSetProperty(QLatin1String("ConnectAutomatically"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Connection of type \c QDBusObjectPath.
     *
     * 
     * \htmlonly
     * <p>Either the object path of the  \endhtmlonly ConnectionInterface \htmlonly  to
     * this account, or the special value <code>'/'</code> if there is no
     * connection.</p>
     * 
     * <p>If this object path is not '/', the Connection's well-known bus
     *   name can be derived from this object path by removing the first '/'
     *   and replacing subsequent '/' characters with '.'.</p>
     * 
     * <div class="rationale">
     *   Object paths aren't nullable, so we can't use an empty string.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnection() const
    {
        return internalRequestProperty(QLatin1String("Connection"));
    }

    /**
     * Asynchronous getter for the remote object property \c ConnectionStatus of type \c uint.
     *
     * 
     * If the Connection property is non-empty, the status of that connection. 
     * If the Connection property is the empty string, this property may 
     * either be Disconnected (indicating that the account manager is not 
     * attempting to bring it online), or Connecting (indicating that the 
     * account manager is attempting to connect). The account manager is 
     * expected to set this by observing signals from the Connection. If the 
     * AM is doing some sort of backoff/delay on reconnection attempts, the 
     * account&apos;s status is conceptually &quot;Connecting&quot; even 
     * though there is no Connection.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnectionStatus() const
    {
        return internalRequestProperty(QLatin1String("ConnectionStatus"));
    }

    /**
     * Asynchronous getter for the remote object property \c ConnectionStatusReason of type \c uint.
     *
     * 
     * The reason for the last change to ConnectionStatus. The account manager 
     * is expected to set this by observing signals from the Connection. If 
     * you weren&apos;t watching the Connection at the time it failed, you 
     * can&apos;t tell why - unless the AM can tell you.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnectionStatusReason() const
    {
        return internalRequestProperty(QLatin1String("ConnectionStatusReason"));
    }

    /**
     * Asynchronous getter for the remote object property \c ConnectionError of type \c QString.
     *
     * 
     * \htmlonly
     * <p>If the last connection to this account failed with an error,
     *   the D-Bus error name of that error; otherwise, the empty string.
     *   The account manager is expected to set this by observing the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly  and
     *    \endhtmlonly ConnectionInterface::StatusChanged() \htmlonly 
     *   signals.</p>
     * 
     * <p>If ConnectionError is received before the connection disconnects,
     *   its first argument should be used to set this property;
     *   otherwise, the Reason argument of StatusChanged should be converted
     *   to a suitable D-Bus error name.</p>
     * 
     * <p>Whenever the Connection connects successfully, this property should
     *   be reset to the empty string.</p>
     * 
     * <div class="rationale">
     *   <p>This combines the state-recoverability of
     *      \endhtmlonly \link requestPropertyConnectionStatusReason() ConnectionStatusReason \endlink \htmlonly  with the
     *     extensibility of Connection.ConnectionError.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnectionError() const
    {
        return internalRequestProperty(QLatin1String("ConnectionError"));
    }

    /**
     * Asynchronous getter for the remote object property \c ConnectionErrorDetails of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>If the last connection to this account failed with an error,
     *   a mapping representing any additional information about the last
     *   disconnection; otherwise, the empty map. The keys and values are
     *   the same as for the second argument of
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly .</p>
     * 
     * <p>Whenever the Connection connects successfully, this property should
     *   be reset to the empty map.</p>
     * 
     * <div class="rationale">
     *   <p>This combines the state-recoverability of
     *      \endhtmlonly \link requestPropertyConnectionStatusReason() ConnectionStatusReason \endlink \htmlonly  with the
     *     extensibility of Connection.ConnectionError.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnectionErrorDetails() const
    {
        return internalRequestProperty(QLatin1String("ConnectionErrorDetails"));
    }

    /**
     * Asynchronous getter for the remote object property \c CurrentPresence of type \c Tp::SimplePresence.
     *
     * 
     * The actual presence. If the connection is not online, the 
     * Connection_Presence_Type SHOULD be Connection_Presence_Type_Offline. If 
     * the connection is online but does not support the SimplePresence 
     * interface, the type SHOULD be Connection_Presence_Type_Unset. The 
     * account manager is expected to set this by observing signals from the 
     * Connection.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentPresence() const
    {
        return internalRequestProperty(QLatin1String("CurrentPresence"));
    }

    /**
     * Asynchronous getter for the remote object property \c RequestedPresence of type \c Tp::SimplePresence.
     *
     * 
     * \htmlonly
     * <p>The requested presence for this account. When this is changed, the
     * account manager should attempt to manipulate the connection manager to
     * make  \endhtmlonly \link requestPropertyCurrentPresence() CurrentPresence \endlink \htmlonly  match
     *  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly  as closely as
     *   possible. It should not be saved to any sort of persistent
     *   storage.</p>
     * 
     * <p>When the account manager automatically connects an account,
     *   it must signal this by setting the RequestedPresence to the same
     *   thing as the  \endhtmlonly \link requestPropertyAutomaticPresence() AutomaticPresence \endlink \htmlonly .</p>
     * 
     * <p>The <tp:type>Connection_Presence_Type</tp:type> in this property
     *   MUST NOT be Unset, Unknown or Error.</p>
     * 
     * <div class="rationale">
     *   <p>Requesting those presence types doesn't make sense.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequestedPresence() const
    {
        return internalRequestProperty(QLatin1String("RequestedPresence"));
    }

    /**
     * Asynchronous setter for the remote object property \c RequestedPresence of type \c Tp::SimplePresence.
     *
     * 
     * \htmlonly
     * <p>The requested presence for this account. When this is changed, the
     * account manager should attempt to manipulate the connection manager to
     * make  \endhtmlonly \link requestPropertyCurrentPresence() CurrentPresence \endlink \htmlonly  match
     *  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly  as closely as
     *   possible. It should not be saved to any sort of persistent
     *   storage.</p>
     * 
     * <p>When the account manager automatically connects an account,
     *   it must signal this by setting the RequestedPresence to the same
     *   thing as the  \endhtmlonly \link requestPropertyAutomaticPresence() AutomaticPresence \endlink \htmlonly .</p>
     * 
     * <p>The <tp:type>Connection_Presence_Type</tp:type> in this property
     *   MUST NOT be Unset, Unknown or Error.</p>
     * 
     * <div class="rationale">
     *   <p>Requesting those presence types doesn't make sense.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyRequestedPresence(Tp::SimplePresence newValue)
    {
        return internalSetProperty(QLatin1String("RequestedPresence"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c ChangingPresence of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, a change to the presence of this account is
     * in progress.</p>
     * 
     * <p>Whenever  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly  is set on
     * an account that could go online, or whenever an account with a
     * non-offline  \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly  becomes
     * able to go online (for instance because
     *  \endhtmlonly \link requestPropertyEnabled() Enabled \endlink \htmlonly  or
     *  \endhtmlonly \link requestPropertyValid() Valid \endlink \htmlonly  changes to True),
     * ChangingPresence MUST change to True, and the two property changes MUST
     * be emitted in the same
     *  \endhtmlonly AccountPropertyChanged() \htmlonly  signal, before the
     * Set method returns.</p>
     * 
     * <p>When the account manager succeeds or fails in changing the presence,
     * or the connection disconnects due to an error, ChangingPresence MUST
     * change to False as part of the same
     *  \endhtmlonly AccountPropertyChanged() \htmlonly  signal.</p>
     * 
     * <div class="rationale">
     *   <p>This allows UIs to indicate that a presence change is in progress
     *   or has finished, even if the change was initiated by a different
     *   UI.</p>
     * 
     *   <p>For instance, Maemo 5 and Empathy indicate a presence change by
     *   having the presence indicator alternate between the
     *    \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly 
     *   and the  \endhtmlonly \link requestPropertyCurrentPresence() CurrentPresence \endlink \htmlonly ; they should
     *   start blinking when ChangingPresence becomes true, and stop when it
     *   becomes false.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChangingPresence() const
    {
        return internalRequestProperty(QLatin1String("ChangingPresence"));
    }

    /**
     * Asynchronous getter for the remote object property \c NormalizedName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The normalized user ID of the local user on this account (i.e. the
     *   string returned when the  \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly 
     *   method is called on the
     *   result of  \endhtmlonly ConnectionInterface::GetSelfHandle() \htmlonly 
     *   for an active connection).</p>
     * 
     * <p>It is unspecified whether this user ID is globally unique.</p>
     * 
     * <div class="rationale">
     *   <p>As currently implemented, IRC user IDs are only unique within
     *     the same IRCnet. On some saner protocols, the user ID includes a
     *     DNS name which provides global uniqueness.</p>
     * </div>
     * 
     * <p>If this value is not known yet (which will always be the case for
     *   accounts that have never been online), it will be an empty
     *   string.</p>
     * 
     * <p>It is possible that this value will change if the connection
     *   manager's normalization algorithm changes, although this SHOULD
     *   be avoided.</p>
     * 
     * <div class="rationale">
     *   <p>It's not always completely clear what normalization algorithm
     *     should be used; for instance, in Gabble, we currently use JIDs,
     *     but it would also have been reasonable to use xmpp URIs.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyNormalizedName() const
    {
        return internalRequestProperty(QLatin1String("NormalizedName"));
    }

    /**
     * Asynchronous getter for the remote object property \c HasBeenOnline of type \c bool.
     *
     * 
     * If true, this account has successfully been put online at some point in 
     * the past. UIs could apply a policy that the &apos;account&apos; 
     * parameter can only be edited in accounts that have never been online, 
     * or that ConnectAutomatically cannot be set on such accounts. The 
     * account manager should not enforce such policies, but it can expose 
     * enough information to UIs that the UI can decide what to do.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHasBeenOnline() const
    {
        return internalRequestProperty(QLatin1String("HasBeenOnline"));
    }

    /**
     * Asynchronous getter for the remote object property \c Supersedes of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>A list of the object paths of formerly-used accounts which are
     *   superseded by this one.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, if an account is migrated from one connection
     *     manager implementation to another, or even from one protocol
     *     to another (for instance formerly-proprietary services which
     *     can now be accessed via XMPP), log storage services could
     *     look for logs under all of the superseded object paths as well
     *     as the new object path.</p>
     * 
     *   <p>This is a list because a single user-visible account could be
     *     migrated more than once.</p>
     * </div>
     * 
     * <p>If the Account Manager implementation performs an account migration
     *   automatically, it SHOULD set this property. If a client performs
     *   an account migration, it SHOULD set this property via
     *   via the Properties argument of  \endhtmlonly AccountManagerInterface::CreateAccount() \htmlonly 
     *   when creating the migrated account. In either case, the value
     *   SHOULD include the old account's path, and every path from
     *   the old account's Supersedes property.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupersedes() const
    {
        return internalRequestProperty(QLatin1String("Supersedes"));
    }

    /**
     * Asynchronous setter for the remote object property \c Supersedes of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>A list of the object paths of formerly-used accounts which are
     *   superseded by this one.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, if an account is migrated from one connection
     *     manager implementation to another, or even from one protocol
     *     to another (for instance formerly-proprietary services which
     *     can now be accessed via XMPP), log storage services could
     *     look for logs under all of the superseded object paths as well
     *     as the new object path.</p>
     * 
     *   <p>This is a list because a single user-visible account could be
     *     migrated more than once.</p>
     * </div>
     * 
     * <p>If the Account Manager implementation performs an account migration
     *   automatically, it SHOULD set this property. If a client performs
     *   an account migration, it SHOULD set this property via
     *   via the Properties argument of  \endhtmlonly AccountManagerInterface::CreateAccount() \htmlonly 
     *   when creating the migrated account. In either case, the value
     *   SHOULD include the old account's path, and every path from
     *   the old account's Supersedes property.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertySupersedes(Tp::ObjectPathList newValue)
    {
        return internalSetProperty(QLatin1String("Supersedes"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Remove on the remote object.
     * 
     * Delete the account.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Remove(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Remove"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c UpdateParameters on the remote object.
     * 
     * \htmlonly
     * <p>Change the value of the  \endhtmlonly \link requestPropertyParameters() Parameters \endlink \htmlonly 
     *   property.</p>
     * 
     * <p>If any of the <var>Set</var> parameters’
     *   <tp:type>Conn_Mgr_Param_Flags</tp:type> include
     *   <code>DBus_Property</code>, the change will be applied immediately to
     *   the corresponding D-Bus Property on the active
     *    \endhtmlonly \link requestPropertyConnection() Connection \endlink \htmlonly , if there is one. If any of
     *   the <var>Unset</var> parameters’
     *   <tp:type>Conn_Mgr_Param_Flags</tp:type> include both
     *   <code>DBus_Property</code> and <code>Has_Default</code>, the
     *   corresponding D-Bus Property on the connection will be set to the
     *   default value.  Changes to other parameters will not take effect
     *   until the next time the account is disconnected and reconnected. (If
     *   parameters are explicitly set to their default value, or are unset
     *   when previously set to their default value, the account manager MAY
     *   decide that no reconnection is necessary to make the change take
     *   effect.)</p>
     * 
     * <div class="rationale">
     *   <p>In general, reconnecting is a destructive operation that shouldn't
     *     happen as a side-effect. In particular, migration tools that
     *     twiddle the settings of all accounts shouldn't cause an automatic
     *     disconnect and reconnect.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param set
     *     
     *     A mapping from parameter names to their values. These parameters 
     *     should be stored for future use.
     *
     * \param unset
     *     
     *     A list of the names of parameters to be removed from the set of 
     *     stored values, allowing the default values to be used. If the given 
     *     parameters were not, in fact, stored, or even if they do not exist 
     *     at all, the account manager MUST accept this without error.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>If all of the updates could be applied to the active
     *        \endhtmlonly \link requestPropertyConnection() Connection \endlink \htmlonly  (if any),
     *       the empty list, signifying that no reconnection is required for the
     *       new parameters to take effect. For example, if the only parameter
     *       updated is <tt>...Cellular. \endhtmlonly \link ConnectionInterfaceCellularInterface::requestPropertyMessageValidityPeriod() ConnectionInterfaceCellularInterface::MessageValidityPeriod \endlink \htmlonly </tt>,
     *       the new value can be applied immediately to the connection.</p>
     *     
     *     <p>Otherwise, a list of the names of parameters with changes that
     *       will not take effect until the account is reconnected. User
     *       interfaces that require &quot;instant apply&quot; semantics MAY call
     *        \endhtmlonly Reconnect() \htmlonly  in response to receiving a
     *       non-empty list. For example, if the caller updates both
     *       <tt>...Anonymity. \endhtmlonly \link ConnectionInterfaceAnonymityInterface::requestPropertyAnonymityMandatory() ConnectionInterfaceAnonymityInterface::AnonymityMandatory \endlink \htmlonly </tt>
     *       and <tt>require-encryption</tt>, the former can be applied to the
     *       current connection, but the latter needs a reconnect to take
     *       effect, so this method should return
     *       <code>[&quot;require-encryption&quot;]</code>.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<QStringList> UpdateParameters(const QVariantMap& set, const QStringList& unset, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UpdateParameters"));
        callMessage << QVariant::fromValue(set) << QVariant::fromValue(unset);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Reconnect on the remote object.
     * 
     * \htmlonly
     * <p>Re-connect this account. If the account is currently disconnected
     *   and the requested presence is offline, or if the account
     *   is not  \endhtmlonly \link requestPropertyEnabled() Enabled \endlink \htmlonly  or not
     *    \endhtmlonly \link requestPropertyValid() Valid \endlink \htmlonly , this does nothing.</p>
     * 
     * <p>If the account is disconnected and the requested presence is not
     *   offline, this forces an attempt to connect with the requested
     *   presence immediately.</p>
     * 
     * <p>If the account is connecting or connected, this is equivalent to
     *   remembering the current value of
     *    \endhtmlonly \link requestPropertyRequestedPresence() RequestedPresence \endlink \htmlonly , setting its value
     *   to (OFFLINE, &quot;offline&quot;, &quot;&quot;), waiting for the change to take effect,
     *   then setting its value to the value that was previously
     *   remembered.</p>
     * 
     * <div class="rationale">
     *   <p>Clients desiring &quot;instant apply&quot; semantics for CM parameters MAY
     *     call this method to achieve that.</p>
     * </div>
     * 
     * <p>In particular, if the account's
     *    \endhtmlonly \link requestPropertyConnection() Connection \endlink \htmlonly  is in the Connecting
     *   state, calling this method causes the attempt to connect to be
     *   aborted and re-tried.</p>
     * 
     * <div class="rationale">
     *   <p>This is necessary to ensure that the new parameters are
     *     picked up.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Reconnect(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Reconnect"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c Removed on the remote object.
     * 
     * This account has been removed. This is redundant with AccountRemoved, 
     * but it&apos;s still worth having, to avoid having to bind to 
     * AccountManager.AccountRemoved to tell you whether your Account is valid 
     * — ideally, an account-editing UI should only care about a single 
     * Account.
     */
    void Removed();

    /**
     * Represents the signal \c AccountPropertyChanged on the remote object.
     * 
     * The values of one or more properties on this interface (that do not 
     * specify that this signal does not apply to them) may have changed. This 
     * does not cover properties of other interfaces, which must provide their 
     * own change notification if appropriate.
     *
     * \param properties
     *     
     *     A map from property names in this namespace (e.g. Nickname) to 
     *     values. Properties whose values have not changed SHOULD be omitted, 
     *     but this need not be done.
     */
    void AccountPropertyChanged(const QVariantMap& properties);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class AccountInterfaceAddressingInterface
 * \headerfile TelepathyQt/account.h <TelepathyQt/AccountManager>
 * \ingroup clientaccount
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Account.Interface.Addressing".
 */
class TP_QT_EXPORT AccountInterfaceAddressingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Account.Interface.Addressing", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Account.Interface.Addressing");
    }

    /**
     * Creates a AccountInterfaceAddressingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAddressingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceAddressingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAddressingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceAddressingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AccountInterfaceAddressingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a AccountInterfaceAddressingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit AccountInterfaceAddressingInterface(const Tp::Client::AccountInterface& mainInterface);

    /**
     * Creates a AccountInterfaceAddressingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAddressingInterface(const Tp::Client::AccountInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c URISchemes of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of fields indicating the type of URI addressing scheme
     *   the the account should be used for (eg 'tel') indicating the
     *   account is intended for use by applications offering a telephony
     *   UI, or 'sip' or 'xmpp' for those protocols</p>
     * <p>Note that these fields signify intent, not ability: It is
     *   entirely possible that an account which can be used for a
     *   given URI scheme is not wanted for it by the user, and
     *   therefore not flagged as such in this field.</p>
     * <p>Change notification for this property is provided by the
     *   standard D-Bus <code>PropertiesChanged</code> signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyURISchemes() const
    {
        return internalRequestProperty(QLatin1String("URISchemes"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetURISchemeAssociation on the remote object.
     * 
     * Associate (or disassociate) an account with a particular URI addressing 
     * scheme, (such as &apos;tel&apos; for telephony)
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param URIScheme
     *     
     *     URI scheme to associate/disassociate the account with/from
     *
     * \param association
     *     
     *     True to associate this account with a given addressing scheme False 
     *     if the account should not be associated with said scheme
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetURISchemeAssociation(const QString& URIScheme, bool association, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetURISchemeAssociation"));
        callMessage << QVariant::fromValue(URIScheme) << QVariant::fromValue(association);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class AccountInterfaceAvatarInterface
 * \headerfile TelepathyQt/account.h <TelepathyQt/AccountManager>
 * \ingroup clientaccount
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Account.Interface.Avatar".
 */
class TP_QT_EXPORT AccountInterfaceAvatarInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Account.Interface.Avatar", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Account.Interface.Avatar");
    }

    /**
     * Creates a AccountInterfaceAvatarInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAvatarInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceAvatarInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAvatarInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceAvatarInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AccountInterfaceAvatarInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a AccountInterfaceAvatarInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit AccountInterfaceAvatarInterface(const Tp::Client::AccountInterface& mainInterface);

    /**
     * Creates a AccountInterfaceAvatarInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceAvatarInterface(const Tp::Client::AccountInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Avatar of type \c Tp::Avatar.
     *
     * 
     * The avatar to set on this account for display to other contacts, 
     * represented as a structure containing the bytes of the avatar, and the 
     * MIME type as a string; may be set to an empty byte-array and an empty 
     * string to indicate no avatar. When the account becomes connected, the 
     * account manager SHOULD set this avatar using SetAvatar if appropriate.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAvatar() const
    {
        return internalRequestProperty(QLatin1String("Avatar"));
    }

    /**
     * Asynchronous setter for the remote object property \c Avatar of type \c Tp::Avatar.
     *
     * 
     * The avatar to set on this account for display to other contacts, 
     * represented as a structure containing the bytes of the avatar, and the 
     * MIME type as a string; may be set to an empty byte-array and an empty 
     * string to indicate no avatar. When the account becomes connected, the 
     * account manager SHOULD set this avatar using SetAvatar if appropriate.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyAvatar(Tp::Avatar newValue)
    {
        return internalSetProperty(QLatin1String("Avatar"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AvatarChanged on the remote object.
     * 
     * Emitted when the Avatar property changes. The avatar itself is 
     * deliberately not included in this signal, to reduce bus traffic in the 
     * (likely common) case where no running application cares about the 
     * user&apos;s own avatar.
     */
    void AvatarChanged();

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class AccountInterfaceStorageInterface
 * \headerfile TelepathyQt/account.h <TelepathyQt/AccountManager>
 * \ingroup clientaccount
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Account.Interface.Storage".
 */
class TP_QT_EXPORT AccountInterfaceStorageInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Account.Interface.Storage", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Account.Interface.Storage");
    }

    /**
     * Creates a AccountInterfaceStorageInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceStorageInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceStorageInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceStorageInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountInterfaceStorageInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AccountInterfaceStorageInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a AccountInterfaceStorageInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit AccountInterfaceStorageInterface(const Tp::Client::AccountInterface& mainInterface);

    /**
     * Creates a AccountInterfaceStorageInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    AccountInterfaceStorageInterface(const Tp::Client::AccountInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c StorageProvider of type \c QString.
     *
     * 
     * \htmlonly
     * <p>
     *   The name of the account storage implementation, which SHOULD start
     *   with a reversed domain name in the same way as D-Bus interface names.
     *   When this is the empty string the account is internally stored.
     * </p>
     * <p>
     *   This property cannot change once an Account has been created.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStorageProvider() const
    {
        return internalRequestProperty(QLatin1String("StorageProvider"));
    }

    /**
     * Asynchronous getter for the remote object property \c StorageIdentifier of type \c QDBusVariant.
     *
     * 
     * \htmlonly
     * <p>
     *   Unique identification of the account within the storage backend.
     *   The contents of the variant are defined by the
     *    \endhtmlonly \link requestPropertyStorageProvider() StorageProvider \endlink \htmlonly .
     * </p>
     * <p>
     *   This property cannot change once an Account has been created.
     * </p>
     * <div class="rationale">
     *   <p>
     *     Different storage systems will have their own way of uniquely
     *     identifying an account, typically an integer or a string.
     *     Given that all users of this property should have direct knowledge
     *     of the backend they should know what types to expect and how to
     *     handle it.
     *   </p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStorageIdentifier() const
    {
        return internalRequestProperty(QLatin1String("StorageIdentifier"));
    }

    /**
     * Asynchronous getter for the remote object property \c StorageSpecificInformation of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>
     *   Map containing information specific to the storage backend. The keys
     *   and the types of their values are defined by the
     *    \endhtmlonly \link requestPropertyStorageProvider() StorageProvider \endlink \htmlonly , and are not
     *   interpreted by the AccountManager implementation.
     * </p>
     * <p>
     *   As the values in this map may change at any time (due to an external
     *   application manipulating the storage provider directly), this
     *   property should not be cached; it should instead be retrieved each
     *   time it is needed.
     * </p>
     * 
     * <div class="rationale">
     *   <p>
     *     This can be used to provide additional hints to user interfaces
     *     aware of a specific storage provider, without requiring those user
     *     interfaces to use the
     *      \endhtmlonly \link requestPropertyStorageIdentifier() StorageIdentifier \endlink \htmlonly  to query the
     *     storage provider directly.
     *   </p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStorageSpecificInformation() const
    {
        return internalRequestProperty(QLatin1String("StorageSpecificInformation"));
    }

    /**
     * Asynchronous getter for the remote object property \c StorageRestrictions of type \c uint.
     *
     * 
     * \htmlonly
     * <p>
     *   Bitfield which defines what restrictions this Storage method has.
     * </p>
     * <p>
     *   This property cannot change once an Account has been created.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStorageRestrictions() const
    {
        return internalRequestProperty(QLatin1String("StorageRestrictions"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::AccountInterface*)
Q_DECLARE_METATYPE(Tp::Client::AccountInterfaceAddressingInterface*)
Q_DECLARE_METATYPE(Tp::Client::AccountInterfaceAvatarInterface*)
Q_DECLARE_METATYPE(Tp::Client::AccountInterfaceStorageInterface*)
