#!/bin/sh

####
####    Build an afm directory for the fonts supplied
####    with ghostscript
####

####
####    To make the result of this script work with the 'Ted' word 
####    processor two X11 resources must be set to point to the correct 
####    files in the ghostscript distribution. As an example I give the 
####    values that last worked on my computer. For more information, see 
####    the 'Ted' documentation.
####
####    Use the 'gs -h' command to find the exact locations.
####
####    Ted.ghostscriptFontmap: /usr/share/ghostscript/6.53/lib/Fontmap.GS
####    Ted.ghostscriptFontToXmapping: /usr/share/ghostscript/fonts/fonts.dir
####

####
####    Configurable Values
####

GHOST_FONT_DIR=/usr/share/ghostscript/fonts
TED_AFM_DIR=/usr/share/Ted/afm

set -u -e

####
####    Does the target exist..
####	If not make it.
####

if  test -d $TED_AFM_DIR
then
    : ok
else
    mkdir -p $TED_AFM_DIR
fi

####
####    Change a GhostScript afm file to use the name of a similar
####    Adobe Base 35 font.
####

urw_to_base35()
    {
    FAM_ALIAS="$1"
    FAM_NAME="$2"
    FONT_ALIAS="$3"
    FONT_NAME="$4"
    FULL_ALIAS="$5"
    FULL_NAME="$6"
    AFM_NAME="$7"

    AFM_SOURCE=$GHOST_FONT_DIR/$AFM_NAME.afm
    AFM_TARGET=$TED_AFM_DIR/$FONT_ALIAS.afm

    (
    sed -e	'2,$d'						\
	$AFM_SOURCE

    echo Comment Modified from $AFM_NAME.afm to simulate the Adobe base 35
    echo Comment font \"$FULL_ALIAS\" with the similar URW++/GhostScript
    echo Comment font \"$FULL_NAME\" in the \"Ted\" word processor.

    sed -e	's/^FamilyName .*/'"FamilyName $FAM_ALIAS/"	\
	-e	's/^FullName .*/'"FullName $FULL_ALIAS/"	\
	-e	's/^FontName .*/'"FontName $FONT_ALIAS/"	\
	-e	'1d'						\
	$AFM_SOURCE

    ) > $AFM_TARGET

    chmod 644 $AFM_TARGET

    }

####
####    Actual job
####

####

urw_to_base35	"ITC Avant Garde Gothic"		\
		"URW Gothic L"				\
		"AvantGarde-Book"			\
		"URWGothicL-Book"			\
		"ITC Avant Garde Gothic Book"		\
		"URW Gothic L Book"			\
		a010013l

urw_to_base35	"ITC Avant Garde Gothic"		\
		"URW Gothic L"				\
		"AvantGarde-BookOblique"		\
		"URWGothicL-BookObli"			\
		"ITC Avant Garde Gothic Book Oblique"	\
		"URW Gothic L Book Oblique"		\
		a010033l

urw_to_base35	"ITC Avant Garde Gothic"		\
		"URW Gothic L"				\
		"AvantGarde-Demi"			\
		"URWGothicL-Demi"			\
		"ITC Avant Garde Gothic Demi"		\
		"URW Gothic L Demi"			\
		a010015l

urw_to_base35	"ITC Avant Garde Gothic"		\
		"URW Gothic L"				\
		"AvantGarde-DemiOblique"		\
		"URWGothicL-DemiObli"			\
		"ITC Avant Garde Gothic Demi Oblique"	\
		"URW Gothic L Demi Oblique"		\
		a010035l

####

urw_to_base35	"ITC Bookman"				\
		"URW Bookman L"				\
		"Bookman-Light"				\
		"URWBookmanL-Ligh"			\
		"ITC Bookman Light"			\
		"URW Bookman L Light"			\
		b018012l

urw_to_base35	"ITC Bookman"				\
		"URW Bookman L"				\
		"Bookman-LightItalic"			\
		"URWBookmanL-LighItal"			\
		"ITC Bookman Light Italic"		\
		"URW Bookman L Light Italic"		\
		b018032l

urw_to_base35	"ITC Bookman"				\
		"URW Bookman L"				\
		"Bookman-Demi"				\
		"URWBookmanL-DemiBold"			\
		"ITC Bookman Demi"			\
		"URW Bookman L Demi Bold"		\
		b018015l

urw_to_base35	"ITC Bookman"				\
		"URW Bookman L"				\
		"Bookman-DemiItalic"			\
		"URWBookmanL-DemiBoldItal"		\
		"ITC Bookman Demi Italic"		\
		"URW Bookman L Demi Bold Italic"	\
		b018035l

####

urw_to_base35	"Courier"				\
		"Nimbus Mono L"				\
		"Courier"				\
		"NimbusMonL-Regu"			\
		"Courier"				\
		"Nimbus Mono L Regular"			\
		n022003l

urw_to_base35	"Courier"				\
		"Nimbus Mono L"				\
		"Courier-Oblique"			\
		"NimbusMonL-ReguObli"			\
		"Courier Oblique"			\
		"Nimbus Mono L Regular Oblique"		\
		n022023l

urw_to_base35	"Courier"				\
		"Nimbus Mono L"				\
		"Courier-Bold"				\
		"NimbusMonL-Bold"			\
		"Courier Bold"				\
		"Nimbus Mono L Bold"			\
		n022004l

urw_to_base35	"Courier"				\
		"Nimbus Mono L"				\
		"Courier-BoldOblique"			\
		"NimbusMonL-BoldObli"			\
		"Courier Bold Oblique"			\
		"Nimbus Mono L Bold Oblique"		\
		n022024l

####

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica"				\
		"NimbusSanL-Regu"			\
		"Helvetica"				\
		"Nimbus Sans L Regular"			\
		n019003l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Oblique"			\
		"NimbusSanL-ReguItal"			\
		"Helvetica Oblique"			\
		"Nimbus Sans L Regular Italic"		\
		n019023l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Bold"			\
		"NimbusSanL-Bold"			\
		"Helvetica Bold"			\
		"Nimbus Sans L Bold"			\
		n019004l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-BoldOblique"			\
		"NimbusSanL-BoldItal"			\
		"Helvetica Bold Oblique"		\
		"Nimbus Sans L Bold Italic"		\
		n019024l

####

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Narrow"			\
		"NimbusSanL-ReguCond"			\
		"Helvetica Narrow"			\
		"Nimbus Sans L Regular Condensed"	\
		n019043l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Narrow-Oblique"		\
		"NimbusSanL-ReguCondItal"		\
		"Helvetica Narrow Oblique"		\
		"Nimbus Sans L Regular Condensed Italic" \
		n019063l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Narrow-Bold"			\
		"NimbusSanL-BoldCond"			\
		"Helvetica Narrow Bold"			\
		"Nimbus Sans L Bold Condensed"		\
		n019044l

urw_to_base35	"Helvetica"				\
		"Nimbus Sans L"				\
		"Helvetica-Narrow-BoldOblique"		\
		"NimbusSanL-BoldCondItal"		\
		"Helvetica Narrow Bold Oblique"		\
		"Nimbus Sans L Bold Condensed Italic"	\
		n019064l

####

urw_to_base35	"New Century Schoolbook"		\
		"Century Schoolbook L"			\
		"NewCenturySchlbk-Roman"		\
		"CenturySchL-Roma"			\
		"New Century Schoolbook Roman"		\
		"Century Schoolbook L Roman"		\
		c059013l

urw_to_base35	"New Century Schoolbook"		\
		"Century Schoolbook L"			\
		"NewCenturySchlbk-Italic"		\
		"CenturySchL-Ital"			\
		"New Century Schoolbook Italic"		\
		"Century Schoolbook L Italic"		\
		c059033l

urw_to_base35	"New Century Schoolbook"		\
		"Century Schoolbook L"			\
		"NewCenturySchlbk-Bold"			\
		"CenturySchL-Bold"			\
		"New Century Schoolbook Bold"		\
		"Century Schoolbook L Bold"		\
		c059016l

urw_to_base35	"New Century Schoolbook"		\
		"Century Schoolbook L"			\
		"NewCenturySchlbk-BoldItalic"		\
		"CenturySchL-BoldItal"			\
		"New Century Schoolbook Bold Italic"	\
		"Century Schoolbook L Bold Italic"	\
		c059036l

####

urw_to_base35	"Palatino"				\
		"URW Palladio L"			\
		"Palatino-Roman"			\
		"URWPalladioL-Roma"			\
		"Palatino Roman"			\
		"URW Palladio L Roman"			\
		p052003l

urw_to_base35	"Palatino"				\
		"URW Palladio L"			\
		"Palatino-Italic"			\
		"URWPalladioL-Ital"			\
		"Palatino Italic"			\
		"URW Palladio L Italic"			\
		p052023l

urw_to_base35	"Palatino"				\
		"URW Palladio L"			\
		"Palatino-Bold"				\
		"URWPalladioL-Bold"			\
		"Palatino Bold"				\
		"URW Palladio L Bold"			\
		p052004l

urw_to_base35	"Palatino"				\
		"URW Palladio L"			\
		"Palatino-BoldItalic"			\
		"URWPalladioL-BoldItal"			\
		"Palatino Bold Italic"			\
		"URW Palladio L Bold Italic"		\
		p052024l

####

urw_to_base35	"Symbol"				\
		"Standard Symbols L"			\
		"Symbol"				\
		"StandardSymL"				\
		"Symbol"				\
		"Standard Symbols L"			\
		s050000l

####

urw_to_base35	"Times"					\
		"Nimbus Roman No9 L"			\
		"Times-Roman"				\
		"NimbusRomNo9L-Regu"			\
		"Times Roman"				\
		"Nimbus Roman No9 L Regular"		\
		n021003l

urw_to_base35	"Times"					\
		"Nimbus Roman No9 L"			\
		"Times-Italic"				\
		"NimbusRomNo9L-ReguItal"		\
		"Times Italic"				\
		"Nimbus Roman No9 L Regular Italic"	\
		n021023l

urw_to_base35	"Times"					\
		"Nimbus Roman No9 L"			\
		"Times-Bold"				\
		"NimbusRomNo9L-Medi"			\
		"Times Bold"				\
		"Nimbus Roman No9 L Medium"		\
		n021004l

urw_to_base35	"Times"					\
		"Nimbus Roman No9 L"			\
		"Times-BoldItalic"			\
		"NimbusRomNo9L-MediItal"		\
		"Times Bold Italic"			\
		"Nimbus Roman No9 L Medium Italic"	\
		n021024l

####

urw_to_base35	"ITC Zapf Chancery"			\
		"URW Chancery L"			\
		"ZapfChancery-MediumItalic"		\
		"URWChanceryL-MediItal"			\
		"ITC Zapf Chancery Medium Italic"	\
		"URW Chancery L Medium Italic"		\
		z003034l

####

urw_to_base35	"ITC Zapf Dingbats"			\
		"Dingbats"				\
		"ZapfDingbats"				\
		"Dingbats"				\
		"ITC Zapf Dingbats"			\
		"Dingbats"				\
		d050000l

####

exit 0
