typedef struct {
  const char *name;
  //double value;
  octave_value value;
}  fits_constants_type;

fits_constants_type fits_constants [] = {
 { "NIOBUF", NIOBUF },
 { "IOBUFLEN", IOBUFLEN },
 { "FLEN_FILENAME", FLEN_FILENAME },
 { "FLEN_KEYWORD", FLEN_KEYWORD },
 { "FLEN_CARD", FLEN_CARD },
 { "FLEN_VALUE", FLEN_VALUE },
 { "FLEN_COMMENT", FLEN_COMMENT },
 { "FLEN_ERRMSG", FLEN_ERRMSG },
 { "FLEN_STATUS", FLEN_STATUS },
 // codes for FITS table data types
 { "TBIT", TBIT },
 { "TBYTE", TBYTE },
 { "TSBYTE", TSBYTE },
 { "TLOGICAL", TLOGICAL },
 { "TSTRING", TSTRING },
 { "TUSHORT", TUSHORT },
 { "TSHORT", TSHORT },
 { "TUINT", TUINT },
 { "TINT", TINT },
 { "TULONG", TULONG },
 { "TLONG", TLONG },
 { "TINT32BIT", TINT32BIT }, // when returning data type of a column
 { "TFLOAT", TFLOAT },
 { "TULONGLONG", TULONGLONG },
 { "TLONGLONG", TLONGLONG },
 { "TDOUBLE", TDOUBLE },
 { "TCOMPLEX", TCOMPLEX },
 { "TDBLCOMPLEX", TDBLCOMPLEX },

 { "TYP_STRUC_KEY", TYP_STRUC_KEY },
 { "TYP_CMPRS_KEY", TYP_CMPRS_KEY },
 { "TYP_SCAL_KEY", TYP_SCAL_KEY },
 { "TYP_NULL_KEY", TYP_NULL_KEY },
 { "TYP_DIM_KEY", TYP_DIM_KEY },
 { "TYP_RANG_KEY", TYP_RANG_KEY },
 { "TYP_UNIT_KEY", TYP_UNIT_KEY },
 { "TYP_DISP_KEY", TYP_DISP_KEY },
 { "TYP_HDUID_KEY", TYP_HDUID_KEY },
 { "TYP_CKSUM_KEY", TYP_CKSUM_KEY },
 { "TYP_WCS_KEY", TYP_WCS_KEY },
 { "TYP_REFSYS_KEY", TYP_REFSYS_KEY },
 { "TYP_COMM_KEY", TYP_COMM_KEY },
 { "TYP_CONT_KEY", TYP_CONT_KEY },
 { "TYP_USER_KEY", TYP_USER_KEY },

 // BITPIX code values for FITS image types
 { "BYTE_IMG", BYTE_IMG },
 { "SHORT_IMG", SHORT_IMG },
 { "LONG_IMG", LONG_IMG },
 { "LONGLONG_IMG", LONGLONG_IMG },
 { "FLOAT_IMG", FLOAT_IMG },
 { "DOUBLE_IMG", DOUBLE_IMG },
 { "SBYTE_IMG", SBYTE_IMG },
 { "USHORT_IMG", USHORT_IMG },
 { "ULONG_IMG", ULONG_IMG },
 { "ULONGLONG_IMG", ULONGLONG_IMG },

 // HDU types
 { "IMAGE_HDU", IMAGE_HDU },
 { "ASCII_TBL", ASCII_TBL },
 { "BINARY_TBL", BINARY_TBL },
 { "ANY_HDU", ANY_HDU },

 // file mode
 { "READONLY", READONLY },
 { "READWRITE", READWRITE },

 // null values
 { "FLOATNULLVALUE", FLOATNULLVALUE }, // double
 { "DOUBLENULLVALUE", DOUBLENULLVALUE }, // double

 // dither
 { "NO_DITHER", NO_DITHER },
 { "SUBTRACTIVE_DITHER_1", SUBTRACTIVE_DITHER_1 },
 { "SUBTRACTIVE_DITHER_2", SUBTRACTIVE_DITHER_2 },
  
 // compression
 { "MAX_COMPRESS_DIM", MAX_COMPRESS_DIM },
 { "RICE_1", RICE_1 },
 { "GZIP_1", GZIP_1 },
 { "GZIP_2", GZIP_2 },
 { "PLIO_1", PLIO_1 },
 { "HCOMPRESS_1", HCOMPRESS_1 },
 { "BZIP2_1", BZIP2_1 },
 { "NOCOMPRESS", NOCOMPRESS },

 //
 { "TRUE", TRUE },
 { "FALSE", FALSE },
 { "CASESEN", CASESEN },
 { "CASEINSEN", CASEINSEN },
 //hierarchical grouping parameters
 { "GT_ID_ALL_URI", GT_ID_ALL_URI },
 { "GT_ID_REF", GT_ID_REF },
 { "GT_ID_POS", GT_ID_POS },
 { "GT_ID_ALL", GT_ID_ALL },
 { "GT_ID_REF_URI", GT_ID_REF_URI },
 { "GT_ID_POS_URI", GT_ID_POS_URI },

 { "OPT_RM_GPT", OPT_RM_GPT },
 { "OPT_RM_ENTRY", OPT_RM_ENTRY },
 { "OPT_RM_MBR", OPT_RM_MBR },
 { "OPT_RM_ALL", OPT_RM_ALL },
 { "OPT_GCP_GPT", OPT_GCP_GPT },
 { "OPT_GCP_MBR", OPT_GCP_MBR },
 { "OPT_GCP_ALL", OPT_GCP_ALL },
 { "OPT_MCP_ADD", OPT_MCP_ADD },
 { "OPT_MCP_NADD", OPT_MCP_NADD },
 { "OPT_MCP_REPL", OPT_MCP_REPL },
 { "OPT_MCP_MOV", OPT_MCP_MOV },
 { "OPT_MRG_COPY", OPT_MRG_COPY },
 { "OPT_MRG_MOV", OPT_MRG_MOV },
 { "OPT_CMT_MBR", OPT_CMT_MBR },
 { "OPT_CMT_MBR_DEL", OPT_CMT_MBR_DEL },

 { "VALIDSTRUC", VALIDSTRUC },
 { "INPUTCOL", InputCol },
 { "INPUTOUTPUTCOL", InputOutputCol },
 { "OUTPUTCOL", OutputCol },

 // error status codes
 { "CREATE_DISK_FILE", CREATE_DISK_FILE },
 { "OPEN_DISK_FILE", OPEN_DISK_FILE },
 { "SKIP_TABLE", SKIP_TABLE },
 { "SKIP_IMAGE", SKIP_IMAGE },
 { "SKIP_NULL_PRIMARY", SKIP_NULL_PRIMARY },
 { "USE_MEM_BUFF", USE_MEM_BUFF },
 { "OVERFLOW_ERR", OVERFLOW_ERR },
 { "PREPEND_PRIMARY", PREPEND_PRIMARY },
 { "SAME_FILE", SAME_FILE },
 { "TOO_MANY_FILES", TOO_MANY_FILES },
 { "FILE_NOT_OPENED", FILE_NOT_OPENED },
 { "FILE_NOT_CREATED", FILE_NOT_CREATED },
 { "WRITE_ERROR", WRITE_ERROR },
 { "END_OF_FILE", END_OF_FILE },
 { "READ_ERROR", READ_ERROR },
 { "FILE_NOT_CLOSED", FILE_NOT_CLOSED },
 { "ARRAY_TOO_BIG", ARRAY_TOO_BIG },
 { "READONLY_FILE", READONLY_FILE },
 { "MEMORY_ALLOCATION", MEMORY_ALLOCATION },
 { "BAD_FILEPTR", BAD_FILEPTR },
 { "NULL_INPUT_PTR", NULL_INPUT_PTR },
 { "SEEK_ERROR", SEEK_ERROR },
 { "BAD_URL_PREFIX", BAD_URL_PREFIX },
 { "TOO_MANY_DRIVERS", TOO_MANY_DRIVERS },
 { "DRIVER_INIT_FAILED", DRIVER_INIT_FAILED },
 { "NO_MATCHING_DRIVER", NO_MATCHING_DRIVER },
 { "URL_PARSE_ERROR", URL_PARSE_ERROR },
 { "RANGE_PARSE_ERROR", RANGE_PARSE_ERROR },
 { "SHARED_ERRBASE", SHARED_ERRBASE },
 { "SHARED_BADARG", SHARED_BADARG },
 { "SHARED_NULPTR", SHARED_NULPTR },
 { "SHARED_TABFULL", SHARED_TABFULL },
 { "SHARED_NOTINIT", SHARED_NOTINIT },
 { "SHARED_IPCERR", SHARED_IPCERR },
 { "SHARED_NOMEM", SHARED_NOMEM },
 { "SHARED_AGAIN", SHARED_AGAIN },
 { "SHARED_NOFILE", SHARED_NOFILE },
 { "SHARED_NORESIZE", SHARED_NORESIZE },
 { "HEADER_NOT_EMPTY", HEADER_NOT_EMPTY },
 { "KEY_NO_EXIST", KEY_NO_EXIST },
 { "KEY_OUT_BOUNDS", KEY_OUT_BOUNDS },
 { "VALUE_UNDEFINED", VALUE_UNDEFINED },
 { "NO_QUOTE", NO_QUOTE },
 { "BAD_INDEX_KEY", BAD_INDEX_KEY },
 { "BAD_KEYCHAR", BAD_KEYCHAR },
 { "BAD_ORDER", BAD_ORDER },
 { "NOT_POS_INT", NOT_POS_INT },
 { "NO_END", NO_END },
 { "BAD_BITPIX", BAD_BITPIX },
 { "BAD_NAXIS", BAD_NAXIS },
 { "BAD_NAXES", BAD_NAXES },
 { "BAD_PCOUNT", BAD_PCOUNT },
 { "BAD_GCOUNT", BAD_GCOUNT },
 { "BAD_TFIELDS", BAD_TFIELDS },
 { "NEG_WIDTH", NEG_WIDTH },
 { "NEG_ROWS", NEG_ROWS},
 { "COL_NOT_FOUND", COL_NOT_FOUND },
 { "BAD_SIMPLE", BAD_SIMPLE },
 { "NO_SIMPLE", NO_SIMPLE },
 { "NO_BITPIX", NO_BITPIX },
 { "NO_NAXIS", NO_NAXIS },
 { "NO_NAXES", NO_NAXES },
 { "NO_XTENSION", NO_XTENSION },
 { "NOT_ATABLE", NOT_ATABLE },
 { "NOT_BTABLE", NOT_BTABLE },
 { "NO_PCOUNT", NO_PCOUNT },
 { "NO_GCOUNT", NO_GCOUNT },
 { "NO_TFIELDS", NO_TFIELDS },
 { "NO_TBCOL", NO_TBCOL },
 { "NO_TFORM", NO_TFORM },
 { "NOT_IMAGE", NOT_IMAGE },
 { "BAD_TBCOL", BAD_TBCOL },
 { "NOT_TABLE", NOT_TABLE },
 { "COL_TOO_WIDE", COL_TOO_WIDE },
 { "COL_NOT_UNIQUE", COL_NOT_UNIQUE },
 { "BAD_ROW_WIDTH", BAD_ROW_WIDTH },
 { "UNKNOWN_EXT", UNKNOWN_EXT },
 { "UNKNOWN_REC", UNKNOWN_REC },
 { "END_JUNK", END_JUNK },
 { "BAD_HEADER_FILL", BAD_HEADER_FILL },
 { "BAD_DATA_FILL", BAD_DATA_FILL },
 { "BAD_TFORM", BAD_TFORM },
 { "BAD_TFORM_DTYPE", BAD_TFORM_DTYPE },
 { "BAD_TDIM", BAD_TDIM },
 { "BAD_HEAP_PTR", BAD_HEAP_PTR },
 { "BAD_HDU_NUM", BAD_HDU_NUM },
 { "BAD_COL_NUM", BAD_COL_NUM },
 { "NEG_FILE_POS", NEG_FILE_POS },
 { "NEG_BYTES", NEG_BYTES },
 { "BAD_ROW_NUM", BAD_ROW_NUM },
 { "BAD_ELEM_NUM", BAD_ELEM_NUM },
 { "NOT_ASCII_COL", NOT_ASCII_COL },
 { "NOT_LOGICAL_COL", NOT_LOGICAL_COL },
 { "BAD_ATABLE_FORMAT", BAD_ATABLE_FORMAT },
 { "BAD_BTABLE_FORMAT", BAD_BTABLE_FORMAT },
 { "NO_NULL", NO_NULL },
 { "NOT_VARI_LEN", NOT_VARI_LEN },
 { "BAD_DIMEN", BAD_DIMEN },
 { "BAD_PIX_NUM", BAD_PIX_NUM },
 { "ZERO_SCALE", ZERO_SCALE },
 { "NEG_AXIS", NEG_AXIS },
 { "NOT_GROUP_TABLE", NOT_GROUP_TABLE },
 { "HDU_ALREADY_MEMBER", HDU_ALREADY_MEMBER },
 { "MEMBER_NOT_FOUND", MEMBER_NOT_FOUND },
 { "GROUP_NOT_FOUND", GROUP_NOT_FOUND },
 { "BAD_GROUP_ID", BAD_GROUP_ID },
 { "TOO_MANY_HDUS_TRACKED", TOO_MANY_HDUS_TRACKED },
 { "HDU_ALREADY_TRACKED", HDU_ALREADY_TRACKED },
 { "BAD_OPTION", BAD_OPTION },
 { "IDENTICAL_POINTERS", IDENTICAL_POINTERS },
 { "BAD_GROUP_ATTACH", BAD_GROUP_ATTACH },
 { "BAD_GROUP_DETACH", BAD_GROUP_DETACH },
 { "BAD_I2C", BAD_I2C },
 { "BAD_F2C", BAD_F2C },
 { "BAD_INTKEY", BAD_INTKEY },
 { "BAD_LOGICALKEY", BAD_LOGICALKEY },
 { "BAD_FLOATKEY", BAD_FLOATKEY },
 { "BAD_DOUBLEKEY", BAD_DOUBLEKEY },
 { "BAD_C2I", BAD_C2I },
 { "BAD_C2F", BAD_C2F },
 { "BAD_C2D", BAD_C2D },
 { "BAD_DATATYPE", BAD_DATATYPE },
 { "BAD_DECIM", BAD_DECIM },
 { "NUM_OVERFLOW", NUM_OVERFLOW },
 { "BAD_DATE", BAD_DATE },
 { "PARSE_SYNTAX_ERR", PARSE_SYNTAX_ERR },
 { "PARSE_BAD_TYPE", PARSE_BAD_TYPE },
 { "PARSE_LRG_VECTOR", PARSE_LRG_VECTOR },
 { "PARSE_NO_OUTPUT", PARSE_NO_OUTPUT },
 { "PARSE_BAD_COL", PARSE_BAD_COL },
 { "PARSE_BAD_OUTPUT", PARSE_BAD_OUTPUT },
 { "ANGLE_TOO_BIG", ANGLE_TOO_BIG },
 { "BAD_WCS_VAL", BAD_WCS_VAL },
 { "WCS_ERROR", WCS_ERROR },
 { "BAD_WCS_PROJ", BAD_WCS_PROJ },
 { "NO_WCS_KEY", NO_WCS_KEY },
 { "APPROX_WCS_KEY", APPROX_WCS_KEY },
 { "NO_CLOSE_ERROR", NO_CLOSE_ERROR },
 { "NGP_ERRBASE", NGP_ERRBASE },
 { "NGP_OK", NGP_OK },
 { "NGP_NO_MEMORY", NGP_NO_MEMORY },
 { "NGP_READ_ERR", NGP_READ_ERR },
 { "NGP_NUL_PTR", NGP_NUL_PTR },
 { "NGP_EMPTY_CURLINE", NGP_EMPTY_CURLINE },
 { "NGP_UNREAD_QUEUE_FULL", NGP_UNREAD_QUEUE_FULL },
 { "NGP_INC_NESTING", NGP_INC_NESTING },
 { "NGP_ERR_FOPEN", NGP_ERR_FOPEN },
 { "NGP_EOF", NGP_EOF },
 { "NGP_BAD_ARG", NGP_BAD_ARG },
 { "NGP_TOKEN_NOT_EXPECT", NGP_TOKEN_NOT_EXPECT },

 // version
 { "CFITSIO_VERSION", CFITSIO_VERSION },
 { "CFITSIO_MINOR", CFITSIO_MINOR },
 { "CFITSIO_MAJOR", CFITSIO_MAJOR },
 { "CFITSIO_SONAME", CFITSIO_SONAME }
};
