; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; Test long double atomic loads on z14.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z14 | FileCheck %s

define void @f1(ptr %ret, ptr %src) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lpq %r0, 0(%r3)
; CHECK-NEXT:    stg %r1, 8(%r2)
; CHECK-NEXT:    stg %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %val = load atomic fp128, ptr %src seq_cst, align 16
  store fp128 %val, ptr %ret, align 8
  ret void
}

define void @f1_fpuse(ptr %ret, ptr %src) {
; CHECK-LABEL: f1_fpuse:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lpq %r0, 0(%r3)
; CHECK-NEXT:    vlvgp %v0, %r0, %r1
; CHECK-NEXT:    wfaxb %v0, %v0, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %val = load atomic fp128, ptr %src seq_cst, align 16
  %use = fadd fp128 %val, %val
  store fp128 %use, ptr %ret, align 8
  ret void
}

define void @f2(ptr %ret, ptr %src) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -176
; CHECK-NEXT:    .cfi_def_cfa_offset 336
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    lghi %r2, 16
; CHECK-NEXT:    lhi %r5, 5
; CHECK-NEXT:    brasl %r14, __atomic_load@PLT
; CHECK-NEXT:    vl %v0, 160(%r15), 3
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 280(%r15)
; CHECK-NEXT:    br %r14
  %val = load atomic fp128, ptr %src seq_cst, align 8
  store fp128 %val, ptr %ret, align 8
  ret void
}

define void @f2_fpuse(ptr %ret, ptr %src) {
; CHECK-LABEL: f2_fpuse:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -176
; CHECK-NEXT:    .cfi_def_cfa_offset 336
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    lghi %r2, 16
; CHECK-NEXT:    lhi %r5, 5
; CHECK-NEXT:    brasl %r14, __atomic_load@PLT
; CHECK-NEXT:    vl %v0, 160(%r15), 3
; CHECK-NEXT:    wfaxb %v0, %v0, %v0
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 280(%r15)
; CHECK-NEXT:    br %r14
  %val = load atomic fp128, ptr %src seq_cst, align 8
  %use = fadd fp128 %val, %val
  store fp128 %use, ptr %ret, align 8
  ret void
}
