; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

define i8 @atomicrmw_xchg_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB0_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB0_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB0_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_acquire(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB1_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB1_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_acquire(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB2_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB2_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 acquire
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB3_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB3_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB3_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_acquire(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB4_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB4_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_acquire(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB5_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB5_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 acquire
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    move $a3, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB6_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    move $a3, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB6_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_exchange_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_exchange_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_add_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    add.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB8_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB8_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB8_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_add_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    add.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB9_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB9_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB9_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_add_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    add.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB10_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    add.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB10_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_add_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_add_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_add_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_sub_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB12_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB12_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB12_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_sub_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB13_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB13_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB13_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_sub_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    sub.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB14_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    sub.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB14_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.w $a2, $zero, $a1
; LA64-NEXT:    amadd_db.w $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_sub_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_sub_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_sub_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.d $a2, $zero, $a1
; LA64-NEXT:    amadd_db.d $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_nand_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    and $a5, $a4, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB16_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB16_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB16_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_nand_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a5, $a3, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB17_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB17_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB17_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_nand_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    nor $a3, $a3, $zero
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB18_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    nor $a3, $a3, $zero
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB18_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.w $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB18_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_nand_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_nand_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_nand_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.d $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB19_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_and_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a3
; LA32R-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB20_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB20_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_and_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a4
; LA32R-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB21_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB21_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_and_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB22_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB22_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_and_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_and_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_and_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_or_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB24_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB24_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_or_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB25_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB25_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_or_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    or $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB26_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    or $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB26_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_or_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_or_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_or_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_xor_i8_acquire(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i8_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB28_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i8_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB28_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i8_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b acquire
  ret i8 %1
}

define i16 @atomicrmw_xor_i16_acquire(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i16_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB29_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i16_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB29_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i16_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b acquire
  ret i16 %1
}

define i32 @atomicrmw_xor_i32_acquire(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i32_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    xor $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB30_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i32_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    xor $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB30_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i32_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b acquire
  ret i32 %1
}

define i64 @atomicrmw_xor_i64_acquire(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i64_acquire:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 2
; LA32R-NEXT:    bl __atomic_fetch_xor_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i64_acquire:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 2
; LA32S-NEXT:    bl __atomic_fetch_xor_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i64_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b acquire
  ret i64 %1
}

define i8 @atomicrmw_xchg_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB32_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB32_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB32_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_release(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB33_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB33_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 release
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_release(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB34_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB34_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 release
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB35_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB35_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB35_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_release(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB36_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB36_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 release
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_release(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB37_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB37_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 release
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    move $a3, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB38_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    move $a3, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB38_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_exchange_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_exchange_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_add_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB40_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    add.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB40_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB40_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB40_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB40_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB40_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_add_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB41_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    add.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB41_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB41_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB41_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB41_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB41_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_add_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB42_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    add.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB42_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB42_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    add.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB42_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_add_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_add_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_add_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_sub_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB44_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB44_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB44_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB44_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB44_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB44_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_sub_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB45_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB45_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB45_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_sub_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    sub.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB46_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    sub.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB46_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.w $a2, $zero, $a1
; LA64-NEXT:    amadd_db.w $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_sub_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_sub_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_sub_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.d $a2, $zero, $a1
; LA64-NEXT:    amadd_db.d $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_nand_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    and $a5, $a4, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB48_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB48_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB48_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_nand_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a5, $a3, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB49_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB49_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB49_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_nand_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    nor $a3, $a3, $zero
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB50_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    nor $a3, $a3, $zero
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB50_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.w $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB50_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_nand_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_nand_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_nand_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.d $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB51_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_and_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a3
; LA32R-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB52_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB52_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_and_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a4
; LA32R-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB53_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB53_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_and_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB54_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB54_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_and_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_and_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_and_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_or_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB56_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB56_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_or_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB57_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB57_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_or_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    or $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB58_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    or $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB58_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_or_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_or_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_or_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_xor_i8_release(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i8_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB60_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i8_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB60_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i8_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b release
  ret i8 %1
}

define i16 @atomicrmw_xor_i16_release(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i16_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB61_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i16_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB61_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i16_release:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b release
  ret i16 %1
}

define i32 @atomicrmw_xor_i32_release(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i32_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    xor $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB62_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i32_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    xor $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB62_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i32_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b release
  ret i32 %1
}

define i64 @atomicrmw_xor_i64_release(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i64_release:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 3
; LA32R-NEXT:    bl __atomic_fetch_xor_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i64_release:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 3
; LA32S-NEXT:    bl __atomic_fetch_xor_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i64_release:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b release
  ret i64 %1
}

define i8 @atomicrmw_xchg_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB64_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB64_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB64_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_acq_rel(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB65_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB65_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_acq_rel(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB66_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB66_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 acq_rel
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB67_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB67_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB67_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_acq_rel(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB68_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB68_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_acq_rel(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB69_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB69_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 acq_rel
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB70_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    move $a3, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB70_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB70_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    move $a3, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB70_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_exchange_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_exchange_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_add_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB72_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    add.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB72_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB72_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB72_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB72_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB72_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_add_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB73_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    add.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB73_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB73_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB73_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB73_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB73_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_add_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB74_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    add.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB74_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB74_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    add.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB74_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_add_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_add_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_add_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_sub_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB76_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB76_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB76_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB76_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB76_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB76_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_sub_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB77_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB77_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB77_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB77_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB77_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB77_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_sub_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB78_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    sub.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB78_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB78_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    sub.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB78_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.w $a2, $zero, $a1
; LA64-NEXT:    amadd_db.w $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_sub_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_sub_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_sub_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.d $a2, $zero, $a1
; LA64-NEXT:    amadd_db.d $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_nand_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB80_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    and $a5, $a4, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB80_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB80_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB80_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB80_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB80_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_nand_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a5, $a3, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB81_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB81_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB81_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB81_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_nand_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    nor $a3, $a3, $zero
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB82_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    nor $a3, $a3, $zero
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB82_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB82_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.w $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB82_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_nand_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_nand_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_nand_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB83_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.d $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB83_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_and_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a3
; LA32R-NEXT:  .LBB84_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB84_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB84_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB84_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_and_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a4
; LA32R-NEXT:  .LBB85_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB85_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB85_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB85_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_and_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB86_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB86_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB86_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_and_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_and_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_and_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_or_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB88_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB88_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB88_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_or_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB89_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB89_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB89_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB89_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_or_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB90_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    or $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB90_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB90_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    or $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB90_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_or_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_or_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_or_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_xor_i8_acq_rel(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i8_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB92_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB92_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i8_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB92_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB92_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i8_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b acq_rel
  ret i8 %1
}

define i16 @atomicrmw_xor_i16_acq_rel(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i16_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB93_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB93_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i16_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB93_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB93_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i16_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b acq_rel
  ret i16 %1
}

define i32 @atomicrmw_xor_i32_acq_rel(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i32_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB94_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    xor $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB94_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i32_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB94_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    xor $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB94_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i32_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b acq_rel
  ret i32 %1
}

define i64 @atomicrmw_xor_i64_acq_rel(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i64_acq_rel:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 4
; LA32R-NEXT:    bl __atomic_fetch_xor_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i64_acq_rel:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 4
; LA32S-NEXT:    bl __atomic_fetch_xor_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i64_acq_rel:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b acq_rel
  ret i64 %1
}

define i8 @atomicrmw_xchg_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB96_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB96_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB96_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_seq_cst(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB97_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB97_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 seq_cst
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_seq_cst(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB98_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB98_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 seq_cst
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB99_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB99_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB99_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_seq_cst(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB100_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB100_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB100_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB100_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 seq_cst
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_seq_cst(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB101_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB101_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB101_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB101_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor_db.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 seq_cst
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB102_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    move $a3, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB102_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB102_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    move $a3, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB102_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_exchange_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_exchange_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_add_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB104_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    add.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB104_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB104_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB104_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB104_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB104_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_add_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB105_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    add.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB105_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB105_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB105_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB105_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB105_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_add_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB106_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    add.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB106_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB106_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    add.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB106_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_add_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_add_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_add_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_sub_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB108_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB108_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB108_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB108_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB108_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB108_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_sub_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB109_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB109_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB109_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB109_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB109_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB109_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_sub_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB110_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    sub.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB110_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB110_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    sub.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB110_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.w $a2, $zero, $a1
; LA64-NEXT:    amadd_db.w $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_sub_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_sub_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_sub_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.d $a2, $zero, $a1
; LA64-NEXT:    amadd_db.d $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_nand_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    and $a5, $a4, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB112_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB112_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB112_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB112_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_nand_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a5, $a3, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB113_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB113_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB113_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB113_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_nand_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB114_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    nor $a3, $a3, $zero
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB114_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB114_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    nor $a3, $a3, $zero
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB114_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB114_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.w $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB114_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_nand_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_nand_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_nand_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB115_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.d $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB115_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_and_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a3
; LA32R-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB116_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB116_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB116_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_and_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a4
; LA32R-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB117_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB117_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB117_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_and_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB118_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB118_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB118_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_and_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_and_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_and_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amand_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_or_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB120_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB120_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB120_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB120_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_or_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB121_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB121_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB121_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_or_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    or $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB122_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB122_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    or $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB122_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_or_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_or_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_or_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_xor_i8_seq_cst(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i8_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB124_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB124_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i8_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB124_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB124_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i8_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_xor_i16_seq_cst(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i16_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB125_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB125_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i16_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB125_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB125_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i16_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor_db.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_xor_i32_seq_cst(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i32_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    xor $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB126_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i32_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB126_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    xor $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB126_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i32_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_xor_i64_seq_cst(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i64_seq_cst:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    ori $a3, $zero, 5
; LA32R-NEXT:    bl __atomic_fetch_xor_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i64_seq_cst:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    ori $a3, $zero, 5
; LA32S-NEXT:    bl __atomic_fetch_xor_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i64_seq_cst:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor_db.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b seq_cst
  ret i64 %1
}

define i8 @atomicrmw_xchg_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB128_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB128_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB128_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB128_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_0_i8_monotonic(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB129_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB129_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB129_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB129_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 0 monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_minus_1_i8_monotonic(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a2, $zero, 255
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB130_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB130_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a2, $zero, 255
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB130_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB130_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a2, $zero, 255
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i8 -1 monotonic
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB131_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    addi.w $a5, $a1, 0
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB131_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB131_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    addi.w $a5, $a1, 0
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB131_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB131_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    addi.w $a5, $a1, 0
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB131_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_0_i16_monotonic(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_0_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:    nor $a2, $a2, $zero
; LA32R-NEXT:  .LBB132_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    and $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB132_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_0_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:    nor $a2, $a2, $zero
; LA32S-NEXT:  .LBB132_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB132_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_0_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    nor $a2, $a2, $zero
; LA64-NEXT:    amand.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 0 monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_minus_1_i16_monotonic(ptr %a) nounwind {
; LA32R-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $zero, -4
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    sll.w $a2, $a2, $a0
; LA32R-NEXT:  .LBB133_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a1, 0
; LA32R-NEXT:    or $a4, $a3, $a2
; LA32R-NEXT:    sc.w $a4, $a1, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB133_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 4095
; LA32S-NEXT:    sll.w $a2, $a2, $a1
; LA32S-NEXT:  .LBB133_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a2
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB133_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_minus_1_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 4095
; LA64-NEXT:    sll.w $a2, $a2, $a1
; LA64-NEXT:    amor.w $a3, $a2, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i16 -1 monotonic
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB134_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    move $a3, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB134_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB134_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    move $a3, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB134_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xchg_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_exchange_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xchg_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_exchange_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xchg_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amswap.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xchg ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_add_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB136_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    add.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB136_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB136_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB136_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB136_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB136_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_add_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB137_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    add.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB137_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB137_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    add.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB137_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB137_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    add.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB137_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_add_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB138_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    add.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB138_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB138_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    add.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB138_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_add_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_add_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_add_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_add_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_add_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_add_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amadd.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw add ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_sub_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB140_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a4, $a1
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB140_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB140_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB140_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB140_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB140_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_sub_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB141_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    sub.w $a5, $a3, $a1
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB141_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB141_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    sub.w $a5, $a4, $a1
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB141_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB141_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    sub.w $a5, $a4, $a1
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB141_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_sub_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB142_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    sub.w $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB142_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB142_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    sub.w $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB142_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.w $a2, $zero, $a1
; LA64-NEXT:    amadd.w $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_sub_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_sub_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_sub_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_sub_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_sub_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_sub_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    sub.d $a2, $zero, $a1
; LA64-NEXT:    amadd.d $a1, $a2, $a0
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
  %1 = atomicrmw sub ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_nand_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB144_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a4, $a2, 0
; LA32R-NEXT:    and $a5, $a4, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    and $a5, $a5, $a3
; LA32R-NEXT:    xor $a5, $a4, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB144_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a4, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB144_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB144_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB144_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB144_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_nand_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB145_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a5, $a3, $a1
; LA32R-NEXT:    nor $a5, $a5, $zero
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    and $a5, $a5, $a4
; LA32R-NEXT:    xor $a5, $a3, $a5
; LA32R-NEXT:    sc.w $a5, $a2, 0
; LA32R-NEXT:    beq $a5, $zero, .LBB145_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB145_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a4, $a0, 0
; LA32S-NEXT:    and $a5, $a4, $a1
; LA32S-NEXT:    nor $a5, $a5, $zero
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    and $a5, $a5, $a3
; LA32S-NEXT:    xor $a5, $a4, $a5
; LA32S-NEXT:    sc.w $a5, $a0, 0
; LA32S-NEXT:    beq $a5, $zero, .LBB145_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a4, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:  .LBB145_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a4, $a0, 0
; LA64-NEXT:    and $a5, $a4, $a1
; LA64-NEXT:    nor $a5, $a5, $zero
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    and $a5, $a5, $a3
; LA64-NEXT:    xor $a5, $a4, $a5
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB145_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    srl.w $a0, $a4, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_nand_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB146_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    nor $a3, $a3, $zero
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB146_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB146_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    nor $a3, $a3, $zero
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB146_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB146_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.w $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB146_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_nand_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_nand_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_nand_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_nand_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_nand_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_nand_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB147_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a2, $a0, 0
; LA64-NEXT:    and $a3, $a2, $a1
; LA64-NEXT:    nor $a3, $a3, $zero
; LA64-NEXT:    sc.d $a3, $a0, 0
; LA64-NEXT:    beq $a3, $zero, .LBB147_1
; LA64-NEXT:  # %bb.2:
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw nand ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_and_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ori $a3, $zero, 255
; LA32R-NEXT:    sll.w $a3, $a3, $a0
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a3
; LA32R-NEXT:  .LBB148_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB148_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    ori $a3, $zero, 255
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB148_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB148_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a3, $zero, 255
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_and_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    sll.w $a4, $a3, $a0
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:    orn $a1, $a1, $a4
; LA32R-NEXT:  .LBB149_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    and $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB149_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    lu12i.w $a3, 15
; LA32S-NEXT:    ori $a3, $a3, 4095
; LA32S-NEXT:    sll.w $a3, $a3, $a2
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:    orn $a1, $a1, $a3
; LA32S-NEXT:  .LBB149_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    and $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB149_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a3, 15
; LA64-NEXT:    ori $a3, $a3, 4095
; LA64-NEXT:    sll.w $a3, $a3, $a2
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    orn $a1, $a1, $a3
; LA64-NEXT:    amand.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_and_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB150_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    and $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB150_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB150_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    and $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB150_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amand.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_and_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_and_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_and_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_and_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_and_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_and_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amand.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw and ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_or_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB152_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB152_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB152_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_or_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    or $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB153_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB153_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    or $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB153_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amor.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_or_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB154_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    or $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB154_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB154_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    or $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB154_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amor.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_or_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_or_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_or_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_or_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_or_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_or_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amor.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw or ptr %a, i64 %b monotonic
  ret i64 %1
}

define i8 @atomicrmw_xor_i8_monotonic(ptr %a, i8 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i8_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB156_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB156_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i8_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB156_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB156_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i8_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i8 %b monotonic
  ret i8 %1
}

define i16 @atomicrmw_xor_i16_monotonic(ptr %a, i16 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i16_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -4
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    lu12i.w $a3, 15
; LA32R-NEXT:    ori $a3, $a3, 4095
; LA32R-NEXT:    and $a1, $a1, $a3
; LA32R-NEXT:    sll.w $a1, $a1, $a0
; LA32R-NEXT:  .LBB157_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a3, $a2, 0
; LA32R-NEXT:    xor $a4, $a3, $a1
; LA32R-NEXT:    sc.w $a4, $a2, 0
; LA32R-NEXT:    beq $a4, $zero, .LBB157_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    srl.w $a0, $a3, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i16_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a2, $a0, 3
; LA32S-NEXT:    bstrins.w $a0, $zero, 1, 0
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    sll.w $a1, $a1, $a2
; LA32S-NEXT:  .LBB157_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a3, $a0, 0
; LA32S-NEXT:    xor $a4, $a3, $a1
; LA32S-NEXT:    sc.w $a4, $a0, 0
; LA32S-NEXT:    beq $a4, $zero, .LBB157_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    srl.w $a0, $a3, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i16_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a2, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a2
; LA64-NEXT:    amxor.w $a3, $a1, $a0
; LA64-NEXT:    srl.w $a0, $a3, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i16 %b monotonic
  ret i16 %1
}

define i32 @atomicrmw_xor_i32_monotonic(ptr %a, i32 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i32_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:  .LBB158_1: # =>This Inner Loop Header: Depth=1
; LA32R-NEXT:    ll.w $a2, $a0, 0
; LA32R-NEXT:    xor $a3, $a2, $a1
; LA32R-NEXT:    sc.w $a3, $a0, 0
; LA32R-NEXT:    beq $a3, $zero, .LBB158_1
; LA32R-NEXT:  # %bb.2:
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i32_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:  .LBB158_1: # =>This Inner Loop Header: Depth=1
; LA32S-NEXT:    ll.w $a2, $a0, 0
; LA32S-NEXT:    xor $a3, $a2, $a1
; LA32S-NEXT:    sc.w $a3, $a0, 0
; LA32S-NEXT:    beq $a3, $zero, .LBB158_1
; LA32S-NEXT:  # %bb.2:
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i32_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor.w $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i32 %b monotonic
  ret i32 %1
}

define i64 @atomicrmw_xor_i64_monotonic(ptr %a, i64 %b) nounwind {
; LA32R-LABEL: atomicrmw_xor_i64_monotonic:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    move $a3, $zero
; LA32R-NEXT:    bl __atomic_fetch_xor_8
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: atomicrmw_xor_i64_monotonic:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    move $a3, $zero
; LA32S-NEXT:    bl __atomic_fetch_xor_8
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: atomicrmw_xor_i64_monotonic:
; LA64:       # %bb.0:
; LA64-NEXT:    amxor.d $a2, $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %1 = atomicrmw xor ptr %a, i64 %b monotonic
  ret i64 %1
}
