; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 --mattr=+zba -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32IZBA
; RUN: llc -mtriple=riscv32 -mattr=+zba,+experimental-xqcisls -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32IZBAXQCISLS

define i32 @lb_ri(i8* %a, i32 %b) {
; RV32I-LABEL: lb_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lb a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lb_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    sh3add a0, a1, a0
; RV32IZBA-NEXT:    lb a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lb_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrb a0, a0, a1, 3
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %b, 3
  %1 = getelementptr i8, i8* %a, i32 %shl
  %2 = load i8, i8* %1
  %3 = sext i8 %2 to i32
  ret i32 %3
}

define i32 @lbu_ri(i8* %a, i32 %b) {
; RV32I-LABEL: lbu_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lbu_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    sh2add a0, a1, a0
; RV32IZBA-NEXT:    lbu a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lbu_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrbu a0, a0, a1, 2
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %b, 2
  %1 = getelementptr i8, i8* %a, i32 %shl
  %2 = load i8, i8* %1
  %3 = zext i8 %2 to i32
  ret i32 %3
}

define i32 @lh_ri(i16* %a, i32 %b) {
; RV32I-LABEL: lh_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 5
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lh_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    slli a1, a1, 5
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lh a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lh_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrh a0, a0, a1, 5
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %b, 4
  %1 = getelementptr i16, i16* %a, i32 %shl
  %2 = load i16, i16* %1
  %3 = sext i16 %2 to i32
  ret i32 %3
}

define i32 @lhu_ri(i16* %a, i32 %b) {
; RV32I-LABEL: lhu_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 6
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lhu a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lhu_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    slli a1, a1, 6
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lhu a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lhu_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrhu a0, a0, a1, 6
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %b, 5
  %1 = getelementptr i16, i16* %a, i32 %shl
  %2 = load i16, i16* %1
  %3 = zext i16 %2 to i32
  ret i32 %3
}

define i32 @lw_ri(i32* %a, i32 %b) {
; RV32I-LABEL: lw_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 6
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lw_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    slli a1, a1, 6
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lw a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lw_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrw a0, a0, a1, 6
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %b, 4
  %1 = getelementptr i32, i32* %a, i32 %shl
  %2 = load i32, i32* %1
  ret i32 %2
}

define void @sb_ri(i8* %a, i8 %b, i32 %c) {
; RV32I-LABEL: sb_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a2, 7
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    sb a1, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: sb_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    slli a2, a2, 7
; RV32IZBA-NEXT:    add a0, a0, a2
; RV32IZBA-NEXT:    sb a1, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: sb_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.srb a1, a0, a2, 7
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %c, 7
  %1 = getelementptr i8, i8* %a, i32 %shl
  store i8 %b, i8* %1
  ret void
}

define void @sh_ri(i16* %a, i16 %b, i32 %c) {
; RV32I-LABEL: sh_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a2, 3
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    sh a1, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: sh_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    sh3add a0, a2, a0
; RV32IZBA-NEXT:    sh a1, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: sh_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.srh a1, a0, a2, 3
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %c, 2
  %1 = getelementptr i16, i16* %a, i32 %shl
  store i16 %b, i16* %1
  ret void
}

define void @sw_ri(i32* %a, i32 %b, i32 %c) {
; RV32I-LABEL: sw_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a2, 3
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    sw a1, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: sw_ri:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    sh3add a0, a2, a0
; RV32IZBA-NEXT:    sw a1, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: sw_ri:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.srw a1, a0, a2, 3
; RV32IZBAXQCISLS-NEXT:    ret
  %shl = shl i32 %c, 1
  %1 = getelementptr i32, i32* %a, i32 %shl
  store i32 %b, i32* %1
  ret void
}

define i8 @lrb_anyext(ptr %a, i64 %b) {
; RV32I-LABEL: lrb_anyext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lrb_anyext:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lbu a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lrb_anyext:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrbu a0, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i64 %b
  %2 = load i8, ptr %1, align 1
  ret i8 %2
}

define i64 @lrb(ptr %a, i64 %b) {
; RV32I-LABEL: lrb:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lb a1, 0(a0)
; RV32I-NEXT:    srai a2, a1, 31
; RV32I-NEXT:    add a0, a1, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    add a2, a2, a2
; RV32I-NEXT:    add a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lrb:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lb a1, 0(a0)
; RV32IZBA-NEXT:    srai a2, a1, 31
; RV32IZBA-NEXT:    add a0, a1, a1
; RV32IZBA-NEXT:    sltu a1, a0, a1
; RV32IZBA-NEXT:    add a2, a2, a2
; RV32IZBA-NEXT:    add a1, a2, a1
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lrb:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrb a1, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    srai a2, a1, 31
; RV32IZBAXQCISLS-NEXT:    add a0, a1, a1
; RV32IZBAXQCISLS-NEXT:    sltu a1, a0, a1
; RV32IZBAXQCISLS-NEXT:    add a2, a2, a2
; RV32IZBAXQCISLS-NEXT:    add a1, a2, a1
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i64 %b
  %2 = load i8, ptr %1, align 1
  %3 = sext i8 %2 to i64
  %4 = add i64 %3, %3
  ret i64 %4
}

define i8 @lurb_anyext(ptr %a, i32 %b) {
; RV32I-LABEL: lurb_anyext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lurb_anyext:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lbu a0, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lurb_anyext:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrbu a0, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = zext i32 %b to i64
  %2 = getelementptr i8, ptr %a, i64 %1
  %3 = load i8, ptr %2, align 1
  ret i8 %3
}

define i64 @lurb(ptr %a, i32 %b) {
; RV32I-LABEL: lurb:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lb a1, 0(a0)
; RV32I-NEXT:    srai a2, a1, 31
; RV32I-NEXT:    add a0, a1, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    add a2, a2, a2
; RV32I-NEXT:    add a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lurb:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lb a1, 0(a0)
; RV32IZBA-NEXT:    srai a2, a1, 31
; RV32IZBA-NEXT:    add a0, a1, a1
; RV32IZBA-NEXT:    sltu a1, a0, a1
; RV32IZBA-NEXT:    add a2, a2, a2
; RV32IZBA-NEXT:    add a1, a2, a1
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lurb:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrb a1, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    srai a2, a1, 31
; RV32IZBAXQCISLS-NEXT:    add a0, a1, a1
; RV32IZBAXQCISLS-NEXT:    sltu a1, a0, a1
; RV32IZBAXQCISLS-NEXT:    add a2, a2, a2
; RV32IZBAXQCISLS-NEXT:    add a1, a2, a1
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = zext i32 %b to i64
  %2 = getelementptr i8, ptr %a, i64 %1
  %3 = load i8, ptr %2, align 1
  %4 = sext i8 %3 to i64
  %5 = add i64 %4, %4
  ret i64 %5
}

define i64 @lrbu(ptr %a, i64 %b) {
; RV32I-LABEL: lrbu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a1, 0(a0)
; RV32I-NEXT:    add a0, a1, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lrbu:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lbu a1, 0(a0)
; RV32IZBA-NEXT:    add a0, a1, a1
; RV32IZBA-NEXT:    sltu a1, a0, a1
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lrbu:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrbu a1, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    add a0, a1, a1
; RV32IZBAXQCISLS-NEXT:    sltu a1, a0, a1
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i64 %b
  %2 = load i8, ptr %1, align 1
  %3 = zext i8 %2 to i64
  %4 = add i64 %3, %3
  ret i64 %4
}

define i64 @lurbu(ptr %a, i32 %b) {
; RV32I-LABEL: lurbu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a1, 0(a0)
; RV32I-NEXT:    add a0, a1, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lurbu:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    lbu a1, 0(a0)
; RV32IZBA-NEXT:    add a0, a1, a1
; RV32IZBA-NEXT:    sltu a1, a0, a1
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lurbu:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    qc.lrbu a1, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    add a0, a1, a1
; RV32IZBAXQCISLS-NEXT:    sltu a1, a0, a1
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = zext i32 %b to i64
  %2 = getelementptr i8, ptr %a, i64 %1
  %3 = load i8, ptr %2, align 1
  %4 = zext i8 %3 to i64
  %5 = add i64 %4, %4
  ret i64 %5
}

define i64 @lrd_2(ptr %a, i64 %b) {
; RV32I-LABEL: lrd_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    lw a1, 96(a0)
; RV32I-NEXT:    lw a2, 100(a0)
; RV32I-NEXT:    add a0, a1, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    add a2, a2, a2
; RV32I-NEXT:    add a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lrd_2:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    sh3add a0, a1, a0
; RV32IZBA-NEXT:    lw a1, 96(a0)
; RV32IZBA-NEXT:    lw a2, 100(a0)
; RV32IZBA-NEXT:    add a0, a1, a1
; RV32IZBA-NEXT:    sltu a1, a0, a1
; RV32IZBA-NEXT:    add a2, a2, a2
; RV32IZBA-NEXT:    add a1, a2, a1
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lrd_2:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    addi a2, a0, 96
; RV32IZBAXQCISLS-NEXT:    qc.lrw a2, a2, a1, 3
; RV32IZBAXQCISLS-NEXT:    addi a0, a0, 100
; RV32IZBAXQCISLS-NEXT:    qc.lrw a1, a0, a1, 3
; RV32IZBAXQCISLS-NEXT:    add a0, a2, a2
; RV32IZBAXQCISLS-NEXT:    sltu a2, a0, a2
; RV32IZBAXQCISLS-NEXT:    add a1, a1, a1
; RV32IZBAXQCISLS-NEXT:    add a1, a1, a2
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = add i64 %b, 12
  %2 = getelementptr i64, ptr %a, i64 %1
  %3 = load i64, ptr %2, align 8
  %4 = add i64 %3, %3
  ret i64 %4
}

define void @srb(ptr %a, i64 %b, i8 %c) {
; RV32I-LABEL: srb:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a3, a3, a3
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    sb a3, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: srb:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a3, a3, a3
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    sb a3, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: srb:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    add a3, a3, a3
; RV32IZBAXQCISLS-NEXT:    qc.srb a3, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = add i8 %c, %c
  %2 = getelementptr i8, ptr %a, i64 %b
  store i8 %1, ptr %2, align 1
  ret void
}

define void @surb(ptr %a, i32 %b, i8 %c) {
; RV32I-LABEL: surb:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a2, a2, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    sb a2, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: surb:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    add a2, a2, a2
; RV32IZBA-NEXT:    add a0, a0, a1
; RV32IZBA-NEXT:    sb a2, 0(a0)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: surb:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    add a2, a2, a2
; RV32IZBAXQCISLS-NEXT:    qc.srb a2, a0, a1, 0
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = zext i32 %b to i64
  %2 = add i8 %c, %c
  %3 = getelementptr i8, ptr %a, i64 %1
  store i8 %2, ptr %3, align 1
  ret void
}

define i64 @lrd_large_shift(ptr %a, i64 %b) {
; RV32I-LABEL: lrd_large_shift:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 5
; RV32I-NEXT:    add a1, a1, a0
; RV32I-NEXT:    lw a0, 384(a1)
; RV32I-NEXT:    lw a1, 388(a1)
; RV32I-NEXT:    ret
;
; RV32IZBA-LABEL: lrd_large_shift:
; RV32IZBA:       # %bb.0:
; RV32IZBA-NEXT:    slli a1, a1, 5
; RV32IZBA-NEXT:    add a1, a1, a0
; RV32IZBA-NEXT:    lw a0, 384(a1)
; RV32IZBA-NEXT:    lw a1, 388(a1)
; RV32IZBA-NEXT:    ret
;
; RV32IZBAXQCISLS-LABEL: lrd_large_shift:
; RV32IZBAXQCISLS:       # %bb.0:
; RV32IZBAXQCISLS-NEXT:    addi a2, a0, 384
; RV32IZBAXQCISLS-NEXT:    addi a3, a0, 388
; RV32IZBAXQCISLS-NEXT:    qc.lrw a0, a2, a1, 5
; RV32IZBAXQCISLS-NEXT:    qc.lrw a1, a3, a1, 5
; RV32IZBAXQCISLS-NEXT:    ret
  %1 = add i64 %b, 12
  %2 = shl i64 %1, 2
  %3 = getelementptr i64, ptr %a, i64 %2
  %4 = load i64, ptr %3, align 8
  ret i64 %4
}
