; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

; This test set ensures that we can correctly operate with recurrencies from
; different loops.

; Check that we can evaluate a sum of phis from two different loops in any
; order.

define void @test_00(i1 %arg) {
; CHECK-LABEL: 'test_00'
; CHECK-NEXT:  Classifying expressions for: @test_00
; CHECK-NEXT:    %phi1 = phi i32 [ 10, %entry ], [ %phi1.inc, %loop1 ]
; CHECK-NEXT:    --> {10,+,1}<nuw><nsw><%loop1> U: [10,175) S: [10,175) Exits: 174 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2 = phi i32 [ 4, %entry ], [ %phi2.inc, %loop1 ]
; CHECK-NEXT:    --> {4,+,2}<nuw><nsw><%loop1> U: [4,333) S: [4,333) Exits: 332 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
; CHECK-NEXT:    --> {6,+,3}<nuw><nsw><%loop1> U: [6,499) S: [6,499) Exits: 498 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {11,+,1}<nuw><nsw><%loop1> U: [11,176) S: [11,176) Exits: 175 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {6,+,2}<nuw><nsw><%loop1> U: [6,335) S: [6,335) Exits: 334 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3.inc = add i32 %phi3, 3
; CHECK-NEXT:    --> {9,+,3}<nuw><nsw><%loop1> U: [9,502) S: [9,502) Exits: 501 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %sum1 = add i32 %phi1, %phi2
; CHECK-NEXT:    --> {14,+,3}<%loop1> U: [14,507) S: [14,507) Exits: 506 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %sum2 = add i32 %sum1, %phi3
; CHECK-NEXT:    --> {20,+,6}<%loop1> U: [20,1005) S: [20,1005) Exits: 1004 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi4 = phi i32 [ 63, %loop1 ], [ %phi4.inc, %loop2 ]
; CHECK-NEXT:    --> {63,+,1}<nuw><nsw><%loop2> U: [63,205) S: [63,205) Exits: 204 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5 = phi i32 [ 53, %loop1 ], [ %phi5.inc, %loop2 ]
; CHECK-NEXT:    --> {53,+,2}<nuw><nsw><%loop2> U: [53,336) S: [53,336) Exits: 335 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
; CHECK-NEXT:    --> {43,+,3}<nuw><nsw><%loop2> U: [43,467) S: [43,467) Exits: 466 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi4.inc = add i32 %phi4, 1
; CHECK-NEXT:    --> {64,+,1}<nuw><nsw><%loop2> U: [64,206) S: [64,206) Exits: 205 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5.inc = add i32 %phi5, 2
; CHECK-NEXT:    --> {55,+,2}<nuw><nsw><%loop2> U: [55,338) S: [55,338) Exits: 337 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6.inc = add i32 %phi6, 3
; CHECK-NEXT:    --> {46,+,3}<nuw><nsw><%loop2> U: [46,470) S: [46,470) Exits: 469 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %sum3 = add i32 %phi4, %phi5
; CHECK-NEXT:    --> {116,+,3}<%loop2> U: [116,540) S: [116,540) Exits: 539 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %sum4 = add i32 %sum3, %phi6
; CHECK-NEXT:    --> {159,+,6}<%loop2> U: [159,1006) S: [159,1006) Exits: 1005 LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %s1 = add i32 %phi1, %phi4
; CHECK-NEXT:    --> {{\{\{}}73,+,1}<nuw><nsw><%loop1>,+,1}<nw><%loop2> U: [73,379) S: [73,379) --> 378 U: [378,379) S: [378,379)
; CHECK-NEXT:    %s2 = add i32 %phi5, %phi2
; CHECK-NEXT:    --> {{\{\{}}57,+,2}<nuw><nsw><%loop1>,+,2}<nw><%loop2> U: [57,668) S: [57,668) --> 667 U: [667,668) S: [667,668)
; CHECK-NEXT:    %s3 = add i32 %sum1, %sum3
; CHECK-NEXT:    --> {{\{\{}}130,+,3}<%loop1>,+,3}<%loop2> U: [130,1046) S: [130,1046) --> 1045 U: [1045,1046) S: [1045,1046)
; CHECK-NEXT:    %s4 = add i32 %sum4, %sum2
; CHECK-NEXT:    --> {{\{\{}}179,+,6}<%loop1>,+,6}<%loop2> U: [179,2010) S: [179,2010) --> 2009 U: [2009,2010) S: [2009,2010)
; CHECK-NEXT:    %s5 = add i32 %phi3, %sum3
; CHECK-NEXT:    --> {{\{\{}}122,+,3}<nuw><nsw><%loop1>,+,3}<%loop2> U: [122,1038) S: [122,1038) --> 1037 U: [1037,1038) S: [1037,1038)
; CHECK-NEXT:    %s6 = add i32 %sum2, %phi6
; CHECK-NEXT:    --> {{\{\{}}63,+,6}<%loop1>,+,3}<nw><%loop2> U: [63,1471) S: [63,1471) --> 1470 U: [1470,1471) S: [1470,1471)
; CHECK-NEXT:  Determining loop execution counts for: @test_00
; CHECK-NEXT:  Loop %loop2: backedge-taken count is i32 141
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 141
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is i32 141
; CHECK-NEXT:  Loop %loop2: Trip multiple is 142
; CHECK-NEXT:  Loop %loop1: backedge-taken count is i32 164
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i32 164
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is i32 164
; CHECK-NEXT:  Loop %loop1: Trip multiple is 165
;

entry:
  br label %loop1

loop1:
  %phi1 = phi i32 [ 10, %entry ], [ %phi1.inc, %loop1 ]
  %phi2 = phi i32 [ 4, %entry ], [ %phi2.inc, %loop1 ]
  %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
  %phi1.inc = add i32 %phi1, 1
  %phi2.inc = add i32 %phi2, 2
  %phi3.inc = add i32 %phi3, 3
  %sum1 = add i32 %phi1, %phi2
  %sum2 = add i32 %sum1, %phi3
  %cond1 = icmp ult i32 %sum2, 1000
  br i1 %cond1, label %loop1, label %loop2

loop2:
  %phi4 = phi i32 [ 63, %loop1 ], [ %phi4.inc, %loop2 ]
  %phi5 = phi i32 [ 53, %loop1 ], [ %phi5.inc, %loop2 ]
  %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
  %phi4.inc = add i32 %phi4, 1
  %phi5.inc = add i32 %phi5, 2
  %phi6.inc = add i32 %phi6, 3
  %sum3 = add i32 %phi4, %phi5
  %sum4 = add i32 %sum3, %phi6
  %cond2 = icmp ult i32 %sum4, 1000
  br i1 %cond2, label %loop2, label %exit

exit:
  %s1 = add i32 %phi1, %phi4
  %s2 = add i32 %phi5, %phi2
  %s3 = add i32 %sum1, %sum3
  %s4 = add i32 %sum4, %sum2
  %s5 = add i32 %phi3, %sum3
  %s6 = add i32 %sum2, %phi6
  ret void
}

; Check that we can evaluate a sum of phis+invariants from two different loops
; in any order.

define void @test_01(i32 %a, i32 %b) {
; CHECK-LABEL: 'test_01'
; CHECK-NEXT:  Classifying expressions for: @test_01
; CHECK-NEXT:    %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
; CHECK-NEXT:    --> {%a,+,1}<nw><%loop1> U: full-set S: full-set Exits: (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))) + %a) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2 = phi i32 [ %b, %entry ], [ %phi2.inc, %loop1 ]
; CHECK-NEXT:    --> {%b,+,2}<nw><%loop1> U: full-set S: full-set Exits: ((2 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw><nsw> + %b) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
; CHECK-NEXT:    --> {6,+,3}<nuw><nsw><%loop1> U: [6,508) S: [6,508) Exits: (6 + (3 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw>)<nuw> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {(1 + %a),+,1}<nw><%loop1> U: full-set S: full-set Exits: (1 + ((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))) + %a) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {(2 + %b),+,2}<nw><%loop1> U: full-set S: full-set Exits: (2 + (2 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw><nsw> + %b) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3.inc = add i32 %phi3, 3
; CHECK-NEXT:    --> {9,+,3}<nuw><nsw><%loop1> U: [9,511) S: [9,511) Exits: (9 + (3 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw>)<nuw> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %sum1 = add i32 %phi1, %phi2
; CHECK-NEXT:    --> {(%a + %b),+,3}<%loop1> U: full-set S: full-set Exits: ((3 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw> + %a + %b) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %sum2 = add i32 %sum1, %phi3
; CHECK-NEXT:    --> {(6 + %a + %b),+,6}<%loop1> U: full-set S: full-set Exits: (6 + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + %a + %b) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %is1 = add i32 %sum2, %a
; CHECK-NEXT:    --> {(6 + (2 * %a) + %b),+,6}<%loop1> U: full-set S: full-set Exits: (6 + (2 * %a) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + %b) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi4 = phi i32 [ 63, %loop1 ], [ %phi4.inc, %loop2 ]
; CHECK-NEXT:    --> {63,+,1}<nuw><nsw><%loop2> U: [63,231) S: [63,231) Exits: (63 + ((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5 = phi i32 [ 53, %loop1 ], [ %phi5.inc, %loop2 ]
; CHECK-NEXT:    --> {53,+,2}<nuw><nsw><%loop2> U: [53,388) S: [53,388) Exits: (53 + (2 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw><nsw>)<nuw><nsw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
; CHECK-NEXT:    --> {43,+,3}<nuw><nsw><%loop2> U: [43,545) S: [43,545) Exits: (43 + (3 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw>)<nuw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi4.inc = add i32 %phi4, 1
; CHECK-NEXT:    --> {64,+,1}<nuw><nsw><%loop2> U: [64,232) S: [64,232) Exits: (64 + ((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5.inc = add i32 %phi5, 2
; CHECK-NEXT:    --> {55,+,2}<nuw><nsw><%loop2> U: [55,390) S: [55,390) Exits: (55 + (2 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw><nsw>)<nuw><nsw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6.inc = add i32 %phi6, 3
; CHECK-NEXT:    --> {46,+,3}<nuw><nsw><%loop2> U: [46,548) S: [46,548) Exits: (46 + (3 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw>)<nuw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %sum3 = add i32 %phi4, %phi5
; CHECK-NEXT:    --> {116,+,3}<%loop2> U: [116,618) S: [116,618) Exits: (116 + (3 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw>)<nuw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %sum4 = add i32 %sum3, %phi6
; CHECK-NEXT:    --> {159,+,6}<%loop2> U: [159,1162) S: [159,1162) Exits: (159 + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %is2 = add i32 %sum4, %b
; CHECK-NEXT:    --> {(159 + %b),+,6}<%loop2> U: full-set S: full-set Exits: (159 + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))) + %b) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %ec2 = add i32 %is1, %is2
; CHECK-NEXT:    --> {{\{\{}}(165 + (2 * %a) + (2 * %b)),+,6}<%loop1>,+,6}<%loop2> U: full-set S: full-set --> {(165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))),+,6}<%loop2> U: full-set S: full-set Exits: (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %s1 = add i32 %phi1, %is1
; CHECK-NEXT:    --> {(6 + (3 * %a) + %b),+,7}<%loop1> U: full-set S: full-set --> (6 + (3 * %a) + (7 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + %b) U: full-set S: full-set
; CHECK-NEXT:    %s2 = add i32 %is2, %phi4
; CHECK-NEXT:    --> {(222 + %b),+,7}<%loop2> U: full-set S: full-set --> (222 + (7 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))) + %b) U: full-set S: full-set
; CHECK-NEXT:    %s3 = add i32 %is1, %phi5
; CHECK-NEXT:    --> {{\{\{}}(59 + (2 * %a) + %b),+,6}<%loop1>,+,2}<nw><%loop2> U: full-set S: full-set --> (59 + (2 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))<nuw><nsw> + (2 * %a) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + %b) U: full-set S: full-set
; CHECK-NEXT:    %s4 = add i32 %phi2, %is2
; CHECK-NEXT:    --> {{\{\{}}(159 + (2 * %b)),+,2}<nw><%loop1>,+,6}<%loop2> U: full-set S: full-set --> (159 + (2 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))<nuw><nsw> + (2 * %b) + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))) U: full-set S: full-set
; CHECK-NEXT:    %s5 = add i32 %is1, %is2
; CHECK-NEXT:    --> {{\{\{}}(165 + (2 * %a) + (2 * %b)),+,6}<%loop1>,+,6}<%loop2> U: full-set S: full-set --> (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))) U: full-set S: full-set
; CHECK-NEXT:    %s6 = add i32 %is2, %is1
; CHECK-NEXT:    --> {{\{\{}}(165 + (2 * %a) + (2 * %b)),+,6}<%loop1>,+,6}<%loop2> U: full-set S: full-set --> (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (6 * (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))))))) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test_01
; CHECK-NEXT:  Loop %loop2: backedge-taken count is (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 167
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is (((-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (-1 * (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))<nuw><nsw> + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))))))))) /u 6) + (1 umin (-165 + (-6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))) + (-2 * %a) + (-2 * %b) + (1000 umax (165 + (2 * %a) + (2 * %b) + (6 * (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))))))))
; CHECK-NEXT:  Loop %loop2: Trip multiple is 1
; CHECK-NEXT:  Loop %loop1: backedge-taken count is (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i32 167
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is (((-6 + (-2 * %a) + (-1 * (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))<nuw><nsw> + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b))) /u 6) + (1 umin (-6 + (-2 * %a) + (-1 * %b) + (1000 umax (6 + (2 * %a) + %b)))))
; CHECK-NEXT:  Loop %loop1: Trip multiple is 1
;

entry:
  br label %loop1

loop1:
  %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
  %phi2 = phi i32 [ %b, %entry ], [ %phi2.inc, %loop1 ]
  %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
  %phi1.inc = add i32 %phi1, 1
  %phi2.inc = add i32 %phi2, 2
  %phi3.inc = add i32 %phi3, 3
  %sum1 = add i32 %phi1, %phi2
  %sum2 = add i32 %sum1, %phi3
  %is1 = add i32 %sum2, %a
  %cond1 = icmp ult i32 %is1, 1000
  br i1 %cond1, label %loop1, label %loop2

loop2:
  %phi4 = phi i32 [ 63, %loop1 ], [ %phi4.inc, %loop2 ]
  %phi5 = phi i32 [ 53, %loop1 ], [ %phi5.inc, %loop2 ]
  %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
  %phi4.inc = add i32 %phi4, 1
  %phi5.inc = add i32 %phi5, 2
  %phi6.inc = add i32 %phi6, 3
  %sum3 = add i32 %phi4, %phi5
  %sum4 = add i32 %sum3, %phi6
  %is2 = add i32 %sum4, %b
  %ec2 = add i32 %is1, %is2
  %cond2 = icmp ult i32 %ec2, 1000
  br i1 %cond2, label %loop2, label %exit

exit:
  %s1 = add i32 %phi1, %is1
  %s2 = add i32 %is2, %phi4
  %s3 = add i32 %is1, %phi5
  %s4 = add i32 %phi2, %is2
  %s5 = add i32 %is1, %is2
  %s6 = add i32 %is2, %is1
  ret void
}

; Check that we can correctly evaluate a sum of phis+variants from two different
; loops in any order.

define void @test_02(i32 %a, i32 %b, ptr %p) {
; CHECK-LABEL: 'test_02'
; CHECK-NEXT:  Classifying expressions for: @test_02
; CHECK-NEXT:    %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
; CHECK-NEXT:    --> {%a,+,1}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2 = phi i32 [ %b, %entry ], [ %phi2.inc, %loop1 ]
; CHECK-NEXT:    --> {%b,+,2}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
; CHECK-NEXT:    --> {6,+,3}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {(1 + %a),+,1}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {(2 + %b),+,2}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi3.inc = add i32 %phi3, 3
; CHECK-NEXT:    --> {9,+,3}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %v1 = load i32, ptr %p, align 4
; CHECK-NEXT:    --> %v1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Variant }
; CHECK-NEXT:    %sum1 = add i32 %phi1, %phi2
; CHECK-NEXT:    --> {(%a + %b),+,3}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %sum2 = add i32 %sum1, %phi3
; CHECK-NEXT:    --> {(6 + %a + %b),+,6}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %is1 = add i32 %sum2, %v1
; CHECK-NEXT:    --> ({(6 + %a + %b),+,6}<%loop1> + %v1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Variant }
; CHECK-NEXT:    %phi4 = phi i32 [ %a, %loop1 ], [ %phi4.inc, %loop2 ]
; CHECK-NEXT:    --> {%a,+,1}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5 = phi i32 [ %b, %loop1 ], [ %phi5.inc, %loop2 ]
; CHECK-NEXT:    --> {%b,+,2}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
; CHECK-NEXT:    --> {43,+,3}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi4.inc = add i32 %phi4, 1
; CHECK-NEXT:    --> {(1 + %a),+,1}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi5.inc = add i32 %phi5, 2
; CHECK-NEXT:    --> {(2 + %b),+,2}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi6.inc = add i32 %phi6, 3
; CHECK-NEXT:    --> {46,+,3}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %v2 = load i32, ptr %p, align 4
; CHECK-NEXT:    --> %v2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %sum3 = add i32 %phi4, %phi5
; CHECK-NEXT:    --> {(%a + %b),+,3}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %sum4 = add i32 %sum3, %phi6
; CHECK-NEXT:    --> {(43 + %a + %b),+,6}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %is2 = add i32 %sum4, %v2
; CHECK-NEXT:    --> ({(43 + %a + %b),+,6}<%loop2> + %v2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %is3 = add i32 %v1, %sum2
; CHECK-NEXT:    --> ({(6 + %a + %b),+,6}<%loop1> + %v1) U: full-set S: full-set Exits: ({(6 + %a + %b),+,6}<%loop1> + %v1) LoopDispositions: { %loop2: Invariant }
; CHECK-NEXT:    %ec2 = add i32 %is1, %is3
; CHECK-NEXT:    --> (2 * ({(6 + %a + %b),+,6}<%loop1> + %v1)) U: [0,-1) S: [-2147483648,2147483647) Exits: (2 * ({(6 + %a + %b),+,6}<%loop1> + %v1)) LoopDispositions: { %loop2: Invariant }
; CHECK-NEXT:    %s1 = add i32 %phi1, %is1
; CHECK-NEXT:    --> ({(6 + (2 * %a) + %b),+,7}<%loop1> + %v1) U: full-set S: full-set
; CHECK-NEXT:    %s2 = add i32 %is2, %phi4
; CHECK-NEXT:    --> ({(43 + (2 * %a) + %b),+,7}<%loop2> + %v2) U: full-set S: full-set
; CHECK-NEXT:    %s3 = add i32 %is1, %phi5
; CHECK-NEXT:    --> {({(6 + (2 * %b) + %a),+,6}<%loop1> + %v1),+,2}<%loop2> U: full-set S: full-set
; CHECK-NEXT:    %s4 = add i32 %phi2, %is2
; CHECK-NEXT:    --> ({{\{\{}}(43 + (2 * %b) + %a),+,2}<%loop1>,+,6}<%loop2> + %v2) U: full-set S: full-set
; CHECK-NEXT:    %s5 = add i32 %is1, %is2
; CHECK-NEXT:    --> ({({(49 + (2 * %a) + (2 * %b)),+,6}<%loop1> + %v1),+,6}<%loop2> + %v2) U: full-set S: full-set
; CHECK-NEXT:    %s6 = add i32 %is2, %is1
; CHECK-NEXT:    --> ({({(49 + (2 * %a) + (2 * %b)),+,6}<%loop1> + %v1),+,6}<%loop2> + %v2) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test_02
; CHECK-NEXT:  Loop %loop2: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop2: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop2: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop1: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop1: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop1: Unpredictable symbolic max backedge-taken count.
;

entry:
  br label %loop1

loop1:
  %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
  %phi2 = phi i32 [ %b, %entry ], [ %phi2.inc, %loop1 ]
  %phi3 = phi i32 [ 6, %entry ], [ %phi3.inc, %loop1 ]
  %phi1.inc = add i32 %phi1, 1
  %phi2.inc = add i32 %phi2, 2
  %phi3.inc = add i32 %phi3, 3
  %v1 = load i32, ptr %p
  %sum1 = add i32 %phi1, %phi2
  %sum2 = add i32 %sum1, %phi3
  %is1 = add i32 %sum2, %v1
  %cond1 = icmp ult i32 %is1, 1000
  br i1 %cond1, label %loop1, label %loop2

loop2:
  %phi4 = phi i32 [ %a, %loop1 ], [ %phi4.inc, %loop2 ]
  %phi5 = phi i32 [ %b, %loop1 ], [ %phi5.inc, %loop2 ]
  %phi6 = phi i32 [ 43, %loop1 ], [ %phi6.inc, %loop2 ]
  %phi4.inc = add i32 %phi4, 1
  %phi5.inc = add i32 %phi5, 2
  %phi6.inc = add i32 %phi6, 3
  %v2 = load i32, ptr %p
  %sum3 = add i32 %phi4, %phi5
  %sum4 = add i32 %sum3, %phi6
  %is2 = add i32 %sum4, %v2
  %is3 = add i32 %v1, %sum2
  %ec2 = add i32 %is1, %is3
  %cond2 = icmp ult i32 %ec2, 1000
  br i1 %cond2, label %loop2, label %exit

exit:
  %s1 = add i32 %phi1, %is1
  %s2 = add i32 %is2, %phi4
  %s3 = add i32 %is1, %phi5
  %s4 = add i32 %phi2, %is2
  %s5 = add i32 %is1, %is2
  %s6 = add i32 %is2, %is1
  ret void
}

; Mix of previous use cases that demonstrates %s3 can be incorrectly treated as
; a recurrence of loop1 because of operands order if we pick recurrencies in an
; incorrect order. It also shows that we cannot safely fold v1 (SCEVUnknown)
; because we cannot prove for sure that it doesn't use Phis of loop 2.

define void @test_03(i32 %a, i32 %b, i32 %c, ptr %p) {
; CHECK-LABEL: 'test_03'
; CHECK-NEXT:  Classifying expressions for: @test_03
; CHECK-NEXT:    %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
; CHECK-NEXT:    --> {%a,+,1}<%loop1> U: full-set S: full-set Exits: (%a umax %c) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {(1 + %a),+,1}<%loop1> U: full-set S: full-set Exits: (1 + (%a umax %c)) LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %phi2 = phi i32 [ %a, %loop1 ], [ %phi2.inc, %loop2 ]
; CHECK-NEXT:    --> {%a,+,2}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {(2 + %a),+,2}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %v1 = load i32, ptr %p, align 4
; CHECK-NEXT:    --> %v1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %s1 = add i32 %phi1, %v1
; CHECK-NEXT:    --> ({%a,+,1}<%loop1> + %v1) U: full-set S: full-set --> ((%a umax %c) + %v1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %s2 = add i32 %s1, %b
; CHECK-NEXT:    --> ({(%a + %b),+,1}<%loop1> + %v1) U: full-set S: full-set --> ((%a umax %c) + %b + %v1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %s3 = add i32 %s2, %phi2
; CHECK-NEXT:    --> ({{\{\{}}((2 * %a) + %b),+,1}<%loop1>,+,2}<%loop2> + %v1) U: full-set S: full-set --> ({((%a umax %c) + %a + %b),+,2}<%loop2> + %v1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_03
; CHECK-NEXT:  Loop %loop2: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop2: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop2: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop1: backedge-taken count is ((-1 * %a) + (%a umax %c))
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i32 -1
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is ((-1 * %a) + (%a umax %c))
; CHECK-NEXT:  Loop %loop1: Trip multiple is 1
;

entry:
  br label %loop1

loop1:
  %phi1 = phi i32 [ %a, %entry ], [ %phi1.inc, %loop1 ]
  %phi1.inc = add i32 %phi1, 1
  %cond1 = icmp ult i32 %phi1, %c
  br i1 %cond1, label %loop1, label %loop2

loop2:
  %phi2 = phi i32 [ %a, %loop1 ], [ %phi2.inc, %loop2 ]
  %phi2.inc = add i32 %phi2, 2
  %v1 = load i32, ptr %p
  %s1 = add i32 %phi1, %v1
  %s2 = add i32 %s1, %b
  %s3 = add i32 %s2, %phi2
  %cond2 = icmp ult i32 %s3, %c
  br i1 %cond2, label %loop2, label %exit

exit:

  ret void
}

; Another mix of previous use cases that demonstrates that incorrect picking of
; a loop for a recurrence may cause a crash of SCEV analysis.
define void @test_04(i1 %arg) {
; CHECK-LABEL: 'test_04'
; CHECK-NEXT:  Classifying expressions for: @test_04
; CHECK-NEXT:    %tmp = phi i64 [ 2, %bb ], [ %tmp4, %bb3 ]
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%loop1> U: [2,-9223372036854775808) S: [2,-9223372036854775808) Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %tmp2 = trunc i64 %tmp to i32
; CHECK-NEXT:    --> {2,+,1}<%loop1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %tmp4 = add nuw nsw i64 %tmp, 1
; CHECK-NEXT:    --> {3,+,1}<nuw><%loop1> U: [3,0) S: [3,0) Exits: <<Unknown>> LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %tmp7 = phi i64 [ %tmp15, %loop2 ], [ 2, %loop1 ]
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%loop2> U: [2,9223372036854775807) S: [2,9223372036854775807) Exits: (-1 + (3 smax {2,+,1}<nuw><nsw><%loop1>))<nsw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %tmp8 = load i8, ptr addrspace(1) undef, align 1
; CHECK-NEXT:    --> %tmp8 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp9 = sext i8 %tmp8 to i64
; CHECK-NEXT:    --> (sext i8 %tmp8 to i64) U: [-128,128) S: [-128,128) Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp10 = sub i64 %tmp9, %tmp7
; CHECK-NEXT:    --> ((sext i8 %tmp8 to i64) + {-2,+,-1}<nsw><%loop2>) U: [9223372036854775682,126) S: [9223372036854775682,126) Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp11 = add i64 %tmp10, undef
; CHECK-NEXT:    --> ((sext i8 %tmp8 to i64) + {(-2 + undef),+,-1}<nw><%loop2>) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp13 = trunc i64 %tmp11 to i32
; CHECK-NEXT:    --> ((sext i8 %tmp8 to i32) + {(-2 + (trunc i64 undef to i32)),+,-1}<%loop2>) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp14 = sub i32 %tmp13, %tmp2
; CHECK-NEXT:    --> ((sext i8 %tmp8 to i32) + {{\{\{}}(-4 + (trunc i64 undef to i32)),+,-1}<%loop1>,+,-1}<%loop2>) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant }
; CHECK-NEXT:    %tmp15 = add nuw nsw i64 %tmp7, 1
; CHECK-NEXT:    --> {3,+,1}<nuw><nsw><%loop2> U: [3,-9223372036854775808) S: [3,-9223372036854775808) Exits: (3 smax {2,+,1}<nuw><nsw><%loop1>) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_04
; CHECK-NEXT:  Loop %loop2: backedge-taken count is (-3 + (3 smax {2,+,1}<nuw><nsw><%loop1>))<nsw>
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i64 9223372036854775804
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is (-3 + (3 smax {2,+,1}<nuw><nsw><%loop1>))<nsw>
; CHECK-NEXT:  Loop %loop2: Trip multiple is 1
; CHECK-NEXT:  Loop %loop1: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop1: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop1: Unpredictable symbolic max backedge-taken count.
;
; `{{[{][{]}}` is the ugliness needed to match `{{`

bb:
  br label %loop1

loop1:
  %tmp = phi i64 [ 2, %bb ], [ %tmp4, %bb3 ]
  %tmp2 = trunc i64 %tmp to i32
  br i1 %arg, label %loop2, label %bb3

bb3:
  %tmp4 = add nuw nsw i64 %tmp, 1
  br label %loop1

bb5:
  ret void

loop2:
  %tmp7 = phi i64 [ %tmp15, %loop2 ], [ 2, %loop1 ]
  %tmp8 = load i8, ptr addrspace(1) undef, align 1
  %tmp9 = sext i8 %tmp8 to i64
  %tmp10 = sub i64 %tmp9, %tmp7
  %tmp11 = add i64 %tmp10, undef
  %tmp13 = trunc i64 %tmp11 to i32
  %tmp14 = sub i32 %tmp13, %tmp2
  %tmp15 = add nuw nsw i64 %tmp7, 1
  %tmp16 = icmp slt i64 %tmp15, %tmp
  br i1 %tmp16, label %loop2, label %bb5
}

@A = weak global [1000 x i32] zeroinitializer, align 32

; Demonstrate a situation when we can add two recs with different degrees from
; the same loop.
define void @test_05(i32 %N) {
; CHECK-LABEL: 'test_05'
; CHECK-NEXT:  Classifying expressions for: @test_05
; CHECK-NEXT:    %"alloca point" = bitcast i32 0 to i32
; CHECK-NEXT:    --> 0 U: [0,1) S: [0,1)
; CHECK-NEXT:    %tmp = getelementptr [1000 x i32], ptr @A, i32 0, i32 %i.0
; CHECK-NEXT:    --> {(8 + @A)<nuw><nsw>,+,4}<nw><%bb3> U: [40,-3623) S: [-9223372036854775808,9223372036854775805) Exits: (408 + @A)<nuw> LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:    %tmp2 = add i32 %i.0, 1
; CHECK-NEXT:    --> {3,+,1}<nuw><nsw><%bb3> U: [3,104) S: [3,104) Exits: 103 LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:    %i.0 = phi i32 [ 2, %entry ], [ %tmp2, %bb ]
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%bb3> U: [2,103) S: [2,103) Exits: 102 LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:    %SQ = mul i32 %i.0, %i.0
; CHECK-NEXT:    --> {4,+,5,+,2}<%bb3> U: full-set S: full-set Exits: 10404 LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:    %tmp4 = mul i32 %i.0, 2
; CHECK-NEXT:    --> {4,+,2}<nuw><nsw><%bb3> U: [4,205) S: [4,205) Exits: 204 LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:    %tmp5 = sub i32 %SQ, %tmp4
; CHECK-NEXT:    --> {0,+,3,+,2}<%bb3> U: full-set S: full-set Exits: 10200 LoopDispositions: { %bb3: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_05
; CHECK-NEXT:  Loop %bb3: backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb3: constant max backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb3: symbolic max backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb3: Trip multiple is 101
;

entry:
        %"alloca point" = bitcast i32 0 to i32           ; <i32> [#uses=0]
        br label %bb3

bb:             ; preds = %bb3
        %tmp = getelementptr [1000 x i32], ptr @A, i32 0, i32 %i.0          ; <ptr> [#uses=1]
        store i32 123, ptr %tmp
        %tmp2 = add i32 %i.0, 1         ; <i32> [#uses=1]
        br label %bb3

bb3:            ; preds = %bb, %entry
        %i.0 = phi i32 [ 2, %entry ], [ %tmp2, %bb ]            ; <i32> [#uses=3]
        %SQ = mul i32 %i.0, %i.0
        %tmp4 = mul i32 %i.0, 2
        %tmp5 = sub i32 %SQ, %tmp4
        %tmp3 = icmp sle i32 %tmp5, 9999          ; <i1> [#uses=1]
        br i1 %tmp3, label %bb, label %bb5

bb5:            ; preds = %bb3
        br label %return

return:         ; preds = %bb5
        ret void
}

; Check that we can add Phis from different loops with different nesting, nested
; loop comes first.
define void @test_06() {
; CHECK-LABEL: 'test_06'
; CHECK-NEXT:  Classifying expressions for: @test_06
; CHECK-NEXT:    %phi1 = phi i32 [ 10, %entry ], [ %phi1.inc, %loop1.exit ]
; CHECK-NEXT:    --> {10,+,1}<nuw><nsw><%loop1> U: [10,1000) S: [10,1000) Exits: 999 LoopDispositions: { %loop1: Computable, %loop2: Invariant }
; CHECK-NEXT:    %phi2 = phi i32 [ 20, %loop1 ], [ %phi2.inc, %loop2 ]
; CHECK-NEXT:    --> {20,+,2}<nuw><nsw><%loop2> U: [20,999) S: [20,999) Exits: 998 LoopDispositions: { %loop2: Computable, %loop1: Variant }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {22,+,2}<nuw><nsw><%loop2> U: [22,1001) S: [22,1001) Exits: 1000 LoopDispositions: { %loop2: Computable, %loop1: Variant }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {11,+,1}<nuw><nsw><%loop1> U: [11,1001) S: [11,1001) Exits: 1000 LoopDispositions: { %loop1: Computable, %loop2: Invariant }
; CHECK-NEXT:    %phi3 = phi i32 [ 30, %loop1.exit ], [ %phi3.inc, %loop3 ]
; CHECK-NEXT:    --> {30,+,3}<nuw><nsw><%loop3> U: [30,1000) S: [30,1000) Exits: 999 LoopDispositions: { %loop3: Computable }
; CHECK-NEXT:    %phi3.inc = add i32 %phi3, 3
; CHECK-NEXT:    --> {33,+,3}<nuw><nsw><%loop3> U: [33,1003) S: [33,1003) Exits: 1002 LoopDispositions: { %loop3: Computable }
; CHECK-NEXT:    %s1 = add i32 %phi1, %phi2
; CHECK-NEXT:    --> {{\{\{}}30,+,1}<nuw><nsw><%loop1>,+,2}<nw><%loop2> U: [30,1998) S: [30,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:    %s2 = add i32 %phi2, %phi1
; CHECK-NEXT:    --> {{\{\{}}30,+,1}<nuw><nsw><%loop1>,+,2}<nw><%loop2> U: [30,1998) S: [30,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:    %s3 = add i32 %phi1, %phi3
; CHECK-NEXT:    --> {{\{\{}}40,+,1}<nuw><nsw><%loop1>,+,3}<nw><%loop3> U: [40,1999) S: [40,1999) --> 1998 U: [1998,1999) S: [1998,1999)
; CHECK-NEXT:    %s4 = add i32 %phi3, %phi1
; CHECK-NEXT:    --> {{\{\{}}40,+,1}<nuw><nsw><%loop1>,+,3}<nw><%loop3> U: [40,1999) S: [40,1999) --> 1998 U: [1998,1999) S: [1998,1999)
; CHECK-NEXT:    %s5 = add i32 %phi2, %phi3
; CHECK-NEXT:    --> {{\{\{}}50,+,2}<nuw><nsw><%loop2>,+,3}<nw><%loop3> U: [50,1998) S: [50,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:    %s6 = add i32 %phi3, %phi2
; CHECK-NEXT:    --> {{\{\{}}50,+,2}<nuw><nsw><%loop2>,+,3}<nw><%loop3> U: [50,1998) S: [50,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:  Determining loop execution counts for: @test_06
; CHECK-NEXT:  Loop %loop3: backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: constant max backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: symbolic max backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: Trip multiple is 324
; CHECK-NEXT:  Loop %loop2: backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: Trip multiple is 490
; CHECK-NEXT:  Loop %loop1: backedge-taken count is i32 989
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i32 989
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is i32 989
; CHECK-NEXT:  Loop %loop1: Trip multiple is 990
;

entry:
  br label %loop1

loop1:
  %phi1 = phi i32 [ 10, %entry ], [ %phi1.inc, %loop1.exit ]
  br label %loop2

loop2:
  %phi2 = phi i32 [ 20, %loop1 ], [ %phi2.inc, %loop2 ]
  %phi2.inc = add i32 %phi2, 2
  %cond2 = icmp ult i32 %phi2.inc, 1000
  br i1 %cond2, label %loop2, label %loop1.exit

loop1.exit:
  %phi1.inc = add i32 %phi1, 1
  %cond1 = icmp ult i32 %phi1.inc, 1000
  br i1 %cond1, label %loop1, label %loop3

loop3:
  %phi3 = phi i32 [ 30, %loop1.exit ], [ %phi3.inc, %loop3 ]
  %phi3.inc = add i32 %phi3, 3
  %cond3 = icmp ult i32 %phi3.inc, 1000
  br i1 %cond3, label %loop3, label %exit

exit:
  %s1 = add i32 %phi1, %phi2
  %s2 = add i32 %phi2, %phi1
  %s3 = add i32 %phi1, %phi3
  %s4 = add i32 %phi3, %phi1
  %s5 = add i32 %phi2, %phi3
  %s6 = add i32 %phi3, %phi2
  ret void
}

; Check that we can add Phis from different loops with different nesting, nested
; loop comes second.
define void @test_07() {
; CHECK-LABEL: 'test_07'
; CHECK-NEXT:  Classifying expressions for: @test_07
; CHECK-NEXT:    %phi3 = phi i32 [ 30, %entry ], [ %phi3.inc, %loop3 ]
; CHECK-NEXT:    --> {30,+,3}<nuw><nsw><%loop3> U: [30,1000) S: [30,1000) Exits: 999 LoopDispositions: { %loop3: Computable }
; CHECK-NEXT:    %phi3.inc = add i32 %phi3, 3
; CHECK-NEXT:    --> {33,+,3}<nuw><nsw><%loop3> U: [33,1003) S: [33,1003) Exits: 1002 LoopDispositions: { %loop3: Computable }
; CHECK-NEXT:    %phi1 = phi i32 [ 10, %loop3 ], [ %phi1.inc, %loop1.exit ]
; CHECK-NEXT:    --> {10,+,1}<nuw><nsw><%loop1> U: [10,11) S: [10,11) Exits: 10 LoopDispositions: { %loop1: Computable, %loop2: Invariant }
; CHECK-NEXT:    %phi2 = phi i32 [ 20, %loop1 ], [ %phi2.inc, %loop2 ]
; CHECK-NEXT:    --> {20,+,2}<nuw><nsw><%loop2> U: [20,999) S: [20,999) Exits: 998 LoopDispositions: { %loop2: Computable, %loop1: Variant }
; CHECK-NEXT:    %phi2.inc = add i32 %phi2, 2
; CHECK-NEXT:    --> {22,+,2}<nuw><nsw><%loop2> U: [22,1001) S: [22,1001) Exits: 1000 LoopDispositions: { %loop2: Computable, %loop1: Variant }
; CHECK-NEXT:    %phi1.inc = add i32 %phi1, 1
; CHECK-NEXT:    --> {11,+,1}<nuw><nsw><%loop1> U: [11,12) S: [11,12) Exits: 11 LoopDispositions: { %loop1: Computable, %loop2: Invariant }
; CHECK-NEXT:    %s1 = add i32 %phi1, %phi2
; CHECK-NEXT:    --> {{\{\{}}30,+,1}<nuw><nsw><%loop1>,+,2}<nw><%loop2> U: [30,1009) S: [30,1009) --> 1008 U: [1008,1009) S: [1008,1009)
; CHECK-NEXT:    %s2 = add i32 %phi2, %phi1
; CHECK-NEXT:    --> {{\{\{}}30,+,1}<nuw><nsw><%loop1>,+,2}<nw><%loop2> U: [30,1009) S: [30,1009) --> 1008 U: [1008,1009) S: [1008,1009)
; CHECK-NEXT:    %s3 = add i32 %phi1, %phi3
; CHECK-NEXT:    --> {{\{\{}}40,+,3}<nuw><nsw><%loop3>,+,1}<nw><%loop1> U: [40,1010) S: [40,1010) --> 1009 U: [1009,1010) S: [1009,1010)
; CHECK-NEXT:    %s4 = add i32 %phi3, %phi1
; CHECK-NEXT:    --> {{\{\{}}40,+,3}<nuw><nsw><%loop3>,+,1}<nw><%loop1> U: [40,1010) S: [40,1010) --> 1009 U: [1009,1010) S: [1009,1010)
; CHECK-NEXT:    %s5 = add i32 %phi2, %phi3
; CHECK-NEXT:    --> {{\{\{}}50,+,3}<nuw><nsw><%loop3>,+,2}<nw><%loop2> U: [50,1998) S: [50,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:    %s6 = add i32 %phi3, %phi2
; CHECK-NEXT:    --> {{\{\{}}50,+,3}<nuw><nsw><%loop3>,+,2}<nw><%loop2> U: [50,1998) S: [50,1998) --> 1997 U: [1997,1998) S: [1997,1998)
; CHECK-NEXT:  Determining loop execution counts for: @test_07
; CHECK-NEXT:  Loop %loop2: backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is i32 489
; CHECK-NEXT:  Loop %loop2: Trip multiple is 490
; CHECK-NEXT:  Loop %loop1: backedge-taken count is i32 0
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i32 0
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is i32 0
; CHECK-NEXT:  Loop %loop1: Trip multiple is 1
; CHECK-NEXT:  Loop %loop3: backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: constant max backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: symbolic max backedge-taken count is i32 323
; CHECK-NEXT:  Loop %loop3: Trip multiple is 324
;

entry:
  br label %loop3

loop3:
  %phi3 = phi i32 [ 30, %entry ], [ %phi3.inc, %loop3 ]
  %phi3.inc = add i32 %phi3, 3
  %cond3 = icmp ult i32 %phi3.inc, 1000
  br i1 %cond3, label %loop3, label %loop1

loop1:
  %phi1 = phi i32 [ 10, %loop3 ], [ %phi1.inc, %loop1.exit ]
  br label %loop2

loop2:
  %phi2 = phi i32 [ 20, %loop1 ], [ %phi2.inc, %loop2 ]
  %phi2.inc = add i32 %phi2, 2
  %cond2 = icmp ult i32 %phi2.inc, 1000
  br i1 %cond2, label %loop2, label %loop1.exit

loop1.exit:
  %phi1.inc = add i32 %phi1, 1
  %cond1 = icmp ult i32 %phi1.inc, 1000
  br i1 %cond1, label %exit, label %loop1

exit:
  %s1 = add i32 %phi1, %phi2
  %s2 = add i32 %phi2, %phi1
  %s3 = add i32 %phi1, %phi3
  %s4 = add i32 %phi3, %phi1
  %s5 = add i32 %phi2, %phi3
  %s6 = add i32 %phi3, %phi2
  ret void
}

; Make sure that a complicated Phi does not get folded with rec's start value
; of a loop which is above.
define void @test_08() {
; CHECK-LABEL: 'test_08'
; CHECK-NEXT:  Classifying expressions for: @test_08
; CHECK-NEXT:    %iv.1.1 = phi i64 [ 2, %entry ], [ %iv.1.1.next, %loop_1_back_branch ]
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%loop_1> U: [2,4) S: [2,4) Exits: 3 LoopDispositions: { %loop_1: Computable }
; CHECK-NEXT:    %iv.1.2 = phi i32 [ -1, %entry ], [ %iv.1.2.next, %loop_1_back_branch ]
; CHECK-NEXT:    --> {-1,+,1}<nsw><%loop_1> U: [-1,1) S: [-1,1) Exits: 0 LoopDispositions: { %loop_1: Computable }
; CHECK-NEXT:    %iv.1.1.next = add nuw nsw i64 %iv.1.1, 1
; CHECK-NEXT:    --> {3,+,1}<nuw><nsw><%loop_1> U: [3,5) S: [3,5) Exits: 4 LoopDispositions: { %loop_1: Computable }
; CHECK-NEXT:    %iv.1.2.next = add nsw i32 %iv.1.2, 1
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop_1> U: [0,2) S: [0,2) Exits: 1 LoopDispositions: { %loop_1: Computable }
; CHECK-NEXT:    %tmp6 = sub i64 1, %iv.1.1
; CHECK-NEXT:    --> {-1,+,-1}<nsw><%loop_1> U: [-2,0) S: [-2,0) --> -2 U: [-2,-1) S: [-2,-1)
; CHECK-NEXT:    %tmp7 = trunc i64 %tmp6 to i32
; CHECK-NEXT:    --> {-1,+,-1}<%loop_1> U: [-2,0) S: [-2,0) --> -2 U: [-2,-1) S: [-2,-1)
; CHECK-NEXT:    %iv.2.1 = phi i64 [ 0, %loop_2_preheader ], [ %tmp16, %loop_2 ]
; CHECK-NEXT:    --> %iv.2.1 U: full-set S: full-set Exits: 0 LoopDispositions: { %loop_2: Variant }
; CHECK-NEXT:    %iv.2.2 = phi i64 [ 0, %loop_2_preheader ], [ %iv.2.2.next, %loop_2 ]
; CHECK-NEXT:    --> {0,+,-1}<nuw><nsw><%loop_2> U: [0,1) S: [0,1) Exits: 0 LoopDispositions: { %loop_2: Computable }
; CHECK-NEXT:    %iv.2.3 = phi i64 [ 2, %loop_2_preheader ], [ %iv.2.3.next, %loop_2 ]
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%loop_2> U: [2,3) S: [2,3) Exits: 2 LoopDispositions: { %loop_2: Computable }
; CHECK-NEXT:    %tmp11 = add i64 %iv.2.2, %iv.2.1
; CHECK-NEXT:    --> ({0,+,-1}<nuw><nsw><%loop_2> + %iv.2.1) U: full-set S: full-set Exits: 0 LoopDispositions: { %loop_2: Variant }
; CHECK-NEXT:    %tmp12 = trunc i64 %tmp11 to i32
; CHECK-NEXT:    --> ((trunc i64 %iv.2.1 to i32) + {0,+,-1}<%loop_2>) U: full-set S: full-set Exits: 0 LoopDispositions: { %loop_2: Variant }
; CHECK-NEXT:    %tmp14 = mul i32 %tmp12, %tmp7
; CHECK-NEXT:    --> (((trunc i64 %iv.2.1 to i32) + {0,+,-1}<%loop_2>) * {-1,+,-1}<%loop_1>) U: full-set S: full-set --> (-2 * ((trunc i64 %iv.2.1 to i32) + {0,+,-1}<%loop_2>)) U: [0,-1) S: [-2147483648,2147483647) Exits: 0 LoopDispositions: { %loop_2: Variant }
; CHECK-NEXT:    %tmp16 = mul i64 %iv.2.1, %iv.1.1
; CHECK-NEXT:    --> ({2,+,1}<nuw><nsw><%loop_1> * %iv.2.1) U: full-set S: full-set --> (3 * %iv.2.1) U: full-set S: full-set Exits: 0 LoopDispositions: { %loop_2: Variant }
; CHECK-NEXT:    %iv.2.3.next = add nuw nsw i64 %iv.2.3, 1
; CHECK-NEXT:    --> {3,+,1}<nuw><nsw><%loop_2> U: [3,4) S: [3,4) Exits: 3 LoopDispositions: { %loop_2: Computable }
; CHECK-NEXT:    %iv.2.2.next = add nsw i64 %iv.2.2, -1
; CHECK-NEXT:    --> {-1,+,-1}<nuw><nsw><%loop_2> U: [-1,0) S: [-1,0) Exits: -1 LoopDispositions: { %loop_2: Computable }
; CHECK-NEXT:    %tmp10 = add i32 %iv.1.2, 3
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%loop_1> U: [2,4) S: [2,4) --> 3 U: [3,4) S: [3,4)
; CHECK-NEXT:  Determining loop execution counts for: @test_08
; CHECK-NEXT:  Loop %loop_2: backedge-taken count is i64 0
; CHECK-NEXT:  Loop %loop_2: constant max backedge-taken count is i64 0
; CHECK-NEXT:  Loop %loop_2: symbolic max backedge-taken count is i64 0
; CHECK-NEXT:  Loop %loop_2: Trip multiple is 1
; CHECK-NEXT:  Loop %loop_1: backedge-taken count is i64 1
; CHECK-NEXT:  Loop %loop_1: constant max backedge-taken count is i64 1
; CHECK-NEXT:  Loop %loop_1: symbolic max backedge-taken count is i64 1
; CHECK-NEXT:  Loop %loop_1: Trip multiple is 2
;

entry:
  br label %loop_1

loop_1:
  %iv.1.1 = phi i64 [ 2, %entry ], [ %iv.1.1.next, %loop_1_back_branch ]
  %iv.1.2 = phi i32 [ -1, %entry ], [ %iv.1.2.next, %loop_1_back_branch ]
  br label %loop_1_exit

dead:
  br label %loop_1_exit

loop_1_exit:
  %tmp5 = icmp sgt i64 %iv.1.1, 2
  br i1 %tmp5, label %loop_2_preheader, label %loop_1_back_branch

loop_1_back_branch:
  %iv.1.1.next = add nuw nsw i64 %iv.1.1, 1
  %iv.1.2.next = add nsw i32 %iv.1.2, 1
  br label %loop_1

loop_2_preheader:
  %tmp6 = sub i64 1, %iv.1.1
  %tmp7 = trunc i64 %tmp6 to i32
  br label %loop_2

loop_2:
  %iv.2.1 = phi i64 [ 0, %loop_2_preheader ], [ %tmp16, %loop_2 ]
  %iv.2.2 = phi i64 [ 0, %loop_2_preheader ], [ %iv.2.2.next, %loop_2 ]
  %iv.2.3 = phi i64 [ 2, %loop_2_preheader ], [ %iv.2.3.next, %loop_2 ]
  %tmp11 = add i64 %iv.2.2, %iv.2.1
  %tmp12 = trunc i64 %tmp11 to i32
  %tmp14 = mul i32 %tmp12, %tmp7
  %tmp16 = mul i64 %iv.2.1, %iv.1.1
  %iv.2.3.next = add nuw nsw i64 %iv.2.3, 1
  %iv.2.2.next = add nsw i64 %iv.2.2, -1
  %tmp17 = icmp slt i64 %iv.2.3.next, %iv.1.1
  br i1 %tmp17, label %loop_2, label %exit

exit:
  %tmp10 = add i32 %iv.1.2, 3
  ret void
}

define i64 @test_09(i32 %param) {
; CHECK-LABEL: 'test_09'
; CHECK-NEXT:  Classifying expressions for: @test_09
; CHECK-NEXT:    %iv1 = phi i64 [ %iv1.next, %guarded ], [ 0, %outer.loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop1> U: [0,3) S: [0,3) Exits: 2 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %iv1.trunc = trunc i64 %iv1 to i32
; CHECK-NEXT:    --> {0,+,1}<%loop1> U: [0,3) S: [0,3) Exits: 2 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %iv1.next = add nuw nsw i64 %iv1, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop1> U: [1,4) S: [1,4) Exits: 3 LoopDispositions: { %loop1: Computable }
; CHECK-NEXT:    %iv2 = phi i32 [ %iv2.next, %loop2 ], [ %param, %loop2.preheader ]
; CHECK-NEXT:    --> {%param,+,1}<%loop2> U: full-set S: full-set Exits: (2 smax %param) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %iv2.next = add i32 %iv2, 1
; CHECK-NEXT:    --> {(1 + %param),+,1}<%loop2> U: full-set S: full-set Exits: (1 + (2 smax %param))<nuw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %iv2.ext = sext i32 %iv2.next to i64
; CHECK-NEXT:    --> (sext i32 {(1 + %param),+,1}<%loop2> to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) --> (sext i32 (1 + (2 smax %param))<nuw> to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %ret = mul i64 %iv1, %iv2.ext
; CHECK-NEXT:    --> ((sext i32 {(1 + %param),+,1}<%loop2> to i64) * {0,+,1}<nuw><nsw><%loop1>) U: [-4294967296,4294967295) S: [-4294967296,4294967295) --> (2 * (sext i32 (1 + (2 smax %param))<nuw> to i64))<nsw> U: [0,-1) S: [-4294967296,4294967295)
; CHECK-NEXT:  Determining loop execution counts for: @test_09
; CHECK-NEXT:  Loop %loop2: backedge-taken count is ((-1 * %param) + (2 smax %param))
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 -2147483646
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is ((-1 * %param) + (2 smax %param))
; CHECK-NEXT:  Loop %loop2: Trip multiple is 1
; CHECK-NEXT:  Loop %loop1: <multiple exits> backedge-taken count is i64 2
; CHECK-NEXT:    exit count for loop1: i64 100
; CHECK-NEXT:    exit count for guarded: i32 2
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i64 2
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is i64 2
; CHECK-NEXT:    symbolic max exit count for loop1: i64 100
; CHECK-NEXT:    symbolic max exit count for guarded: i32 2
; CHECK-NEXT:  Loop %loop1: Trip multiple is 1
;

entry:
  br label %outer.loop

outer.loop:                                 ; preds = %loop2.exit, %entry
  br label %loop1

loop1:                                           ; preds = %guarded, %outer.loop
  %iv1 = phi i64 [ %iv1.next, %guarded ], [ 0, %outer.loop ]
  %iv1.trunc = trunc i64 %iv1 to i32
  %cond1 = icmp ult i64 %iv1, 100
  br i1 %cond1, label %guarded, label %deopt

guarded:                                          ; preds = %loop1
  %iv1.next = add nuw nsw i64 %iv1, 1
  %tmp16 = icmp slt i32 %iv1.trunc, 2
  br i1 %tmp16, label %loop1, label %loop2.preheader

deopt:                                            ; preds = %loop1
  unreachable

loop2.preheader:                                 ; preds = %guarded
  br label %loop2

loop2:                                           ; preds = %loop2, %loop2.preheader
  %iv2 = phi i32 [ %iv2.next, %loop2 ], [ %param, %loop2.preheader ]
  %iv2.next = add i32 %iv2, 1
  %cond2 = icmp slt i32 %iv2, %iv1.trunc
  br i1 %cond2, label %loop2, label %exit

exit:                                          ; preds = %loop2.exit
  %iv2.ext = sext i32 %iv2.next to i64
  %ret = mul i64 %iv1, %iv2.ext
  ret i64 %ret
}

define i64 @test_10(i32 %param) {
; CHECK-LABEL: 'test_10'
; CHECK-NEXT:  Classifying expressions for: @test_10
; CHECK-NEXT:    %uncle = phi i64 [ %uncle.outer.next, %uncle.loop.backedge ], [ 0, %outer.loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%uncle.loop> U: [0,1) S: [0,1) Exits: <<Unknown>> LoopDispositions: { %uncle.loop: Computable, %loop1: Invariant }
; CHECK-NEXT:    %iv1 = phi i64 [ %iv1.next, %guarded ], [ 0, %uncle.loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop1> U: [0,3) S: [0,3) Exits: 2 LoopDispositions: { %loop1: Computable, %uncle.loop: Variant }
; CHECK-NEXT:    %iv1.trunc = trunc i64 %iv1 to i32
; CHECK-NEXT:    --> {0,+,1}<%loop1> U: [0,3) S: [0,3) Exits: 2 LoopDispositions: { %loop1: Computable, %uncle.loop: Variant }
; CHECK-NEXT:    %iv1.next = add nuw nsw i64 %iv1, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop1> U: [1,4) S: [1,4) Exits: 3 LoopDispositions: { %loop1: Computable, %uncle.loop: Variant }
; CHECK-NEXT:    %uncle.outer.next = add i64 %uncle, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%uncle.loop> U: [1,2) S: [1,2) Exits: <<Unknown>> LoopDispositions: { %uncle.loop: Computable, %loop1: Invariant }
; CHECK-NEXT:    %iv2 = phi i32 [ %iv2.next, %loop2 ], [ %param, %loop2.preheader ]
; CHECK-NEXT:    --> {%param,+,1}<%loop2> U: full-set S: full-set Exits: (2 smax %param) LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %iv2.next = add i32 %iv2, 1
; CHECK-NEXT:    --> {(1 + %param),+,1}<%loop2> U: full-set S: full-set Exits: (1 + (2 smax %param))<nuw> LoopDispositions: { %loop2: Computable }
; CHECK-NEXT:    %iv2.ext = sext i32 %iv2.next to i64
; CHECK-NEXT:    --> (sext i32 {(1 + %param),+,1}<%loop2> to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) --> (sext i32 (1 + (2 smax %param))<nuw> to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %ret = mul i64 %iv1, %iv2.ext
; CHECK-NEXT:    --> ((sext i32 {(1 + %param),+,1}<%loop2> to i64) * {0,+,1}<nuw><nsw><%loop1>) U: [-4294967296,4294967295) S: [-4294967296,4294967295) --> (2 * (sext i32 (1 + (2 smax %param))<nuw> to i64))<nsw> U: [0,-1) S: [-4294967296,4294967295)
; CHECK-NEXT:  Determining loop execution counts for: @test_10
; CHECK-NEXT:  Loop %loop2: backedge-taken count is ((-1 * %param) + (2 smax %param))
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 -2147483646
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is ((-1 * %param) + (2 smax %param))
; CHECK-NEXT:  Loop %loop2: Trip multiple is 1
; CHECK-NEXT:  Loop %loop1: <multiple exits> backedge-taken count is i64 2
; CHECK-NEXT:    exit count for loop1: i64 100
; CHECK-NEXT:    exit count for guarded: i32 2
; CHECK-NEXT:  Loop %loop1: constant max backedge-taken count is i64 2
; CHECK-NEXT:  Loop %loop1: symbolic max backedge-taken count is i64 2
; CHECK-NEXT:    symbolic max exit count for loop1: i64 100
; CHECK-NEXT:    symbolic max exit count for guarded: i32 2
; CHECK-NEXT:  Loop %loop1: Trip multiple is 1
; CHECK-NEXT:  Loop %uncle.loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop1: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for uncle.loop.backedge: i64 0
; CHECK-NEXT:  Loop %uncle.loop: constant max backedge-taken count is i64 0
; CHECK-NEXT:  Loop %uncle.loop: symbolic max backedge-taken count is i64 0
; CHECK-NEXT:    symbolic max exit count for loop1: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for uncle.loop.backedge: i64 0
;

entry:
  br label %outer.loop

outer.loop:                                       ; preds = %entry
  br label %uncle.loop

uncle.loop:                                       ; preds = %uncle.loop.backedge, %outer.loop
  %uncle = phi i64 [ %uncle.outer.next, %uncle.loop.backedge ], [ 0, %outer.loop ]
  br label %loop1

loop1:                                            ; preds = %guarded, %uncle.loop
  %iv1 = phi i64 [ %iv1.next, %guarded ], [ 0, %uncle.loop ]
  %iv1.trunc = trunc i64 %iv1 to i32
  %cond1 = icmp ult i64 %iv1, 100
  br i1 %cond1, label %guarded, label %deopt

guarded:                                          ; preds = %loop1
  %iv1.next = add nuw nsw i64 %iv1, 1
  %tmp16 = icmp slt i32 %iv1.trunc, 2
  br i1 %tmp16, label %loop1, label %uncle.loop.backedge

uncle.loop.backedge:                              ; preds = %guarded
  %uncle.outer.next = add i64 %uncle, 1
  %cond.uncle = icmp ult i64 %uncle, 120
  br i1 %cond.uncle, label %loop2.preheader, label %uncle.loop

deopt:                                            ; preds = %loop1
  unreachable

loop2.preheader:                                  ; preds = %uncle.loop.backedge
  br label %loop2

loop2:                                            ; preds = %loop2, %loop2.preheader
  %iv2 = phi i32 [ %iv2.next, %loop2 ], [ %param, %loop2.preheader ]
  %iv2.next = add i32 %iv2, 1
  %cond2 = icmp slt i32 %iv2, %iv1.trunc
  br i1 %cond2, label %loop2, label %exit

exit:                                             ; preds = %loop2
  %iv2.ext = sext i32 %iv2.next to i64
  %ret = mul i64 %iv1, %iv2.ext
  ret i64 %ret
}
