; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no_x86_scrub_sp --version 5
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu  | FileCheck %s
; Test for issue https://github.com/llvm/llvm-project/issues/115323

declare double @g(double, double)

; Though not visible within the IR, this will lower to an FSINCOS node, with
; store users, that are within a (callseq_start, callseq_end) pair. In this
; case, the stores cannot be folded into the sincos call.
define double @negative_sincos_with_stores_within_call_sequence(double %a) {
; CHECK-LABEL: negative_sincos_with_stores_within_call_sequence:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl $44, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    fldl 48(%esp)
; CHECK-NEXT:    leal 24(%esp), %eax
; CHECK-NEXT:    movl %eax, 12(%esp)
; CHECK-NEXT:    leal 32(%esp), %eax
; CHECK-NEXT:    movl %eax, 8(%esp)
; CHECK-NEXT:    fstpl (%esp)
; CHECK-NEXT:    calll sincos
; CHECK-NEXT:    fldl 32(%esp)
; CHECK-NEXT:    fldl 24(%esp)
; CHECK-NEXT:    faddl {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    fstpl 8(%esp)
; CHECK-NEXT:    fstpl (%esp)
; CHECK-NEXT:    calll g@PLT
; CHECK-NEXT:    addl $44, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    retl
entry:
  %0 = tail call double @llvm.sin.f64(double %a)
  %1 = tail call double @llvm.cos.f64(double %a)
  %add = fadd double %1, 3.140000e+00
  %call = tail call double @g(double %add, double %0)
  ret double %call
}
