; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+xtheadbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32XTHEADBB

declare i32 @llvm.ctlz.i32(i32, i1)

define i32 @ctlz_i32(i32 %a) nounwind {
; RV32I-LABEL: ctlz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB0_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    addi a1, a2, 1365
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    and a1, a2, a1
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    and a1, a0, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    addi a1, a2, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB0_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: ctlz_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %1
}

declare i64 @llvm.ctlz.i64(i64, i1)

define i64 @ctlz_i64(i64 %a) nounwind {
; RV32I-LABEL: ctlz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a2, 1365
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    addi a2, a5, -241
; RV32I-NEXT:    bnez a1, .LBB1_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    and a1, a0, a3
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB1_2:
; RV32I-NEXT:    srli a0, a1, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    and a1, a0, a3
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: ctlz_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a1, .LBB1_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, 32
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB1_2:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a1
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
  %1 = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %1
}

declare i32 @llvm.cttz.i32(i32, i1)

define i32 @cttz_i32(i32 %a) nounwind {
; RV32I-LABEL: cttz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    neg a1, a0
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi a1, a1, 1329
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    lui a1, %hi(.LCPI2_0)
; RV32I-NEXT:    addi a1, a1, %lo(.LCPI2_0)
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB2_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: cttz_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    beqz a0, .LBB2_2
; RV32XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB2_2:
; RV32XTHEADBB-NEXT:    li a0, 32
; RV32XTHEADBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %1
}

declare i64 @llvm.cttz.i64(i64, i1)

define i64 @cttz_i64(i64 %a) nounwind {
; RV32I-LABEL: cttz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    and a0, s0, a0
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi s3, a1, 1329
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui s4, %hi(.LCPI3_0)
; RV32I-NEXT:    addi s4, s4, %lo(.LCPI3_0)
; RV32I-NEXT:    neg a0, s2
; RV32I-NEXT:    and a0, s2, a0
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    bnez s2, .LBB3_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    beqz s0, .LBB3_4
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    srli s1, s1, 27
; RV32I-NEXT:    add s1, s4, s1
; RV32I-NEXT:    lbu a0, 0(s1)
; RV32I-NEXT:    j .LBB3_5
; RV32I-NEXT:  .LBB3_3:
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    add a0, s4, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    bnez s0, .LBB3_2
; RV32I-NEXT:  .LBB3_4:
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:  .LBB3_5:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: cttz_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a0, .LBB3_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    addi a0, a1, -1
; RV32XTHEADBB-NEXT:    not a1, a1
; RV32XTHEADBB-NEXT:    and a0, a1, a0
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 64
; RV32XTHEADBB-NEXT:    j .LBB3_3
; RV32XTHEADBB-NEXT:  .LBB3_2:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:  .LBB3_3:
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
  %1 = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %1
}

define i32 @sexti1_i32(i32 %a) nounwind {
; RV32I-LABEL: sexti1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 31
; RV32I-NEXT:    srai a0, a0, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sexti1_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 0, 0
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i32 %a, 31
  %shr = ashr exact i32 %shl, 31
  ret i32 %shr
}

define i32 @sexti1_i32_2(i1 %a) nounwind {
; RV32I-LABEL: sexti1_i32_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 31
; RV32I-NEXT:    srai a0, a0, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sexti1_i32_2:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 0, 0
; RV32XTHEADBB-NEXT:    ret
  %sext = sext i1 %a to i32
  ret i32 %sext
}

define i32 @sextb_i32(i32 %a) nounwind {
; RV32I-LABEL: sextb_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sextb_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 7, 0
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i32 %a, 24
  %shr = ashr exact i32 %shl, 24
  ret i32 %shr
}

define i64 @sextb_i64(i64 %a) nounwind {
; RV32I-LABEL: sextb_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 24
; RV32I-NEXT:    srai a0, a1, 24
; RV32I-NEXT:    srai a1, a1, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sextb_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 7, 0
; RV32XTHEADBB-NEXT:    srai a1, a0, 31
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i64 %a, 56
  %shr = ashr exact i64 %shl, 56
  ret i64 %shr
}

define i32 @sexth_i32(i32 %a) nounwind {
; RV32I-LABEL: sexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sexth_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = ashr exact i32 %shl, 16
  ret i32 %shr
}

define i32 @no_sexth_i32(i32 %a) nounwind {
; RV32I-LABEL: no_sexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 17
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: no_sexth_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    slli a0, a0, 17
; RV32XTHEADBB-NEXT:    srai a0, a0, 16
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i32 %a, 17
  %shr = ashr exact i32 %shl, 16
  ret i32 %shr
}

define i64 @sexth_i64(i64 %a) nounwind {
; RV32I-LABEL: sexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srai a0, a1, 16
; RV32I-NEXT:    srai a1, a1, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: sexth_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ext a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    srai a1, a0, 31
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i64 %a, 48
  %shr = ashr exact i64 %shl, 48
  ret i64 %shr
}

define i64 @no_sexth_i64(i64 %a) nounwind {
; RV32I-LABEL: no_sexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 17
; RV32I-NEXT:    srai a0, a1, 16
; RV32I-NEXT:    srai a1, a1, 31
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: no_sexth_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    slli a1, a0, 17
; RV32XTHEADBB-NEXT:    srai a0, a1, 16
; RV32XTHEADBB-NEXT:    srai a1, a1, 31
; RV32XTHEADBB-NEXT:    ret
  %shl = shl i64 %a, 49
  %shr = ashr exact i64 %shl, 48
  ret i64 %shr
}

define i32 @zexth_i32(i32 %a) nounwind {
; RV32I-LABEL: zexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: zexth_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    ret
  %and = and i32 %a, 65535
  ret i32 %and
}

define i64 @zexth_i64(i64 %a) nounwind {
; RV32I-LABEL: zexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: zexth_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
  %and = and i64 %a, 65535
  ret i64 %and
}

declare i32 @llvm.bswap.i32(i32)

define i32 @bswap_i32(i32 %a) nounwind {
; RV32I-LABEL: bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a2, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a2, a2, 8
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: bswap_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.rev a0, a0
; RV32XTHEADBB-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV32I-LABEL: bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 24
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    or a4, a5, a4
; RV32I-NEXT:    slli a5, a1, 24
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    and a3, a0, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a0, a3
; RV32I-NEXT:    or a0, a1, a2
; RV32I-NEXT:    or a1, a3, a4
; RV32I-NEXT:    ret
;
; RV32XTHEADBB-LABEL: bswap_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.rev a2, a1
; RV32XTHEADBB-NEXT:    th.rev a1, a0
; RV32XTHEADBB-NEXT:    mv a0, a2
; RV32XTHEADBB-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}
