/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _ABW_TEXT_GENERATOR_HXX_
#define _ABW_TEXT_GENERATOR_HXX_

#include <librevenge/librevenge.h>

#include "librvngabw-api.hxx"
#include "ABWDocumentHandler.hxx"

namespace librvngabw
{
class ABWTextGeneratorPrivate;

/** A generator for text documents.
  *
  * See @c librevenge library for documentation of the ::librevenge::RVNGTextInterface
  * interface.
  */
class RVNGABWAPI ABWTextGenerator : public librevenge::RVNGTextInterface
{
public:
	ABWTextGenerator(ABWDocumentHandler *pHandler);
	~ABWTextGenerator();

	void setDocumentMetaData(const librevenge::RVNGPropertyList &propList);
	void startDocument(const librevenge::RVNGPropertyList &);
	void endDocument();

	void defineEmbeddedFont(const librevenge::RVNGPropertyList &propList);

	void definePageStyle(const librevenge::RVNGPropertyList &);
	void openPageSpan(const librevenge::RVNGPropertyList &propList);
	void closePageSpan();

	void defineSectionStyle(const librevenge::RVNGPropertyList &);
	void openSection(const librevenge::RVNGPropertyList &propList);
	void closeSection();

	void openHeader(const librevenge::RVNGPropertyList &propList);
	void closeHeader();
	void openFooter(const librevenge::RVNGPropertyList &propList);
	void closeFooter();

	void defineParagraphStyle(const librevenge::RVNGPropertyList &propList);
	void openParagraph(const librevenge::RVNGPropertyList &propList);
	void closeParagraph();

	void defineCharacterStyle(const librevenge::RVNGPropertyList &propList);
	void openSpan(const librevenge::RVNGPropertyList &propList);
	void closeSpan();

	void openLink(const librevenge::RVNGPropertyList &propList);
	void closeLink();

	void insertTab();
	void insertSpace();
	void insertText(const librevenge::RVNGString &text);
	void insertLineBreak();
	void insertField(const librevenge::RVNGPropertyList &propList);

	void openOrderedListLevel(const librevenge::RVNGPropertyList &propList);
	void openUnorderedListLevel(const librevenge::RVNGPropertyList &propList);
	void closeOrderedListLevel();
	void closeUnorderedListLevel();
	void openListElement(const librevenge::RVNGPropertyList &propList);
	void closeListElement();

	void openFootnote(const librevenge::RVNGPropertyList &propList);
	void closeFootnote();
	void openEndnote(const librevenge::RVNGPropertyList &propList);
	void closeEndnote();
	void openComment(const librevenge::RVNGPropertyList &propList);
	void closeComment();
	void openTextBox(const librevenge::RVNGPropertyList &propList);
	void closeTextBox();

	void openTable(const librevenge::RVNGPropertyList &propList);
	void openTableRow(const librevenge::RVNGPropertyList &propList);
	void closeTableRow();
	void openTableCell(const librevenge::RVNGPropertyList &propList);
	void closeTableCell();
	void insertCoveredTableCell(const librevenge::RVNGPropertyList &propList);
	void closeTable();

	//
	// simple Graphic
	//

	void openGroup(const librevenge::RVNGPropertyList &propList);
	void closeGroup();

	void defineGraphicStyle(const librevenge::RVNGPropertyList &propList);
	void drawRectangle(const librevenge::RVNGPropertyList &propList);
	void drawEllipse(const librevenge::RVNGPropertyList &propList);
	void drawPolygon(const librevenge::RVNGPropertyList &propList);
	void drawPolyline(const librevenge::RVNGPropertyList &propList);
	void drawPath(const librevenge::RVNGPropertyList &propList);
	void drawConnector(const librevenge::RVNGPropertyList &propList);

	void openFrame(const librevenge::RVNGPropertyList &propList);
	void closeFrame();

	void insertBinaryObject(const librevenge::RVNGPropertyList &propList);
	void insertEquation(const librevenge::RVNGPropertyList &propList);

	/** Registers a handler to check acceptable mimeType
	  * @param[in] checkHandler a function that check is a mime type must be allowed
	  * @param[in] useAlsoDefaultType a flag to know if we need to use or not the default value
	  *
	  * \note by default, the list of allowed image is: bmp,gif,jpeg,png, svg,tiff,wnf and wpg
	*/
	void registerCheckImageHandler(ABWCheckImage checkHandler, bool useAlsoDefaultType);
	/** Registers a handler for embedded images.
	  *
	  * The handler converts the image to a format suitable for the used
	  * ABWDocumentHandler.
	  *
	  * @param[in] mimeType MIME type of the image
	  * @param[in] imageHandler a function that handles processing of
	  *		the images's data and generating output
	  */
	void registerEmbeddedImageHandler(const librevenge::RVNGString &mimeType, ABWEmbeddedImage imageHandler);
	/** Registers a handler for embedded objects.
	  *
	  * @param[in] mimeType MIME type of the object
	  * @param[in] objectHandler a function that handles processing of
	  *		the object's data and generating output
	  */
	void registerEmbeddedObjectHandler(const librevenge::RVNGString &mimeType, ABWEmbeddedObject objectHandler);


private:
	ABWTextGenerator(ABWTextGenerator const &);
	ABWTextGenerator &operator=(ABWTextGenerator const &);

	ABWTextGeneratorPrivate *m_data;
};
}
#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
