; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -codegenprepare -S -mtriple=riscv64 < %s | FileCheck %s

define i8 @hoist_add(i8 %x) {
; CHECK-LABEL: define i8 @hoist_add(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INC:%.*]] = add i8 [[X]], 1
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i8 [[INC]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[EXIT:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ [[INC]], [[IF_THEN]] ], [ -1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %cmp = icmp eq i8 %x, -1
  br i1 %cmp, label %exit, label %if.then

if.then:
  %inc = add nuw nsw i8 %x, 1
  br label %exit

exit:
  %retval = phi i8 [ %inc, %if.then ], [ -1, %entry ]
  ret i8 %retval
}

define i8 @hoist_lshr(i8 %x) {
; CHECK-LABEL: define i8 @hoist_lshr(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INC:%.*]] = lshr i8 [[X]], 3
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i8 [[INC]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[EXIT:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ [[INC]], [[IF_THEN]] ], [ -1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %cmp = icmp ult i8 %x, 8
  br i1 %cmp, label %exit, label %if.then

if.then:
  %inc = lshr exact i8 %x, 3
  br label %exit

exit:
  %retval = phi i8 [ %inc, %if.then ], [ -1, %entry ]
  ret i8 %retval
}

define i8 @nomove_add(i8 %x) {
; CHECK-LABEL: define i8 @nomove_add(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INC:%.*]] = add i8 [[X]], 1
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i8 [[INC]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[EXIT:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ [[INC]], [[IF_THEN]] ], [ -1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %inc = add nuw nsw i8 %x, 1
  %cmp = icmp eq i8 %x, -1
  br i1 %cmp, label %exit, label %if.then

if.then:
  br label %exit

exit:
  %retval = phi i8 [ %inc, %if.then ], [ -1, %entry ]
  ret i8 %retval
}
