/* gitg-diff-view.c generated by valac 0.32.1, the Vala compiler
 * generated from gitg-diff-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>
#include <stdio.h>


#define GITG_TYPE_DIFF_VIEW (gitg_diff_view_get_type ())
#define GITG_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffView))
#define GITG_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))
#define GITG_IS_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW))
#define GITG_IS_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW))
#define GITG_DIFF_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))

typedef struct _GitgDiffView GitgDiffView;
typedef struct _GitgDiffViewClass GitgDiffViewClass;
typedef struct _GitgDiffViewPrivate GitgDiffViewPrivate;

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;

#define GITG_TYPE_DIFF_VIEW_OPTIONS (gitg_diff_view_options_get_type ())
#define GITG_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptions))
#define GITG_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))
#define GITG_IS_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_IS_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_DIFF_VIEW_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))

typedef struct _GitgDiffViewOptions GitgDiffViewOptions;
typedef struct _GitgDiffViewOptionsClass GitgDiffViewOptionsClass;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;

#define GITG_TYPE_PATCH_SET (gitg_patch_set_get_type ())
#define GITG_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PATCH_SET, GitgPatchSet))
#define GITG_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PATCH_SET, GitgPatchSetClass))
#define GITG_IS_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PATCH_SET))
#define GITG_IS_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PATCH_SET))
#define GITG_PATCH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PATCH_SET, GitgPatchSetClass))

typedef struct _GitgPatchSet GitgPatchSet;
typedef struct _GitgPatchSetClass GitgPatchSetClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;
#define _ggit_diff_file_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_file_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_INFO (gitg_diff_view_file_info_get_type ())
#define GITG_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfo))
#define GITG_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))
#define GITG_IS_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_IS_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_DIFF_VIEW_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))

typedef struct _GitgDiffViewFileInfo GitgDiffViewFileInfo;
typedef struct _GitgDiffViewFileInfoClass GitgDiffViewFileInfoClass;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT (gitg_diff_view_file_renderer_text_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererText))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))

typedef struct _GitgDiffViewFileRendererText GitgDiffViewFileRendererText;
typedef struct _GitgDiffViewFileRendererTextClass GitgDiffViewFileRendererTextClass;
typedef struct _GitgPatchSetPrivate GitgPatchSetPrivate;

#define GITG_PATCH_SET_TYPE_PATCH (gitg_patch_set_patch_get_type ())

#define GITG_PATCH_SET_TYPE_TYPE (gitg_patch_set_type_get_type ())
typedef struct _GitgPatchSetPatch GitgPatchSetPatch;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgDiffView {
	GtkGrid parent_instance;
	GitgDiffViewPrivate * priv;
};

struct _GitgDiffViewClass {
	GtkGridClass parent_class;
	void (*options_changed) (GitgDiffView* self);
};

struct _GitgDiffViewPrivate {
	GitgDiffViewCommitDetails* d_commit_details;
	GtkScrolledWindow* d_scrolledwindow;
	GtkGrid* d_grid_files;
	GtkEventBox* d_event_box;
	GtkRevealer* d_revealer_options;
	GitgDiffViewOptions* d_diff_view_options;
	GtkTextView* d_text_view_message;
	GgitDiff* d_diff;
	GitgCommit* d_commit;
	GgitDiffOptions* d_options;
	GCancellable* d_cancellable;
	gulong d_expanded_notify;
	gulong d_parent_commit_notify;
	gboolean d_changes_inline;
	guint d_reveal_options_timeout;
	guint d_unreveal_options_timeout;
	gboolean _has_selection;
	gboolean _wrap_lines;
	gboolean _staged;
	gboolean _unstaged;
	gboolean _show_parents;
	gboolean _default_collapse_all;
	gboolean _use_gravatar;
	gint _tab_width;
	gboolean _handle_selection;
	gboolean _highlight;
	GitgRepository* _repository;
	gboolean _new_is_workdir;
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

typedef void (*GitgDiffViewAnon) (void* user_data);
struct _Block6Data {
	int _ref_count_;
	GitgDiffView* self;
	gint nqueries;
	gboolean finished;
	GeeHashMap* infomap;
	GitgDiffViewAnon check_finish;
	gpointer check_finish_target;
	GDestroyNotify check_finish_target_destroy_notify;
	GgitDiff* diff;
	gboolean preserve_expanded;
	GCancellable* cancellable;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GgitDiffDelta* delta;
	GitgDiffViewFileInfo* info;
};

struct _Block8Data {
	int _ref_count_;
	GitgDiffView* self;
	GeeArrayList* files;
	GitgDiffViewFile* current_file;
	GgitDiffHunk* current_hunk;
	GeeArrayList* current_lines;
	gboolean current_is_binary;
	gint maxlines;
	GitgDiffViewAnon add_hunk;
	gpointer add_hunk_target;
	GDestroyNotify add_hunk_target_destroy_notify;
	GitgDiffViewAnon add_file;
	gpointer add_file_target;
	GDestroyNotify add_file_target_destroy_notify;
	GeeHashMap* infomap;
	GCancellable* cancellable;
};

typedef enum  {
	GITG_PATCH_SET_TYPE_ADD = 'a',
	GITG_PATCH_SET_TYPE_REMOVE = 'r'
} GitgPatchSetType;

struct _GitgPatchSetPatch {
	GitgPatchSetType type;
	gsize old_offset;
	gsize new_offset;
	gsize length;
};

struct _GitgPatchSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgPatchSetPrivate * priv;
	gchar* filename;
	GitgPatchSetPatch* patches;
	gint patches_length1;
};

struct _GitgPatchSetClass {
	GTypeClass parent_class;
	void (*finalize) (GitgPatchSet *self);
};


static gpointer gitg_diff_view_parent_class = NULL;
static GRegex* gitg_diff_view_s_message_regexp;
static GRegex* gitg_diff_view_s_message_regexp = NULL;

GType gitg_diff_view_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_options_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
#define GITG_DIFF_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_DIFF_VIEW, GitgDiffViewPrivate))
enum  {
	GITG_DIFF_VIEW_DUMMY_PROPERTY,
	GITG_DIFF_VIEW_OPTIONS,
	GITG_DIFF_VIEW_HAS_SELECTION,
	GITG_DIFF_VIEW_DIFF,
	GITG_DIFF_VIEW_COMMIT,
	GITG_DIFF_VIEW_WRAP_LINES,
	GITG_DIFF_VIEW_STAGED,
	GITG_DIFF_VIEW_UNSTAGED,
	GITG_DIFF_VIEW_SHOW_PARENTS,
	GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL,
	GITG_DIFF_VIEW_USE_GRAVATAR,
	GITG_DIFF_VIEW_TAB_WIDTH,
	GITG_DIFF_VIEW_HANDLE_SELECTION,
	GITG_DIFF_VIEW_HIGHLIGHT,
	GITG_DIFF_VIEW_REPOSITORY,
	GITG_DIFF_VIEW_NEW_IS_WORKDIR,
	GITG_DIFF_VIEW_IGNORE_WHITESPACE,
	GITG_DIFF_VIEW_CHANGES_INLINE,
	GITG_DIFF_VIEW_CONTEXT_LINES
};
static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f);
GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self);
static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val);
static void gitg_diff_view_real_constructed (GObject* base);
static void gitg_diff_view_update_expanded_files (GitgDiffView* self);
static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_parent_commit_changed (GitgDiffView* self);
static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event);
static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void gitg_diff_view_options_set_view (GitgDiffViewOptions* self, GitgDiffView* value);
static void gitg_diff_view_real_dispose (GObject* base);
static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded);
gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
GType gitg_diff_view_file_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self, gboolean value);
static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit);
void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self, GgitCommit* value);
GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
static void _vala_GgitOId_free (GgitOId* self);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent);
static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable);
static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded);
void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self, gboolean value);
static void gitg_diff_view_on_selection_changed (GitgDiffView* self);
gpointer gitg_patch_set_ref (gpointer instance);
void gitg_patch_set_unref (gpointer instance);
GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_patch_set (GValue* value, gpointer v_object);
void gitg_value_take_patch_set (GValue* value, gpointer v_object);
gpointer gitg_value_get_patch_set (const GValue* value);
GType gitg_patch_set_get_type (void) G_GNUC_CONST;
GType gitg_diff_selectable_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST;
GitgDiffViewFileRenderer* gitg_diff_view_file_get_renderer (GitgDiffViewFile* self);
gboolean gitg_diff_selectable_get_has_selection (GitgDiffSelectable* self);
gboolean gitg_diff_view_get_has_selection (GitgDiffView* self);
static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value);
static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f);
GgitDiffDelta* gitg_diff_view_file_get_delta (GitgDiffViewFile* self);
static gchar* gitg_diff_view_key_for_delta (GitgDiffView* self, GgitDiffDelta* delta);
GType gitg_diff_view_file_info_get_type (void) G_GNUC_CONST;
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda48_ (Block6Data* _data6_);
static void gitg_diff_view_update_diff_hunks (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GeeHashMap* infomap, GCancellable* cancellable);
static void ___lambda48__gitg_diff_view_anon (gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self);
gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self);
GitgDiffViewFileInfo* gitg_diff_view_file_info_new (GitgRepository* repository, GgitDiffDelta* delta, gboolean from_workdir);
GitgDiffViewFileInfo* gitg_diff_view_file_info_construct (GType object_type, GitgRepository* repository, GgitDiffDelta* delta, gboolean from_workdir);
void gitg_diff_view_file_info_query (GitgDiffViewFileInfo* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_diff_view_file_info_query_finish (GitgDiffViewFileInfo* self, GAsyncResult* _res_);
static void _____lambda63_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ______lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda57_ (Block8Data* _data8_);
void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self, GgitDiffHunk* hunk, GeeArrayList* lines);
static void ___lambda57__gitg_diff_view_anon (gpointer self);
static void __lambda58_ (Block8Data* _data8_);
static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda58__gitg_diff_view_anon (gpointer self);
static gint ___lambda59_ (Block8Data* _data8_, GgitDiffDelta* delta, gfloat progress);
const gchar* gitg_diff_view_file_info_get_new_file_content_type (GitgDiffViewFileInfo* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
GitgDiffViewFile* gitg_diff_view_file_new_binary (GitgRepository* repository, GgitDiffDelta* delta);
GitgDiffViewFile* gitg_diff_view_file_construct_binary (GType object_type, GitgRepository* repository, GgitDiffDelta* delta);
gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self);
GitgDiffViewFile* gitg_diff_view_file_new_text (GitgDiffViewFileInfo* info, gboolean handle_selection);
GitgDiffViewFile* gitg_diff_view_file_construct_text (GType object_type, GitgDiffViewFileInfo* info, gboolean handle_selection);
static gint ____lambda59__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self);
static gint ___lambda60_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffBinary* binary);
static gint ____lambda60__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self);
static gint ___lambda61_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk);
static gint ____lambda61__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self);
static gint ___lambda62_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line);
static gint ____lambda62__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self);
gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self);
void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self, gboolean value);
GType gitg_diff_view_file_renderer_text_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_renderer_text_set_maxlines (GitgDiffViewFileRendererText* self, gint value);
static void gitg_diff_view_auto_update_expanded (GitgDiffView* self);
static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey);
static gboolean ___lambda64_ (GitgDiffView* self);
static gboolean ____lambda64__gsource_func (gpointer self);
static gboolean _____lambda65_ (GitgDiffView* self);
static gboolean ______lambda65__gsource_func (gpointer self);
static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GitgDiffView* gitg_diff_view_new (void);
GitgDiffView* gitg_diff_view_construct (GType object_type);
GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self);
void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value);
GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self);
void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value);
gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self);
void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_staged (GitgDiffView* self);
void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_unstaged (GitgDiffView* self);
void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_show_parents (GitgDiffView* self);
void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self);
void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_tab_width (GitgDiffView* self);
void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value);
void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_highlight (GitgDiffView* self);
void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value);
void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self);
void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self);
void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_context_lines (GitgDiffView* self);
void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value);
GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1);
GitgPatchSet* gitg_diff_selectable_get_selection (GitgDiffSelectable* self);
GType gitg_patch_set_patch_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_type_get_type (void) G_GNUC_CONST;
GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self);
void gitg_patch_set_patch_free (GitgPatchSetPatch* self);
static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value);
static void gitg_diff_view_real_options_changed (GitgDiffView* self);
static void gitg_diff_view_finalize (GObject* obj);
static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f) {
	gboolean result = FALSE;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	GgitDiffOption _tmp4_ = 0;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = f;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = (_tmp3_ & _tmp4_) != 0;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 484 "gitg-diff-view.c"
}


static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val) {
	GgitDiffOption flags = 0;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GgitDiffOption _tmp9_ = 0;
	GgitDiffOptions* _tmp10_ = NULL;
	GgitDiffOptions* _tmp11_ = NULL;
	GgitDiffOption _tmp12_ = 0;
	GgitDiffOption _tmp13_ = 0;
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	flags = _tmp3_;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = val;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_) {
#line 516 "gitg-diff-view.c"
		GgitDiffOption _tmp5_ = 0;
		GgitDiffOption _tmp6_ = 0;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = flags;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = f;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp5_ | _tmp6_;
#line 525 "gitg-diff-view.c"
	} else {
		GgitDiffOption _tmp7_ = 0;
		GgitDiffOption _tmp8_ = 0;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = flags;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = f;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp7_ & (~_tmp8_);
#line 535 "gitg-diff-view.c"
	}
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = flags;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = gitg_diff_view_get_options (self);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_options_get_flags (_tmp11_);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = _tmp12_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp13_) {
#line 549 "gitg-diff-view.c"
		GgitDiffOptions* _tmp14_ = NULL;
		GgitDiffOptions* _tmp15_ = NULL;
		GgitDiffOption _tmp16_ = 0;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = gitg_diff_view_get_options (self);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp14_;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = flags;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_flags (_tmp15_, _tmp16_);
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 563 "gitg-diff-view.c"
	}
}


static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_expanded_files ((GitgDiffView*) self);
#line 571 "gitg-diff-view.c"
}


static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_commit_changed ((GitgDiffView*) self);
#line 578 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_motion_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 587 "gitg-diff-view.c"
}


static void gitg_diff_view_real_constructed (GObject* base) {
	GitgDiffView * self;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GitgDiffViewOptions* _tmp6_ = NULL;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = g_signal_connect_object ((GObject*) _tmp0_, "notify::expanded", (GCallback) _gitg_diff_view_update_expanded_files_g_object_notify, self, 0);
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_expanded_notify = _tmp1_;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = g_signal_connect_object ((GObject*) _tmp2_, "notify::parent-commit", (GCallback) _gitg_diff_view_parent_commit_changed_g_object_notify, self, 0);
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_parent_commit_notify = _tmp3_;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "use-gravatar", (GObject*) _tmp4_, "use-gravatar", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_event_box;
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "motion-notify-event", (GCallback) _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event, self, 0);
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_diff_view_options;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_options_set_view (_tmp6_, self);
#line 626 "gitg-diff-view.c"
}


static void gitg_diff_view_real_dispose (GObject* base) {
	GitgDiffView * self;
	GCancellable* _tmp0_ = NULL;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_cancellable;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 639 "gitg-diff-view.c"
		GCancellable* _tmp1_ = NULL;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = self->priv->d_cancellable;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_cancellable_cancel (_tmp1_);
#line 645 "gitg-diff-view.c"
	}
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
#line 649 "gitg-diff-view.c"
}


static void gitg_diff_view_parent_commit_changed (GitgDiffView* self) {
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 658 "gitg-diff-view.c"
}


static void gitg_diff_view_update_expanded_files (GitgDiffView* self) {
	gboolean expanded = FALSE;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkGrid* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_commit_details_get_expanded (_tmp0_);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	expanded = _tmp2_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = self->priv->d_grid_files;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
#line 683 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp4_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 691 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 695 "gitg-diff-view.c"
			{
				GtkWidget* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = file;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = expanded;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp5_) : NULL, _tmp6_);
#line 705 "gitg-diff-view.c"
			}
		}
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 710 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit) {
	gchar* result = NULL;
	gchar* message = NULL;
	GitgCommit* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GMatchInfo* minfo = NULL;
	GRegex* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp9_ = NULL;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (commit != NULL, NULL);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = commit;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_commit_get_message ((GgitCommit*) _tmp0_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	message = _tmp2_;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = gitg_diff_view_s_message_regexp;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = message;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	minfo = _tmp5_;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_) {
#line 751 "gitg-diff-view.c"
		GMatchInfo* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = minfo;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = g_match_info_fetch_named (_tmp7_, "message");
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp8_;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_match_info_unref0 (minfo);
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 766 "gitg-diff-view.c"
	}
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = g_strdup ("");
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp9_;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (message);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 778 "gitg-diff-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 785 "gitg-diff-view.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 792 "gitg-diff-view.c"
}


static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded) {
	gboolean _tmp0_ = FALSE;
	GgitDiff* _tmp1_ = NULL;
	GitgDiffViewCommitDetails* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GitgCommit* _tmp9_ = NULL;
	GgitDiff* _tmp56_ = NULL;
#line 246 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_diff;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ == NULL) {
#line 811 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = self->priv->d_commit;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 817 "gitg-diff-view.c"
	} else {
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 821 "gitg-diff-view.c"
	}
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 825 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp3_ = NULL;
		GtkScrolledWindow* _tmp4_ = NULL;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = self->priv->d_commit_details;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = self->priv->d_scrolledwindow;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 838 "gitg-diff-view.c"
	}
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_commit_details;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 258 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_scrolledwindow;
#line 258 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->d_cancellable;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_cancellable_cancel (_tmp7_);
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = g_cancellable_new ();
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_cancellable = _tmp8_;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->d_commit;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != NULL) {
#line 862 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp10_ = NULL;
		gulong _tmp11_ = 0UL;
		GitgDiffViewCommitDetails* _tmp12_ = NULL;
		GitgCommit* _tmp13_ = NULL;
		GitgDiffViewCommitDetails* _tmp14_ = NULL;
		gulong _tmp15_ = 0UL;
		gint parent = 0;
		GgitCommitParents* parents = NULL;
		GitgCommit* _tmp16_ = NULL;
		GgitCommitParents* _tmp17_ = NULL;
		GgitCommit* parent_commit = NULL;
		GitgDiffViewCommitDetails* _tmp18_ = NULL;
		GgitCommit* _tmp19_ = NULL;
		GgitCommit* _tmp20_ = NULL;
		GgitCommit* _tmp21_ = NULL;
		GgitCommit* _tmp22_ = NULL;
		GitgCommit* _tmp39_ = NULL;
		GgitDiffOptions* _tmp40_ = NULL;
		GgitDiffOptions* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		GgitDiff* _tmp43_ = NULL;
		GitgDiffViewCommitDetails* _tmp44_ = NULL;
		gchar* message = NULL;
		GitgCommit* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		GtkTextView* _tmp47_ = NULL;
		GtkTextBuffer* _tmp48_ = NULL;
		GtkTextBuffer* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		GtkTextView* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = self->priv->d_commit_details;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = self->priv->d_parent_commit_notify;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_block (_tmp10_, _tmp11_);
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->d_commit_details;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = self->priv->d_commit;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp12_, (GgitCommit*) _tmp13_);
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->d_commit_details;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = self->priv->d_parent_commit_notify;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_unblock (_tmp14_, _tmp15_);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent = 0;
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = self->priv->d_commit;
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = ggit_commit_get_parents ((GgitCommit*) _tmp16_);
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parents = _tmp17_;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = self->priv->d_commit_details;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = gitg_diff_view_commit_details_get_parent_commit (_tmp18_);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _tmp19_;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent_commit = _tmp21_;
#line 275 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = parent_commit;
#line 275 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp22_ != NULL) {
#line 934 "gitg-diff-view.c"
			{
				gint i = 0;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				i = 0;
#line 939 "gitg-diff-view.c"
				{
					gboolean _tmp23_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp23_ = TRUE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					while (TRUE) {
#line 946 "gitg-diff-view.c"
						gint _tmp25_ = 0;
						GgitCommitParents* _tmp26_ = NULL;
						guint _tmp27_ = 0U;
						guint _tmp28_ = 0U;
						GgitOId* id = NULL;
						GgitCommitParents* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						GgitOId* _tmp31_ = NULL;
						GgitOId* _tmp32_ = NULL;
						GgitCommit* _tmp33_ = NULL;
						GgitOId* _tmp34_ = NULL;
						GgitOId* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!_tmp23_) {
#line 963 "gitg-diff-view.c"
							gint _tmp24_ = 0;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp24_ = i;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							i = _tmp24_ + 1;
#line 969 "gitg-diff-view.c"
						}
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp23_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp25_ = i;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp26_ = parents;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp27_ = ggit_commit_parents_get_size (_tmp26_);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp28_ = _tmp27_;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!(((guint) _tmp25_) < _tmp28_)) {
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 985 "gitg-diff-view.c"
						}
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp29_ = parents;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp30_ = i;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp31_ = ggit_commit_parents_get_id (_tmp29_, (guint) _tmp30_);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						id = _tmp31_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp32_ = id;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp33_ = parent_commit;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp34_ = ggit_object_get_id ((GgitObject*) _tmp33_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp35_ = _tmp34_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp36_ = ggit_oid_equal (_tmp32_, _tmp35_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp37_ = _tmp36_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (_tmp35_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (_tmp37_) {
#line 1011 "gitg-diff-view.c"
							gint _tmp38_ = 0;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp38_ = i;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							parent = _tmp38_;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							__vala_GgitOId_free0 (id);
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 1021 "gitg-diff-view.c"
						}
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (id);
#line 1025 "gitg-diff-view.c"
					}
				}
			}
		}
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp39_ = self->priv->d_commit;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp40_ = gitg_diff_view_get_options (self);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp41_ = _tmp40_;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp42_ = parent;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp43_ = gitg_commit_get_diff (_tmp39_, _tmp41_, _tmp42_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp43_;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp44_ = self->priv->d_commit_details;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _tmp44_);
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp45_ = self->priv->d_commit;
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp46_ = gitg_diff_view_message_without_subject (self, _tmp45_);
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		message = _tmp46_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp47_ = self->priv->d_text_view_message;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp48_ = gtk_text_view_get_buffer (_tmp47_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = _tmp48_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp50_ = message;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_text_buffer_set_text (_tmp49_, _tmp50_, -1);
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp51_ = self->priv->d_text_view_message;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp52_ = message;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp51_, g_strcmp0 (_tmp52_, "") != 0);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parent_commit);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parents);
#line 1076 "gitg-diff-view.c"
	} else {
		GitgDiffViewCommitDetails* _tmp53_ = NULL;
		GitgDiffViewCommitDetails* _tmp54_ = NULL;
		GtkTextView* _tmp55_ = NULL;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp53_ = self->priv->d_commit_details;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp53_, NULL);
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp54_ = self->priv->d_commit_details;
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp54_);
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp55_ = self->priv->d_text_view_message;
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp55_);
#line 1093 "gitg-diff-view.c"
	}
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp56_ = self->priv->d_diff;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp56_ != NULL) {
#line 1099 "gitg-diff-view.c"
		GgitDiff* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		GCancellable* _tmp59_ = NULL;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp57_ = self->priv->d_diff;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp58_ = preserve_expanded;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp59_ = self->priv->d_cancellable;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff (self, _tmp57_, _tmp58_, _tmp59_);
#line 1111 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded) {
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_expanded_notify;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_block (_tmp0_, _tmp1_);
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = expanded;
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp2_, _tmp3_);
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_expanded_notify;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_unblock (_tmp4_, _tmp5_);
#line 1143 "gitg-diff-view.c"
}


static void gitg_diff_view_on_selection_changed (GitgDiffView* self) {
	gboolean something_selected = FALSE;
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	something_selected = FALSE;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 1161 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 1169 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 1173 "gitg-diff-view.c"
			{
				GitgDiffSelectable* selectable = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgDiffViewFileRenderer* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffSelectable* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp4_) : NULL;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp5_ == NULL) {
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp4_);
#line 1195 "gitg-diff-view.c"
				}
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				selectable = _tmp5_;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = selectable;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp7_ = gitg_diff_selectable_get_has_selection (_tmp6_);
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = _tmp7_;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					something_selected = TRUE;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (selectable);
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1213 "gitg-diff-view.c"
				}
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (selectable);
#line 1217 "gitg-diff-view.c"
			}
		}
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 1222 "gitg-diff-view.c"
	}
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->_has_selection;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = something_selected;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp10_) {
#line 1230 "gitg-diff-view.c"
		gboolean _tmp11_ = FALSE;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = something_selected;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, _tmp11_);
#line 1236 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f) {
	gchar* result = NULL;
	gchar* path = NULL;
	GitgDiffViewFile* _tmp0_ = NULL;
	GgitDiffDelta* _tmp1_ = NULL;
	GgitDiffDelta* _tmp2_ = NULL;
	GgitDiffFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 339 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 339 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = f;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_file_get_delta (_tmp0_);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = ggit_diff_delta_get_old_file (_tmp2_);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = ggit_diff_file_get_path (_tmp3_);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	path = _tmp5_;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = path;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_ == NULL) {
#line 1273 "gitg-diff-view.c"
		GitgDiffViewFile* _tmp7_ = NULL;
		GgitDiffDelta* _tmp8_ = NULL;
		GgitDiffDelta* _tmp9_ = NULL;
		GgitDiffFile* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = f;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_file_get_delta (_tmp7_);
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = ggit_diff_delta_get_new_file (_tmp9_);
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = ggit_diff_file_get_path (_tmp10_);
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (path);
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		path = _tmp12_;
#line 1296 "gitg-diff-view.c"
	}
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = path;
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1302 "gitg-diff-view.c"
}


static gpointer _ggit_diff_file_ref0 (gpointer self) {
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_file_ref (self) : NULL;
#line 1309 "gitg-diff-view.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1321 "gitg-diff-view.c"
}


static gchar* gitg_diff_view_key_for_delta (GitgDiffView* self, GgitDiffDelta* delta) {
	gchar* result = NULL;
	GgitDiffFile* new_file = NULL;
	GgitDiffDelta* _tmp0_ = NULL;
	GgitDiffFile* _tmp1_ = NULL;
	GgitDiffFile* _tmp2_ = NULL;
	gchar* new_path = NULL;
	GgitDiffFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GgitDiffFile* old_file = NULL;
	GgitDiffDelta* _tmp10_ = NULL;
	GgitDiffFile* _tmp11_ = NULL;
	GgitDiffFile* _tmp12_ = NULL;
	gchar* old_path = NULL;
	GgitDiffFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp20_ = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, NULL);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = delta;
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_diff_delta_get_new_file (_tmp0_);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _ggit_diff_file_ref0 (_tmp1_);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	new_file = _tmp2_;
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = new_file;
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = ggit_diff_file_get_path (_tmp3_);
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	new_path = _tmp5_;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = new_path;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_ != NULL) {
#line 1370 "gitg-diff-view.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = new_path;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = g_strconcat ("path:", _tmp8_, NULL);
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp9_;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (new_path);
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (new_file);
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1388 "gitg-diff-view.c"
	}
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = delta;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = ggit_diff_delta_get_old_file (_tmp10_);
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = _ggit_diff_file_ref0 (_tmp11_);
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	old_file = _tmp12_;
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = old_file;
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp14_ = ggit_diff_file_get_path (_tmp13_);
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	old_path = _tmp15_;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = old_path;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_ != NULL) {
#line 1410 "gitg-diff-view.c"
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = old_path;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = string_to_string (_tmp17_);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = g_strconcat ("path:", _tmp18_, NULL);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp19_;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (old_path);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (old_file);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (new_path);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (new_file);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1432 "gitg-diff-view.c"
	}
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp20_ = g_strdup ("");
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp20_;
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (old_path);
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_file_unref0 (old_file);
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (new_path);
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_file_unref0 (new_file);
#line 371 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1448 "gitg-diff-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data6_;
#line 1457 "gitg-diff-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1466 "gitg-diff-view.c"
		GitgDiffView* self;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data6_->self;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->check_finish_target_destroy_notify == NULL) ? NULL : (_data6_->check_finish_target_destroy_notify (_data6_->check_finish_target), NULL);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish = NULL;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish_target = NULL;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish_target_destroy_notify = NULL;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->infomap);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->diff);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->cancellable);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 1488 "gitg-diff-view.c"
	}
}


static void __lambda48_ (Block6Data* _data6_) {
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _data6_->nqueries;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp2_ == 0) {
#line 1504 "gitg-diff-view.c"
		gboolean _tmp3_ = FALSE;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _data6_->finished;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = _tmp3_;
#line 1510 "gitg-diff-view.c"
	} else {
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = FALSE;
#line 1514 "gitg-diff-view.c"
	}
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_) {
#line 1518 "gitg-diff-view.c"
		gboolean _tmp4_ = FALSE;
		GCancellable* _tmp5_ = NULL;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = _data6_->cancellable;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp5_ == NULL) {
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp4_ = TRUE;
#line 1527 "gitg-diff-view.c"
		} else {
			GCancellable* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp6_ = _data6_->cancellable;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp7_ = g_cancellable_is_cancelled (_tmp6_);
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp4_ = !_tmp7_;
#line 1537 "gitg-diff-view.c"
		}
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp4_;
#line 1541 "gitg-diff-view.c"
	} else {
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1545 "gitg-diff-view.c"
	}
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 1549 "gitg-diff-view.c"
		GgitDiff* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		GeeHashMap* _tmp10_ = NULL;
		GCancellable* _tmp11_ = NULL;
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->finished = FALSE;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = _data6_->diff;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _data6_->preserve_expanded;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = _data6_->infomap;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = _data6_->cancellable;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff_hunks (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 1566 "gitg-diff-view.c"
	}
}


static void ___lambda48__gitg_diff_view_anon (gpointer self) {
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda48_ (self);
#line 1574 "gitg-diff-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data7_;
#line 1583 "gitg-diff-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1592 "gitg-diff-view.c"
		GitgDiffView* self;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data7_->_data6_->self;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data7_->info);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_delta_unref0 (_data7_->delta);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		block6_data_unref (_data7_->_data6_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data7_->_data6_ = NULL;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 1606 "gitg-diff-view.c"
	}
}


static void _____lambda63_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	Block6Data* _data6_;
	GitgDiffView* self;
	GitgDiffViewFileInfo* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GgitDiffDelta* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GitgDiffViewFileInfo* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GitgDiffViewAnon _tmp8_ = NULL;
	void* _tmp8__target = NULL;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = _data7_->_data6_;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (res != NULL);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = _data7_->info;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = res;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_file_info_query_finish (_tmp0_, _tmp1_);
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _data6_->infomap;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _data7_->delta;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gitg_diff_view_key_for_delta (self, _tmp3_);
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = _data7_->info;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp5_, _tmp6_);
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (_tmp5_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = _data6_->nqueries;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->nqueries = _tmp7_ - 1;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = _data6_->check_finish;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8__target = _data6_->check_finish_target;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ (_tmp8__target);
#line 1660 "gitg-diff-view.c"
}


static void ______lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_____lambda63_ (self, source_object, res);
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block7_data_unref (self);
#line 1669 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable) {
	Block6Data* _data6_;
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GitgDiffViewAnon _tmp21_ = NULL;
	void* _tmp21__target = NULL;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->_ref_count_ = 1;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->self = g_object_ref (self);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = diff;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->diff);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->diff = _tmp1_;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = preserve_expanded;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->preserve_expanded = _tmp2_;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = cancellable;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->cancellable);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->cancellable = _tmp4_;
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->nqueries = 0;
#line 377 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->finished = FALSE;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GITG_TYPE_DIFF_VIEW_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->infomap = _tmp5_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish = ___lambda48__gitg_diff_view_anon;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish_target = block6_data_ref (_data6_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish_target_destroy_notify = block6_data_unref;
#line 1727 "gitg-diff-view.c"
	{
		gint i = 0;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 1732 "gitg-diff-view.c"
		{
			gboolean _tmp6_ = FALSE;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp6_ = TRUE;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 1739 "gitg-diff-view.c"
				Block7Data* _data7_;
				gint _tmp8_ = 0;
				GgitDiff* _tmp9_ = NULL;
				gsize _tmp10_ = 0UL;
				GgitDiff* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GgitDiffDelta* _tmp13_ = NULL;
				GitgRepository* _tmp14_ = NULL;
				GgitDiffDelta* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				GitgDiffViewFileInfo* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GitgDiffViewFileInfo* _tmp19_ = NULL;
				GCancellable* _tmp20_ = NULL;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_ = g_slice_new0 (Block7Data);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->_ref_count_ = 1;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->_data6_ = block6_data_ref (_data6_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp6_) {
#line 1762 "gitg-diff-view.c"
					gint _tmp7_ = 0;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = i;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp7_ + 1;
#line 1768 "gitg-diff-view.c"
				}
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = FALSE;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = i;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = _data6_->diff;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp10_ = ggit_diff_get_num_deltas (_tmp9_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!(((gsize) _tmp8_) < _tmp10_)) {
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					block7_data_unref (_data7_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_data7_ = NULL;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1786 "gitg-diff-view.c"
				}
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = _data6_->diff;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp12_ = i;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp13_ = ggit_diff_get_delta (_tmp11_, (gsize) _tmp12_);
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->delta = _tmp13_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp14_ = self->priv->_repository;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp15_ = _data7_->delta;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp16_ = self->priv->_new_is_workdir;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp17_ = gitg_diff_view_file_info_new (_tmp14_, _tmp15_, _tmp16_);
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->info = _tmp17_;
#line 394 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp18_ = _data6_->nqueries;
#line 394 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data6_->nqueries = _tmp18_ + 1;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp19_ = _data7_->info;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp20_ = _data6_->cancellable;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_info_query (_tmp19_, _tmp20_, ______lambda63__gasync_ready_callback, block7_data_ref (_data7_));
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				block7_data_unref (_data7_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_ = NULL;
#line 1820 "gitg-diff-view.c"
			}
		}
	}
#line 407 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->finished = TRUE;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ = _data6_->check_finish;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21__target = _data6_->check_finish_target;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ (_tmp21__target);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block6_data_unref (_data6_);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = NULL;
#line 1836 "gitg-diff-view.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data8_;
#line 1845 "gitg-diff-view.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1854 "gitg-diff-view.c"
		GitgDiffView* self;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data8_->self;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data8_->add_file_target_destroy_notify == NULL) ? NULL : (_data8_->add_file_target_destroy_notify (_data8_->add_file_target), NULL);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file_target = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file_target_destroy_notify = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data8_->add_hunk_target_destroy_notify == NULL) ? NULL : (_data8_->add_hunk_target_destroy_notify (_data8_->add_hunk_target), NULL);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk_target = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk_target_destroy_notify = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->files);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->infomap);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->cancellable);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block8Data, _data8_);
#line 1890 "gitg-diff-view.c"
	}
}


static void __lambda57_ (Block8Data* _data8_) {
	GitgDiffView* self;
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data8_->current_hunk != NULL) {
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_file_add_hunk (_data8_->current_file, _data8_->current_hunk, _data8_->current_lines);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_lines = NULL;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_hunk = NULL;
#line 1911 "gitg-diff-view.c"
	}
}


static void ___lambda57__gitg_diff_view_anon (gpointer self) {
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda57_ (self);
#line 1919 "gitg-diff-view.c"
}


static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_on_selection_changed ((GitgDiffView*) self);
#line 1926 "gitg-diff-view.c"
}


static void __lambda58_ (Block8Data* _data8_) {
	GitgDiffView* self;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk (_data8_->add_hunk_target);
#line 435 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data8_->current_file != NULL) {
#line 1938 "gitg-diff-view.c"
		GitgDiffViewFileRenderer* _tmp0_ = NULL;
		GitgDiffViewFileRenderer* _tmp1_ = NULL;
		GitgDiffViewFileRenderer* _tmp2_ = NULL;
#line 437 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _data8_->current_file);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = gitg_diff_view_file_get_renderer (_data8_->current_file);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = _tmp0_;
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _tmp1_;
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_connect_object ((GObject*) _tmp2_, "notify::has-selection", (GCallback) _gitg_diff_view_on_selection_changed_g_object_notify, self, 0);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_tmp2_);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->files, _data8_->current_file);
#line 442 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 442 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_file = NULL;
#line 1960 "gitg-diff-view.c"
	}
}


static void ___lambda58__gitg_diff_view_anon (gpointer self) {
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda58_ (self);
#line 1968 "gitg-diff-view.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	for (i = 0; i < stack_length; i++) {
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			return TRUE;
#line 1980 "gitg-diff-view.c"
		}
	}
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return FALSE;
#line 1985 "gitg-diff-view.c"
}


static gint ___lambda59_ (Block8Data* _data8_, GgitDiffDelta* delta, gfloat progress) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GitgDiffViewFileInfo* info = NULL;
	gchar* deltakey = NULL;
	GgitDiffDelta* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GgitDiffDelta* _tmp16_ = NULL;
	GgitDiffFlag _tmp17_ = 0;
	gchar** known_binary_files_types = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint known_binary_files_types_length1 = 0;
	gint _known_binary_files_types_size_ = 0;
	gboolean _tmp20_ = FALSE;
	GitgDiffViewFileInfo* _tmp21_ = NULL;
#line 449 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 449 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2018 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2027 "gitg-diff-view.c"
	} else {
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2031 "gitg-diff-view.c"
	}
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 452 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 452 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2039 "gitg-diff-view.c"
	}
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file (_data8_->add_file_target);
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	info = NULL;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = delta;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gitg_diff_view_key_for_delta (self, _tmp4_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	deltakey = _tmp5_;
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = _data8_->infomap;
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = deltakey;
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp8_) {
#line 2059 "gitg-diff-view.c"
		GeeHashMap* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _data8_->infomap;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = deltakey;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (info);
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		info = (GitgDiffViewFileInfo*) _tmp11_;
#line 2073 "gitg-diff-view.c"
	} else {
		GitgRepository* _tmp12_ = NULL;
		GgitDiffDelta* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GitgDiffViewFileInfo* _tmp15_ = NULL;
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->_repository;
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = delta;
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->_new_is_workdir;
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = gitg_diff_view_file_info_new (_tmp12_, _tmp13_, _tmp14_);
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (info);
#line 466 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		info = _tmp15_;
#line 2091 "gitg-diff-view.c"
	}
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = delta;
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp17_ = ggit_diff_delta_get_flags (_tmp16_);
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_is_binary = (_tmp17_ & GGIT_DIFF_FLAG_BINARY) != 0;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = g_strdup ("application/pdf");
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_[0] = _tmp18_;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types = _tmp19_;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types_length1 = 1;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_known_binary_files_types_size_ = known_binary_files_types_length1;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ = info;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp21_ != NULL) {
#line 2115 "gitg-diff-view.c"
		GitgDiffViewFileInfo* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = info;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp22_);
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = _tmp23_;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = known_binary_files_types;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25__length1 = known_binary_files_types_length1;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _vala_string_array_contains (_tmp25_, _tmp25__length1, _tmp24_);
#line 2133 "gitg-diff-view.c"
	} else {
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = FALSE;
#line 2137 "gitg-diff-view.c"
	}
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp20_) {
#line 479 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_is_binary = TRUE;
#line 2143 "gitg-diff-view.c"
	}
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data8_->current_is_binary) {
#line 2147 "gitg-diff-view.c"
		GitgRepository* _tmp26_ = NULL;
		GgitDiffDelta* _tmp27_ = NULL;
		GitgDiffViewFile* _tmp28_ = NULL;
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = self->priv->_repository;
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp27_ = delta;
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = gitg_diff_view_file_new_binary (_tmp26_, _tmp27_);
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_object_ref_sink (_tmp28_);
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_file = _tmp28_;
#line 2163 "gitg-diff-view.c"
	} else {
		GitgDiffViewFileInfo* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		GitgDiffViewFile* _tmp31_ = NULL;
		GitgDiffViewFileRenderer* _tmp32_ = NULL;
		GitgDiffViewFileRenderer* _tmp33_ = NULL;
		GitgDiffViewFileRenderer* _tmp34_ = NULL;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp29_ = info;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp30_ = self->priv->_handle_selection;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp31_ = gitg_diff_view_file_new_text (_tmp29_, _tmp30_);
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_object_ref_sink (_tmp31_);
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_file = _tmp31_;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp32_ = gitg_diff_view_file_get_renderer (_data8_->current_file);
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp33_ = _tmp32_;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp34_ = _tmp33_;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_object_bind_property_with_closures ((GObject*) self, "highlight", (GObject*) _tmp34_, "highlight", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_tmp34_);
#line 2193 "gitg-diff-view.c"
	}
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types = (_vala_array_free (known_binary_files_types, known_binary_files_types_length1, (GDestroyNotify) g_free), NULL);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (deltakey);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (info);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2205 "gitg-diff-view.c"
}


static gint ____lambda59__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self) {
	gint result;
	result = ___lambda59_ (self, delta, progress);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2214 "gitg-diff-view.c"
}


static gint ___lambda60_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffBinary* binary) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (binary != NULL, 0);
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2233 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2242 "gitg-diff-view.c"
	} else {
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2246 "gitg-diff-view.c"
	}
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2254 "gitg-diff-view.c"
	}
#line 502 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 502 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2260 "gitg-diff-view.c"
}


static gint ____lambda60__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self) {
	gint result;
	result = ___lambda60_ (self, delta, binary);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2269 "gitg-diff-view.c"
}


static gpointer _ggit_diff_hunk_ref0 (gpointer self) {
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_hunk_ref (self) : NULL;
#line 2276 "gitg-diff-view.c"
}


static gint ___lambda61_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2295 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2304 "gitg-diff-view.c"
	} else {
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2308 "gitg-diff-view.c"
	}
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2316 "gitg-diff-view.c"
	}
#line 511 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_data8_->current_is_binary) {
#line 2320 "gitg-diff-view.c"
		GgitDiffHunk* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GgitDiffHunk* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GgitDiffHunk* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GgitDiffHunk* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GgitDiffHunk* _tmp14_ = NULL;
		GgitDiffHunk* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = hunk;
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = ggit_diff_hunk_get_old_start (_tmp4_);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = hunk;
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = ggit_diff_hunk_get_old_lines (_tmp6_);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = MAX (_data8_->maxlines, _tmp5_ + _tmp7_);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->maxlines = _tmp8_;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = hunk;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = ggit_diff_hunk_get_new_start (_tmp9_);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = hunk;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = ggit_diff_hunk_get_new_lines (_tmp11_);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = MAX (_data8_->maxlines, _tmp10_ + _tmp12_);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->maxlines = _tmp13_;
#line 516 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk (_data8_->add_hunk_target);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = hunk;
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _ggit_diff_hunk_ref0 (_tmp14_);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_hunk = _tmp15_;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, ggit_diff_line_unref, NULL, NULL, NULL);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_lines = _tmp16_;
#line 2374 "gitg-diff-view.c"
	}
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2380 "gitg-diff-view.c"
}


static gint ____lambda61__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self) {
	gint result;
	result = ___lambda61_ (self, delta, hunk);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2389 "gitg-diff-view.c"
}


static gint ___lambda62_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (line != NULL, 0);
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2410 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2419 "gitg-diff-view.c"
	} else {
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2423 "gitg-diff-view.c"
	}
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2431 "gitg-diff-view.c"
	}
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_data8_->current_is_binary) {
#line 2435 "gitg-diff-view.c"
		GgitDiffLine* _tmp4_ = NULL;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = line;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->current_lines, _tmp4_);
#line 2441 "gitg-diff-view.c"
	}
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2447 "gitg-diff-view.c"
}


static gint ____lambda62__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self) {
	gint result;
	result = ___lambda62_ (self, delta, hunk, line);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2456 "gitg-diff-view.c"
}


static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 591 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_update_expanded ((GitgDiffView*) self);
#line 2463 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff_hunks (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GeeHashMap* infomap, GCancellable* cancellable) {
	Block8Data* _data8_;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GList* file_widgets = NULL;
	GtkGrid* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GeeHashSet* was_expanded = NULL;
	GeeHashSet* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GitgDiffViewCommitDetails* _tmp27_ = NULL;
	GitgDiffViewCommitDetails* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GError * _inner_error_ = NULL;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (infomap != NULL);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->_ref_count_ = 1;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->self = g_object_ref (self);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = infomap;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data8_->infomap);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->infomap = _tmp1_;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = cancellable;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data8_->cancellable);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->cancellable = _tmp3_;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->files = _tmp4_;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_file = NULL;
#line 416 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_hunk = NULL;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_lines = NULL;
#line 418 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_is_binary = FALSE;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->maxlines = 0;
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk = ___lambda57__gitg_diff_view_anon;
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk_target = block8_data_ref (_data8_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk_target_destroy_notify = block8_data_unref;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file = ___lambda58__gitg_diff_view_anon;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file_target = block8_data_ref (_data8_);
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file_target_destroy_notify = block8_data_unref;
#line 2542 "gitg-diff-view.c"
	{
		GgitDiff* _tmp5_ = NULL;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = diff;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_foreach (_tmp5_, ____lambda59__ggit_diff_file_callback, ____lambda60__ggit_diff_binary_callback, ____lambda61__ggit_diff_hunk_callback, ____lambda62__ggit_diff_line_callback, _data8_, &_inner_error_);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2551 "gitg-diff-view.c"
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 2562 "gitg-diff-view.c"
	}
	__finally33:
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		block8_data_unref (_data8_);
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_ = NULL;
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 446 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 2577 "gitg-diff-view.c"
	}
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk (_data8_->add_hunk_target);
#line 542 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file (_data8_->add_file_target);
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_grid_files;
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	file_widgets = _tmp7_;
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	was_expanded = _tmp8_;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = file_widgets;
#line 2595 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp9_;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2603 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 2607 "gitg-diff-view.c"
			{
				GitgDiffViewFile* f = NULL;
				GtkWidget* _tmp10_ = NULL;
				GitgDiffViewFile* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				GitgDiffViewFile* _tmp22_ = NULL;
#line 549 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp10_ = file;
#line 549 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp10_) : NULL);
#line 549 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				f = _tmp11_;
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp13_ = preserve_expanded;
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp13_) {
#line 2625 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = f;
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = gitg_diff_view_file_get_expanded (_tmp14_);
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp16_;
#line 2637 "gitg-diff-view.c"
				} else {
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = FALSE;
#line 2641 "gitg-diff-view.c"
				}
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp12_) {
#line 2645 "gitg-diff-view.c"
					gchar* path = NULL;
					GitgDiffViewFile* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = f;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = gitg_diff_view_primary_path (self, _tmp17_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					path = _tmp18_;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = path;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp19_ != NULL) {
#line 2660 "gitg-diff-view.c"
						GeeHashSet* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp20_ = was_expanded;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp21_ = path;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
#line 2669 "gitg-diff-view.c"
					}
#line 551 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_free0 (path);
#line 2673 "gitg-diff-view.c"
				}
#line 561 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp22_ = f;
#line 561 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp22_);
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (f);
#line 2681 "gitg-diff-view.c"
			}
		}
	}
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _data8_->files);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp25_ = _tmp24_;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp25_ <= 1) {
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = TRUE;
#line 2693 "gitg-diff-view.c"
	} else {
		gboolean _tmp26_ = FALSE;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = self->priv->_default_collapse_all;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = !_tmp26_;
#line 2700 "gitg-diff-view.c"
	}
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp27_ = self->priv->d_commit_details;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp27_, _tmp23_);
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp28_ = self->priv->d_commit_details;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _data8_->files);
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp30_ = _tmp29_;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expander_visible (_tmp28_, _tmp30_ > 1);
#line 2714 "gitg-diff-view.c"
	{
		gint i = 0;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 2719 "gitg-diff-view.c"
		{
			gboolean _tmp31_ = FALSE;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp31_ = TRUE;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 2726 "gitg-diff-view.c"
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GitgDiffViewFile* file = NULL;
				gint _tmp36_ = 0;
				gpointer _tmp37_ = NULL;
				gchar* path = NULL;
				GitgDiffViewFile* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				GitgDiffViewCommitDetails* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				GitgDiffViewFile* _tmp49_ = NULL;
				GitgDiffViewFileRendererText* renderer_text = NULL;
				GitgDiffViewFile* _tmp50_ = NULL;
				GitgDiffViewFileRenderer* _tmp51_ = NULL;
				GitgDiffViewFileRenderer* _tmp52_ = NULL;
				GitgDiffViewFileRendererText* _tmp53_ = NULL;
				GitgDiffViewFileRendererText* _tmp54_ = NULL;
				gint _tmp58_ = 0;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				GtkGrid* _tmp62_ = NULL;
				GitgDiffViewFile* _tmp63_ = NULL;
				GitgDiffViewFile* _tmp64_ = NULL;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp31_) {
#line 2755 "gitg-diff-view.c"
					gint _tmp32_ = 0;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp32_ = i;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp32_ + 1;
#line 2761 "gitg-diff-view.c"
				}
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp31_ = FALSE;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp33_ = i;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _data8_->files);
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = _tmp34_;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!(_tmp33_ < _tmp35_)) {
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 2775 "gitg-diff-view.c"
				}
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp36_ = i;
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _data8_->files, _tmp36_);
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				file = (GitgDiffViewFile*) _tmp37_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp38_ = file;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = gitg_diff_view_primary_path (self, _tmp38_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				path = _tmp39_;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = self->priv->d_commit_details;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = gitg_diff_view_commit_details_get_expanded (_tmp41_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp43_ = _tmp42_;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp43_) {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp40_ = TRUE;
#line 2799 "gitg-diff-view.c"
				} else {
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp45_ = NULL;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = path;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp45_ != NULL) {
#line 2807 "gitg-diff-view.c"
						GeeHashSet* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						gboolean _tmp48_ = FALSE;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp46_ = was_expanded;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp47_ = path;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp48_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp46_, _tmp47_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp44_ = _tmp48_;
#line 2819 "gitg-diff-view.c"
					} else {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp44_ = FALSE;
#line 2823 "gitg-diff-view.c"
					}
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp40_ = _tmp44_;
#line 2827 "gitg-diff-view.c"
				}
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp49_ = file;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (_tmp49_, _tmp40_);
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp50_ = file;
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp51_ = gitg_diff_view_file_get_renderer (_tmp50_);
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp52_ = _tmp51_;
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp53_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT) ? ((GitgDiffViewFileRendererText*) _tmp52_) : NULL;
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp53_ == NULL) {
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp52_);
#line 2845 "gitg-diff-view.c"
				}
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				renderer_text = _tmp53_;
#line 576 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp54_ = renderer_text;
#line 576 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp54_ != NULL) {
#line 2853 "gitg-diff-view.c"
					GitgDiffViewFileRendererText* _tmp55_ = NULL;
					GitgDiffViewFileRendererText* _tmp56_ = NULL;
					GitgDiffViewFileRendererText* _tmp57_ = NULL;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp55_ = renderer_text;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_file_renderer_text_set_maxlines (_tmp55_, _data8_->maxlines);
#line 580 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp56_ = renderer_text;
#line 580 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "wrap-lines", (GObject*) _tmp56_, "wrap-lines", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp57_ = renderer_text;
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "tab-width", (GObject*) _tmp57_, "tab-width", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 2869 "gitg-diff-view.c"
				}
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp58_ = i;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp59_ = gee_abstract_collection_get_size ((GeeCollection*) _data8_->files);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp60_ = _tmp59_;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp58_ == (_tmp60_ - 1)) {
#line 2879 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp61_ = NULL;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp61_ = file;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gtk_widget_set_vexpand ((GtkWidget*) _tmp61_, TRUE);
#line 2885 "gitg-diff-view.c"
				}
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp62_ = self->priv->d_grid_files;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp63_ = file;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
#line 591 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp64_ = file;
#line 591 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				g_signal_connect_object ((GObject*) _tmp64_, "notify::expanded", (GCallback) _gitg_diff_view_auto_update_expanded_g_object_notify, self, 0);
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (renderer_text);
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_free0 (path);
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (file);
#line 2903 "gitg-diff-view.c"
			}
		}
	}
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (was_expanded);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_list_free0 (file_widgets);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block8_data_unref (_data8_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_ = NULL;
#line 2915 "gitg-diff-view.c"
}


static void gitg_diff_view_auto_update_expanded (GitgDiffView* self) {
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 595 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 2928 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2936 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 2940 "gitg-diff-view.c"
			{
				GtkWidget* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp4_) {
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_auto_change_expanded (self, FALSE);
#line 602 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_list_free0 (file_collection);
#line 602 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					return;
#line 2959 "gitg-diff-view.c"
				}
			}
		}
#line 597 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 2965 "gitg-diff-view.c"
	}
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_change_expanded (self, TRUE);
#line 2969 "gitg-diff-view.c"
}


static gboolean ___lambda64_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_reveal_options_timeout = (guint) 0;
#line 659 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 659 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2986 "gitg-diff-view.c"
}


static gboolean ____lambda64__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda64_ ((GitgDiffView*) self);
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2995 "gitg-diff-view.c"
}


static gboolean _____lambda65_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 676 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_unreveal_options_timeout = (guint) 0;
#line 677 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 677 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 678 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 678 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3012 "gitg-diff-view.c"
}


static gboolean ______lambda65__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda65_ ((GitgDiffView*) self);
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3021 "gitg-diff-view.c"
}


static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey) {
	void* data = NULL;
	GdkWindow* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	GtkWidget* w = NULL;
	void* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation revealer_alloc = {0};
	GtkEventBox* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	GtkRevealer* _tmp13_ = NULL;
	GtkAllocation _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GtkRevealer* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 629 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 629 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (window != NULL);
#line 632 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = window;
#line 632 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gdk_window_get_user_data (_tmp0_, &_tmp1_);
#line 632 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	data = _tmp1_;
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = data;
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	w = _tmp3_;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = w;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_ == NULL) {
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (w);
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 3077 "gitg-diff-view.c"
	}
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = w;
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_event_box;
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ex;
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = ey;
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_translate_coordinates (_tmp5_, (GtkWidget*) _tmp6_, _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	x = _tmp9_;
#line 642 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	y = _tmp10_;
#line 646 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = self->priv->d_event_box;
#line 646 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp11_, &_tmp12_);
#line 646 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	alloc = _tmp12_;
#line 647 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = self->priv->d_revealer_options;
#line 647 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp13_, &_tmp14_);
#line 647 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	revealer_alloc = _tmp14_;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = self->priv->d_revealer_options;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = gtk_revealer_get_reveal_child (_tmp18_);
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp20_ = _tmp19_;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_tmp20_) {
#line 3113 "gitg-diff-view.c"
		gint _tmp21_ = 0;
		GtkAllocation _tmp22_ = {0};
		gint _tmp23_ = 0;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = y;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = alloc;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = _tmp22_.height;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = _tmp21_ >= (_tmp23_ - 18);
#line 3125 "gitg-diff-view.c"
	} else {
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = FALSE;
#line 3129 "gitg-diff-view.c"
	}
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp17_) {
#line 3133 "gitg-diff-view.c"
		gint _tmp24_ = 0;
		GtkAllocation _tmp25_ = {0};
		gint _tmp26_ = 0;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = x;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = alloc;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = _tmp25_.width;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = _tmp24_ >= (_tmp26_ - 150);
#line 3145 "gitg-diff-view.c"
	} else {
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = FALSE;
#line 3149 "gitg-diff-view.c"
	}
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_) {
#line 3153 "gitg-diff-view.c"
		guint _tmp27_ = 0U;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp27_ = self->priv->d_reveal_options_timeout;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp27_ == ((guint) 0);
#line 3159 "gitg-diff-view.c"
	} else {
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = FALSE;
#line 3163 "gitg-diff-view.c"
	}
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp15_) {
#line 3167 "gitg-diff-view.c"
		guint _tmp28_ = 0U;
		guint _tmp30_ = 0U;
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = self->priv->d_unreveal_options_timeout;
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp28_ != ((guint) 0)) {
#line 3174 "gitg-diff-view.c"
			guint _tmp29_ = 0U;
#line 653 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp29_ = self->priv->d_unreveal_options_timeout;
#line 653 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_source_remove (_tmp29_);
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			self->priv->d_unreveal_options_timeout = (guint) 0;
#line 3182 "gitg-diff-view.c"
		}
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda64__gsource_func, g_object_ref (self), g_object_unref);
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_reveal_options_timeout = _tmp30_;
#line 3188 "gitg-diff-view.c"
	} else {
		GtkRevealer* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
#line 663 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp31_ = self->priv->d_revealer_options;
#line 663 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp32_ = gtk_revealer_get_reveal_child (_tmp31_);
#line 663 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp33_ = _tmp32_;
#line 663 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp33_) {
#line 3201 "gitg-diff-view.c"
			gboolean above = FALSE;
			gint _tmp34_ = 0;
			GtkAllocation _tmp35_ = {0};
			gint _tmp36_ = 0;
			GtkAllocation _tmp37_ = {0};
			gint _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp34_ = y;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp35_ = alloc;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp36_ = _tmp35_.height;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp37_ = revealer_alloc;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp38_ = _tmp37_.height;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			above = _tmp34_ <= ((_tmp36_ - 6) - _tmp38_);
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp40_ = above;
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp40_) {
#line 3226 "gitg-diff-view.c"
				guint _tmp41_ = 0U;
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = self->priv->d_unreveal_options_timeout;
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = _tmp41_ == ((guint) 0);
#line 3232 "gitg-diff-view.c"
			} else {
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = FALSE;
#line 3236 "gitg-diff-view.c"
			}
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp39_) {
#line 3240 "gitg-diff-view.c"
				guint _tmp42_ = 0U;
				guint _tmp44_ = 0U;
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = self->priv->d_reveal_options_timeout;
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp42_ != ((guint) 0)) {
#line 3247 "gitg-diff-view.c"
					guint _tmp43_ = 0U;
#line 671 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = self->priv->d_reveal_options_timeout;
#line 671 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp43_);
#line 672 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_reveal_options_timeout = (guint) 0;
#line 3255 "gitg-diff-view.c"
				}
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp44_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ______lambda65__gsource_func, g_object_ref (self), g_object_unref);
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				self->priv->d_unreveal_options_timeout = _tmp44_;
#line 3261 "gitg-diff-view.c"
			} else {
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp46_ = above;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp46_) {
#line 3269 "gitg-diff-view.c"
					guint _tmp47_ = 0U;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp47_ = self->priv->d_unreveal_options_timeout;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = _tmp47_ != ((guint) 0);
#line 3275 "gitg-diff-view.c"
				} else {
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = FALSE;
#line 3279 "gitg-diff-view.c"
				}
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp45_) {
#line 3283 "gitg-diff-view.c"
					guint _tmp48_ = 0U;
#line 683 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp48_ = self->priv->d_unreveal_options_timeout;
#line 683 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp48_);
#line 684 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_unreveal_options_timeout = (guint) 0;
#line 3291 "gitg-diff-view.c"
				}
			}
		}
	}
#line 629 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (w);
#line 3298 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3334 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_leave_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3343 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 697 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 697 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 697 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 700 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 700 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3379 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_enter_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3388 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event) {
	gboolean result = FALSE;
	GdkEventMotion* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventMotion* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3424 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_construct (GType object_type) {
	GitgDiffView * self = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) g_object_new (object_type, NULL);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self;
#line 3434 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_new (void) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return gitg_diff_view_construct (GITG_TYPE_DIFF_VIEW);
#line 3441 "gitg-diff-view.c"
}


GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self) {
	GgitDiffOptions* result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp2_ = NULL;
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_options;
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ == NULL) {
#line 3455 "gitg-diff-view.c"
		GgitDiffOptions* _tmp1_ = NULL;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = ggit_diff_options_new ();
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_options);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_options = _tmp1_;
#line 3463 "gitg-diff-view.c"
	}
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_options;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp2_;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3471 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_has_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_has_selection;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3486 "gitg-diff-view.c"
}


static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_has_selection = _tmp0_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "has-selection");
#line 3500 "gitg-diff-view.c"
}


GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self) {
	GgitDiff* result;
	GgitDiff* _tmp0_ = NULL;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3515 "gitg-diff-view.c"
}


void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value) {
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3530 "gitg-diff-view.c"
		GgitDiff* _tmp2_ = NULL;
		GgitDiff* _tmp3_ = NULL;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp3_;
#line 81 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 81 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = NULL;
#line 3545 "gitg-diff-view.c"
	}
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "diff");
#line 3551 "gitg-diff-view.c"
}


GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3566 "gitg-diff-view.c"
}


void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value) {
	GitgCommit* _tmp0_ = NULL;
	GitgCommit* _tmp1_ = NULL;
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3581 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
		GitgCommit* _tmp3_ = NULL;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = _tmp3_;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = NULL;
#line 3596 "gitg-diff-view.c"
	}
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "commit");
#line 3602 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_wrap_lines;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3617 "gitg-diff-view.c"
}


void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = _tmp0_;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "wrap-lines");
#line 3631 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_staged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_staged;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3646 "gitg-diff-view.c"
}


void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = _tmp0_;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "staged");
#line 3660 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_unstaged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_unstaged;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3675 "gitg-diff-view.c"
}


void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "unstaged");
#line 3689 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_show_parents (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_show_parents;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3704 "gitg-diff-view.c"
}


void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "show-parents");
#line 3718 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_default_collapse_all;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3733 "gitg-diff-view.c"
}


void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "default-collapse-all");
#line 3747 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_use_gravatar;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3762 "gitg-diff-view.c"
}


void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "use-gravatar");
#line 3776 "gitg-diff-view.c"
}


gint gitg_diff_view_get_tab_width (GitgDiffView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_tab_width;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3791 "gitg-diff-view.c"
}


void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value) {
	gint _tmp0_ = 0;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "tab-width");
#line 3805 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_handle_selection;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3820 "gitg-diff-view.c"
}


void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "handle-selection");
#line 3834 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_highlight (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_highlight;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3849 "gitg-diff-view.c"
}


void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "highlight");
#line 3863 "gitg-diff-view.c"
}


GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_repository;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3878 "gitg-diff-view.c"
}


void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_repository = _tmp1_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "repository");
#line 3897 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_new_is_workdir;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3912 "gitg-diff-view.c"
}


void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_new_is_workdir = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "new-is-workdir");
#line 3926 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_flag_get (self, GGIT_DIFF_IGNORE_WHITESPACE);
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3941 "gitg-diff-view.c"
}


void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_flag_set (self, GGIT_DIFF_IGNORE_WHITESPACE, _tmp0_);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "ignore-whitespace");
#line 3955 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3970 "gitg-diff-view.c"
}


void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3985 "gitg-diff-view.c"
		gboolean _tmp2_ = FALSE;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_changes_inline = _tmp2_;
#line 3991 "gitg-diff-view.c"
	}
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "changes-inline");
#line 3995 "gitg-diff-view.c"
}


gint gitg_diff_view_get_context_lines (GitgDiffView* self) {
	gint result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp3_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4019 "gitg-diff-view.c"
}


void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value) {
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = value;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp3_ != _tmp4_) {
#line 4043 "gitg-diff-view.c"
		GgitDiffOptions* _tmp5_ = NULL;
		GgitDiffOptions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GgitDiffOptions* _tmp8_ = NULL;
		GgitDiffOptions* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = gitg_diff_view_get_options (self);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = _tmp5_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = value;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_context_lines (_tmp6_, _tmp7_);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_get_options (self);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = value;
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_interhunk_lines (_tmp9_, _tmp10_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 4068 "gitg-diff-view.c"
	}
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "context-lines");
#line 4072 "gitg-diff-view.c"
}


static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if ((*length) == (*size)) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*array = g_renew (GitgPatchSet*, *array, (*size) + 1);
#line 4083 "gitg-diff-view.c"
	}
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[(*length)++] = value;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[*length] = NULL;
#line 4089 "gitg-diff-view.c"
}


GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1) {
	GitgPatchSet** result;
	GitgPatchSet** ret = NULL;
	GitgPatchSet** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GtkGrid* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GitgPatchSet** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = g_new0 (GitgPatchSet*, 0 + 1);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret = _tmp0_;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret_length1 = 0;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ret_size_ = ret_length1;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_grid_files;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
#line 4117 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp2_;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 4125 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 4129 "gitg-diff-view.c"
			{
				GitgDiffSelectable* sel = NULL;
				GtkWidget* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffViewFileRenderer* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				GitgDiffSelectable* _tmp9_ = NULL;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = file;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp3_) : NULL);
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = _tmp4_;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp5_) : NULL;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp6_ == NULL) {
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp5_);
#line 4151 "gitg-diff-view.c"
				}
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				sel = _tmp6_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = sel;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp9_ != NULL) {
#line 4159 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = sel;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp11_ = gitg_diff_selectable_get_has_selection (_tmp10_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp11_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = _tmp12_;
#line 4171 "gitg-diff-view.c"
				} else {
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = FALSE;
#line 4175 "gitg-diff-view.c"
				}
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 4179 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp13_ = NULL;
					GitgPatchSet* _tmp14_ = NULL;
					GitgPatchSet* _tmp15_ = NULL;
					GitgPatchSet* _tmp16_ = NULL;
					GitgPatchSetPatch* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = sel;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = gitg_diff_selectable_get_selection (_tmp13_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = _tmp14_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = _tmp16_->patches;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17__length1 = _tmp16_->patches_length1;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = _tmp17__length1 != 0;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_gitg_patch_set_unref0 (_tmp16_);
#line 4202 "gitg-diff-view.c"
				} else {
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = FALSE;
#line 4206 "gitg-diff-view.c"
				}
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp7_) {
#line 4210 "gitg-diff-view.c"
					GitgPatchSet** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GitgDiffSelectable* _tmp19_ = NULL;
					GitgPatchSet* _tmp20_ = NULL;
					GitgPatchSet* _tmp21_ = NULL;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = ret;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18__length1 = ret_length1;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = sel;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp20_ = gitg_diff_selectable_get_selection (_tmp19_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp21_ = _tmp20_;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 4228 "gitg-diff-view.c"
				}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (sel);
#line 4232 "gitg-diff-view.c"
			}
		}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 4237 "gitg-diff-view.c"
	}
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = ret;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22__length1 = ret_length1;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (result_length1) {
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*result_length1 = _tmp22__length1;
#line 4247 "gitg-diff-view.c"
	}
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp22_;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4253 "gitg-diff-view.c"
}


static void gitg_diff_view_real_options_changed (GitgDiffView* self) {
	GitgCommit* _tmp0_ = NULL;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update (self, TRUE);
#line 4265 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_class_init (GitgDiffViewClass * klass) {
	gint GitgDiffView_private_offset;
	GError * _inner_error_ = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDiffViewPrivate));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->constructed = gitg_diff_view_real_constructed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->dispose = gitg_diff_view_real_dispose;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GitgDiffViewClass *) klass)->options_changed = gitg_diff_view_real_options_changed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_get_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_set_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_finalize;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_OPTIONS, g_param_spec_object ("options", "options", "options", ggit_diff_options_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DIFF, g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT, g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_WRAP_LINES, g_param_spec_boolean ("wrap-lines", "wrap-lines", "wrap-lines", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_STAGED, g_param_spec_boolean ("staged", "staged", "staged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_UNSTAGED, g_param_spec_boolean ("unstaged", "unstaged", "unstaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_SHOW_PARENTS, g_param_spec_boolean ("show-parents", "show-parents", "show-parents", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL, g_param_spec_boolean ("default-collapse-all", "default-collapse-all", "default-collapse-all", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_USE_GRAVATAR, g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_TAB_WIDTH, g_param_spec_int ("tab-width", "tab-width", "tab-width", G_MININT, G_MAXINT, 4, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HANDLE_SELECTION, g_param_spec_boolean ("handle-selection", "handle-selection", "handle-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HIGHLIGHT, g_param_spec_boolean ("highlight", "highlight", "highlight", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_NEW_IS_WORKDIR, g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_IGNORE_WHITESPACE, g_param_spec_boolean ("ignore-whitespace", "ignore-whitespace", "ignore-whitespace", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CHANGES_INLINE, g_param_spec_boolean ("changes-inline", "changes-inline", "changes-inline", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CONTEXT_LINES, g_param_spec_int ("context-lines", "context-lines", "context-lines", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	GitgDiffView_private_offset = g_type_class_get_instance_private_offset (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view.ui");
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_new ("options_changed", GITG_TYPE_DIFF_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgDiffViewClass, options_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "commit_details", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_commit_details));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolledwindow", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_scrolledwindow));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_files", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_grid_files));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_box", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_event_box));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_revealer_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_view_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_diff_view_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view_message", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_text_view_message));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event));
#line 4351 "gitg-diff-view.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = g_regex_new (".*[\\R\\s]*(?P<message>(?:.|\\R)*?)\\s*$", 0, 0, &_inner_error_);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp1_;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4362 "gitg-diff-view.c"
			goto __catch34_g_error;
		}
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _tmp0_;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = NULL;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (gitg_diff_view_s_message_regexp);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_s_message_regexp = _tmp2_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (_tmp0_);
#line 4375 "gitg-diff-view.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		e = _inner_error_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = stderr;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = e;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = _tmp4_->message;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = string_to_string (_tmp5_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = g_strconcat ("Failed to compile regex: ", _tmp6_, "\n", NULL);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = _tmp7_;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		fprintf (_tmp3_, "%s", _tmp8_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (_tmp8_);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_error_free0 (e);
#line 4409 "gitg-diff-view.c"
	}
	__finally34:
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 4418 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_instance_init (GitgDiffView * self) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv = GITG_DIFF_VIEW_GET_PRIVATE (self);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = TRUE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = TRUE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = TRUE;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = 4;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = TRUE;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_OPTIONS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 4450 "gitg-diff-view.c"
}


static void gitg_diff_view_finalize (GObject* obj) {
	GitgDiffView * self;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit_details);
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_scrolledwindow);
#line 30 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_grid_files);
#line 33 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_event_box);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_revealer_options);
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff_view_options);
#line 42 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_text_view_message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff);
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit);
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_options);
#line 47 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->finalize (obj);
#line 4484 "gitg-diff-view.c"
}


GType gitg_diff_view_get_type (void) {
	static volatile gsize gitg_diff_view_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_diff_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffView), 0, (GInstanceInitFunc) gitg_diff_view_instance_init, NULL };
		GType gitg_diff_view_type_id;
		gitg_diff_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffView", &g_define_type_info, 0);
		g_once_init_leave (&gitg_diff_view_type_id__volatile, gitg_diff_view_type_id);
	}
	return gitg_diff_view_type_id__volatile;
}


static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_OPTIONS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_options (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_has_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_diff (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_commit (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_wrap_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_staged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_unstaged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_show_parents (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_default_collapse_all (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_use_gravatar (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_tab_width (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_handle_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_highlight (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_repository (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_new_is_workdir (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_ignore_whitespace (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_changes_inline (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_context_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4613 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4619 "gitg-diff-view.c"
	}
}


static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_diff (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_commit (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_wrap_lines (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_staged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_unstaged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_show_parents (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_default_collapse_all (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_use_gravatar (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_tab_width (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_handle_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_highlight (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_repository (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_new_is_workdir (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_ignore_whitespace (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_changes_inline (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_context_lines (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4731 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4737 "gitg-diff-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



