---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, tables des matières, titre
---

# Comment changer le titre de la table des matières ?

## Avec les commandes de base

Cette technique n'est qu'un cas particulier de la méthode présentée 
à la question 
"[](/3_composition/langues/traduire_le_titre_de_table_des_matieres_ou_bibliographie)". 
Il suffit ainsi de redéfinir la commande `\contentsname`. Par exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \renewcommand*{\contentsname}{Plan du document}

\begin{document}
\section{De la brièveté}
Tout est dit.
\tableofcontents
\end{document}
```


## Avec l'extension <ctanpkg:babel>

L'extension <ctanpkg:babel> permet d'utiliser plusieurs langues. 
Son utilisation impose une manière particulière de redéfinir le titre 
de la table des matières. Par exemple, pour le français :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)  
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \addto\captionsfrench{%
    \renewcommand*{\contentsname}{Plan du document}}

\begin{document}
\section{De la brièveté}
Tout est dit.
\tableofcontents
\end{document}
```