# $Id: hash.rb,v 1.2 2002/04/14 19:50:10 knu Exp $

require 'features/ruby18/base'

class Hash
  alias __ruby16_select select
  alias __ruby16_update update

  def select(*x, &block)
    if block
      __ruby16_select(*x, &block)
    else
      indexes(*x)
    end
  end

  def update(h, &block)
    if block
      h.each { |k, v|
	if key?(k)
	  self[k] = block.call(k, self[k], v)
	else
	  self[k] = v
	end
      }

      self
    else
      __ruby16_update(h)
    end
  end
end

class << ENV
  alias __ruby16_select select

  def select(*x, &block)
    if block
      __ruby16_select(*x, &block)
    else
      indexes(*x)
    end
  end
end
