# $Id: tc_struct.rb,v 1.1 2002/04/14 14:01:30 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/struct'
rescue LoadError; end

class TC_Struct < Test::Unit::TestCase
  def test_instance_each_pair
    struct_class = Struct.new("ABC", :a, :b, :c)
    struct = struct_class.new(1, 2, 3)

    i = 0

    struct.each_pair { |*x|
      case i
      when 0
	assert_equal([:a, 1], x)
      when 1
	assert_equal([:b, 2], x)
      when 2
	assert_equal([:c, 3], x)
      else
	flunk("unexpected pair: #{x.inspect}")
      end
      i += 1
    }

    if i == 0
      flunk("block wasn't yielded once.")
    end
  end

  def test_instance_select
    struct_class = Struct.new("ABC", :a, :b, :c)
    struct = struct_class.new(1, 2, 3)

    assert_equal([2, 1], struct.select(:b, :a))
    assert_equal([1, 3], struct.select { |i| i % 2 == 1 })

    struct_class2 = struct_class.clone
    struct2 = struct_class2.new(1,2,3)

    assert_equal([2, 1], struct2.select(:b, :a))
    assert_equal([1, 3], struct2.select { |i| i % 2 == 1 })
  end
end
