# $Id: tc_numeric.rb,v 1.1 2002/04/08 20:45:23 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/numeric'
rescue LoadError; end

class TC_Numeric < Test::Unit::TestCase
  def test_to_s
    assert_equal('123', 123.to_s)
    assert_equal('123', 123.to_s(10))
    assert_equal('7b', 123.to_s(16))
    assert_equal('173', 123.to_s(8))
    assert_equal('1111011', 123.to_s(2))
    assert_equal('10000000000000000', (2**64).to_s(16))

    assert_raises(ArgumentError) { 123.to_s(4) }
  end
end
