/* Test roundeven.
   Copyright (C) 1997-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_f_f_data roundeven_test_data[] =
  {
    TEST_f_f (roundeven, plus_zero, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, minus_zero, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_f (roundeven, -snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),

    TEST_f_f (roundeven, min_subnorm_value, 0.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, min_value, 0.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p23, 0x1p23, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p24, 0x1p24, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p25, 0x1p25, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p52, 0x1p52, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p53, 0x1p53, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p54, 0x1p54, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p63, 0x1p63, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p64, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p65, 0x1p65, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p105, 0x1p105, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p106, 0x1p106, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p107, 0x1p107, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p112, 0x1p112, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p113, 0x1p113, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1p114, 0x1p114, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, max_value, max_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -min_subnorm_value, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -min_value, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p23, -0x1p23, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p24, -0x1p24, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p25, -0x1p25, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p52, -0x1p52, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p53, -0x1p53, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p54, -0x1p54, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p63, -0x1p63, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p64, -0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p65, -0x1p65, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p105, -0x1p105, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p106, -0x1p106, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p107, -0x1p107, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p112, -0x1p112, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p113, -0x1p113, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1p114, -0x1p114, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -max_value, -max_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (roundeven, 0.1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.2, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.25, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.25, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.499, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.499, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.5, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.5, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.501, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.501, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.625, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.625, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.75, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.75, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0.8, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0.8, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1.25, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1.25, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1.499, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1.499, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1.5, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1.5, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1.501, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1.501, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 1.75, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -1.75, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2.25, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2.25, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2.499, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2.499, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2.5, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2.5, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2.501, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2.501, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 2.75, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -2.75, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3.25, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3.25, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3.499, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3.499, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3.5, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3.5, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3.501, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3.501, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 3.75, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -3.75, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4.25, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4.25, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4.499, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4.499, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4.5, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4.5, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4.501, 5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4.501, -5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 4.75, 5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -4.75, -5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5.25, 5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5.25, -5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5.499, 5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5.499, -5.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5.5, 6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5.5, -6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5.501, 6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5.501, -6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 5.75, 6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -5.75, -6.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* 0.5, 1.5, 2.5, 3.5 +/- 1ulp.  */
    TEST_f_f (roundeven, 0x0.ffffffp-1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x0.ffffffp-1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1.000002p-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1.000002p-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2.fffffcp-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2.fffffcp-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3.000004p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3.000004p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4.fffff8p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4.fffff8p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x5.000008p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x5.000008p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x6.fffff8p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x6.fffff8p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7.000008p-1, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7.000008p-1, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_f_f (roundeven, 0x0.fffffffffffff8p-1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x0.fffffffffffff8p-1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1.0000000000001p-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1.0000000000001p-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2.ffffffffffffep-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2.ffffffffffffep-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3.0000000000002p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3.0000000000002p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4.ffffffffffffcp-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4.ffffffffffffcp-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x5.0000000000004p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x5.0000000000004p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x6.ffffffffffffcp-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x6.ffffffffffffcp-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7.0000000000004p-1, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7.0000000000004p-1, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_f (roundeven, 0x0.ffffffffffffffffp-1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x0.ffffffffffffffffp-1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1.0000000000000002p-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1.0000000000000002p-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2.fffffffffffffffcp-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2.fffffffffffffffcp-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3.0000000000000004p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3.0000000000000004p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4.fffffffffffffff8p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4.fffffffffffffff8p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x5.0000000000000008p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x5.0000000000000008p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x6.fffffffffffffff8p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x6.fffffffffffffff8p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7.0000000000000008p-1, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7.0000000000000008p-1, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_f (roundeven, 0x0.ffffffffffffffffffffffffffcp-1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x0.ffffffffffffffffffffffffffcp-1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1.000000000000000000000000008p-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1.000000000000000000000000008p-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2.ffffffffffffffffffffffffffp-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2.ffffffffffffffffffffffffffp-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3.00000000000000000000000001p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3.00000000000000000000000001p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4.fffffffffffffffffffffffffep-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4.fffffffffffffffffffffffffep-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x5.00000000000000000000000002p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x5.00000000000000000000000002p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x6.fffffffffffffffffffffffffep-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x6.fffffffffffffffffffffffffep-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7.00000000000000000000000002p-1, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7.00000000000000000000000002p-1, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_f (roundeven, 0x0.ffffffffffffffffffffffffffff8p-1, plus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x0.ffffffffffffffffffffffffffff8p-1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1.0000000000000000000000000001p-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1.0000000000000000000000000001p-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2.fffffffffffffffffffffffffffep-1, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2.fffffffffffffffffffffffffffep-1, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3.0000000000000000000000000002p-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3.0000000000000000000000000002p-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4.fffffffffffffffffffffffffffcp-1, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4.fffffffffffffffffffffffffffcp-1, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x5.0000000000000000000000000004p-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x5.0000000000000000000000000004p-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x6.fffffffffffffffffffffffffffcp-1, 3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x6.fffffffffffffffffffffffffffcp-1, -3.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7.0000000000000000000000000004p-1, 4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7.0000000000000000000000000004p-1, -4.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* 31, 32, 33 fractional bits.  */
#if MANT_DIG >= 53
    TEST_f_f (roundeven, 0x200000.7ffffffep0, 0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000.7ffffffep0, -0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000.8p0, 0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000.8p0, -0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000.80000002p0, 0x200001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000.80000002p0, -0x200001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200001.7ffffffep0, 0x200001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200001.7ffffffep0, -0x200001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200001.8p0, 0x200002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200001.8p0, -0x200002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200001.80000002p0, 0x200002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200001.80000002p0, -0x200002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3fffff.fffffffep0, 0x400000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3fffff.fffffffep0, -0x400000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000.7fffffffp0, 0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000.7fffffffp0, -0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000.8p0, 0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000.8p0, -0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000.80000001p0, 0x100001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000.80000001p0, -0x100001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100001.7fffffffp0, 0x100001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100001.7fffffffp0, -0x100001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100001.8p0, 0x100002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100001.8p0, -0x100002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100001.80000001p0, 0x100002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100001.80000001p0, -0x100002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1fffff.ffffffffp0, 0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1fffff.ffffffffp0, -0x200000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000.7fffffff8p0, 0x80000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000.7fffffff8p0, -0x80000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000.8p0, 0x80000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000.8p0, -0x80000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000.800000008p0, 0x80001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000.800000008p0, -0x80001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80001.7fffffff8p0, 0x80001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80001.7fffffff8p0, -0x80001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80001.8p0, 0x80002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80001.8p0, -0x80002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80001.800000008p0, 0x80002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80001.800000008p0, -0x80002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xfffff.ffffffff8p0, 0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xfffff.ffffffff8p0, -0x100000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_f (roundeven, 0x100000000.7ffffffep0, 0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000.7ffffffep0, -0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000.8p0, 0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000.8p0, -0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000.80000002p0, 0x100000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000.80000002p0, -0x100000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000001.7ffffffep0, 0x100000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000001.7ffffffep0, -0x100000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000001.8p0, 0x100000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000001.8p0, -0x100000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000001.80000002p0, 0x100000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000001.80000002p0, -0x100000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffff.fffffffep0, 0x200000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffff.fffffffep0, -0x200000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000.7fffffffp0, 0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000.7fffffffp0, -0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000.8p0, 0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000.8p0, -0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000.80000001p0, 0x80000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000.80000001p0, -0x80000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000001.7fffffffp0, 0x80000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000001.7fffffffp0, -0x80000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000001.8p0, 0x80000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000001.8p0, -0x80000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000001.80000001p0, 0x80000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000001.80000001p0, -0x80000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xffffffff.ffffffffp0, 0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xffffffff.ffffffffp0, -0x100000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000.7fffffff8p0, 0x40000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000.7fffffff8p0, -0x40000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000.8p0, 0x40000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000.8p0, -0x40000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000.800000008p0, 0x40000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000.800000008p0, -0x40000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000001.7fffffff8p0, 0x40000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000001.7fffffff8p0, -0x40000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000001.8p0, 0x40000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000001.8p0, -0x40000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000001.800000008p0, 0x40000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000001.800000008p0, -0x40000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7fffffff.ffffffff8p0, 0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7fffffff.ffffffff8p0, -0x80000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_f (roundeven, 0x4000000000000000000.7ffffffep0, 0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000000.7ffffffep0, -0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4000000000000000000.8p0, 0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000000.8p0, -0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4000000000000000000.80000002p0, 0x4000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000000.80000002p0, -0x4000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4000000000000000001.7ffffffep0, 0x4000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000001.7ffffffep0, -0x4000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4000000000000000001.8p0, 0x4000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000001.8p0, -0x4000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x4000000000000000001.80000002p0, 0x4000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x4000000000000000001.80000002p0, -0x4000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7ffffffffffffffffff.fffffffep0, 0x8000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7ffffffffffffffffff.fffffffep0, -0x8000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000000.7fffffffp0, 0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000000.7fffffffp0, -0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000000.8p0, 0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000000.8p0, -0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000000.80000001p0, 0x2000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000000.80000001p0, -0x2000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000001.7fffffffp0, 0x2000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000001.7fffffffp0, -0x2000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000001.8p0, 0x2000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000001.8p0, -0x2000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000000001.80000001p0, 0x2000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000000001.80000001p0, -0x2000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3ffffffffffffffffff.ffffffffp0, 0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3ffffffffffffffffff.ffffffffp0, -0x4000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000000.7fffffff8p0, 0x1000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000000.7fffffff8p0, -0x1000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000000.8p0, 0x1000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000000.8p0, -0x1000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000000.800000008p0, 0x1000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000000.800000008p0, -0x1000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000001.7fffffff8p0, 0x1000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000001.7fffffff8p0, -0x1000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000001.8p0, 0x1000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000001.8p0, -0x1000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000000001.800000008p0, 0x1000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000000001.800000008p0, -0x1000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffffffffffffff.ffffffff8p0, 0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffffffffffffff.ffffffff8p0, -0x2000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_f (roundeven, 0x200000000000000000000.7ffffffep0, 0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000.7ffffffep0, -0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000.8p0, 0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000.8p0, -0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000.80000002p0, 0x200000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000.80000002p0, -0x200000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000001.7ffffffep0, 0x200000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000001.7ffffffep0, -0x200000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000001.8p0, 0x200000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000001.8p0, -0x200000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000001.80000002p0, 0x200000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000001.80000002p0, -0x200000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3ffffffffffffffffffff.fffffffep0, 0x400000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3ffffffffffffffffffff.fffffffep0, -0x400000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000000.7fffffffp0, 0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000000.7fffffffp0, -0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000000.8p0, 0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000000.8p0, -0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000000.80000001p0, 0x100000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000000.80000001p0, -0x100000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000001.7fffffffp0, 0x100000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000001.7fffffffp0, -0x100000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000001.8p0, 0x100000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000001.8p0, -0x100000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x100000000000000000001.80000001p0, 0x100000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x100000000000000000001.80000001p0, -0x100000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffffffffffffffff.ffffffffp0, 0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffffffffffffffff.ffffffffp0, -0x200000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000000.7fffffff8p0, 0x80000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000000.7fffffff8p0, -0x80000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000000.8p0, 0x80000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000000.8p0, -0x80000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000000.800000008p0, 0x80000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000000.800000008p0, -0x80000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000001.7fffffff8p0, 0x80000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000001.7fffffff8p0, -0x80000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000001.8p0, 0x80000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000001.8p0, -0x80000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x80000000000000000001.800000008p0, 0x80000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x80000000000000000001.800000008p0, -0x80000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xffffffffffffffffffff.ffffffff8p0, 0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xffffffffffffffffffff.ffffffff8p0, -0x100000000000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* 63, 64, 65 fractional bits.  */
#if MANT_DIG >= 106
    TEST_f_f (roundeven, 0x40000000000.7ffffffffffffffep0, 0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000000.7ffffffffffffffep0, -0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000000.8p0, 0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000000.8p0, -0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000000.8000000000000002p0, 0x40000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000000.8000000000000002p0, -0x40000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000001.7ffffffffffffffep0, 0x40000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000001.7ffffffffffffffep0, -0x40000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000001.8p0, 0x40000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000001.8p0, -0x40000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x40000000001.8000000000000002p0, 0x40000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x40000000001.8000000000000002p0, -0x40000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x7ffffffffff.fffffffffffffffep0, 0x80000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x7ffffffffff.fffffffffffffffep0, -0x80000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000000.7fffffffffffffffp0, 0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000000.7fffffffffffffffp0, -0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000000.8p0, 0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000000.8p0, -0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000000.8000000000000001p0, 0x20000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000000.8000000000000001p0, -0x20000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000001.7fffffffffffffffp0, 0x20000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000001.7fffffffffffffffp0, -0x20000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000001.8p0, 0x20000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000001.8p0, -0x20000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x20000000001.8000000000000001p0, 0x20000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x20000000001.8000000000000001p0, -0x20000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3ffffffffff.ffffffffffffffffp0, 0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3ffffffffff.ffffffffffffffffp0, -0x40000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000.7fffffffffffffff8p0, 0x10000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000.7fffffffffffffff8p0, -0x10000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000.8p0, 0x10000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000.8p0, -0x10000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000.80000000000000008p0, 0x10000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000.80000000000000008p0, -0x10000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000001.7fffffffffffffff8p0, 0x10000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000001.7fffffffffffffff8p0, -0x10000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000001.8p0, 0x10000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000001.8p0, -0x10000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000001.80000000000000008p0, 0x10000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000001.80000000000000008p0, -0x10000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffffff.ffffffffffffffff8p0, 0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffffff.ffffffffffffffff8p0, -0x20000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_f (roundeven, 0x2000000000000.7ffffffffffffffep0, 0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000.7ffffffffffffffep0, -0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000.8p0, 0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000.8p0, -0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000000.8000000000000002p0, 0x2000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000000.8000000000000002p0, -0x2000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000001.7ffffffffffffffep0, 0x2000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000001.7ffffffffffffffep0, -0x2000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000001.8p0, 0x2000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000001.8p0, -0x2000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x2000000000001.8000000000000002p0, 0x2000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x2000000000001.8000000000000002p0, -0x2000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3ffffffffffff.fffffffffffffffep0, 0x4000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3ffffffffffff.fffffffffffffffep0, -0x4000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000.7fffffffffffffffp0, 0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000.7fffffffffffffffp0, -0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000.8p0, 0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000.8p0, -0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000000.8000000000000001p0, 0x1000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000000.8000000000000001p0, -0x1000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000001.7fffffffffffffffp0, 0x1000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000001.7fffffffffffffffp0, -0x1000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000001.8p0, 0x1000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000001.8p0, -0x1000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1000000000001.8000000000000001p0, 0x1000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1000000000001.8000000000000001p0, -0x1000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffffffff.ffffffffffffffffp0, 0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffffffff.ffffffffffffffffp0, -0x2000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000000.7fffffffffffffff8p0, 0x800000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000000.7fffffffffffffff8p0, -0x800000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000000.8p0, 0x800000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000000.8p0, -0x800000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000000.80000000000000008p0, 0x800000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000000.80000000000000008p0, -0x800000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000001.7fffffffffffffff8p0, 0x800000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000001.7fffffffffffffff8p0, -0x800000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000001.8p0, 0x800000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000001.8p0, -0x800000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800000000001.80000000000000008p0, 0x800000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800000000001.80000000000000008p0, -0x800000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xffffffffffff.ffffffffffffffff8p0, 0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xffffffffffff.ffffffffffffffff8p0, -0x1000000000000p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Maximum exponent for noninteger values.  */
    TEST_f_f (roundeven, 0x800001p-1, 0x800000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800001p-1, -0x800000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800002p-1, 0x800002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800002p-1, -0x800002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800003p-1, 0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800003p-1, -0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800004p-1, 0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800004p-1, -0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800005p-1, 0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800005p-1, -0x800004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xffffffp-1, 0x1000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xffffffp-1, -0x1000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_f_f (roundeven, 0x10000000000001p-1, 0x10000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000001p-1, -0x10000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000002p-1, 0x10000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000002p-1, -0x10000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000003p-1, 0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000003p-1, -0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000004p-1, 0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000004p-1, -0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000005p-1, 0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000005p-1, -0x10000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1fffffffffffffp-1, 0x20000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1fffffffffffffp-1, -0x20000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_f (roundeven, 0x8000000000000001p-1, 0x8000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000001p-1, -0x8000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000002p-1, 0x8000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000002p-1, -0x8000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000003p-1, 0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000003p-1, -0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000004p-1, 0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000004p-1, -0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000005p-1, 0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000005p-1, -0x8000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0xffffffffffffffffp-1, 0x10000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0xffffffffffffffffp-1, -0x10000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_f (roundeven, 0x200000000000000000000000001p-1, 0x200000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000001p-1, -0x200000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000002p-1, 0x200000000000000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000002p-1, -0x200000000000000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000003p-1, 0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000003p-1, -0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000004p-1, 0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000004p-1, -0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000005p-1, 0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000005p-1, -0x200000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x3ffffffffffffffffffffffffffp-1, 0x400000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x3ffffffffffffffffffffffffffp-1, -0x400000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_f (roundeven, 0x10000000000000000000000000001p-1, 0x10000000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000001p-1, -0x10000000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000002p-1, 0x10000000000000000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000002p-1, -0x10000000000000000000000000002p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000003p-1, 0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000003p-1, -0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000004p-1, 0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000004p-1, -0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000005p-1, 0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000005p-1, -0x10000000000000000000000000004p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x1ffffffffffffffffffffffffffffp-1, 0x20000000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x1ffffffffffffffffffffffffffffp-1, -0x20000000000000000000000000000p-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Minimum exponent forcing integer values.  */
    TEST_f_f (roundeven, 0x800001p0, 0x800001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800001p0, -0x800001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800002p0, 0x800002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800002p0, -0x800002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x800003p0, 0x800003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x800003p0, -0x800003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_f_f (roundeven, 0x10000000000001p0, 0x10000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000001p0, -0x10000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000002p0, 0x10000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000002p0, -0x10000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000003p0, 0x10000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000003p0, -0x10000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_f (roundeven, 0x8000000000000001p0, 0x8000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000001p0, -0x8000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000002p0, 0x8000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000002p0, -0x8000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x8000000000000003p0, 0x8000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x8000000000000003p0, -0x8000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_f (roundeven, 0x200000000000000000000000001p0, 0x200000000000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000001p0, -0x200000000000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000002p0, 0x200000000000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000002p0, -0x200000000000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x200000000000000000000000003p0, 0x200000000000000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x200000000000000000000000003p0, -0x200000000000000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_f (roundeven, 0x10000000000000000000000000001p0, 0x10000000000000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000001p0, -0x10000000000000000000000000001p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000002p0, 0x10000000000000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000002p0, -0x10000000000000000000000000002p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, 0x10000000000000000000000000003p0, 0x10000000000000000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (roundeven, -0x10000000000000000000000000003p0, -0x10000000000000000000000000003p0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
  };

static void
roundeven_test (void)
{
  ALL_RM_TEST (roundeven, 1, roundeven_test_data, RUN_TEST_LOOP_f_f, END);
}

static void
do_test (void)
{
  roundeven_test ();
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
