/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.Pref;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.prefs.Preferences;

public abstract class PrefPackage
implements Serializable,
Cloneable {
    protected static final String TECH_NODE = "technology/technologies";
    protected static final String USER_NODE = "tool/user";
    protected static final String IO_NODE = "tool/io";

    protected PrefPackage(boolean factory) {
        this(factory ? PrefPackage.getFactoryPrefRoot() : PrefPackage.getPrefRoot());
    }

    protected PrefPackage withField(String fieldName, Object value) {
        try {
            PrefPackage that = (PrefPackage)this.clone();
            Field field = this.findField(fieldName);
            field.setAccessible(true);
            field.set(that, value);
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new AssertionError();
        }
    }

    private Field findField(String fieldName) {
        for (Class<?> cls = this.getClass(); cls != PrefPackage.class; cls = cls.getSuperclass()) {
            try {
                return cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    protected PrefPackage(Preferences prefRoot) {
        Class<?> cls = this.getClass();
        for (Field field : cls.getDeclaredFields()) {
            try {
                StringPref sa;
                DoublePref da;
                LongPref la;
                IntegerPref ia;
                BooleanPref ba = field.getAnnotation(BooleanPref.class);
                if (ba != null) {
                    assert (field.getType() == Boolean.TYPE);
                    field.setAccessible(true);
                    field.setBoolean(this, prefRoot.node(ba.node()).getBoolean(ba.key(), ba.factory()));
                }
                if ((ia = field.getAnnotation(IntegerPref.class)) != null) {
                    assert (field.getType() == Integer.TYPE);
                    field.setAccessible(true);
                    field.setInt(this, prefRoot.node(ia.node()).getInt(ia.key(), ia.factory()));
                }
                if ((la = field.getAnnotation(LongPref.class)) != null) {
                    assert (field.getType() == Long.TYPE);
                    field.setAccessible(true);
                    field.setLong(this, prefRoot.node(la.node()).getLong(la.key(), la.factory()));
                }
                if ((da = field.getAnnotation(DoublePref.class)) != null) {
                    assert (field.getType() == Double.TYPE);
                    field.setAccessible(true);
                    field.setDouble(this, prefRoot.node(da.node()).getDouble(da.key(), da.factory()));
                }
                if ((sa = field.getAnnotation(StringPref.class)) == null) continue;
                assert (field.getType() == String.class);
                field.setAccessible(true);
                field.set(this, prefRoot.node(sa.node()).get(sa.key(), sa.factory()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void putPrefs(Preferences prefRoot, boolean removeDefaults) {
        Class<?> cls = this.getClass();
        for (Field field : cls.getDeclaredFields()) {
            try {
                StringPref sa;
                Preferences prefs;
                DoublePref da;
                LongPref la;
                IntegerPref ia;
                BooleanPref ba = field.getAnnotation(BooleanPref.class);
                if (ba != null) {
                    assert (field.getType() == Boolean.TYPE);
                    field.setAccessible(true);
                    boolean v = field.getBoolean(this);
                    Preferences prefs2 = prefRoot.node(ba.node());
                    if (removeDefaults && v == ba.factory()) {
                        prefs2.remove(ba.key());
                    } else {
                        prefs2.putBoolean(ba.key(), v);
                    }
                }
                if ((ia = field.getAnnotation(IntegerPref.class)) != null) {
                    assert (field.getType() == Integer.TYPE);
                    field.setAccessible(true);
                    int v = field.getInt(this);
                    Preferences prefs3 = prefRoot.node(ia.node());
                    if (removeDefaults && v == ia.factory()) {
                        prefs3.remove(ia.key());
                    } else {
                        prefs3.putInt(ia.key(), v);
                    }
                }
                if ((la = field.getAnnotation(LongPref.class)) != null) {
                    assert (field.getType() == Long.TYPE);
                    field.setAccessible(true);
                    long v = field.getLong(this);
                    Preferences prefs4 = prefRoot.node(la.node());
                    if (removeDefaults && v == la.factory()) {
                        prefs4.remove(la.key());
                    } else {
                        prefs4.putLong(la.key(), v);
                    }
                }
                if ((da = field.getAnnotation(DoublePref.class)) != null) {
                    assert (field.getType() == Double.TYPE);
                    field.setAccessible(true);
                    double v = field.getDouble(this);
                    prefs = prefRoot.node(da.node());
                    if (removeDefaults && v == da.factory()) {
                        prefs.remove(da.key());
                    } else {
                        prefs.putDouble(da.key(), v);
                    }
                }
                if ((sa = field.getAnnotation(StringPref.class)) == null) continue;
                assert (field.getType() == String.class);
                field.setAccessible(true);
                String v = (String)field.get(this);
                prefs = prefRoot.node(sa.node());
                if (removeDefaults && v.equals(sa.factory())) {
                    prefs.remove(sa.key());
                    continue;
                }
                prefs.put(sa.key(), v);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void lowLevelPutPrefs(PrefPackage prefPackage, Preferences prefRoot, boolean removeDefaults) {
        prefPackage.putPrefs(prefRoot, removeDefaults);
    }

    public static Preferences getPrefRoot() {
        return Pref.getPrefRoot();
    }

    public static Preferences getFactoryPrefRoot() {
        return Pref.getFactoryPrefRoot();
    }

    protected String getKey(String what, TechId techId) {
        int len = what.length() + techId.techName.length();
        StringBuilder sb = new StringBuilder(len);
        sb.append(what);
        sb.append(techId.techName);
        assert (sb.length() == len);
        return sb.toString();
    }

    protected String getKey(String what, LayerId layerId) {
        int len = what.length() + layerId.fullName.length() + 1;
        StringBuilder sb = new StringBuilder(len);
        sb.append(what);
        sb.append(layerId.name);
        sb.append("IN");
        sb.append(layerId.techId.techName);
        assert (sb.length() == len);
        return sb.toString();
    }

    protected String getKey(String what, PrimitiveNodeId pnId) {
        int len = what.length() + pnId.fullName.length() + 4;
        StringBuilder sb = new StringBuilder(len);
        sb.append(what);
        sb.append("For");
        sb.append(pnId.name);
        sb.append("IN");
        sb.append(pnId.techId.techName);
        assert (sb.length() == len);
        return sb.toString();
    }

    protected String getKey(String what, ArcProtoId apId) {
        int len = what.length() + apId.fullName.length() + 4;
        StringBuilder sb = new StringBuilder(len);
        sb.append(what);
        sb.append("For");
        sb.append(apId.name);
        sb.append("IN");
        sb.append(apId.techId.techName);
        assert (sb.length() == len);
        return sb.toString();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface BooleanPref {
        public String node();

        public String key();

        public boolean factory();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface IntegerPref {
        public String node();

        public String key();

        public int factory();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface LongPref {
        public String node();

        public String key();

        public long factory();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface DoublePref {
        public String node();

        public String key();

        public double factory();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface StringPref {
        public String node();

        public String key();

        public String factory();
    }
}

