/*
* Copyright (C) 2023, KylinSoft Co., Ltd.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
*
*/

#ifndef CALENDARBUTTONTEXT_H
#define CALENDARBUTTONTEXT_H

#include <QObject>
#include <QDateTime>
#include <QGSettings>
#include <QPushButton>
#include "../panel/iukuipanelplugin.h"

#ifdef KDKSYSTIME_FOUND
#include "kysdk/kysdk-system/libkydate.h"
#endif

class CalendarButtonText : public QObject
{
    Q_OBJECT
public:
    CalendarButtonText(IUKUIPanelPlugin *plugin,QPushButton *parent);
    ~CalendarButtonText();
    enum DateStyle{YEAR_MON_DAY=0, MON_DAY};

public:
    QString getBtnText();
    QString getEnUsBtnText();
    QString getZhCnBtnText();
    QString getOtherBtnText();
    QString getToolTipText();
    QString getEnUsToolTipText();
    QString getZhCnToolTipText();
    QString getBoCnToolTipText();
    QString getOtherToolTipText();

private:
    QString getAmPm();
    QString getTime();
    QString getWeek();
    QString getDate(DateStyle dateStyle);
    void updateFontSize(QString btnText);
    void setOptimalFont(QStringList textList, int btnMaxLength);
    QString getFormatsLocale();

public:
    QDateTime m_dataTime;
    QPushButton *m_parent;
    IUKUIPanelPlugin * m_plugin;
    QGSettings *m_timeFormat = nullptr;
    QGSettings *m_fontGsettings = nullptr;
    QGSettings *m_panelGsettings = nullptr;
};

#endif // CALENDARBUTTONTEXT_H
