/*---------------------------------------------------------------------------*\
**$Author: antanas $
**$Date: 2021-02-25 15:58:35 -0500 (Thu, 25 Feb 2021) $
**$Revision: 256 $
**$URL: svn://www.crystallography.net/smiles-scripts/branches/use-system-dependencies/src/cdkcif2sdf.java $
\*---------------------------------------------------------------------------*/

// This CLI Java program reads a CIF (Crystallographic Information File,
// https://www.iucr.org/resources/cif) and converts it to the SDF format.

import org.openscience.cdk.ChemFile;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.CIFReader;
import org.openscience.cdk.io.SDFWriter;

import javax.vecmath.Point3d;
import java.io.FileReader;

import static net.crystallography.helpers.cdk.OrthogonaliseAtomCoordinates.computeOrthogonalCoordinates;

@SuppressWarnings("ALL")
public class cdkcif2sdf {

    static OptionValue smilesOption = new OptionValue();
    static Option options[] = {
            new VersionOption ( null, "--version", OptionType.OT_FUNCTION ),
            new CDKCif2SdfHelp( null, "--help",    OptionType.OT_FUNCTION ),
    };

    private static final String progName = CDKCif2SmilesHelp.progName;

    @SuppressWarnings("SingleStatementInBlock")
    public static void main(String[] argv ) {
        String filenames[] = null;
        try {
            filenames = SOptions.get_options( argv, options );
        }
        catch (SOptionsException e) {
            System.err.println( progName + ": " + e.getMessage() );
            System.exit(1);
        }

        if( filenames == null || filenames.length == 0 ) {
            filenames = new String[] { "-" };
        }

        try {
            SDFWriter sw = new SDFWriter( System.out );
            for( String filename : filenames ) {
                try {
                    CIFReader reader;
                    if (filename.equals("-")) {
                        reader = new CIFReader(System.in);
                    } else {
                        reader = new CIFReader(new FileReader(filename));
                    }

                    ChemFile cifFile = reader.read(new ChemFile());

                    assert cifFile != null;
                    for ( IChemSequence sequence : cifFile.chemSequences() ) {
                        assert sequence.chemModels() != null;
                        for (IChemModel model : sequence.chemModels()) {
                            ICrystal crystal = model.getCrystal();
                            assert crystal != null : "Crystal is null";
                            computeOrthogonalCoordinates( crystal );
                            //-------------------------------------------------
                            // Print out the chemical SDF format file:
                            sw.write( crystal );
                        } // for
                    } // for
                } // try
                catch(Exception e) {
                    System.err.println( progName + ": " + "WARNING, " + e );
                }
            } // for
            sw.close();
        }
        catch(Exception e) {
            System.err.println( progName + ": " + "WARNING, " + e );
        }
    }

}
