//------------------------------------------------------------------------------
// <copyright file="ComponentCollection.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
// <autogenerated>
//     This class was generated by a tool.
//     Runtime Version: 1.0.2204.0
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------


using System.Diagnostics.CodeAnalysis;

/*
 This class has the HostProtectionAttribute. The purpose of this attribute is to enforce host-specific programming model guidelines, not security behavior. 
 Suppress FxCop message - BUT REVISIT IF ADDING NEW SECURITY ATTRIBUTES.
*/
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope="member", Target="System.ComponentModel.ComponentCollection..ctor(System.ComponentModel.IComponent[])")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope="member", Target="System.ComponentModel.ComponentCollection.get_Item(System.String):System.ComponentModel.IComponent")]


namespace System.ComponentModel {
    using System;
    using System.Collections;
    using System.ComponentModel;
    using System.Globalization;
    using System.Security.Permissions;
    
    /** The component in the container identified by name. */
    /// <devdoc>
    ///    <para>
    ///       Gets a specific <see cref='System.ComponentModel.Component'/> in the <see cref='System.ComponentModel.Container'/>
    ///       .
    ///    </para>
    /// </devdoc>
    [System.Runtime.InteropServices.ComVisible(true)]
    [HostProtection(Synchronization=true)]
    public class ComponentCollection : ReadOnlyCollectionBase {
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        public ComponentCollection(IComponent[] components) {
            InnerList.AddRange(components);
        }

        /** The component in the container identified by name. */
        /// <devdoc>
        ///    <para>
        ///       Gets a specific <see cref='System.ComponentModel.Component'/> in the <see cref='System.ComponentModel.Container'/>
        ///       .
        ///    </para>
        /// </devdoc>
        public virtual IComponent this[string name] {
            get {
                if (name != null) {
                    IList list = InnerList;
                    foreach(IComponent comp in list) {
                        if (comp != null && comp.Site != null && comp.Site.Name != null && string.Equals(comp.Site.Name, name, StringComparison.OrdinalIgnoreCase)) {
                            return comp;
                        }
                    }
                }
                return null;
            }
        }
        
        /** The component in the container identified by index. */
        /// <devdoc>
        ///    <para>
        ///       Gets a specific <see cref='System.ComponentModel.Component'/> in the <see cref='System.ComponentModel.Container'/>
        ///       .
        ///    </para>
        /// </devdoc>
        public virtual IComponent this[int index] {
            get {
                return (IComponent)InnerList[index];
            }
        }
        
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        public void CopyTo(IComponent[] array, int index) {
            InnerList.CopyTo(array, index);
        }
    }
}

