/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;

public class SubAnt
extends Task {
    private Path buildpath;
    private String target = null;
    private String antfile = "build.xml";
    private File genericantfile = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private boolean failOnError = true;
    private String output = null;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Vector propertySets = new Vector();

    public void execute() {
        if (this.buildpath == null) {
            throw new BuildException("No buildpath specified");
        }
        String[] filenames = this.buildpath.list();
        int count = filenames.length;
        if (count < 1) {
            this.log("No sub-builds to iterate on", 1);
            return;
        }
        BuildException buildException = null;
        int i = 0;
        while (i < count) {
            File file = null;
            Throwable thrownException = null;
            try {
                File directory = null;
                file = new File(filenames[i]);
                if (file.isDirectory()) {
                    if (this.genericantfile != null) {
                        directory = file;
                        file = this.genericantfile;
                    } else {
                        file = new File(file, this.antfile);
                    }
                }
                this.execute(file, directory);
            }
            catch (RuntimeException ex) {
                if (!this.getProject().isKeepGoingMode()) {
                    throw ex;
                }
                thrownException = ex;
            }
            catch (Throwable ex) {
                if (!this.getProject().isKeepGoingMode()) {
                    throw new BuildException(ex);
                }
                thrownException = ex;
            }
            if (thrownException != null) {
                if (thrownException instanceof BuildException) {
                    this.log("File '" + file + "' failed with message '" + thrownException.getMessage() + "'.", 0);
                    if (buildException == null) {
                        buildException = (BuildException)thrownException;
                    }
                } else {
                    this.log("Target '" + file + "' failed with message '" + thrownException.getMessage() + "'.", 0);
                    thrownException.printStackTrace(System.err);
                    if (buildException == null) {
                        buildException = new BuildException(thrownException);
                    }
                }
            }
            ++i;
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    private void execute(File file, File directory) throws BuildException {
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            String msg = "Invalid file: " + file;
            if (this.failOnError) {
                throw new BuildException(msg);
            }
            this.log(msg, 1);
            return;
        }
        Ant ant = this.createAntTask(directory);
        String antfilename = null;
        try {
            antfilename = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        ant.setAntfile(antfilename);
        try {
            ant.execute();
        }
        catch (BuildException e) {
            if (this.failOnError) {
                throw e;
            }
            this.log("Failure for target '" + this.target + "' of: " + antfilename + "\n" + e.getMessage(), 1);
        }
    }

    public void setAntfile(String antfile) {
        this.antfile = antfile;
    }

    public void setGenericAntfile(File afile) {
        this.genericantfile = afile;
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public void setInheritall(boolean b) {
        this.inheritAll = b;
    }

    public void setInheritrefs(boolean b) {
        this.inheritRefs = b;
    }

    public void addProperty(Property p) {
        this.properties.addElement(p);
    }

    public void addReference(Ant.Reference r) {
        this.references.addElement(r);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    public void addDirset(DirSet set) {
        this.getBuildpath().addDirset(set);
    }

    public void addFileset(FileSet set) {
        this.getBuildpath().addFileset(set);
    }

    public void addFilelist(FileList list) {
        this.getBuildpath().addFilelist(list);
    }

    public void setBuildpath(Path s) {
        this.getBuildpath().append(s);
    }

    public Path createBuildpath() {
        return this.getBuildpath().createPath();
    }

    public Path.PathElement createBuildpathElement() {
        return this.getBuildpath().createPathElement();
    }

    private Path getBuildpath() {
        if (this.buildpath == null) {
            this.buildpath = new Path(this.getProject());
        }
        return this.buildpath;
    }

    public void setBuildpathRef(Reference r) {
        this.createBuildpath().setRefid(r);
    }

    private Ant createAntTask(File directory) {
        Ant ant = (Ant)this.getProject().createTask("ant");
        ant.setOwningTarget(this.getOwningTarget());
        ant.setTaskName(this.getTaskName());
        ant.init();
        if (this.target != null && this.target.length() > 0) {
            ant.setTarget(this.target);
        }
        if (this.output != null) {
            ant.setOutput(this.output);
        }
        if (directory != null) {
            ant.setDir(directory);
        }
        ant.setInheritAll(this.inheritAll);
        Enumeration i = this.properties.elements();
        while (i.hasMoreElements()) {
            SubAnt.copyProperty(ant.createProperty(), (Property)i.nextElement());
        }
        Enumeration i2 = this.propertySets.elements();
        while (i2.hasMoreElements()) {
            ant.addPropertyset((PropertySet)i2.nextElement());
        }
        ant.setInheritRefs(this.inheritRefs);
        Enumeration i3 = this.references.elements();
        while (i3.hasMoreElements()) {
            ant.addReference((Ant.Reference)i3.nextElement());
        }
        return ant;
    }

    private static void copyProperty(Property to, Property from) {
        to.setName(from.getName());
        if (from.getValue() != null) {
            to.setValue(from.getValue());
        }
        if (from.getFile() != null) {
            to.setFile(from.getFile());
        }
        if (from.getResource() != null) {
            to.setResource(from.getResource());
        }
        if (from.getPrefix() != null) {
            to.setPrefix(from.getPrefix());
        }
        if (from.getRefid() != null) {
            to.setRefid(from.getRefid());
        }
        if (from.getEnvironment() != null) {
            to.setEnvironment(from.getEnvironment());
        }
        if (from.getClasspath() != null) {
            to.setClasspath(from.getClasspath());
        }
    }
}

