; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no_x86_scrub_sp --no_x86_scrub_mem_shuffle
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop | FileCheck %s --check-prefix=XOP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=INT256,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=INT256,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq | FileCheck %s --check-prefixes=INT256,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefixes=INT256,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vbmi | FileCheck %s --check-prefixes=INT256,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=INT256,AVX512VL,AVX512VLF
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=INT256,AVX512VL,AVX512VLF
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=INT256,AVX512VL,AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+avx512vbmi | FileCheck %s --check-prefixes=INT256,AVX512VL,VLVBMI

define <4 x i64> @var_shuffle_v4i64(<4 x i64> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_v4i64:
; XOP:       # %bb.0:
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm4
; AVX1-NEXT:    vpermilpd %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilpd %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm3, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %index0 = extractelement <4 x i64> %indices, i32 0
  %index1 = extractelement <4 x i64> %indices, i32 1
  %index2 = extractelement <4 x i64> %indices, i32 2
  %index3 = extractelement <4 x i64> %indices, i32 3
  %v0 = extractelement <4 x i64> %v, i64 %index0
  %v1 = extractelement <4 x i64> %v, i64 %index1
  %v2 = extractelement <4 x i64> %v, i64 %index2
  %v3 = extractelement <4 x i64> %v, i64 %index3
  %ret0 = insertelement <4 x i64> undef, i64 %v0, i32 0
  %ret1 = insertelement <4 x i64> %ret0, i64 %v1, i32 1
  %ret2 = insertelement <4 x i64> %ret1, i64 %v2, i32 2
  %ret3 = insertelement <4 x i64> %ret2, i64 %v3, i32 3
  ret <4 x i64> %ret3
}

define <4 x i64> @var_shuffle_zero_v4i64(<4 x i64> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v4i64:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm3 = [3,3]
; XOP-NEXT:    vpcomgtuq %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtuq %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm3, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    # xmm3 = mem[0,0]
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [9223372036854775811,9223372036854775811]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm4, %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775811,9223372036854775811,9223372036854775811,9223372036854775811]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm4, %ymm4
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm3, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_zero_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [3,3,3,3]
; AVX512-NEXT:    vpcmpleuq %zmm2, %zmm1, %k1
; AVX512-NEXT:    vpcmpnleuq %zmm2, %zmm1, %k2
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k2}
; AVX512-NEXT:    vpermq %zmm0, %zmm1, %zmm0 {%k1} {z}
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_zero_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleuq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpermq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %cmp = icmp ugt <4 x i64> %indices, <i64 3, i64 3, i64 3, i64 3>
  %or = select <4 x i1> %cmp, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> %indices
  %idx0 = extractelement <4 x i64> %or, i64 0
  %idx1 = extractelement <4 x i64> %or, i64 1
  %idx2 = extractelement <4 x i64> %or, i64 2
  %idx3 = extractelement <4 x i64> %or, i64 3
  %elt0 = extractelement <4 x i64> %v, i64 %idx0
  %elt1 = extractelement <4 x i64> %v, i64 %idx1
  %elt2 = extractelement <4 x i64> %v, i64 %idx2
  %elt3 = extractelement <4 x i64> %v, i64 %idx3
  %vec0 = insertelement <4 x i64> poison, i64 %elt0, i64 0
  %vec1 = insertelement <4 x i64> %vec0, i64 %elt1, i64 1
  %vec2 = insertelement <4 x i64> %vec1, i64 %elt2, i64 2
  %vec3 = insertelement <4 x i64> %vec2, i64 %elt3, i64 3
  %res = select <4 x i1> %cmp, <4 x i64> zeroinitializer, <4 x i64> %vec3
  ret <4 x i64> %res
}

define <8 x i32> @var_shuffle_v8i32(<8 x i32> %v, <8 x i32> %indices) nounwind {
; XOP-LABEL: var_shuffle_v8i32:
; XOP:       # %bb.0:
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps %ymm1, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; INT256-LABEL: var_shuffle_v8i32:
; INT256:       # %bb.0:
; INT256-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; INT256-NEXT:    retq
  %index0 = extractelement <8 x i32> %indices, i32 0
  %index1 = extractelement <8 x i32> %indices, i32 1
  %index2 = extractelement <8 x i32> %indices, i32 2
  %index3 = extractelement <8 x i32> %indices, i32 3
  %index4 = extractelement <8 x i32> %indices, i32 4
  %index5 = extractelement <8 x i32> %indices, i32 5
  %index6 = extractelement <8 x i32> %indices, i32 6
  %index7 = extractelement <8 x i32> %indices, i32 7
  %v0 = extractelement <8 x i32> %v, i32 %index0
  %v1 = extractelement <8 x i32> %v, i32 %index1
  %v2 = extractelement <8 x i32> %v, i32 %index2
  %v3 = extractelement <8 x i32> %v, i32 %index3
  %v4 = extractelement <8 x i32> %v, i32 %index4
  %v5 = extractelement <8 x i32> %v, i32 %index5
  %v6 = extractelement <8 x i32> %v, i32 %index6
  %v7 = extractelement <8 x i32> %v, i32 %index7
  %ret0 = insertelement <8 x i32> undef, i32 %v0, i32 0
  %ret1 = insertelement <8 x i32> %ret0, i32 %v1, i32 1
  %ret2 = insertelement <8 x i32> %ret1, i32 %v2, i32 2
  %ret3 = insertelement <8 x i32> %ret2, i32 %v3, i32 3
  %ret4 = insertelement <8 x i32> %ret3, i32 %v4, i32 4
  %ret5 = insertelement <8 x i32> %ret4, i32 %v5, i32 5
  %ret6 = insertelement <8 x i32> %ret5, i32 %v6, i32 6
  %ret7 = insertelement <8 x i32> %ret6, i32 %v7, i32 7
  ret <8 x i32> %ret7
}

define <8 x i32> @var_shuffle_zero_v8i32(<8 x i32> %v, <8 x i32> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v8i32:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [7,7,7,7]
; XOP-NEXT:    vpcomgtud %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtud %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm3, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [8,8,8,8]
; AVX1-NEXT:    vpmaxud %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxud %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm4, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps %ymm1, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vblendvps %ymm3, %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpmaxud %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_zero_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    vpcmpnleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %k1
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_zero_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovdqa32 %ymm1, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %cmp = icmp ugt <8 x i32> %indices, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %or = select <8 x i1> %cmp, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> %indices
  %idx0 = extractelement <8 x i32> %or, i64 0
  %idx1 = extractelement <8 x i32> %or, i64 1
  %idx2 = extractelement <8 x i32> %or, i64 2
  %idx3 = extractelement <8 x i32> %or, i64 3
  %idx4 = extractelement <8 x i32> %or, i64 4
  %idx5 = extractelement <8 x i32> %or, i64 5
  %idx6 = extractelement <8 x i32> %or, i64 6
  %idx7 = extractelement <8 x i32> %or, i64 7
  %elt0 = extractelement <8 x i32> %v, i32 %idx0
  %elt1 = extractelement <8 x i32> %v, i32 %idx1
  %elt2 = extractelement <8 x i32> %v, i32 %idx2
  %elt3 = extractelement <8 x i32> %v, i32 %idx3
  %elt4 = extractelement <8 x i32> %v, i32 %idx4
  %elt5 = extractelement <8 x i32> %v, i32 %idx5
  %elt6 = extractelement <8 x i32> %v, i32 %idx6
  %elt7 = extractelement <8 x i32> %v, i32 %idx7
  %vec0 = insertelement <8 x i32> poison, i32 %elt0, i64 0
  %vec1 = insertelement <8 x i32> %vec0, i32 %elt1, i64 1
  %vec2 = insertelement <8 x i32> %vec1, i32 %elt2, i64 2
  %vec3 = insertelement <8 x i32> %vec2, i32 %elt3, i64 3
  %vec4 = insertelement <8 x i32> %vec3, i32 %elt4, i64 4
  %vec5 = insertelement <8 x i32> %vec4, i32 %elt5, i64 5
  %vec6 = insertelement <8 x i32> %vec5, i32 %elt6, i64 6
  %vec7 = insertelement <8 x i32> %vec6, i32 %elt7, i64 7
  %res = select <8 x i1> %cmp, <8 x i32> zeroinitializer, <8 x i32> %vec7
  ret <8 x i32> %res
}

define <16 x i16> @var_shuffle_v16i16(<16 x i16> %v, <16 x i16> %indices) nounwind {
; XOP-LABEL: var_shuffle_v16i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm2 = [256,256,256,256,256,256,256,256]
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [514,514,514,514,514,514,514,514]
; XOP-NEXT:    vpmacsww %xmm2, %xmm3, %xmm1, %xmm4
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpmacsww %xmm2, %xmm3, %xmm1, %xmm1
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOP-NEXT:    vpperm %xmm1, %xmm2, %xmm0, %xmm1
; XOP-NEXT:    vpperm %xmm4, %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [514,514,514,514,514,514,514,514]
; AVX1-NEXT:    vpmullw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [256,256,256,256,256,256,256,256]
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmullw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm1, %xmm5, %xmm6
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm3, %xmm5, %xmm4
; AVX1-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX2-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_v16i16:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512VLF-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm2
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512VLF-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm2 ^ (ymm0 & (ymm3 ^ ymm2))
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_v16i16:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    retq
  %index0 = extractelement <16 x i16> %indices, i32 0
  %index1 = extractelement <16 x i16> %indices, i32 1
  %index2 = extractelement <16 x i16> %indices, i32 2
  %index3 = extractelement <16 x i16> %indices, i32 3
  %index4 = extractelement <16 x i16> %indices, i32 4
  %index5 = extractelement <16 x i16> %indices, i32 5
  %index6 = extractelement <16 x i16> %indices, i32 6
  %index7 = extractelement <16 x i16> %indices, i32 7
  %index8 = extractelement <16 x i16> %indices, i32 8
  %index9 = extractelement <16 x i16> %indices, i32 9
  %index10 = extractelement <16 x i16> %indices, i32 10
  %index11 = extractelement <16 x i16> %indices, i32 11
  %index12 = extractelement <16 x i16> %indices, i32 12
  %index13 = extractelement <16 x i16> %indices, i32 13
  %index14 = extractelement <16 x i16> %indices, i32 14
  %index15 = extractelement <16 x i16> %indices, i32 15
  %v0 = extractelement <16 x i16> %v, i16 %index0
  %v1 = extractelement <16 x i16> %v, i16 %index1
  %v2 = extractelement <16 x i16> %v, i16 %index2
  %v3 = extractelement <16 x i16> %v, i16 %index3
  %v4 = extractelement <16 x i16> %v, i16 %index4
  %v5 = extractelement <16 x i16> %v, i16 %index5
  %v6 = extractelement <16 x i16> %v, i16 %index6
  %v7 = extractelement <16 x i16> %v, i16 %index7
  %v8 = extractelement <16 x i16> %v, i16 %index8
  %v9 = extractelement <16 x i16> %v, i16 %index9
  %v10 = extractelement <16 x i16> %v, i16 %index10
  %v11 = extractelement <16 x i16> %v, i16 %index11
  %v12 = extractelement <16 x i16> %v, i16 %index12
  %v13 = extractelement <16 x i16> %v, i16 %index13
  %v14 = extractelement <16 x i16> %v, i16 %index14
  %v15 = extractelement <16 x i16> %v, i16 %index15
  %ret0 = insertelement <16 x i16> undef, i16 %v0, i32 0
  %ret1 = insertelement <16 x i16> %ret0, i16 %v1, i32 1
  %ret2 = insertelement <16 x i16> %ret1, i16 %v2, i32 2
  %ret3 = insertelement <16 x i16> %ret2, i16 %v3, i32 3
  %ret4 = insertelement <16 x i16> %ret3, i16 %v4, i32 4
  %ret5 = insertelement <16 x i16> %ret4, i16 %v5, i32 5
  %ret6 = insertelement <16 x i16> %ret5, i16 %v6, i32 6
  %ret7 = insertelement <16 x i16> %ret6, i16 %v7, i32 7
  %ret8 = insertelement <16 x i16> %ret7, i16 %v8, i32 8
  %ret9 = insertelement <16 x i16> %ret8, i16 %v9, i32 9
  %ret10 = insertelement <16 x i16> %ret9, i16 %v10, i32 10
  %ret11 = insertelement <16 x i16> %ret10, i16 %v11, i32 11
  %ret12 = insertelement <16 x i16> %ret11, i16 %v12, i32 12
  %ret13 = insertelement <16 x i16> %ret12, i16 %v13, i32 13
  %ret14 = insertelement <16 x i16> %ret13, i16 %v14, i32 14
  %ret15 = insertelement <16 x i16> %ret14, i16 %v15, i32 15
  ret <16 x i16> %ret15
}

define <16 x i16> @var_shuffle_zero_v16i16(<16 x i16> %v, <16 x i16> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v16i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15]
; XOP-NEXT:    vpcomgtuw %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtuw %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [256,256,256,256,256,256,256,256]
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm4 = [514,514,514,514,514,514,514,514]
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm5
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpperm %xmm1, %xmm3, %xmm0, %xmm1
; XOP-NEXT:    vpperm %xmm5, %xmm3, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [16,16,16,16,16,16,16,16]
; AVX1-NEXT:    vpmaxuw %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxuw %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [514,514,514,514,514,514,514,514]
; AVX1-NEXT:    vpmullw %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [256,256,256,256,256,256,256,256]
; AVX1-NEXT:    vpaddw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmullw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm7
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm6, %xmm5
; AVX1-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmaxuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX2-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX2-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_shuffle_zero_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmaxuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm2
; AVX512F-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512F-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX512F-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512F-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm1, %ymm0, %ymm3, %ymm0
; AVX512F-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: var_shuffle_zero_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpcmpnleuw %zmm2, %zmm1, %k1
; AVX512BW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-NEXT:    vmovdqu16 %zmm2, %zmm1 {%k1}
; AVX512BW-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512BW-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX512BW-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_zero_v16i16:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    vpmaxuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512VLF-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm2
; AVX512VLF-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512VLF-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512VLF-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX512VLF-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm1 = ymm3 ^ (ymm1 & (ymm0 ^ ymm3))
; AVX512VLF-NEXT:    vpandn %ymm1, %ymm2, %ymm0
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_zero_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_zero_v16i16:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    vpcmpnleuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; VLVBMI-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; VLVBMI-NEXT:    vmovdqu16 %ymm2, %ymm1 {%k1}
; VLVBMI-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VLVBMI-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; VLVBMI-NEXT:    retq
  %cmp = icmp ugt <16 x i16> %indices, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %or = select <16 x i1> %cmp, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %indices
  %idx0 = extractelement <16 x i16> %or, i64 0
  %idx1 = extractelement <16 x i16> %or, i64 1
  %idx2 = extractelement <16 x i16> %or, i64 2
  %idx3 = extractelement <16 x i16> %or, i64 3
  %idx4 = extractelement <16 x i16> %or, i64 4
  %idx5 = extractelement <16 x i16> %or, i64 5
  %idx6 = extractelement <16 x i16> %or, i64 6
  %idx7 = extractelement <16 x i16> %or, i64 7
  %idx8 = extractelement <16 x i16> %or, i64 8
  %idx9 = extractelement <16 x i16> %or, i64 9
  %idxA = extractelement <16 x i16> %or, i64 10
  %idxB = extractelement <16 x i16> %or, i64 11
  %idxC = extractelement <16 x i16> %or, i64 12
  %idxD = extractelement <16 x i16> %or, i64 13
  %idxE = extractelement <16 x i16> %or, i64 14
  %idxF = extractelement <16 x i16> %or, i64 15
  %elt0 = extractelement <16 x i16> %v, i16 %idx0
  %elt1 = extractelement <16 x i16> %v, i16 %idx1
  %elt2 = extractelement <16 x i16> %v, i16 %idx2
  %elt3 = extractelement <16 x i16> %v, i16 %idx3
  %elt4 = extractelement <16 x i16> %v, i16 %idx4
  %elt5 = extractelement <16 x i16> %v, i16 %idx5
  %elt6 = extractelement <16 x i16> %v, i16 %idx6
  %elt7 = extractelement <16 x i16> %v, i16 %idx7
  %elt8 = extractelement <16 x i16> %v, i16 %idx8
  %elt9 = extractelement <16 x i16> %v, i16 %idx9
  %eltA = extractelement <16 x i16> %v, i16 %idxA
  %eltB = extractelement <16 x i16> %v, i16 %idxB
  %eltC = extractelement <16 x i16> %v, i16 %idxC
  %eltD = extractelement <16 x i16> %v, i16 %idxD
  %eltE = extractelement <16 x i16> %v, i16 %idxE
  %eltF = extractelement <16 x i16> %v, i16 %idxF
  %vec0 = insertelement <16 x i16> poison, i16 %elt0, i64 0
  %vec1 = insertelement <16 x i16> %vec0, i16 %elt1, i64 1
  %vec2 = insertelement <16 x i16> %vec1, i16 %elt2, i64 2
  %vec3 = insertelement <16 x i16> %vec2, i16 %elt3, i64 3
  %vec4 = insertelement <16 x i16> %vec3, i16 %elt4, i64 4
  %vec5 = insertelement <16 x i16> %vec4, i16 %elt5, i64 5
  %vec6 = insertelement <16 x i16> %vec5, i16 %elt6, i64 6
  %vec7 = insertelement <16 x i16> %vec6, i16 %elt7, i64 7
  %vec8 = insertelement <16 x i16> %vec7, i16 %elt8, i64 8
  %vec9 = insertelement <16 x i16> %vec8, i16 %elt9, i64 9
  %vecA = insertelement <16 x i16> %vec9, i16 %eltA, i64 10
  %vecB = insertelement <16 x i16> %vecA, i16 %eltB, i64 11
  %vecC = insertelement <16 x i16> %vecB, i16 %eltC, i64 12
  %vecD = insertelement <16 x i16> %vecC, i16 %eltD, i64 13
  %vecE = insertelement <16 x i16> %vecD, i16 %eltE, i64 14
  %vecF = insertelement <16 x i16> %vecE, i16 %eltF, i64 15
  %res = select <16 x i1> %cmp, <16 x i16> zeroinitializer, <16 x i16> %vecF
  ret <16 x i16> %res
}

define <32 x i8> @var_shuffle_v32i8(<32 x i8> %v, <32 x i8> %indices) nounwind {
; XOP-LABEL: var_shuffle_v32i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpperm %xmm2, %xmm3, %xmm0, %xmm2
; XOP-NEXT:    vpperm %xmm1, %xmm3, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm2, %xmm5, %xmm6
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpshufb %xmm1, %xmm5, %xmm4
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_v32i8:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm3 ^ (ymm0 & (ymm2 ^ ymm3))
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VLBW-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm0, %ymm2 {%k1}
; AVX512VLBW-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_v32i8:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    vpermb %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    retq
  %index0 = extractelement <32 x i8> %indices, i32 0
  %index1 = extractelement <32 x i8> %indices, i32 1
  %index2 = extractelement <32 x i8> %indices, i32 2
  %index3 = extractelement <32 x i8> %indices, i32 3
  %index4 = extractelement <32 x i8> %indices, i32 4
  %index5 = extractelement <32 x i8> %indices, i32 5
  %index6 = extractelement <32 x i8> %indices, i32 6
  %index7 = extractelement <32 x i8> %indices, i32 7
  %index8 = extractelement <32 x i8> %indices, i32 8
  %index9 = extractelement <32 x i8> %indices, i32 9
  %index10 = extractelement <32 x i8> %indices, i32 10
  %index11 = extractelement <32 x i8> %indices, i32 11
  %index12 = extractelement <32 x i8> %indices, i32 12
  %index13 = extractelement <32 x i8> %indices, i32 13
  %index14 = extractelement <32 x i8> %indices, i32 14
  %index15 = extractelement <32 x i8> %indices, i32 15
  %index16 = extractelement <32 x i8> %indices, i32 16
  %index17 = extractelement <32 x i8> %indices, i32 17
  %index18 = extractelement <32 x i8> %indices, i32 18
  %index19 = extractelement <32 x i8> %indices, i32 19
  %index20 = extractelement <32 x i8> %indices, i32 20
  %index21 = extractelement <32 x i8> %indices, i32 21
  %index22 = extractelement <32 x i8> %indices, i32 22
  %index23 = extractelement <32 x i8> %indices, i32 23
  %index24 = extractelement <32 x i8> %indices, i32 24
  %index25 = extractelement <32 x i8> %indices, i32 25
  %index26 = extractelement <32 x i8> %indices, i32 26
  %index27 = extractelement <32 x i8> %indices, i32 27
  %index28 = extractelement <32 x i8> %indices, i32 28
  %index29 = extractelement <32 x i8> %indices, i32 29
  %index30 = extractelement <32 x i8> %indices, i32 30
  %index31 = extractelement <32 x i8> %indices, i32 31
  %v0 = extractelement <32 x i8> %v, i8 %index0
  %v1 = extractelement <32 x i8> %v, i8 %index1
  %v2 = extractelement <32 x i8> %v, i8 %index2
  %v3 = extractelement <32 x i8> %v, i8 %index3
  %v4 = extractelement <32 x i8> %v, i8 %index4
  %v5 = extractelement <32 x i8> %v, i8 %index5
  %v6 = extractelement <32 x i8> %v, i8 %index6
  %v7 = extractelement <32 x i8> %v, i8 %index7
  %v8 = extractelement <32 x i8> %v, i8 %index8
  %v9 = extractelement <32 x i8> %v, i8 %index9
  %v10 = extractelement <32 x i8> %v, i8 %index10
  %v11 = extractelement <32 x i8> %v, i8 %index11
  %v12 = extractelement <32 x i8> %v, i8 %index12
  %v13 = extractelement <32 x i8> %v, i8 %index13
  %v14 = extractelement <32 x i8> %v, i8 %index14
  %v15 = extractelement <32 x i8> %v, i8 %index15
  %v16 = extractelement <32 x i8> %v, i8 %index16
  %v17 = extractelement <32 x i8> %v, i8 %index17
  %v18 = extractelement <32 x i8> %v, i8 %index18
  %v19 = extractelement <32 x i8> %v, i8 %index19
  %v20 = extractelement <32 x i8> %v, i8 %index20
  %v21 = extractelement <32 x i8> %v, i8 %index21
  %v22 = extractelement <32 x i8> %v, i8 %index22
  %v23 = extractelement <32 x i8> %v, i8 %index23
  %v24 = extractelement <32 x i8> %v, i8 %index24
  %v25 = extractelement <32 x i8> %v, i8 %index25
  %v26 = extractelement <32 x i8> %v, i8 %index26
  %v27 = extractelement <32 x i8> %v, i8 %index27
  %v28 = extractelement <32 x i8> %v, i8 %index28
  %v29 = extractelement <32 x i8> %v, i8 %index29
  %v30 = extractelement <32 x i8> %v, i8 %index30
  %v31 = extractelement <32 x i8> %v, i8 %index31
  %ret0 = insertelement <32 x i8> undef, i8 %v0, i32 0
  %ret1 = insertelement <32 x i8> %ret0, i8 %v1, i32 1
  %ret2 = insertelement <32 x i8> %ret1, i8 %v2, i32 2
  %ret3 = insertelement <32 x i8> %ret2, i8 %v3, i32 3
  %ret4 = insertelement <32 x i8> %ret3, i8 %v4, i32 4
  %ret5 = insertelement <32 x i8> %ret4, i8 %v5, i32 5
  %ret6 = insertelement <32 x i8> %ret5, i8 %v6, i32 6
  %ret7 = insertelement <32 x i8> %ret6, i8 %v7, i32 7
  %ret8 = insertelement <32 x i8> %ret7, i8 %v8, i32 8
  %ret9 = insertelement <32 x i8> %ret8, i8 %v9, i32 9
  %ret10 = insertelement <32 x i8> %ret9, i8 %v10, i32 10
  %ret11 = insertelement <32 x i8> %ret10, i8 %v11, i32 11
  %ret12 = insertelement <32 x i8> %ret11, i8 %v12, i32 12
  %ret13 = insertelement <32 x i8> %ret12, i8 %v13, i32 13
  %ret14 = insertelement <32 x i8> %ret13, i8 %v14, i32 14
  %ret15 = insertelement <32 x i8> %ret14, i8 %v15, i32 15
  %ret16 = insertelement <32 x i8> %ret15, i8 %v16, i32 16
  %ret17 = insertelement <32 x i8> %ret16, i8 %v17, i32 17
  %ret18 = insertelement <32 x i8> %ret17, i8 %v18, i32 18
  %ret19 = insertelement <32 x i8> %ret18, i8 %v19, i32 19
  %ret20 = insertelement <32 x i8> %ret19, i8 %v20, i32 20
  %ret21 = insertelement <32 x i8> %ret20, i8 %v21, i32 21
  %ret22 = insertelement <32 x i8> %ret21, i8 %v22, i32 22
  %ret23 = insertelement <32 x i8> %ret22, i8 %v23, i32 23
  %ret24 = insertelement <32 x i8> %ret23, i8 %v24, i32 24
  %ret25 = insertelement <32 x i8> %ret24, i8 %v25, i32 25
  %ret26 = insertelement <32 x i8> %ret25, i8 %v26, i32 26
  %ret27 = insertelement <32 x i8> %ret26, i8 %v27, i32 27
  %ret28 = insertelement <32 x i8> %ret27, i8 %v28, i32 28
  %ret29 = insertelement <32 x i8> %ret28, i8 %v29, i32 29
  %ret30 = insertelement <32 x i8> %ret29, i8 %v30, i32 30
  %ret31 = insertelement <32 x i8> %ret30, i8 %v31, i32 31
  ret <32 x i8> %ret31
}

define <32 x i8> @var_shuffle_zero_v32i8(<32 x i8> %v, <32 x i8> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v32i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; XOP-NEXT:    vpcomgtub %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtub %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOP-NEXT:    vpperm %xmm3, %xmm4, %xmm0, %xmm3
; XOP-NEXT:    vpperm %xmm1, %xmm4, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX1-NEXT:    vpmaxub %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxub %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm7
; AVX1-NEXT:    vpshufb %xmm3, %xmm0, %xmm3
; AVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm5
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmaxub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX2-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_shuffle_zero_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmaxub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm2
; AVX512F-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX512F-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512F-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm1, %ymm0, %ymm3, %ymm0
; AVX512F-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: var_shuffle_zero_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastb {{.*#+}} ymm2 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512BW-NEXT:    vpcmpnleub %zmm2, %zmm1, %k1
; AVX512BW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-NEXT:    vmovdqu8 %zmm2, %zmm1 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX512BW-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_zero_v32i8:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    vpmaxub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512VLF-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm2
; AVX512VLF-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm3, %ymm3
; AVX512VLF-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm1 = ymm3 ^ (ymm1 & (ymm0 ^ ymm3))
; AVX512VLF-NEXT:    vpandn %ymm1, %ymm2, %ymm0
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_zero_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k2
; AVX512VLBW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm0, %ymm2 {%k2}
; AVX512VLBW-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vmovdqu8 %ymm0, %ymm2 {%k1}
; AVX512VLBW-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_zero_v32i8:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    vpcmpnleub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; VLVBMI-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; VLVBMI-NEXT:    vmovdqu8 %ymm2, %ymm1 {%k1}
; VLVBMI-NEXT:    vpermb %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VLVBMI-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k1}
; VLVBMI-NEXT:    retq
  %cmp = icmp ugt <32 x i8> %indices, <i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31>
  %or = select <32 x i1> %cmp, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %indices
  %idx00 = extractelement <32 x i8> %or, i64 0
  %idx01 = extractelement <32 x i8> %or, i64 1
  %idx02 = extractelement <32 x i8> %or, i64 2
  %idx03 = extractelement <32 x i8> %or, i64 3
  %idx04 = extractelement <32 x i8> %or, i64 4
  %idx05 = extractelement <32 x i8> %or, i64 5
  %idx06 = extractelement <32 x i8> %or, i64 6
  %idx07 = extractelement <32 x i8> %or, i64 7
  %idx08 = extractelement <32 x i8> %or, i64 8
  %idx09 = extractelement <32 x i8> %or, i64 9
  %idx0A = extractelement <32 x i8> %or, i64 10
  %idx0B = extractelement <32 x i8> %or, i64 11
  %idx0C = extractelement <32 x i8> %or, i64 12
  %idx0D = extractelement <32 x i8> %or, i64 13
  %idx0E = extractelement <32 x i8> %or, i64 14
  %idx0F = extractelement <32 x i8> %or, i64 15
  %idx10 = extractelement <32 x i8> %or, i64 16
  %idx11 = extractelement <32 x i8> %or, i64 17
  %idx12 = extractelement <32 x i8> %or, i64 18
  %idx13 = extractelement <32 x i8> %or, i64 19
  %idx14 = extractelement <32 x i8> %or, i64 20
  %idx15 = extractelement <32 x i8> %or, i64 21
  %idx16 = extractelement <32 x i8> %or, i64 22
  %idx17 = extractelement <32 x i8> %or, i64 23
  %idx18 = extractelement <32 x i8> %or, i64 24
  %idx19 = extractelement <32 x i8> %or, i64 25
  %idx1A = extractelement <32 x i8> %or, i64 26
  %idx1B = extractelement <32 x i8> %or, i64 27
  %idx1C = extractelement <32 x i8> %or, i64 28
  %idx1D = extractelement <32 x i8> %or, i64 29
  %idx1E = extractelement <32 x i8> %or, i64 30
  %idx1F = extractelement <32 x i8> %or, i64 31
  %elt00 = extractelement <32 x i8> %v, i8 %idx00
  %elt01 = extractelement <32 x i8> %v, i8 %idx01
  %elt02 = extractelement <32 x i8> %v, i8 %idx02
  %elt03 = extractelement <32 x i8> %v, i8 %idx03
  %elt04 = extractelement <32 x i8> %v, i8 %idx04
  %elt05 = extractelement <32 x i8> %v, i8 %idx05
  %elt06 = extractelement <32 x i8> %v, i8 %idx06
  %elt07 = extractelement <32 x i8> %v, i8 %idx07
  %elt08 = extractelement <32 x i8> %v, i8 %idx08
  %elt09 = extractelement <32 x i8> %v, i8 %idx09
  %elt0A = extractelement <32 x i8> %v, i8 %idx0A
  %elt0B = extractelement <32 x i8> %v, i8 %idx0B
  %elt0C = extractelement <32 x i8> %v, i8 %idx0C
  %elt0D = extractelement <32 x i8> %v, i8 %idx0D
  %elt0E = extractelement <32 x i8> %v, i8 %idx0E
  %elt0F = extractelement <32 x i8> %v, i8 %idx0F
  %elt10 = extractelement <32 x i8> %v, i8 %idx10
  %elt11 = extractelement <32 x i8> %v, i8 %idx11
  %elt12 = extractelement <32 x i8> %v, i8 %idx12
  %elt13 = extractelement <32 x i8> %v, i8 %idx13
  %elt14 = extractelement <32 x i8> %v, i8 %idx14
  %elt15 = extractelement <32 x i8> %v, i8 %idx15
  %elt16 = extractelement <32 x i8> %v, i8 %idx16
  %elt17 = extractelement <32 x i8> %v, i8 %idx17
  %elt18 = extractelement <32 x i8> %v, i8 %idx18
  %elt19 = extractelement <32 x i8> %v, i8 %idx19
  %elt1A = extractelement <32 x i8> %v, i8 %idx1A
  %elt1B = extractelement <32 x i8> %v, i8 %idx1B
  %elt1C = extractelement <32 x i8> %v, i8 %idx1C
  %elt1D = extractelement <32 x i8> %v, i8 %idx1D
  %elt1E = extractelement <32 x i8> %v, i8 %idx1E
  %elt1F = extractelement <32 x i8> %v, i8 %idx1F
  %vec00 = insertelement <32 x i8> poison, i8 %elt00, i64 0
  %vec01 = insertelement <32 x i8> %vec00, i8 %elt01, i64 1
  %vec02 = insertelement <32 x i8> %vec01, i8 %elt02, i64 2
  %vec03 = insertelement <32 x i8> %vec02, i8 %elt03, i64 3
  %vec04 = insertelement <32 x i8> %vec03, i8 %elt04, i64 4
  %vec05 = insertelement <32 x i8> %vec04, i8 %elt05, i64 5
  %vec06 = insertelement <32 x i8> %vec05, i8 %elt06, i64 6
  %vec07 = insertelement <32 x i8> %vec06, i8 %elt07, i64 7
  %vec08 = insertelement <32 x i8> %vec07, i8 %elt08, i64 8
  %vec09 = insertelement <32 x i8> %vec08, i8 %elt09, i64 9
  %vec0A = insertelement <32 x i8> %vec09, i8 %elt0A, i64 10
  %vec0B = insertelement <32 x i8> %vec0A, i8 %elt0B, i64 11
  %vec0C = insertelement <32 x i8> %vec0B, i8 %elt0C, i64 12
  %vec0D = insertelement <32 x i8> %vec0C, i8 %elt0D, i64 13
  %vec0E = insertelement <32 x i8> %vec0D, i8 %elt0E, i64 14
  %vec0F = insertelement <32 x i8> %vec0E, i8 %elt0F, i64 15
  %vec10 = insertelement <32 x i8> %vec0F, i8 %elt10, i64 16
  %vec11 = insertelement <32 x i8> %vec10, i8 %elt11, i64 17
  %vec12 = insertelement <32 x i8> %vec11, i8 %elt12, i64 18
  %vec13 = insertelement <32 x i8> %vec12, i8 %elt13, i64 19
  %vec14 = insertelement <32 x i8> %vec13, i8 %elt14, i64 20
  %vec15 = insertelement <32 x i8> %vec14, i8 %elt15, i64 21
  %vec16 = insertelement <32 x i8> %vec15, i8 %elt16, i64 22
  %vec17 = insertelement <32 x i8> %vec16, i8 %elt17, i64 23
  %vec18 = insertelement <32 x i8> %vec17, i8 %elt18, i64 24
  %vec19 = insertelement <32 x i8> %vec18, i8 %elt19, i64 25
  %vec1A = insertelement <32 x i8> %vec19, i8 %elt1A, i64 26
  %vec1B = insertelement <32 x i8> %vec1A, i8 %elt1B, i64 27
  %vec1C = insertelement <32 x i8> %vec1B, i8 %elt1C, i64 28
  %vec1D = insertelement <32 x i8> %vec1C, i8 %elt1D, i64 29
  %vec1E = insertelement <32 x i8> %vec1D, i8 %elt1E, i64 30
  %vec1F = insertelement <32 x i8> %vec1E, i8 %elt1F, i64 31
  %res = select <32 x i1> %cmp, <32 x i8> zeroinitializer, <32 x i8> %vec1F
  ret <32 x i8> %res
}

define <4 x double> @var_shuffle_v4f64(<4 x double> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_v4f64:
; XOP:       # %bb.0:
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm4
; AVX1-NEXT:    vpermilpd %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilpd %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm3, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_v4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %index0 = extractelement <4 x i64> %indices, i32 0
  %index1 = extractelement <4 x i64> %indices, i32 1
  %index2 = extractelement <4 x i64> %indices, i32 2
  %index3 = extractelement <4 x i64> %indices, i32 3
  %v0 = extractelement <4 x double> %v, i64 %index0
  %v1 = extractelement <4 x double> %v, i64 %index1
  %v2 = extractelement <4 x double> %v, i64 %index2
  %v3 = extractelement <4 x double> %v, i64 %index3
  %ret0 = insertelement <4 x double> undef, double %v0, i32 0
  %ret1 = insertelement <4 x double> %ret0, double %v1, i32 1
  %ret2 = insertelement <4 x double> %ret1, double %v2, i32 2
  %ret3 = insertelement <4 x double> %ret2, double %v3, i32 3
  ret <4 x double> %ret3
}

define <4 x double> @var_shuffle_zero_v4f64(<4 x double> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v4f64:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm3 = [3,3]
; XOP-NEXT:    vpcomgtuq %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtuq %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm3, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    # xmm3 = mem[0,0]
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [9223372036854775811,9223372036854775811]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm4, %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775811,9223372036854775811,9223372036854775811,9223372036854775811]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm4, %ymm4
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm3, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_zero_v4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [3,3,3,3]
; AVX512-NEXT:    vpcmpleuq %zmm2, %zmm1, %k1
; AVX512-NEXT:    vpcmpnleuq %zmm2, %zmm1, %k2
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k2}
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0 {%k1} {z}
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_zero_v4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleuq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpermq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovapd %ymm1, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %cmp = icmp ugt <4 x i64> %indices, <i64 3, i64 3, i64 3, i64 3>
  %or = select <4 x i1> %cmp, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> %indices
  %idx0 = extractelement <4 x i64> %or, i64 0
  %idx1 = extractelement <4 x i64> %or, i64 1
  %idx2 = extractelement <4 x i64> %or, i64 2
  %idx3 = extractelement <4 x i64> %or, i64 3
  %elt0 = extractelement <4 x double> %v, i64 %idx0
  %elt1 = extractelement <4 x double> %v, i64 %idx1
  %elt2 = extractelement <4 x double> %v, i64 %idx2
  %elt3 = extractelement <4 x double> %v, i64 %idx3
  %vec0 = insertelement <4 x double> poison, double %elt0, i64 0
  %vec1 = insertelement <4 x double> %vec0, double %elt1, i64 1
  %vec2 = insertelement <4 x double> %vec1, double %elt2, i64 2
  %vec3 = insertelement <4 x double> %vec2, double %elt3, i64 3
  %res = select <4 x i1> %cmp, <4 x double> zeroinitializer, <4 x double> %vec3
  ret <4 x double> %res
}

define <8 x float> @var_shuffle_v8f32(<8 x float> %v, <8 x i32> %indices) nounwind {
; XOP-LABEL: var_shuffle_v8f32:
; XOP:       # %bb.0:
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps %ymm1, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; INT256-LABEL: var_shuffle_v8f32:
; INT256:       # %bb.0:
; INT256-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; INT256-NEXT:    retq
  %index0 = extractelement <8 x i32> %indices, i32 0
  %index1 = extractelement <8 x i32> %indices, i32 1
  %index2 = extractelement <8 x i32> %indices, i32 2
  %index3 = extractelement <8 x i32> %indices, i32 3
  %index4 = extractelement <8 x i32> %indices, i32 4
  %index5 = extractelement <8 x i32> %indices, i32 5
  %index6 = extractelement <8 x i32> %indices, i32 6
  %index7 = extractelement <8 x i32> %indices, i32 7
  %v0 = extractelement <8 x float> %v, i32 %index0
  %v1 = extractelement <8 x float> %v, i32 %index1
  %v2 = extractelement <8 x float> %v, i32 %index2
  %v3 = extractelement <8 x float> %v, i32 %index3
  %v4 = extractelement <8 x float> %v, i32 %index4
  %v5 = extractelement <8 x float> %v, i32 %index5
  %v6 = extractelement <8 x float> %v, i32 %index6
  %v7 = extractelement <8 x float> %v, i32 %index7
  %ret0 = insertelement <8 x float> undef, float %v0, i32 0
  %ret1 = insertelement <8 x float> %ret0, float %v1, i32 1
  %ret2 = insertelement <8 x float> %ret1, float %v2, i32 2
  %ret3 = insertelement <8 x float> %ret2, float %v3, i32 3
  %ret4 = insertelement <8 x float> %ret3, float %v4, i32 4
  %ret5 = insertelement <8 x float> %ret4, float %v5, i32 5
  %ret6 = insertelement <8 x float> %ret5, float %v6, i32 6
  %ret7 = insertelement <8 x float> %ret6, float %v7, i32 7
  ret <8 x float> %ret7
}

define <8 x float> @var_shuffle_zero_v8f32(<8 x float> %v, <8 x i32> %indices) nounwind {
; XOP-LABEL: var_shuffle_zero_v8f32:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [7,7,7,7]
; XOP-NEXT:    vpcomgtud %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpcomgtud %xmm3, %xmm1, %xmm3
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; XOP-NEXT:    vorps %ymm1, %ymm2, %ymm1
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm3, %ymm0, %ymm0
; XOP-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_zero_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [8,8,8,8]
; AVX1-NEXT:    vpmaxud %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxud %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm4, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps %ymm1, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vblendvps %ymm3, %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_zero_v8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpmaxud %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpandn %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_zero_v8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    vpcmpnleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %k1
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_zero_v8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovaps %ymm1, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %cmp = icmp ugt <8 x i32> %indices, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %or = select <8 x i1> %cmp, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> %indices
  %idx0 = extractelement <8 x i32> %or, i64 0
  %idx1 = extractelement <8 x i32> %or, i64 1
  %idx2 = extractelement <8 x i32> %or, i64 2
  %idx3 = extractelement <8 x i32> %or, i64 3
  %idx4 = extractelement <8 x i32> %or, i64 4
  %idx5 = extractelement <8 x i32> %or, i64 5
  %idx6 = extractelement <8 x i32> %or, i64 6
  %idx7 = extractelement <8 x i32> %or, i64 7
  %elt0 = extractelement <8 x float> %v, i32 %idx0
  %elt1 = extractelement <8 x float> %v, i32 %idx1
  %elt2 = extractelement <8 x float> %v, i32 %idx2
  %elt3 = extractelement <8 x float> %v, i32 %idx3
  %elt4 = extractelement <8 x float> %v, i32 %idx4
  %elt5 = extractelement <8 x float> %v, i32 %idx5
  %elt6 = extractelement <8 x float> %v, i32 %idx6
  %elt7 = extractelement <8 x float> %v, i32 %idx7
  %vec0 = insertelement <8 x float> poison, float %elt0, i64 0
  %vec1 = insertelement <8 x float> %vec0, float %elt1, i64 1
  %vec2 = insertelement <8 x float> %vec1, float %elt2, i64 2
  %vec3 = insertelement <8 x float> %vec2, float %elt3, i64 3
  %vec4 = insertelement <8 x float> %vec3, float %elt4, i64 4
  %vec5 = insertelement <8 x float> %vec4, float %elt5, i64 5
  %vec6 = insertelement <8 x float> %vec5, float %elt6, i64 6
  %vec7 = insertelement <8 x float> %vec6, float %elt7, i64 7
  %res = select <8 x i1> %cmp, <8 x float> zeroinitializer, <8 x float> %vec7
  ret <8 x float> %res
}

;
; PR35820 - Unequal source/destination vector sizes
;

define <4 x i64> @var_shuffle_v4i64_from_v2i64(<2 x i64> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_v4i64_from_v2i64:
; XOP:       # %bb.0:
; XOP-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm0, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4i64_from_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm3
; AVX1-NEXT:    vpermilpd %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpermilpd %ymm3, %ymm0, %ymm2
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v4i64_from_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v4i64_from_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_v4i64_from_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vpermpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %index0 = extractelement <4 x i64> %indices, i32 0
  %index1 = extractelement <4 x i64> %indices, i32 1
  %index2 = extractelement <4 x i64> %indices, i32 2
  %index3 = extractelement <4 x i64> %indices, i32 3
  %v0 = extractelement <2 x i64> %v, i64 %index0
  %v1 = extractelement <2 x i64> %v, i64 %index1
  %v2 = extractelement <2 x i64> %v, i64 %index2
  %v3 = extractelement <2 x i64> %v, i64 %index3
  %ret0 = insertelement <4 x i64> undef, i64 %v0, i32 0
  %ret1 = insertelement <4 x i64> %ret0, i64 %v1, i32 1
  %ret2 = insertelement <4 x i64> %ret1, i64 %v2, i32 2
  %ret3 = insertelement <4 x i64> %ret2, i64 %v3, i32 3
  ret <4 x i64> %ret3
}

define <8 x i32> @var_shuffle_v8i32_from_v4i32(<4 x i32> %v, <8 x i32> %indices) unnamed_addr nounwind {
; XOP-LABEL: var_shuffle_v8i32_from_v4i32:
; XOP:       # %bb.0: # %entry
; XOP-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm0, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v8i32_from_v4i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; INT256-LABEL: var_shuffle_v8i32_from_v4i32:
; INT256:       # %bb.0: # %entry
; INT256-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; INT256-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; INT256-NEXT:    retq
entry:
  %tmp1 = extractelement <8 x i32> %indices, i32 0
  %vecext2.8 = extractelement <4 x i32> %v, i32 %tmp1
  %tmp2 = extractelement <8 x i32> %indices, i32 1
  %vecext2.9 = extractelement <4 x i32> %v, i32 %tmp2
  %tmp3 = extractelement <8 x i32> %indices, i32 2
  %vecext2.10 = extractelement <4 x i32> %v, i32 %tmp3
  %tmp4 = extractelement <8 x i32> %indices, i32 3
  %vecext2.11 = extractelement <4 x i32> %v, i32 %tmp4
  %tmp5 = extractelement <8 x i32> %indices, i32 4
  %vecext2.12 = extractelement <4 x i32> %v, i32 %tmp5
  %tmp6 = extractelement <8 x i32> %indices, i32 5
  %vecext2.13 = extractelement <4 x i32> %v, i32 %tmp6
  %tmp7 = extractelement <8 x i32> %indices, i32 6
  %vecext2.14 = extractelement <4 x i32> %v, i32 %tmp7
  %tmp8 = extractelement <8 x i32> %indices, i32 7
  %vecext2.15 = extractelement <4 x i32> %v, i32 %tmp8
  %tmp9 = insertelement <8 x i32> undef, i32 %vecext2.8, i32 0
  %tmp10 = insertelement <8 x i32> %tmp9, i32 %vecext2.9, i32 1
  %tmp11 = insertelement <8 x i32> %tmp10, i32 %vecext2.10, i32 2
  %tmp12 = insertelement <8 x i32> %tmp11, i32 %vecext2.11, i32 3
  %tmp13 = insertelement <8 x i32> %tmp12, i32 %vecext2.12, i32 4
  %tmp14 = insertelement <8 x i32> %tmp13, i32 %vecext2.13, i32 5
  %tmp15 = insertelement <8 x i32> %tmp14, i32 %vecext2.14, i32 6
  %tmp16 = insertelement <8 x i32> %tmp15, i32 %vecext2.15, i32 7
  ret <8 x i32> %tmp16
}

define <16 x i16> @var_shuffle_v16i16_from_v8i16(<8 x i16> %v, <16 x i16> %indices) nounwind {
; XOP-LABEL: var_shuffle_v16i16_from_v8i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm2 = [256,256,256,256,256,256,256,256]
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm3 = [514,514,514,514,514,514,514,514]
; XOP-NEXT:    vpmacsww %xmm2, %xmm3, %xmm1, %xmm4
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpmacsww %xmm2, %xmm3, %xmm1, %xmm1
; XOP-NEXT:    vpperm %xmm1, %xmm0, %xmm0, %xmm1
; XOP-NEXT:    vpperm %xmm4, %xmm0, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v16i16_from_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [514,514,514,514,514,514,514,514]
; AVX1-NEXT:    vpmullw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [256,256,256,256,256,256,256,256]
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmullw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm4
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v16i16_from_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX2-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v16i16_from_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_v16i16_from_v8i16:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLF-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514]
; AVX512VLF-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm2 ^ (ymm0 & (ymm3 ^ ymm2))
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_v16i16_from_v8i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLBW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_v16i16_from_v8i16:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; VLVBMI-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    retq
  %index0 = extractelement <16 x i16> %indices, i32 0
  %index1 = extractelement <16 x i16> %indices, i32 1
  %index2 = extractelement <16 x i16> %indices, i32 2
  %index3 = extractelement <16 x i16> %indices, i32 3
  %index4 = extractelement <16 x i16> %indices, i32 4
  %index5 = extractelement <16 x i16> %indices, i32 5
  %index6 = extractelement <16 x i16> %indices, i32 6
  %index7 = extractelement <16 x i16> %indices, i32 7
  %index8 = extractelement <16 x i16> %indices, i32 8
  %index9 = extractelement <16 x i16> %indices, i32 9
  %index10 = extractelement <16 x i16> %indices, i32 10
  %index11 = extractelement <16 x i16> %indices, i32 11
  %index12 = extractelement <16 x i16> %indices, i32 12
  %index13 = extractelement <16 x i16> %indices, i32 13
  %index14 = extractelement <16 x i16> %indices, i32 14
  %index15 = extractelement <16 x i16> %indices, i32 15
  %v0 = extractelement <8 x i16> %v, i16 %index0
  %v1 = extractelement <8 x i16> %v, i16 %index1
  %v2 = extractelement <8 x i16> %v, i16 %index2
  %v3 = extractelement <8 x i16> %v, i16 %index3
  %v4 = extractelement <8 x i16> %v, i16 %index4
  %v5 = extractelement <8 x i16> %v, i16 %index5
  %v6 = extractelement <8 x i16> %v, i16 %index6
  %v7 = extractelement <8 x i16> %v, i16 %index7
  %v8 = extractelement <8 x i16> %v, i16 %index8
  %v9 = extractelement <8 x i16> %v, i16 %index9
  %v10 = extractelement <8 x i16> %v, i16 %index10
  %v11 = extractelement <8 x i16> %v, i16 %index11
  %v12 = extractelement <8 x i16> %v, i16 %index12
  %v13 = extractelement <8 x i16> %v, i16 %index13
  %v14 = extractelement <8 x i16> %v, i16 %index14
  %v15 = extractelement <8 x i16> %v, i16 %index15
  %ret0 = insertelement <16 x i16> undef, i16 %v0, i32 0
  %ret1 = insertelement <16 x i16> %ret0, i16 %v1, i32 1
  %ret2 = insertelement <16 x i16> %ret1, i16 %v2, i32 2
  %ret3 = insertelement <16 x i16> %ret2, i16 %v3, i32 3
  %ret4 = insertelement <16 x i16> %ret3, i16 %v4, i32 4
  %ret5 = insertelement <16 x i16> %ret4, i16 %v5, i32 5
  %ret6 = insertelement <16 x i16> %ret5, i16 %v6, i32 6
  %ret7 = insertelement <16 x i16> %ret6, i16 %v7, i32 7
  %ret8 = insertelement <16 x i16> %ret7, i16 %v8, i32 8
  %ret9 = insertelement <16 x i16> %ret8, i16 %v9, i32 9
  %ret10 = insertelement <16 x i16> %ret9, i16 %v10, i32 10
  %ret11 = insertelement <16 x i16> %ret10, i16 %v11, i32 11
  %ret12 = insertelement <16 x i16> %ret11, i16 %v12, i32 12
  %ret13 = insertelement <16 x i16> %ret12, i16 %v13, i32 13
  %ret14 = insertelement <16 x i16> %ret13, i16 %v14, i32 14
  %ret15 = insertelement <16 x i16> %ret14, i16 %v15, i32 15
  ret <16 x i16> %ret15
}

define <32 x i8> @var_shuffle_v32i8_from_v16i8(<16 x i8> %v, <32 x i8> %indices) nounwind {
; XOP-LABEL: var_shuffle_v32i8_from_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vpperm %xmm2, %xmm0, %xmm0, %xmm2
; XOP-NEXT:    vpperm %xmm1, %xmm0, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v32i8_from_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v32i8_from_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v32i8_from_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VLF-LABEL: var_shuffle_v32i8_from_v16i8:
; AVX512VLF:       # %bb.0:
; AVX512VLF-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX512VLF-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VLF-NEXT:    vpshufb %ymm1, %ymm0, %ymm3
; AVX512VLF-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512VLF-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm3 ^ (ymm0 & (ymm2 ^ ymm3))
; AVX512VLF-NEXT:    retq
;
; AVX512VLBW-LABEL: var_shuffle_v32i8_from_v16i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLBW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %k1
; AVX512VLBW-NEXT:    vpshufb %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; VLVBMI-LABEL: var_shuffle_v32i8_from_v16i8:
; VLVBMI:       # %bb.0:
; VLVBMI-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; VLVBMI-NEXT:    vpermb %ymm0, %ymm1, %ymm0
; VLVBMI-NEXT:    retq
  %index0 = extractelement <32 x i8> %indices, i32 0
  %index1 = extractelement <32 x i8> %indices, i32 1
  %index2 = extractelement <32 x i8> %indices, i32 2
  %index3 = extractelement <32 x i8> %indices, i32 3
  %index4 = extractelement <32 x i8> %indices, i32 4
  %index5 = extractelement <32 x i8> %indices, i32 5
  %index6 = extractelement <32 x i8> %indices, i32 6
  %index7 = extractelement <32 x i8> %indices, i32 7
  %index8 = extractelement <32 x i8> %indices, i32 8
  %index9 = extractelement <32 x i8> %indices, i32 9
  %index10 = extractelement <32 x i8> %indices, i32 10
  %index11 = extractelement <32 x i8> %indices, i32 11
  %index12 = extractelement <32 x i8> %indices, i32 12
  %index13 = extractelement <32 x i8> %indices, i32 13
  %index14 = extractelement <32 x i8> %indices, i32 14
  %index15 = extractelement <32 x i8> %indices, i32 15
  %index16 = extractelement <32 x i8> %indices, i32 16
  %index17 = extractelement <32 x i8> %indices, i32 17
  %index18 = extractelement <32 x i8> %indices, i32 18
  %index19 = extractelement <32 x i8> %indices, i32 19
  %index20 = extractelement <32 x i8> %indices, i32 20
  %index21 = extractelement <32 x i8> %indices, i32 21
  %index22 = extractelement <32 x i8> %indices, i32 22
  %index23 = extractelement <32 x i8> %indices, i32 23
  %index24 = extractelement <32 x i8> %indices, i32 24
  %index25 = extractelement <32 x i8> %indices, i32 25
  %index26 = extractelement <32 x i8> %indices, i32 26
  %index27 = extractelement <32 x i8> %indices, i32 27
  %index28 = extractelement <32 x i8> %indices, i32 28
  %index29 = extractelement <32 x i8> %indices, i32 29
  %index30 = extractelement <32 x i8> %indices, i32 30
  %index31 = extractelement <32 x i8> %indices, i32 31
  %v0 = extractelement <16 x i8> %v, i8 %index0
  %v1 = extractelement <16 x i8> %v, i8 %index1
  %v2 = extractelement <16 x i8> %v, i8 %index2
  %v3 = extractelement <16 x i8> %v, i8 %index3
  %v4 = extractelement <16 x i8> %v, i8 %index4
  %v5 = extractelement <16 x i8> %v, i8 %index5
  %v6 = extractelement <16 x i8> %v, i8 %index6
  %v7 = extractelement <16 x i8> %v, i8 %index7
  %v8 = extractelement <16 x i8> %v, i8 %index8
  %v9 = extractelement <16 x i8> %v, i8 %index9
  %v10 = extractelement <16 x i8> %v, i8 %index10
  %v11 = extractelement <16 x i8> %v, i8 %index11
  %v12 = extractelement <16 x i8> %v, i8 %index12
  %v13 = extractelement <16 x i8> %v, i8 %index13
  %v14 = extractelement <16 x i8> %v, i8 %index14
  %v15 = extractelement <16 x i8> %v, i8 %index15
  %v16 = extractelement <16 x i8> %v, i8 %index16
  %v17 = extractelement <16 x i8> %v, i8 %index17
  %v18 = extractelement <16 x i8> %v, i8 %index18
  %v19 = extractelement <16 x i8> %v, i8 %index19
  %v20 = extractelement <16 x i8> %v, i8 %index20
  %v21 = extractelement <16 x i8> %v, i8 %index21
  %v22 = extractelement <16 x i8> %v, i8 %index22
  %v23 = extractelement <16 x i8> %v, i8 %index23
  %v24 = extractelement <16 x i8> %v, i8 %index24
  %v25 = extractelement <16 x i8> %v, i8 %index25
  %v26 = extractelement <16 x i8> %v, i8 %index26
  %v27 = extractelement <16 x i8> %v, i8 %index27
  %v28 = extractelement <16 x i8> %v, i8 %index28
  %v29 = extractelement <16 x i8> %v, i8 %index29
  %v30 = extractelement <16 x i8> %v, i8 %index30
  %v31 = extractelement <16 x i8> %v, i8 %index31
  %ret0 = insertelement <32 x i8> undef, i8 %v0, i32 0
  %ret1 = insertelement <32 x i8> %ret0, i8 %v1, i32 1
  %ret2 = insertelement <32 x i8> %ret1, i8 %v2, i32 2
  %ret3 = insertelement <32 x i8> %ret2, i8 %v3, i32 3
  %ret4 = insertelement <32 x i8> %ret3, i8 %v4, i32 4
  %ret5 = insertelement <32 x i8> %ret4, i8 %v5, i32 5
  %ret6 = insertelement <32 x i8> %ret5, i8 %v6, i32 6
  %ret7 = insertelement <32 x i8> %ret6, i8 %v7, i32 7
  %ret8 = insertelement <32 x i8> %ret7, i8 %v8, i32 8
  %ret9 = insertelement <32 x i8> %ret8, i8 %v9, i32 9
  %ret10 = insertelement <32 x i8> %ret9, i8 %v10, i32 10
  %ret11 = insertelement <32 x i8> %ret10, i8 %v11, i32 11
  %ret12 = insertelement <32 x i8> %ret11, i8 %v12, i32 12
  %ret13 = insertelement <32 x i8> %ret12, i8 %v13, i32 13
  %ret14 = insertelement <32 x i8> %ret13, i8 %v14, i32 14
  %ret15 = insertelement <32 x i8> %ret14, i8 %v15, i32 15
  %ret16 = insertelement <32 x i8> %ret15, i8 %v16, i32 16
  %ret17 = insertelement <32 x i8> %ret16, i8 %v17, i32 17
  %ret18 = insertelement <32 x i8> %ret17, i8 %v18, i32 18
  %ret19 = insertelement <32 x i8> %ret18, i8 %v19, i32 19
  %ret20 = insertelement <32 x i8> %ret19, i8 %v20, i32 20
  %ret21 = insertelement <32 x i8> %ret20, i8 %v21, i32 21
  %ret22 = insertelement <32 x i8> %ret21, i8 %v22, i32 22
  %ret23 = insertelement <32 x i8> %ret22, i8 %v23, i32 23
  %ret24 = insertelement <32 x i8> %ret23, i8 %v24, i32 24
  %ret25 = insertelement <32 x i8> %ret24, i8 %v25, i32 25
  %ret26 = insertelement <32 x i8> %ret25, i8 %v26, i32 26
  %ret27 = insertelement <32 x i8> %ret26, i8 %v27, i32 27
  %ret28 = insertelement <32 x i8> %ret27, i8 %v28, i32 28
  %ret29 = insertelement <32 x i8> %ret28, i8 %v29, i32 29
  %ret30 = insertelement <32 x i8> %ret29, i8 %v30, i32 30
  %ret31 = insertelement <32 x i8> %ret30, i8 %v31, i32 31
  ret <32 x i8> %ret31
}

define <4 x double> @var_shuffle_v4f64_from_v2f64(<2 x double> %v, <4 x i64> %indices) nounwind {
; XOP-LABEL: var_shuffle_v4f64_from_v2f64:
; XOP:       # %bb.0:
; XOP-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm0, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4f64_from_v2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm3
; AVX1-NEXT:    vpermilpd %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpermilpd %ymm3, %ymm0, %ymm2
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v4f64_from_v2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v4f64_from_v2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_v4f64_from_v2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vpermpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %index0 = extractelement <4 x i64> %indices, i32 0
  %index1 = extractelement <4 x i64> %indices, i32 1
  %index2 = extractelement <4 x i64> %indices, i32 2
  %index3 = extractelement <4 x i64> %indices, i32 3
  %v0 = extractelement <2 x double> %v, i64 %index0
  %v1 = extractelement <2 x double> %v, i64 %index1
  %v2 = extractelement <2 x double> %v, i64 %index2
  %v3 = extractelement <2 x double> %v, i64 %index3
  %ret0 = insertelement <4 x double> undef, double %v0, i32 0
  %ret1 = insertelement <4 x double> %ret0, double %v1, i32 1
  %ret2 = insertelement <4 x double> %ret1, double %v2, i32 2
  %ret3 = insertelement <4 x double> %ret2, double %v3, i32 3
  ret <4 x double> %ret3
}

define <8 x float> @var_shuffle_v8f32_from_v4f32(<4 x float> %v, <8 x i32> %indices) unnamed_addr nounwind {
; XOP-LABEL: var_shuffle_v8f32_from_v4f32:
; XOP:       # %bb.0: # %entry
; XOP-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpermil2ps $0, %ymm1, %ymm0, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v8f32_from_v4f32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; INT256-LABEL: var_shuffle_v8f32_from_v4f32:
; INT256:       # %bb.0: # %entry
; INT256-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; INT256-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; INT256-NEXT:    retq
entry:
  %tmp1 = extractelement <8 x i32> %indices, i32 0
  %vecext2.8 = extractelement <4 x float> %v, i32 %tmp1
  %tmp2 = extractelement <8 x i32> %indices, i32 1
  %vecext2.9 = extractelement <4 x float> %v, i32 %tmp2
  %tmp3 = extractelement <8 x i32> %indices, i32 2
  %vecext2.10 = extractelement <4 x float> %v, i32 %tmp3
  %tmp4 = extractelement <8 x i32> %indices, i32 3
  %vecext2.11 = extractelement <4 x float> %v, i32 %tmp4
  %tmp5 = extractelement <8 x i32> %indices, i32 4
  %vecext2.12 = extractelement <4 x float> %v, i32 %tmp5
  %tmp6 = extractelement <8 x i32> %indices, i32 5
  %vecext2.13 = extractelement <4 x float> %v, i32 %tmp6
  %tmp7 = extractelement <8 x i32> %indices, i32 6
  %vecext2.14 = extractelement <4 x float> %v, i32 %tmp7
  %tmp8 = extractelement <8 x i32> %indices, i32 7
  %vecext2.15 = extractelement <4 x float> %v, i32 %tmp8
  %tmp9 = insertelement <8 x float> undef, float %vecext2.8, i32 0
  %tmp10 = insertelement <8 x float> %tmp9, float %vecext2.9, i32 1
  %tmp11 = insertelement <8 x float> %tmp10, float %vecext2.10, i32 2
  %tmp12 = insertelement <8 x float> %tmp11, float %vecext2.11, i32 3
  %tmp13 = insertelement <8 x float> %tmp12, float %vecext2.12, i32 4
  %tmp14 = insertelement <8 x float> %tmp13, float %vecext2.13, i32 5
  %tmp15 = insertelement <8 x float> %tmp14, float %vecext2.14, i32 6
  %tmp16 = insertelement <8 x float> %tmp15, float %vecext2.15, i32 7
  ret <8 x float> %tmp16
}

define <4 x i32> @var_shuffle_v4i32_from_v8i32(<8 x i32> %v, <4 x i32> %indices) unnamed_addr nounwind {
; XOP-LABEL: var_shuffle_v4i32_from_v8i32:
; XOP:       # %bb.0: # %entry
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOP-NEXT:    vpermil2ps $0, %xmm1, %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vzeroupper
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4i32_from_v8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpermilps %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpermilps %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; INT256-LABEL: var_shuffle_v4i32_from_v8i32:
; INT256:       # %bb.0: # %entry
; INT256-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; INT256-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; INT256-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; INT256-NEXT:    vzeroupper
; INT256-NEXT:    retq
entry:
  %tmp1 = extractelement <4 x i32> %indices, i32 0
  %vecext2.8 = extractelement <8 x i32> %v, i32 %tmp1
  %tmp2 = extractelement <4 x i32> %indices, i32 1
  %vecext2.9 = extractelement <8 x i32> %v, i32 %tmp2
  %tmp3 = extractelement <4 x i32> %indices, i32 2
  %vecext2.10 = extractelement <8 x i32> %v, i32 %tmp3
  %tmp4 = extractelement <4 x i32> %indices, i32 3
  %vecext2.11 = extractelement <8 x i32> %v, i32 %tmp4
  %tmp9 = insertelement <4 x i32> undef, i32 %vecext2.8, i32 0
  %tmp10 = insertelement <4 x i32> %tmp9, i32 %vecext2.9, i32 1
  %tmp11 = insertelement <4 x i32> %tmp10, i32 %vecext2.10, i32 2
  %tmp12 = insertelement <4 x i32> %tmp11, i32 %vecext2.11, i32 3
  ret <4 x i32> %tmp12
}

;
; PR50356 - correctly adjust the indices vector to match the source/destination size.
;

define <4 x i64> @PR50356(<4 x i64> %0, <4 x i32> %1, <4 x i64> %2) unnamed_addr nounwind {
; XOP-LABEL: PR50356:
; XOP:       # %bb.0:
; XOP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vpermil2pd $0, %xmm1, %xmm3, %xmm0, %xmm0
; XOP-NEXT:    vpcomltq %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vextractf128 $1, %ymm2, %xmm1
; XOP-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOP-NEXT:    vpcomltq %xmm1, %xmm2, %xmm1
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    vmovapd {{.*#+}} ymm1 = [34,68,102,136]
; XOP-NEXT:    vblendvpd %ymm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: PR50356:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpermilpd %xmm1, %xmm3, %xmm3
; AVX1-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [34,68,102,136]
; AVX1-NEXT:    vblendvpd %ymm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR50356:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $64, %rsp
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX2-NEXT:    andl $3, %eax
; AVX2-NEXT:    vpextrd $1, %xmm1, %ecx
; AVX2-NEXT:    andl $3, %ecx
; AVX2-NEXT:    vmovq (%rsp,%rcx,8), %xmm0 # xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq (%rsp,%rax,8), %xmm1 # xmm1 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vmovapd {{.*#+}} ymm1 = [34,68,102,136]
; AVX2-NEXT:    vblendvpd %ymm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: PR50356:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-32, %rsp
; AVX512-NEXT:    subq $64, %rsp
; AVX512-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512-NEXT:    vmovd %xmm1, %eax
; AVX512-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512-NEXT:    andl $3, %eax
; AVX512-NEXT:    vpextrd $1, %xmm1, %ecx
; AVX512-NEXT:    andl $3, %ecx
; AVX512-NEXT:    vmovq (%rsp,%rcx,8), %xmm0 # xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq (%rsp,%rax,8), %xmm1 # xmm1 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpcmpgtq %zmm0, %zmm2, %k1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [17,51,85,119]
; AVX512-NEXT:    vpmovzxbq {{.*#+}} ymm0 = [34,68,102,136]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: PR50356:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    pushq %rbp
; AVX512VL-NEXT:    movq %rsp, %rbp
; AVX512VL-NEXT:    andq $-32, %rsp
; AVX512VL-NEXT:    subq $64, %rsp
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512VL-NEXT:    andl $3, %eax
; AVX512VL-NEXT:    vpextrd $1, %xmm1, %ecx
; AVX512VL-NEXT:    andl $3, %ecx
; AVX512VL-NEXT:    vmovq (%rsp,%rcx,8), %xmm0 # xmm0 = mem[0],zero
; AVX512VL-NEXT:    vmovq (%rsp,%rax,8), %xmm1 # xmm1 = mem[0],zero
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vpcmpgtq %ymm0, %ymm2, %k1
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} ymm0 = [34,68,102,136]
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} ymm0 {%k1} = [17,51,85,119]
; AVX512VL-NEXT:    movq %rbp, %rsp
; AVX512VL-NEXT:    popq %rbp
; AVX512VL-NEXT:    retq
  %v9 = and <4 x i32> %1, <i32 7, i32 7, i32 7, i32 7>
  %v10 = extractelement <4 x i32> %v9, i32 0
  %v11 = extractelement <4 x i64> %0, i32 %v10
  %v14 = extractelement <4 x i32> %v9, i32 1
  %v15 = extractelement <4 x i64> %0, i32 %v14
  %v27 = insertelement <4 x i64> zeroinitializer, i64 %v11, i32 0
  %v28 = insertelement <4 x i64> %v27, i64 %v15, i32 1
  %v36 = icmp slt <4 x i64> %v28, %2
  %v37 = select <4 x i1> %v36, <4 x i64> <i64 17, i64 51, i64 85, i64 119>, <4 x i64> <i64 34, i64 68, i64 102, i64 136> ; 17 68 102 136
  ret <4 x i64> %v37
}

define <4 x i64> @var_shuffle_v4i64_with_v16i8_indices(<4 x i64> %v, <16 x i8> %indices) unnamed_addr nounwind {
; XOP-LABEL: var_shuffle_v4i64_with_v16i8_indices:
; XOP:       # %bb.0:
; XOP-NEXT:    vpsrld $16, %xmm1, %xmm2
; XOP-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; XOP-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; XOP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; XOP-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vpaddq %xmm2, %xmm2, %xmm2
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; XOP-NEXT:    vpermil2pd $0, %ymm1, %ymm3, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX1-LABEL: var_shuffle_v4i64_with_v16i8_indices:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm2
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpaddq %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm4
; AVX1-NEXT:    vpermilpd %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilpd %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}+16(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vblendvpd %ymm1, %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shuffle_v4i64_with_v16i8_indices:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbq {{.*#+}} ymm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero,xmm1[2],zero,zero,zero,zero,zero,zero,zero,xmm1[3],zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpaddq %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm3, %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: var_shuffle_v4i64_with_v16i8_indices:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} ymm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero,xmm1[2],zero,zero,zero,zero,zero,zero,zero,xmm1[3],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpermq %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shuffle_v4i64_with_v16i8_indices:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} ymm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero,xmm1[2],zero,zero,zero,zero,zero,zero,zero,xmm1[3],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpermq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %index0 = extractelement <16 x i8> %indices, i32 0
  %index1 = extractelement <16 x i8> %indices, i32 1
  %index2 = extractelement <16 x i8> %indices, i32 2
  %index3 = extractelement <16 x i8> %indices, i32 3
  %v0 = extractelement <4 x i64> %v, i8 %index0
  %v1 = extractelement <4 x i64> %v, i8 %index1
  %v2 = extractelement <4 x i64> %v, i8 %index2
  %v3 = extractelement <4 x i64> %v, i8 %index3
  %ret0 = insertelement <4 x i64> undef, i64 %v0, i32 0
  %ret1 = insertelement <4 x i64> %ret0, i64 %v1, i32 1
  %ret2 = insertelement <4 x i64> %ret1, i64 %v2, i32 2
  %ret3 = insertelement <4 x i64> %ret2, i64 %v3, i32 3
  ret <4 x i64> %ret3
}
