/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "textautogeneratewidgetgui.h"
#include "core/textautogeneratemanager.h"
#include "textautogeneratetext/textautogenerateconfiguredialog.h"
#include "textautogeneratetext/textautogeneratedialog.h"
#include <QHBoxLayout>
#include <QPushButton>

TextAutoGenerateWidgetGui::TextAutoGenerateWidgetGui(QWidget *parent)
    : QWidget{parent}
{
    auto mainLayout = new QHBoxLayout(this);
    mainLayout->setContentsMargins({});
    auto configureButton = new QPushButton(QStringLiteral("Configure..."), this);
    mainLayout->addWidget(configureButton, 0, Qt::AlignTop);
    connect(configureButton, &QPushButton::clicked, this, [this]() {
        auto manager = new TextAutoGenerateText::TextAutoGenerateManager(this);
        TextAutoGenerateText::TextAutoGenerateConfigureDialog d(manager, this);
        if (d.exec()) {
            d.saveSettings();
        }
    });

    auto showGenerateDialogButton = new QPushButton(QStringLiteral("Show Dialog..."), this);
    mainLayout->addWidget(showGenerateDialogButton, 0, Qt::AlignTop);
    connect(showGenerateDialogButton, &QPushButton::clicked, this, [this]() {
        TextAutoGenerateText::TextAutoGenerateDialog d(this);
        d.exec();
    });
}

TextAutoGenerateWidgetGui::~TextAutoGenerateWidgetGui() = default;

#include "moc_textautogeneratewidgetgui.cpp"
