/*****************************************************************************
 Copyright (c) 2023-2024, Intel Corporation
 Copyright (c) 2022, Nokia

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* SNOW3G_f9 */
#include "mac_test.h"

const struct mac_test snow3g_hash_test_vectors_json[] = {
        { 128, 32, 1, "\x2b\xd6\x45\x9f\x82\xc5\xb3\x00\x95\x2c\x49\x10\x48\x81\xff\x48",
          "\x6b\x22\x77\x37\x29\x6f\x39\x3c\x80\x79\x35\x3e\xdc\x87\xe2\xe8\x05\xd2"
          "\xec\x49\xa4\xf2\xd8\xe0",
          "\x2b\xce\x18\x20", 1, 189,
          "\x38\xa6\xf0\x56\x05\xd2\xec\x49\x38\xa6\xf0\x56\x05\xd2\xec\x49", 128 },
        { 128, 32, 2, "\xd4\x2f\x68\x24\x28\x20\x1c\xaf\xcd\x9f\x97\x94\x5e\x6d\xe7\xb7",
          "\xb5\x92\x43\x84\x32\x8a\x4a\xe0\x0b\x73\x71\x09\xf8\xb6\xc8\xdd\x2b\x4d"
          "\xb6\x3d\xd5\x33\x98\x1c\xeb\x19\xaa\xd5\x2a\x5b\x2b\xc0",
          "\xfc\x7b\x18\xbd", 1, 254,
          "\x3e\xdc\x87\xe2\xa4\xf2\xd8\xe2\xbe\xdc\x87\xe2\xa4\xf2\x58\xe2", 128 },
        { 128, 32, 3, "\xfd\xb9\xcf\xdf\x28\x93\x6c\xc4\x83\xa3\x18\x69\xd8\x1b\x8f\xab",
          "\x59\x32\xbc\x0a\xce\x2b\x0a\xba\x33\xd8\xac\x18\x8a\xc5\x4f\x34\x6f\xad"
          "\x10\xbf\x9d\xee\x29\x20\xb4\x3b\xd0\xc5\x3a\x91\x5c\xb7\xdf\x6c\xaa\x72"
          "\x05\x3a\xbf\xf2",
          "\x02\xf1\xfa\xaf", 1, 319,
          "\x36\xaf\x61\x44\x98\x38\xf0\x3a\xb6\xaf\x61\x44\x98\x38\x70\x3a", 128 },
        { 128, 32, 4, "\xc7\x36\xc6\xaa\xb2\x2b\xff\xf9\x1e\x26\x98\xd2\xe2\x2a\xd5\x7e",
          "\xd0\xa7\xd4\x63\xdf\x9f\xb2\xb2\x78\x83\x3f\xa0\x2e\x23\x5a\xa1\x72\xbd"
          "\x97\x0c\x14\x73\xe1\x29\x07\xfb\x64\x8b\x65\x99\xaa\xa0\xb2\x4a\x03\x86"
          "\x65\x42\x2b\x20\xa4\x99\x27\x6a\x50\x42\x70\x09",
          "\x38\xb5\x54\xc0", 1, 384,
          "\x14\x79\x3e\x41\x03\x97\xe8\xfd\x94\x79\x3e\x41\x03\x97\x68\xfd", 128 },
        { 128, 32, 5, "\xf4\xeb\xec\x69\xe7\x3e\xaf\x2e\xb2\xcf\x6a\xf4\xb3\x12\x0f\xfd",
          "\x10\xbf\xff\x83\x9e\x0c\x71\x65\x8d\xbb\x2d\x17\x07\xe1\x45\x72\x4f\x41"
          "\xc1\x6f\x48\xbf\x40\x3c\x3b\x18\xe3\x8f\xd5\xd1\x66\x3b\x6f\x6d\x90\x01"
          "\x93\xe3\xce\xa8\xbb\x4f\x1b\x4f\x5b\xe8\x22\x03\x22\x32\xa7\x8d\x7d\x75"
          "\x23\x8d\x5e\x6d\xae\xcd\x3b\x43\x22\xcf\x59\xbc\x7e\xa8\x4a\xb1\x88\x11"
          "\xb5\xbf\xb7\xbc\x55\x3f\x4f\xe4\x44\x78\xce\x28\x7a\x14\x87\x99\x90\xd1"
          "\x8d\x12\xca\x79\xd2\xc8\x55\x14\x90\x21\xcd\x5c\xe8\xca\x03\x71\xca\x04"
          "\xfc\xce\x14\x3e\x3d\x7c\xfe\xe9\x45\x85\xb5\x88\x5c\xac\x46\x06\x8b",
          "\x06\x17\x45\xae", 1, 1000,
          "\x29\x6f\x39\x3c\x6b\x22\x77\x37\xa9\x6f\x39\x3c\x6b\x22\xf7\x37", 128 },
        { 128, 32, 6, "\xb3\x12\x0f\xfd\xb2\xcf\x6a\xf4\xe7\x3e\xaf\x2e\xf4\xeb\xec\x69",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x01\x01\x01\x01\x01\xe0\x95"
          "\x80\x45\xf3\xa0\xbb\xa4\xe3\x96\x83\x46\xf0\xa3\xb8\xa7\xc0\x2a\x01\x8a"
          "\xe6\x40\x76\x52\x26\xb9\x87\xc9\x13\xe6\xcb\xf0\x83\x57\x00\x16\xcf\x83"
          "\xef\xbc\x61\xc0\x82\x51\x3e\x21\x56\x1a\x42\x7c\x00\x9d\x28\xc2\x98\xef"
          "\xac\xe7\x8e\xd6\xd5\x6c\x2d\x45\x05\xad\x03\x2e\x9c\x04\xdc\x60\xe7\x3a"
          "\x81\x69\x6d\xa6\x65\xc6\xc4\x86\x03\xa5\x7b\x45\xab\x33\x22\x15\x85\xe6"
          "\x8e\xe3\x16\x91\x87\xfb\x02\x39\x52\x86\x32\xdd\x65\x6c\x80\x7e\xa3\x24"
          "\x8b\x7b\x46\xd0\x02\xb2\xb5\xc7\x45\x8e\xb8\x5b\x9c\xe9\x58\x79\xe0\x34"
          "\x08\x59\x05\x5e\x3b\x0a\xbb\xc3\xea\xce\x87\x19\xca\xa8\x02\x65\xc9\x72"
          "\x05\xd5\xdc\x4b\xcc\x90\x2f\xe1\x83\x96\x29\xed\x71\x32\x8a\x0f\x04\x49"
          "\xf5\x88\x55\x7e\x68\x98\x86\x0e\x04\x2a\xec\xd8\x4b\x24\x04\xc2\x12\xc9"
          "\x22\x2d\xa5\xbf\x8a\x89\xef\x67\x97\x87\x0c\xf5\x07\x71\xa6\x0f\x66\xa2"
          "\xee\x62\x85\x36\x57\xad\xdf\x04\xcd\xde\x07\xfa\x41\x4e\x11\xf1\x2b\x4d"
          "\x81\xb9\xb4\xe8\xac\x53\x8e\xa3\x06\x66\x68\x8d\x88\x1f\x6c\x34\x84\x21"
          "\x99\x2f\x31\xb9\x4f\x88\x06\xed\x8f\xcc\xff\x4c\x91\x23\xb8\x96\x42\x52"
          "\x7a\xd6\x13\xb1\x09\xbf\x75\x16\x74\x85\xf1\x26\x8b\xf8\x84\xb4\xcd\x23"
          "\xd2\x9a\x09\x34\x92\x57\x03\xd6\x34\x09\x8f\x77\x67\xf1\xbe\x74\x91\xe7"
          "\x08\xa8\xbb\x94\x9a\x38\x73\x70\x8a\xef\x4a\x36\x23\x9e\x50\xcc\x08\x23"
          "\x5c\xd5\xed\x6b\xbe\x57\x86\x68\xa1\x7b\x58\xc1\x17\x1d\x0b\x90\xe8\x13"
          "\xa9\xe4\xf5\x8a\x89\xd7\x19\xb1\x10\x42\xd6\x36\x0b\x1b\x0f\x52\xde\xb7"
          "\x30\xa5\x8d\x58\xfa\xf4\x63\x15\x95\x4b\x0a\x87\x26\x91\x47\x59\x77\xdc"
          "\x88\xc0\xd7\x33\xfe\xff\x54\x60\x0a\x0c\xc1\xd0\x30\x0a\xaa\xeb\x94\x57"
          "\x2c\x6e\x95\xb0\x1a\xe9\x0d\xe0\x4f\x1d\xce\x47\xf8\x7e\x8f\xa7\xbe\xbf"
          "\x77\xe1\xdb\xc2\x0d\x6b\xa8\x5c\xb9\x14\x3d\x51\x8b\x28\x5d\xfa\x04\xb6"
          "\x98\xbf\x0c\xf7\x81\x9f\x20\xfa\x7a\x28\x8e\xb0\x70\x3d\x99\x5c\x59\x94"
          "\x0c\x7c\x66\xde\x57\xa9\xb7\x0f\x82\x37\x9b\x70\xe2\x03\x1e\x45\x0f\xcf"
          "\xd2\x18\x13\x26\xfc\xd2\x8d\x88\x23\xba\xaa\x80\xdf\x6e\x0f\x44\x35\x59"
          "\x64\x75\x39\xfd\x89\x07\xc0\xff\xd9\xd7\x9c\x13\x0e\xd8\x1c\x9a\xfd\x9b"
          "\x7e\x84\x8c\x9f\xed\x38\x44\x3d\x5d\x38\x0e\x53\xfb\xdb\x8a\xc8\xc3\xd3"
          "\xf0\x68\x76\x05\x4f\x12\x24\x61\x10\x7d\xe9\x2f\xea\x09\xc6\xf6\x92\x3a"
          "\x18\x8d\x53\xaf\xe5\x4a\x10\xf6\x0e\x6e\x9d\x5a\x03\xd9\x96\xb5\xfb\xc8"
          "\x20\xf8\xa6\x37\x11\x6a\x27\xad\x04\xb4\x44\xa0\x93\x2d\xd6\x0f\xbd\x12"
          "\x67\x1c\x11\xe1\xc0\xec\x73\xe7\x89\x87\x9f\xaa\x3d\x42\xc6\x4d\x20\xcd"
          "\x12\x52\x74\x2a\x37\x68\xc2\x5a\x90\x15\x85\x88\x8e\xce\xe1\xe6\x12\xd9"
          "\x93\x6b\x40\x3b\x07\x75\x94\x9a\x66\xcd\xfd\x99\xa2\x9b\x13\x45\xba\xa8"
          "\xd9\xd5\x40\x0c\x91\x02\x4b\x0a\x60\x73\x63\xb0\x13\xce\x5d\xe9\xae\x86"
          "\x9d\x3b\x8d\x95\xb0\x57\x0b\x3c\x2d\x39\x14\x22\xd3\x24\x50\xcb\xcf\xae"
          "\x96\x65\x22\x86\xe9\x6d\xec\x12\x14\xa9\x34\x65\x27\x98\x0a\x81\x92\xea"
          "\xc1\xc3\x9a\x3a\xaf\x6f\x15\x35\x1d\xa6\xbe\x76\x4d\xf8\x97\x72\xec\x04"
          "\x07\xd0\x6e\x44\x15\xbe\xfa\xe7\xc9\x25\x80\xdf\x9b\xf5\x07\x49\x7c\x8f"
          "\x29\x95\x16\x0d\x4e\x21\x8d\xaa\xcb\x02\x94\x4a\xbf\x83\x34\x0c\xe8\xbe"
          "\x16\x86\xa9\x60\xfa\xf9\x0e\x2d\x90\xc5\x5c\xc6\x47\x5b\xab\xc3\x17\x1a"
          "\x80\xa3\x63\x17\x49\x54\x95\x5d\x71\x01\xda\xb1\x6a\xe8\x17\x91\x67\xe2"
          "\x14\x44\xb4\x43\xa9\xea\xaa\x7c\x91\xde\x36\xd1\x18\xc3\x9d\x38\x9f\x8d"
          "\xd4\x46\x9a\x84\x6c\x9a\x26\x2b\xf7\xfa\x18\x48\x7a\x79\xe8\xde\x11\x69"
          "\x9e\x0b\x8f\xdf\x55\x7c\xb4\x87\x19\xd4\x53\xba\x71\x30\x56\x10\x9b\x93"
          "\xa2\x18\xc8\x96\x75\xac\x19\x5f\xb4\xfb\x06\x63\x9b\x37\x97\x14\x49\x55"
          "\xb3\xc9\x32\x7d\x1a\xec\x00\x3d\x42\xec\xd0\xea\x98\xab\xf1\x9f\xfb\x4a"
          "\xf3\x56\x1a\x67\xe7\x7c\x35\xbf\x15\xc5\x9c\x24\x12\xda\x88\x1d\xb0\x2b"
          "\x1b\xfb\xce\xbf\xac\x51\x52\xbc\x99\xbc\x3f\x1d\x15\xf7\x71\x00\x1b\x70"
          "\x29\xfe\xdb\x02\x8f\x8b\x85\x2b\xc4\x40\x7e\xb8\x3f\x89\x1c\x9c\xa7\x33"
          "\x25\x4f\xdd\x1e\x9e\xdb\x56\x91\x9c\xe9\xfe\xa2\x1c\x17\x40\x72\x52\x1c"
          "\x18\x31\x9a\x54\xb5\xd4\xef\xbe\xbd\xdf\x1d\x8b\x69\xb1\xcb\xf2\x5f\x48"
          "\x9f\xcc\x98\x13\x72\x54\x7c\xf4\x1d\x00\x8e\xf0\xbc\xa1\x92\x6f\x93\x4b"
          "\x73\x5e\x09\x0b\x3b\x25\x1e\xb3\x3a\x36\xf8\x2e\xd9\xb2\x9c\xf4\xcb\x94"
          "\x41\x88\xfa\x0e\x1e\x38\xdd\x77\x8f\x7d\x1c\x9d\x98\x7b\x28\xd1\x32\xdf"
          "\xb9\x73\x1f\xa4\xf4\xb4\x16\x93\x5b\xe4\x9d\xe3\x05\x16\xaf\x35\x78\x58"
          "\x1f\x2f\x13\xf5\x61\xc0\x66\x33\x61\x94\x1e\xab\x24\x9a\x4b\xc1\x23\xf8"
          "\xd1\x5c\xd7\x11\xa9\x56\xa1\xbf\x20\xfe\x6e\xb7\x8a\xea\x23\x73\x36\x1d"
          "\xa0\x42\x6c\x79\xa5\x30\xc3\xbb\x1d\xe0\xc9\x97\x22\xef\x1f\xde\x39\xac"
          "\x2b\x00\xa0\xa8\xee\x7c\x80\x0a\x08\xbc\x22\x64\xf8\x9f\x4e\xff\xe6\x27"
          "\xac\x2f\x05\x31\xfb\x55\x4f\x6d\x21\xd7\x4c\x59\x0a\x70\xad\xfa\xa3\x90"
          "\xbd\xfb\xb3\xd6\x8e\x46\x21\x5c\xab\x18\x7d\x23\x68\xd5\xa7\x1f\x5e\xbe"
          "\xc0\x81\xcd\x3b\x20\xc0\x82\xdb\xe4\xcd\x2f\xac\xa2\x87\x73\x79\x5d\x6b"
          "\x0c\x10\x20\x4b\x65\x9a\x93\x9e\xf2\x9b\xbe\x10\x88\x24\x36\x24\x42\x99"
          "\x27\xa7\xeb\x57\x6d\xd3\xa0\x0e\xa5\xe0\x1a\xf5\xd4\x75\x83\xb2\x27\x2c"
          "\x0c\x16\x1a\x80\x65\x21\xa1\x6f\xf9\xb0\xa7\x22\xc0\xcf\x26\xb0\x25\xd5"
          "\x83\x6e\x22\x58\xa4\xf7\xd4\x77\x3a\xc8\x01\xe4\x26\x3b\xc2\x94\xf4\x3d"
          "\xef\x7f\xa8\x70\x3f\x3a\x41\x97\x46\x35\x25\x88\x76\x52\xb0\xb2\xa4\xa2"
          "\xa7\xcf\x87\xf0\x09\x14\x87\x1e\x25\x03\x91\x13\xc7\xe1\x61\x8d\xa3\x40"
          "\x64\xb5\x7a\x43\xc4\x63\x24\x9f\xb8\xd0\x5e\x0f\x26\xf4\xa6\xd8\x49\x72"
          "\xe7\xa9\x05\x48\x24\x14\x5f\x91\x29\x5c\xdb\xe3\x9a\x6f\x92\x0f\xac\xc6"
          "\x59\x71\x2b\x46\xa5\x4b\xa2\x95\xbb\xe6\xa9\x01\x54\xe9\x1b\x33\x98\x5a"
          "\x2b\xcd\x42\x0a\xd5\xc6\x7e\xc9\xad\x8e\xb7\xac\x68\x64\xdb\x27\x2a\x51"
          "\x6b\xc9\x4c\x28\x39\xb0\xa8\x16\x9a\x6b\xf5\x8e\x1a\x0c\x2a\xda\x8c\x88"
          "\x3b\x7b\xf4\x97\xa4\x91\x71\x26\x8e\xd1\x5d\xdd\x29\x69\x38\x4e\x7f\xf4"
          "\xbf\x4a\xab\x2e\xc9\xec\xc6\x52\x9c\xf6\x29\xe2\xdf\x0f\x08\xa7\x7a\x65"
          "\xaf\xa1\x2a\xa9\xb5\x05\xdf\x8b\x28\x7e\xf6\xcc\x91\x49\x3d\x1c\xaa\x39"
          "\x07\x6e\x28\xef\x1e\xa0\x28\xf5\x11\x8d\xe6\x1a\xe0\x2b\xb6\xae\xfc\x33"
          "\x43\xa0\x50\x29\x2f\x19\x9f\x40\x18\x57\xb2\xbe\xad\x5e\x6e\xe2\xa1\xf1"
          "\x91\x02\x2f\x92\x78\x01\x6f\x04\x77\x91\xa9\xd1\x8d\xa7\xd2\xa6\xd2\x7f"
          "\x2e\x0e\x51\xc2\xf6\xea\x30\xe8\xac\x49\xa0\x60\x4f\x4c\x13\x54\x2e\x85"
          "\xb6\x83\x81\xb9\xfd\xcf\xa0\xce\x4b\x2d\x34\x13\x54\x85\x2d\x36\x02\x45"
          "\xc5\x36\xb6\x12\xaf\x71\xf3\xe7\x7c\x90\x95\xae\x2d\xbd\xe5\x04\xb2\x65"
          "\x73\x3d\xab\xfe\x10\xa2\x0f\xc7\xd6\xd3\x2c\x21\xcc\xc7\x2b\x8b\x34\x44"
          "\xae\x66\x3d\x65\x92\x2d\x17\xf8\x2c\xaa\x2b\x86\x5c\xd8\x89\x13\xd2\x91"
          "\xa6\x58\x99\x02\x6e\xa1\x32\x84\x39\x72\x3c\x19\x8c\x36\xb0\xc3\xc8\xd0"
          "\x85\xbf\xaf\x8a\x32\x0f\xde\x33\x4b\x4a\x49\x19\xb4\x4c\x2b\x95\xf6\xe8"
          "\xec\xf7\x33\x93\xf7\xf0\xd2\xa4\x0e\x60\xb1\xd4\x06\x52\x6b\x02\x2d\xdc"
          "\x33\x18\x10\xb1\xa5\xf7\xc3\x47\xbd\x53\xed\x1f\x10\x5d\x6a\x0d\x30\xab"
          "\xa4\x77\xe1\x78\x88\x9a\xb2\xec\x55\xd5\x58\xde\xab\x26\x30\x20\x43\x36"
          "\x96\x2b\x4d\xb5\xb6\x63\xb6\x90\x2b\x89\xe8\x5b\x31\xbc\x6a\xf5\x0f\xc5"
          "\x0a\xcc\xb3\xfb\x9b\x57\xb6\x63\x29\x70\x31\x37\x8d\xb4\x78\x96\xd7\xfb"
          "\xaf\x6c\x60\x0a\xdd\x2c\x67\xf9\x36\xdb\x03\x79\x86\xdb\x85\x6e\xb4\x9c"
          "\xf2\xdb\x3f\x7d\xa6\xd2\x36\x50\xe4\x38\xf1\x88\x40\x41\xb0\x13\x11\x9e"
          "\x4c\x2a\xe5\xaf\x37\xcc\xcd\xfb\x68\x66\x07\x38\xb5\x8b\x3c\x59\xd1\xc0"
          "\x24\x84\x37\x47\x2a\xba\x1f\x35\xca\x1f\xb9\x0c\xd7\x14\xaa\x9f\x63\x55"
          "\x34\xf4\x9e\x7c\x5b\xba\x81\xc2\xb6\xb3\x6f\xde\xe2\x1c\xa2\x7e\x34\x7f"
          "\x79\x3d\x2c\xe9\x44\xed\xb2\x3c\x8c\x9b\x91\x4b\xe1\x03\x35\xe3\x50\xfe"
          "\xb5\x07\x03\x94\xb7\xa4\xa1\x5c\x0c\xa1\x20\x28\x35\x68\xb7\xbf\xc2\x54"
          "\xfe\x83\x8b\x13\x7a\x21\x47\xce\x7c\x11\x3a\x3a\x4d\x65\x49\x9d\x9e\x86"
          "\xb8\x7d\xbc\xc7\xf0\x3b\xbd\x3a\x3a\xb1\xaa\x24\x3e\xce\x5b\xa9\xbc\xf2"
          "\x5f\x82\x83\x6c\xfe\x47\x3b\x2d\x83\xe7\xa7\x20\x1c\xd0\xb9\x6a\x72\x45"
          "\x1e\x86\x3f\x6c\x3b\xa6\x64\xa6\xd0\x73\xd1\xf7\xb5\xed\x99\x08\x65\xd9"
          "\x78\xbd\x38\x15\xd0\x60\x94\xfc\x9a\x2a\xba\x52\x21\xc2\x2d\x5a\xb9\x96"
          "\x38\x9e\x37\x21\xe3\xaf\x5f\x05\xbe\xdd\xc2\x87\x5e\x0d\xfa\xeb\x39\x02"
          "\x1e\xe2\x7a\x41\x18\x7c\xbb\x45\xef\x40\xc3\xe7\x3b\xc0\x39\x89\xf9\xa3"
          "\x0d\x12\xc5\x4b\xa7\xd2\x14\x1d\xa8\xa8\x75\x49\x3e\x65\x77\x6e\xf3\x5f"
          "\x97\xde\xbc\x22\x86\xcc\x4a\xf9\xb4\x62\x3e\xee\x90\x2f\x84\x0c\x52\xf1"
          "\xb8\xad\x65\x89\x39\xae\xf7\x1f\x3f\x72\xb9\xec\x1d\xe2\x15\x88\xbd\x35"
          "\x48\x4e\xa4\x44\x36\x34\x3f\xf9\x5e\xad\x6a\xb1\xd8\xaf\xb1\xb2\xa3\x03"
          "\xdf\x1b\x71\xe5\x3c\x4a\xea\x6b\x2e\x3e\x93\x72\xbe\x0d\x1b\xc9\x97\x98"
          "\xb0\xce\x3c\xc1\x0d\x2a\x59\x6d\x56\x5d\xba\x82\xf8\x8c\xe4\xcf\xf3\xb3"
          "\x3d\x5d\x24\xe9\xc0\x83\x11\x24\xbf\x1a\xd5\x4b\x79\x25\x32\x98\x3d\xd6"
          "\xc3\xa8\xb7\xd0",
          "\x17\x9f\x2f\xa6", 1, 16448,
          "\x29\x6f\x39\x3c\x6b\x22\x77\x37\xa9\x6f\x39\x3c\x6b\x22\xf7\x37", 128 },
        { 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0 }
};
