/**
 * Fingerprint tables for 64-, 96-, and 128-bit Rabin fingerprints.
 *
 * AUTOMATICALLY GENERATED.  DO NOT EDIT.
 */

#include "folly/Fingerprint.h"

namespace folly {
namespace detail {

template <>
const uint64_t FingerprintTable<64>::poly[1] = {13778541736389896631LU};

template <>
const uint64_t FingerprintTable<64>::table[8][256][1] = {
  // Table 0
  {
    {0LU},
    {13778541736389896631LU},
    {13932267936266468057LU},
    {9110339399070241646LU},
    {4433091293687421957LU},
    {9417791798823384498LU},
    {18220678798140483292LU},
    {4894265323467722603LU},
    {8866182587374843914LU},
    {14140234807041511869LU},
    {13425892162097185491LU},
    {388839523937217380LU},
    {5084145193601901583LU},
    {17994613522571414968LU},
    {9788530646935445206LU},
    {4098537859734402913LU},
    {17732365174749687828LU},
    {5269548668425312675LU},
    {3985509688447617741LU},
    {9833725540373472122LU},
    {14669214811366878225LU},
    {8405040250484819366LU},
    {777679047874434760LU},
    {13113893104660266879LU},
    {10168290387203803166LU},
    {3614755040283369897LU},
    {5495620681799791303LU},
    {17542482971433278320LU},
    {12725069391647003675LU},
    {1130317220161338796LU},
    {8197075719468805826LU},
    {14913364891833403253LU},
    {5988449327088208287LU},
    {17017986275789824040LU},
    {10539097336850625350LU},
    {3275616136293964529LU},
    {7971019376895235482LU},
    {15107757406008998957LU},
    {12666343419881369411LU},
    {1220707007037392628LU},
    {2886874404556255637LU},
    {10891685549024204834LU},
    {16810080500969638732LU},
    {6232508630196675323LU},
    {1555358095748869520LU},
    {12295543072213320743LU},
    {15333883914973976393LU},
    {7781042135610982142LU},
    {11893226797815527819LU},
    {1889836700698054716LU},
    {7229510080566739794LU},
    {15808575497209686757LU},
    {10991241363599582606LU},
    {2864163452375993401LU},
    {6472200524959899479LU},
    {16638221869157005024LU},
    {15998537213336371585LU},
    {7003394709584455734LU},
    {2260634440322677592LU},
    {11558582721770656495LU},
    {16394151438937611652LU},
    {6680121835809158195LU},
    {2511568234112608093LU},
    {11379985709957254890LU},
    {11976898654176416574LU},
    {1801804251968830089LU},
    {7453217696368306663LU},
    {15589228477870096464LU},
    {11219589092362129211LU},
    {2631450599991699084LU},
    {6551232272587929058LU},
    {16563555257700080725LU},
    {15942038753790470964LU},
    {7064539767431021187LU},
    {2045799812397994477LU},
    {11768770738308446298LU},
    {16192972575732447025LU},
    {6885942766053187206LU},
    {2441414014074785256LU},
    {11445497858325701727LU},
    {5773748809112511274LU},
    {17228326064230861469LU},
    {10482447182970903027LU},
    {3336627024338858052LU},
    {7900994868755955503LU},
    {15173416928229725848LU},
    {12465017260393350646LU},
    {1426398165530192961LU},
    {3110716191497739040LU},
    {10672490223208673943LU},
    {16893600586773914105LU},
    {6144342070717089870LU},
    {1634519616474236709LU},
    {12221023756238401170LU},
    {15562084271221964284LU},
    {7548199570518905931LU},
    {17666850795029469857LU},
    {5339709521921504022LU},
    {3779673401396109432LU},
    {10034915366332582351LU},
    {14459020161133479588LU},
    {8619877109528751891LU},
    {716523026973768829LU},
    {13170406920709821898LU},
    {10242946039933051563LU},
    {3535738653489613596LU},
    {5728326904751986802LU},
    {17314137478049296837LU},
    {12944401049919798958LU},
    {906620562850207513LU},
    {8285105932515640439LU},
    {14829699664604458432LU},
    {232857994914261685LU},
    {13550330352963191554LU},
    {14006789419168911468LU},
    {9031171317900687835LU},
    {4521268880645355184LU},
    {9334256283501272839LU},
    {18439880684636916841LU},
    {4670421369831761374LU},
    {8660497993889370815LU},
    {14341558804165671688LU},
    {13360243671618316390LU},
    {458848606817976785LU},
    {5023136468225216186LU},
    {18051257111743440653LU},
    {9578206283985974371LU},
    {4313227346204958164LU},
    {17535835009858785227LU},
    {5507053234643281532LU},
    {3603608503937660178LU},
    {10175215277670538405LU},
    {14906435392736613326LU},
    {8208226718147263097LU},
    {1118889267089271063LU},
    {12731712882030641312LU},
    {9822578518411114433LU},
    {3992434111014706806LU},
    {5262901199983398168LU},
    {17743798205156762799LU},
    {13102464545175858116LU},
    {784321916276212339LU},
    {8398111365316825373LU},
    {14680366441690609834LU},
    {382182706262032351LU},
    {13437333433871390312LU},
    {14129079534862042374LU},
    {8873116351382187185LU},
    {4091599624795988954LU},
    {9799690519163423341LU},
    {17983176713406519555LU},
    {5090797402907340980LU},
    {9099183521015039957LU},
    {13939201077755342434LU},
    {13771885532106374412LU},
    {11441903956612283LU},
    {4882828028149570512LU},
    {18227330540082885223LU},
    {9410854057554682121LU},
    {4444251642941851838LU},
    {11547497618225022548LU},
    {2267497893693829091LU},
    {6996808455143226509LU},
    {16009908054752171322LU},
    {11368619193443637841LU},
    {2518150292232254438LU},
    {6673254048677716104LU},
    {16405240729946196287LU},
    {15801989737511911006LU},
    {7240881397935249385LU},
    {1878751112072905863LU},
    {11900089782749900080LU},
    {16631354696490967643LU},
    {6483290447077149676LU},
    {2852796331060385922LU},
    {10997822798127018293LU},
    {6221432382995478080LU},
    {16816935235704283127LU},
    {10885108030676176025LU},
    {2898236372707796270LU},
    {7769684355182701125LU},
    {15340457099838276594LU},
    {12288684141434179740LU},
    {1566438668112034091LU},
    {3269039232948473418LU},
    {10550459935573698557LU},
    {17006909423250027667LU},
    {5995303438767250724LU},
    {1213848570464571983LU},
    {12677424468734376952LU},
    {15096399141037811862LU},
    {7977592092786147617LU},
    {6155770703073762549LU},
    {16886957516349388098LU},
    {10679419043843008044LU},
    {3099564771501150107LU},
    {7559346802792218864LU},
    {15555159784071342407LU},
    {12227671022707440169LU},
    {1623086658955613086LU},
    {3343556312839283967LU},
    {10471296248557407560LU},
    {17239754219057503782LU},
    {5767105245588961169LU},
    {1433046053947537658LU},
    {12453584909253513549LU},
    {15184563528891318819LU},
    {7894069767710092180LU},
    {11780208244188884193LU},
    {2039148006156551510LU},
    {7071477306979227192LU},
    {15930878477710032783LU},
    {11456653809503973604LU},
    {2434480670848178515LU},
    {6892598906054904381LU},
    {16181530882389042058LU},
    {15596166639903216875LU},
    {7442058026130046300LU},
    {1813241125700415026LU},
    {11970246234576865157LU},
    {16570211865031280878LU},
    {6539791065364226393LU},
    {2642606074177073719LU},
    {11212655255499365248LU},
    {465715989828523370LU},
    {13349153684951088349LU},
    {14352925723474849715LU},
    {8653916632216831492LU},
    {4319813178808551791LU},
    {9566834764628271320LU},
    {18062342635801375670LU},
    {5016273693584431617LU},
    {9042537761290710368LU},
    {14000207562786473175LU},
    {13557198204376963001LU},
    {221768493292994062LU},
    {4681506262814585189LU},
    {18433017295564282066LU},
    {9340842739663522748LU},
    {4509897966056088075LU},
    {17320995987778741630LU},
    {5717245654194801865LU},
    {3547096854145441703LU},
    {10236373534621791760LU},
    {14836276778545789307LU},
    {8273743269527081164LU},
    {917697213635953570LU},
    {12937547011381193237LU},
    {10046272936450432372LU},
    {3773100281115866307LU},
    {5346568654672996269LU},
    {17655770149777329690LU},
    {13181483095039279473LU},
    {709668494262397126LU},
    {8626454692409916328LU},
    {14447657982654272031LU},
  },
  // Table 1
  {
    {0LU},
    {6449344493959411233LU},
    {12898688987918822466LU},
    {16898057683544218211LU},
    {15651561368708985139LU},
    {9274363563742480146LU},
    {7652985109632834929LU},
    {3725727918628186960LU},
    {962713630731242449LU},
    {6114923300192517616LU},
    {13717234084660209555LU},
    {16707733516848140722LU},
    {15305970219265669858LU},
    {10225729117645163715LU},
    {7451455837256373920LU},
    {4532960157281230977LU},
    {1925427261462484898LU},
    {4843851477225136515LU},
    {12229846600385035232LU},
    {17310016221150023105LU},
    {14091193443052365457LU},
    {11100622538598863024LU},
    {8110033553944201939LU},
    {2957752428860390642LU},
    {1721574722895518835LU},
    {5648903386736159314LU},
    {11881932180992978993LU},
    {18259201441078707728LU},
    {14902911674512747840LU},
    {10903614442596522849LU},
    {9065920314562461954LU},
    {2616647302028998435LU},
    {3850854522924969796LU},
    {7849870274495535461LU},
    {9687702954450273030LU},
    {16136694503817917735LU},
    {17025154611935583863LU},
    {13098107428440139862LU},
    {6864654208233304629LU},
    {487666411312808980LU},
    {4047827024382764181LU},
    {7038116448490607284LU},
    {10028843950706215127LU},
    {15180843612624207606LU},
    {16220067107888403878LU},
    {13301924372470948743LU},
    {5915504857720781284LU},
    {835616700121026501LU},
    {3443149445791037670LU},
    {8523109058476461767LU},
    {11297806773472318628LU},
    {14216020981692211845LU},
    {17797383561638382037LU},
    {12645455381112782836LU},
    {5043006036201563543LU},
    {2052788075769336758LU},
    {2491819765599613751LU},
    {8868736081631036694LU},
    {10490538935988019061LU},
    {14417514655237417300LU},
    {18131840629124923908LU},
    {11682777624101188645LU},
    {5233294604057996870LU},
    {1234207380188305511LU},
    {7701709045849939592LU},
    {3702340663910475945LU},
    {15699740548991070922LU},
    {9250396368717661419LU},
    {12958109235311046587LU},
    {16885366181655878042LU},
    {60001425723786233LU},
    {6437198986030544344LU},
    {7475352371420583257LU},
    {4484852702894334840LU},
    {15329285747970750747LU},
    {10177075842171227962LU},
    {13729308416466609258LU},
    {16647804401269314123LU},
    {975332822625617960LU},
    {6055574229073755657LU},
    {8095654048765528362LU},
    {3015484114616532747LU},
    {14076232896981214568LU},
    {11157808367834616649LU},
    {12208148449526249497LU},
    {17360429819571801656LU},
    {1904274003977802843LU},
    {4894845153393107578LU},
    {9008805111693492987LU},
    {2631536087711134938LU},
    {14845251748994625209LU},
    {10917923321257416856LU},
    {11831009715441562568LU},
    {18280282422912517609LU},
    {1671233400242053002LU},
    {5670530327095830955LU},
    {6886298891582075340LU},
    {437307655866288109LU},
    {17046218116952923534LU},
    {13047202679034276783LU},
    {9702029550464680191LU},
    {16079017102691284702LU},
    {3865725874874526909LU},
    {7792772813676141212LU},
    {5966480783266019869LU},
    {814480884975635516LU},
    {16270498173345535583LU},
    {13280208512865362046LU},
    {10086012072403127086LU},
    {15165900534796369167LU},
    {4105576151538673516LU},
    {7023719191749677389LU},
    {4983639531199227502LU},
    {2065425009562292303LU},
    {17737472163262073388LU},
    {12657512237159676941LU},
    {11249136021299353437LU},
    {14239354226660286844LU},
    {3395059734510680863LU},
    {8546988159965056318LU},
    {5221166537377902015LU},
    {1294191054198840222LU},
    {18119131419546747389LU},
    {11742215339585730524LU},
    {10466589208115993740LU},
    {14465676126890142381LU},
    {2468414760376611022LU},
    {8917477460304873199LU},
    {15403418091699879184LU},
    {10106996211925568305LU},
    {7404681327820951890LU},
    {4558235228663850867LU},
    {934051652291824675LU},
    {6158329042365512194LU},
    {13832580083323002977LU},
    {16606916877151508032LU},
    {15609425552936613569LU},
    {9304293288618180832LU},
    {7754785819886738051LU},
    {3611363776198585506LU},
    {120002851447572466LU},
    {6353164348634132947LU},
    {12874397972061088688LU},
    {16945814064245218705LU},
    {14950704742841166514LU},
    {10879357932489268371LU},
    {8969705405788669680LU},
    {2736613173791371473LU},
    {1607247285273205633LU},
    {5750738585560673696LU},
    {11911827125240297411LU},
    {18217028662801007074LU},
    {13990340098581995875LU},
    {11215934048657495874LU},
    {8153474076779138337LU},
    {2929127412892744448LU},
    {1950665645251235920LU},
    {4797042462005683825LU},
    {12111148458147511314LU},
    {17407501073235872307LU},
    {16191308097531056724LU},
    {13345212741794456693LU},
    {6030968229233065494LU},
    {734897092342319159LU},
    {4145159722957185895LU},
    {6919284311863383366LU},
    {9982168672178425637LU},
    {15206233857866610948LU},
    {17144968622244305285LU},
    {13001758782974685092LU},
    {6840531692515751367LU},
    {535611633152656358LU},
    {3808548007955605686LU},
    {7879613357289201303LU},
    {9789690306786215156LU},
    {16022501060585304789LU},
    {18017610223386985974LU},
    {11784730195808744407LU},
    {5263072175422269876LU},
    {1191937570026233749LU},
    {2539728007754265797LU},
    {8844578802464965348LU},
    {10394224796273039495LU},
    {14537365353173560998LU},
    {17822810786532429351LU},
    {12598814866067060742LU},
    {4924139393790304869LU},
    {2150084086749893700LU},
    {3342466800484106004LU},
    {8638607210650683701LU},
    {11341060654191661910LU},
    {14187225266561131895LU},
    {13772597783164150680LU},
    {16619043568904213945LU},
    {874615311732576218LU},
    {6171036878089910779LU},
    {7356520680264094379LU},
    {4582184131364299914LU},
    {15354677538195521257LU},
    {10130400393050605768LU},
    {12861759663342708809LU},
    {17005181943101202024LU},
    {107944621549126667LU},
    {6413077121937961514LU},
    {7731451749749053818LU},
    {3660035352469385051LU},
    {15585545627352282424LU},
    {9352383825070244633LU},
    {11932961566532039738LU},
    {18166054112181191195LU},
    {1628961769951271032LU},
    {5700308893955092057LU},
    {8984647659518674185LU},
    {2679445877264069416LU},
    {14965101174410389835LU},
    {10821609629429096298LU},
    {12161508588521422827LU},
    {17385855016035420618LU},
    {2001571768510878633LU},
    {4775977582063052168LU},
    {8211152303077347032LU},
    {2914799992782469369LU},
    {14047438383499354778LU},
    {11201061871538459835LU},
    {9967279062398455004LU},
    {15263349885905189629LU},
    {4130850019124584606LU},
    {6976945061477242559LU},
    {6009885873545608687LU},
    {785820932819160014LU},
    {16169679782243865005LU},
    {13395555438299473804LU},
    {9731959446201648909LU},
    {16036879741668110636LU},
    {3751363002817817423LU},
    {7894573078190873966LU},
    {6790119469021361726LU},
    {557308410159759391LU},
    {17093976319930112636LU},
    {13022910665534073949LU},
    {10442333074755804030LU},
    {14513467993837776223LU},
    {2588382108397680444LU},
    {8821262449661919517LU},
    {5323002664852777549LU},
    {1179861863292443756LU},
    {18076960669431039503LU},
    {11772109630060589102LU},
    {11364447083739762863LU},
    {14138502154441860750LU},
    {3366433171413187821LU},
    {8590428855540304588LU},
    {4936829520753222044LU},
    {2090665213211318205LU},
    {17834954920609746398LU},
    {12538814815270796287LU},
  },
  // Table 2
  {
    {0LU},
    {1490947648328864663LU},
    {2981895296657729326LU},
    {4454404202900862137LU},
    {5963790593315458652LU},
    {5076483732374478283LU},
    {8908808405801724274LU},
    {8003629876970781413LU},
    {11927581186630917304LU},
    {12769867788053122863LU},
    {10152967464748956566LU},
    {10977100647889709057LU},
    {17817616811603448548LU},
    {16425767940139139443LU},
    {16007259753941562826LU},
    {14597816841810175581LU},
    {17598300964608069831LU},
    {16179552747857134416LU},
    {15949613004921894889LU},
    {14549019855178785918LU},
    {12031958554756947611LU},
    {12847347459103001868LU},
    {10348088282959821237LU},
    {11181069580311931426LU},
    {5890425292092361855LU},
    {4975939260172263400LU},
    {8709732298512493393LU},
    {7813683357795875014LU},
    {251459865430852131LU},
    {1715226692422635956LU},
    {3034454813689980173LU},
    {4516094958371845786LU},
    {6288226075133102137LU},
    {4896728567291894702LU},
    {9089836030644285207LU},
    {7680182492644637824LU},
    {398541899415815781LU},
    {1240477000310887922LU},
    {3235333064313479499LU},
    {4059677010222625500LU},
    {17492829399495267457LU},
    {16605875001151997718LU},
    {15826443287274582959LU},
    {14921053033600475192LU},
    {11529391354946689757LU},
    {13019986402699774282LU},
    {9899318401480769011LU},
    {11372039170540645988LU},
    {11780850584184723710LU},
    {13244266048625052521LU},
    {9951878520344526800LU},
    {11433729289818811463LU},
    {17419464597024986786LU},
    {16505330064556180789LU},
    {15627366715591750028LU},
    {14731107013178384923LU},
    {502919730861704262LU},
    {1317956173681694673LU},
    {3430453384845271912LU},
    {4263646405964706047LU},
    {6068909627379960346LU},
    {4650514010128963981LU},
    {9032189916743691572LU},
    {7631384905255485091LU},
    {12576452150266204274LU},
    {13418581079242572773LU},
    {9793457134583789404LU},
    {10617712882772157643LU},
    {18179672061288570414LU},
    {16788227093277855161LU},
    {15360364985289275648LU},
    {13950483062977161879LU},
    {797083798831631562LU},
    {2287590572624224093LU},
    {2480954000621775844LU},
    {3953868519384135795LU},
    {6470666128626958998LU},
    {5583483267584020737LU},
    {8119354020445251000LU},
    {7214016230370309679LU},
    {6535059397309120693LU},
    {5621012512807375650LU},
    {8345416524407859099LU},
    {7448963543671108620LU},
    {608709530348556009LU},
    {2072353928859262334LU},
    {2383323319528270279LU},
    {3865120999418346064LU},
    {18390015875625573389LU},
    {16971427058430005146LU},
    {15444998131133315875LU},
    {14044280843851884724LU},
    {12535160378936955473LU},
    {13350143808404062662LU},
    {9553265152429110655LU},
    {10386687186006124264LU},
    {17999987028124031051LU},
    {17112592443043236828LU},
    {15036706808868241253LU},
    {14131721480048831730LU},
    {12326192922484184599LU},
    {13816911558288213376LU},
    {9398659336469459257LU},
    {10871221255998218926LU},
    {6650562319161771251LU},
    {5258906726088103780LU},
    {8442660267917927389LU},
    {7033129707886735434LU},
    {1047131731806522031LU},
    {1889471422745975096LU},
    {2876103865125514625LU},
    {3700008114128928278LU},
    {1005839461723408524LU},
    {1821034616300018459LU},
    {2635912347363389346LU},
    {3468981918609030197LU},
    {6860906769690543824LU},
    {5442106089407698247LU},
    {8527292811929412094LU},
    {7126928124953227881LU},
    {12137819254759920692LU},
    {13601674279405225891LU},
    {9301028020257927962LU},
    {10782474336791240845LU},
    {18064379833487383144LU},
    {17150122185946712575LU},
    {15262769810510970182LU},
    {14366668330030821073LU},
    {16295755762843044179LU},
    {17768617509366291140LU},
    {14647947334818328189LU},
    {16138401336371805674LU},
    {12746739960060217103LU},
    {11841490135184184472LU},
    {11062060646007545889LU},
    {10174965750163518390LU},
    {5161512630489994731LU},
    {5985715597866223228LU},
    {7980573818017903301LU},
    {8822649966182130002LU},
    {1541009052357499831LU},
    {131215086637713440LU},
    {4324320308109458585LU},
    {2932963296691072782LU},
    {1594167597663263124LU},
    {193503082618849795LU},
    {4575181145248448186LU},
    {3156645100289895725LU},
    {4961908001243551688LU},
    {5795242069619557471LU},
    {7907737038768271590LU},
    {8722632503034372977LU},
    {12941332257253917996LU},
    {12044932057327212219LU},
    {11166966535168041474LU},
    {10252972431476339093LU},
    {16238708040890502000LU},
    {17720417764186151143LU},
    {14428032460740619358LU},
    {15891588902656901065LU},
    {13070118794618241386LU},
    {11660535453692990205LU},
    {11242025025614751300LU},
    {9850316651647022547LU},
    {16690833048815718198LU},
    {17514825254497311905LU},
    {14897927087342217240LU},
    {15740354734959852431LU},
    {1217419060697112018LU},
    {312380959590485573LU},
    {4144707857718524668LU},
    {3257260500350511467LU},
    {4766646639056540558LU},
    {6239296523836768281LU},
    {7730241998836692128LU},
    {9221048599892191031LU},
    {4709598316344660397LU},
    {6191097413774131770LU},
    {7510327759876486787LU},
    {8974235565417948436LU},
    {1412011821210148849LU},
    {515822384053914726LU},
    {4249613249199421663LU},
    {3335267644982668104LU},
    {16491228918322613525LU},
    {17324351261857570434LU},
    {14825089843699509819LU},
    {15640337770565433772LU},
    {13123276703732761417LU},
    {11722824051507204318LU},
    {11492886464586818663LU},
    {10073997819054602224LU},
    {5525546336509253921LU},
    {6349591562988604086LU},
    {7336221849336512015LU},
    {8178420494097313176LU},
    {2192422803045226365LU},
    {783032671791121642LU},
    {3966788455652601939LU},
    {2574992365065577412LU},
    {16801216049538975129LU},
    {18273636990513862158LU},
    {13855386941906608823LU},
    {15346246624967225632LU},
    {13540717729761102789LU},
    {12635591973234153554LU},
    {10559704114207370475LU},
    {9672450025570385788LU},
    {13301124638323542502LU},
    {12405163654266231409LU},
    {10517813452176207560LU},
    {9603415376915414367LU},
    {16885320535835854778LU},
    {18366907899638338605LU},
    {14066259415773470868LU},
    {15529973461885874947LU},
    {2094263463613044062LU},
    {693758279136085705LU},
    {3778942845491950192LU},
    {2360282594007163367LU},
    {5752207730251029250LU},
    {6585136255297046677LU},
    {7400016228257856556LU},
    {8215352360297820091LU},
    {2011678923446817048LU},
    {1106200704590578319LU},
    {3642069232600036918LU},
    {2755026869074634145LU},
    {5271824694726778692LU},
    {6744598236008991955LU},
    {6937963837218060394LU},
    {8428611657193483261LU},
    {13721813539381087648LU},
    {12312072044772335159LU},
    {10884212178815396494LU},
    {9492626714365081881LU},
    {17054585623858824188LU},
    {17878982350596886635LU},
    {14253856249906455762LU},
    {15095844131630446405LU},
    {17281246554280215007LU},
    {18114527540583879240LU},
    {14317651126506350321LU},
    {15132775534510568806LU},
    {13623654800707194755LU},
    {12222797016998747156LU},
    {10696365933536192685LU},
    {9277917544064957242LU},
    {5355929817215950183LU},
    {6837868543301439216LU},
    {7148835709252893257LU},
    {8612339130304424414LU},
    {1772085333256966971LU},
    {875772850016780460LU},
    {3600179034962998293LU},
    {2685991721667372930LU},
  },
  // Table 3
  {
    {0LU},
    {8897839333771868945LU},
    {17795678667543737890LU},
    {10199961345714588979LU},
    {5970313340185478643LU},
    {2999865619134840546LU},
    {11829869008725275601LU},
    {16093431387574536384LU},
    {11940626680370957286LU},
    {16055008352872722679LU},
    {5999731238269681092LU},
    {2898113084106770133LU},
    {17829593601459883541LU},
    {10093702910041945348LU},
    {115267972509530167LU},
    {8854914863018836774LU},
    {17608080387581017723LU},
    {10315229315980166506LU},
    {192111775330142297LU},
    {8778075460325176136LU},
    {11999462476539362184LU},
    {15996185752924422297LU},
    {5796226168213540266LU},
    {3101622550129112763LU},
    {5902485601367225757LU},
    {3067706549878230668LU},
    {12042383613349135295LU},
    {15880921183211845806LU},
    {230535945019060334LU},
    {8667316585107131263LU},
    {17709829726037673548LU},
    {10285814683052637533LU},
    {6309500271432701249LU},
    {3239390685618662992LU},
    {11635377735216063331LU},
    {15709210654763292786LU},
    {384223550660284594LU},
    {9092328889615281059LU},
    {17556150920650352272LU},
    {9860775994694737281LU},
    {17454397045940559527LU},
    {9890186368319120822LU},
    {345803917224503429LU},
    {9203092024136471444LU},
    {11592452336427080532LU},
    {15824470689825054789LU},
    {6203245100258225526LU},
    {3273311220520359527LU},
    {11804971202734451514LU},
    {15611965019872006187LU},
    {6135413099756461336LU},
    {3341147616854107657LU},
    {17368552640995913417LU},
    {9976043965188904408LU},
    {576335325682145515LU},
    {8972565015939998714LU},
    {461071890038120668LU},
    {9015493746457549773LU},
    {17334633170214262526LU},
    {10082298141097029103LU},
    {6105999463055877423LU},
    {3442904686054841918LU},
    {11694209269705151245LU},
    {15650383520401156124LU},
    {12619000542865402498LU},
    {15304581294320275859LU},
    {6478781371237325984LU},
    {2491116147198175153LU},
    {18286130144147681137LU},
    {9709228359506220128LU},
    {807148243477387603LU},
    {8090972599899955778LU},
    {768447101320569188LU},
    {8201454224603372149LU},
    {18184657779230562118LU},
    {9738920241876741207LU},
    {6372807641163113623LU},
    {2525318122099203974LU},
    {12575793704051987125LU},
    {15419559888306874788LU},
    {6576317517885461753LU},
    {2321812641343188968LU},
    {12516970692329939675LU},
    {15478396096248895946LU},
    {691607834449006858LU},
    {8278297891602016795LU},
    {18406184048272942888LU},
    {9517407164893584441LU},
    {18371983068621561631LU},
    {9623379830864454670LU},
    {576625908750559549LU},
    {8321508130980975148LU},
    {12406490200516451052LU},
    {15517096036930527741LU},
    {6546622441040719054LU},
    {2423288269319788511LU},
    {17910933589085536195LU},
    {9505711817191998674LU},
    {1037684188808923617LU},
    {8439149760535245552LU},
    {12270826199512922672LU},
    {15074043630815428897LU},
    {6682295233708215314LU},
    {2866314282995201795LU},
    {6711994571927991333LU},
    {2764843189199589172LU},
    {12381302429951377927LU},
    {15035339155952810262LU},
    {1152670651364291030LU},
    {8395943780929129159LU},
    {17945130031879997428LU},
    {9399734891448286437LU},
    {922143780076241336LU},
    {8626475052478479017LU},
    {18030987492915099546LU},
    {9313890622338190475LU},
    {6779831380048069707LU},
    {2697010776911626074LU},
    {12168796349285741161LU},
    {15247858432972638584LU},
    {12211998926111754846LU},
    {15132875304343679311LU},
    {6885809372109683836LU},
    {2662813336652957549LU},
    {18132455321570889645LU},
    {9284194480672978108LU},
    {960849458494388623LU},
    {8515997687069754014LU},
    {16215301650359893171LU},
    {11129286707407079330LU},
    {1728996904398834321LU},
    {7819894084864651648LU},
    {12957562742474651968LU},
    {14459364136363082321LU},
    {4982232294396350306LU},
    {4494320182386308211LU},
    {4953381538320463701LU},
    {4595514370828127300LU},
    {12847363692360188279LU},
    {14497219754111613542LU},
    {1614296486954775206LU},
    {7862259797316454839LU},
    {16181945199799911556LU},
    {11234977862959316885LU},
    {1536894202641138376LU},
    {7939666481756781017LU},
    {16402908449206744298LU},
    {11014027805611577339LU},
    {5156328534737700667LU},
    {4392571770376829994LU},
    {12787977798206664985LU},
    {14556618844484979208LU},
    {12745615282326227246LU},
    {14671315996772414015LU},
    {5050636244198407948LU},
    {4425929424509125661LU},
    {16301717594708135133LU},
    {11042875158890559436LU},
    {1499037587411614463LU},
    {8049866598205932014LU},
    {13152635035770923506LU},
    {14843004940980572899LU},
    {4643625282686377936LU},
    {4254214087593108673LU},
    {16455409462819400705LU},
    {11467890901268551440LU},
    {1345354519554513443LU},
    {7624824471978451250LU},
    {1383215668898013716LU},
    {7514628616971606277LU},
    {16556595783204033590LU},
    {11439039286547263271LU},
    {4749321833065719783LU},
    {4220860970250788086LU},
    {13194993291811312069LU},
    {14728303251903163092LU},
    {4817721523336009609LU},
    {4152465675812220056LU},
    {12983050091194655147LU},
    {14940259648873880250LU},
    {1153251817501119098LU},
    {7744596868629408107LU},
    {16643016261961950296LU},
    {11352631999714221897LU},
    {16676368177812364399LU},
    {11246936582241527678LU},
    {1267956769654745677LU},
    {7702235418098061660LU},
    {13093244882081438108LU},
    {14902399494796747405LU},
    {4846576538639577022LU},
    {4051276023699002543LU},
    {5627213455769835057LU},
    {3849620461361949984LU},
    {13321950770141421587LU},
    {14094694668348234498LU},
    {2075368377617847234LU},
    {7473241102578215123LU},
    {16878299521070491104LU},
    {10466570345764953841LU},
    {16979204332600008151LU},
    {10437437221091796678LU},
    {2113511036888116213LU},
    {7363326756451586276LU},
    {13364590467416430628LU},
    {13980274419404497717LU},
    {5732628565990403590LU},
    {3815985902810109207LU},
    {13423989143855982666LU},
    {13920888939184657243LU},
    {5529686378399178344LU},
    {4018932486367405433LU},
    {16758254136196361657LU},
    {10658400609554405032LU},
    {2190917859310607259LU},
    {7285924334155915402LU},
    {2305341302728582060LU},
    {7243281373821409469LU},
    {16791887561858258318LU},
    {10552986700809039519LU},
    {5558822834784200287LU},
    {3918024274272329038LU},
    {13533902494732947581LU},
    {13882747344017746796LU},
    {1844287560152482672LU},
    {7125609921776187489LU},
    {17252950104956958034LU},
    {10670631768736337475LU},
    {5423153750972270211LU},
    {3474967060193213842LU},
    {13669580370209108129LU},
    {14325778165657439152LU},
    {13559662760096139414LU},
    {14363915224504333191LU},
    {5394021553823252148LU},
    {3575879808608306597LU},
    {17219312144577170789LU},
    {10776041415569831540LU},
    {1729868651452398407LU},
    {7168257144022564950LU},
    {17132904719774547211LU},
    {10862462032297199130LU},
    {1959837042153524009LU},
    {6938293153582477368LU},
    {13771618744219367672LU},
    {14151972436735034345LU},
    {5325626673305915098LU},
    {3644279084957496779LU},
    {5220215822916941549LU},
    {3677918180307504636LU},
    {13728974787112763599LU},
    {14266388148880604126LU},
    {1921698916988777246LU},
    {7048211761159604239LU},
    {17031995374139508028LU},
    {10891590895519858221LU},
  },
  // Table 4
  {
    {0LU},
    {9018338774520336593LU},
    {18036677549040673186LU},
    {9757248697669759347LU},
    {5452025039430068979LU},
    {3931335395985930786LU},
    {12819035954167057233LU},
    {14754300481219861376LU},
    {10904050078860137958LU},
    {16894520162977170743LU},
    {7862670791971861572LU},
    {1169319865202828437LU},
    {15923474999890214677LU},
    {11663231704657457092LU},
    {2789041597999865527LU},
    {6598681496083189350LU},
    {10489685323341578875LU},
    {17056620991453450922LU},
    {7772649536886039513LU},
    {1655755415483904776LU},
    {15725341583943723144LU},
    {12041553994566236249LU},
    {2338639730405656874LU},
    {6724744112972192251LU},
    {486440435810572189LU},
    {8928313325394757452LU},
    {18198773779758659135LU},
    {9342887857009698542LU},
    {5578083195999731054LU},
    {3480937580689173951LU},
    {13197362992166378700LU},
    {14556162733794659357LU},
    {11246197205547576641LU},
    {16227902754739060112LU},
    {7376230354148019427LU},
    {1979949105305672754LU},
    {15545299073772079026LU},
    {12293820313993369443LU},
    {3311510830967809552LU},
    {5824081050579203777LU},
    {810774378057840807LU},
    {8532034678013208694LU},
    {17370196482127632645LU},
    {10099540962303773140LU},
    {4677279460811313748LU},
    {4453668291386868357LU},
    {13449488225944384502LU},
    {14375979421978600231LU},
    {972880871621144378LU},
    {8117684083010224107LU},
    {17856626650789514904LU},
    {10009505263234555465LU},
    {5055613961286944201LU},
    {4255538023643026712LU},
    {13575538915734365291LU},
    {13925574122713920698LU},
    {11156166391999462108LU},
    {16714328729369569805LU},
    {6961875161378347902LU},
    {2142059513735859119LU},
    {15094889314179665967LU},
    {12419875056089186558LU},
    {3113385311306117517LU},
    {6202411219584508252LU},
    {9732911259101639477LU},
    {18029506265692873700LU},
    {9033404542631416471LU},
    {34492536686412358LU},
    {14752460708296038854LU},
    {12798341253474158871LU},
    {3959898210611345508LU},
    {5463975912558766261LU},
    {1171156902246115027LU},
    {7883370461957649922LU},
    {16865961175151888241LU},
    {10892093145518954400LU},
    {6623021661935619104LU},
    {2796207920642612465LU},
    {11648162101158407554LU},
    {15888988532012514643LU},
    {1621548756115681614LU},
    {7757297891456770463LU},
    {17064069356026417388LU},
    {10513745680684531773LU},
    {6713070321068661693LU},
    {2309799834555075436LU},
    {12062534572577323551LU},
    {15726895479549356750LU},
    {9354558921622627496LU},
    {18227618636312196217LU},
    {8907336582773736714LU},
    {484880471402517979LU},
    {14590372129037127259LU},
    {13212709668300660362LU},
    {3473485389318172665LU},
    {5554028898875555624LU},
    {1945761743242288756LU},
    {7360896829202550437LU},
    {16235368166020448214LU},
    {11270273467137650439LU},
    {5812388021500376199LU},
    {3282652754503885910LU},
    {12314783905425577253LU},
    {15546837005001049588LU},
    {10111227922573888402LU},
    {17399058393979525955LU},
    {8511076047286053424LU},
    {809233719544560353LU},
    {14410172844254470497LU},
    {13464817924089721264LU},
    {4446197910812590275LU},
    {4653205935101775890LU},
    {9985151929009249295LU},
    {17849438312143359198LU},
    {8132731739227438509LU},
    {1007354102412782972LU},
    {13923750322756695804LU},
    {13554861193030411821LU},
    {4284119027471718238LU},
    {5067584063001003919LU},
    {2143877253474306537LU},
    {6982556710880336184LU},
    {16685752694835865675LU},
    {11144193554411157658LU},
    {6226770622612235034LU},
    {3120569814562206667LU},
    {12404822439169016504LU},
    {15060418810678628969LU},
    {12759622189647892445LU},
    {14714627305813909260LU},
    {5430336661591600767LU},
    {3926009924183146158LU},
    {18066809085262832942LU},
    {9772143176215082495LU},
    {68985073372824716LU},
    {9066457272965370973LU},
    {2756694459983911483LU},
    {6586000248505256682LU},
    {15856780295177370521LU},
    {11612825208378846024LU},
    {7919796421222691016LU},
    {1211283271817224217LU},
    {10927951825117532522LU},
    {16897630170420920763LU},
    {2342313804492230054LU},
    {6748084025965567351LU},
    {15766740923915299844LU},
    {12099241457081089237LU},
    {7721678973960415061LU},
    {1589622544030889860LU},
    {10477568142410663671LU},
    {17023712020177671718LU},
    {13246043323871238208LU},
    {14624583740520466577LU},
    {5592415841285224930LU},
    {3511633183558347059LU},
    {18192886474691850931LU},
    {9321763545814049378LU},
    {447329093668639505LU},
    {8868335494232769472LU},
    {3243097512231363228LU},
    {5775408389683835469LU},
    {15514595782913540926LU},
    {12279479997898380271LU},
    {7397364569536153711LU},
    {1985846331744835774LU},
    {11306165132517075405LU},
    {16267004175508633884LU},
    {13426140642137323386LU},
    {14372297659898472363LU},
    {4619599669110150872LU},
    {4412276639408850441LU},
    {17436319432204098953LU},
    {10150501621032717656LU},
    {843693270710172715LU},
    {8544161763140807930LU},
    {13588227834121789671LU},
    {13957928948719235126LU},
    {5106012786756059461LU},
    {4322225040366506388LU},
    {17814673165547473428LU},
    {9952389538176211653LU},
    {969760942805035958LU},
    {8093772432560339815LU},
    {3153050798718514433LU},
    {6261817313289987536LU},
    {15100222473976009891LU},
    {12441571104741344370LU},
    {6946970778636345330LU},
    {2111918056137150243LU},
    {11108057797751111248LU},
    {16645353577373298305LU},
    {3891523486484577512LU},
    {5415267027875671097LU},
    {14721793658405100874LU},
    {12783962325589626267LU},
    {9054500369568306715LU},
    {40426055632783050LU},
    {9792842876384065465LU},
    {18068646092093564776LU},
    {11624776043000752398LU},
    {15885343148338936287LU},
    {6565305509007771820LU},
    {2754854725835315325LU},
    {16932122668298421245LU},
    {10943017631999775532LU},
    {1204111949966697055LU},
    {7895459021195047566LU},
    {12075187198457544339LU},
    {15759288694005919298LU},
    {6763430740906663729LU},
    {2376523160965631968LU},
    {17022152094572106848LU},
    {10456591361016513713LU},
    {1618467439089120706LU},
    {7733350000039290131LU},
    {3513187048978688885LU},
    {5613396449510964132LU},
    {14595743814723668695LU},
    {13234369561884563974LU},
    {8892395821625180550LU},
    {454777488154399063LU},
    {9306411870203551780LU},
    {18158679845542605045LU},
    {12255406433413616041LU},
    {15507125441143849336LU},
    {5790738049293021195LU},
    {3277290973014024410LU},
    {16265463478454877018LU},
    {11285206540292647819LU},
    {2014708204825565944LU},
    {7409051568615180841LU},
    {4413814600548516943LU},
    {4640563230593914014LU},
    {14343439613651428845LU},
    {13414447582879364412LU},
    {8568238054943436476LU},
    {851158651808366189LU},
    {10135168126002007838LU},
    {17402132040196595663LU},
    {4287754506948613074LU},
    {5090960199782105859LU},
    {13965113421760672368LU},
    {13612587267334808225LU},
    {8081799564753058081LU},
    {941184938452560368LU},
    {9973071057765406851LU},
    {17816490935236462674LU},
    {12453541245224470068LU},
    {15128803438997886693LU},
    {6241139629124413334LU},
    {3151226960260659015LU},
    {16679826846698990791LU},
    {11123105415463631894LU},
    {2104729756264123749LU},
    {6922617405608549812LU},
  },
  // Table 5
  {
    {0LU},
    {15929697230913992205LU},
    {366050252398265773LU},
    {15566093945938310048LU},
    {732100504796531546LU},
    {15508522160442244439LU},
    {1097903334866292471LU},
    {15144812246460987642LU},
    {1464201009593063092LU},
    {14501665794501828793LU},
    {1244572174135857945LU},
    {14723460113814971668LU},
    {2195806669732584942LU},
    {14080704016400968675LU},
    {1976352684541483075LU},
    {14302532401247219278LU},
    {2928402019186126184LU},
    {17704319894491159397LU},
    {3294311508322035909LU},
    {17340575897801121480LU},
    {2489144348271715890LU},
    {18418192659015192639LU},
    {2855087941595440031LU},
    {18054623456756684178LU},
    {4391613339465169884LU},
    {16276996603696827857LU},
    {4172125267261931121LU},
    {16498931634732714108LU},
    {3952705369082966150LU},
    {16990801202794907275LU},
    {3733110620629513515LU},
    {17212488875926799142LU},
    {5856804038372252368LU},
    {10112317315902516445LU},
    {6076469693515063165LU},
    {9890559844182829424LU},
    {6588623016644071818LU},
    {9691423703219218311LU},
    {6808041283818116135LU},
    {9469559568134218282LU},
    {4978288696543431780LU},
    {10954944568154831465LU},
    {4612275298190510537LU},
    {11318584666364231620LU},
    {5710175883190880062LU},
    {10533701332248736051LU},
    {5344337300744323731LU},
    {10897375530350982302LU},
    {8783226678930339768LU},
    {11886667489574551989LU},
    {9002751605170532885LU},
    {11664769271780770840LU},
    {8344250534523862242LU},
    {12600258796293360367LU},
    {8563809530592131407LU},
    {12378535407290847042LU},
    {7905410738165932300LU},
    {12728313934505219841LU},
    {7539538068707239073LU},
    {13092094778797101740LU},
    {7466221241259027030LU},
    {13442399991391755355LU},
    {7100241929909858299LU},
    {13805933443419904502LU},
    {11713608076744504736LU},
    {9195997802824876973LU},
    {12077353203015135245LU},
    {8830089391721563648LU},
    {12152939387030126330LU},
    {8482053537842219255LU},
    {12516507459716430679LU},
    {8116108866477509978LU},
    {13177246033288143636LU},
    {7768529350709105945LU},
    {12955312071703307961LU},
    {7988018543894614196LU},
    {13616082567636232270LU},
    {7054798446816812611LU},
    {13394393825061678563LU},
    {7274392074279607278LU},
    {9956577393086863560LU},
    {6286314075782016709LU},
    {10320181756095143269LU},
    {5920264952964344680LU},
    {9224550596381021074LU},
    {6707417714514617759LU},
    {9588259432321291839LU},
    {6341613754872651826LU},
    {11420351766381760124LU},
    {4858427800657754225LU},
    {11198558568050887633LU},
    {5078057705566010844LU},
    {10688674601488647462LU},
    {5279463205244924715LU},
    {10466845095651737739LU},
    {5498916120993363590LU},
    {17566453357860679536LU},
    {3375785992536856957LU},
    {17788352670875314909LU},
    {3156262178688998608LU},
    {18005503210341065770LU},
    {2662123254062125607LU},
    {18227225504131113351LU},
    {2442563145593132938LU},
    {16688501069047724484LU},
    {4217850260459229129LU},
    {16324721328566631529LU},
    {4583724016540453476LU},
    {17127619061184262814LU},
    {3503837830042223763LU},
    {16764084505353713459LU},
    {3869816054760472894LU},
    {15810821476331864600LU},
    {466955331898323989LU},
    {16032580060443887541LU},
    {247290771976368568LU},
    {15079076137414478146LU},
    {887777444106223439LU},
    {15300939160098753775LU},
    {668358081719712482LU},
    {14932442482518054060LU},
    {1309164761125364385LU},
    {14568803470931185921LU},
    {1675179263289075468LU},
    {14200483859819716598LU},
    {1730481692220467707LU},
    {13836808575086549595LU},
    {2096319170864622678LU},
    {18025945911601431287LU},
    {2826186296187057402LU},
    {18391995605649753946LU},
    {2462582470049689943LU},
    {17294376494543440301LU},
    {3247184330254352288LU},
    {17660178783443127296LU},
    {2883473857931541005LU},
    {17183736452311716931LU},
    {3704565259938193998LU},
    {16964107075684438510LU},
    {3926359020909783011LU},
    {16451672276496064281LU},
    {4125776637915982100LU},
    {16232217732955019956LU},
    {4347604481600548025LU},
    {15171149753443987359LU},
    {1124606234447468946LU},
    {15537058701418211890LU},
    {760861679407488063LU},
    {15610094052807058629LU},
    {410837942855422664LU},
    {15976037087789228392LU},
    {47268199426840421LU},
    {14329085524178417963LU},
    {2002558561917226790LU},
    {14109596893633625222LU},
    {2224493051783039627LU},
    {14768379438174351985LU},
    {1288722053359617148LU},
    {14548784148559214556LU},
    {1510409168141566417LU},
    {12352963054771165223LU},
    {8538593207641845290LU},
    {12572628151564033418LU},
    {8316835194760473479LU},
    {11621112179924718461LU},
    {8959872768233842032LU},
    {11840529905928689360LU},
    {8738008074807288029LU},
    {13780849368552230547LU},
    {7074818873003751582LU},
    {13414835429029235518LU},
    {7438458412871597363LU},
    {13049066650541802953LU},
    {7495748724473607108LU},
    {12683227509745303652LU},
    {7859422381414168169LU},
    {9497331216237000015LU},
    {6835597095184761666LU},
    {9716855601315508450LU},
    {6613698319041038063LU},
    {9936556973405306389LU},
    {6121547277084788760LU},
    {10156115411132021688LU},
    {5899823346912202165LU},
    {10924799638290097147LU},
    {5371959108578448886LU},
    {10558926410489849430LU},
    {5735739411700256859LU},
    {11363812094497581217LU},
    {4658404126545551020LU},
    {10997832241986727180LU},
    {5021937020223757057LU},
    {6387826317641398103LU},
    {9635373382158434650LU},
    {6751571985073713914LU},
    {9269465529405064439LU},
    {5948955726350138381LU},
    {10349070241992460800LU},
    {6312524357377997216LU},
    {9983126111797825453LU},
    {5546179911367533027LU},
    {10513189361579644910LU},
    {5324246508124251214LU},
    {10732679095935226435LU},
    {5106814492599134905LU},
    {11227099496604687540LU},
    {4885126291186265876LU},
    {11446693682417424665LU},
    {8072095599560235583LU},
    {12471732998027275314LU},
    {8435700520918458258LU},
    {12105684416371288479LU},
    {8803738655970562405LU},
    {12050663463482484584LU},
    {9167448033080906952LU},
    {11684860062182073029LU},
    {7229468317245246603LU},
    {13350248309793421958LU},
    {7007675660084447526LU},
    {13569878773043232555LU},
    {7961461057007912913LU},
    {12929110627002544604LU},
    {7739632109520945788LU},
    {13148564083912668273LU},
    {712010809620327815LU},
    {15343822429710359434LU},
    {933910663796647978LU},
    {15124299174212443687LU},
    {272858691821135581LU},
    {16057800747349610704LU},
    {494581543952737136LU},
    {15838241180050691453LU},
    {2139334070351985459LU},
    {13880611079368641854LU},
    {1775554888212446878LU},
    {14246485376619939987LU},
    {1700250178108289129LU},
    {14594239756605228644LU},
    {1336716163439424964LU},
    {14960218539673420745LU},
    {2396570379788763375LU},
    {18182143488423802594LU},
    {2618329522250728770LU},
    {17962479469663531855LU},
    {3128494962723802037LU},
    {17760792496090561976LU},
    {3350358526578150936LU},
    {17541373692045604885LU},
    {3824601854857729627LU},
    {16717942517487542358LU},
    {3460963384440935414LU},
    {17083957577992807931LU},
    {4556313068112469249LU},
    {16297086292501900044LU},
    {4192638341729245356LU},
    {16662924312307740321LU},
  },
  // Table 6
  {
    {0LU},
    {5432812500015443033LU},
    {10865625000030886066LU},
    {15974072651883295979LU},
    {10566533285046540499LU},
    {15692480806837728394LU},
    {317972541626613857LU},
    {5696086476962622520LU},
    {11128547129054550033LU},
    {15066142234246493256LU},
    {917325817511182499LU},
    {5179074527194541306LU},
    {635945083253227714LU},
    {4879208743231810715LU},
    {11392172953925245040LU},
    {15383199969053652009LU},
    {10076280768148232597LU},
    {13885470490948777420LU},
    {2097647899472199975LU},
    {6231131997530123646LU},
    {1834651635022364998LU},
    {5913446067749383455LU},
    {10358149054389082612LU},
    {14184847340301465005LU},
    {1271890166506455428LU},
    {6540233198039133661LU},
    {9758417486463621430LU},
    {14702536648921920879LU},
    {9441083413380749655LU},
    {14438625586762790158LU},
    {1571478134716727781LU},
    {6821327423706852796LU},
    {12149428960346725021LU},
    {16428651417519503044LU},
    {4490375915515052591LU},
    {8445444700550622838LU},
    {4195295798944399950LU},
    {8168849547619855895LU},
    {12462263995060247292LU},
    {16688054593670362789LU},
    {3669303270044729996LU},
    {8759151411939962581LU},
    {11826892135498766910LU},
    {17241104918324655719LU},
    {11549522939174476383LU},
    {16946235903431456262LU},
    {3927791665666425581LU},
    {9072338286171745972LU},
    {2543780333012910856LU},
    {7505363759672913745LU},
    {13080466396078267322LU},
    {18366273899044616163LU},
    {12821339901632338907LU},
    {18053724307945600898LU},
    {2820652957931373417LU},
    {7800730178843275056LU},
    {13348062480042122009LU},
    {17462956276552677184LU},
    {3456420650171794347LU},
    {7247020139070648306LU},
    {3142956269433455562LU},
    {6988245475368628115LU},
    {13642654847413705592LU},
    {17740039995078620961LU},
    {17150222212900805773LU},
    {11917912281856323796LU},
    {8704227051206771775LU},
    {3724083601365428326LU},
    {8980751831030105182LU},
    {4019234082470094855LU},
    {16890889401101245676LU},
    {11605006874184003765LU},
    {8390591597888799900LU},
    {4545368654173366469LU},
    {16337699095239711790LU},
    {12240239439015784567LU},
    {16632497745583692879LU},
    {12517679008461664278LU},
    {8077475096625775869LU},
    {4286809894189361316LU},
    {7338606540089459992LU},
    {3364978282861488449LU},
    {17518302823879925162LU},
    {13292578487487246835LU},
    {17830922788113636811LU},
    {13551634617405452690LU},
    {7043169756544730489LU},
    {3088176030891338016LU},
    {18421830663815126281LU},
    {13025051470622470480LU},
    {7596738303108875707LU},
    {2452266157874375138LU},
    {7855583331332851162LU},
    {2765660165484833155LU},
    {18144676572343491944LU},
    {12730529467623682353LU},
    {5087560666025821712LU},
    {1008700038722939465LU},
    {15010727519345827490LU},
    {11184103674344452859LU},
    {15292389737343639235LU},
    {11483125024949973658LU},
    {4824216324546987633LU},
    {690797870235478568LU},
    {15918588465617657345LU},
    {10920971749323289176LU},
    {5341369767531153075LU},
    {91586775118277354LU},
    {5641305915862746834LU},
    {372897136434997899LU},
    {15601460357686550112LU},
    {10657416288970093113LU},
    {14793346762956038021LU},
    {9667465537744253916LU},
    {6595225743525578551LU},
    {1217037265270893422LU},
    {6912841300343588694LU},
    {1480103894076484367LU},
    {14494040278141296612LU},
    {9385526878391514045LU},
    {6285912538866911124LU},
    {2042723319797443533LU},
    {13976490950737256230LU},
    {9985397741039072127LU},
    {14240331648538009415LU},
    {10302802187086246686LU},
    {6004888686316849141LU},
    {1743064987042409388LU},
    {7148513109123485869LU},
    {2905284531227442420LU},
    {17725863096850221087LU},
    {13734800999070983238LU},
    {17408454102413543550LU},
    {13470964583371236391LU},
    {7448167202730856652LU},
    {3186312906392485013LU},
    {17961503662060210364LU},
    {12835591289458320613LU},
    {8038468164940189710LU},
    {2660319080916139095LU},
    {7775405809612116079LU},
    {2342698967152245814LU},
    {18243446835404441821LU},
    {13134893526569018500LU},
    {16781183195777599800LU},
    {11783535502314759521LU},
    {9090737308346732938LU},
    {3840993538936225235LU},
    {8809431461059777003LU},
    {3541053142863363506LU},
    {17044742929638197593LU},
    {12100659053271147776LU},
    {8255722168242491689LU},
    {4176822286836415856LU},
    {16453975782974851483LU},
    {12627382946309891522LU},
    {16154950193251551738LU},
    {12345725250898224547LU},
    {8573619788378722632LU},
    {4440170910379031825LU},
    {14677213080178919984LU},
    {9280464898514544233LU},
    {6729956565722976898LU},
    {1585445163126308571LU},
    {6416558001133605603LU},
    {1326604408413929146LU},
    {14971730835440634449LU},
    {9557623504011748872LU},
    {5899545287230575137LU},
    {1925956249745997432LU},
    {14345391360939690643LU},
    {10119636050570405578LU},
    {14086339513089460978LU},
    {9807011537981269675LU},
    {6176352061782676032LU},
    {2221388794177142297LU},
    {4645969273667933093LU},
    {800785723138752508LU},
    {15470911653044456215LU},
    {11373420850541913934LU},
    {15193476606217751414LU},
    {11078617961046075183LU},
    {4904532315748750276LU},
    {1113897676016467869LU},
    {15711166662665702324LU},
    {10478887844651657197LU},
    {5531320330969666310LU},
    {551137521257365343LU},
    {5236165602156761959LU},
    {274617255429717822LU},
    {16024067513396333525LU},
    {10738224929924540300LU},
    {10175121332051643424LU},
    {14290045724044877945LU},
    {2017400077445878930LU},
    {5807959624509896907LU},
    {2276170459084641523LU},
    {6121428553599989930LU},
    {9898033090940079169LU},
    {13995457595791597592LU},
    {1676957911899526193LU},
    {6638581249293531240LU},
    {9335878501019716739LU},
    {14621655439671320794LU},
    {9648432649093975266LU},
    {14880777660610371771LU},
    {1381595740470957136LU},
    {6361704110345828361LU},
    {496355867522979253LU},
    {5586243815428831724LU},
    {10387866272465587463LU},
    {15802048594559263070LU},
    {10682739535062306150LU},
    {16079413276891537727LU},
    {183173550236554708LU},
    {5327751146329094541LU},
    {11282611831725493668LU},
    {15561864714159317501LU},
    {745794272869995798LU},
    {4700823287298996559LU},
    {1022384903185257847LU},
    {4995907643016788270LU},
    {11023204373473103301LU},
    {15249034227834773916LU},
    {2715173270205716157LU},
    {7983476530087443172LU},
    {12926544698365873679LU},
    {17870694287196709462LU},
    {13190451487051157102LU},
    {18188032917220745783LU},
    {2434074530541786844LU},
    {7683892809584884357LU},
    {13825682600687177388LU},
    {17634841863866999541LU},
    {2960207788152968734LU},
    {7093731691177130567LU},
    {3277898266318493311LU},
    {7356723673529629222LU},
    {13526309990485823181LU},
    {17352969055006450324LU},
    {12571825077733822248LU},
    {16509389621802886001LU},
    {4085446639594887066LU},
    {8347235256753273795LU},
    {4385316662671726587LU},
    {8628611468429802402LU},
    {12254771891282612041LU},
    {16245759514864739088LU},
    {3749408224543070009LU},
    {9182180779464702816LU},
    {11728190041613176715LU},
    {16836668292140131282LU},
    {12009777372633698282LU},
    {17135764254862074803LU},
    {3486129974084818776LU},
    {8864212794817526529LU},
  },
  // Table 7
  {
    {0LU},
    {14297026218246971738LU},
    {3739480296785226499LU},
    {17693640305174776409LU},
    {7478960593570452998LU},
    {11647336200458991452LU},
    {6066303122871811333LU},
    {10540370449199750239LU},
    {14957921187140905996LU},
    {719462723558837590LU},
    {18190174778447759119LU},
    {4186454352089097813LU},
    {12132606245743622666LU},
    {7941693880367668048LU},
    {11221528386651246857LU},
    {6760990482114932819LU},
    {2314105385638474159LU},
    {16606011039351443701LU},
    {1438925447117675180LU},
    {15389128177095195638LU},
    {5176819184107382697LU},
    {9349186979371894515LU},
    {8372908704178195626LU},
    {12852061135186161136LU},
    {17260164902498999715LU},
    {3017782420663483641LU},
    {15883387760735336096LU},
    {1874654797062477818LU},
    {9818682331424574373LU},
    {5632817962143050495LU},
    {13521980964229865638LU},
    {9065332169056797180LU},
    {4628210771276948318LU},
    {9679230332646703620LU},
    {8349665637725751389LU},
    {13093869776623855879LU},
    {2877850894235350360LU},
    {16256046031106380802LU},
    {1447172395810201179LU},
    {15167101243413380865LU},
    {10353638368214765394LU},
    {5316146029614427656LU},
    {13567884121375466577LU},
    {8801145423012152587LU},
    {16745817408356391252LU},
    {3318068450587064334LU},
    {15816736113727779415LU},
    {2155368423718687501LU},
    {6928770137035494129LU},
    {11983746702073623467LU},
    {6035564841326967282LU},
    {10784889269746915496LU},
    {571241037221889271LU},
    {13944350794669237677LU},
    {3749309594124955636LU},
    {17465245978340003502LU},
    {12660420831047286525LU},
    {7627941304773238695LU},
    {11265635924286100990LU},
    {6502821518919955620LU},
    {14445369076285843707LU},
    {1013731284165364129LU},
    {18130664338113594360LU},
    {4464248926753792674LU},
    {9256421542553896636LU},
    {5052009368782661606LU},
    {12938885562819308991LU},
    {8500854657345178853LU},
    {16699331275451502778LU},
    {2438361415297610208LU},
    {15301750307456760761LU},
    {1311534087003020003LU},
    {5755701788470700720LU},
    {9910560003904687082LU},
    {8936568605480632755LU},
    {13433160531109896425LU},
    {2894344791620402358LU},
    {17168842011982667244LU},
    {2003972936381077429LU},
    {15971654734808561391LU},
    {11558542112567752467LU},
    {7350170736305165897LU},
    {10632292059228855312LU},
    {6189143063190076746LU},
    {14385249031365796117LU},
    {129362351812608079LU},
    {17602290846024305174LU},
    {3616069287915891532LU},
    {8069613659970394911LU},
    {12219456864120896069LU},
    {6636136901174128668LU},
    {11128806732629201222LU},
    {592115421185150233LU},
    {14870499276941372483LU},
    {4310736847437375002LU},
    {18283468566038546240LU},
    {13857540274070988258LU},
    {443291124160070840LU},
    {17558007661425790689LU},
    {3874132972891385787LU},
    {12071129682653934564LU},
    {7056148741162291902LU},
    {10691556483821623527LU},
    {5911313579016518077LU},
    {1142482074443778542LU},
    {14534194603306231988LU},
    {4341369850724983533LU},
    {18038774098489967543LU},
    {7498619188249911272LU},
    {12572167746967502514LU},
    {6626272694354900203LU},
    {11356955043751941553LU},
    {16164129222915724365LU},
    {2754998438313178391LU},
    {15255882609546477390LU},
    {1575967398515514900LU},
    {9770593389728645707LU},
    {4751618060635398929LU},
    {13005643037839911240LU},
    {8220317227446192146LU},
    {3442918294975526977LU},
    {16838552643000015131LU},
    {2027462568330728258LU},
    {15729881552635539992LU},
    {5191851001620786759LU},
    {10260349365152534301LU},
    {8928497853507585348LU},
    {13655293292767011870LU},
    {13825454947670189263LU},
    {8769880248339842453LU},
    {10104018737565323212LU},
    {5355222074761047702LU},
    {15571047340291994313LU},
    {2197269079808250771LU},
    {17001709314690357706LU},
    {3286230327346804880LU},
    {8090949930113222851LU},
    {13124027590678440345LU},
    {4876722830595220416LU},
    {9639009470346740378LU},
    {1694003404998155973LU},
    {15126309700153982879LU},
    {2623068174006040006LU},
    {16289026188495393948LU},
    {11511403576941401440LU},
    {6460841412376032314LU},
    {12404590216045952611LU},
    {7659717574044344121LU},
    {17873137210961265510LU},
    {4495469839638798908LU},
    {14695085178345039973LU},
    {974558196382533951LU},
    {5788689583240804716LU},
    {10825724525037803574LU},
    {7183455836099236463LU},
    {11950863037565006645LU},
    {4007945872762154858LU},
    {17435167064983965232LU},
    {322667136815170665LU},
    {13984632961182541107LU},
    {18439803039634491281LU},
    {4147369620306372299LU},
    {14700341472610331794LU},
    {750736876925554120LU},
    {10965645115417973143LU},
    {6792819923282489549LU},
    {12378286126380153492LU},
    {7899802198409108430LU},
    {3490959567872306077LU},
    {17733869815321922247LU},
    {258724703625216158LU},
    {14266859533006381508LU},
    {6321077178069876123LU},
    {10507398944221322433LU},
    {7232138575831783064LU},
    {11688118867968980930LU},
    {16139227319940789822LU},
    {1842869604797847396LU},
    {17014388528977354045LU},
    {3059771123783941223LU},
    {13272273802348257336LU},
    {9104496329819570530LU},
    {10076200741737089851LU},
    {5601605649861110369LU},
    {1184230842370300466LU},
    {15422020802849389416LU},
    {2560989257351016753LU},
    {16565167080512491627LU},
    {8621473694874750004LU},
    {12811787925891902830LU},
    {4918191523123095351LU},
    {9379257193206400621LU},
    {4587066165993316979LU},
    {17996865453631210281LU},
    {886582248320141680LU},
    {14566040062480656426LU},
    {6368674088341730421LU},
    {11388247551726146863LU},
    {7748265945782771574LU},
    {12533063990561865260LU},
    {17311201786256428671LU},
    {3914898935195545381LU},
    {14112297482324583804LU},
    {410335894891267110LU},
    {10950262003901749369LU},
    {5881165506077784355LU},
    {11822627158033036154LU},
    {7096359484389282336LU},
    {2284964148887557084LU},
    {15698685533250957958LU},
    {3193227292835231967LU},
    {16877700115727915397LU},
    {8682739701449967066LU},
    {13697263246138270848LU},
    {5447671394469932761LU},
    {10228582802377494403LU},
    {14997238376499822544LU},
    {1606053613185932938LU},
    {16412710631055299795LU},
    {2714708248930989449LU},
    {13252545388709800406LU},
    {8179454226796595340LU},
    {9515879876326671061LU},
    {4784529023826125711LU},
    {9192477354598318381LU},
    {13401306127730827383LU},
    {5509996876626356782LU},
    {9952477369629264756LU},
    {1754335105868797739LU},
    {16010749551036085873LU},
    {3151934797031029800LU},
    {17137558220847750514LU},
    {12684119393319611681LU},
    {8533818792298138747LU},
    {9503236121270797858LU},
    {5011234792852645752LU},
    {15550243874858089255LU},
    {1271332253486717565LU},
    {16440634454892384292LU},
    {2468500870583955838LU},
    {6885836589951053954LU},
    {11089650629363487192LU},
    {7812103100719684481LU},
    {12250661771740805851LU},
    {4054925136661456516LU},
    {18315226493712369630LU},
    {837864599112289671LU},
    {14828538216368843997LU},
    {10383702003241573518LU},
    {6229441922167438804LU},
    {11817195216799889293LU},
    {7320075525622585047LU},
    {17856995707015170696LU},
    {3583166989756935122LU},
    {14138355556244791691LU},
    {170216361013444817LU},
  },

};

template <>
const uint64_t FingerprintTable<96>::poly[2] = {5860692403937950147LU, 13148800308052230144LU};

template <>
const uint64_t FingerprintTable<96>::table[8][256][2] = {
  // Table 0
  {
    {0LU, 0LU},
    {5860692403937950147LU, 13148800308052230144LU},
    {11721384807875900295LU, 7850856542394908672LU},
    {17582024160376736324LU, 15747456603911094272LU},
    {1441202947931889357LU, 8042968148917354496LU},
    {4996025542042248974LU, 15701713084789817344LU},
    {13162498970240658762LU, 246999261340762112LU},
    {16717304247043921033LU, 13048169134112636928LU},
    {2882405895863778714LU, 16085936297834708992LU},
    {8742894615272522841LU, 7585563572231471104LU},
    {9992051084084497949LU, 12956682095870083072LU},
    {15852592854928259038LU, 411672061270818816LU},
    {4323581630876377943LU, 12727987547058208768LU},
    {7878253866771765908LU, 493998522681524224LU},
    {11433174867173707984LU, 15875537588149288960LU},
    {14987864420378290451LU, 7649594194515722240LU},
    {5764811791727557429LU, 13725128521959866368LU},
    {96235273442706166LU, 576636240372170752LU},
    {17485789230545045682LU, 15171127144462942208LU},
    {11817265213939396977LU, 7274236940726042624LU},
    {4900083219738568184LU, 15125109855536283648LU},
    {1537358094459444283LU, 7466620118030614528LU},
    {16621148894361081471LU, 13624786528168312832LU},
    {13258441636146966460LU, 823344122541637632LU},
    {8647163261752755887LU, 7009231020406865920LU},
    {2978490811078541164LU, 15509313328911482880LU},
    {15756507733543531816LU, 987997045363048448LU},
    {10087782781188017387LU, 13533314831548940288LU},
    {7782443760736868450LU, 1070614885945049088LU},
    {4419605660637864353LU, 13304331102589026304LU},
    {14891840734208945125LU, 7072990071908990976LU},
    {11528984767047029286LU, 15299188389031444480LU},
    {11529623583455114859LU, 9003512970210181120LU},
    {17389575878610243496LU, 14594771588793499648LU},
    {192470546885412332LU, 1153272480744341504LU},
    {6052440159349750831LU, 11995569608749744128LU},
    {12970751627139426470LU, 1399699961678921728LU},
    {16524834387380539749LU, 11895510215216332800LU},
    {1633650542493129505LU, 9196178764952764416LU},
    {5187786354169242338LU, 14548473881452085248LU},
    {9800166439477136369LU, 11803475637363015680LU},
    {15660269092847252018LU, 1564915903173230592LU},
    {3074716188918888566LU, 14933240236061229056LU},
    {8934801524981891509LU, 8738226648656117760LU},
    {11241267270242309436LU, 14722269814689103872LU},
    {14795553715012611327LU, 8802828982627074048LU},
    {4515905805251176123LU, 11575335208051802112LU},
    {8070139198584381304LU, 1646688245083275264LU},
    {17294326523505511774LU, 14018462040813731840LU},
    {11625082464239924381LU, 8426930631677575168LU},
    {5956981622157082329LU, 12571882584113414144LU},
    {287719695828567834LU, 1729840396776767488LU},
    {16429663784790938515LU, 12472094778541998080LU},
    {13066271393377512016LU, 1975994090726096896LU},
    {5092266381761191956LU, 13971872971480891392LU},
    {1728821488666483159LU, 8619885589388328960LU},
    {15564887521473736900LU, 2141229771890098176LU},
    {9895756437028014343LU, 12380044721626546176LU},
    {8839211321275728707LU, 8161918131468500992LU},
    {3170098103895030400LU, 14356659203198681088LU},
    {14700233853732384265LU, 8226231302471286784LU},
    {11336937394708338634LU, 14145980143817981952LU},
    {7974469417729367438LU, 2223275900785393664LU},
    {4611225460384506957LU, 12151632704353337344LU},
    {1249673651470521621LU, 5736497988579098624LU},
    {4612503093200678102LU, 18007025940420362240LU},
    {12969525740101609106LU, 2553535392376684544LU},
    {16332407683510935377LU, 10742799103877447680LU},
    {384941093770824664LU, 2306544961488683008LU},
    {6053622203350790683LU, 10843421447364280320LU},
    {12104880318699501663LU, 5544395143789936640LU},
    {17773579295344443804LU, 18052760697808355328LU},
    {4132025671228811407LU, 10421500309929984000LU},
    {7494759180569301324LU, 2799399923357843456LU},
    {11240243693392304904LU, 18181950058486824960LU},
    {14602924701051527883LU, 5344276356723113984LU},
    {3267301084986259010LU, 18392357529905528832LU},
    {8935869219746582401LU, 5280236972705579008LU},
    {10375572708338484677LU, 10650203689194618880LU},
    {16044122976035929094LU, 2717064631494377472LU},
    {4708234515170438688LU, 17430427177932816384LU},
    {1153588805244721123LU, 5160207201016479744LU},
    {16428492873347751335LU, 11319385642888069120LU},
    {12873794111984952420LU, 3129831806346461184LU},
    {6149432377837777133LU, 11419736398412906496LU},
    {288917132996200750LU, 2883115162443710464LU},
    {17869603049963783018LU, 17476453297312235520LU},
    {12009070487815142057LU, 4967815193259147264LU},
    {7590639861229687738LU, 3375985569015267328LU},
    {4035790466775067257LU, 10997795555668656128LU},
    {14699159699335307325LU, 4767676563443417088LU},
    {11144363356315671038LU, 17605657965254148096LU},
    {9031811610502352247LU, 4703926342394052608LU},
    {3171146007445566644LU, 17815774074681425920LU},
    {16140278397168762608LU, 3293376490166550528LU},
    {10279630111421138739LU, 11226770522895286272LU},
    {12778620897801937790LU, 3706117104940875776LU},
    {16141908973301471933LU, 9590180007917912064LU},
    {1440150646333657337LU, 6889695650993143808LU},
    {4803420854770297146LU, 16853861263355150336LU},
    {11913963244314164659LU, 6697021094517276672LU},
    {17583102712821236848LU, 16900167732429848576LU},
    {575439391657135668LU, 3459680793553534976LU},
    {6244526358482958327LU, 9690248231904083968LU},
    {11049182445553164004LU, 17028809519137816576LU},
    {14412583495872325415LU, 6497445483374444544LU},
    {4322379795661319523LU, 9268870270393778176LU},
    {7685798713045472416LU, 3951988181452193792LU},
    {10184532763522383913LU, 9497001869252231168LU},
    {15853768164419140074LU, 3870224669994909696LU},
    {3457642977332966318LU, 17239771178776657920LU},
    {9126930879908874861LU, 6432851911136772096LU},
    {16237290613127075915LU, 10166795288849678336LU},
    {12683030969237922184LU, 4282459543780196352LU},
    {4899011126926453708LU, 16277256024056922112LU},
    {1344768800346477071LU, 6313345369543540736LU},
    {17678422642551457414LU, 16323836262937001984LU},
    {11818293188837097285LU, 6120399242285547520LU},
    {6340196207790060801LU, 10266574332687810560LU},
    {480119805510667458LU, 4036314611564150784LU},
    {14507832919429146065LU, 5920843336452669440LU},
    {10953723633755216914LU, 16452462604942573568LU},
    {7781257318688134742LU, 4528606692199366656LU},
    {4227130715707125653LU, 9845216213926412288LU},
    {15948938835458734876LU, 4446551801570787328LU},
    {10089013066273260255LU, 10073636992932904960LU},
    {9222450920769013915LU, 5856521334997123072LU},
    {3362472100146475352LU, 16663150494776033280LU},
    {2499347302941043242LU, 11472995977158197248LU},
    {8357039964213253097LU, 2972843291319468032LU},
    {9225006186401356205LU, 17567307807131172864LU},
    {15082716714736476270LU, 5022201152947617792LU},
    {3940466413106918631LU, 17340575886574878720LU},
    {7492307406493666596LU, 5107070784753369088LU},
    {10666177798244271968LU, 11265122845681778688LU},
    {14218071293312319139LU, 3038854134045343744LU},
    {769882187541649328LU, 4613089922977366016LU},
    {6627741149947702899LU, 17761371124102332416LU},
    {12107244406701581367LU, 3240098821019009024LU},
    {17965085502042627572LU, 11137059384910151680LU},
    {2210992226738882941LU, 3430230207099830272LU},
    {5763016563689451710LU, 11088790287579873280LU},
    {13548442681707969274LU, 4857546013923082240LU},
    {17100414516979335993LU, 17658777321907159040LU},
    {8264051342457622815LU, 2396256546150416384LU},
    {2592545450385729756LU, 10896699631907897344LU},
    {14989518361138602648LU, 5598799846715686912LU},
    {9317995151757515611LU, 18143598800852221952LU},
    {7399379670199635922LU, 5683378116530012160LU},
    {4033743313075058193LU, 17917156043264098304LU},
    {14124794736953097301LU, 2462538976838287360LU},
    {10759105328393504150LU, 10688552713446227968LU},
    {6534602169972518021LU, 18337970986101506048LU},
    {863229593685349702LU, 5189381810051612672LU},
    {17871738439493164802LU, 10560473945411158016LU},
    {12200383180513093313LU, 2663803506560860160LU},
    {5669957710620963400LU, 10512478635066130432LU},
    {2304401342967417739LU, 2853663304679686144LU},
    {17007005194578739663LU, 18235088020938162176LU},
    {13641501878362306572LU, 5434129262988754944LU},
    {9416469030340877377LU, 16414110282156081152LU},
    {15274899326458029442LU, 6175365692573876224LU},
    {2307177610489442246LU, 10320414402032959488LU},
    {8165555404927407621LU, 4125462249840050176LU},
    {10857662769840685708LU, 10111987151055880192LU},
    {14410241672985951055LU, 4192027212066586624LU},
    {3748283114180112651LU, 16187950073286492160LU},
    {7300844150260353224LU, 6259663612692922368LU},
    {12298864755675554267LU, 4392728723116261376LU},
    {18157111708228900888LU, 9984471264254754816LU},
    {577834265992401500LU, 5766230324887420928LU},
    {6436133720227031967LU, 16608202134889955328LU},
    {13740049424206610198LU, 6010132227612999680LU},
    {17292462026218014421LU, 16506162520914919424LU},
    {2018966432846400657LU, 4583431889603264512LU},
    {5571396901920732498LU, 9935630386518294528LU},
    {15181279722459375476LU, 6751971138030534656LU},
    {9510443295546089143LU, 16990460494886207488LU},
    {8071580933550134515LU, 3548847037627760640LU},
    {2400797558073945392LU, 9744071757035208704LU},
    {14316541942080600505LU, 3615701180002336768LU},
    {10951575324961063034LU, 9535353126886834176LU},
    {7206931938734213694LU, 6835995288344199168LU},
    {3841982638921790461LU, 16764571856798744576LU},
    {18063623221004704494LU, 9407852684788105216LU},
    {12392706804620370733LU, 3816382985742057472LU},
    {6342292014891133289LU, 17184804075653300224LU},
    {671322547071799466LU, 6342577307802140672LU},
    {17198912653532218403LU, 17082492890896138240LU},
    {13833812720627973600LU, 6586752980333101056LU},
    {5477633399346182052LU, 9359303186222940160LU},
    {2112516149132725863LU, 4006796972081020928LU},
    {3744968154551516991LU, 15034255294177738752LU},
    {7110497721894323964LU, 7412234209881751552LU},
    {10471561622859746488LU, 13571527000962629632LU},
    {13837073872893392251LU, 733615942126272512LU},
    {2880301292667314674LU, 13779391301986287616LU},
    {8551700669802059825LU, 667613929853157376LU},
    {9606841709540594293LU, 15260978453000749056LU},
    {15278188035240356790LU, 7327373339809284096LU},
    {2015519531790942885LU, 1123892606632198144LU},
    {5381182414918777702LU, 13394042189034553344LU},
    {13353781151498023202LU, 7163826439786070016LU},
    {16719461351932922081LU, 15353591391150145536LU},
    {1150878783314271336LU, 6919361587107069952LU},
    {6822358149919810987LU, 15456193955078602752LU},
    {12489052716965916655LU, 933752390098616320LU},
    {18160585135008536108LU, 13442320116817592320LU},
    {7203636770319500298LU, 7988563463171473408LU},
    {3651620817396776393LU, 15610874964566081536LU},
    {13930421003894945677LU, 157287659499159552LU},
    {10378422918035099214LU, 12994890966748889088LU},
    {8644759591322639047LU, 90996467078004736LU},
    {2786892245425644292LU, 13203046646943842304LU},
    {15371597426090944832LU, 7903976362904387584LU},
    {9513782581875216515LU, 15837326552606965760LU},
    {5474171105124399504LU, 12817717273661800448LU},
    {1922321453335216211LU, 547259664794910720LU},
    {16812659773982886423LU, 15929924149133180928LU},
    {13260792255128728532LU, 7740449339989819392LU},
    {6915285954665932637LU, 16032798283843764224LU},
    {1057601952332996254LU, 7495710717505437696LU},
    {18253861759817749722LU, 12865703822273544192LU},
    {12396125255805644057LU, 357408628409368576LU},
    {10662763745106692436LU, 12418254657657241600LU},
    {14027837152544600215LU, 1886846503989805056LU},
    {3554191405891320531LU, 13881599003801419776LU},
    {6919317864766292752LU, 8564919087560392704LU},
    {9798022253852907417LU, 14107767974404292608LU},
    {15468965196240481882LU, 8480612405708062720LU},
    {2689537600692954142LU, 12626690739087081472LU},
    {8360497860387610077LU, 1820272711310508032LU},
    {13545107793426265294LU, 8316522364120596480LU},
    {16910101211393363213LU, 14200928452164452352LU},
    {1824901937432512329LU, 2277098927700312064LU},
    {5189842303964642954LU, 12240798484571095040LU},
    {12680392415580121603LU, 2086404591666069504LU},
    {18351202042182685632LU, 12289630531854794752LU},
    {960239611021334916LU, 8072629223128301568LU},
    {6631031920314720327LU, 14302959304406204416LU},
    {14121325708220887649LU, 1310533734784565248LU},
    {10568921765148740514LU, 11841686672905338880LU},
    {7013159638552183270LU, 9141228704259637248LU},
    {3460703193800882213LU, 14458181136175595520LU},
    {15562514637376269484LU, 9057213384398733312LU},
    {9704259026420503919LU, 14684060943810297856LU},
    {8454261431414251307LU, 1243688354143272960LU},
    {2595987953393493736LU, 12050396541320429568LU},
    {17003720883844108283LU, 14777236900632592384LU},
    {13451133597207918136LU, 8893103603141574656LU},
    {5283816843791907964LU, 11664484409695797248LU},
    {1731282058836968895LU, 1700529912156258304LU},
    {18444901841538027830LU, 11713042669994246144LU},
    {12586479929448704245LU, 1510107164084011008LU},
    {6724944200292950705LU, 14879556915842514944LU},
    {866540155266521970LU, 8648919100157853696LU},
  },
  // Table 1
  {
    {0LU, 0LU},
    {4998694605882086485LU, 4499247880606842880LU},
    {9997389211764172970LU, 8998495761213685760LU},
    {14979872618206067967LU, 4796788955582300160LU},
    {4913116833680222359LU, 5745401558862921728LU},
    {103595952279076034LU, 8199733699307110400LU},
    {14885304139138908221LU, 3700499287717707776LU},
    {10073944874295858280LU, 948670052763172864LU},
    {9826233667360444718LU, 11490803117725843456LU},
    {14772692124940076411LU, 11603245791031853056LU},
    {207191904558152068LU, 16399467398614220800LU},
    {5169843969391406545LU, 15989492446425776128LU},
    {14732170276083120569LU, 15045484881310121984LU},
    {9884768470191828460LU, 17202843294778785792LU},
    {5102281830787584275LU, 12406670340585947136LU},
    {256736000523715910LU, 10546817817720651776LU},
    {4750957145968384926LU, 9842332396790218752LU},
    {337809660785446859LU, 13179352437653241856LU},
    {14651079161075610420LU, 17615804735296634880LU},
    {10236110884636813153LU, 14557713236574076928LU},
    {414383809116304137LU, 14352190723518889984LU},
    {4656371968345352028LU, 17968715381895856128LU},
    {10339687938782813091LU, 13532240819142000640LU},
    {14565517675129802742LU, 9636761230345502720LU},
    {14533961724694645424LU, 1720785884162293760LU},
    {10155035989304614629LU, 2995456397212123136LU},
    {4832043173419868698LU, 7710269888996048896LU},
    {454920637099128399LU, 6156679629898776576LU},
    {10204563661575168551LU, 6366596607462342656LU},
    {14466418346784945778LU, 7361762502998228992LU},
    {513472001047431821LU, 2646891561731751936LU},
    {4791502701324787416LU, 1930689392708419584LU},
    {9501914291936769853LU, 1237920719870885888LU},
    {14304412038663398248LU, 3413007555746594816LU},
    {675619321570893719LU, 7911960801596932096LU},
    {5494011608388389826LU, 6033808041558671360LU},
    {14407983938680741802LU, 6815703328807190528LU},
    {9416357547735649279LU, 6982466240212107264LU},
    {5570580602591115008LU, 2483500075100143616LU},
    {581038885692023637LU, 2019759107392667648LU},
    {828767618232608275LU, 10257637373328228352LU},
    {5683174958039740998LU, 12694232020394442752LU},
    {9312743936690704057LU, 17490686690082160640LU},
    {14151274328592489196LU, 14757149171085475840LU},
    {5741731613555396228LU, 13970648313096044544LU},
    {788222541832051409LU, 18415566884633051136LU},
    {14200807292430919214LU, 13619064111311618048LU},
    {9245195954475004539LU, 9471114799984148480LU},
    {13993632846914628771LU, 11077455941900173312LU},
    {9758650221601421558LU, 12090913072357572608LU},
    {5228259616803193865LU, 16526542969663127552LU},
    {995414442094121052LU, 15792603650859204608LU},
    {9664086346839737396LU, 15420539777992097792LU},
    {14070183217878962273LU, 16748967441748459520LU},
    {909841274198256798LU, 12313359259797553152LU},
    {5331850277514393803LU, 10705440172666781696LU},
    {5363388702327668109LU, 489924733316366336LU},
    {1094510882443373016LU, 4088149085800890368LU},
    {13894529671553602855LU, 8803864142759854080LU},
    {9623531993250693490LU, 4926113182528831488LU},
    {1026944002094863642LU, 5293783123463503872LU},
    {5412937952421888335LU, 8577036942649065472LU},
    {9583005402649574832LU, 3861378785416839168LU},
    {13953069628513118693LU, 857607593512665088LU},
    {6264073709686839225LU, 10674121120820494336LU},
    {1418804973667091436LU, 12273033043056263168LU},
    {15876219326969806611LU, 16772263331477061632LU},
    {11028549257555258182LU, 15470857299844661248LU},
    {1351238643141787438LU, 15823921603193864192LU},
    {6313622410092112763LU, 16566868086892789760LU},
    {10988023216776779652LU, 12067616083117342720LU},
    {15934758734240859089LU, 11027137320535982080LU},
    {16047379546680297111LU, 816717327306326016LU},
    {11235725629766554306LU, 3829495684105502720LU},
    {6056886480435490365LU, 8625664515129737216LU},
    {1247651489103116904LU, 5315389063820214272LU},
    {11141161205182230016LU, 4967000150200287232LU},
    {16123930467333093973LU, 8835743945536307200LU},
    {1162077771384047274LU, 4039518214785335296LU},
    {6160477690835636991LU, 468315494424772608LU},
    {1657535236465216551LU, 2068530672946905088LU},
    {5935271250312075378LU, 2505250077249896448LU},
    {11366349916079481997LU, 6941719967079333888LU},
    {15628490456998228184LU, 6783964289288896512LU},
    {5993827356139300016LU, 5985039774539317248LU},
    {1616990709887332581LU, 7890214097982062592LU},
    {15678022871147678746LU, 3453757127414251520LU},
    {11298802483686955087LU, 1269663057924063232LU},
    {11483463227110792457LU, 9494552552482537472LU},
    {15709570023342229852LU, 13669523427214491648LU},
    {1576445083664102819LU, 18384389695556550656LU},
    {5818164945010221558LU, 13930463890405064704LU},
    {15813142473048552862LU, 14733712518098714624LU},
    {11397905933086499275LU, 17440228473690914816LU},
    {5894734488901377332LU, 12725410308982571008LU},
    {1481864097962559841LU, 10297822895530835968LU},
    {15362870612991565956LU, 9588131501791248384LU},
    {10406991011512661201LU, 13510632653992230912LU},
    {6885508947896223790LU, 18009603492028612608LU},
    {1932276970417265787LU, 14384071600037167104LU},
    {10456519233606387731LU, 14606341865616703488LU},
    {15295326685392886854LU, 17637411800934776832LU},
    {1990828884188242105LU, 13138463228008857600LU},
    {6844967926112711916LU, 9810450420760313856LU},
    {6732364776718381482LU, 1907391278186758144LU},
    {1743108949888329215LU, 2596571883805605888LU},
    {15552045093721479424LU, 7393079330051457024LU},
    {10560124050705960277LU, 6406920668130050048LU},
    {1819682548396513597LU, 6179974445885554688LU},
    {6637780148783779176LU, 7760586268387311616LU},
    {10663700555028787607LU, 2964136271624011776LU},
    {15466484157464651202LU, 1680458524959703040LU},
    {10726777404655336218LU, 979849466632732672LU},
    {15097127486228115279LU, 3740685866482270208LU},
    {2189021764886746032LU, 8176298171601780736LU},
    {6574721028783540197LU, 5694944399033630720LU},
    {15056605087682696077LU, 4765612840247623680LU},
    {10785312757309360088LU, 8958312480984006656LU},
    {6507158340490771239LU, 4522686706847055872LU},
    {2238566410675515250LU, 50460458364174336LU},
    {2053888004189727284LU, 10587566246927007744LU},
    {6475628709623201377LU, 12438411604897300480LU},
    {10825875904843776670LU, 17154073885298130944LU},
    {15232249835767715531LU, 15023737103953428480LU},
    {6390051487110283939LU, 15948745116731047936LU},
    {2157483406645597942LU, 16367727233814495232LU},
    {15137681906389019145LU, 11652016300024135680LU},
    {10902431017552821852LU, 11512551994594164736LU},
    {12528147419373678451LU, 2901498167931437056LU},
    {16753960100531403558LU, 1600109556686389248LU},
    {2837609947334182873LU, 6099322012402974720LU},
    {7079616235746055052LU, 7698251629904003072LU},
    {16857551790424377316LU, 7493978170647904256LU},
    {12442566484566053809LU, 6453516897173372928LU},
    {7156169834914934606LU, 1954246991974236160LU},
    {2743040504684559131LU, 2697211239657897984LU},
    {2702477286283574877LU, 13201099132678176768LU},
    {6980525015963609608LU, 9890805986103394304LU},
    {12627244820184225527LU, 14686992100076027904LU},
    {16889081350424593058LU, 17699753036487852032LU},
    {7039061882157536970LU, 17908702452408909824LU},
    {2661956401009345183LU, 14337481968063610880LU},
    {16938629708775997024LU, 9541273588980514816LU},
    {12559685844186425909LU, 13409999895209705472LU},
    {17019703227302687981LU, 11588549216103825408LU},
    {12208361026222121144LU, 11430775774328651776LU},
    {7390404154867620935LU, 15867263565581778944LU},
    {2580865152856868882LU, 16303965480777940992LU},
    {12113772960870980730LU, 17251329030259474432LU},
    {17096273388125620271LU, 15067217265504026624LU},
    {2495302978206233808LU, 10630778127640428544LU},
    {7493979420528976005LU, 12535935030695821312LU},
    {7237261083066688963LU, 4586147193697599488LU},
    {2391698231973228950LU, 132238877652942848LU},
    {17208876608387304809LU, 4847087794327126016LU},
    {12361492966038509884LU, 9022076433043816448LU},
    {2324155542768094548LU, 8079036429570670592LU},
    {7286790543822149889LU, 5651466436506288128LU},
    {12320955381671273982LU, 936630988849545216LU},
    {17267431959843795371LU, 3643164639707004928LU},
    {3315070472930433102LU, 4137061345893810176LU},
    {7737062412467358747LU, 511512033515012096LU},
    {11870542500624150756LU, 5010500154499792896LU},
    {16276657492256253105LU, 8932983611435515904LU},
    {7651504429604532441LU, 8561922501762875392LU},
    {3418642234065855628LU, 5233892205407502336LU},
    {16182073618692397171LU, 734960984149458944LU},
    {11947109156921674790LU, 3766013155482796032LU},
    {11987654712278600032LU, 11970079549078634496LU},
    {16357735958954908981LU, 10983938582422487040LU},
    {3233981419774665162LU, 15780428195964125184LU},
    {7619957206542366111LU, 16469626221970325504LU},
    {16317194320239600119LU, 16836011941913690112LU},
    {12046213705699194274LU, 15552351959234117632LU},
    {7552410462988634461LU, 10755884061047128064LU},
    {3283514522494754056LU, 12336513372655714304LU},
    {8065864871849952208LU, 12826029959524909056LU},
    {3076340210123429765LU, 10344693950941495296LU},
    {16524386362236709754LU, 14780288904393129984LU},
    {11532741842092097327LU, 17541142793349496832LU},
    {3152890167328205639LU, 18322035317403549696LU},
    {7971299483548401426LU, 13849826764185927680LU},
    {11636329890020443117LU, 9414183707100577792LU},
    {16438809481777682360LU, 13606900768224313344LU},
    {16695545482300871422LU, 3353139675895169024LU},
    {11739917114925418155LU, 1222785405443637248LU},
    {7858678741976578644LU, 5938465587268157440LU},
    {2905187825205784065LU, 7789293181253713920LU},
    {11789468977802754665LU, 7004076544255590400LU},
    {16627982314515263036LU, 6864594818438266880LU},
    {2963728195925119683LU, 2148901717352120320LU},
    {7818153664915064470LU, 2567866139170308096LU},
    {18100704033844099274LU, 13575583949761019904LU},
    {13721465483092470943LU, 9373859655022804992LU},
    {8182832645462773856LU, 13873124887297523712LU},
    {3806013020291990581LU, 18372355003919630336LU},
    {13771017895792447581LU, 17572462910347673600LU},
    {18033140316370027528LU, 14820616255005786112LU},
    {3864553940834531575LU, 10321399126364782592LU},
    {8142307018712312994LU, 12775713571543711744LU},
    {8317960631609272804LU, 2526978037627486208LU},
    {3905108360994913713LU, 2117020849423777792LU},
    {18001601958129402190LU, 6913224555582455808LU},
    {13586348354119718171LU, 7025684717995294720LU},
    {3981657768376484211LU, 7830182382308163584LU},
    {8223395792996668710LU, 5970347554708127744LU},
    {13689935852225423833LU, 1174156767811076096LU},
    {17916025627358838156LU, 3331532601667092480LU},
    {13464729553436762964LU, 3814782556373516288LU},
    {18411483225584973569LU, 756708752916217856LU},
    {3486217899776658430LU, 5193143767611211776LU},
    {8448584637039026091LU, 8530181228861587456LU},
    {18370941037180685251LU, 8884213111033167872LU},
    {13523289096680529814LU, 4988751286221406208LU},
    {8381037343796863849LU, 552259371799674880LU},
    {3535751552319420220LU, 4168801519283470336LU},
    {3639365096793027194LU, 12359948891771109376LU},
    {8637746887313516079LU, 10806341212286484480LU},
    {13275560297567558352LU, 15521172536774623232LU},
    {18258346615159410309LU, 16795825354559193088LU},
    {8552189454139120365LU, 16446187404320047104LU},
    {3742936308105776824LU, 15729967746189885440LU},
    {18163763291284533831LU, 11015114706347098112LU},
    {13352126404041909778LU, 12010262837898248192LU},
    {8714195753672167415LU, 12487307466805084160LU},
    {4445585669155953570LU, 10609172195873652736LU},
    {17461254392813348701LU, 15108107540300300288LU},
    {13189979092111143688LU, 17283212140160745472LU},
    {4378043529773492064LU, 16352596343203561472LU},
    {8763724664739197749LU, 15888872795883438080LU},
    {13149442057567080394LU, 11389888798067261440LU},
    {17519809194580859807LU, 11556669404737437696LU},
    {17344138056077680345LU, 3619868758568337408LU},
    {13108905296155855500LU, 886313475586916352LU},
    {8795280681746740851LU, 5682785496942510080LU},
    {4562695545824338470LU, 8119362654901895168LU},
    {13014316680981542478LU, 9045373413694111744LU},
    {17420708766589592091LU, 4897406407101382656LU},
    {4477132821351030500LU, 100920916728348672LU},
    {8898856497096526513LU, 4545822067878002688LU},
    {4107776008379454569LU, 2728388420144463872LU},
    {8961933213577969724LU, 1994431406075281408LU},
    {12951257419246402755LU, 6430079136085049344LU},
    {17790047849934858390LU, 7443518846155096064LU},
    {9020469530082950398LU, 7667073349905809408LU},
    {4067255672928430251LU, 6059136498790301696LU},
    {17839595658597798996LU, 1623546218263085056LU},
    {12883698993071243265LU, 2951956392912617472LU},
    {12780102974220567879LU, 13450746159752544256LU},
    {17582868456315277586LU, 9573012619908874240LU},
    {4314966813291195885LU, 14288710393919438848LU},
    {9133081477709396408LU, 17886952441669222400LU},
    {17686460695896714704LU, 17659003473410129920LU},
    {12694521489590303109LU, 14655249770612785152LU},
    {9209635626567222650LU, 9939574261712683008LU},
    {4220396820818366767LU, 13222845844882980864LU},
  },
  // Table 2
  {
    {0LU, 0LU},
    {787157787337582373LU, 16641238619603861504LU},
    {1574315574675164747LU, 14835733165498171392LU},
    {2248875640374733166LU, 3103704639816597504LU},
    {3148631149350329495LU, 11224722257286791168LU},
    {2404540186922974130LU, 9022881825311162368LU},
    {4497751280749466332LU, 6207409279633195008LU},
    {3785190978916267513LU, 12741997816277106688LU},
    {6297262298700658991LU, 4002700440864030720LU},
    {6739871468033891850LU, 15095499165586685952LU},
    {4809080373845948260LU, 18045763650622324736LU},
    {5211160410695372865LU, 2062332197620154368LU},
    {8995502561498932664LU, 12414818559266390016LU},
    {8519396785732633245LU, 5385115409739415552LU},
    {7570381957832535027LU, 7037251558844661760LU},
    {7197857839628553430LU, 9752783969346125824LU},
    {12594524597401317982LU, 8005400881728061440LU},
    {11827638662994466171LU, 9937592709831196672LU},
    {13479742936067783701LU, 11744254257463820288LU},
    {12825443728157498160LU, 4902862385661870080LU},
    {9618160747691896521LU, 17644783227535097856LU},
    {10346485695043308012LU, 1310356756362166272LU},
    {10422320821390745730LU, 4124664395240308736LU},
    {11119121705226160039LU, 16126350338067267584LU},
    {17991005122997865329LU, 6382893044823228416LU},
    {17528124101300137044LU, 13719399546688110592LU},
    {17038793571465266490LU, 10770230819478831104LU},
    {16616452677342454303LU, 8324347030029729792LU},
    {15140763915665070054LU, 14074503117689323520LU},
    {15632635707039985859LU, 2712046993001152512LU},
    {14395715679257106861LU, 1058823864982700032LU},
    {14783999216008330888LU, 16735443186733809664LU},
    {919902527783296383LU, 7514299232883310592LU},
    {443795534402140762LU, 10284437093081939968LU},
    {1809657417049379636LU, 11937701074829312000LU},
    {1437134280237085713LU, 4853391358913675264LU},
    {2843470250010231272LU, 17549998036661305344LU},
    {3286082874636248781LU, 1549115538830000128LU},
    {3652171409827860387LU, 4498254407426637824LU},
    {4054248304917145734LU, 15608505259310186496LU},
    {6602409870874567760LU, 6900734601707126784LU},
    {5858324524125291381LU, 13345814774361882624LU},
    {5654673297323993627LU, 10531466762791157760LU},
    {4942107616035884350LU, 8419135777136443392LU},
    {8075613369740261575LU, 14123971103600672768LU},
    {8862763303721705442LU, 2518605896532099072LU},
    {7335027054580315788LU, 711973726475780096LU},
    {8009594660103377321LU, 17226547910775144448LU},
    {11676878483317305121LU, 527135453795581952LU},
    {12168744659030886404LU, 16258360500121763840LU},
    {13246648573827178858LU, 14606262455966367744LU},
    {13634937490016503375LU, 3189199490011627520LU},
    {9925568832960082870LU, 11283482490842382336LU},
    {9462695664601683091LU, 8820147931442053120LU},
    {11270156811806113277LU, 5869851938526330880LU},
    {10847808377876552408LU, 13223810292674199552LU},
    {17683601293891114510LU, 3520882793326313472LU},
    {18411927458874192171LU, 15433060097286209536LU},
    {16190953049741875269LU, 18248493919539036160LU},
    {16887752952168857440LU, 2003577169564925952LU},
    {16058405764729211545LU, 12329317919455444992LU},
    {15291516375012830652LU, 5614589091388588032LU},
    {14628814581127300306LU, 7420126671849652224LU},
    {13974518514993964023LU, 9225654339526197248LU},
    {1839805055566592766LU, 15028598465766621184LU},
    {1397460746143784411LU, 3918625309288562688LU},
    {887591068804281525LU, 2122130112454328320LU},
    {485773624097313680LU, 18123290030813216768LU},
    {3619314834098759273LU, 5428658075949072384LU},
    {4095716530962186572LU, 12513244525197524992LU},
    {2874268560474171426LU, 9706782717827350528LU},
    {3247095128133897991LU, 6936921316083630080LU},
    {5686940500020462545LU, 16653251999613059072LU},
    {4900085269521294580LU, 138963069861625856LU},
    {6572165749272497562LU, 3098231077660000256LU},
    {5897901574596864703LU, 14703881814154412032LU},
    {7304342819655720774LU, 8996508814853275648LU},
    {8048696481608202339LU, 11109126017128595456LU},
    {8108496609834291469LU, 12770266444910821376LU},
    {8821321741504722472LU, 6325472763754577920LU},
    {13204819741749135520LU, 13801469203414253568LU},
    {13667433391009935237LU, 6447225319840546816LU},
    {11716649048250582763LU, 8244885475014213632LU},
    {12138729235700605390LU, 10707934779866611712LU},
    {11309346594647987255LU, 2616189451872763904LU},
    {10817176919371690770LU, 14032965926328991744LU},
    {9884215232071768700LU, 16838271554272886784LU},
    {9495631681123843417LU, 1106760291326099456LU},
    {16151226739480523151LU, 9801198133491793920LU},
    {16917812629634193066LU, 7995393045287665664LU},
    {17725526607443410884LU, 5037211793064198144LU},
    {18379528038818142433LU, 11751662925725564928LU},
    {14670054109160631576LU, 1423947452951560192LU},
    {13941468425079949885LU, 17668587744470761472LU},
    {16019189320206754643LU, 16006351747840737280LU},
    {15322121171300238454LU, 4093897710548025344LU},
    {1534718717949273985LU, 13319512416116015104LU},
    {2279069199486812324LU, 6785208996581081088LU},
    {42077375795734986LU, 8447474508226363392LU},
    {754905924104277743LU, 10649600332188876800LU},
    {4539142250403461910LU, 2530548641509146624LU},
    {3752287962641177651LU, 14262863521250279424LU},
    {3109544774691140957LU, 17221004263342211072LU},
    {2435279343745979000LU, 580052272675815424LU},
    {4767117623613808302LU, 10327909674015260672LU},
    {5243526898955401611LU, 7612655096358240256LU},
    {6336885270304100581LU, 4807319472362749952LU},
    {6709704023262492608LU, 11837300179856261120LU},
    {7609424626233426489LU, 1482284941466140672LU},
    {7167074976010380572LU, 17465992990362173440LU},
    {8954014559272701042LU, 15668373826356379648LU},
    {8552202768898616151LU, 4575851422649679872LU},
    {13512162201007560159LU, 15546580158843453440LU},
    {12783568938465522426LU, 3544616658049957888LU},
    {12564409929334840212LU, 1883508494062059520LU},
    {11867349595112914097LU, 18217657132390547456LU},
    {10391766656329550152LU, 5478265167261204480LU},
    {11158357887266713197LU, 12319380718047199232LU},
    {9651195429406459651LU, 9360073849384730624LU},
    {10305191206465118246LU, 7427605425387732992LU},
    {17068793616652512496LU, 16162573061449580544LU},
    {16576627121807903701LU, 485668347711586304LU},
    {17958559745864884923LU, 3292098509762723840LU},
    {17569972778262037918LU, 14654269517341917184LU},
    {14362724702190219367LU, 8902147502891859968LU},
    {14825337408697325378LU, 11347744663403495424LU},
    {15171415111687896620LU, 13144278102626533376LU},
    {15593496555424192777LU, 5807485246702092288LU},
    {3679610111133185533LU, 11610452857823690752LU},
    {4178234555325944536LU, 5174938367611109376LU},
    {2794921492287568822LU, 7837250618577125376LU},
    {3180954880631626899LU, 9958038978953216000LU},
    {1775182137608563050LU, 4244260224908656640LU},
    {1319059266270039631LU, 15859191251858358272LU},
    {971547248194627361LU, 17799835987916881920LU},
    {546952907146543108LU, 1293719315777847296LU},
    {7238629668197518546LU, 10857316151898144768LU},
    {7969203664444468215LU, 8096735315487621120LU},
    {8191433061924373145LU, 6579744976685498368LU},
    {8881480193430316476LU, 13672503408668442624LU},
    {5748537120948342853LU, 966821361945149440LU},
    {4983905732978390880LU, 16977260746125606912LU},
    {6494190256267795982LU, 13873842632167260160LU},
    {5833133997509933355LU, 2772040358912065536LU},
    {11373881000040925091LU, 14859759925516566528LU},
    {10895526175395897478LU, 2939151497675407360LU},
    {9800170539042589160LU, 277926139723251712LU},
    {9434400173151334093LU, 16513268273723211776LU},
    {13144331498544995124LU, 6196462155320000512LU},
    {13584686121424583697LU, 12902759996944547840LU},
    {11795803149193729407LU, 10961019554599272448LU},
    {12204640236907541082LU, 9145917408387530752LU},
    {14608685639311441548LU, 17993017629706551296LU},
    {13857842024082987433LU, 2253352800845037568LU},
    {16097392963216404679LU, 3771507960547639296LU},
    {15387082809773561826LU, 15178987651874160640LU},
    {16216993219668582939LU, 7093788816112091136LU},
    {16997392856630150462LU, 9548683455538135040LU},
    {17642643483009444944LU, 12650945527509155840LU},
    {18319456995651029877LU, 5287403761294114816LU},
    {4599511809987618946LU, 14513054355608829952LU},
    {3834872572973338535LU, 3429830109421371392LU},
    {3030263064078739145LU, 327538728593522688LU},
    {2369214349422494188LU, 16319401168038002688LU},
    {1470021508851512341LU, 5957843835462615040LU},
    {2200601125054796592LU, 12997121600963739648LU},
    {125968206201879134LU, 11479006745234243584LU},
    {816009962564590971LU, 8771905458614042624LU},
    {7543776961198657965LU, 18367025988887379968LU},
    {7087657540874794632LU, 1735370781350690816LU},
    {9037025165063839718LU, 3677141151028084736LU},
    {8612427677943806147LU, 15417609596683943936LU},
    {4828648749528255802LU, 7287652949679931392LU},
    {5327271971794479647LU, 9499076656283779072LU},
    {6258835632188343153LU, 12160261091787538432LU},
    {6644869997645833300LU, 5634112337678958592LU},
    {10456235714885507804LU, 11993191064451153920LU},
    {11236631900849225209LU, 4648227050425942016LU},
    {9567076447384769687LU, 7751613106748391424LU},
    {10243893106081559474LU, 10187931076316364800LU},
    {13451739313230399051LU, 4446854755678945280LU},
    {12700896919911735662LU, 15800853505645740032LU},
    {12643638310680496128LU, 17317882499153526784LU},
    {11933327180141031205LU, 1631697494960242688LU},
    {14301282089377719283LU, 10519332732855648256LU},
    {14741644561318380758LU, 8578692326124158976LU},
    {15249553261831859640LU, 6638079166665195520LU},
    {15658382805427243677LU, 13469914152117993472LU},
    {17134634248393883492LU, 736923543685562368LU},
    {16656273803775711297LU, 17062901298791186432LU},
    {17875742105706606895LU, 14400550874155843584LU},
    {17509977114975327754LU, 2389307907540779008LU},
    {3069437435898547971LU, 8192280758522478592LU},
    {2338598300597659686LU, 10899095553644167168LU},
    {4558138398973624648LU, 13570417993162162176LU},
    {3867828396131378797LU, 6530854011040432128LU},
    {84154751591469972LU, 16894949016452726784LU},
    {848490489043039409LU, 902801047582408704LU},
    {1509811848208555487LU, 2852456590668201984LU},
    {2170565928106195706LU, 13935395582307729408LU},
    {9078284500806923820LU, 5061097283018293248LU},
    {8579357778977984777LU, 11586969578671964160LU},
    {7504575925282355303LU, 10078982968791007232LU},
    {7118246925066264386LU, 7867282528854343680LU},
    {6219089549382281915LU, 15995264452974870528LU},
    {6674949450608545182LU, 4254518586791428096LU},
    {4870558687491958000LU, 1160104545351630848LU},
    {5294887928132453333LU, 17791482057482829824LU},
    {9534235247227616605LU, 2209075274320969728LU},
    {10285345955749485176LU, 17895537011847069696LU},
    {10487053797910803222LU, 15225310192716480512LU},
    {11197624378832589875LU, 3871587901204594688LU},
    {12673770540608201162LU, 9614638944725499904LU},
    {11893669058126759663LU, 7178598670563016704LU},
    {13419408046524985217LU, 5227856286002970624LU},
    {12742894818675624100LU, 12573097720555765760LU},
    {15218849252466852978LU, 2964569882932281344LU},
    {15697504400567296855LU, 14976099066167951360LU},
    {14334149952020761145LU, 16485241907014795264LU},
    {14700218373599472924LU, 159550643407683584LU},
    {17908029118545402085LU, 12890003579003207680LU},
    {17467934961807949760LU, 6058453848098340864LU},
    {17104405537797232302LU, 9151702845299359744LU},
    {16695835444584165771LU, 11092628781456687104LU},
    {2764351918620086908LU, 1871514634679222272LU},
    {3220206474767988057LU, 18377354985802301440LU},
    {3712624985138125879LU, 15284064928713932800LU},
    {4136959875799694098LU, 3668857305870368768LU},
    {1003981888723128043LU, 9385164936658812928LU},
    {505062741060676046LU, 7264099018316185600LU},
    {1745087242086662304LU, 5754986242240413696LU},
    {1358750422890981253LU, 12190222899608551424LU},
    {8158461894983035731LU, 3347448294472155136LU},
    {8922798579483298934LU, 14448963938789883904LU},
    {7269296275242542360LU, 16399746764761989120LU},
    {7930049103148778045LU, 389021026521972736LU},
    {6524170527031408580LU, 13092737146454802432LU},
    {5793328215593832673LU, 5999693322484973568LU},
    {5716076366347598223LU, 8669890695319781376LU},
    {5025769784455143082LU, 11430186414621327360LU},
    {9841576886147440674LU, 8565865273150668800LU},
    {9401481782378039047LU, 10381253773421969408LU},
    {11334814399822278249LU, 13475629503753486336LU},
    {10926245558583806284LU, 6769618291066404864LU},
    {11756190881462549685LU, 17088390336260079616LU},
    {12234849205682871184LU, 853333319369097216LU},
    {13186389064198271742LU, 2361351643288567808LU},
    {13552454064843937243LU, 14282245463116611584LU},
    {16136415859055810829LU, 4714252642069512192LU},
    {15356319721669541416LU, 12078071004178415616LU},
    {14567182261513393990LU, 10128454253237239808LU},
    {13890663383626215523LU, 7673835934827151360LU},
    {17600700540503836058LU, 15756505893845336064LU},
    {18351803674842473151LU, 4349304035363258368LU},
    {16256631599861402577LU, 1677949400770412544LU},
    {16967209999779589364LU, 17417891787598462976LU},
  },
  // Table 3
  {
    {0LU, 0LU},
    {7359220222266371067LU, 4774161641937829888LU},
    {14718440444532742134LU, 9548323283875659776LU},
    {12277749743594191885LU, 14322378960380362752LU},
    {14542566867886052910LU, 13798192353820803072LU},
    {12677809186956410325LU, 18247526237637443584LU},
    {401933203376128472LU, 4323301328395698176LU},
    {7184024066115086883LU, 8772529521657118720LU},
    {14048552121589044638LU, 14448640076780929024LU},
    {11878042213788089957LU, 9998795057496326144LU},
    {1059502747243364968LU, 5476822350307524608LU},
    {7535982258037139859LU, 1027012377956057088LU},
    {803866406752256944LU, 8646602656791396352LU},
    {7856208431371806795LU, 3873058253193609216LU},
    {14368048132230173766LU, 17545059043314237440LU},
    {11620620108573294525LU, 12771549411771678720LU},
    {15328471652506604286LU, 2845763713066074112LU},
    {12869203113344760069LU, 7295573822856495104LU},
    {1800257168844309768LU, 11816418980871012352LU},
    {9140899415448235763LU, 16266263862716661760LU},
    {2119005494486729936LU, 10953644700615049216LU},
    {8883644418909105963LU, 15727154194718654464LU},
    {15071964516074279718LU, 2054024755912114176LU},
    {13189754759389165789LU, 6827569296948854784LU},
    {1607732813504513888LU, 17293205313582792704LU},
    {8101663145923439771LU, 12519149499639136256LU},
    {15712416862743613590LU, 7746116506387218432LU},
    {13559357914006567789LU, 2971955001888342016LU},
    {16113391274712338766LU, 5800856544501301248LU},
    {13384539972587322037LU, 1351628488678834176LU},
    {1431058809484625592LU, 15276980947094863872LU},
    {8501977693075057987LU, 10827646925839269888LU},
    {17880991682046401599LU, 17907915468371394560LU},
    {11387132853450569668LU, 13458031691301912576LU},
    {3775261859809774537LU, 8937331119066447872LU},
    {5928249375859154994LU, 4487553307430092800LU},
    {3600514337688619537LU, 5186093888032473088LU},
    {6329434873747431914LU, 412517323719573504LU},
    {18281798830896471527LU, 14085783651723771904LU},
    {11210810642773751324LU, 9312312777966092288LU},
    {4238010988973459873LU, 3460545327520546816LU},
    {6697208095178351194LU, 8234666012650242048LU},
    {17767288837818211927LU, 13007564315727757312LU},
    {10426718094769796524LU, 17781649953924317184LU},
    {17510526477161045903LU, 10338951321968705536LU},
    {10745818247938929780LU, 14788255244093489152LU},
    {4558633019780122745LU, 862756000875151360LU},
    {6440912010129613698LU, 5312025150944706560LU},
    {3215465627009027777LU, 16139666553456033792LU},
    {5385904101854078266LU, 11365580777820520448LU},
    {16203326291846879543LU, 6591554925568720896LU},
    {9726918284607566540LU, 1817434377877979136LU},
    {16523200672014571759LU, 6955418125319798784LU},
    {9470789342594233108LU, 2506149112689197056LU},
    {2957832436050906905LU, 16430519707221622784LU},
    {5705329693373211874LU, 11981215647657885696LU},
    {17179503370004208479LU, 1691238691009200128LU},
    {9820354651561980068LU, 6141016640084508672LU},
    {2462269227166846121LU, 10662845861005885440LU},
    {4902888495416682322LU, 15112729500636413952LU},
    {2862117618969251185LU, 12107217820480176128LU},
    {4726944533831640714LU, 16880688556798902272LU},
    {17003955386150115975LU, 3208549777968988160LU},
    {10221795218879918460LU, 7982126479720841216LU},
    {11608391796075463100LU, 5148327188331757568LU},
    {14355356958623394375LU, 374839959338614784LU},
    {7879941794144638538LU, 14119063270241337344LU},
    {827007028603927985LU, 9345470075815067648LU},
    {7550523719619549074LU, 17874662238132895744LU},
    {1074647944862071913LU, 13424865597359915008LU},
    {11856498751718309988LU, 8975106614860185600LU},
    {14027460525513157535LU, 4525204283531984896LU},
    {7201028675377239074LU, 10372187776064946176LU},
    {418274702974123993LU, 14821438096997875712LU},
    {12658869747494863828LU, 825034647439147008LU},
    {14523094198570199087LU, 5274320015305211904LU},
    {12267421557956379148LU, 3498293069235617792LU},
    {14708634493631818231LU, 8272362352196714496LU},
    {7384994586825348602LU, 12974336657724538880LU},
    {26448469340634625LU, 17748440712740864000LU},
    {8476021977946919746LU, 6921090655041093632LU},
    {1405636390781253817LU, 2471805424613982208LU},
    {13394416190356702388LU, 16469332025300484096LU},
    {16123930393840529231LU, 12020081566928601088LU},
    {13578760316536784236LU, 16100827847098105856LU},
    {15731145368799702679LU, 11326723654642827264LU},
    {8084828892197900954LU, 6625873599754403840LU},
    {1590376258469607777LU, 1851804454232260608LU},
    {13210916622074513116LU, 12146004583503626240LU},
    {15093718911373339943LU, 16919597640490942464LU},
    {8868991975241797930LU, 3174250078948818944LU},
    {2104815978500930257LU, 7947737445380915200LU},
    {9117266039560245490LU, 1725512001750302720LU},
    {1776171860392049417LU, 6175414470517456896LU},
    {12881824020259227396LU, 10624050301889413120LU},
    {15340489031690202367LU, 15073846805223440384LU},
    {6430931254018055555LU, 13832589033202515968LU},
    {4548198198652106360LU, 18281800596350566400LU},
    {10771808203708156533LU, 4284417481931489280LU},
    {17535914895917654414LU, 8733735010512666624LU},
    {10443515908830956461LU, 38910234743275520LU},
    {17784681591823163478LU, 4812947356989259776LU},
    {6677912430013537371LU, 9513935400586969088LU},
    {4219175985893980064LU, 14288078213388173312LU},
    {11225567730009901085LU, 8607746581585723392LU},
    {18295884012374909926LU, 3834218395784445952LU},
    {6308238806928187371LU, 17579430167640539136LU},
    {3578793837109654544LU, 12805866934906126336LU},
    {5915664872101813811LU, 14414295340733693952LU},
    {3763208386882860488LU, 9964468738268856320LU},
    {11410659386746423749LU, 5515687221606219776LU},
    {17905183524029309502LU, 1065825847086153728LU},
    {10198095856230010749LU, 10991339957829763072LU},
    {16980780523833517190LU, 15764903053125222400LU},
    {4739068548505458827LU, 2020814432396902400LU},
    {2874913331094369136LU, 6794342755637133312LU},
    {4924538454333692243LU, 2878947648302219264LU},
    {2483254085701169832LU, 7328809160261238784LU},
    {9805776990833364645LU, 11778714927563276288LU},
    {17164394611873719646LU, 16228541392589160448LU},
    {5724235237938502371LU, 5767691567250800640LU},
    {2977339309324497176LU, 1318374176108576768LU},
    {9453889067663281429LU, 15314633039888252928LU},
    {16506754528671573742LU, 10865421339301249024LU},
    {9701037386694102221LU, 17255526832510337024LU},
    {16176984665274541878LU, 12481383882270179328LU},
    {5396268381411367739LU, 7779272687544696832LU},
    {3225235174928986304LU, 3005235702737666048LU},
    {1398307331414637243LU, 4079413182450368512LU},
    {8450717551524434240LU, 8853450235976876032LU},
    {16079449916754554189LU, 13555423510712549376LU},
    {13331953749146994358LU, 18329566254794276864LU},
    {15759883588289277077LU, 9791382466773123072LU},
    {13589446205304424302LU, 14240593961201696768LU},
    {1654014057207855971LU, 244196077920583680LU},
    {8130420957286142104LU, 4693513537782284288LU},
    {15101047439239098149LU, 17302580402556239872LU},
    {13236221614357857502LU, 12852753868810878976LU},
    {2149295889724143827LU, 8402987121010278400LU},
    {8931454947954266920LU, 3953125815209689088LU},
    {1747433107253737739LU, 5720165138485477376LU},
    {9106580718801343216LU, 946637021403676672LU},
    {15276850664941055741LU, 14690863562121805824LU},
    {12836232488821884166LU, 9917300398106869760LU},
    {14402057350754478149LU, 2297631478420340736LU},
    {11673137921858782142LU, 6747492921659883520LU},
    {836549405948247987LU, 11196132120286199808LU},
    {7907536502208664648LU, 15645958516592607232LU},
    {1013293830703726187LU, 11574204308803026944LU},
    {7507151569586902416LU, 16347767335379009536LU},
    {14001012587675609501LU, 2602412145974968320LU},
    {11848026180934664806LU, 7375940400495722496LU},
    {371574878851448283LU, 15519740976930226176LU},
    {7136282015944988192LU, 10745598095409545216LU},
    {14513552354877106733LU, 6044753469359783936LU},
    {12631274471420133846LU, 1270716553272229888LU},
    {14769989173650697205LU, 7501929241739526144LU},
    {12310793176487968782LU, 3052611919316779008LU},
    {52896938681269251LU, 17050137351772176384LU},
    {7393466591746430968LU, 12600925719904649216LU},
    {16952043955893839492LU, 13842181310082187264LU},
    {10187408320207441279LU, 9392384738028683264LU},
    {2811272781562507634LU, 4943610849227964416LU},
    {4693479229915863689LU, 493708586619240448LU},
    {2490580398571696298LU, 9179541410267791360LU},
    {4949845631547235153LU, 4406054249994125312LU},
    {17208876736213116764LU, 18151262654595858432LU},
    {9868237780494683303LU, 13377669528889065472LU},
    {3006075311402791706LU, 620000351906430976LU},
    {5734923305462454497LU, 5394069566148050944LU},
    {16570394546700149996LU, 10095058777976864768LU},
    {9499478952116162327LU, 14869162764273713152LU},
    {16169657784395801908LU, 13251747199508807680LU},
    {9675730743128772303LU, 17700997451722260480LU},
    {3180752516939215554LU, 3703608908464521216LU},
    {5333808159760423225LU, 8152894207611109376LU},
    {4609550665554932858LU, 16674403437940572160LU},
    {6474305055601188737LU, 11900299314204770304LU},
    {17562365580253389708LU, 7198182553201672192LU},
    {10780278023698647159LU, 2424113476399005696LU},
    {17737983950483595860LU, 6348500157897637888LU},
    {10378767036551088559LU, 1899214996190003200LU},
    {4209631957001860514LU, 15895474890761830400LU},
    {6650319369202343513LU, 11446224501109424128LU},
    {18234532079120490980LU, 3451024003500605440LU},
    {11182193360418884127LU, 7900926403548282880LU},
    {3552343720784098834LU, 12350828941034913792LU},
    {6299768453286993385LU, 16800625375649464320LU},
    {3809906559724009418LU, 10419507488054312960LU},
    {5980413178520624177LU, 15193100476322152448LU},
    {17914728118784516156LU, 1449019620894703616LU},
    {11438251916054006727LU, 6222506918607323136LU},
    {12861862508036111111LU, 9218433992695480320LU},
    {15303143587662188796LU, 4444857497102057472LU},
    {9096396397304212721LU, 18116857118991581184LU},
    {1737782084329211658LU, 13343386313953378304LU},
    {8912360099479989545LU, 13876560457407397888LU},
    {2129678737792321234LU, 9426676749057392640LU},
    {13253381014325263071LU, 4904709470707253248LU},
    {15117532940584456484LU, 454931727790374912LU},
    {8109004317094588057LU, 13217384828325855232LU},
    {1633060346845906274LU, 17666688681731162112LU},
    {13603861463651711343LU, 3742456144627499008LU},
    {15774891381398114964LU, 8191725225977577472LU},
    {13355824860027074743LU, 581126727464386560LU},
    {16102717497755587404LU, 5355247343874605056LU},
    {8438351971787960129LU, 10129412353066795008LU},
    {1385489816965973178LU, 14903497922543878144LU},
    {7405932158199867897LU, 6381701711089631232LU},
    {64769766361645570LU, 1932432767178506240LU},
    {12287314659856940559LU, 15857788455409942528LU},
    {14746047798058554868LU, 11408484464565682176LU},
    {12616477613856374743LU, 16712116261571526656LU},
    {14499207361159058476LU, 11938030554655490048LU},
    {7157587674219309089LU, 7164989796102701056LU},
    {393484271014151130LU, 2390869317131436032LU},
    {11831329744203627623LU, 10381846607757836288LU},
    {13983782923238365084LU, 15155317275357085696LU},
    {7526416773765720977LU, 1482193402828161024LU},
    {1031895927366221930LU, 6255770035860537344LU},
    {7917539472969017929LU, 3417876609846214656LU},
    {847226479342076338LU, 7867654490202046464LU},
    {11647055934608276927LU, 12388498617424412672LU},
    {14376497596092945988LU, 16838382188335464448LU},
    {5357182376252221240LU, 9758111670118383616LU},
    {3204798433029377219LU, 14207445485215547392LU},
    {9663299174483030222LU, 281954007298080768LU},
    {16157750718230174517LU, 4731182131840024576LU},
    {9478137097010917654LU, 4041628864793804800LU},
    {16548521592045918957LU, 8815790438012157952LU},
    {5749826662188738272LU, 13588685511274266624LU},
    {3020313565599534363LU, 18362741119059492864LU},
    {9849076908667384486LU, 5757895296604438528LU},
    {17190169998120835421LU, 984350961726128128LU},
    {4966508171402339664LU, 14657618320522477568LU},
    {2507844269281906347LU, 9884108757699395584LU},
    {4719597313065591944LU, 17335799255876501504LU},
    {2836796130927791987LU, 12885954305311375360LU},
    {10177298818072343422LU, 8365248166798295040LU},
    {16941473722953013381LU, 3915438263166304256LU},
    {11448470475877004742LU, 11535383134501601280LU},
    {17924345143741963837LU, 16308892559885729792LU},
    {5954678618648994352LU, 2636748352217153536LU},
    {3783717936982723019LU, 7410292824534417408LU},
    {6282715793000276968LU, 2263321660457222144LU},
    {3535751720435599379LU, 6713131701528166400LU},
    {11201251771544073246LU, 11234962090680647680LU},
    {18254185428042620901LU, 15684806903806820352LU},
    {6635869904741474392LU, 7536220101717000192LU},
    {4194658060928338851LU, 3086992114614009856LU},
    {10400288318331811758LU, 17011359341892075520LU},
    {17758833328653409365LU, 12562025389355958272LU},
    {10792536762822735478LU, 15558545375089393664LU},
    {17575289625917414797LU, 10784489629865213952LU},
    {6450470349857972608LU, 6010471405475332096LU},
    {4586246988495293051LU, 1236309969695932416LU},
  },
  // Table 4
  {
    {0LU, 0LU},
    {2796614662829274486LU, 8158826364900737024LU},
    {5593229325658548972LU, 16317652729801474048LU},
    {7732881049280749466LU, 10613308588682117120LU},
    {11186458651317097945LU, 14188561385893396480LU},
    {13686961432553300143LU, 13104942966768664576LU},
    {15465762098561498933LU, 2779873103654682624LU},
    {17325064676591225411LU, 6317968111563702272LU},
    {7433698125706859120LU, 4590899643730100224LU},
    {4748587554077992710LU, 5660989259469815808LU},
    {3077903996717004956LU, 15980412305741447168LU},
    {898885215680990698LU, 12464887385332645888LU},
    {18165134753247217577LU, 18109470595581214720LU},
    {15769380377618100959LU, 9973286061314408448LU},
    {12792652584721296709LU, 1811064129629192192LU},
    {10900738085115254835LU, 7501809923253075968LU},
    {14867396251413718240LU, 9181799287460200448LU},
    {16761280886760755606LU, 1032930237299556352LU},
    {9497175108155985420LU, 11321978518939631616LU},
    {11890396123246345082LU, 17016365345318895616LU},
    {6155807993434009913LU, 13514080537773342720LU},
    {8332293688809129039LU, 14605826684289548288LU},
    {1797770431361981397LU, 6483030696955740160LU},
    {4484851413609770659LU, 2936807961655246848LU},
    {12212169074293323408LU, 4673165387188142080LU},
    {10355399685305648102LU, 3594877950190682112LU},
    {16493716195408567420LU, 11721068404797341696LU},
    {13991242900239362314LU, 15244791146463887360LU},
    {3622054970005283657LU, 9528928796409856000LU},
    {1480433007327974975LU, 17655367397047009280LU},
    {9213023029606910373LU, 7371967031760912384LU},
    {6418941830697647315LU, 1690967171766681600LU},
    {14840038681006796803LU, 5233595818304339968LU},
    {16950980249496126837LU, 4150224222360174592LU},
    {9254137343086664431LU, 12309047099747467264LU},
    {12007404567006146457LU, 15846896349627809792LU},
    {6254409519274567130LU, 10107927779895934976LU},
    {8071491108128477356LU, 18266436918512189440LU},
    {1968922126207569718LU, 7941359582155112448LU},
    {4439588302585346624LU, 2237331533448871936LU},
    {12311615986868019827LU, 8581417001837133824LU},
    {10093753916914112261LU, 445478225599004672LU},
    {16664587377618258079LU, 10764909294869544960LU},
    {13946262500874092009LU, 16455408265312862208LU},
    {3595540862723962794LU, 12966061393911480320LU},
    {1669286707914490588LU, 14035834917238079488LU},
    {8969702827219541318LU, 5873615923310493696LU},
    {6536230512752240688LU, 2358408229186174976LU},
    {261756968116049123LU, 4020934247777828864LU},
    {2697199487043772821LU, 5112926152322711552LU},
    {5638180164038213135LU, 15401968575627395072LU},
    {7561900889589468025LU, 11855499017146335232LU},
    {10997713653332148538LU, 17522062547165904896LU},
    {13713505375696057420LU, 9372877404592144384LU},
    {15348441404841880534LU, 1250080644164222976LU},
    {17568273954134105760LU, 6944784696827969536LU},
    {7244109940010567315LU, 611113519110160384LU},
    {4775976883955348453LU, 8737798942927880192LU},
    {2960866014655949951LU, 16863990720384466944LU},
    {1141813980588562697LU, 11182745102361559040LU},
    {18426046059213820746LU, 14743934063521824768LU},
    {15670808664958789180LU, 13665329400239882240LU},
    {12837883661395294630LU, 3381934343533363200LU},
    {10729475488106384592LU, 6905973177613025280LU},
    {14605610833433319877LU, 2826856906251829248LU},
    {17041092797877562547LU, 6197791168525238272LU},
    {9740909706302403369LU, 14215878120925298688LU},
    {11664670426052249183LU, 13002183009468678144LU},
    {5877133143705259036LU, 16419251267815079936LU},
    {8592964035634035050LU, 10584900940546965504LU},
    {2022363740096620272LU, 121338516943667200LU},
    {4242236009783268230LU, 8112933355147755520LU},
    {12508819038549134261LU, 1769111486082318336LU},
    {10040725426936692419LU, 7616955707241267200LU},
    {16142982216256954713LU, 18086129763314827264LU},
    {14323970177461900335LU, 10072070115848880128LU},
    {3937844252415139436LU, 15882719164310224896LU},
    {1182646028798716698LU, 12489389636885413888LU},
    {8879176605170693248LU, 4474663066897743872LU},
    {6770808151202464246LU, 5701780329111486464LU},
    {351869790838521125LU, 6365643111837728768LU},
    {2462771365129259091LU, 2985525865888088064LU},
    {5295445748743280585LU, 13413052414366318592LU},
    {8048673527146242751LU, 14635930509499170816LU},
    {11519186856252483836LU, 11290713137004675072LU},
    {13336228724711972234LU, 17116302693061623808LU},
    {15151088836625023504LU, 9134242819693608960LU},
    {17621715843437934438LU, 1151408752700686336LU},
    {7191081725447925589LU, 7485378714113409024LU},
    {4973179660221684259LU, 1646225170299355136LU},
    {3338573415828981177LU, 9624925760766607360LU},
    {620209094642036943LU, 17630294730887659520LU},
    {17939405654439082636LU, 11747231846620987392LU},
    {16013111780308930554LU, 15149955738832470016LU},
    {13072461025504481376LU, 4716816458372349952LU},
    {10638949540398572822LU, 3480304831371935744LU},
    {523513936232098246LU, 8041868495555657728LU},
    {2417438016021912752LU, 2207763891956482048LU},
    {5394398974087545642LU, 10225852304645423104LU},
    {7787659984450238044LU, 18217200285309206528LU},
    {11276360328076426271LU, 12357193077545238528LU},
    {13452885194090154345LU, 15727811213045792768LU},
    {15123801779178936051LU, 5264253960583118848LU},
    {17810922480747406213LU, 4050876041051242496LU},
    {6947409535659817910LU, 5777082775236509696LU},
    {5090679592188661440LU, 2384000105352003584LU},
    {3311566596140880218LU, 12853168440529125376LU},
    {809133295170266156LU, 14080039979073929216LU},
    {18110206611584970351LU, 10721864844866224128LU},
    {15968623818472528665LU, 16569391874100428800LU},
    {13171696963044705411LU, 8554664393579692032LU},
    {10377655484529865205LU, 540920872886599680LU},
    {14488219880021134630LU, 1222227038220320768LU},
    {17284794547578075216LU, 7048063451817574400LU},
    {9551953767910696906LU, 17475597885855760384LU},
    {11691566047090119356LU, 9492518095193899008LU},
    {5921732029311899903LU, 15281237367059382272LU},
    {8422195091227422089LU, 11900802929184997376LU},
    {2283627961177125395LU, 3918746131013566464LU},
    {4142891368568244069LU, 5141940352919273472LU},
    {12554261386745028438LU, 3404756378110132224LU},
    {9869110820917570080LU, 6807725993990553600LU},
    {16403964000556807610LU, 14786422959505408000LU},
    {14224905774004273356LU, 13549664474964688896LU},
    {3821298686274488975LU, 16980816394931142656LU},
    {1425504590250950649LU, 11141346724344233984LU},
    {8689940153606742115LU, 708200108079972352LU},
    {6797986484435834133LU, 8713886270125768704LU},
    {14138567134255155785LU, 17874763784044675072LU},
    {16355338618784251711LU, 9887111674278707200LU},
    {9919569097700827301LU, 1908427009550188544LU},
    {12639055203529659859LU, 7729831841531691008LU},
    {6847739974261104528LU, 4388775003856830464LU},
    {8775155083341277926LU, 5607534345611902976LU},
    {1339587063460115836LU, 16040692850345639936LU},
    {3771968517552324618LU, 12655682794832265216LU},
    {11754266287410518073LU, 14391758461920608256LU},
    {9642234146644454735LU, 13150569495275765760LU},
    {17185928071268070101LU, 2723057807384379392LU},
    {14433822063276754851LU, 6121456203672322048LU},
    {4044727480193240544LU, 242677033887334400LU},
    {2228806832459856022LU, 8243786478782513152LU},
    {8484472019566536460LU, 16225866710295511040LU},
    {6012714995972264570LU, 10381961060046340096LU},
    {749248972836023977LU, 9755825089659535360LU},
    {3218472635891571679LU, 17751604651939069952LU},
    {5186732349502211141LU, 7282414670126776320LU},
    {7004623132976558387LU, 1452882385631707136LU},
    {10474129354801445744LU, 4865086421716697088LU},
    {13228205773411585542LU, 3656284119823810560LU},
    {15908034709180027292LU, 11670991465537863680LU},
    {18017533764285293802LU, 15046044481189052416LU},
    {7875688504830278873LU, 13318694254910898176LU},
    {5441336536805099951LU, 14550137013048180736LU},
    {2365292057597433397LU, 6532035200061276160LU},
    {440410137559278403LU, 3143383012280893440LU},
    {17758353210341386496LU, 8949326133795487744LU},
    {15041400568432467062LU, 940018592764657664LU},
    {13541616302404928492LU, 11403560658222972928LU},
    {11322874578820822682LU, 17255664404607795200LU},
    {703739581677042250LU, 12731286223675457536LU},
    {3390011348362170172LU, 13949728339146047488LU},
    {4925542730258518182LU, 5971051731776176128LU},
    {7103470959889704400LU, 2586357768675917824LU},
    {10590891497486561171LU, 8379360755023085568LU},
    {12985555046903208677LU, 391955468437684224LU},
    {16097347054292485503LU, 10825116945288790016LU},
    {17990422474015027209LU, 16646276019241615360LU},
    {7993293835226802234LU, 10311197750108094464LU},
    {5197840423562059084LU, 18311991102590156800LU},
    {2554321691051262678LU, 7884475892825587712LU},
    {413579359924385696LU, 2040887468860899328LU},
    {17713689481331785187LU, 5476199923646988288LU},
    {15212095817776941205LU, 4235256715030822912LU},
    {13280146444866967311LU, 12217329438940987392LU},
    {11422004843051491961LU, 15615481012048363520LU},
    {14382163450895851178LU, 14970757428226818048LU},
    {16237771623453076444LU, 13761639033920815104LU},
    {9946359320443368518LU, 3292450340598710272LU},
    {12449923188458668336LU, 6667820582534381568LU},
    {6677146831657962355LU, 803107447823663104LU},
    {8819859642123255301LU, 8799132768131874816LU},
    {1240418189284073887LU, 16813845388065767424LU},
    {4033338446568461545LU, 10984066280390131712LU},
    {11582827758073302234LU, 17326744657362681856LU},
    {9687781893137250732LU, 9317119890047369216LU},
    {17087039709727860278LU, 1299012253084811264LU},
    {14694909280633803584LU, 7151432091882749952LU},
    {4287480333708269827LU, 3788392735413633024LU},
    {2112085499277601909LU, 5020082316731482112LU},
    {8511544679627191279LU, 15483623643455422464LU},
    {5823302742606415513LU, 12094725697646362624LU},
    {1047027872464196492LU, 16083736991111315456LU},
    {2902667243126990586LU, 12541699014246006784LU},
    {4834876032043825504LU, 4415527783912964096LU},
    {7338470549482621974LU, 5512092007561953280LU},
    {10788797948175091285LU, 2004960535581294592LU},
    {12931541682941784867LU, 7704240205884030976LU},
    {15575319968900476089LU, 17987656496908861440LU},
    {18368270599656708559LU, 9842906234485735424LU},
    {7615032000752632316LU, 16177720904296431616LU},
    {5720017334995891338LU, 10501046505866002432LU},
    {2607904338915044112LU, 212018582370910208LU},
    {215804558170742374LU, 8343134488292753408LU},
    {17478557693048132645LU, 2622548653465665536LU},
    {15303193781845123411LU, 6151023467207589888LU},
    {13767341273816170185LU, 14273834315128242176LU},
    {11079129711340981183LU, 13199806368996917248LU},
    {13894819071319635820LU, 11554165550473019392LU},
    {16581060188581265946LU, 15087442481249255424LU},
    {10181359184377322880LU, 4768000210704007168LU},
    {12359256215902939382LU, 3680197033144090624LU},
    {6623133192281760437LU, 7259592807348699136LU},
    {9017766368226564035LU, 1551129878491824128LU},
    {1618266590340532313LU, 9713335884438306816LU},
    {3511311085761674543LU, 17867269405415571456LU},
    {12105004394092356892LU, 11524292244748107776LU},
    {9309520334077857898LU, 17210360733087301632LU},
    {16889265183388995568LU, 9051514010041581568LU},
    {14748491653082806918LU, 911004014210973696LU},
    {4378578023435415749LU, 6559888496767533056LU},
    {1876953985334986163LU, 3040104085492596736LU},
    {8168669822257715753LU, 13365159088019734528LU},
    {6310497297214582623LU, 14430496631684071424LU},
    {14084342357509940111LU, 10922810464677134336LU},
    {16553597219744798457LU, 16621774008207015936LU},
    {10298191586083916131LU, 8495597091337273344LU},
    {12116113017908018197LU, 351164020838891520LU},
    {6362436319402522198LU, 6013004066085404672LU},
    {9116543661240320800LU, 2471211812889034752LU},
    {1573109152625663162LU, 12754627227740536832LU},
    {3682638582276516300LU, 13850944593849221120LU},
    {11843464058623799807LU, 12115730660409212928LU},
    {9409143288704189577LU, 15643888282226393088LU},
    {16844390182454844179LU, 5354861784660443136LU},
    {14919538911840185957LU, 4281149965301972992LU},
    {4567255922354250790LU, 7837492262027132928LU},
    {1850334204746731856LU, 2161064721137008640LU},
    {8285782737136488138LU, 10283880705838546944LU},
    {6067071387024227260LU, 18414750888091451392LU},
    {947507298381793135LU, 16787682118040813568LU},
    {3164248134561133081LU, 11078901997259194368LU},
    {4663790439295348099LU, 759456067401809920LU},
    {7383245345944869109LU, 8913705715151929344LU},
    {10815517658359452342LU, 3179038417728045056LU},
    {12742902392894040000LU, 6712562206044585984LU},
    {15818705048245254234LU, 14874760841827188736LU},
    {18251055579109805356LU, 13786711940598333440LU},
    {7642597372548977951LU, 15514888716152733696LU},
    {5530534582359416937LU, 11994788178104942592LU},
    {2851009180501901299LU, 3835949374978916352LU},
    {98871974405016197LU, 4901604110567997440LU},
    {17379880307213484230LU, 1416400216159944704LU},
    {15563929286008255920LU, 7102714428168077312LU},
    {13595972968871668266LU, 17427772540251537408LU},
    {11124185020975996764LU, 9287015686880624640LU},
  },
  // Table 5
  {
    {0LU, 0LU},
    {15652774512755748176LU, 5072805651629998080LU},
    {16368045087814148963LU, 4230462852923654144LU},
    {4188111489856785971LU, 8994715743316606976LU},
    {10887636967042318085LU, 14056529577203728384LU},
    {5629916653416338005LU, 9616569420855902208LU},
    {8376222979713571942LU, 17989431486633213952LU},
    {12468076029305598262LU, 13817454311480754176LU},
    {9179476188595406792LU, 3484742043689811968LU},
    {11987983565376383640LU, 8519248844876152832LU},
    {11259833306832676011LU, 786394768002252800LU},
    {5006636919560833531LU, 5516887815289307136LU},
    {16752445959427143885LU, 17532118899556876288LU},
    {3550375458724713885LU, 13053860116103692288LU},
    {818070317773118382LU, 14554234098315952128LU},
    {15160116774108690174LU, 10348496856719294464LU},
    {18358952377190813584LU, 6969484087379623936LU},
    {2878304382676214464LU, 2800866263847403520LU},
    {2156911564743568627LU, 6488855106400813056LU},
    {14183859286473490851LU, 2047786023856898048LU},
    {7624789642448105621LU, 11793317700405559296LU},
    {12747828749427957189LU, 16558748648788197376LU},
    {10013273839121667062LU, 11033775630578614272LU},
    {6039213841170513574LU, 16103150050015707136LU},
    {9343866552722081880LU, 5829028695284645888LU},
    {6383226177145758984LU, 1622113258259349504LU},
    {7100750917449427771LU, 7660976158497832960LU},
    {13525220258335557227LU, 3186148194920693760LU},
    {1636140635546236765LU, 10661724122922352640LU},
    {14955731165406337549LU, 15388857406272307200LU},
    {17695284451294958654LU, 12196752843331338240LU},
    {3218829123601693038LU, 17232368433274814464LU},
    {12449479225575352035LU, 8577322656758497280LU},
    {8501877016308353971LU, 3562061835953766400LU},
    {5756608765352428928LU, 5601732527694807040LU},
    {10870077963775469776LU, 854386312206090240LU},
    {4313823129487137254LU, 12977710212801626112LU},
    {16349214791416018102LU, 17472892825258426368LU},
    {15635157665952086661LU, 10281587257726992384LU},
    {126925913858545621LU, 14468289882872610816LU},
    {15249579284896211243LU, 5139891327101566976LU},
    {763554667123494011LU, 86331673033048064LU},
    {3496932795058061896LU, 9070549141888696320LU},
    {16842981732075548440LU, 4289443066114211840LU},
    {4952213233815723566LU, 9531407653964611584LU},
    {11349098336088699774LU, 13988291622136184832LU},
    {12078427682341027149LU, 13759556026321862656LU},
    {9126230765925191709LU, 17912498602203152384LU},
    {5912512246482970995LU, 1706953701467357184LU},
    {10030824734026597411LU, 5897015678233214976LU},
    {12766452354291517968LU, 3244226516518699008LU},
    {7499161582352918336LU, 7738300202779410432LU},
    {14201501834898855542LU, 15321952316995665920LU},
    {2030012726896261926LU, 10575784159496634368LU},
    {2752584359806055701LU, 17156214260775256064LU},
    {18377773465715415109LU, 12137522207777619968LU},
    {3272281271092473531LU, 2876704172135153664LU},
    {17604756788081148907LU, 7028468552587804672LU},
    {14866241854560275928LU, 2114867430130974720LU},
    {1690630310771040392LU, 6575182218178592768LU},
    {13434750440824017342LU, 16500846094431813632LU},
    {7153969265183210734LU, 11716380254720229376LU},
    {6437658247203386077LU, 16017992792840077312LU},
    {9254610732412297101LU, 10965541927528693760LU},
    {639373136172774405LU, 6370455133066625024LU},
    {15124865485094082901LU, 2165772838517080064LU},
    {17003754032616707942LU, 7124123671907532800LU},
    {3657111254090398262LU, 2646921828366286848LU},
    {11513217530704857856LU, 11203465055389614080LU},
    {5115800163871270480LU, 15932765441798176768LU},
    {8998702302261667939LU, 11659585862055755776LU},
    {11950305381467800883LU, 16692893611452268544LU},
    {8627646258974274509LU, 7508676351893700608LU},
    {12574716409843261085LU, 3337752818118295552LU},
    {10708843885248827566LU, 5945229593823674368LU},
    {5594781055770361342LU, 1506325484034588672LU},
    {16186824011615063240LU, 12332824390885441536LU},
    {4150900286989033880LU, 17095883727046705152LU},
    {253851827717091243LU, 10489835692035670016LU},
    {15761489944464392955LU, 15561440986205782016LU},
    {17732813101080050581LU, 4094040251922644992LU},
    {3399734950790747845LU, 9130707627817304064LU},
    {1527109334246988022LU, 172663346066096128LU},
    {14702197409566537126LU, 4900855081156476928LU},
    {6993865590116123792LU, 18141098283777392640LU},
    {13274044128157182400LU, 13665074773103738880LU},
    {9379249782592006131LU, 13940821500392112128LU},
    {6561773824622611107LU, 9732708248527568896LU},
    {9904426467631447133LU, 616071234219671552LU},
    {5785511548650656013LU, 5686498607839051776LU},
    {7662150378357219134LU, 3618965604255399936LU},
    {12928917883689595502LU, 8385456035170615296LU},
    {2191915220452098904LU, 14672281918691606528LU},
    {14362801901308341768LU, 10230018319843328000LU},
    {18252461531850383419LU, 17378253130696753152LU},
    {2626749163633937771LU, 13208438660556390400LU},
    {11825024492965941990LU, 3413907402934714368LU},
    {9017119474613977014LU, 7567907124886372352LU},
    {5133003336873292165LU, 1573230985628090368LU},
    {11386722917730622677LU, 6031169694688346112LU},
    {3675576374391778787LU, 17037805268009746432LU},
    {16878249237813952691LU, 12255499934287003648LU},
    {14998323164705836672LU, 15476600405558820864LU},
    {656799906254939088LU, 10421848296770240512LU},
    {15816327338907768110LU, 2250929958253756416LU},
    {164155532473383038LU, 6438688423799685120LU},
    {4060025453792523853LU, 2704824245283717120LU},
    {16240482593227725597LU, 7201060705276002304LU},
    {5505168719612111403LU, 15865684447840960512LU},
    {10763491735260252027LU, 11117138081050787840LU},
    {12628290723115895112LU, 16617056115481378816LU},
    {8536961210710959128LU, 11600601534286528512LU},
    {6544562542184947062LU, 5753408344270307328LU},
    {9505734911741063206LU, 702015861979873280LU},
    {13399350992084909589LU, 8461606075911634944LU},
    {6975475217823404869LU, 3678192090870710272LU},
    {14828766804892263027LU, 10145173195120967680LU},
    {1509708264712769315LU, 14604290237048815616LU},
    {3381260621542080784LU, 13150364436357185536LU},
    {17858309511569239104LU, 17300933200993845248LU},
    {2717632105191316158LU, 9188605500659335168LU},
    {18198812432988125166LU, 4170972998913753088LU},
    {14307938530366421469LU, 4986016435730907136LU},
    {2281584714563540109LU, 240901163694686208LU},
    {12875316494406772155LU, 13589241511970603008LU},
    {7752809724999878891LU, 18082118482903695360LU},
    {5875133092681385688LU, 9665622710494953472LU},
    {9849787000858782600LU, 13854490239675924480LU},
    {1278746272345548810LU, 12740910266133250048LU},
    {14449473439739331930LU, 17777668978802425856LU},
    {17481283514434292585LU, 9972467036820865024LU},
    {3143562843797300793LU, 14700708172625084416LU},
    {9702913962935654159LU, 8341261684983201792LU},
    {6890084854636821087LU, 3865254589674553344LU},
    {7314222508180796524LU, 5293843656732573696LU},
    {13598766283478817084LU, 1085854726991380480LU},
    {7987987163593584578LU, 9262923733553643520LU},
    {13250394379475485330LU, 14333477473700806656LU},
    {10231600327742540961LU, 13418786809886801920LU},
    {6108043506889351665LU, 18185291611762589696LU},
    {17997404604523335879LU, 4872427650401959936LU},
    {2376338604941114775LU, 430215805909598208LU},
    {1938054630481769380LU, 8731292956532670464LU},
    {14113306067558637300LU, 4561567469524746240LU},
    {17255292517948549018LU, 15017352703787401216LU},
    {3913292053611498186LU, 10812689040805986304LU},
    {887744959287526649LU, 16923899806152130560LU},
    {15377598284854077865LU, 12446820068531109888LU},
    {8678354282781644959LU, 1403585506922463232LU},
    {11625591918572385743LU, 6132970615855906816LU},
    {11189562111540722684LU, 3012650968069177344LU},
    {4787497963756050092LU, 8046014732429164544LU},
    {10381661262850662482LU, 16155556270298890240LU},
    {5272240266525117698LU, 11984686672722788352LU},
    {8301800573978067761LU, 15745023380383858688LU},
    {12253231220455960161LU, 11306206071883825152LU},
    {507703655434182487LU, 2532927310361788416LU},
    {16010976947241382407LU, 7296106433160937472LU},
    {16441872039283735604LU, 1842918330105593856LU},
    {4401302152181911908LU, 6914544575126175744LU},
    {13653343489063440105LU, 14400272869512708096LU},
    {7224821552328270777LU, 9348965109747154944LU},
    {6799469901581495690LU, 18261415255634608128LU},
    {9756277446195380442LU, 13478057285557157888LU},
    {3054218668493976044LU, 345326692132192256LU},
    {17535628054132104380LU, 4804462365628170240LU},
    {14502780451704165007LU, 4503396496892231680LU},
    {1188363744675528671LU, 8654087367449116672LU},
    {13987731180232247585LU, 17835452493845233664LU},
    {1956730583480411249LU, 12817939778737537024LU},
    {2393836017839467074LU, 14785843147510382592LU},
    {17870650902218753810LU, 10040748826324631552LU},
    {6126812247278876196LU, 3789377356666241024LU},
    {10105827132103580532LU, 8282308263798636544LU},
    {13123547649245222215LU, 1018672423345586176LU},
    {8005683194025523223LU, 5207626753815609344LU},
    {4878087216263414137LU, 12060814877850075136LU},
    {11136171553343499305LU, 16214831015166738432LU},
    {11571023097301312026LU, 11372997215678103552LU},
    {8767764447581441866LU, 15831060246861709312LU},
    {15324300756714438268LU, 7237931208510799872LU},
    {978135596393206572LU, 2455717211562573824LU},
    {4002609428855250207LU, 6829660022604038144LU},
    {17200922002824884303LU, 1774957314529296384LU},
    {4383830440904197809LU, 10897819763673661440LU},
    {16568652817598491617LU, 15085629983575506944LU},
    {16136543451328996818LU, 12504608144829186048LU},
    {489018494563043458LU, 17000933587953909760LU},
    {12380068467935836596LU, 6065792873465380864LU},
    {8284096435185276132LU, 1317372873202991104LU},
    {5253498327267875543LU, 7970133247403229184LU},
    {10507460434988185479LU, 2953693037168951296LU},
    {1828609399556643855LU, 16769339386461421568LU},
    {13860203833522368863LU, 12600667746988982272LU},
    {18034238949227954028LU, 15135814249772744704LU},
    {2557956329405076028LU, 10694658245680693248LU},
    {10266006673746584330LU, 3146461971256180736LU},
    {6287585630426517082LU, 7911773012741849088LU},
    {7880970476829868137LU, 1233957654762618880LU},
    {12999367200905178425LU, 6303311243608326144LU},
    {7351152748783557575LU, 15628866462309941248LU},
    {13780268320869152407LU, 11421932273457430528LU},
    {9593353521644452004LU, 16307952833926266880LU},
    {6637078039723513332LU, 11833002884687986688LU},
    {17373799228120671426LU, 2014850741457387520LU},
    {2892983473533782418LU, 6741899422541545472LU},
    {1313599812509878177LU, 2396952519830929408LU},
    {14628548577940728561LU, 7432511974551846912LU},
    {16692767278064079775LU, 9799900447778013184LU},
    {4508468374134472399LU, 14872579578261405696LU},
    {328311064946766076LU, 12877376847599370240LU},
    {15976438659308281260LU, 17641615521650573312LU},
    {8120050907585047706LU, 5409648490567434240LU},
    {12216546408801092042LU, 969636734482513920LU},
    {10634913032075775993LU, 8189638868304134144LU},
    {5381553557660279465LU, 4017572555400413184LU},
    {11010337439224222807LU, 13284624821972369408LU},
    {4752776364455426311LU, 18319040441003016192LU},
    {8929065596047963956LU, 9433326432173424640LU},
    {11732926672909998692LU, 14163769924127817728LU},
    {1140602242224827218LU, 8885220298043949056LU},
    {15487290669148079618LU, 4406944944606937088LU},
    {17073922421421918257LU, 4754458994863505408LU},
    {3876212278893634913LU, 548597585762320384LU},
    {13089125084369894124LU, 11506816688540614656LU},
    {7826194670607505340LU, 15696827065569378304LU},
    {6233847901692942735LU, 11891177971899170816LU},
    {10356802359822185695LU, 16385162520408621056LU},
    {2503229297912858089LU, 6675108691064127488LU},
    {18123772103905405113LU, 1928814012418490368LU},
    {13950950435646809738LU, 7356384181741420544LU},
    {1775096640145132506LU, 2337677912402034688LU},
    {14610210588142828836LU, 12676549644331778048LU},
    {1438959883566141556LU, 16828297454800601088LU},
    {3019416529425538631LU, 10761836400388079616LU},
    {17356534498036167447LU, 15222027020931170304LU},
    {6762521243084161569LU, 7853984799004819456LU},
    {9574826809900969841LU, 3069427777137541120LU},
    {13762920698981769538LU, 6218180383301697536LU},
    {7477774217366588434LU, 1165679962657652736LU},
    {5435264210382632316LU, 18377211001318670336LU},
    {10544091644378486828LU, 13361830273616969728LU},
    {12126797733209921055LU, 14248658625588363264LU},
    {8174835097047235407LU, 9501291579508260864LU},
    {15885700165545740921LU, 4330821438173872128LU},
    {381833307109713705LU, 8825950234690453504LU},
    {4563169429127080218LU, 481802327389372416LU},
    {16603207322253296714LU, 4668418030986854400LU},
    {3749806297938326196LU, 14939762019346153472LU},
    {17091212852053336036LU, 9886117763011837952LU},
    {15505619449999757783LU, 17717492892097839104LU},
    {1015233786856062087LU, 12936330681100795904LU},
    {11750266185362771377LU, 884501347280355328LU},
    {8802434643640787169LU, 5341366563624714240LU},
    {4627359136519581394LU, 3959788628040744960LU},
    {11028890951026230146LU, 8112609218260893696LU},
  },
  // Table 6
  {
    {0LU, 0LU},
    {2557492544691097621LU, 7035076458556948480LU},
    {5114985089382195242LU, 14070152917113896960LU},
    {7314437598226575423LU, 11737125324717031424LU},
    {10229970178764390485LU, 9693561760518242304LU},
    {12575789888098701376LU, 16656545440665174016LU},
    {14628875196453150847LU, 5027506575724511232LU},
    {16751769455831887978LU, 2622456573661806592LU},
    {5378727226691008872LU, 13507713751268196352LU},
    {7627718987235092861LU, 15768394028313214976LU},
    {889742661742238018LU, 8662167691286544384LU},
    {3397695266330888535LU, 1844135377808392192LU},
    {14365695867853535549LU, 4464044726626025472LU},
    {16439050874324592936LU, 6652632225261027328LU},
    {9340790609469724951LU, 18352239464459272192LU},
    {11736150257698507010LU, 11462184741315280896LU},
    {10757454453382017745LU, 8568683428826841088LU},
    {13129169662468334276LU, 1678585824729366528LU},
    {15255437974470185723LU, 13090043982916878336LU},
    {17350185637584110318LU, 15278656770319319040LU},
    {1779485323484476036LU, 17324335382573088768LU},
    {4308829468024496785LU, 10506330556885630976LU},
    {6795390532661777070LU, 3688270755616784384LU},
    {9020738936395154107LU, 5948905952685064192LU},
    {16136173432124787641LU, 14816594529234190336LU},
    {18199395554719505324LU, 12411501646218002432LU},
    {11030203793704709011LU, 1070774452570030080LU},
    {13433443857055005574LU, 8033783421484400640LU},
    {5915218157788957676LU, 5411476450123448320LU},
    {8172092102981082105LU, 3078476345517277184LU},
    {1507298799389256646LU, 9825258587528626176LU},
    {4005118090604837843LU, 16860289966108835840LU},
    {8917429732044430433LU, 6606152192262930432LU},
    {6394859627171155060LU, 4182815662562869248LU},
    {4412684098481978443LU, 11020024489621585920LU},
    {2180596702150241374LU, 17964684258735816704LU},
    {17742270159132073012LU, 15937033445289492480LU},
    {15368319728872410145LU, 13585719325255270400LU},
    {12737630430130289694LU, 2191158393043943424LU},
    {10645153310133906443LU, 9207910940568190976LU},
    {3558970646968952073LU, 16201926691436625920LU},
    {1304365045737960732LU, 9329579053302153216LU},
    {8617658936048993571LU, 2565917040061710336LU},
    {6117606622550168886LU, 4772244609055064064LU},
    {13590781065323554140LU, 7376541511233568768LU},
    {11520822149018481993LU, 576216282764935168LU},
    {18041477872790308214LU, 11897811905370128384LU},
    {15645009649948251491LU, 14176232252773498880LU},
    {17188890454461296304LU, 3262805449824534528LU},
    {14840835386514701989LU, 5541200508460466176LU},
    {12139214315660971674LU, 17151090347611258880LU},
    {10018590461960838799LU, 10350808000096108544LU},
    {7166092741511999205LU, 12376352836458381312LU},
    {4615374373926616816LU, 14582725485428473856LU},
    {2706382690698415823LU, 7530751800895340544LU},
    {500191326694645466LU, 658376674970173440LU},
    {11830436315577915352LU, 10822952900246896640LU},
    {9750344652835440589LU, 17839680159003705344LU},
    {16344184205962164210LU, 6156952691034554368LU},
    {13955596535680559079LU, 3805681451953815552LU},
    {3014597598778513293LU, 1203773101347700736LU},
    {767874044756592536LU, 8148477950438670336LU},
    {8010236181209675687LU, 15273835858508120064LU},
    {5500050416898811826LU, 12850471841017364480LU},
    {17834859464088860866LU, 13212304384525860864LU},
    {15347194251339524311LU, 15490715935836209152LU},
    {12789719254342310120LU, 8365631325125738496LU},
    {10520474758050072829LU, 1565332484936171520LU},
    {8825368196963956887LU, 3593304905533620224LU},
    {6414261074766669954LU, 5799623678433951744LU},
    {4361193404300482749LU, 17482624443762081792LU},
    {2303621584450914472LU, 10610303193906675712LU},
    {13629922010810548650LU, 877782742824124416LU},
    {11410217315973845439LU, 7894561678627438592LU},
    {18148140956915835264LU, 14946808660519550976LU},
    {15610936353819881877LU, 12595485744392306688LU},
    {3521553740009259519LU, 9991501653271904256LU},
    {1414442117496213994LU, 16936187810665201664LU},
    {8512649513116688853LU, 5326571268873388032LU},
    {6151081780058075584LU, 2903225943080304640LU},
    {7117941293937904147LU, 13957109309163700224LU},
    {4734980921550510598LU, 11533718903393878016LU},
    {2608730091475921465LU, 212414032894754816LU},
    {525262925419428396LU, 7157127678078746624LU},
    {17235317872097987142LU, 5131834080123420672LU},
    {14721756608767089235LU, 2780536452763615232LU},
    {12235213245100337772LU, 9544489218110128128LU},
    {9994116993266612857LU, 16561225272959959040LU},
    {2913004388805211003LU, 8846361521303846912LU},
    {798012231985308526LU, 1973995191471702016LU},
    {7967151244830102353LU, 13368846875789099008LU},
    {5615716276462486340LU, 15575193136480124928LU},
    {11931501764264866606LU, 18177343929400164352LU},
    {9721930504134058811LU, 11377070377978036224LU},
    {16386671003721241348LU, 4540152303025389568LU},
    {13841584337310073617LU, 6818520973382254592LU},
    {10106980437886002339LU, 17074919411854344192LU},
    {12627315740882613430LU, 10184838300431286272LU},
    {14609438590255481993LU, 3437782761060958208LU},
    {16843795849489814684LU, 5626379055788982272LU},
    {124713779405726966LU, 7669700177673846784LU},
    {2505438930620839139LU, 851641475916627968LU},
    {5136075356773057756LU, 12192095372205621248LU},
    {7221813065948157129LU, 14452784445343662080LU},
    {14332185483023998411LU, 6305961599207211008LU},
    {16544025087114874334LU, 3900920393237528576LU},
    {9230748747853233633LU, 10718706897147396096LU},
    {11773602391980092916LU, 17681664189015261184LU},
    {5412765381396831646LU, 15061503601790681088LU},
    {7521020744507411851LU, 12728484805486837760LU},
    {1000382653389290932LU, 1316753349940346880LU},
    {3358589462266178977LU, 8351803420218228736LU},
    {1803994002320725618LU, 11104848169572237312LU},
    {4212865765906761319LU, 18139870752059424768LU},
    {6914434083087496792LU, 6439972760755109888LU},
    {8974276308616701517LU, 4106999044428005376LU},
    {10732418013259388455LU, 2061007621116133376LU},
    {13226857403113375282LU, 9024007793937481728LU},
    {15135796285424006669LU, 16129943378858082304LU},
    {17398301926555788824LU, 13724876884120961024LU},
    {6029195197557026586LU, 2407546202695401472LU},
    {8129570163799719695LU, 4668207788042747904LU},
    {1535748089513185072LU, 16296955900877340672LU},
    {3904087800520040229LU, 9478942279096860672LU},
    {16020472362419351375LU, 12100927643306688512LU},
    {18242445263777185626LU, 14289566818988195840LU},
    {11000100833797623653LU, 7254199608325177344LU},
    {13535072277170331504LU, 364093208134680576LU},
    {13713760833014745158LU, 15622702999556587520LU},
    {11326299328928520275LU, 13362005680081338368LU},
    {17918981821220644972LU, 1985458596623679488LU},
    {15840016324673419385LU, 8803509052043689984LU},
    {3722567576515315731LU, 6793836765539991552LU},
    {1213507445822904326LU, 4605232224474759168LU},
    {8454704189205817401LU, 11316339712211288064LU},
    {6209106268802218028LU, 18206412577297137664LU},
    {17650736393927913774LU, 7186609811067240448LU},
    {15531238156667199803LU, 151551494452150272LU},
    {12828522149533339908LU, 11599247356867903488LU},
    {10481592698026295569LU, 13932257906834538496LU},
    {8722386808600965499LU, 16518504813814611968LU},
    {6517321627971314030LU, 9555539275609538560LU},
    {4607243168901828945LU, 2773862314103799808LU},
    {2057650984690696516LU, 5178895273736273920LU},
    {3106136866370697879LU, 12548411425359396864LU},
    {604958919252568706LU, 14953487265945354240LU},
    {7919338960488143549LU, 7883498633146925056LU},
    {5663607725637716648LU, 920507806174412800LU},
    {12025473746297060034LU, 2928072741204525056LU},
    {9627879357260737239LU, 5261055803380465664LU},
    {16149630629344565992LU, 16997045882341818368LU},
    {14078545546845096701LU, 9962032645703467008LU},
    {7043107480018519039LU, 1536259232834256896LU},
    {4809893900311548906LU, 8426374978873589760LU},
    {2828884234992427989LU, 15425631547620851712LU},
    {305187946744050624LU, 13237001717788180480LU},
    {17025299026233377706LU, 10653142537746776064LU},
    {14931696289798427583LU, 17471165505376092160LU},
    {12302163560116151168LU, 5806451886160609280LU},
    {9927087513418052501LU, 3545799646662098944LU},
    {14235882587875808295LU, 9467474544617848832LU},
    {16640248817421403186LU, 16339804040810463232LU},
    {9469961843101021197LU, 4620693733078204416LU},
    {11534310131891168280LU, 2414383206515081216LU},
    {5217460182951842930LU, 424828065789509632LU},
    {7716405107785663591LU, 7225135152316284928LU},
    {1050525850838856792LU, 14314255356157493248LU},
    {3308525429649351757LU, 12035852051184353280LU},
    {10319171867191160143LU, 4041474782842060800LU},
    {12415045146744716634LU, 6464828354972352512LU},
    {14540157224693108069LU, 18110392948397965312LU},
    {16912998050218925424LU, 11165715037341876224LU},
    {201878643880062234LU, 13731546693453742080LU},
    {2428353230987640079LU, 16082877855918194688LU},
    {4913748629824392496LU, 9066724061194747904LU},
    {7444218957738482981LU, 2049953371728642048LU},
    {5826008777610422006LU, 17692723042607693824LU},
    {8332835748579587811LU, 10675977641909026816LU},
    {1596024463970617052LU, 3947990382943404032LU},
    {3843890590895347401LU, 6299278664454373376LU},
    {15934302489660204707LU, 8290949677868646400LU},
    {18328535971694671542LU, 1346226686835818496LU},
    {11231432552924972681LU, 12703642199250698240LU},
    {13303661393201845916LU, 15127023259171684352LU},
    {1909306303799713694LU, 5691467773331374080LU},
    {4107632629268909963LU, 3413089757125672960LU},
    {6666211597615038388LU, 10213915744421281792LU},
    {9222577958930821025LU, 17014179949994573824LU},
    {10918713804299837387LU, 14445952045728923648LU},
    {13040482447240187870LU, 12239596439189061632LU},
    {15094662477125369825LU, 808797802749493248LU},
    {17439356570021162996LU, 7681154786732802048LU},
    {5319655925563650180LU, 8040461683312820224LU},
    {7686869453195190417LU, 1023699789939736576LU},
    {1094134155019440302LU, 12454226228531953664LU},
    {3193382937886949563LU, 14805531002717339648LU},
    {14135410875201401041LU, 16794774431896436736LU},
    {16669256702135591108LU, 9850105316933369856LU},
    {9428007208703561979LU, 3049007131790409728LU},
    {11648854493623009518LU, 5472334315641634816LU},
    {249427558811453932LU, 15339400355347693568LU},
    {2308144150721305081LU, 13060970662095486976LU},
    {5010877861241678278LU, 1703282951833255936LU},
    {7418623991208229331LU, 8503598834453053440LU},
    {10272150713546115513LU, 5937446670701690880LU},
    {12533530188483713452LU, 3731109755859501056LU},
    {14443626131896314259LU, 10458824816977772544LU},
    {16936939355555985798LU, 17331163109263409152LU},
    {15895755280718398037LU, 1837294250820108288LU},
    {18439734541284758080LU, 8709677623082483712LU},
    {11125301632693772927LU, 15725541765211488256LU},
    {13338266853224280682LU, 13519177362578604032LU},
    {5864028216675910144LU, 11527265006362034176LU},
    {8223361208926867989LU, 18327555600214392832LU},
    {1701557254171288106LU, 6681701354194337792LU},
    {3810938800656069183LU, 4403314541895614464LU},
    {10825530762793663293LU, 11676263129871810560LU},
    {13061014188223425320LU, 14099635393699774464LU},
    {15042041489014823703LU, 7010225537264123904LU},
    {17563502958206733058LU, 65528934510362624LU},
    {2000765306778581864LU, 2633506699880693760LU},
    {4087628649572051837LU, 4984786185298640896LU},
    {6717178924532357954LU, 16703606840436457472LU},
    {9099029709365709655LU, 9686887828016857088LU},
    {3607988004641451237LU, 3762952265434923008LU},
    {1255426852898733296LU, 6168011613346463744LU},
    {8425731531813522639LU, 17832997430409297920LU},
    {6309613191618387162LU, 10870023096111202304LU},
    {13828868166174993584LU, 12879945521510219776LU},
    {11282655883325389989LU, 15212982459755921408LU},
    {17948552617233403034LU, 8213998088856010752LU},
    {15737855740664028303LU, 1178930976147898368LU},
    {8698480661866321293LU, 10326115339758206976LU},
    {6613887862190392728LU, 17216179408751034368LU},
    {4488722985740285351LU, 5480461527637032960LU},
    {2104636979733587378LU, 3291883374850867200LU},
    {17676366570599929304LU, 705877810673090560LU},
    {15434144152571807181LU, 7523919470000078848LU},
    {12948696002478044658LU, 14594180300645859328LU},
    {10434008572952880615LU, 12333509369449676800LU},
    {12058390395114053172LU, 4815092405390802944LU},
    {9522311408457649697LU, 2554448961985314816LU},
    {16259140327599439390LU, 9336415576085495808LU},
    {14040561249202155019LU, 16154412155435745280LU},
    {3071496179026370145LU, 14147167728045129728LU},
    {711054629342006900LU, 11958546694305480704LU},
    {7808175601040080459LU, 511140484484169728LU},
    {5702190161901153886LU, 7401229842244435968LU},
    {17148882503120119644LU, 17989539784233582592LU},
    {14880764173023131465LU, 10954500159316164608LU},
    {12322132329671247734LU, 4243682324174077952LU},
    {9835593283117291363LU, 6576674182443040768LU},
    {6918996233255495433LU, 9160845074030919680LU},
    {4862550047024248604LU, 2197827858779340800LU},
    {2808317335406774051LU, 13574664594831441920LU},
    {398335846827939638LU, 15979749231510421504LU},
  },
  // Table 7
  {
    {0LU, 0LU},
    {3312253575799351630LU, 568604746017931264LU},
    {6624507151598703260LU, 1137209492035862528LU},
    {8509981628311469010LU, 588908336326377472LU},
    {13249014303197406520LU, 2274418984071725056LU},
    {11108842459120995446LU, 1762115839055626240LU},
    {17019963256622938020LU, 1177816672652754944LU},
    {13962411721147309802LU, 1710353039233122304LU},
    {4534759990220583859LU, 9897034285683048448LU},
    {1376352423513807613LU, 10285451057551114240LU},
    {7277902796946612527LU, 9696665875116982272LU},
    {5257727282484250721LU, 9328482307633315840LU},
    {9886316390903109259LU, 10865224625504124928LU},
    {11872682083252928453LU, 10461051843420094464LU},
    {15194505533399073815LU, 11025135389034676224LU},
    {18386727595111361881LU, 11449611744247283712LU},
    {9069519980441167719LU, 1347324497656545280LU},
    {5776452893889089065LU, 1537626874975354880LU},
    {2752704847027615227LU, 2124158041392676864LU},
    {848065871302237365LU, 1918130457363349504LU},
    {14555805593893225055LU, 946587676524412928LU},
    {16715075943603890961LU, 776558103188471808LU},
    {10515454564968501443LU, 210220541557080064LU},
    {13553894400672446861LU, 364454539438325760LU},
    {4842456406458143956LU, 11235351051508908032LU},
    {7981681881966525850LU, 11245465454677852160LU},
    {1791630377644967496LU, 10674606727002849280LU},
    {3830974789168295686LU, 10648696731199340544LU},
    {17649088236555219436LU, 9546400053355085824LU},
    {15643628436620023970LU, 9484500842951213056LU},
    {12610309965655401328LU, 10066546027697012736LU},
    {9437204001763150398LU, 10112720014210498560LU},
    {18139039960882335438LU, 2694648995313090560LU},
    {15442189662919616384LU, 2486347621237522432LU},
    {11552905787778178130LU, 3075253749950709760LU},
    {10206097428010710300LU, 3263255948944211968LU},
    {5505409694055230454LU, 4248316082785353728LU},
    {7030217842749260472LU, 4400329067178491904LU},
    {1696131742604474730LU, 3836260914726699008LU},
    {4214986374844878884LU, 3664019123995672576LU},
    {14219100501974302077LU, 12410799908691378176LU},
    {16763270283909403699LU, 12382668899399761920LU},
    {11437628707960975329LU, 11814114730916708352LU},
    {12920233208323983023LU, 11822016916690567168LU},
    {8253287075087325253LU, 12946820640505069568LU},
    {6881198749896323339LU, 12990720836972314624LU},
    {2983470900347947737LU, 13575105765282152448LU},
    {328789066377978775LU, 13510906376552972288LU},
    {9684912812916287913LU, 4023958029308264448LU},
    {12362598611866386663LU, 3473383083552538624LU},
    {15963363763933051701LU, 4044186835646152704LU},
    {17329358612947784315LU, 4610491403338776576LU},
    {3583260755289934993LU, 2902469380296146944LU},
    {2039340906824213983LU, 3432784733388406784LU},
    {7661949578336591373LU, 2850649388689129472LU},
    {5162193451730433859LU, 2336134026277945344LU},
    {13297173447789599258LU, 13731102241648017408LU},
    {10772172562915455828LU, 13360697660676243456LU},
    {16386337259987798150LU, 12774041149933355008LU},
    {14884550668426387912LU, 13160245704406335488LU},
    {1104781051720892194LU, 11609981566767333376LU},
    {2495985474731923052LU, 12032184131933700096LU},
    {6105195150960799166LU, 12598501902355791872LU},
    {8740782877345383664LU, 12192028941946454016LU},
    {11970846854055109727LU, 18208983269842616320LU},
    {10076664364569922833LU, 18111044267303501824LU},
    {18288563855105586883LU, 17544726505471344640LU},
    {15004158865372897165LU, 17626935886073561088LU},
    {1296202738390532455LU, 16366945034370547712LU},
    {4326398580125444137LU, 16485152425666150400LU},
    {5337877860973237243LU, 17071808944998973440LU},
    {7486265375251954357LU, 16937801563022295040LU},
    {11010819388110460908LU, 8496632165570707456LU},
    {13058526828753813154LU, 8218522798247641088LU},
    {14060435685498520944LU, 8800658134356983808LU},
    {17210451899318545470LU, 9062967528178843648LU},
    {3392263485208949460LU, 7672521829453398016LU},
    {208503384840461210LU, 7898842008674893824LU},
    {8429972749689757768LU, 7328038247991345152LU},
    {6416005072457730310LU, 7085988464012820480LU},
    {15851990729272214328LU, 17150241404375531520LU},
    {17729238550933138038LU, 16854144018232115200LU},
    {9228842877312635300LU, 16269759098512211968LU},
    {12530160544634943722LU, 16586155659737694208LU},
    {7791334949904770560LU, 17406898221803896832LU},
    {4744292380740505422LU, 17759292793722765312LU},
    {4021323026879198364LU, 18327846970795753472LU},
    {1889795434167279058LU, 17995681205214773248LU},
    {16506574150174650507LU, 7446897207300587520LU},
    {14475796979307223493LU, 6970629456373219328LU},
    {13762397499792646679LU, 7534697600235077632LU},
    {10595464210334141273LU, 8031194174680203264LU},
    {5966941800695895475LU, 8703467456854753280LU},
    {9167544230445399293LU, 9163974816699514880LU},
    {657578132755957551LU, 8575068679396392960LU},
    {2654681490372324961LU, 8134860511813566464LU},
    {6744753382265678481LU, 15696765656126980096LU},
    {8101219698223793119LU, 16010870835120177152LU},
    {465233403220604941LU, 15428825658964312064LU},
    {3135536971512123715LU, 15130445686681632768LU},
    {16881700565877903273LU, 14287178572358483968LU},
    {14389181315215812327LU, 13952809385475440640LU},
    {12801802033014938933LU, 14523668121740378112LU},
    {11267546726467318907LU, 14873832884078116864LU},
    {7166521510579869986LU, 5804938760592293888LU},
    {5657616571687153772LU, 6299231913735356416LU},
    {4078681813648427966LU, 6865569466776813568LU},
    {1543923696762479344LU, 6387071906268315648LU},
    {15323899156673182746LU, 5701298777378258944LU},
    {17968817172903892308LU, 5258799227563147264LU},
    {10324386903460867718LU, 4672268052555890688LU},
    {11723127270115854280LU, 5130492826261389312LU},
    {2325903778883014134LU, 14656038429687545856LU},
    {986350140514510008LU, 14735956428057477120LU},
    {8910863404933898090LU, 14171872891032829952LU},
    {6223625168818107940LU, 14071651302354452480LU},
    {10924238898123581646LU, 15345146330100006912LU},
    {13433618070352462208LU, 15208935526821265408LU},
    {14732483027527170642LU, 15797720717845331968LU},
    {16249891606645429020LU, 15913698299559804928LU},
    {2209562103441784389LU, 4773219059825115136LU},
    {3701549966696011531LU, 5033325032344911872LU},
    {4991970949463846105LU, 5617624190157848576LU},
    {7543659336125711767LU, 5337285013253652480LU},
    {12210390301921598333LU, 6750259731002032128LU},
    {9548607966075220531LU, 6505918564791222272LU},
    {17481565754690767329LU, 5937313810183356416LU},
    {16099667717416788143LU, 6161351403265589248LU},
    {2095483502170501500LU, 5701407221007515648LU},
    {3522899265105549362LU, 5258903264555958272LU},
    {5114502596119438304LU, 4672301729394458624LU},
    {7713856992314034862LU, 5130530892556533760LU},
    {12306459177633895492LU, 5804906466733195264LU},
    {9745277739060919562LU, 6299195213239812096LU},
    {17377043833575278296LU, 6865462406127026176LU},
    {15911450989818556310LU, 6386969235075104768LU},
    {2592405476781064911LU, 14287145995031543808LU},
    {1012586541573843841LU, 13952772418691923968LU},
    {8652797160250888275LU, 14523560777622749184LU},
    {6188953314559457565LU, 14873729946596933632LU},
    {10675755721946474487LU, 15696873816288395264LU},
    {13389371393930366649LU, 16010974605825015808LU},
    {14972530750503908715LU, 15428859052335038464LU},
    {16302573736285723685LU, 15130483486688804864LU},
    {6974333621894157851LU, 6750297531009204224LU},
    {5566082356765867861LU, 6505951958161948672LU},
    {4262434249115944071LU, 5937417580888195072LU},
    {1643893364884139465LU, 6161459563427004416LU},
    {15498077319732802339LU, 4773116122343931904LU},
    {18078370459287525997LU, 5033217688227282944LU},
    {10158644193600561599LU, 5617587223374331904LU},
    {11605138530517174513LU, 5337252435926712320LU},
    {6784526970417898920LU, 15345043658906796032LU},
    {8345177009774218470LU, 15208828466171478016LU},
    {417006769680922420LU, 15797684017349787648LU},
    {2900032705364893306LU, 15913666005700706304LU},
    {16859945499379515536LU, 14656076495982690304LU},
    {14127213728369732062LU, 14735990104896045056LU},
    {12832010144915460620LU, 14171976928025640960LU},
    {11521061267929086786LU, 14071759745983709184LU},
    {16622354777049776050LU, 7672488161204764672LU},
    {14652754451372709628LU, 7898803933789814784LU},
    {13637055519792491822LU, 7327929812952023040LU},
    {10428068091375862880LU, 7085884418430074880LU},
    {5869179695458097802LU, 8496739234810429440LU},
    {8972576483067212740LU, 8218625460850917376LU},
    {764901591099918358LU, 8800690436806017024LU},
    {2840087884628615512LU, 9063004220084453376LU},
    {15582669899809541121LU, 16367052369898242048LU},
    {17705830077550847311LU, 16485255371737268224LU},
    {9488584761481010845LU, 17071841513735979008LU},
    {12563147963327264723LU, 16937838538395746304LU},
    {8042646053758396729LU, 18208949867881955328LU},
    {4785719925601648759LU, 18111006475886264320LU},
    {3779590868334558117LU, 17544618336719994880LU},
    {1838788944014971627LU, 17626832123958657024LU},
    {11201331639455144149LU, 8703363694739849216LU},
    {13151745477094994331LU, 9163866647948165120LU},
    {13879502379444996681LU, 8575030887979155456LU},
    {17107654305668375303LU, 8134827109852905472LU},
    {3219769755568700909LU, 7446934182674038784LU},
    {97274461119468707LU, 6970662025110224896LU},
    {8592887534019981169LU, 7534800546306195456LU},
    {6536812941473023551LU, 8031301510207897600LU},
    {11933883601391790950LU, 17406934913709506560LU},
    {9829905513643016744LU, 17759325096171798528LU},
    {18335088460890798586LU, 18327949633399029760LU},
    {15241356363193634996LU, 17995788274454495232LU},
    {1315156265511915102LU, 17150137358792785920LU},
    {4591176502464096016LU, 16854035583192793088LU},
    {5309362980744649922LU, 16269721023627132928LU},
    {7231048806038336908LU, 16586121991489060864LU},
    {13489506764531356963LU, 12946787238544408576LU},
    {10863570695616953453LU, 12990683045555077120LU},
    {16202439396447586239LU, 13574997596530802688LU},
    {14784717082507620081LU, 13510802614438068224LU},
    {930466806441209883LU, 12410907244219072512LU},
    {2386577616404601173LU, 12382771845470879744LU},
    {6271073943024247431LU, 11814147299653713920LU},
    {8858626188871109577LU, 11822053892064018432LU},
    {9645284068318684816LU, 4248423152025075712LU},
    {12118504703119527902LU, 4400431729781768192LU},
    {16011445553935021068LU, 3836293217175732224LU},
    {17564999476308106562LU, 3664055815901282304LU},
    {3604879224591614888LU, 2694615327064457216LU},
    {2301453337225177830LU, 2486309546352443392LU},
    {7631878063649411380LU, 3075145314911387648LU},
    {4908534066730694778LU, 3263151903361466368LU},
    {14333043021159739972LU, 11609877521184587776LU},
    {16942066413421959946LU, 12032075696894377984LU},
    {11315233143374307544LU, 12598463827470712832LU},
    {12749890124196923798LU, 12191995273697820672LU},
    {8157363627296855932LU, 13731138933553627136LU},
    {6684392894825053746LU, 13360729963125276672LU},
    {3087847393524958688LU, 12774143812536631296LU},
    {517141876044885166LU, 13160352773646057472LU},
    {17872401665653359095LU, 2902506355669598208LU},
    {15416098105549383865LU, 3432817302125412352LU},
    {11811108629808747371LU, 2850752334760247296LU},
    {10240624438597171749LU, 2336241361805639680LU},
    {5754037713921172687LU, 4023854267193360384LU},
    {7074327921840704897LU, 3473274914801188864LU},
    {1455939175955805779LU, 4044149044228915200LU},
    {4162440842551893789LU, 4610458001378115584LU},
    {4651807557766028269LU, 10865332785665540096LU},
    {7888608077297398435LU, 10461155614124933120LU},
    {1972700281029020017LU, 11025168782405402624LU},
    {3933627539129753663LU, 11449649544254455808LU},
    {17821726809867796181LU, 9897001708356108288LU},
    {15754720762993317787LU, 10285414090767597568LU},
    {12447250337636215881LU, 9696558530999353344LU},
    {9316532730078643463LU, 9328379370152132608LU},
    {9106347151035689054LU, 2274386690212626432LU},
    {6023357172754596112LU, 1762079138560081920LU},
    {2706316323327851202LU, 1177709612002967552LU},
    {610722945559794572LU, 1710250368039911424LU},
    {14536997494710717798LU, 108443629256704LU},
    {16450161939196175400LU, 568708783010742272LU},
    {10543824017275133946LU, 1137243168874430464LU},
    {13809247051971770036LU, 588946402621521920LU},
    {4419124206883568778LU, 9546438119650230272LU},
    {1199258354234840516LU, 9484534519789780992LU},
    {7403099933392023062LU, 10066650064689823744LU},
    {5425259998639097688LU, 10112828457839755264LU},
    {9983941898927692210LU, 11235248380315697152LU},
    {12067794674168951036LU, 11245358394028064768LU},
    {15087318672251423534LU, 10674570026507304960LU},
    {18201176357300576864LU, 10648664437340241920LU},
    {269466257535766329LU, 946484739043229696LU},
    {3335525966978360951LU, 776450759070842880LU},
    {6364619839374155173LU, 210183574773563392LU},
    {8477130291839071467LU, 364421962111385600LU},
    {12997567117140765185LU, 1347362297663717376LU},
    {11067560342332670799LU, 1537660268346081280LU},
    {17261831497387243677LU, 2124261812097515520LU},
    {14013272783243694547LU, 1918238617524764672LU},
  },

};

template <>
const uint64_t FingerprintTable<128>::poly[2] = {14491457269451502875LU, 10114337454828269779LU};

template <>
const uint64_t FingerprintTable<128>::table[8][256][2] = {
  // Table 0
  {
    {0LU, 0LU},
    {14491457269451502875LU, 10114337454828269779LU},
    {6569626697471745836LU, 10729800775251841397LU},
    {10536170465193454135LU, 1781930835946987942LU},
    {13139253394943491673LU, 3012857476794131178LU},
    {9170453377918372674LU, 11930749795658240569LU},
    {17110303038662926709LU, 13630207070172705695LU},
    {2625596856677356654LU, 3563861671893975884LU},
    {11937913592521673129LU, 16123726145850242311LU},
    {7831762716177431730LU, 6025714953588262356LU},
    {18340906755836745349LU, 5414755517606929522LU},
    {4007080099267388318LU, 14373320845285889185LU},
    {1437770267030747120LU, 17729873939228088301LU},
    {15773862003616301803LU, 8813670066635859774LU},
    {5251193713354713308LU, 7127723343787951768LU},
    {9350602332962627015LU, 17201387512774932043LU},
    {9388885683008382536LU, 3735928661843270365LU},
    {5429083111333794643LU, 13800708217990933006LU},
    {15663525432354863460LU, 12051429907176524712LU},
    {1187818903265758335LU, 3126096230651870075LU},
    {3752629413930637329LU, 1880110713027950647LU},
    {18235069437963939082LU, 10829511035213859044LU},
    {8014160198534776637LU, 10299897616862226754LU},
    {11971688928518730278LU, 193036978944514449LU},
    {2875540534061494241LU, 17013003804746624986LU},
    {17220647299526449914LU, 6937527503023841033LU},
    {8992554094535192781LU, 8718331327735299759LU},
    {13100979933523051990LU, 17627340133271719548LU},
    {10502387426709426616LU, 14255446687575903536LU},
    {6387236922970072227LU, 5298728402126945763LU},
    {14597284685814075028LU, 5850859602016721989LU},
    {254460592215702415LU, 15956030951840312470LU},
    {14808948323771677067LU, 16999970348320097641LU},
    {331027292307213456LU, 7471857323686540730LU},
    {10858166222667589287LU, 9154672362272314396LU},
    {6896149286054499260LU, 17534402659046679759LU},
    {8924996823881697234LU, 13989261398991611779LU},
    {12880306791000175305LU, 5656115740643497808LU},
    {2375637806531516670LU, 6252192461303740150LU},
    {16855858930258292197LU, 15751735214865761829LU},
    {7505258827861274658LU, 3760221426055901294LU},
    {11615899134747313465LU, 13291148505069928637LU},
    {3676073706292047630LU, 11585815165270434075LU},
    {18023394802218326549LU, 3212277996718166472LU},
    {16028320397069553275LU, 2153051160014901892LU},
    {1687715032094358368LU, 10501396854310822487LU},
    {9609565421003034967LU, 9873795199589057521LU},
    {5496633783327908940LU, 386073957889028898LU},
    {5751081068122988483LU, 15579263535783698356LU},
    {9715406072845003480LU, 6082658815132757863LU},
    {1505312156332589295LU, 5535840180819037889LU},
    {15994550525343348212LU, 13875055006047682066LU},
    {17985108189070385562LU, 17436662655470599518LU},
    {3498187504843674753LU, 9053959416290954637LU},
    {11726230175165955766LU, 7285857425586662443LU},
    {7755215793336552365LU, 16807936192833887480LU},
    {16889638707789698666LU, 573736317435882163LU},
    {2558030779709301617LU, 10064149301442255456LU},
    {12774473845940144454LU, 10597456804253891526LU},
    {8670541835525913693LU, 2255426567443237653LU},
    {6646202210278287411LU, 3330838318537508953LU},
    {10747825297918598440LU, 11701719204033443978LU},
    {508921184431404831LU, 13465317829971073324LU},
    {14847227251612500484LU, 3928039834221767167LU},
    {5916629915962525196LU, 6594771508900510209LU},
    {11171152573833802519LU, 15553196622930643666LU},
    {662054584614426912LU, 14943714647373081460LU},
    {13847417358780738619LU, 4845843616659069863LU},
    {16448296849776244821LU, 8235540376284305643LU},
    {3269588371625626958LU, 18309344724544628792LU},
    {13792298572108998521LU, 16622061244383807902LU},
    {8535422873618584162LU, 7705717175868160333LU},
    {17849993647763394469LU, 9531778724273671942LU},
    {4516007881279158974LU, 584050046295801813LU},
    {12437792127542579337LU, 1198035339888664179LU},
    {7313869508290798994LU, 11312231481286995616LU},
    {4751275613063033340LU, 12504384922607480300LU},
    {9868535106123171047LU, 2437898228624219455LU},
    {1928643809896361680LU, 4138692758105504921LU},
    {15264973786807032779LU, 13056726356021972042LU},
    {15010517655722549316LU, 7520442852111802588LU},
    {1822812007032345951LU, 16429310379400122383LU},
    {10050929272495521640LU, 18210887942181171625LU},
    {4785054195785075315LU, 8135552936430305658LU},
    {7352147412584095261LU, 4724886256831316534LU},
    {12615687040525757190LU, 14830198919278490341LU},
    {4405667994036338993LU, 15381415540481758019LU},
    {17600045530727101482LU, 6424555993436332944LU},
    {8501651981572352493LU, 13231295799824684507LU},
    {13609896720429554934LU, 4306102320029803784LU},
    {3375430064188716737LU, 2556049634912093358LU},
    {16702743096530355162LU, 12620689012055897213LU},
    {14097373182598977460LU, 11407847125738501937LU},
    {772386768296518319LU, 1300846325468563426LU},
    {10993267566655817880LU, 772147915778057796LU},
    {5878342109085269379LU, 9721688451345405591LU},
    {11502162136245976967LU, 12711782997857845096LU},
    {6234138699639753372LU, 4338104551058771899LU},
    {14173922218007486635LU, 2634249255278243357LU},
    {984068071980455344LU, 12165317630265515726LU},
    {3010624312665178590LU, 11071680361638075778LU},
    {16202857750218716357LU, 1584100432562400593LU},
    {8280961310735851250LU, 955161505685556471LU},
    {13542356976977144809LU, 9303365938385812516LU},
    {4194010877985060398LU, 8046710743728278127LU},
    {17523472304431219509LU, 16426581237231647420LU},
    {6996375009687349506LU, 18107918832581909274LU},
    {12106768280090123289LU, 8579665628943690697LU},
    {10118497600544950391LU, 5072312259964823685LU},
    {5005716276622359916LU, 14571714851173324886LU},
    {15510431586673104731LU, 15169128311958223344LU},
    {2187589168581747264LU, 6836122866990221603LU},
    {2149314666974976463LU, 9489643085332014517LU},
    {15332533341869845716LU, 1147472634871764326LU},
    {5116061559418603235LU, 1681554529174959296LU},
    {10368440255455294456LU, 11172107674728498195LU},
    {12361227676422711190LU, 12285307351275489119LU},
    {7102203618170737293LU, 2748169534798231436LU},
    {17341083671051827386LU, 4510853134886475306LU},
    {4160226695698599329LU, 12881593824457664249LU},
    {13292404420556574822LU, 6661676637075017906LU},
    {8170625934818534781LU, 15001032723631939681LU},
    {16380748292534996810LU, 14453440368436888007LU},
    {3048906522127645265LU, 4956694334357336340LU},
    {1017842368862809663LU, 8483891586232595032LU},
    {14356320740012219172LU, 18005829057776059019LU},
    {6128302404775522579LU, 16238641628570018605LU},
    {11247710429515449352LU, 7856079668443534334LU},
    {11833259831925050392LU, 13189543017801020418LU},
    {7864358642754140419LU, 4276153749714814161LU},
    {18380368428162831156LU, 2588799623247930743LU},
    {3895561073958053423LU, 12659649172151735716LU},
    {1324109169228853825LU, 11440685221036611304LU},
    {15815465266324801370LU, 1339859116088452667LU},
    {5281648048408161645LU, 730307043980347293LU},
    {9248090643851925622LU, 9691687233318139726LU},
    {113665547421697457LU, 7550373831279870213LU},
    {14449849625842938026LU, 16471080752568611286LU},
    {6539176743251253917LU, 18171945375379705968LU},
    {10638677704751460230LU, 8102785354802192547LU},
    {13243911605092547560LU, 4685855875131646959LU},
    {9137853070508445427LU, 14797378415058064188LU},
    {17070845747237168324LU, 15411434351736320666LU},
    {2737111432367149535LU, 6466379272008843849LU},
    {2770886777752103504LU, 9570716748070334175LU},
    {17253243221817237323LU, 616813374837792268LU},
    {9032015762558317948LU, 1168100092591603626LU},
    {12989460912517464167LU, 11270456580152381305LU},
    {10388726333211284489LU, 12474361585536371765LU},
    {6428840181375607058LU, 2396070679777328358LU},
    {14627739016581597989LU, 4177718888864439616LU},
    {151948907392237118LU, 13089542315088014739LU},
    {9502551226126066681LU, 6562025771505408984LU},
    {5387475472027932386LU, 15514241007989189387LU},
    {15633075482420559061LU, 14985471955213290157LU},
    {1290326138536790478LU, 4875796457248438910LU},
    {3857287619792723360LU, 8277385516211009842LU},
    {18202469134840195259LU, 18339350470538021345LU},
    {7974702911411716748LU, 16589227692090501191LU},
    {12083203499904513943LU, 7666708638334392468LU},
    {7618924078930097555LU, 6694228696263848299LU},
    {11574291237735547016LU, 15040885704223605176LU},
    {3645624014064691903LU, 14411876685090693150LU},
    {18125902329539272612LU, 4925844181830013133LU},
    {16132978310865996746LU, 8442415734972863361LU},
    {1655114471281491665LU, 17975031810652791634LU},
    {9570108391570150630LU, 16271105872860611316LU},
    {5608148646780379645LU, 7895879726442918439LU},
    {14704294825168190522LU, 9449772513662633068LU},
    {363623506646862113LU, 1114938166762747071LU},
    {10897627598640800534LU, 1712422274927449369LU},
    {6784630007341962765LU, 11213653764847429066LU},
    {8811335988072677987LU, 12316087007253964422LU},
    {12921910341471352696LU, 2789662977204852309LU},
    {2406091845232352591LU, 4471070670179399667LU},
    {16753346987744651348LU, 12849111986872665888LU},
    {17003303963144704987LU, 8015847525939817398LU},
    {2516422878410565312LU, 16385039415239613285LU},
    {12744024149408779511LU, 18147793657339509443LU},
    {8773049367149558252LU, 8612204640059607568LU},
    {6750860128377433474LU, 5112099269824186716LU},
    {10715224732801718425LU, 14604200939696961935LU},
    {469464150711546542LU, 15138352926256224297LU},
    {14958742119351158709LU, 6794633950402242810LU},
    {5646427565216537202LU, 12753342410927562417LU},
    {9748002291488403305LU, 4368950177767452258LU},
    {1544773536593036638LU, 2601692650937126852LU},
    {15883031242344886341LU, 12125460398735212311LU},
    {17871447348975445035LU, 11039211864259263579LU},
    {3539791059602084144LU, 1544295831556115592LU},
    {11756684218170538759LU, 996632828981259566LU},
    {7652703846519950876LU, 9334158917382184445LU},
    {17736363426448394772LU, 17046123221635747331LU},
    {4557580198782402319LU, 6976821922006138576LU},
    {12468277399279506744LU, 8676209102117543798LU},
    {7211326951217078307LU, 17597057319111077797LU},
    {4646652454142506061LU, 14213412276854287593LU},
    {9901100362305421654LU, 5268498510556486714LU},
    {1968136143960910689LU, 5883891186821479836LU},
    {15153424168479694458LU, 15995272465420651855LU},
    {6021248625330357181LU, 3696616649566599940LU},
    {11138591698484508326LU, 13767606394394086359LU},
    {622557869649812625LU, 12081730312484088433LU},
    {13958971426727881098LU, 3168200865124801186LU},
    {16561922621471702500LU, 1910323011371112942LU},
    {3228020435022711039LU, 10871563039160674621LU},
    {13761808919538852552LU, 10260673694361667739LU},
    {8637969880244738003LU, 159987803062073416LU},
    {8388021755970120796LU, 16093421487456556254LU},
    {13651469042218719559LU, 5983605776110527501LU},
    {3405915340228604784LU, 5454063001917474219LU},
    {16600200535152887403LU, 14406418400753743224LU},
    {13992750019374699013LU, 17769093591454266932LU},
    {804952028781733662LU, 8846714716701755111LU},
    {11032759905006292265LU, 7097506500290406209LU},
    {5766792486470694962LU, 17159331257887381394LU},
    {15115136369394394613LU, 42126770772140505LU},
    {1790251127380349166LU, 10144624519929647370LU},
    {10011432553244719833LU, 10696685628637098156LU},
    {4896608268019191746LU, 1742640942781235327LU},
    {7465773188566522796LU, 2979830419955499827LU},
    {12574119099636657847LU, 11891512550206895072LU},
    {4375178337163494528LU, 13672245733980443206LU},
    {17702592541657264539LU, 3594096106469237397LU},
    {4298629333949952927LU, 532542096954477418LU},
    {17490911132729312900LU, 10033633373494082489LU},
    {6956878582485413043LU, 10629639454290156063LU},
    {12218322610030139816LU, 2294945269743528652LU},
    {10232123118837206470LU, 3363109058349918592LU},
    {4964148043666569437LU, 11741290554048108883LU},
    {15479942221865898730LU, 13424035502525298933LU},
    {2290136437201037297LU, 3897471275747444774LU},
    {11388532202693655094LU, 15609761870506704493LU},
    {6275711279135870765LU, 6123870628841426622LU},
    {14204407236341474586LU, 5496339069596462872LU},
    {881525218554122241LU, 13842854764931604427LU},
    {2906001441507591279LU, 17397073712163626119LU},
    {16235423268394103156LU, 9021706269772950612LU},
    {8320453391397198659LU, 7316443575205776882LU},
    {13430807062296931928LU, 16849200929132772641LU},
    {13397022872235283927LU, 3799726805405372855LU},
    {8138064767403598028LU, 13323353274150035812LU},
    {16341251869637069563LU, 11555321373554327746LU},
    {3160460847764963296LU, 3171070436097716241LU},
    {1131467882852363150LU, 2122469261334426461LU},
    {14314752511360442005LU, 10460136663164224398LU},
    {6097813044255290530LU, 9913388668714672680LU},
    {11350257693848551865LU, 418331374683509499LU},
    {2035684737725619326LU, 16967783172465190064LU},
    {15374105917062211941LU, 7432334351109772387LU},
    {5146546573465355090LU, 9195862331815081413LU},
    {10265897406314886729LU, 17564914041842566422LU},
    {12256604809551045159LU, 14030539183430485594LU},
    {7134769132058892092LU, 5686680046029600393LU},
    {17380575747409427723LU, 6219917453364434735LU},
    {4048676785321347088LU, 15712159336887068668LU},
  },
  // Table 1
  {
    {0LU, 0LU},
    {9325725187317804330LU, 16305298596061862103LU},
    {14685320087738773326LU, 5245925065519071613LU},
    {5379300671158633060LU, 12287310319761775018LU},
    {6810153174805998471LU, 2145914956768195113LU},
    {16134470703695185581LU, 18415180288363391742LU},
    {10758601342317266121LU, 6127876565813998420LU},
    {1451737217396451811LU, 13205286288145116035LU},
    {13620306349611996942LU, 4291829913536390226LU},
    {4354609014724852260LU, 15692698610637094021LU},
    {8559566795651758144LU, 8305448725777376559LU},
    {17843843380475368810LU, 10451428890791329272LU},
    {16395225032702409865LU, 2758585448911001211LU},
    {7128120589145608611LU, 14123420882623237804LU},
    {2903474434792903623LU, 7963828502580680454LU},
    {12186906861034798829LU, 10145833134604849105LU},
    {12903348909141990151LU, 18105052632434440311LU},
    {3637297517494318637LU, 1804289642731675808LU},
    {8709218029449704521LU, 12938653147564636426LU},
    {17993844249350330723LU, 5892778500970324445LU},
    {17119133591303516288LU, 16610897451554753118LU},
    {7852238058268646826LU, 346158791691965065LU},
    {2765172360839012302LU, 12558435122053499683LU},
    {12048391489264562916LU, 5476527349777863668LU},
    {1014694209531923465LU, 13892960403290987557LU},
    {10340065337905930531LU, 2487600320965461234LU},
    {14256241178291217223LU, 9800097691536923992LU},
    {4950571394672201325LU, 7658650727691994511LU},
    {5806948869585807246LU, 15927657005161360908LU},
    {15131475306817850020LU, 4558321253753485019LU},
    {11194490629723211968LU, 10792633128249896817LU},
    {1887413204874356202LU, 8615153037645969318LU},
    {12625895930084885268LU, 8852241439534694461LU},
    {3338170980383010366LU, 10993695842745194730LU},
    {7274595034988637274LU, 3608579285463351616LU},
    {16545991941870633328LU, 15013929213861370263LU},
    {17418436058899409043LU, 7430562221419721236LU},
    {8129304000675726777LU, 9608049750584175299LU},
    {4212567280105424861LU, 3446359777091646313LU},
    {13483120028285119223LU, 14815685375913929662LU},
    {1314273746124297242LU, 4708194694277768303LU},
    {10616845416297265456LU, 11754061385976216760LU},
    {15704476116537293652LU, 692317583383930130LU},
    {6384451119693829758LU, 16993090211483909573LU},
    {5530344721678024605LU, 6670126170397447750LU},
    {14831508733576516279LU, 13752025989119135377LU},
    {9760153516487266515LU, 1467128272747140923LU},
    {439283811188833785LU, 17731876570202099692LU},
    {2029388419063846931LU, 9339176732872423498LU},
    {11331751168128464185LU, 7193204557248553117LU},
    {15556957944959760221LU, 14507834705373641015LU},
    {6237146243667712631LU, 3106956404369416672LU},
    {4804021632322040724LU, 11267084367801453155LU},
    {14105539690092650174LU, 9085087723824927412LU},
    {9901142789344402650LU, 15317301455383989022LU},
    {579923446938907120LU, 3952456418573800393LU},
    {11613897739171614493LU, 13408569936613170200LU},
    {2325963866245489207LU, 6367177277498590415LU},
    {7701268224806658131LU, 17499169960257805669LU},
    {16972878425056808313LU, 1193881552617670066LU},
    {18423764619509507226LU, 12093041414637809201LU},
    {9134986605046237616LU, 5015624288240383718LU},
    {3774826409748712404LU, 17230306075291938636LU},
    {13045029518642276094LU, 961050930776029083LU},
    {10910987642450326323LU, 8786431836732338345LU},
    {1585333960098979353LU, 11216113291181713534LU},
    {6676341960766020733LU, 3540647611780837844LU},
    {15982289941367615831LU, 15234242201890941187LU},
    {14549190069977274548LU, 7217158570926703232LU},
    {5224944045920318878LU, 9682864356293990999LU},
    {154714037386557434LU, 3235056190032806909LU},
    {9461506726463052496LU, 14892617653383650090LU},
    {3057540650182599741LU, 4782833399132214523LU},
    {12323309421044091159LU, 11540481801207614508LU},
    {16258608001351453555LU, 769355427458798982LU},
    {6974259911565583961LU, 16781892155462520145LU},
    {8425134560210849722LU, 6892719554183292626LU},
    {17692310439607771792LU, 13686392286098406917LU},
    {13772196702623621364LU, 1687335728665520047LU},
    {4488692771553693150LU, 17663839330988179320LU},
    {2628547492248594484LU, 9416389388555536606LU},
    {11894529577953068318LU, 6982183529046937609LU},
    {17273212035536734074LU, 14582929713992911267LU},
    {7988655052591393360LU, 2893835305217429876LU},
    {8861109616192766899LU, 11487114791605107447LU},
    {18127935843418664601LU, 9016875668707779104LU},
    {12768902239387659517LU, 15539436349258267530LU},
    {3485752347783168471LU, 3886366407493264221LU},
    {11060689443356049210LU, 13340252340794895500LU},
    {1735249078030946832LU, 6587102127180903515LU},
    {5959329529355145332LU, 17433255893116530161LU},
    {15265068618913168734LU, 1416192354863510822LU},
    {14410938580193580221LU, 11882125961631276709LU},
    {5086342906144668055LU, 5092942483550881394LU},
    {878567622377667571LU, 17017009066694647768LU},
    {10185714353031304921LU, 1035969996529780495LU},
    {4058776838127693863LU, 231609392035295380LU},
    {13346432486453976333LU, 16248663291891099715LU},
    {17554768391904747369LU, 5475130911697498601LU},
    {8283440717947302467LU, 12228289080207354174LU},
    {7408749302297680800LU, 2229569661282140861LU},
    {16697812059279980170LU, 18210599093854837354LU},
    {12474292487335425262LU, 6213912808738833344LU},
    {3203808971946072516LU, 13003104240373177111LU},
    {9608043264644081449LU, 4087424661893354694LU},
    {305402361542363651LU, 15776529224596343825LU},
    {5663870962494474343LU, 8103161138378053051LU},
    {14983965260717729101LU, 10537359558521081196LU},
    {15840327891289017518LU, 2701774236368676591LU},
    {6539094646595985796LU, 14354854330719272504LU},
    {1159846893877814240LU, 7904912837147600786LU},
    {10480785900421828298LU, 10375144521484402501LU},
    {10034665865845812000LU, 17903153161907538147LU},
    {732374617180046858LU, 1890606245482090548LU},
    {4651927732490978414LU, 12734354554997180830LU},
    {13971668001835215172LU, 5976713557793657161LU},
    {15402536449613316263LU, 16551595846806059722LU},
    {6101089892107349389LU, 575082057404113437LU},
    {2165230432426569705LU, 12501519462352141239LU},
    {11486378343018463939LU, 5707854134503334752LU},
    {3911172893595466798LU, 14121989234534542513LU},
    {13199178198473593092LU, 2428404248327959654LU},
    {18269973210092475232LU, 10031248576480767436LU},
    {8998291509439282762LU, 7601559132641309979LU},
    {7549652819497424809LU, 16013868076874325656LU},
    {16838502265778485891LU, 4356316216621434447LU},
    {11748059560256501991LU, 10876744119348813797LU},
    {2477784951094105549LU, 8411030345933883186LU},
    {16702942258247488381LU, 9187908613531619713LU},
    {7396991796155154007LU, 11369914070262909270LU},
    {3170667920197958707LU, 3985482508653875452LU},
    {12496319125491912985LU, 15350318767069038635LU},
    {13352683921532041466LU, 7081295223561675688LU},
    {4045889300854805968LU, 9227276213010119551LU},
    {8251438494496282548LU, 3064863860575265493LU},
    {17575682591117474462LU, 14465733382114654722LU},
    {6541980981776942195LU, 4903758798670706131LU},
    {15826327141979564377LU, 11981167146673106180LU},
    {10449888091840637757LU, 918984638878430382LU},
    {1184117395820856855LU, 17188248596149103737LU},
    {309428074773114868LU, 6470112380065613818LU},
    {9592929526638166750LU, 13511496259715358509LU},
    {14954189237999730874LU, 1227004263339525767LU},
    {5687010883554520464LU, 17532301484804234832LU},
    {6115081300365199482LU, 9565666798264429046LU},
    {15399640762645439824LU, 7388188081855000865LU},
    {11462117191721494324LU, 14703503225921317003LU},
    {2196137580918508062LU, 3334168848703746140LU},
    {747496590216373245LU, 11026994474253360095LU},
    {10030648411265699543LU, 8885548884867171080LU},
    {13948519823131167923LU, 15117040237215488674LU},
    {4681695521185194393LU, 3711681529352897141LU},
    {16850269120421699444LU, 13785439108366585252LU},
    {7544531962586051166LU, 6703530511249610099LU},
    {2455748969740628026LU, 17835084489074855129LU},
    {11781191262363082000LU, 1570345004374922254LU},
    {13212057475952899315LU, 11711722552650530701LU},
    {3904913226643200473LU, 4665847081487509338LU},
    {8977385543107386301LU, 16880934588266807024LU},
    {18301983694343714455LU, 580170773991138855LU},
    {5257094984497188969LU, 386034703401521596LU},
    {14528425124900437315LU, 16650782176015141227LU},
    {9455387513299582759LU, 5590723649933775041LU},
    {167734335584014861LU, 12672622643818317846LU},
    {1618606683469003758LU, 1773480150376457109LU},
    {10889092115414095556LU, 18074251953907727170LU},
    {15977310105182786720LU, 5787670610434859752LU},
    {6688249269189638538LU, 12833536477560404543LU},
    {17722219232385533799LU, 4527485509500663278LU},
    {8402126853003946573LU, 15896812482517445945LU},
    {4484816320520284201LU, 8510001302994351251LU},
    {13787459146620192003LU, 10687490206349110340LU},
    {12354357041041566944LU, 2527379612034287559LU},
    {3033420502960783818LU, 13932730914891046672LU},
    {6971504695566336942LU, 7772732814986528442LU},
    {16272740413147623044LU, 9914188592659963501LU},
    {18150935310226443118LU, 18309782264180500939LU},
    {8831192572280563268LU, 2040525745335873820LU},
    {3470498156061893664LU, 13174204254361807030LU},
    {12772786931961039114LU, 6096785753639858273LU},
    {11918659058710290665LU, 16419767712523508706LU},
    {2597509229406752195LU, 114477930290414389LU},
    {7974513282632961959LU, 12327476639996926623LU},
    {17275957916993938061LU, 5286082606285193800LU},
    {5107116101351414880LU, 14237793103565196697LU},
    {14378795885302067530LU, 2872948891462128974LU},
    {10172685812289336110LU, 10185884967101762788LU},
    {884678586552081924LU, 8003889147828163635LU},
    {1757135244755335143LU, 15587274059679743920LU},
    {11027407387593562829LU, 4186396583110010727LU},
    {15253170641875376297LU, 10420302738012913357LU},
    {5964318724845188483LU, 8274331386827728410LU},
    {8117553676255387726LU, 463218784070590760LU},
    {17423575569892887908LU, 16439723760717773311LU},
    {13505139554512637696LU, 5665785660796428373LU},
    {4179416848685605418LU, 12459459767040260226LU},
    {3325308215944612809LU, 1993543564286317313LU},
    {12632174268301223651LU, 18006081666887191510LU},
    {16566881435894604935LU, 6009834086705156732LU},
    {7242565838606125485LU, 12767483863373515435LU},
    {14817498604595361600LU, 4459139322564281722LU},
    {5533223944930007658LU, 16116699961212198317LU},
    {463563625157842958LU, 8444054254204650503LU},
    {9729262889628267812LU, 10909759214864817360LU},
    {10601704705359862983LU, 2316497130878285651LU},
    {1318274754166288877LU, 14010090896549703556LU},
    {6407617943892145033LU, 7559464407036802606LU},
    {15674724866653789859LU, 9989145037051686649LU},
    {14102669807825156937LU, 18244010031291930975LU},
    {4818041113023010403LU, 2262971785964208520LU},
    {610804723084727303LU, 13106314375483136034LU},
    {9876853635397531949LU, 6317131722244079861LU},
    {11327741924988948686LU, 16206322276756106102LU},
    {2044520871283506660LU, 189259563075990433LU},
    {6266905751128113024LU, 12116135673226406411LU},
    {15533799354718114474LU, 5362986284181123804LU},
    {9129837745484966983LU, 14312469196589169933LU},
    {18435505601806598509LU, 2659397880633861594LU},
    {13078189293191971593LU, 10262964587728993392LU},
    {3752816233095622179LU, 7792724090637165735LU},
    {2319693787755628480LU, 15809825674295201572LU},
    {11626768735417101034LU, 4120729891056785395LU},
    {17004899388491376782LU, 10640472798111354457LU},
    {7680370469915362724LU, 8206265564144014990LU},
    {16113713970058945370LU, 8986042140625051925LU},
    {6842314592566201968LU, 11456272450771548610LU},
    {1464749234360093716LU, 3781212490964181096LU},
    {10752471717616197950LU, 15434291211120277695LU},
    {9303855464981956829LU, 7021965036284810044LU},
    {33300795813144055LU, 9456162081964903403LU},
    {5391182107236132755LU, 3007915210635547201LU},
    {14680312248904043193LU, 14697018398879795862LU},
    {7105102470401111124LU, 5132820611430532423LU},
    {16425125544246352254LU, 11922012867902021008LU},
    {12202179784214698778LU, 1150164114808226874LU},
    {2899606195200095792LU, 17131194372222262509LU},
    {4330460864853139411LU, 6556294850994730862LU},
    {13651328097263350521LU, 13309453844077490105LU},
    {17858003864714653853LU, 1311082282451629587LU},
    {8556837384352898487LU, 17328137006876143300LU},
    {7822345787190933597LU, 9797234395359533410LU},
    {17142159961249568119LU, 7331519797241676213LU},
    {12052251476649187091LU, 14932671702049609759LU},
    {2749891196186245689LU, 3275119017089597640LU},
    {3606266436374664154LU, 11110686558346898251LU},
    {12927487701925183216LU, 8680996290068755356LU},
    {17996583018878565524LU, 15203118265282619958LU},
    {8695066879819567550LU, 3509532454641545953LU},
    {15099305638994849619LU, 13580992080039099696LU},
    {5827697359603794553LU, 6787328126514816487LU},
    {1893551072187039773LU, 17632759513373916237LU},
    {11181486861815737655LU, 1656247098300687514LU},
    {10306773902471742676LU, 11654948735791795993LU},
    {1036573264327338494LU, 4897309113185425358LU},
    {4955569902188211098LU, 16822060691867766372LU},
    {14244350382975616688LU, 809515150035277491LU},
  },
  // Table 2
  {
    {0LU, 0LU},
    {469066376209699809LU, 8311775996196688849LU},
    {938132752419399618LU, 16623551992393377698LU},
    {830526720335492131LU, 10802979151249945715LU},
    {1876265504838799237LU, 14800359911077203780LU},
    {2056914587650055268LU, 13707880669858520213LU},
    {1661053440670984263LU, 3159214228790339814LU},
    {1265311590168492966LU, 6381201142541744951LU},
    {3752531009677598475LU, 11153975748444855944LU},
    {3643938146581187818LU, 16831005018668436825LU},
    {4113829175300110537LU, 8969017266007488810LU},
    {4581626146007395112LU, 1090158726156167931LU},
    {3322106881341968526LU, 6318428457580679628LU},
    {2925101122895725423LU, 2663541696917979677LU},
    {2530623180336985932LU, 12762402285083489902LU},
    {2710288730670097581LU, 13998442706521875903LU},
    {7505062019355196951LU, 3861207423180160272LU},
    {7972817502826540534LU, 5101627895226117825LU},
    {7287876293162375637LU, 15215265963627322034LU},
    {7179240843316824628LU, 11564724859455211875LU},
    {8227658350600221074LU, 17938034532014977620LU},
    {8407365976580055667LU, 10063838067470197125LU},
    {9163252292014790224LU, 2180317452312335862LU},
    {8766287509704164785LU, 7861973304280958503LU},
    {6644213762683937052LU, 12636856915161359256LU},
    {6536561806662873853LU, 15854498430069878857LU},
    {5850202245791450846LU, 5327083393835959354LU},
    {6319221598550791487LU, 4230223810002261995LU},
    {5061246360673971865LU, 7078060496457428188LU},
    {4665550945210006904LU, 1252861331350880013LU},
    {5420577461340195163LU, 9550141339334200190LU},
    {5601271879678876346LU, 17857254968082684079LU},
    {15010124038710393902LU, 7722414846360320544LU},
    {15477984798272483279LU, 1761711575870106097LU},
    {15945635005653081068LU, 10203255790452235650LU},
    {15836965193922070541LU, 18356781130779610707LU},
    {14575752586324751275LU, 11983787853545092452LU},
    {14755213644674441290LU, 15354930245264090805LU},
    {14358481686633649257LU, 4682705645200872134LU},
    {13961693648670099336LU, 3721402392915607831LU},
    {16455316701200442149LU, 17429324990320403624LU},
    {16347910763053445316LU, 9419342946019243897LU},
    {16814731953160111335LU, 1680932061230842634LU},
    {17283576210840606470LU, 7208718150271422683LU},
    {18326504584029580448LU, 4360634904624671724LU},
    {17930703342718795585LU, 5754837728927594557LU},
    {17532575019408329570LU, 15723946608561917006LU},
    {17713305448900696195LU, 12209243311518949279LU},
    {13288427525367874105LU, 6826969756613166896LU},
    {13757246784191353304LU, 3307639843465417953LU},
    {13073123613325747707LU, 13262252786430206098LU},
    {12965693775832839706LU, 14651793569786327875LU},
    {11700404491582901692LU, 10654166787671918708LU},
    {11881158300728827485LU, 16177607185862171557LU},
    {12638443197101582974LU, 8460447620004523990LU},
    {12242666434957556127LU, 446085559455529991LU},
    {10122492721347943730LU, 14156120992914856376LU},
    {10013793482648637139LU, 13199480073718057577LU},
    {9331101890420013808LU, 2505722662701760026LU},
    {9798934322524907793LU, 5881491412743613899LU},
    {10841154922680390327LU, 653538604958848764LU},
    {10444394632352137558LU, 8811444253541500205LU},
    {11202543759357752693LU, 17267765862455816542LU},
    {11382033664855942804LU, 11311408025168224911LU},
    {7603948678036606279LU, 6488093414460179603LU},
    {7999750196439506598LU, 2977735524814378818LU},
    {7242436696056425093LU, 13598881737691849521LU},
    {7061706543657220452LU, 14979450480357765344LU},
    {8327000130860352194LU, 10911982725988813783LU},
    {8434406346100511011LU, 16444465516366469126LU},
    {9118549291463222528LU, 8204887885851864181LU},
    {8649705310874842849LU, 181483415943987108LU},
    {6743309328584069708LU, 13889302792303270427LU},
    {6563848543031509421LU, 12941633896549697994LU},
    {5805675243343902094LU, 2770293467850210745LU},
    {6202463554105632367LU, 6137090177277357672LU},
    {5160238496243817929LU, 983411589810197855LU},
    {4692378009479908904LU, 9150359630638974606LU},
    {5375102603635374603LU, 16940149086340494077LU},
    {5483772688163514858LU, 10974748839618519340LU},
    {117640243621753680LU, 8043311442846448003LU},
    {514400261286027441LU, 2073565814528567890LU},
    {911165187963442322LU, 9884606589160807969LU},
    {731675009802323827LU, 18047174304487329264LU},
    {1992883124259863765LU, 11743951626535319239LU},
    {2101582090296241972LU, 15106122029112108310LU},
    {1633907676951812887LU, 4920285663743054181LU},
    {1166074972182939894LU, 3967954417788256948LU},
    {3869254260590242907LU, 17678164540540512011LU},
    {3688500174485389242LU, 9659140138352964826LU},
    {4086648305583115161LU, 1434339902170513577LU},
    {4482424790769260664LU, 6971168366285738872LU},
    {3439500755966993374LU, 4048740535805061199LU},
    {2970681220185632831LU, 5433971371024497566LU},
    {2503831459350414364LU, 16033584772948856813LU},
    {2611261019884394493LU, 12527853482160856124LU},
    {13386962263027364201LU, 3540341640808971955LU},
    {13783968294270739080LU, 4789734119109897570LU},
    {13028035782639621803LU, 15533875541565839633LU},
    {12848370505104688458LU, 11874362448310241984LU},
    {11799957455393423084LU, 18177831131636920823LU},
    {11908550591288012045LU, 10312677042166784550LU},
    {12593529167635306798LU, 1942768243850171989LU},
    {12125732469725153999LU, 7615381737932408196LU},
    {10221940053651140194LU, 12388048175021269051LU},
    {10041291247931997571LU, 15614661696260256746LU},
    {9286222966933719456LU, 5573635925508458393LU},
    {9681965094529374785LU, 4467804352532550728LU},
    {10939936029318767079LU, 7389915241924128639LU},
    {10470869930202231302LU, 1573758451816725678LU},
    {11157280085186496037LU, 9240533989062199517LU},
    {11264886394362516932LU, 17538605259983018764LU},
    {15127412361293401982LU, 338915969809253283LU},
    {15523107499798437023LU, 8641649556571558002LU},
    {15919019207600187580LU, 16286892231320151041LU},
    {15738324512303627101LU, 10475361782422845392LU},
    {14692581389279379707LU, 14542513158376934631LU},
    {14800233068342563610LU, 13441061876543545142LU},
    {14331124893983008569LU, 3414813586027473733LU},
    {13862105264264738008LU, 6645772523222104212LU},
    {16572391718532911221LU, 11420833572140916011LU},
    {16392683819889099668LU, 17088820433005612794LU},
    {16787199162421196727LU, 8704415646475664009LU},
    {17184163672068891734LU, 834599498811746648LU},
    {18443687429739896816LU, 5988524662917747311LU},
    {17975931673605622801LU, 2324665861564842430LU},
    {17505994481972148274LU, 13090058688855078349LU},
    {17614629659153722323LU, 14335071133795411484LU},
    {15207897356073212558LU, 12976186828920359206LU},
    {15388583805100460399LU, 14361399840276650743LU},
    {15999500392879013196LU, 5955471049628757636LU},
    {15603795908591464109LU, 2449757427547159893LU},
    {14484873392112850187LU, 8751019401674147426LU},
    {14953902367746803434LU, 731977862851777971LU},
    {14123413087314440905LU, 11512156887005979072LU},
    {14015769654655836456LU, 17049002607477191185LU},
    {16654000261720704389LU, 3377221378268075950LU},
    {16257027505803695716LU, 6739373820079637631LU},
    {16868812692201022023LU, 14442186959023386636LU},
    {17048511245062320550LU, 13489873794628723677LU},
    {18237098582926445056LU, 16409775771703728362LU},
    {18128472751660554721LU, 10440012594971036475LU},
    {17299410621749685698LU, 362966831887974216LU},
    {17767174624288538147LU, 8525551941546306713LU},
    {13486618657168139417LU, 9331861510896989238LU},
    {13666293280619804536LU, 17498792019417081831LU},
    {13127697086063018843LU, 7436523719389844372LU},
    {12730699301223174330LU, 1471140885253292101LU},
    {11611350486687804188LU, 5540586935700421490LU},
    {12079138938327595261LU, 4592900095287748771LU},
    {12404927108211264734LU, 12274180354554715344LU},
    {12296324626535210815LU, 15640995163795607297LU},
    {10320476992487635858LU, 1966823179620395710LU},
    {9924744210808711283LU, 7499288849469356399LU},
    {9384756018959817808LU, 18300719261277949212LU},
    {9565413071082491825LU, 10277332065979670221LU},
    {10750205207270749207LU, 15433554098971436538LU},
    {10642590651824367606LU, 11923178401568618027LU},
    {10967545376327029717LU, 3502753605527487064LU},
    {11436602129662099508LU, 4883340035153416585LU},
    {235280487243507360LU, 16086622885692896006LU},
    {414778911809205569LU, 12422746861268951255LU},
    {1028800522572054882LU, 4147131629057135780LU},
    {632049850823463555LU, 5392161177345247093LU},
    {1822330375926884645LU, 1322469104612064322LU},
    {2290153734913243844LU, 6990438330055307155LU},
    {1463350019604647655LU, 17647604535265106912LU},
    {1354642807298956550LU, 9777806178177288241LU},
    {3985766248519727531LU, 5041159179361086862LU},
    {3589998009738160714LU, 3939690536480833119LU},
    {4203164180592483945LU, 11765499984514665004LU},
    {4383927612613021064LU, 14996476436837063165LU},
    {3267815353903625774LU, 9840571327486108362LU},
    {3160376447587132879LU, 18143286865973227803LU},
    {2332149944365879788LU, 7935908835576513896LU},
    {2800961233877926413LU, 2124396314157389497LU},
    {7738508521180485815LU, 16909585007371472406LU},
    {7919229327798225750LU, 11093410152882757063LU},
    {7377000348970778485LU, 871536202996378036LU},
    {6981190584297516180LU, 9169625383141767781LU},
    {8173296611166230322LU, 2868679804341027154LU},
    {8642148838158140627LU, 6095275948427022979LU},
    {8964849581538521328LU, 13942336732571477744LU},
    {8857452712215094033LU, 12836522656469726497LU},
    {6879001511933986748LU, 8097481071610122398LU},
    {6482203855390790749LU, 232309330612405071LU},
    {5941362440371265662LU, 10867942742048995132LU},
    {6120814979653464991LU, 16540574008453719277LU},
    {5007662918700828729LU, 13620425472188162010LU},
    {4899001080576220120LU, 14869800711311920139LU},
    {5222522039768788987LU, 6608962890612160632LU},
    {5690391872449428506LU, 2949466882450729897LU},
    {13442093815224915913LU, 17158428425041857973LU},
    {13549532998633505832LU, 11333211178374127204LU},
    {13226794889505337355LU, 624948976605325847LU},
    {12757983877086438378LU, 8932080566117988806LU},
    {11565873391437649996LU, 2556790398523900657LU},
    {11961641907312364461LU, 5774414519099560224LU},
    {12503917083279933326LU, 14251978726022423891LU},
    {12323153928351493231LU, 13155136690602489474LU},
    {10275035157837400258LU, 8418382631098733373LU},
    {9807212071648189219LU, 544168497846501612LU},
    {9483640517139001088LU, 10549297369821574303LU},
    {9592348002242886881LU, 16230971045652293454LU},
    {10705504367222458183LU, 13380593112628665465LU},
    {10526006215454954662LU, 14620996328317587368LU},
    {11066889394130395269LU, 6846547841823620059LU},
    {11463640338676134756LU, 3196023874285283338LU},
    {15180718724165790174LU, 15819799756707000485LU},
    {15289380289626438207LU, 12164895721433654132LU},
    {16116225804028595740LU, 4411698571050276615LU},
    {15648355698685042173LU, 5647756113016308950LU},
    {14458079510894585435LU, 1652338256104439777LU},
    {14854876894774867386LU, 7329349839366958128LU},
    {14240804724124647833LU, 17319982791852333123LU},
    {14061351912178487928LU, 9441142059756981138LU},
    {16627030537034102485LU, 4702279003849125421LU},
    {16158178033083245876LU, 3609782350043971068LU},
    {16986450698006909207LU, 12102123968478857615LU},
    {17093847290372440822LU, 15324128414537898590LU},
    {18209955057015798096LU, 10098382337428693353LU},
    {18029233973440162481LU, 18410140233810588344LU},
    {17416030401408736914LU, 7680345238268544715LU},
    {17811839889123052915LU, 1859790341783164186LU},
    {7693631758198549479LU, 9598715471437739925LU},
    {7802257862261585926LU, 17756603604891575364LU},
    {7476449918816128037LU, 7171917171483709495LU},
    {7008686189075472324LU, 1215576695241933798LU},
    {8128030699449672802LU, 5210678173740038353LU},
    {8525003728164878211LU, 4254019327064009472LU},
    {9063628527675687840LU, 12601832924967329651LU},
    {8883930247611535425LU, 15977619723283319970LU},
    {6833911443703608556LU, 2305734182132197661LU},
    {6364882745161754381LU, 7829157476973624012LU},
    {6039895017528496942LU, 17964055666845748927LU},
    {6147538727280246991LU, 9949710829366746478LU},
    {4962751049737861993LU, 15175703483115857497LU},
    {4782064877803759752LU, 11656355779390961032LU},
    {5322077241122512043LU, 3758348034390311419LU},
    {5717782002502160202LU, 5147906453166838314LU},
    {207749934314132976LU, 12727383021449546373LU},
    {315364212801570321LU, 14121568073428932948LU},
    {1145877700141494834LU, 6202027448751533351LU},
    {676820669848527315LU, 2687341803235098358LU},
    {1795747678258977397LU, 9062877976204854721LU},
    {2191480182980004244LU, 1052878846808479248LU},
    {1580530627500178871LU, 11202554499736461923LU},
    {1399873298418560598LU, 16730357827953160626LU},
    {3959148290236156667LU, 3056359424960893965LU},
    {3491359565932402970LU, 6427483907454273500LU},
    {4320450265359658297LU, 14760801499964388271LU},
    {4429052474372800216LU, 13799516312059388030LU},
    {3240460799061476734LU, 16649577303994948425LU},
    {3060785902946899615LU, 10688856536629528728LU},
    {2448980907558527676LU, 125421490876087531LU},
    {2845978419734409565LU, 8278964208355405626LU},
  },
  // Table 3
  {
    {0LU, 0LU},
    {7998784087690674182LU, 16461784756912824991LU},
    {15997568175381348365LU, 14476825440116098366LU},
    {12755219717378703371LU, 3214450890929858465LU},
    {8439307433835148544LU, 2129446439718042287LU},
    {1882243897948058886LU, 18012518643285858352LU},
    {12329930106842494221LU, 15376789172667318161LU},
    {14131686112256865547LU, 3535702070140263694LU},
    {16878614867670297088LU, 4258892879436084574LU},
    {9600972316742052358LU, 16099984418524944321LU},
    {3764487795896117773LU, 17578293212862165088LU},
    {6575050994553973259LU, 1695225445864542975LU},
    {11466889978652647168LU, 2780956017123872753LU},
    {17303938152947932934LU, 14043335003142483310LU},
    {4692844069882224397LU, 17185723852459739855LU},
    {3323998949026127627LU, 723943532387674192LU},
    {2117318601375637787LU, 18043699768563292783LU},
    {8242530369737056541LU, 2169639166595954928LU},
    {14078531109497430294LU, 3638940789728747345LU},
    {12421383848308826384LU, 15489039493847891406LU},
    {7528975591792235547LU, 16709842352014778560LU},
    {539632432132215837LU, 257069196702433887LU},
    {13150101989107946518LU, 3390450891729085950LU},
    {15672508740240036880LU, 14661837042507417441LU},
    {17824922726122326811LU, 13939408122691530545LU},
    {10979700544692980509LU, 2668026339755527598LU},
    {2980291929838455574LU, 692074245702576655LU},
    {5070345128638778128LU, 17144851768865638544LU},
    {9385688139764448795LU, 15924703631209928094LU},
    {17096167886958378525LU, 4074609295203677953LU},
    {6647997898052255254LU, 1447887064775348384LU},
    {3693810834085723664LU, 17321952034863968831LU},
    {4234637202751275575LU, 17640655463417033950LU},
    {6180372065829077553LU, 1199136910220203585LU},
    {16485060739474113082LU, 4339278333191909856LU},
    {10072248722882708028LU, 15585890289062597503LU},
    {5753917505641543479LU, 16815705363006066289LU},
    {2367599020231358257LU, 948395761339542766LU},
    {10509363050574346042LU, 2428960713691024207LU},
    {18363886788176574268LU, 14249781621096212944LU},
    {15057951183584471095LU, 14972940630320005504LU},
    {13833357582089070641LU, 3152115294932460319LU},
    {1079264864264431674LU, 514138393404867774LU},
    {7060291896153942076LU, 16381443567097423393LU},
    {11954497038340005175LU, 15152293246708874031LU},
    {14620799886978620721LU, 3905676862589458864LU},
    {8927296408294530362LU, 1922973699780427281LU},
    {1505683829893733692LU, 18364487824736918670LU},
    {2857056866955338540LU, 1060646060776877745LU},
    {5235203303703257898LU, 16918944069441244206LU},
    {17988653901632873249LU, 14289974326767692687LU},
    {10855340681549587239LU, 2460141826351958288LU},
    {5960583859676911148LU, 1384148491405153310LU},
    {4447688151336588842LU, 17816655451599828609LU},
    {10140690257277556257LU, 15842959464021725472LU},
    {16409880848135001639LU, 4587335915140494271LU},
    {14815343997595928876LU, 3864804792148663279LU},
    {11717186873136924970LU, 15120423981767014768LU},
    {1411996825675155745LU, 18251558159985073873LU},
    {8978216258549926183LU, 1819046840535907406LU},
    {13295995796104510508LU, 2895774129550696768LU},
    {15530027817335847978LU, 14725602270437180383LU},
    {7387621668171447329LU, 16197159996018386046LU},
    {686651039659588647LU, 338857627833157345LU},
    {8469274405502551151LU, 16834566853124516284LU},
    {1912212952498308201LU, 996535048041122595LU},
    {12360744131658155106LU, 2398273820440407170LU},
    {14162498062494401636LU, 14212343727405567517LU},
    {42389844596830575LU, 17594777718473380627LU},
    {8041171539814429033LU, 1178033360315543948LU},
    {16038547707034612066LU, 4378960176450180653LU},
    {12796201632629895524LU, 15614317530345092274LU},
    {11507835011283086959LU, 15184666652302580962LU},
    {17344885294231285353LU, 3949313666520563325LU},
    {4735198040462716514LU, 1896791522679085532LU},
    {3366350802078559844LU, 18313540248958204739LU},
    {16909463666990668655LU, 14931567601794033229LU},
    {9631818766539283305LU, 3117502062671201490LU},
    {3794490366097972066LU, 567332152406926195LU},
    {6605055922583690084LU, 16405368325341037036LU},
    {7560086096178832756LU, 1425525669001835475LU},
    {570744942444569970LU, 17851281628760150348LU},
    {13179807678176224633LU, 15789752244728723181LU},
    {15702212415077836159LU, 4563406492425901170LU},
    {2158529728528863348LU, 1028276786809735548LU},
    {8283739182078939250LU, 16875320193493609443LU},
    {14120583792307884153LU, 14316143060485295170LU},
    {12463438854805770367LU, 2511084755112226525LU},
    {9427776696524115828LU, 2941655988940588685LU},
    {17138258492593737586LU, 14746718731146028050LU},
    {6689243524295397241LU, 16157464657836180403LU},
    {3735054420328320895LU, 310425687993065772LU},
    {17854592816589060724LU, 3845947399560854562LU},
    {11009368346118437490LU, 15072297588425481917LU},
    {3011367659787467385LU, 18282231575764285724LU},
    {5101423139324344959LU, 1856480052576164739LU},
    {5714113733910677080LU, 2121292121553755490LU},
    {2327797597939746398LU, 17943561333332082685LU},
    {10470406607406515797LU, 15391144065172936796LU},
    {18324927987231213139LU, 3597340361909091011LU},
    {4202682326987305816LU, 71221635118983117LU},
    {6148415081328309086LU, 16467699798161245522LU},
    {16451695826181354325LU, 14417433881322169075LU},
    {10038885927168340819LU, 3197839129326452844LU},
    {11921167719353822296LU, 2768296982810306620LU},
    {14587472960381627486LU, 13987887375276772003LU},
    {8895376302673177685LU, 17186566829490105602LU},
    {1473761340724784211LU, 790084306926981021LU},
    {15018958870762395992LU, 4316602598811275923LU},
    {13794363186300262750LU, 16110401942812241932LU},
    {1039426597738617173LU, 17514396937650558893LU},
    {7020455704256584019LU, 1692123366617740594LU},
    {5921853243599562563LU, 16652146092930533133LU},
    {4408959824384403269LU, 246656336886113682LU},
    {10100555101296666446LU, 3454343017869984307LU},
    {16369743411367225160LU, 14664926176855154860LU},
    {2823993651350311491LU, 18056372246260596130LU},
    {5202138039306424901LU, 2225091441480113981LU},
    {17956432517099852366LU, 3638093681071814812LU},
    {10823121336966779464LU, 15422885791325116931LU},
    {13263739641361747267LU, 15853495491014881875LU},
    {15497773977488313669LU, 4068698952512852172LU},
    {7354522858326936910LU, 1507274509123041133LU},
    {653549906078256456LU, 17338550885663184370LU},
    {14775243336342894659LU, 13947575918327220476LU},
    {11677084206042019909LU, 2736988331359693411LU},
    {1373302079319177294LU, 677715255666314690LU},
    {8939523526374094920LU, 17083200583736766301LU},
    {16938548811005102303LU, 15222389632539480952LU},
    {9516303760164030681LU, 3978025083819028967LU},
    {3824425904996616402LU, 1993070096082245190LU},
    {6490378271538645204LU, 18436836056433505497LU},
    {11389499020836453855LU, 14901737137208027607LU},
    {17370034927659400665LU, 3078660035148860232LU},
    {4615457879127670226LU, 442934894125034729LU},
    {3390090956005391828LU, 16307988301133385334LU},
    {84779689193661151LU, 16742811363237209638LU},
    {7938809381156020953LU, 877753596699608249LU},
    {16082343079628858066LU, 2356066720631087896LU},
    {12695249795118588628LU, 14179139463169393031LU},
    {8373110659734362079LU, 17714691960997780617LU},
    {1959664487079958489LU, 1270921641383640598LU},
    {12263729183451240402LU, 4413314819760380343LU},
    {14209110850008668116LU, 15657675009226341160LU},
    {17758795500896741828LU, 2965853378528774423LU},
    {11057051584815491522LU, 14797933286095268744LU},
    {2914160005700807113LU, 16267239238287543337LU},
    {5147700867271223759LU, 411188636778131126LU},
    {9470396080925433028LU, 3793583045358171064LU},
    {17036264928322149570LU, 15046950399585947943LU},
    {6732701604157119689LU, 18180336424206857862LU},
    {3633912110102437071LU, 1745573269354533913LU},
    {2039858645379580868LU, 1311237354650074185LU},
    {8308696142494139330LU, 17745996081253670614LU},
    {14001075370941416393LU, 15770048316795435383LU},
    {12487545403223737295LU, 4516676534327319528LU},
    {7588980732195944132LU, 1134664304813852390LU},
    {454892678351107778LU, 16990710478340908153LU},
    {13210111845167380169LU, 14363992576972522456LU},
    {15587764270400026319LU, 2531908241432060231LU},
    {15120172192357665512LU, 2851051338003670950LU},
    {13750835190285880046LU, 14115682090433824057LU},
    {1141489884889139941LU, 17255819183810749080LU},
    {6977765493169801955LU, 796290630146031623LU},
    {11874819151819800552LU, 4187688320970611977LU},
    {14684750358838837230LU, 16026528024937365398LU},
    {8847623169281523685LU, 17507088648228837431LU},
    {1569629654918365155LU, 1621769046096525992LU},
    {4317059457057726696LU, 2056553573619471096LU},
    {6118180825137881326LU, 17941877543864676455LU},
    {16567478364157878501LU, 15303896313277667270LU},
    {10010062112484761827LU, 3465060977432196441LU},
    {5690078028284302824LU, 74037631653718103LU},
    {2447236280321152494LU, 16533570553160764104LU},
    {10445519544890365413LU, 14550863060757540201LU},
    {18443528077264721379LU, 3286236676178104310LU},
    {14751433323169819635LU, 15994781746384027081LU},
    {11796895330429840373LU, 4146939245508271958LU},
    {1348081573032274942LU, 1517965173240527095LU},
    {9057929294462790648LU, 17394281978455448168LU},
    {13378487048590794483LU, 13868185241962809190LU},
    {15467767578599005941LU, 2594551692623652345LU},
    {7470108840656641790LU, 620851375986131544LU},
    {624394881325965048LU, 17071377132733456583LU},
    {2777450728467775987LU, 16636932280344201367LU},
    {5299082027665015285LU, 186410960429246984LU},
    {17909051860762477054LU, 3317540809587297705LU},
    {10919215308297355768LU, 14591178795767213878LU},
    {6022735319574934771LU, 18117719077819019832LU},
    {4365235308542817525LU, 2241406709165904039LU},
    {10202846278648689918LU, 3712960105152329478LU},
    {16327423444270249208LU, 15560807042598278553LU},
    {11428227467821354160LU, 4242584243107510980LU},
    {17408765423167671478LU, 16038635353521592411LU},
    {4655595195879492797LU, 17440378592954613754LU},
    {3430226232538565819LU, 1620356788330716517LU},
    {16971614195434142128LU, 2841208025074270315LU},
    {9549366855199472054LU, 14058546582416007924LU},
    {3856645129564010941LU, 17259477865049605461LU},
    {6522599776624490939LU, 860743507349170122LU},
    {8405364653974611632LU, 142443270237966234LU},
    {1991920486893643446LU, 16541173199956045061LU},
    {12296830162656618173LU, 14488655522612939428LU},
    {14242209814765463227LU, 3271312537297233979LU},
    {124882510680773552LU, 2051212778088232245LU},
    {7978909887479468982LU, 17871230154463401898LU},
    {16121035657429275581LU, 15321064711232270347LU},
    {12733944696387392443LU, 3525009172577850004LU},
    {9510197623165349291LU, 13873539532417458347LU},
    {17076068579567300013LU, 2665203780583047732LU},
    {6771660285137382822LU, 603678863584765333LU},
    {3672868673772744096LU, 17011416026784139018LU},
    {17790752605346355371LU, 15926389585270659588LU},
    {11089006340094285997LU, 4139341280363903131LU},
    {2947522681449568422LU, 1580168613853962042LU},
    {5181065901065951392LU, 17409193223976795557LU},
    {7622307813101242283LU, 18127575851039888885LU},
    {488221842491574189LU, 2298546881654175594LU},
    {13242034180011231142LU, 3709297274843287755LU},
    {15619684530883856288LU, 15496341220495553108LU},
    {2078853195477234347LU, 16582049801591566170LU},
    {8347688300471038637LU, 174308278862941637LU},
    {14040911408513168038LU, 3384246733235481188LU},
    {12527383824611521184LU, 14592578125549029627LU},
    {11843706487199125127LU, 14857548112151514650LU},
    {14653640009297940097LU, 3045734408430267525LU},
    {8817919648768806538LU, 493312673772227364LU},
    {1539923810987593356LU, 16333600682103728571LU},
    {15078963225706953607LU, 15257576560762041525LU},
    {13709624217977846657LU, 4019971808306828842LU},
    {1099435032717818762LU, 1969701424434082187LU},
    {6935712655497395084LU, 18384198384027423508LU},
    {5647987302700622983LU, 17666000418811640644LU},
    {2405147844047185025LU, 1251507895780104667LU},
    {10404276078612849802LU, 4450182882960227962LU},
    {18402282330519086220LU, 15687792071985634533LU},
    {4287391535683441031LU, 16764488574744019435LU},
    {6088510855156339073LU, 924205003244888948LU},
    {16536400473437933962LU, 2328195531584767189LU},
    {9978986262033797516LU, 14140013672146773578LU},
    {13348517839647813532LU, 3771909948298122357LU},
    {15437800761860665242LU, 15000511903844333290LU},
    {7439297044795043729LU, 18208194118329766219LU},
    {593580701598003095LU, 1784694361819034580LU},
    {14709045716653873820LU, 3014549018246082266LU},
    {11754505640762612378LU, 14817359925058325573LU},
    {1307099812156512913LU, 16230357697616817124LU},
    {9016949607896717975LU, 381066892367923579LU},
    {5981788058258851228LU, 1099481525661475115LU},
    {4324290396481439130LU, 16948776698752697268LU},
    {10160494545612195217LU, 14387347788329214997LU},
    {16285069353137456535LU, 2584541249367688842LU},
    {2746604158638354588LU, 1355430511332629380LU},
    {5268233348914245786LU, 17778934635956255003LU},
    {17879047052748189841LU, 15719657093763980986LU},
    {10889212617542693015LU, 4491059506339052581LU},
  },
  // Table 4
  {
    {0LU, 0LU},
    {2249652845203596452LU, 3088568997046785571LU},
    {4499305690407192904LU, 6177137994093571142LU},
    {2398415257225915884LU, 9179839505019320933LU},
    {8998611380814385808LU, 12354275988187142284LU},
    {7194819298453632564LU, 9344962276333604527LU},
    {4796830514451831768LU, 18359679010038641866LU},
    {6749097761421492092LU, 15282512244933288681LU},
    {17997222761628771617LU, 6261807902664732952LU},
    {16643797790366597509LU, 8951647803723130683LU},
    {14389638596907265129LU, 243180478957657438LU},
    {15603313852960655565LU, 2991303266879835005LU},
    {9593661028903663537LU, 18272613946367732116LU},
    {11104707589538124565LU, 15513089484867174327LU},
    {13498195522842984185LU, 12118280416157025746LU},
    {11847675499295562333LU, 9435053274389468145LU},
    {4223825477632196441LU, 2418866668808098531LU},
    {2712950054197156861LU, 814385486013711552LU},
    {355419656017655313LU, 8369957690575879845LU},
    {2006049192573735605LU, 6842336794647783558LU},
    {5079910551530270153LU, 10007771214277151343LU},
    {6433155589365746029LU, 11546793792373562444LU},
    {8651354499323339905LU, 16094497972730635817LU},
    {7437578526220058661LU, 17692366404824117258LU},
    {14077390809724344952LU, 8608599313037550587LU},
    {15881010655373393628LU, 6749539407239607768LU},
    {18243043004030554928LU, 2508075289989500861LU},
    {16290665144539953044LU, 581725298073033118LU},
    {13816354284336138472LU, 15854034053608913783LU},
    {11566882472071523404LU, 17786996255043104084LU},
    {9353188811125817760LU, 9925174632985007921LU},
    {11454181060869268740LU, 11772832315431452946LU},
    {8447650955264392882LU, 4837733337616197062LU},
    {7639312913434106390LU, 7638063140943410149LU},
    {5425900108394313722LU, 1628770972027423104LU},
    {6085757489147941726LU, 4343233323593342883LU},
    {710839312035310626LU, 16739915381151759690LU},
    {1649786142657202310LU, 14018840854427855721LU},
    {4012098385147471210LU, 13684673589295567116LU},
    {2924394641152049614LU, 10895745974960113455LU},
    {10159821103060540307LU, 1568798354844751070LU},
    {10648392025402933047LU, 4546859814486999805LU},
    {12866311178731492059LU, 4646843511037573272LU},
    {12517208220653270655LU, 7683187891903344315LU},
    {17302708998646679811LU, 13742251871751720018LU},
    {17232968444199366055LU, 10694505843077372529LU},
    {14875157052440117323LU, 16937988735938682900LU},
    {15084652818563966191LU, 13966539992637601335LU},
    {5738183157191475691LU, 7111921299311261477LU},
    {5808025562560177487LU, 5219200957157040390LU},
    {8201795451114637475LU, 3966269371327667043LU},
    {7992480683569507335LU, 2150409281680002368LU},
    {3693904361907131259LU, 14538088210547027881LU},
    {3205222792684582879LU, 16365349939413334410LU},
    {951346791425563187LU, 11274814944387204079LU},
    {1300277547152342679LU, 13160922561610323404LU},
    {13141756129890673866LU, 3770911062399632957LU},
    {12202708547858628718LU, 2200072749545279518LU},
    {9804436708793478530LU, 7056417029182450299LU},
    {10891960553721415974LU, 5418288595849837656LU},
    {14592112277110437466LU, 11468349586593259185LU},
    {15400559866309645054LU, 13113090186493921426LU},
    {17649930618522697490LU, 14600205349461406455LU},
    {16990244340609276854LU, 16159641464734065876LU},
    {16895301910528785764LU, 9675466675232394124LU},
    {17672253329344125376LU, 12437504620146285999LU},
    {15278625826868212780LU, 15276126281886820298LU},
    {14641424947761123464LU, 17952331942231634409LU},
    {10851800216788627444LU, 3257541944054846208LU},
    {9917218414521207632LU, 570215526745310499LU},
    {12171514978295883452LU, 8686466647186685766LU},
    {13245569418708288024LU, 5931322378177292645LU},
    {1421678624070621253LU, 15033086688593967764LU},
    {901439534060829921LU, 18049457065906793655LU},
    {3299572285314404621LU, 9590937635146159826LU},
    {3671050337825666473LU, 12665555732130545905LU},
    {8024196770294942421LU, 8922603104881582616LU},
    {8098583895836651121LU, 5841090773629645883LU},
    {5848789282304099229LU, 3344747876210675294LU},
    {5625925617898202937LU, 339497697499519101LU},
    {15052755595986272829LU, 12094315398549051759LU},
    {14978548094634272409LU, 10163338915013955404LU},
    {17192104385263717237LU, 17468963234429646121LU},
    {17415068526201991121LU, 15614811836208882442LU},
    {12395977834360967341LU, 911019364307026403LU},
    {12916046096408327177LU, 2772064988205406144LU},
    {10554153316922612197LU, 6421303005592808869LU},
    {10182565991920205121LU, 8341159281936300934LU},
    {2964736114272511772LU, 17379895477438064759LU},
    {3899137192839250872LU, 15847331430542556756LU},
    {1681080051210219092LU, 11855814657457062961LU},
    {606924034754464496LU, 10255995691635249682LU},
    {6180529228803913100LU, 6504040451074781435LU},
    {5403749737461977384LU, 8114980165271381720LU},
    {7761136168390622404LU, 1151624164798454973LU},
    {8398447419499829344LU, 2677294527199529630LU},
    {11476366314382951382LU, 14223842598622522954LU},
    {9258381639128491890LU, 17274102110710200425LU},
    {11616051125120354974LU, 10438401914314080780LU},
    {13694566461855362618LU, 13402829176192422959LU},
    {16403590902229274950LU, 7932538742655334086LU},
    {18202736415777371618LU, 4956990766761943269LU},
    {15984961367139014670LU, 4300818563360004736LU},
    {14046062016438172842LU, 1257452701407022243LU},
    {7387808723814262519LU, 10629432347384504146LU},
    {8772620320104612435LU, 13357563539567692145LU},
    {6410445585369165759LU, 14283955805117117204LU},
    {5174113825387498267LU, 17070334751331607863LU},
    {1902693582851126375LU, 4102885815064856542LU},
    {387281995875422403LU, 1309612677532488189LU},
    {2600555094304685359LU, 7875101049511095192LU},
    {4264724419153385867LU, 5158090030159773115LU},
    {11950922557912054927LU, 16498012614826146985LU},
    {13466444482530662443LU, 14855257732824574602LU},
    {11216929625627276743LU, 12775917569674842351LU},
    {9552932262612242787LU, 11209987738627868364LU},
    {15653186159024434719LU, 5730693766212772901LU},
    {14268273021049948859LU, 7303517797167559174LU},
    {16666686765883139927LU, 1890977314165770339LU},
    {17902837767803864051LU, 3522612031925411392LU},
    {6636280554502871470LU, 12831562433410665905LU},
    {4837025802823892234LU, 11010759235745258386LU},
    {7091041510692786406LU, 16693511534541054455LU},
    {9029769999071982658LU, 14805453383589607380LU},
    {2376127499852794686LU, 1829000768858412349LU},
    {4594212617279369114LU, 3728179642414842654LU},
    {2200305220970218102LU, 5537299734793615739LU},
    {121969542784132818LU, 7351209290914262872LU},
    {2156002383232978898LU, 9282212440131577803LU},
    {203778990026124150LU, 12253668051186299368LU},
    {2565668677133403802LU, 15377700700125727629LU},
    {4369416630852952638LU, 18425453596016844206LU},
    {6992636535170784578LU, 3144145337884180295LU},
    {9093483114588240358LU, 107790232921532772LU},
    {6879929366581122058LU, 9087038925126324993LU},
    {4630320650019811502LU, 6108966740850328866LU},
    {16440762079092828915LU, 15435914088522290899LU},
    {18091255845357932119LU, 18224852968121008368LU},
    {15733867009250108347LU, 9479787303297989269LU},
    {14222846980775315231LU, 12200873095822027958LU},
    {11009101373105043555LU, 9026434775415115359LU},
    {9795452374334987463LU, 6311966097261975676LU},
    {12013512470899306795LU, 2953742183177249305LU},
    {13366910910000731535LU, 153406053799687226LU},
    {2843357248141242507LU, 11619429303478383912LU},
    {4057177075007820847LU, 10059999505733247755LU},
    {1802879068121659843LU, 17652170058104035694LU},
    {449589901645471079LU, 16007435776267767629LU},
    {6599144570628809243LU, 735131196582768036LU},
    {4948471180308350655LU, 2373248355458202503LU},
    {7342100675651332947LU, 6884367390551540194LU},
    {8853020227728101367LU, 8455194429485586369LU},
    {16048393540589884842LU, 17845206209763165232LU},
    {13947375033564672270LU, 15959109308650967571LU},
    {16197167791673302242LU, 11682181547259291766LU},
    {18446666136098142278LU, 9854930533967035989LU},
    {11697578564608198458LU, 6689495752421350588LU},
    {13649982681381643166LU, 8505348966195202719LU},
    {11251851235796405874LU, 678995394999038202LU},
    {9448204857986116310LU, 2571708860742575833LU},
    {7554715222435082592LU, 14119382820730995213LU},
    {8642374837789267396LU, 16802599246656082990LU},
    {6243963635575027752LU, 10829896622191193675LU},
    {5305060658715909260LU, 13589410367312410728LU},
    {1456562807888684016LU, 7530347674812603009LU},
    {796749555777308500LU, 4782231763569527970LU},
    {3046261320306223800LU, 4411470547534280391LU},
    {3854555508372655644LU, 1721637522618114276LU},
    {10454341035639149633LU, 10742341588114748181LU},
    {10244871801675002085LU, 13819502034887255350LU},
    {12638782152923864329LU, 13884013283670237011LU},
    {12708496450088892845LU, 16893320677727799664LU},
    {17146394103789192913LU, 4496635649192127385LU},
    {17495470529706697333LU, 1493945412455136698LU},
    {15241452416653610905LU, 7772887550270654431LU},
    {14752907751594584893LU, 4684329827949498876LU},
    {5929472228545023545LU, 16313046881166577902LU},
    {5580497344177564317LU, 14465377932651546317LU},
    {7798274385678501745LU, 13247918787375561896LU},
    {8286999808664380373LU, 11314945320409655947LU},
    {3362160102420438185LU, 5264885241204574306LU},
    {3571518998607329293LU, 7191241559439842881LU},
    {1213848069508928993LU, 2065247309560947748LU},
    {1143961810375881029LU, 3924313542214562311LU},
    {12361058457607826200LU, 13008080902149562870LU},
    {13020771267681439676LU, 11410205602570893269LU},
    {10807499474923954768LU, 16229960330542763440LU},
    {9999025628442953460LU, 14690930884424293267LU},
    {15522272336781244808LU, 2303248329596909946LU},
    {14434721959692033324LU, 3830879950427172697LU},
    {16796894838999658688LU, 5354589054399059260LU},
    {17735968678314513508LU, 6959080961558741791LU},
    {17839746774306435766LU, 474886379161676871LU},
    {16765736462535235090LU, 3191908123482290788LU},
    {14547538858245487614LU, 5993931436088770561LU},
    {15482076806750101338LU, 8787215298053559842LU},
    {10048373492187799590LU, 12530164438928602315LU},
    {10685530242652603522LU, 9743778625161798376LU},
    {13043058785408739694LU, 17896614891823175821LU},
    {12266151220357221834LU, 15168476831550803630LU},
    {1031739464176736151LU, 5796497454292196703LU},
    {1254576596422964019LU, 8839869642631072636LU},
    {3468272250235182815LU, 416813854955073817LU},
    {3393911381975792251LU, 3392368157771228986LU},
    {8264110591757190407LU, 18087158927899919827LU},
    {7892659071406678435LU, 15122720399885898736LU},
    {5530625279638522959LU, 12590909452829763989LU},
    {6050838112364980459LU, 9540638675143278518LU},
    {14775617447628525039LU, 2812120621059456676LU},
    {15147248901271644491LU, 998222339060443271LU},
    {17545240640209224871LU, 8268383005425832674LU},
    {17025128524398567427LU, 6369215406527907009LU},
    {12820891170738331519LU, 10121167536524682792LU},
    {12597882901158329307LU, 12009219369210408971LU},
    {10348227650774996535LU, 15693925428953664110LU},
    {10422479005891375763LU, 17514722308890221645LU},
    {3805387165702252750LU, 8205771630129713084LU},
    {3168049382432820330LU, 6574143788982081951LU},
    {774563991750844806LU, 2619225355064976378LU},
    {1551369740374541602LU, 1046408200185329113LU},
    {5201110188609370718LU, 15750202099022190384LU},
    {6275292737226366714LU, 17316121214293786899LU},
    {8529448838306771734LU, 10316180060319546230LU},
    {7595021502457190322LU, 11958924226008870229LU},
    {9416911257529830404LU, 5022699354125224321LU},
    {11355766754467899552LU, 8027942657029693346LU},
    {13609640900298540364LU, 1156770021237843399LU},
    {11810539515391681000LU, 4238275476146222052LU},
    {18324843120519011988LU, 17205724190083092749LU},
    {16246371637547858480LU, 14131116809142503214LU},
    {13852603054665668572LU, 13510403859737722187LU},
    {16070543601277875064LU, 10494044197931821928LU},
    {8893883976150968613LU, 1392280169085368473LU},
    {7229740908584553857LU, 4147413163704676026LU},
    {4980368713264472173LU, 5110394981808559327LU},
    {6495753768080475337LU, 7797710125264880380LU},
    {543828368332618677LU, 13268004595066413077LU},
    {1780133871030918929LU, 10591805252182029878LU},
    {4178407702959207165LU, 17120699682032127059LU},
    {2793622638829573721LU, 14358668055115537008LU},
    {13272561109005742941LU, 7216380793111780194LU},
    {12036366253321689081LU, 5690704104056360257LU},
    {9674051605647784469LU, 3574774397780965156LU},
    {11059008872262950577LU, 1963828357466890503LU},
    {14182083021385572813LU, 14940278995372557294LU},
    {15846124238164952425LU, 16540109226524759501LU},
    {18059539998143965317LU, 11164162693469663144LU},
    {16543973944883596321LU, 12696738006232430987LU},
    {4752254999705589372LU, 3658001537716824698LU},
    {6830616935173468888LU, 1738134537209363545LU},
    {9188425234558738228LU, 7456359284829685308LU},
    {6970313584971971472LU, 5595302936230465567LU},
    {4400610441940436204LU, 11074599469587231478LU},
    {2461855696278429768LU, 12928757735628727509LU},
    {243939085568265636LU, 14702418581828525744LU},
    {2043220369408518400LU, 16633401932647483539LU},
  },
  // Table 5
  {
    {0LU, 0LU},
    {4312004766465957797LU, 117680806553603990LU},
    {8624009532931915594LU, 235361613107207980LU},
    {5510703381737611503LU, 208918419956224186LU},
    {17248019065863831188LU, 470723226214415960LU},
    {15315076065446388017LU, 516311239929590222LU},
    {11021406763475223006LU, 417836839912448372LU},
    {11755721534545190523LU, 319300880632377058LU},
    {1702770167913400371LU, 9317359238934547555LU},
    {3203788931382564758LU, 9290924713497297909LU},
    {6921987033462306681LU, 9370237099726426959LU},
    {6618189140563323100LU, 9487908963688324313LU},
    {17941269471081936551LU, 9783419947436536379LU},
    {14063440896265332994LU, 9684892637750803885LU},
    {10327479058557503981LU, 9548085001781275927LU},
    {13008016411239749192LU, 9593664091024138881LU},
    {3405540335826800743LU, 187974404159543494LU},
    {1483295720542179266LU, 232436381988280144LU},
    {6407577862765129517LU, 135105353285044202LU},
    {7150338946373464200LU, 35443357313222780LU},
    {13843974066924613363LU, 293730125743302302LU},
    {18143028646296449366LU, 410284893457672456LU},
    {13236378281126646201LU, 529073853667097010LU},
    {10116877619355012636LU, 501504622482191908LU},
    {4099292255266068564LU, 9499843571074618533LU},
    {231035891837716465LU, 9400190500380351283LU},
    {5714292136792942366LU, 9264490776474864521LU},
    {8402150173796956347LU, 9308944103903888415LU},
    {15546101980981012160LU, 9610225457767607037LU},
    {17035296735395592549LU, 9582665168369034603LU},
    {11533854542347344266LU, 9663120617748297169LU},
    {11224987762792662575LU, 9779666718554176071LU},
    {6811080671653601486LU, 375948808319086988LU},
    {7301039464901492587LU, 330369584120299034LU},
    {2966591441084358532LU, 464872763976560288LU},
    {1368006112085966881LU, 563399933740310838LU},
    {12815155725530259034LU, 270210706570088404LU},
    {9948386985644507647LU, 152538706981175362LU},
    {14300677892746928400LU, 70886714626445560LU},
    {18276002816819003061LU, 97321100812803950LU},
    {5270519686288468221LU, 9546025578460806639LU},
    {8283233278489786200LU, 9644561673367892601LU},
    {4506422351265552311LU, 9745340495138546371LU},
    {386559965867722770LU, 9699752620674264405LU},
    {11995865708779476585LU, 9435626058511270839LU},
    {11362213743039187404LU, 9462069386618178593LU},
    {15120627615937472803LU, 9346728220549930139LU},
    {16861498760798451334LU, 9229047553918309133LU},
    {8198584510532137129LU, 552943068439685450LU},
    {5336880258047487756LU, 436397107421570780LU},
    {462071783675432931LU, 353636927051150950LU},
    {4449216321842450502LU, 381197351539866096LU},
    {11428584273585884733LU, 82237479240177426LU},
    {11911226777471373720LU, 37784291196262532LU},
    {16804300347593912695LU, 171144134098225214LU},
    {15196147206461615826LU, 270797340285290408LU},
    {7378670108095674522LU, 9719218891300365609LU},
    {6751208255825602367LU, 9746787983100160703LU},
    {1281537585904666576LU, 9630303719522171397LU},
    {3035354516457674869LU, 9513748816315004307LU},
    {9888506934270592526LU, 9253140566721452913LU},
    {12892778615335360939LU, 9352802422905509095LU},
    {18344755918372256068LU, 9452473366971991133LU},
    {14214199544948467425LU, 9408011254053112779LU},
    {13622161343307202972LU, 751897616638173976LU},
    {9717909194373127737LU, 850424930266524814LU},
    {14602078929802985174LU, 660739168240598068LU},
    {17398056369661272435LU, 615160075088606114LU},
    {5933182882168717064LU, 929745527953120576LU},
    {7602558961461928109LU, 956180049414132438LU},
    {2736012224171933762LU, 1126799867480621676LU},
    {2174981205518950375LU, 1009128007528451578LU},
    {12297879105474267567LU, 10025767288005439355LU},
    {10483683522940802570LU, 9980179269710110957LU},
    {15925982936172803813LU, 9828686281025990743LU},
    {16632677864742693184LU, 9927222244919836609LU},
    {5041658937217414971LU, 10208242524070514979LU},
    {9088478909568837790LU, 10090561722197794485LU},
    {3627984769330530417LU, 10299409497978179087LU},
    {688595065018767316LU, 10325852686481899929LU},
    {10541039372576936443LU, 645307083212061662LU},
    {12222235063934537310LU, 672867368063972424LU},
    {16566466556979572401LU, 842379273026233586LU},
    {16010500028025630996LU, 725833176733395812LU},
    {9012844702531104623LU, 1043936916567541126LU},
    {5099024739198709962LU, 1143589991707740688LU},
    {773119931735445541LU, 952761167638977194LU},
    {3561781084228358016LU, 908307835730400572LU},
    {9649031504516782536LU, 9924103455721404349LU},
    {13708797264824632941LU, 9807548692117485611LU},
    {17457814718599898754LU, 10015253095543777425LU},
    {14524615125761341735LU, 10042822322584741639LU},
    {7689187123147892572LU, 10318071948185766373LU},
    {5864297554619037945LU, 10273609966280197747LU},
    {2097507586302662678LU, 10121008825047553737LU},
    {2795760601438046131LU, 10220670825062717791LU},
    {16397169021064274258LU, 1105886136879370900LU},
    {15589530224531734263LU, 1079442812748635394LU},
    {10673760516094975512LU, 872794214843141560LU},
    {12679746066863669693LU, 990474877464969774LU},
    {924143567350865862LU, 707273854102301900LU},
    {3964406618410942563LU, 608737755252532058LU},
    {8898432643684901004LU, 762394703079732192LU},
    {4659752452464754473LU, 807982581453077622LU},
    {17595289052893882721LU, 10238103938567806711LU},
    {14985823788043712196LU, 10355775933475901793LU},
    {9476036308988204587LU, 10182956971894243803LU},
    {13283074270814833038LU, 10156522590355213901LU},
    {1977717814344374261LU, 9844117881029501103LU},
    {2352306869966194768LU, 9889697109808508729LU},
    {7844392203224377535LU, 10077218878331633539LU},
    {6272300802190538522LU, 9978691703954173973LU},
    {14757340216191349045LU, 991693708891179602LU},
    {17806049577524358800LU, 892031848261125572LU},
    {13502416511651204735LU, 1046831892490769790LU},
    {9274434707559829978LU, 1091294009889135336LU},
    {2563075171809333153LU, 813863365334791178LU},
    {1749241862669930500LU, 786294278081592220LU},
    {6070709032915349739LU, 580753558920456998LU},
    {8063744398888939342LU, 697308457614517424LU},
    {15811556439982848262LU, 10128275536646440497LU},
    {16193466181955954339LU, 10172728728767252903LU},
    {12448877587559253580LU, 10361358684198770973LU},
    {10886358395614665193LU, 10261705473968428683LU},
    {3760693962181822354LU, 9945782752687044713LU},
    {1146159812941404215LU, 10062328709594773503LU},
    {4872342574099134680LU, 9890653086007600965LU},
    {8667556524875212669LU, 9863092665662892243LU},
    {12901890135316772387LU, 10989862397462410979LU},
    {9861732844468087174LU, 11034315577839139189LU},
    {14168916252244904297LU, 11225215184042715599LU},
    {18407701789486847692LU, 11125561983408907865LU},
    {6652376628893993143LU, 11388352041943451835LU},
    {7459839160911189778LU, 11504898014890166061LU},
    {3170357898931566589LU, 11335456889915234199LU},
    {1164196768956934232LU, 11307896455678957569LU},
    {11866365764337434128LU, 1859491055906241152LU},
    {11491670810789077429LU, 1759829187827135766LU},
    {15205117922923856218LU, 1912360098828264876LU},
    {16777104115652353791LU, 1956822221528263226LU},
    {5472024448343867524LU, 2253599734961243352LU},
    {8081665840010010401LU, 2226030650862193486LU},
    {4349962411037900750LU, 2018256015056903156LU},
    {543100166115795051LU, 2134810912744363106LU},
    {11263028078186899012LU, 11103629443239833125LU},
    {12076685120663861729LU, 11221301452307866035LU},
    {16996851790662703374LU, 11050751591742468361LU},
    {15003640847631058603LU, 11024317193895952031LU},
    {8291995151097583824LU, 11281618640793358461LU},
    {5243391547827832693LU, 11327197859707330539LU},
    {341630711068092314LU, 11516953577086865233LU},
    {4569717863328086079LU, 11418426414721859783LU},
    {10083317874434829943LU, 1969740974431478342LU},
    {12698028152639091154LU, 1943297651575844304LU},
    {18176957819137675581LU, 1734379370686037354LU},
    {14381919583119036056LU, 1852060029885346556LU},
    {7255969538661060835LU, 2152074922246806558LU},
    {6873953900908252998LU, 2053538817827033992LU},
    {1377190130037534633LU, 2204961299254248242LU},
    {2939604111528636428LU, 2250549185345146020LU},
    {17116327789845092077LU, 11363838518678538095LU},
    {15446845402462259528LU, 11247283760241969401LU},
    {11108070800054299047LU, 11452753699415840835LU},
    {11668997020565026306LU, 11480322919141906389LU},
    {203836831121762425LU, 11185866886736083255LU},
    {4108265796207769564LU, 11141404903958066849LU},
    {8465235125621905203LU, 10986534077593675291LU},
    {5669432713332181142LU, 11086196080628705677LU},
    {18025689405062209246LU, 2087873833135082252LU},
    {13978975877979947387LU, 2115434127449375898LU},
    {10198049478397419924LU, 2287179983415481376LU},
    {13137543843673210417LU, 2170633875512843190LU},
    {1546239863470891082LU, 1905522335277954388LU},
    {3360258767014182895LU, 2005175396660869826LU},
    {7123562168456716032LU, 1816615671460801144LU},
    {6416692075155718309LU, 1772162355457058286LU},
    {14036455137055442570LU, 11470570760196054953LU},
    {17950451914392672559LU, 11424982738612359231LU},
    {13070892449941469632LU, 11271255835431616645LU},
    {10282406327165003365LU, 11369791800466280211LU},
    {3285028898938550302LU, 11072098664145936881LU},
    {1603726897343195067LU, 10954417869856484967LU},
    {6501058876335638356LU, 11160996510260952797LU},
    {7056920609294145777LU, 11187439693328822603LU},
    {15378374246295785145LU, 2189399822661981130LU},
    {17203087137982337308LU, 2287927120117128284LU},
    {11728595109238075891LU, 2100475858850843878LU},
    {11030166927224499798LU, 2054896779724637040LU},
    {4195015172605325357LU, 1795273576385555858LU},
    {135355859713470344LU, 1821708109724869124LU},
    {5591521202876092263LU, 1994597576415883966LU},
    {8524825454530531522LU, 1876925706732961064LU},
    {1010806504448489407LU, 10586998974626207227LU},
    {3877681004821932058LU, 10614568054816201325LU},
    {8766742467282422005LU, 10495849326985710295LU},
    {4791522888954795856LU, 10379294433240925505LU},
    {16238395713236764971LU, 10692894882936925091LU},
    {15748260655734101646LU, 10792556755025814581LU},
    {10877596247599429217LU, 10889958013960500367LU},
    {12476005997132360132LU, 10845495887284337433LU},
    {1848287134701731724LU, 1414547708204603800LU},
    {2481833202791784489LU, 1298001739871589902LU},
    {7928813236821885126LU, 1217475510505064116LU},
    {6187836883378216803LU, 1245035940161128738LU},
    {17796865287369802008LU, 1524789406159464384LU},
    {14784327822245027517LU, 1480336221135415382LU},
    {9319504904929508946LU, 1615965162906155244LU},
    {13439543006972338679LU, 1715618368220772218LU},
    {2397590440241457112LU, 10409862456675306813LU},
    {1914771669953050749LU, 10508398565608178347LU},
    {6263189003563686034LU, 10606943472882160145LU},
    {7871166567377356599LU, 10561355582244674951LU},
    {14850820130145605964LU, 10880444394503648101LU},
    {17712630140970862313LU, 10906887712879803635LU},
    {13381906174244398598LU, 10789277411435555913LU},
    {9394866983969700259LU, 10671596756682236895LU},
    {3955435628688748523LU, 1241491688349450590LU},
    {951340076847345742LU, 1195912465291480776LU},
    {4704613739932389537LU, 1332650145907465842LU},
    {8835345827853045508LU, 1431177312382849508LU},
    {15688784406448755071LU, 1707693682953715462LU},
    {16316140363216473818LU, 1590021677928951952LU},
    {12544601604381077045LU, 1510639334198796330LU},
    {10790679463098282384LU, 1537073727968423868LU},
    {5801422341082666865LU, 10942392541912376439LU},
    {7734259033670011092LU, 10842739476519742433LU},
    {2822745534408845371LU, 10709309403386264411LU},
    {2088325964936050590LU, 10753762723366237389LU},
    {13825926701739485669LU, 10471828238951455279LU},
    {9514098751702808128LU, 10444267948546282937LU},
    {14443375986591930031LU, 10526957896537703683LU},
    {17556857165078497546LU, 10643504000497732245LU},
    {5126150343618666306LU, 1627726730669582356LU},
    {9004085363963953383LU, 1672188718094854018LU},
    {3498483725339861000LU, 1572588556163184440LU},
    {818051033361072045LU, 1472926548447279278LU},
    {12141418065830699478LU, 1161507117840913996LU},
    {10640222623648710259LU, 1278061871663716826LU},
    {16127488797777878684LU, 1394616915229034848LU},
    {16431111525669454137LU, 1367047700083115766LU},
    {9205395046051333910LU, 10754844069736332465LU},
    {4906517280960633011LU, 10728409540876563239LU},
    {607564835751393372LU, 10809991028121871261LU},
    {3727240526962124793LU, 10927662893358869515LU},
    {10420599399519205762LU, 10648965779112887017LU},
    {12342737704826644007LU, 10550438477144706431LU},
    {16659876098129037000LU, 10415864790031539653LU},
    {15917010218265745773LU, 10461443873704399443LU},
    {7521387924363644709LU, 1444821431664537810LU},
    {6032016493383061632LU, 1562502221910654788LU},
    {2292319625882808431LU, 1677913345479995390LU},
    {2601011238281949130LU, 1651470166488948840LU},
    {9744685148198269361LU, 1334562098305650314LU},
    {13613047959303187988LU, 1380150124033278236LU},
    {17335113049750425339LU, 1279441257616232870LU},
    {14647359671302771038LU, 1180905288471125552LU},
  },
  // Table 6
  {
    {0LU, 0LU},
    {12610799044851194204LU, 13644485670199188757LU},
    {10889389776667477922LU, 17791679829640547065LU},
    {4043226017793957630LU, 5454507751085725676LU},
    {16656065172615117406LU, 7029034107088512289LU},
    {5198479897177776898LU, 15913141815683643444LU},
    {8086452035587915260LU, 10909015502171451352LU},
    {16085265375763326112LU, 3043985442791355085LU},
    {529042759745388967LU, 5711992444586621585LU},
    {12129609404302301435LU, 17446911633936721796LU},
    {10396959794355553797LU, 13379539557657735272LU},
    {4560991052376579929LU, 357859406355410301LU},
    {16172904071175830521LU, 3371286930633351088LU},
    {5724986047056028325LU, 10634059709942858405LU},
    {8606186327742774363LU, 15573879690038105417LU},
    {15595365401953740039LU, 7312573095112673372LU},
    {1058085519490777934LU, 11423984889173243170LU},
    {11650141285092383250LU, 2580798802130151479LU},
    {11074898362832684268LU, 7521744961305116635LU},
    {3941634323689659824LU, 15364144874572849870LU},
    {16828025645282965776LU, 18376376419338178563LU},
    {5083339952015663180LU, 4781964709910088982LU},
    {9121982104753159858LU, 715718812710820602LU},
    {15102052303264868334LU, 13021117202027251695LU},
    {718494267687191273LU, 15118363392812060595LU},
    {12031951689722796981LU, 7824375480608641702LU},
    {11449972094112056651LU, 2821375346176165194LU},
    {3595269015143947287LU, 11132188549435185247LU},
    {17212372655485548727LU, 12701015306366659218LU},
    {4745720156807504363LU, 944033314483337095LU},
    {8773086783410142997LU, 5092353653004410987LU},
    {15475156772677035593LU, 18154396878372666750LU},
    {2116171038981555869LU, 4401225704636934724LU},
    {12852332925714685889LU, 9245529503727531857LU},
    {9962177981583327551LU, 14698893762718261437LU},
    {2684790779415550051LU, 8549528171797003688LU},
    {18048207804691233987LU, 6672204012301733733LU},
    {6159397847813678495LU, 16267737831824102000LU},
    {7883268647379319649LU, 12281545675436148124LU},
    {14007446067607790141LU, 1669186006512441481LU},
    {1876224024777508666LU, 8237463774856941781LU},
    {13045557191792795238LU, 14919205950146366912LU},
    {10166679904031326360LU, 9563929419820177964LU},
    {2456084038190045636LU, 4171200006296651577LU},
    {18243964209506319716LU, 1431437625421641204LU},
    {5921417823369864248LU, 12576178278437742817LU},
    {7652027564098681542LU, 16516320950826286861LU},
    {14209974398930756506LU, 6372365913239773720LU},
    {1436988535374382547LU, 11789982711914569574LU},
    {13615432390170926223LU, 2217070242403402355LU},
    {9579111581619683953LU, 6158338535525914015LU},
    {3165284870321953581LU, 16729785378998732938LU},
    {17642585954415165325LU, 13984322840706923079LU},
    {6617336625968375505LU, 9171783934753040210LU},
    {7190538030287894575LU, 3817633025160818878LU},
    {14756997280994156915LU, 9916933451412663723LU},
    {1488084413673718900LU, 17067371629885449719LU},
    {13520986996631248168LU, 5873133164620658914LU},
    {9491440313615008726LU, 1888066628966674190LU},
    {3223117490756819594LU, 12063228003362189851LU},
    {17546173566820285994LU, 10184707306008821974LU},
    {6665900361235769206LU, 3462610852737850819LU},
    {7250344237552826760LU, 8917100732462549551LU},
    {14671860350749647060LU, 14331884152434923322LU},
    {4232342077963111738LU, 8802451409273869448LU},
    {10790275443507254374LU, 14371660994361854365LU},
    {12511755114826369688LU, 10142150758742810225LU},
    {189186463308960708LU, 3574410106817971044LU},
    {15968207047222409060LU, 1991914487350456745LU},
    {8257624100376440376LU, 12033126451421850812LU},
    {5369581558831100102LU, 17099056343594007376LU},
    {16538936440934721946LU, 5771079569279690309LU},
    {4461876616019299485LU, 3849878624759655961LU},
    {10586075751327667649LU, 9815445144966165260LU},
    {12318795695627356991LU, 14088731589938652384LU},
    {429998657736675939LU, 9142247666749503989LU},
    {15766537294758639299LU, 6116347277162744632LU},
    {8489127827218214815LU, 16842145518960760365LU},
    {5607857212178329953LU, 11675898672654287297LU},
    {16344005629631834173LU, 2257407975186685140LU},
    {3752448049555017332LU, 16474927549713883562LU},
    {11173942447667762984LU, 6483002296079711423LU},
    {11749255704280336854LU, 1317881079097142099LU},
    {868969579704766602LU, 12614862618413921862LU},
    {15219181120952153130LU, 9596772881097000075LU},
    {8950880563470790006LU, 4067987938296912286LU},
    {4912168076380091272LU, 8342400012593303154LU},
    {16945084128621423316LU, 14888016293762945895LU},
    {3694312927995121619LU, 12387046926660590395LU},
    {11260785647993525903LU, 1638556961669875246LU},
    {11842835646739728497LU, 6705612483165934018LU},
    {817608583678103853LU, 16165086379265920215LU},
    {15304055128197363085LU, 14585897827943022106LU},
    {8890215497900109009LU, 8588777525252858639LU},
    {4862778468162335279LU, 4360392918957716707LU},
    {17041200607866334067LU, 9356730896163219958LU},
    {2873977070748765095LU, 5133221350119587532LU},
    {9863133879582970619LU, 18043160574500889561LU},
    {12753218489365302277LU, 12813975779950015541LU},
    {2305286995961763161LU, 904819422219233568LU},
    {13890317232755683833LU, 2788001782855998445LU},
    {8054370205860849829LU, 11234805094449465080LU},
    {6330569740643907163LU, 15012826684287914260LU},
    {17931149304191938311LU, 7855039982751042561LU},
    {2357040108139760128LU, 610747113774040157LU},
    {10355866367314629468LU, 13052342319611222344LU},
    {13234673251936751010LU, 18343567869506080420LU},
    {1777109691591890174LU, 4885141866465235889LU},
    {14381076060575789150LU, 7635266050321637756LU},
    {7534898832410061058LU, 15325495991904517225LU},
    {5804359494820919292LU, 11465413197837659013LU},
    {18415136274286882464LU, 2470127511738070672LU},
    {2976168827347437801LU, 15687999186061347822LU},
    {9678225897619083701LU, 7272199905566562043LU},
    {13714476303030914891LU, 3413243281989484823LU},
    {1247802089264600599LU, 10521734476987997186LU},
    {14874055592373662391LU, 13275166270154632911LU},
    {7019365982693551083LU, 387360212630189018LU},
    {6446234981513639189LU, 5679711933014828086LU},
    {17759714668930264137LU, 17548434852356045091LU},
    {3322231909919967566LU, 10877295881447616895LU},
    {9302324373804257298LU, 3146073945147468906LU},
    {13331800722471538412LU, 6925221705475701638LU},
    {1587128498483795888LU, 15943207910852880019LU},
    {14500688475105653520LU, 17834201464925099102LU},
    {7367402720882666060LU, 5342743408987195723LU},
    {6783029178914370738LU, 114684784926105255LU},
    {17375072025529036270LU, 13604673366534964146LU},
    {8464684155926223476LU, 17604902818547738896LU},
    {15742921349366858536LU, 5263545481567335429LU},
    {16313862124454878678LU, 196350085871346665LU},
    {5576852445468148874LU, 13827001041119084284LU},
    {10547045922236702762LU, 10798796904122682417LU},
    {4421457897378445686LU, 2920579948306714916LU},
    {378372926617921416LU, 7148820213635942088LU},
    {12268595687152647892LU, 16028105977845144541LU},
    {8227813676271393747LU, 13480468904853853057LU},
    {15937568484506010255LU, 454525356047732372LU},
    {16515248200752880753LU, 5619508829134150008LU},
    {5346753892325000493LU, 17340673779073221741LU},
    {10739163117662200205LU, 15751368613478463136LU},
    {4182618228940060881LU, 7476794656643066805LU},
    {150810914553226799LU, 3202240509123492953LU},
    {12471953155552362355LU, 10460269473058955596LU},
    {8923753232038598970LU, 7699757249519311922LU},
    {15336169201133371494LU, 15528968969875030311LU},
    {17062283039891955352LU, 11255540992845240011LU},
    {4885252126325753796LU, 2407531938610023390LU},
    {11309015088735527780LU, 817171520253851923LU},
    {3743405691728951864LU, 13118385689922806790LU},
    {859997315473351878LU, 18284495333499007978LU},
    {11884398989239713178LU, 4676250223983439615LU},
    {8971174712281028765LU, 2710633373387892387LU},
    {15240899343675982273LU, 11008180528392960950LU},
    {16978255654436429631LU, 15237546964211969114LU},
    {4943949063914751587LU, 7938816276620570959LU},
    {11215714424356659907LU, 4905053271599022978LU},
    {3793357115980004255LU, 17962832077865246359LU},
    {916722865255605601LU, 12896762852659038587LU},
    {11797835067000699965LU, 1126025323680584814LU},
    {7504896099110034665LU, 14503111025718215508LU},
    {14349649115780728245LU, 8367571353043017281LU},
    {18390551831108524875LU, 4588561267891456429LU},
    {5781165727487803927LU, 9437059122113025208LU},
    {10304381339294607031LU, 12162326917149746805LU},
    {2306417852818751467LU, 1554780397114538848LU},
    {1737939159409533205LU, 6782981163118292108LU},
    {13194676780166314057LU, 16391710674573963673LU},
    {8030259718816980302LU, 9655845687521229253LU},
    {13867630269332587538LU, 4276879310097343696LU},
    {17901761126941580012LU, 8135975876593824572LU},
    {6299790474820387760LU, 14821972652698431017LU},
    {9824336152760182544LU, 16684800025186606308LU},
    {2834315883369512524LU, 6545597598454792689LU},
    {2254596848193200306LU, 1253390150316594717LU},
    {12703353868473711086LU, 12411389369762007816LU},
    {7388625855990243239LU, 6327349779611629174LU},
    {14522739886405994235LU, 16903610793571183459LU},
    {17408469056559355909LU, 11612528974756887695LU},
    {6815565498704019801LU, 2052813494863126938LU},
    {9344853877493212665LU, 3910081458160014167LU},
    {3363373074351848613LU, 10023206489001905730LU},
    {1635217167356207707LU, 13883428684822288814LU},
    {13381315664280812295LU, 9075082794013312187LU},
    {7052115330424724992LU, 1768315708705950951LU},
    {14905977351786301276LU, 11948228655178060274LU},
    {17780430995800218018LU, 17177555050505717278LU},
    {6467812432352149758LU, 5996573836806265611LU},
    {9725556936324670558LU, 8720785837915433414LU},
    {3024888893167582466LU, 14149333590463591635LU},
    {1289996312824964092LU, 10371449134635934527LU},
    {13755244666365557408LU, 3653608304986340906LU},
    {5747954141497530190LU, 10266442700239175064LU},
    {16196733427150671378LU, 3684868432941621389LU},
    {15625862986415673580LU, 8687731441953240929LU},
    {8635856186304612784LU, 14252756868060162676LU},
    {12169551722716900624LU, 17290900593425373369LU},
    {567559355515827276LU, 5958100775146390956LU},
    {4610573991923526322LU, 1809638844438467136LU},
    {10447931623452275694LU, 11837662812629471061LU},
    {5229625023071770345LU, 13924190929706845961LU},
    {16686349724833222581LU, 8963951667527932444LU},
    {16108740411721699659LU, 4022866115189378544LU},
    {8110755210157492247LU, 9984168138447573221LU},
    {12661139481287814327LU, 11578909294866276904LU},
    {51766846955042283LU, 2155675881603366717LU},
    {4083503758206331669LU, 6221778056312006865LU},
    {10928279040257995337LU, 16934310035644577220LU},
    {4714080216279520256LU, 1221494227548080314LU},
    {17179341488819621212LU, 12513653899251471791LU},
    {15453298053196321698LU, 16580881694694081091LU},
    {8752651725131762430LU, 6575769347592413014LU},
    {11983513442803986014LU, 8178461883031629211LU},
    {670881410063791874LU, 14710243664535056526LU},
    {3554219383183780348LU, 9770283732930471778LU},
    {11408059139160207520LU, 4237313471038388855LU},
    {5061007409679717799LU, 6896854198940168747LU},
    {16807083641227480315LU, 16351584220073439038LU},
    {15069797664820122117LU, 12204247910099482834LU},
    {9088303392394939225LU, 1442490797410297287LU},
    {11608718989641838585LU, 4484082321965766410LU},
    {1015837146870593189LU, 9466665861654874655LU},
    {3892401063242229851LU, 14470654491400461811LU},
    {11026528012649050375LU, 8469270869052784870LU},
    {5952337654694875603LU, 12929254298413144028LU},
    {18273493364986202255LU, 1024290896234597065LU},
    {14232520246518617713LU, 5009496756332698917LU},
    {7675997623181692717LU, 17933260799515541552LU},
    {13095562309407845261LU, 15195660878805873405LU},
    {1927055081980523217LU, 8051070968781041640LU},
    {2495604178529201199LU, 2596724880266442756LU},
    {10205337271671354739LU, 11048342440192926993LU},
    {6182732111894073460LU, 18170021826889477453LU},
    {18072933157344643368LU, 4715851524242550872LU},
    {14038731965387102166LU, 774720425260378036LU},
    {7913131021537709706LU, 13230079766641719969LU},
    {12892469963027278378LU, 11359423866029656172LU},
    {2155482549417325430LU, 2377395646780642681LU},
    {2735271918942514568LU, 7731688079840232085LU},
    {10013522581666903252LU, 15426669532833292160LU},
    {6644463819839935133LU, 3307847689185682174LU},
    {17525597736664976321LU, 10429534774222864363LU},
    {14639798232162997567LU, 15784953386362169351LU},
    {7217453842773265507LU, 7373967176909600018LU},
    {13480359611517380803LU, 5506759633833805791LU},
    {1446030755623137695LU, 17379676667898665674LU},
    {3174256996967591777LU, 13439671747996208422LU},
    {9443968159083001405LU, 565691394506330163LU},
    {6584941284440625978LU, 7107462170888018031LU},
    {17609329488918973030LU, 16138706727409272186LU},
    {14734805441765332120LU, 10685486817974391446LU},
    {7169173779377720772LU, 2959017553195356035LU},
    {13566058357828741476LU, 229369569852210510LU},
    {1389040363257802808LU, 13723612675503710299LU},
    {3124003346739949254LU, 17709944714681530295LU},
    {9536441030923007898LU, 5232249891874892450LU},
  },
  // Table 7
  {
    {0LU, 0LU},
    {16929368311852446953LU, 16763061563385926176LU},
    {2087869273763011784LU, 6708655943729091731LU},
    {17728605485724133409LU, 13095258958108968627LU},
    {4175738547526023568LU, 13417311887458183462LU},
    {15204722840152149369LU, 5949683641155943174LU},
    {2669137177877243224LU, 16657180166817791413LU},
    {14986744634713133489LU, 1119261840996855701LU},
    {8351477095052047137LU, 8387879701206815308LU},
    {11031385744141404104LU, 11296689815132242028LU},
    {8007384887654592489LU, 2989918654678517471LU},
    {9650863162014276352LU, 13969049497543775487LU},
    {5338274355754486449LU, 14867616259926031210LU},
    {11593513347691773528LU, 2807494751503853898LU},
    {6263599111095326329LU, 10614295194410905593LU},
    {13555259816958632592LU, 8930592514597993945LU},
    {16702954190104094274LU, 16775759402413630616LU},
    {954167871611523755LU, 30720243678049976LU},
    {18101456044350651018LU, 13102826476074545163LU},
    {1280280776824720995LU, 6734232671668331051LU},
    {16014769775309184978LU, 5979837309357034942LU},
    {3805214625303063355LU, 13429450366622490526LU},
    {14035044137002042138LU, 1145402291412769069LU},
    {2897869000347727859LU, 16665309826780023565LU},
    {10676548711508972899LU, 11288488446142510804LU},
    {9141052375234879882LU, 8361671320768062708LU},
    {9859261901068650923LU, 13956984444350227015LU},
    {7071232776695283010LU, 2959833396433039463LU},
    {12527198222190652659LU, 2781846315112259570LU},
    {5127557778540075034LU, 14859980813509955026LU},
    {12763225961119150139LU, 8899945698539588449LU},
    {6616109644764202194LU, 10601665765837412673LU},
    {469041994701044126LU, 6756429431556209123LU},
    {17038082749562178935LU, 13069995222421318595LU},
    {1908335743223047510LU, 61440487356099952LU},
    {17332938759695864255LU, 16751170018522218320LU},
    {4571552883129237518LU, 16712988885200982213LU},
    {15384395184182457575LU, 1103994864643310309LU},
    {2560561553649441990LU, 13468465343336662102LU},
    {14517850249595463727LU, 5930047135732110966LU},
    {8458946602206628543LU, 3000546207811677103LU},
    {11499103643282325078LU, 13908891693616069007LU},
    {7610429250606126711LU, 8412156659535429436LU},
    {9470119885123543710LU, 11249886611989916956LU},
    {5518883217479283503LU, 10635192186801521289LU},
    {11990325773472860102LU, 8878162079078404265LU},
    {5795738000695455719LU, 14883875579850495514LU},
    {13447655894629702414LU, 2750712381247505466LU},
    {16235071360037265372LU, 13046031529622265211LU},
    {846603793710426933LU, 6750485875025579867LU},
    {18282104750469759764LU, 16723342641536125416LU},
    {1677071482972502013LU, 51620053035523016LU},
    {15617845203741845068LU, 1098612901427311709LU},
    {3624423257679729317LU, 16689589465708177021LU},
    {14142465553390566020LU, 5919666792866078926LU},
    {3365617965003361901LU, 13440071941703217902LU},
    {10567950826448415997LU, 13937352955981860663LU},
    {8672197310559082516LU, 3010998328995699991LU},
    {10255115557080150069LU, 11273217553310358436LU},
    {7250882859926291676LU, 8417465264997419396LU},
    {12347695198786114925LU, 8888050373564573201LU},
    {4731842386253668740LU, 10663091340524876849LU},
    {13232219289528404389LU, 2756587457965273730LU},
    {6724854589642882380LU, 14907765914388553890LU},
    {938083989402088252LU, 13512858863112418246LU},
    {16714420226958215125LU, 5991206045569163750LU},
    {1296232270772973556LU, 16617929148610176853LU},
    {18089858719929735965LU, 1025946803886601589LU},
    {3816671486446095020LU, 122880974712199904LU},
    {15998677820222176837LU, 16795845184536479936LU},
    {2886262502363207268LU, 6678099998365109875LU},
    {14050987555925238413LU, 12974654182115613779LU},
    {9143105766258475037LU, 14979233696692412810LU},
    {10670123215978870004LU, 2829023637317022634LU},
    {7069327922639756501LU, 10590498912414512409LU},
    {9865837034244499516LU, 8816738599509681977LU},
    {5121123107298883981LU, 8490186612963772588LU},
    {12529243540336676196LU, 11344963357471201932LU},
    {6622675604376446277LU, 2939404375555218495LU},
    {12761313032038568364LU, 13864479997821832735LU},
    {16917893204413257086LU, 6001092415623354206LU},
    {16146279913759127LU, 13540761040645129598LU},
    {17740228923932068278LU, 1031824354889712589LU},
    {2071874624402816351LU, 16641818108508705261LU},
    {15220858501212253422LU, 16824313319070858872LU},
    {4164256123157059591LU, 133327323105078360LU},
    {14970739368646766630LU, 12997978801062177515LU},
    {2680753297007920335LU, 6683416025846855883LU},
    {11037766434958567007LU, 2823640299893490962LU},
    {8349450367604839094LU, 14955836750784517938LU},
    {9644348777241754263LU, 8806361280079729025LU},
    {8009281220914417278LU, 10562103586990801825LU},
    {11591476001390911439LU, 11321007085991439412LU},
    {5344647729641876262LU, 8484236734491295252LU},
    {13557145533512286983LU, 13836646848686340263LU},
    {6257077407245547502LU, 2929590813029919367LU},
    {830598977474759330LU, 16592661048766171685LU},
    {16246686822910377547LU, 1073724654930384901LU},
    {1693207587420853866LU, 13500971750051159734LU},
    {18270621676285682307LU, 6052642099914689686LU},
    {3636046793531077426LU, 6662837455021482755LU},
    {15601849563116603355LU, 13030458468696748323LU},
    {3354142965945004026LU, 103240106071046032LU},
    {14158610831301860115LU, 16847003004571706800LU},
    {8674084018109348227LU, 10530336676684716137LU},
    {10561429024686787946LU, 8827370585652726345LU},
    {7248846515359458635LU, 14932434857706802426LU},
    {10261488822318272930LU, 2853296232428281562LU},
    {4725328657470275603LU, 2886978303252328783LU},
    {12349591081946805498LU, 13885372626056127343LU},
    {6731235930006723803LU, 8433399809696884188LU},
    {13230192118424512562LU, 11361227109198149628LU},
    {17026475258299378912LU, 1048073195030294205LU},
    {484985513280886793LU, 16585027526212779165LU},
    {17344394621118165032LU, 6021996657991399982LU},
    {1892243894235137217LU, 13488339847965173774LU},
    {15400346019859846512LU, 13022262871792387995LU},
    {4559956010552320409LU, 6636622202851481019LU},
    {14501765719852583352LU, 16834930529994838792LU},
    {2572028031610142033LU, 73161169831444776LU},
    {11505669150782136257LU, 8857521779632504049LU},
    {8457034331128474408LU, 10542476530424524497LU},
    {9463684772507337481LU, 2879438607340202082LU},
    {7612475216017160160LU, 14940561493795650114LU},
    {11988420819492251217LU, 13898076787530126807LU},
    {5525459343664976568LU, 2917691124838205431LU},
    {13449709179285764761LU, 11368787755067556164LU},
    {5789313504617647728LU, 8458982310354850660LU},
    {1876167978804176505LU, 8578973652515284876LU},
    {17363714256904508048LU, 11505844617417635244LU},
    {500153395425655473LU, 3032976557364933407LU},
    {17006106851503574616LU, 14030146264734998847LU},
    {2592464541545947113LU, 14789114223510802090LU},
    {14486806815777254144LU, 2710928015819709578LU},
    {4540704611052061473LU, 10386587233028201017LU},
    {15416630771624228808LU, 8684850636516198425LU},
    {7633342972892190040LU, 245761949424399808LU},
    {9448031078021243313LU, 16990749463358269408LU},
    {8437088145512483216LU, 6805203167529574739LU},
    {11522385153780776313LU, 13173780515803231091LU},
    {5772525004726414536LU, 13356199996730219750LU},
    {13469441993083918369LU, 5906640852074286790LU},
    {5541040399526653952LU, 16448041028124182645LU},
    {11967339823941272809LU, 928152216701491797LU},
    {18286211532516950075LU, 11511723319675274004LU},
    {1672135400865084626LU, 8602861496458547508LU},
    {16229907131980831987LU, 14040029388668032903LU},
    {850340591676155930LU, 3060882016586499495LU},
    {14138655845279513003LU, 2734253751119473202LU},
    {3370850159982972226LU, 14794429099071649810LU},
    {15622708510997505379LU, 8713315488954351265LU},
    {3620384298672214410LU, 10397036828218043521LU},
    {10242246214597767962LU, 16980373225927545176LU},
    {7265140050349279219LU, 217365575153238904LU},
    {10581874317814443986LU, 13168393861929502155LU},
    {8659133905847229243LU, 6781809571492091883LU},
    {13245351208752892554LU, 5878808751110436990LU},
    {6710858740020149859LU, 13346385352613063262LU},
    {12333506383291422274LU, 904192596017687789LU},
    {4744639501473751723LU, 16442094465703968461LU},
    {2056777115330715623LU, 3084134308848148079LU},
    {17760526957655141134LU, 14010505465048484943LU},
    {32292559827518255LU, 8634778007580707580LU},
    {16898503204144183238LU, 11490582005187041500LU},
    {2699934323502556791LU, 10448023218553829193LU},
    {14954524989887943326LU, 8672963592140645737LU},
    {4143749248805632703LU, 14836892143307858906LU},
    {15235887769703272022LU, 2685659847356674554LU},
    {8029157033524849862LU, 6821466850771684387LU},
    {9627703147248736303LU, 13116993781423808003LU},
    {8328512246314119182LU, 266654646210156720LU},
    {11053490493860283623LU, 16938323322101238416LU},
    {6241566724456600918LU, 16472313554482717957LU},
    {13578156155990598079LU, 881353446334412581LU},
    {5361506594015840670LU, 13366832051693711766LU},
    {11571672823109959031LU, 5846478547658286006LU},
    {18106708783932012965LU, 13979863304147155703LU},
    {1276420283498909004LU, 3071499158891981015LU},
    {16698900735209678189LU, 11464929427859484260LU},
    {959085811475059076LU, 8627145635874995268LU},
    {14030058235038777397LU, 8660894364759200721LU},
    {2901995370227692764LU, 10417941001698591217LU},
    {16018562441828834557LU, 2677463100272052034LU},
    {3800034656823748628LU, 14810678008166339938LU},
    {9845321368111221380LU, 13143139506612988091LU},
    {7084348407907434093LU, 6829590171882535579LU},
    {10689295459283752524LU, 16968473468982590504LU},
    {9126882595684344485LU, 278795582616088072LU},
    {12777468103766618900LU, 888917407580799389LU},
    {6603294387300239357LU, 16497892704196006845LU},
    {12514154814491095004LU, 5859181626059838734LU},
    {5141429932802726709LU, 13397545921052772142LU},
    {1661197954949518661LU, 14738578023822791754LU},
    {18301767373812081068LU, 2606362844761507434LU},
    {861410975868766605LU, 10488916065350779097LU},
    {16214483128285134180LU, 8733119850190230265LU},
    {3386415174841707733LU, 8555199426392767852LU},
    {14127726474389002300LU, 11391986238389710668LU},
    {3604969470687604765LU, 3144571938258364927LU},
    {15633786968067687668LU, 14051679614486608863LU},
    {7272093587062154852LU, 13325674910042965510LU},
    {10239664232904020621LU, 5786022809875321894LU},
    {8652031282687294124LU, 16570891144158466709LU},
    {10584306112366677573LU, 960949104058564789LU},
    {6708285931890008052LU, 206480212142092064LU},
    {13252312820490824477LU, 16897447552884882688LU},
    {4747080471737074492LU, 6900780862257331123LU},
    {12326411833009059797LU, 13215289793580509587LU},
    {17348168036218696455LU, 2613929279659880658LU},
    {1887043577039669230LU, 14764155799529972466LU},
    {17021505291436502991LU, 8745821004600157249LU},
    {489126716669238054LU, 10519632958078908001LU},
    {14497693030718917271LU, 11418125641704053236LU},
    {2576925639937392254LU, 8563330169024269268LU},
    {15405614711721465439LU, 14081836632961813863LU},
    {4556110367914762934LU, 3156707102447820615LU},
    {9450657314940551206LU, 5773956606504657566LU},
    {7626362223115547855LU, 13295590768822825150LU},
    {11519892061337836782LU, 952750982267401741LU},
    {8444198739980740615LU, 16544679483100931117LU},
    {13462471860013447606LU, 16866799619393768376LU},
    {5775158560722980191LU, 193851934421522840LU},
    {11974461037263185278LU, 13189644638205632299LU},
    {5538554624013488535LU, 6893142167976316171LU},
    {1265403230183648475LU, 10469279628746878377LU},
    {18122114640585578546LU, 8784273237383036809LU},
    {969971026561773587LU, 14723310978716006714LU},
    {16683361939834438906LU, 2662171631763761946LU},
    {2917393151755539787LU, 3132680461946635407LU},
    {14019032008260575650LU, 14113120032888034991LU},
    {3784487788470274435LU, 8529935622220795932LU},
    {16029438481305124202LU, 11439759795103760956LU},
    {7091469168982695930LU, 16514108842654875621LU},
    {9842836250734701331LU, 977208355364531653LU},
    {9119912021104640818LU, 13273244405702962038LU},
    {10691929662679545819LU, 5806919870952175958LU},
    {6600801194797999722LU, 6853977727599810243LU},
    {12784579691378938499LU, 13239566683021624547LU},
    {5144056063220284066LU, 146322339662889552LU},
    {12507175064300965451LU, 16908075174972149872LU},
    {17745112579367013017LU, 8756442511196047665LU},
    {2067854916277550704LU, 10459462510475418385LU},
    {16914068662256948817LU, 2638208987139497378LU},
    {21362539256111800LU, 14717366340590374786LU},
    {14965595471589749513LU, 14102736373566562327LU},
    {2684509328676030432LU, 3104290410188845623LU},
    {15224950432034320321LU, 11434378913881748612LU},
    {4159304088232516392LU, 8506535153885783716LU},
    {9630145108374452664LU, 1000536014593989501LU},
    {8022062385464855889LU, 16519420694908586333LU},
    {11050918687329953136LU, 5835382249676410862LU},
    {8335473749537001881LU, 13283695374960844238LU},
    {13571054188685574184LU, 13245438513615090267LU},
    {6243998069043918017LU, 6877871343829868667LU},
    {11578627009235295456LU, 16917964620709701320LU},
    {5358924168799627273LU, 174220377434125544LU},
  },

};

}  // namespace detail
}  // namespace folly
